/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.lock.ReadWriteLock;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.model.ChunkModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.MutableChunkModel;
import com.waxmonster.model.TimecodeChunk;
import com.waxmonster.model.impl.DefaultChunkModel;
import com.waxmonster.waxlab.LineConfig;
import com.waxmonster.waxlab.LineWidget;
import com.waxmonster.waxlab.MidiLine;
import com.waxmonster.waxlab.ScratchLineConfig;
import com.waxmonster.waxlab.TimecodeLine;
import com.waxmonster.waxlab.TimecodeLineConfig;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.impl.AbstractScratchLine;
import com.waxmonster.waxlab.impl.FeatureTimecodeLine;
import com.waxmonster.waxlab.impl.ScratchManager;
import com.waxmonster.waxlab.impl.WaxLabScratchDeck;
import java.util.LinkedList;

public class DefaultTimecodeLine
extends AbstractScratchLine
implements TimecodeLine {
    public static final TimecodeChunk[] NO_TIMECODE_CHUNKS = new TimecodeChunk[0];
    public static final int DEFAULT_PLAYBACK_FRAME_TYPE = 2;
    private TimecodeLineConfig timecodeLineConfig;
    private FeatureTimecodeLine featureTimecodeLine;
    private DefaultChunkModel timecodeChunkModel = this.createDefaultChunkModel();
    private int cuePointCount = -1;
    private int beatSliceCount = -1;

    public DefaultTimecodeLine(ReadWriteLock lock) {
        super(lock);
        this.initLineFeatures();
        this.initLineWidgets();
        TimecodeLineConfig tlc = new TimecodeLineConfig();
        tlc.setPlaybackFrameType(2);
        this.setTimecodeLineConfig(tlc);
    }

    public boolean isPlaybackSupported() {
        return false;
    }

    public boolean isRecordingSupported() {
        return true;
    }

    public synchronized TimecodeLineConfig getTimecodeLineConfig() {
        return this.timecodeLineConfig;
    }

    public synchronized void setTimecodeLineConfig(TimecodeLineConfig timecodeLineConfig) {
        ScratchManager scratchManager;
        WaxLabScratchDeck scratchDeck;
        this.timecodeLineConfig = timecodeLineConfig;
        this.setLineDirty();
        int cuePointCount = timecodeLineConfig.getCuePointCount();
        int beatSliceCount = timecodeLineConfig.getBeatSliceCount();
        if (cuePointCount != this.cuePointCount || beatSliceCount != this.beatSliceCount) {
            this.cuePointCount = cuePointCount;
            this.beatSliceCount = beatSliceCount;
            this.refreshMidiActions();
            this.refreshMidiEvents();
        }
        if ((scratchDeck = this.scratchDeck) != null) {
            boolean force = scratchDeck.getScratchPlayer() == null;
            scratchDeck.applyScratchLineConfig((ScratchLineConfig)timecodeLineConfig, force);
        }
        if ((scratchManager = this.scratchManager) != null) {
            int playFrameType = -1;
            boolean audioFaderEnabled = false;
            boolean audioPreFaderEnabled = false;
            boolean audioPostFaderEnabled = false;
            WaxLabPortInfo[] audioPreFaderPorts = null;
            WaxLabPortInfo[] audioPostFaderPorts = null;
            WaxLabPortInfo[] audioTimecodePorts = null;
            WaxLabPortInfo[] audioLiveFeedPorts = null;
            WaxLabPortInfo midiTimecodePort = null;
            MidiLine faderMidiLine = null;
            WaxLabPortInfo midiInputPort = null;
            WaxLabPortInfo midiOutputPort = null;
            if (timecodeLineConfig != null) {
                playFrameType = timecodeLineConfig.getPlaybackFrameType();
                audioFaderEnabled = timecodeLineConfig.isAudioFaderEnabled();
                audioPreFaderEnabled = timecodeLineConfig.isPreFaderEnabled();
                audioPostFaderEnabled = timecodeLineConfig.isPostFaderEnabled();
                audioPreFaderPorts = timecodeLineConfig.getPreFaderPorts();
                audioPostFaderPorts = timecodeLineConfig.getPostFaderPorts();
                audioTimecodePorts = timecodeLineConfig.getRecordingPorts();
                audioLiveFeedPorts = timecodeLineConfig.getLiveFeedPorts();
                midiTimecodePort = timecodeLineConfig.getTimecodeMidiInputPort();
                faderMidiLine = timecodeLineConfig.getFaderMidiLine();
                midiInputPort = timecodeLineConfig.getMidiInputPort();
                midiOutputPort = timecodeLineConfig.getMidiOutputPort();
            }
            scratchManager.setAudioFrameType(playFrameType);
            scratchManager.setAudioFaderEnabled(audioFaderEnabled);
            scratchManager.setAudioPreFaderEnabled(audioPreFaderEnabled);
            scratchManager.setAudioPostFaderEnabled(audioPostFaderEnabled);
            scratchManager.setAudioPreFaderPorts(audioPreFaderPorts);
            scratchManager.setAudioPostFaderPorts(audioPostFaderPorts);
            scratchManager.setAudioTimecodePorts(audioTimecodePorts);
            scratchManager.setAudioLiveFeedPorts(audioLiveFeedPorts);
            scratchManager.setMidiTimecodePort(midiTimecodePort);
            scratchManager.setFaderMidiLine(faderMidiLine);
            scratchManager.setMidiInputPort(midiInputPort);
            scratchManager.setMidiOutputPort(midiOutputPort);
        }
        if (this.featureTimecodeLine != null) {
            boolean scratcherEnabled = false;
            boolean playerEnabled = false;
            boolean recEnabled = false;
            if (timecodeLineConfig != null) {
                scratcherEnabled = timecodeLineConfig.isScratchingEnabled();
                playerEnabled = timecodeLineConfig.isPlaybackEnabled();
                recEnabled = timecodeLineConfig.isRecordingEnabled();
            }
            this.featureTimecodeLine.getWidgetTimecodeScratcher().setSelected(scratcherEnabled);
            this.featureTimecodeLine.getWidgetTimecodePlayer().setSelected(playerEnabled);
            this.featureTimecodeLine.getWidgetTimecodeRecorder().setSelected(recEnabled);
        }
    }

    public synchronized LineConfig getLineConfig() {
        return this.timecodeLineConfig;
    }

    public synchronized ScratchLineConfig getScratchLineConfig() {
        return this.timecodeLineConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimecodeChunk[] getTimecodeChunks() {
        DefaultChunkModel model = this.timecodeChunkModel;
        if (model == null) {
            return NO_TIMECODE_CHUNKS;
        }
        try {
            LineChunk chunk;
            this.lock.lockRead();
            int num = 0;
            int n = model.getChunkCount();
            for (int i = 0; i < n; ++i) {
                chunk = model.getChunkAt(i);
                if (!(chunk instanceof TimecodeChunk)) continue;
                ++num;
            }
            if (num < 1) {
                TimecodeChunk[] i = NO_TIMECODE_CHUNKS;
                return i;
            }
            TimecodeChunk[] chunks = new TimecodeChunk[num];
            int idx = 0;
            for (int i = 0; i < n; ++i) {
                chunk = model.getChunkAt(i);
                if (!(chunk instanceof TimecodeChunk)) continue;
                chunks[idx++] = (TimecodeChunk)chunk;
            }
            TimecodeChunk[] timecodeChunkArray = chunks;
            return timecodeChunkArray;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    protected void refreshMidiActions() {
        this.setMidiActions(this.createMidiActions(this.cuePointCount, this.beatSliceCount));
    }

    protected MidiAction[] createMidiActions(int cuePointCount, int beatSliceCount) {
        String name;
        int i;
        LinkedList<Object> actions = new LinkedList<Object>();
        actions.add((Object)new AbstractScratchLine.PostFaderVolumeControlAction("PostFaderVolumeControl"));
        actions.add((Object)new AbstractScratchLine.PreFaderVolumeControlAction("PreFaderVolumeControl"));
        actions.add((Object)new AbstractScratchLine.PitchFactorControlAction("PitchFactorControl"));
        actions.add((Object)new AbstractScratchLine.PitchTuneControlAction("PitchTuneControl"));
        AbstractScratchLine.ShiftAction shiftScratchModeAction = new AbstractScratchLine.ShiftAction("ShiftScratchMode");
        actions.add((Object)shiftScratchModeAction);
        actions.add((Object)new AbstractScratchLine.ScratchModePrevAction("ScratchModePrev"));
        actions.add((Object)new AbstractScratchLine.ScratchModeNextAction("ScratchModeNext", shiftScratchModeAction));
        actions.add((Object)new AbstractScratchLine.ScratchModeAction("ScratchMode-Absolute", "Absolute"));
        actions.add((Object)new AbstractScratchLine.ScratchModeAction("ScratchMode-Relative", "Relative"));
        actions.add((Object)new AbstractScratchLine.ScratchModeAction("ScratchMode-Splatter", "Splatter"));
        actions.add((Object)new AbstractScratchLine.ScratchModeAction("ScratchMode-Ultimate", "Ultimate"));
        actions.add((Object)new AbstractScratchLine.ScratchModeAction("ScratchMode-Internal", "Internal"));
        AbstractScratchLine.ShiftAction shiftPitchModeAction = new AbstractScratchLine.ShiftAction("ShiftPitchMode");
        actions.add((Object)shiftPitchModeAction);
        actions.add((Object)new AbstractScratchLine.PitchModePrevAction("PitchModePrev"));
        actions.add((Object)new AbstractScratchLine.PitchModeNextAction("PitchModeNext", shiftPitchModeAction));
        actions.add((Object)new AbstractScratchLine.PitchModeAction("PitchMode-Normal", "Normal"));
        actions.add((Object)new AbstractScratchLine.PitchModeAction("PitchMode-Custom", "Custom"));
        actions.add((Object)new AbstractScratchLine.PitchModeAction("PitchMode-BPM", "BPM"));
        actions.add((Object)new AbstractScratchLine.PitchModeAction("PitchMode-Deck", "Deck"));
        actions.add((Object)new AbstractScratchLine.ToggleSlipModeAction("ToggleSlipMode"));
        for (i = 0; i < cuePointCount; ++i) {
            name = "JumpToCuePoint-" + (i + 1);
            actions.add((Object)new AbstractScratchLine.JumpCuePointAction(name, i));
        }
        for (i = 0; i < cuePointCount; ++i) {
            name = "SetCuePoint-" + (i + 1);
            actions.add((Object)new AbstractScratchLine.SetCuePointAction(name, i));
        }
        for (i = 0; i < cuePointCount; ++i) {
            name = "RemoveCuePoint-" + (i + 1);
            actions.add((Object)new AbstractScratchLine.RemoveCuePointAction(name, i));
        }
        for (i = 0; i < cuePointCount; ++i) {
            name = "JumpOrSetCuePoint-" + (i + 1);
            actions.add((Object)new AbstractScratchLine.JumpOrSetCuePointAction(name, i));
        }
        AbstractScratchLine.ShiftAction shiftRemoveCuePointAction = new AbstractScratchLine.ShiftAction("ShiftRemoveCuePoint");
        actions.add((Object)shiftRemoveCuePointAction);
        for (int i2 = 0; i2 < cuePointCount; ++i2) {
            String name2 = "JumpOrSetOrRemoveCuePoint-" + (i2 + 1);
            actions.add((Object)new AbstractScratchLine.JumpOrSetOrRemoveCuePointAction(name2, i2, shiftRemoveCuePointAction));
        }
        actions.add((Object)new AbstractScratchLine.JumpLiveFeedHeadAction("JumpLiveFeedHead"));
        AbstractScratchLine.ShiftAction shiftInstantDoubleAction = new AbstractScratchLine.ShiftAction("ShiftInstantDouble");
        actions.add((Object)shiftInstantDoubleAction);
        AbstractScratchLine.ShiftAction shiftLiveFeedAction = new AbstractScratchLine.ShiftAction("ShiftLiveFeed");
        actions.add((Object)shiftLiveFeedAction);
        actions.add((Object)new AbstractScratchLine.SkipPrevEntryAction("SkipPrev"));
        actions.add((Object)new AbstractScratchLine.SkipNextEntryAction("SkipNext", shiftInstantDoubleAction, shiftLiveFeedAction));
        actions.add((Object)new AbstractScratchLine.InstantDoubleAction("InstantDouble", false));
        actions.add((Object)new AbstractScratchLine.InstantDoubleAction("DoubleClickInstantDouble", true));
        actions.add((Object)new AbstractScratchLine.BeatJumpForwardAction("BeatJumpForward"));
        actions.add((Object)new AbstractScratchLine.BeatJumpBackwardAction("BeatJumpBackward"));
        actions.add((Object)new AbstractScratchLine.BeatJumpDoubleAction("SetBeatJumpDouble"));
        actions.add((Object)new AbstractScratchLine.BeatJumpHalfAction("SetBeatJumpHalf"));
        actions.add((Object)new AbstractScratchLine.BeatJumpControlAction("SetBeatJump-1d/32", 0.03125));
        actions.add((Object)new AbstractScratchLine.BeatJumpControlAction("SetBeatJump-1d/16", 0.0625));
        actions.add((Object)new AbstractScratchLine.BeatJumpControlAction("SetBeatJump-1d/8", 0.125));
        actions.add((Object)new AbstractScratchLine.BeatJumpControlAction("SetBeatJump-1d/4", 0.25));
        actions.add((Object)new AbstractScratchLine.BeatJumpControlAction("SetBeatJump-1d/2", 0.5));
        actions.add((Object)new AbstractScratchLine.BeatJumpControlAction("SetBeatJump-1d", 1.0));
        actions.add((Object)new AbstractScratchLine.BeatJumpControlAction("SetBeatJump-2d", 2.0));
        actions.add((Object)new AbstractScratchLine.BeatJumpControlAction("SetBeatJump-4d", 4.0));
        actions.add((Object)new AbstractScratchLine.BeatJumpControlAction("SetBeatJump-8d", 8.0));
        actions.add((Object)new AbstractScratchLine.BeatJumpControlAction("SetBeatJump-16d", 16.0));
        actions.add((Object)new AbstractScratchLine.BeatJumpControlAction("SetBeatJump-32d", 32.0));
        actions.add((Object)new AbstractScratchLine.BeatSlicerStartAction("SlicerStart"));
        actions.add((Object)new AbstractScratchLine.BeatSlicerStopAction("SlicerStop"));
        actions.add((Object)new AbstractScratchLine.BeatSlicerToggleAction("SlicerToggle"));
        actions.add((Object)new AbstractScratchLine.BeatSlicerLoopModeToggleAction("SlicerLoopModeToggle"));
        for (int i3 = 0; i3 < beatSliceCount; ++i3) {
            actions.add((Object)new AbstractScratchLine.BeatSlicerJumpAction("SlicerJump-" + (i3 + 1), i3));
        }
        actions.add((Object)new AbstractScratchLine.BeatSliceDoubleAction("SetSliceLengthDouble"));
        actions.add((Object)new AbstractScratchLine.BeatSliceHalfAction("SetSliceLengthHalf"));
        actions.add((Object)new AbstractScratchLine.BeatSliceControlAction("SetSliceLength-1d", 1.0));
        actions.add((Object)new AbstractScratchLine.BeatSliceControlAction("SetSliceLength-1d/2", 0.5));
        actions.add((Object)new AbstractScratchLine.BeatSliceControlAction("SetSliceLength-1d/4", 0.25));
        actions.add((Object)new AbstractScratchLine.BeatSliceControlAction("SetSliceLength-1d/8", 0.125));
        int loopRollCount = 5;
        for (int i4 = 0; i4 < loopRollCount; ++i4) {
            actions.add((Object)new AbstractScratchLine.LoopRollAction("LoopRoll-" + (i4 + 1), i4));
        }
        int autoLoopCount = 6;
        for (int i5 = 0; i5 < autoLoopCount; ++i5) {
            actions.add((Object)new AbstractScratchLine.AutoLoopAction("AutoLoop-" + (i5 + 1), i5));
        }
        AbstractScratchLine.ShiftAction shiftCensorGoofyAction = new AbstractScratchLine.ShiftAction("ShiftCensorGoofy");
        actions.add((Object)shiftCensorGoofyAction);
        actions.add((Object)new AbstractScratchLine.CensorAction("Censor", shiftCensorGoofyAction));
        actions.add((Object)new AbstractScratchLine.SpinForwardAction("SpinForward"));
        actions.add((Object)new AbstractScratchLine.SpinBackwardAction("SpinBackward"));
        actions.add((Object)new AbstractScratchLine.NavigateCrateTree("NavigateCrateTree"));
        actions.add((Object)new AbstractScratchLine.NavigatePlayList("NavigatePlayList"));
        actions.add((Object)new AbstractScratchLine.NavigateMoveAction("NavigateMove"));
        actions.add((Object)new AbstractScratchLine.NavigatePushAction("NavigatePush"));
        actions.add((Object)new AbstractScratchLine.NavigateBackAction("NavigateBack"));
        actions.add((Object)new AbstractScratchLine.ToggleShuffleModeAction("ToggleShuffleMode"));
        actions.add((Object)new AbstractScratchLine.ShuffleModeOnAction("ShuffleModeOn"));
        actions.add((Object)new AbstractScratchLine.ShuffleModeOffAction("ShuffleModeOff"));
        actions.add((Object)new AbstractScratchLine.RefreshDeckLightingAction("RefreshDeckLighting"));
        return actions.toArray(new MidiAction[actions.size()]);
    }

    protected void refreshMidiEvents() {
        this.setMidiEvents(this.createMidiEvents(this.cuePointCount, this.beatSliceCount));
    }

    protected String[] createMidiEvents(int cuePointCount, int beatSliceCount) {
        String name;
        int i;
        LinkedList<String> eventList = new LinkedList<String>();
        int loopRollCount = 5;
        int autoLoopCount = 6;
        eventList.add("DeckStarted");
        eventList.add("DeckStopped");
        eventList.add("BeatJumpEnabled");
        eventList.add("BeatJumpDisabled");
        eventList.add("CensorActivated");
        eventList.add("CensorDeactivated");
        eventList.add("PitchModeActivated-Normal");
        eventList.add("PitchModeDeactivated-Normal");
        eventList.add("PitchModeActivated-Custom");
        eventList.add("PitchModeDeactivated-Custom");
        eventList.add("PitchModeActivated-BPM");
        eventList.add("PitchModeDeactivated-BPM");
        eventList.add("PitchModeActivated-Deck");
        eventList.add("PitchModeDeactivated-Deck");
        eventList.add("ScratchModeActivated-Internal");
        eventList.add("ScratchModeDeactivated-Internal");
        eventList.add("ScratchModeActivated-Relative");
        eventList.add("ScratchModeDeactivated-Relative");
        eventList.add("ScratchModeActivated-Absolute");
        eventList.add("ScratchModeDeactivated-Absolute");
        eventList.add("ScratchModeActivated-Splatter");
        eventList.add("ScratchModeDeactivated-Splatter");
        eventList.add("ScratchModeActivated-Ultimate");
        eventList.add("ScratchModeDeactivated-Ultimate");
        eventList.add("SlipModeEnabled");
        eventList.add("SlipModeDisabled");
        for (i = 0; i < cuePointCount; ++i) {
            name = "CuePointAdded-" + (i + 1);
            eventList.add(name);
        }
        for (i = 0; i < cuePointCount; ++i) {
            name = "CuePointRemoved-" + (i + 1);
            eventList.add(name);
        }
        for (i = 0; i < loopRollCount; ++i) {
            name = "LoopRollStarted-" + (i + 1);
            eventList.add(name);
        }
        for (i = 0; i < loopRollCount; ++i) {
            name = "LoopRollStopped-" + (i + 1);
            eventList.add(name);
        }
        for (i = 0; i < autoLoopCount; ++i) {
            name = "AutoLoopStarted-" + (i + 1);
            eventList.add(name);
        }
        for (i = 0; i < autoLoopCount; ++i) {
            name = "AutoLoopStopped-" + (i + 1);
            eventList.add(name);
        }
        eventList.add("BeatSlicerStarted");
        eventList.add("BeatSlicerStopped");
        eventList.add("BeatSlicerLoopActivated");
        eventList.add("BeatSlicerLoopDeactivated");
        for (i = 0; i < beatSliceCount; ++i) {
            name = "BeatSliceActivated-" + (i + 1);
            eventList.add(name);
        }
        for (i = 0; i < beatSliceCount; ++i) {
            name = "BeatSliceEntered-" + (i + 1);
            eventList.add(name);
        }
        for (i = 0; i < beatSliceCount; ++i) {
            name = "BeatSliceExited-" + (i + 1);
            eventList.add(name);
        }
        return eventList.toArray(new String[eventList.size()]);
    }

    public synchronized FeatureTimecodeLine getFeatureTimecodeLine() {
        if (this.featureTimecodeLine == null) {
            this.setFeatureTimecodeLine(this.createFeatureTimecodeLine());
        }
        return this.featureTimecodeLine;
    }

    protected synchronized void setFeatureTimecodeLine(FeatureTimecodeLine featureTimecodeLine) {
        this.featureTimecodeLine = featureTimecodeLine;
    }

    protected FeatureTimecodeLine createFeatureTimecodeLine() {
        ScratchManager scratchManager = this.getScratchManager();
        FeatureTimecodeLine feature = new FeatureTimecodeLine(this, scratchManager);
        scratchManager.setLineFeature(feature);
        feature.setScratchManager(scratchManager);
        return feature;
    }

    protected void initLineFeatures() {
        this.addLineFeature(this.getFeatureTimecodeLine());
    }

    protected void initLineWidgets() {
        this.addLineWidget(this.featureTimecodeLine.getWidgetTimecodeScratcher());
        this.addLineWidget(this.featureTimecodeLine.getWidgetTimecodePlayer());
        this.addLineWidget(this.featureTimecodeLine.getWidgetTimecodeRecorder());
    }

    @Override
    protected synchronized void fireWidgetChanged(LineWidget widget) {
        super.fireWidgetChanged(widget);
        TimecodeLineConfig config = this.getTimecodeLineConfig();
        if (config != null && widget != null) {
            if (widget == this.featureTimecodeLine.getWidgetTimecodeScratcher()) {
                config.setScratchingEnabled(widget.isSelected());
            }
            if (widget == this.featureTimecodeLine.getWidgetTimecodePlayer()) {
                config.setPlaybackEnabled(widget.isSelected());
            }
            if (widget == this.featureTimecodeLine.getWidgetTimecodeRecorder()) {
                config.setRecordingEnabled(widget.isSelected());
            }
        }
    }

    public DefaultChunkModel getTimecodeChunkModel() {
        return this.timecodeChunkModel;
    }

    public ChunkModel getChunkModel() {
        return this.timecodeChunkModel;
    }

    public MutableChunkModel getMutableChunkModel() {
        return this.timecodeChunkModel;
    }

    @Override
    public boolean isLineDirty() {
        if (super.isLineDirty()) {
            return true;
        }
        DefaultChunkModel model = this.timecodeChunkModel;
        return model != null && model.isDirty();
    }

    @Override
    public void clearLineDirty() {
        super.clearLineDirty();
        DefaultChunkModel model = this.timecodeChunkModel;
        if (model != null) {
            model.clearDirty();
        }
    }

    public long computeTimeLength() {
        DefaultChunkModel model = this.timecodeChunkModel;
        return model == null ? 0L : model.computeTimeLength();
    }
}

