/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.sound.DefaultSampleCursor;
import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.spacekiller.util.sound.FloatArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleCursor;
import com.spacekiller.util.sound.SampleModel;
import com.spacekiller.util.thread.ThreadPool;
import com.waxmonster.audio.AudioException;
import com.waxmonster.model.AudioModel;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.impl.DefaultChunkModel;
import com.waxmonster.model.impl.MergedAudioModel;
import com.waxmonster.model.impl.RealAudioModel;
import com.waxmonster.studio.Port;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.WaxLabPreferences;
import com.waxmonster.waxlab.impl.AbstractLine;
import com.waxmonster.waxlab.impl.AbstractLineWidget;
import com.waxmonster.waxlab.impl.CommonLineFeature;
import com.waxmonster.waxlab.impl.DefaultAudioLine;
import com.waxmonster.waxlab.impl.SyncFeature;
import com.waxmonster.waxlab.impl.SyncHandler;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabAudioOutputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import com.waxmonster.waxlab.proc.WaxLabAudioPlayer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class FeatureAudioLinePlayer
extends CommonLineFeature {
    private static final Logger logger = Platform.getLogger(FeatureAudioLinePlayer.class);
    public static final String NAME = "AudioLinePlayer";
    private final DefaultAudioLine audioLine;
    private final WidgetAudioPlayer widgetAudioPlayer;
    private int playbackFrameType;
    private WaxLabPortInfo[] playbackPorts;
    private SyncFeature syncFeatureOld;
    private List playerInfoList;
    private PlayerInfo playerInfoActive;

    public FeatureAudioLinePlayer(DefaultAudioLine audioLine) {
        super(audioLine, NAME);
        this.audioLine = audioLine;
        this.widgetAudioPlayer = new WidgetAudioPlayer(audioLine);
        this.playerInfoList = new ArrayList();
    }

    public final DefaultAudioLine getAudioLine() {
        return this.audioLine;
    }

    public final WidgetAudioPlayer getWidgetAudioPlayer() {
        return this.widgetAudioPlayer;
    }

    protected synchronized void checkEnable() {
        this.setEnabled(this.widgetAudioPlayer.isSelected());
    }

    @Override
    protected void fireFeatureSynced() {
        super.fireFeatureSynced();
        boolean active = this.isActive();
        this.widgetAudioPlayer.setActive(active);
    }

    public synchronized WaxLabPortInfo[] getPlaybackPorts() {
        return this.playbackPorts;
    }

    public synchronized void setPlaybackPorts(WaxLabPortInfo[] playbackPorts) {
        if (FeatureAudioLinePlayer.equalsPortArray(this.playbackPorts, playbackPorts)) {
            return;
        }
        this.playbackPorts = playbackPorts;
        this.invalidate();
    }

    public synchronized int getPlaybackFrameType() {
        return this.playbackFrameType;
    }

    public synchronized void setPlaybackFrameType(int playbackFrameType) {
        if (this.playbackFrameType == playbackFrameType) {
            return;
        }
        this.playbackFrameType = playbackFrameType;
        this.invalidate();
    }

    @Override
    protected synchronized void mediateFeature(SyncFeature syncFeature) {
        SyncMediator mediator = this.getMediator();
        if (mediator == null) {
            return;
        }
        SyncFeature syncFeatureOld = this.syncFeatureOld;
        Level debug = Level.FINE;
        if (!logger.isLoggable(debug)) {
            debug = null;
        }
        try {
            WaxLabAudioSyncGroup audioSyncGroup;
            boolean audioPlayerPortsChanged;
            int playbackFrameType = this.getPlaybackFrameType();
            WaxLabPortInfo[] playbackPortInfos = this.getPlaybackPorts();
            WaxLabAudioOutputPort[] playbackPorts = CommonLineFeature.validateAudioOutputPorts(playbackFrameType, playbackPortInfos);
            WaxLabAudioSyncGroup playbackSyncGroup = CommonLineFeature.validateAudioSyncGroup(playbackPorts);
            if (playbackSyncGroup == null) {
                playbackPorts = null;
            }
            int playbackPortCount = playbackPorts == null ? 0 : playbackPorts.length;
            float audioOutRate = CommonLineFeature.computeAudioOutputSampleRate(playbackPorts, playbackPortCount);
            int audioOutChannels = 0;
            if (audioOutRate > 0.0f) {
                audioOutChannels = CommonLineFeature.computeAudioOutputChannels(playbackPorts, playbackPortCount);
            }
            int audioOutFrames = 0;
            WaxLabAudioSyncGroup audioOutGroup = null;
            if (audioOutChannels > 0 && (audioOutFrames = CommonLineFeature.computeAudioOutputBufferFrames(playbackSyncGroup, playbackPorts, playbackPortCount)) > 0) {
                audioOutGroup = playbackSyncGroup;
            }
            if (debug != null) {
                logger.log(debug, "mediate: " + this.audioLine + ", outChannels=" + audioOutChannels + ", outRate=" + audioOutRate + ", outFrames=" + audioOutFrames);
            }
            boolean enablePlayer = this.isEnabled();
            if (playbackPortCount > 0) {
                for (int i = 0; i < playbackPortCount; ++i) {
                    SampleBuffer sb;
                    WaxLabAudioOutputPort audioOutPort = playbackPorts[i];
                    if (audioOutPort == null) continue;
                    if (playbackPortCount == 1) {
                        if (audioOutPort.getChannels() != audioOutChannels) {
                            if (logger.isLoggable(Level.WARNING)) {
                                logger.warning("Invalid audio output channels: " + (Object)((Object)audioOutPort) + " -> " + audioOutPort.getChannels() + " != " + audioOutChannels);
                            }
                            playbackPortCount = 0;
                            break;
                        }
                    } else if (audioOutPort.getChannels() != 1) {
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.warning("Invalid audio output channels: " + (Object)((Object)audioOutPort) + " -> " + audioOutPort.getChannels() + " != 1");
                        }
                        playbackPortCount = 0;
                        break;
                    }
                    if ((sb = audioOutPort.getBuffer()) == null || sb.getFrameRate() == audioOutRate) continue;
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.warning("Invalid audio output rate: " + (Object)((Object)audioOutPort) + " -> " + sb.getFrameRate() + " != " + audioOutRate);
                    }
                    playbackPortCount = 0;
                    break;
                }
            }
            if (playbackPortCount < 1) {
                enablePlayer = false;
            }
            WaxLabAudioOutputPort[] audioPlayerPortsOld = null;
            int audioOutChannelsOld = -1;
            float audioOutRateOld = -1.0f;
            MergedAudioModel mergedAudioModelOld = null;
            SampleCursor audioPlayerCursorOld = null;
            SampleBuffer audioPlayerOutputOld = null;
            WaxLabAudioPlayer audioPlayerOld = null;
            SyncHandler.AudioProcHandler audioPlayHandlerOld = null;
            SyncHandler.AudioOutHandler audioOutHandlerOld = null;
            PlayerInfo prevInfo = this.playerInfoActive;
            if (prevInfo != null) {
                audioPlayerPortsOld = prevInfo.audioPlayerPorts;
                audioOutChannelsOld = prevInfo.audioOutChannels;
                audioOutRateOld = prevInfo.audioOutRate;
                mergedAudioModelOld = prevInfo.mergedAudioModel;
                audioPlayerCursorOld = prevInfo.audioPlayerCursor;
                audioPlayerOutputOld = prevInfo.audioPlayerOutput;
                audioPlayerOld = prevInfo.audioPlayer;
                audioPlayHandlerOld = prevInfo.audioPlayHandler;
                audioOutHandlerOld = prevInfo.audioOutHandler;
            }
            MergedAudioModel mergedAudioModel = null;
            SampleCursor audioPlayerCursor = null;
            DoubleArraySampleBuffer audioPlayerOutput = null;
            WaxLabAudioPlayer audioPlayer = null;
            SyncHandler.AudioProcHandler audioPlayHandler = null;
            SyncHandler.AudioOutHandler audioOutHandler = null;
            if (enablePlayer && playbackPortCount > 0 && audioOutFrames > 0) {
                if (mergedAudioModelOld == null || audioOutChannels != audioOutChannelsOld || audioOutRate != audioOutRateOld) {
                    DefaultChunkModel chunkModel;
                    if (debug != null) {
                        logger.log(debug, " - creating MergedAudioModel: line=" + this.audioLine);
                    }
                    if ((chunkModel = this.audioLine.getAudioChunkModel()) != null) {
                        WaxLabPreferences waxLabPreferences = mediator.getWaxLabPreferences();
                        int maxParts = waxLabPreferences.getMergedAudioModelParts();
                        boolean fair = waxLabPreferences.isMergedAudioModelFair();
                        ReadWriteLock lock = mediator.getLockFactory().createReadWriteLock(fair);
                        mergedAudioModel = new MergedAudioModel(chunkModel, lock, audioOutRate, audioOutChannels, maxParts);
                        mergedAudioModel.start();
                    }
                    if (debug != null) {
                        logger.log(debug, " - created MergedAudioModel: " + mergedAudioModel);
                    }
                } else {
                    mergedAudioModel = mergedAudioModelOld;
                    if (debug != null) {
                        logger.log(debug, " - keeping MergedAudioModel: " + mergedAudioModel);
                    }
                }
            }
            if (audioOutFrames > 0 && enablePlayer && playbackPortCount > 0) {
                audioPlayerOutput = playbackSyncGroup.createPlayBuffer(audioPlayerOutputOld, audioOutChannels, audioOutFrames, audioOutRate);
            }
            if (enablePlayer && mergedAudioModel != null && audioPlayerOutput != null) {
                if (audioPlayerCursorOld == null || mergedAudioModel != mergedAudioModelOld) {
                    DefaultSampleCursor sampleCursor;
                    if (debug != null) {
                        logger.log(debug, " - creating AudioPlayerCursor: model=" + mergedAudioModel);
                    }
                    long sampleIndex = 0L;
                    MergedAudioModel audioModel = mergedAudioModel;
                    boolean batchMode = mediator.isBatchMode();
                    if (batchMode) {
                        sampleCursor = new DefaultSampleCursor((SampleModel)audioModel, sampleIndex);
                    } else {
                        int channels = audioModel.getChannels();
                        float frameRate = audioModel.getFrameRate();
                        LockFactory lockFactory = mediator.getLockFactory();
                        ThreadPool loaderThreadPool = mediator.getLoaderThreadPool();
                        WaxLabPreferences waxLabPreferences = mediator.getWaxLabPreferences();
                        int bufferMillis = waxLabPreferences.getAudioPlayerBufferMillis();
                        int bufferSize = channels * (int)((double)bufferMillis * (double)frameRate / 1000.0);
                        int bufferCount = waxLabPreferences.getAudioPlayerBufferCount();
                        boolean fair = waxLabPreferences.isAudioPlayerBufferFair();
                        SampleBuffer[] sampleBuffers = new SampleBuffer[bufferCount];
                        for (int i = 0; i < bufferCount; ++i) {
                            sampleBuffers[i] = audioPlayerOutput instanceof FloatArraySampleBuffer ? new FloatArraySampleBuffer(channels, bufferSize, frameRate, new float[bufferSize]) : new DoubleArraySampleBuffer(channels, bufferSize, frameRate, new double[bufferSize]);
                        }
                        boolean success = false;
                        RealAudioModel realtimeModel = null;
                        try {
                            boolean readOnly = true;
                            boolean closeModel = false;
                            ReadWriteLock bufLock = lockFactory.createReadWriteLock(fair);
                            realtimeModel = new RealAudioModel((AudioModel)audioModel, (SampleModel)audioModel, sampleIndex, readOnly, closeModel, bufferCount, bufferSize, sampleBuffers, bufLock, loaderThreadPool);
                            sampleCursor = realtimeModel.openRealtimeCursor(sampleIndex);
                            audioModel = realtimeModel;
                            success = true;
                        }
                        catch (IOException e) {
                            throw new AudioException((Throwable)e);
                        }
                        catch (InterruptedException e) {
                            throw new AudioException((Throwable)e);
                        }
                        finally {
                            if (!success && realtimeModel != null) {
                                try {
                                    realtimeModel.close();
                                }
                                catch (IOException e) {
                                    logger.log(Level.SEVERE, e.getMessage(), e);
                                }
                            }
                        }
                    }
                    audioPlayerCursor = sampleCursor;
                    if (debug != null) {
                        logger.log(debug, " - created AudioPlayerCursor: " + audioPlayerCursor);
                    }
                } else {
                    audioPlayerCursor = audioPlayerCursorOld;
                    if (debug != null) {
                        logger.log(debug, " - keeping AudioPlayerCursor: " + audioPlayerCursor);
                    }
                }
            }
            if (enablePlayer && audioPlayerCursor != null && audioPlayerOutput != null) {
                if (audioPlayerOld == null || audioPlayerCursor != audioPlayerCursorOld || audioPlayerOutput != audioPlayerOutputOld) {
                    if (debug != null) {
                        logger.log(debug, " - creating AudioPlayer: cursor=" + audioPlayerCursor);
                    }
                    audioPlayer = new WaxLabAudioPlayer(this.audioLine.getName(), audioPlayerCursor, (SampleBuffer)audioPlayerOutput);
                    if (debug != null) {
                        logger.log(debug, " - created AudioPlayer: " + audioPlayer);
                    }
                } else {
                    audioPlayer = audioPlayerOld;
                    if (debug != null) {
                        logger.log(debug, " - keeping AudioPlayer: " + audioPlayer);
                    }
                }
            }
            boolean syncFeatureChanged = syncFeature != syncFeatureOld;
            boolean bl = audioPlayerPortsChanged = !CommonLineFeature.equalsPortArray((Port[])playbackPorts, (Port[])audioPlayerPortsOld);
            if (!syncFeatureChanged && !audioPlayerPortsChanged && mergedAudioModel == mergedAudioModelOld && audioPlayerCursor == audioPlayerCursorOld && audioPlayer == audioPlayerOld) {
                logger.info("TODO no changes !");
            }
            if ((audioSyncGroup = audioOutGroup) != null) {
                this.audioLine.setAudioSyncGroup(audioSyncGroup);
            }
            PlayerInfo info = new PlayerInfo();
            info.audioOutChannels = audioOutChannels;
            info.audioOutRate = audioOutRate;
            info.mergedAudioModel = mergedAudioModel;
            info.audioPlayerCursor = audioPlayerCursor;
            this.playerInfoList.add(info);
            this.playerInfoActive = info;
            if (audioPlayer != null) {
                if (audioPlayHandlerOld == null || audioPlayer != audioPlayerOld || audioPlayerOutput != audioPlayerOutputOld) {
                    int priority = 300;
                    audioPlayHandler = syncFeature.createAudioProcHandler(info, priority, audioOutGroup, audioPlayer);
                    if (debug != null) {
                        logger.log(debug, " - created AudioPlayerHandler: " + audioPlayHandler);
                    }
                } else {
                    audioPlayHandler = audioPlayHandlerOld;
                    if (audioPlayHandler != null) {
                        audioPlayHandler.infoObject = info;
                    }
                    if (debug != null) {
                        logger.log(debug, " - keeping AudioPlayerHandler: " + audioPlayHandler);
                    }
                }
                info.audioPlayer = audioPlayer;
                info.audioPlayHandler = audioPlayHandler;
                boolean bl2 = info.audioPlayerPrepare = audioPlayer != audioPlayerOld;
            }
            if (audioPlayHandler != null && audioPlayerOutput != null) {
                if (audioOutHandlerOld == null || audioPlayHandler != audioPlayHandlerOld || audioPlayerOutput != audioPlayerOutputOld || audioPlayerPortsChanged) {
                    int priority = 100;
                    audioOutHandler = syncFeature.createAudioOutHandler(info, priority, playbackSyncGroup, playbackPorts, (SampleBuffer)audioPlayerOutput);
                    if (debug != null) {
                        logger.log(debug, " - created AudioOutHandler: " + audioOutHandler);
                    }
                } else {
                    audioOutHandler = audioOutHandlerOld;
                    if (audioOutHandler != null) {
                        audioOutHandler.infoObject = info;
                    }
                    if (debug != null) {
                        logger.log(debug, " - keeping AudioOutHandler: " + audioOutHandler);
                    }
                }
                info.audioOutHandler = audioOutHandler;
                info.audioPlayerPorts = playbackPorts;
            }
            if (syncFeatureOld != null) {
                if (syncFeatureChanged || audioPlayHandler != audioPlayHandlerOld) {
                    syncFeatureOld.removeSyncHandler(audioPlayHandlerOld);
                }
                if (syncFeatureChanged || audioOutHandler != audioOutHandlerOld) {
                    syncFeatureOld.removeSyncHandler(audioOutHandlerOld);
                }
            }
            this.syncFeatureOld = syncFeature;
            if (syncFeature != null) {
                if (syncFeatureChanged || audioPlayHandler != audioPlayHandlerOld) {
                    syncFeature.insertSyncHandler(audioPlayHandler);
                }
                if (syncFeatureChanged || audioOutHandler != audioOutHandlerOld) {
                    syncFeature.insertSyncHandler(audioOutHandler);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabAudioSyncGroup audioSyncGroup, long lineOfs, long studioTime, long masterTime) {
        Object infoObject = syncHandler.getInfoObject();
        if (infoObject != null && infoObject instanceof PlayerInfo) {
            PlayerInfo info = (PlayerInfo)infoObject;
            if (!info.audioPlayerPrepare) {
                return;
            }
            SampleCursor sampleCursor = info.audioPlayerCursor;
            if (sampleCursor == null) {
                return;
            }
            try {
                float frameRate = sampleCursor.getFrameRate();
                int channels = sampleCursor.getChannels();
                long audioModelLineOfs = 0L;
                long nanoPos = lineOfs - audioModelLineOfs;
                long frameIndex = LineUtil.getUnitOfs((long)nanoPos, (double)frameRate);
                long sampleIndex = (long)channels * frameIndex;
                long sampleDelta = sampleIndex - sampleCursor.getPosition();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("     - prepare AudioPlayer: lineOfs=" + lineOfs + ", samplePos=" + sampleCursor.getPosition() + " -> " + sampleIndex + ", sampleDelta=" + sampleDelta + ", cursor=" + sampleCursor);
                }
                if (sampleDelta != 0L && sampleDelta > Integer.MIN_VALUE && sampleDelta < Integer.MAX_VALUE) {
                    if (sampleDelta > 0L) {
                        sampleCursor.move((int)sampleDelta);
                    } else if (logger.isLoggable(Level.WARNING)) {
                        logger.warning("Cannot move realtime cursor backward: " + sampleDelta);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            return;
        }
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiInputPort midiInputPort, long lineOfs, long studioTime, long masterTime) {
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiOutputPort midiOutputPort, long lineOfs, long studioTime, long masterTime) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseSyncHandler(SyncHandler syncHandler) {
        Object infoObject = syncHandler.getInfoObject();
        if (infoObject != null && infoObject instanceof PlayerInfo) {
            MergedAudioModel mergedModel;
            SampleCursor sampleCursor;
            PlayerInfo info = (PlayerInfo)infoObject;
            boolean releaseAudioPlayer = true;
            boolean releaseSampleCursor = true;
            boolean releaseMergedAudioModel = true;
            FeatureAudioLinePlayer featureAudioLinePlayer = this;
            synchronized (featureAudioLinePlayer) {
                PlayerInfo active;
                if (!this.playerInfoList.remove(info)) {
                    return;
                }
                if (this.playerInfoActive == info) {
                    this.playerInfoActive = null;
                }
                if ((active = this.playerInfoActive) != null) {
                    releaseAudioPlayer = info.audioPlayer != active.audioPlayer;
                    releaseSampleCursor = info.audioPlayerCursor != active.audioPlayerCursor;
                    releaseMergedAudioModel = info.mergedAudioModel != active.mergedAudioModel;
                }
            }
            WaxLabAudioPlayer audioPlayer = info.audioPlayer;
            if (audioPlayer != null) {
                info.audioPlayer = null;
                if (releaseAudioPlayer) {
                    try {
                        audioPlayer.shutdown();
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            if ((sampleCursor = info.audioPlayerCursor) != null) {
                info.audioPlayerCursor = null;
                if (releaseSampleCursor) {
                    try {
                        sampleCursor.close();
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            if ((mergedModel = info.mergedAudioModel) != null) {
                info.mergedAudioModel = null;
                if (releaseMergedAudioModel) {
                    try {
                        mergedModel.stop();
                        mergedModel.close();
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("closed MergedAudioModel: " + mergedModel);
                        }
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
    }

    protected class WidgetAudioPlayer
    extends AbstractLineWidget {
        public static final String NAME = "AudioPlayer";
        public static final String TOOLTIP = "Audio Playback";

        public WidgetAudioPlayer(AbstractLine line) {
            super(line, NAME);
            this.setTooltip(TOOLTIP);
        }

        @Override
        protected Icon createDisabledIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_disabled_icon16.png");
        }

        @Override
        protected Icon createEnabledIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_enabled_icon16.png");
        }

        @Override
        protected Icon createActiveIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_active_icon16.png");
        }

        @Override
        protected synchronized void setSelected(boolean selected) {
            super.setSelected(selected);
            FeatureAudioLinePlayer.this.checkEnable();
        }
    }

    protected static class PlayerInfo {
        protected boolean audioPlayerPrepare;
        protected WaxLabAudioOutputPort[] audioPlayerPorts;
        protected int audioOutChannels;
        protected float audioOutRate;
        protected MergedAudioModel mergedAudioModel;
        protected SampleCursor audioPlayerCursor;
        protected WaxLabAudioPlayer audioPlayer;
        protected SampleBuffer audioPlayerOutput;
        protected SyncHandler.AudioProcHandler audioPlayHandler;
        protected SyncHandler.AudioOutHandler audioOutHandler;

        protected PlayerInfo() {
        }
    }
}

