/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.sound.AudioFile;
import com.spacekiller.util.sound.DefaultSampleCursor;
import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.spacekiller.util.sound.FloatArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleCursor;
import com.spacekiller.util.sound.SampleModel;
import com.spacekiller.util.thread.ThreadPool;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.model.AudioChunk;
import com.waxmonster.model.AudioModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.MutableChunkModel;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.impl.CachedAudioModel;
import com.waxmonster.model.impl.RealAudioModel;
import com.waxmonster.studio.Port;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.WaxLabPreferences;
import com.waxmonster.waxlab.impl.AbstractLine;
import com.waxmonster.waxlab.impl.AbstractLineWidget;
import com.waxmonster.waxlab.impl.CommonLineFeature;
import com.waxmonster.waxlab.impl.DefaultAudioLine;
import com.waxmonster.waxlab.impl.SyncFeature;
import com.waxmonster.waxlab.impl.SyncHandler;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabAudioInputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioJoinerInfo;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import com.waxmonster.waxlab.proc.WaxLabAudioRecorder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.swing.Icon;

public class FeatureAudioLineRecorder
extends CommonLineFeature {
    private static final Logger logger = Platform.getLogger(FeatureAudioLineRecorder.class);
    public static final String NAME = "AudioLineRecorder";
    private final DefaultAudioLine audioLine;
    private final WidgetAudioRecorder widgetAudioRecorder;
    private int recordingFrameType;
    private int recordingSampleType;
    private WaxLabPortInfo[] recordingPorts;
    private long recordingLatencyNanos;
    private SyncFeature syncFeatureOld;
    private List recorderInfoList;
    private RecorderInfo recorderInfoActive;

    public FeatureAudioLineRecorder(DefaultAudioLine audioLine) {
        super(audioLine, NAME);
        this.audioLine = audioLine;
        this.widgetAudioRecorder = new WidgetAudioRecorder(audioLine);
        this.recorderInfoList = new ArrayList();
    }

    public final DefaultAudioLine getAudioLine() {
        return this.audioLine;
    }

    public final WidgetAudioRecorder getWidgetAudioRecorder() {
        return this.widgetAudioRecorder;
    }

    protected synchronized void checkEnable() {
        this.setEnabled(this.widgetAudioRecorder.isSelected());
    }

    @Override
    protected void fireFeatureSynced() {
        super.fireFeatureSynced();
        boolean active = this.isActive();
        this.widgetAudioRecorder.setActive(active);
    }

    public synchronized WaxLabPortInfo[] getRecordingPorts() {
        return this.recordingPorts;
    }

    public synchronized void setRecordingPorts(WaxLabPortInfo[] recordingPorts) {
        if (FeatureAudioLineRecorder.equalsPortArray(this.recordingPorts, recordingPorts)) {
            return;
        }
        this.recordingPorts = recordingPorts;
        this.invalidate();
    }

    public synchronized int getRecordingFrameType() {
        return this.recordingFrameType;
    }

    public synchronized void setRecordingFrameType(int recordingFrameType) {
        if (this.recordingFrameType == recordingFrameType) {
            return;
        }
        this.recordingFrameType = recordingFrameType;
        this.invalidate();
    }

    public synchronized int getRecordingSampleType() {
        return this.recordingSampleType;
    }

    public synchronized void setRecordingSampleType(int recordingSampleType) {
        if (this.recordingSampleType == recordingSampleType) {
            return;
        }
        this.recordingSampleType = recordingSampleType;
        this.invalidate();
    }

    public synchronized long getRecordingLatencyNanos() {
        return this.recordingLatencyNanos;
    }

    public synchronized void setRecordingLatencyNanos(long recordingLatencyNanos) {
        if (this.recordingLatencyNanos == recordingLatencyNanos) {
            return;
        }
        this.recordingLatencyNanos = recordingLatencyNanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mediateFeature(SyncFeature syncFeature) {
        SyncMediator mediator = this.getMediator();
        if (mediator == null) {
            return;
        }
        SyncFeature syncFeatureOld = this.syncFeatureOld;
        Level debug = Level.FINE;
        if (!logger.isLoggable(debug)) {
            debug = null;
        }
        try {
            AudioProcessor recJoiner;
            WaxLabAudioSyncGroup audioSyncGroup;
            boolean syncFeatureChanged;
            RealAudioModel targetSampleModel;
            RealAudioModel targetAudioModel;
            int recFrameType = this.getRecordingFrameType();
            WaxLabPortInfo[] recPortInfos = this.getRecordingPorts();
            WaxLabAudioInputPort[] recPorts = FeatureAudioLineRecorder.validateAudioInputPorts(recPortInfos, recFrameType);
            WaxLabAudioSyncGroup recSyncGroup = FeatureAudioLineRecorder.validateAudioSyncGroup(recPorts);
            if (recSyncGroup == null) {
                recPorts = null;
            }
            int recPortCount = recPorts == null ? 0 : recPorts.length;
            float audioRecRate = CommonLineFeature.computeAudioInputSampleRate(recPorts, recPortCount);
            int audioRecChannels = 0;
            if (audioRecRate > 0.0f) {
                audioRecChannels = CommonLineFeature.computeAudioInputChannels(recPorts, recPortCount);
            }
            int audioRecSampleType = this.getRecordingSampleType();
            long startLineOfs = syncFeature.getStartLineOfs();
            if (debug != null) {
                logger.log(debug, "mediate: " + this.audioLine + ", recChannels=" + audioRecChannels + ", recRate=" + audioRecRate);
            }
            boolean enableRecorder = this.isEnabled();
            if (recPortCount < 1) {
                enableRecorder = false;
            }
            int audioRecChannelsOld = 0;
            float audioRecRateOld = 0.0f;
            int audioRecSampleTypeOld = -1;
            WaxLabAudioInputPort[] audioRecorderPortsOld = null;
            WaxLabAudioJoinerInfo audioRecorderJoinerOld = null;
            SampleBuffer audioRecorderBufferOld = null;
            SampleCursor audioRecorderCursorOld = null;
            WaxLabAudioRecorder audioRecorderOld = null;
            SyncHandler.AudioProcHandler audioJoinHandlerOld = null;
            SyncHandler.AudioProcHandler audioRecHandlerOld = null;
            CachedAudioModel audioRecorderCachedModelOld = null;
            RealAudioModel audioRecorderRealModelOld = null;
            AudioChunk audioRecorderChunkOld = null;
            RecorderInfo prevInfo = this.recorderInfoActive;
            if (prevInfo != null) {
                audioRecChannelsOld = prevInfo.audioRecChannels;
                audioRecRateOld = prevInfo.audioRecRate;
                audioRecSampleTypeOld = prevInfo.audioRecSampleType;
                audioRecorderPortsOld = prevInfo.audioRecorderPorts;
                audioRecorderJoinerOld = prevInfo.audioRecorderJoiner;
                audioRecorderBufferOld = prevInfo.audioRecorderBuffer;
                audioRecorderCursorOld = prevInfo.audioRecorderCursor;
                audioRecorderOld = prevInfo.audioRecorder;
                audioJoinHandlerOld = prevInfo.audioJoinHandler;
                audioRecHandlerOld = prevInfo.audioRecHandler;
                audioRecorderCachedModelOld = prevInfo.audioRecorderCachedModel;
                audioRecorderRealModelOld = prevInfo.audioRecorderRealModel;
                audioRecorderChunkOld = prevInfo.audioRecorderChunk;
            }
            SampleBuffer audioRecorderBuffer = null;
            SampleCursor audioRecorderCursor = null;
            WaxLabAudioJoinerInfo audioRecorderJoiner = null;
            WaxLabAudioRecorder audioRecorder = null;
            SyncHandler.AudioProcHandler audioJoinHandler = null;
            SyncHandler.AudioProcHandler audioRecHandler = null;
            RealAudioModel audioRecorderCachedModel = null;
            RealAudioModel audioRecorderRealModel = null;
            AudioChunk audioRecorderChunk = null;
            if (enableRecorder && recPortCount > 0 && audioRecChannels > 0 && audioRecRate > 0.0f) {
                if (audioRecorderBufferOld == null || audioRecChannels != audioRecChannelsOld || audioRecRate != audioRecRateOld || audioRecSampleType != audioRecSampleTypeOld || !CommonLineFeature.equalsPortArray((Port[])recPorts, (Port[])audioRecorderPortsOld)) {
                    if (debug != null) {
                        logger.log(debug, " - preparing AudioRecorderBuffer: line=" + this.audioLine);
                    }
                    if (recPortCount == 1) {
                        audioRecorderBuffer = recPorts[0].getBuffer();
                    } else {
                        audioRecorderJoiner = recSyncGroup.setupAudioJoiner(recPorts);
                        if (audioRecorderJoiner != null) {
                            audioRecorderBuffer = audioRecorderJoiner.getOutput();
                            if (debug != null) {
                                logger.log(debug, " - created AudioRecorderJoiner: " + audioRecorderJoiner);
                            }
                        }
                    }
                    if (debug != null) {
                        logger.log(debug, " - prepared AudioRecorderBuffer: " + audioRecorderBuffer);
                    }
                } else {
                    audioRecorderBuffer = audioRecorderBufferOld;
                    audioRecorderJoiner = audioRecorderJoinerOld;
                    if (debug != null) {
                        logger.log(debug, " - keeping AudioRecorderBuffer: " + audioRecorderBuffer);
                    }
                }
            }
            if (enableRecorder && audioRecorderBuffer != null) {
                if (audioRecorderCachedModelOld == null || audioRecChannels != audioRecChannelsOld || audioRecRate != audioRecRateOld || audioRecSampleType != audioRecSampleTypeOld) {
                    if (debug != null) {
                        logger.log(debug, " - creating CachedAudioModel: line=" + this.audioLine);
                    }
                    WaxLab waxLab = mediator.getWaxLab();
                    AudioFormat targetFormat = FeatureAudioLineRecorder.createAudioFormat(audioRecChannels, audioRecRate, audioRecSampleType);
                    if (waxLab != null && targetFormat != null) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(" - createCachedAudioModel: format=" + targetFormat);
                        }
                        String timestampString = mediator.getTimestampString();
                        String fileNamePrefix = FeatureAudioLineRecorder.buildFileNamePrefix(waxLab, this.audioLine, timestampString);
                        AudioFile targetAudioFile = null;
                        CachedAudioModel cachedAudioModel = null;
                        try {
                            targetAudioFile = waxLab.createNewAudioFile(fileNamePrefix, targetFormat);
                            if (targetAudioFile != null) {
                                cachedAudioModel = waxLab.createCachedAudioModel(targetAudioFile);
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                        finally {
                            if (cachedAudioModel == null && targetAudioFile != null) {
                                try {
                                    targetAudioFile.close();
                                }
                                catch (Exception e) {
                                    logger.log(Level.SEVERE, e.getMessage(), e);
                                }
                                targetAudioFile = null;
                            }
                        }
                        audioRecorderCachedModel = cachedAudioModel;
                        if (debug != null) {
                            logger.log(debug, " - created CachedAudioModel: " + audioRecorderCachedModel);
                        }
                    } else if (logger.isLoggable(Level.WARNING)) {
                        logger.warning("Unsupported recording sample type: #" + audioRecSampleType);
                    }
                } else {
                    audioRecorderCachedModel = audioRecorderCachedModelOld;
                    if (debug != null) {
                        logger.log(debug, " - keeping CachedAudioModel: " + audioRecorderCachedModel);
                    }
                }
            }
            if (enableRecorder && audioRecorderBuffer != null && audioRecorderCachedModel != null) {
                if (audioRecorderCursorOld == null || audioRecorderCachedModel != audioRecorderCachedModelOld) {
                    if (debug != null) {
                        logger.log(debug, " - creating AudioRecorderCursor: model=" + audioRecorderCachedModel);
                    }
                    long sampleIndex = 0L;
                    boolean batchMode = mediator.isBatchMode();
                    if (batchMode) {
                        audioRecorderCursor = new DefaultSampleCursor((SampleModel)audioRecorderCachedModel, sampleIndex);
                    } else {
                        WaxLabPreferences waxLabPreferences = mediator.getWaxLabPreferences();
                        int bufferCount = waxLabPreferences.getAudioRecorderBufferCount();
                        int bufferSize = audioRecChannels * (int)((double)waxLabPreferences.getAudioRecorderBufferMillis() * (double)audioRecRate / 1000.0);
                        boolean fair = waxLabPreferences.isAudioRecorderBufferFair();
                        SampleBuffer[] sampleBuffers = new SampleBuffer[bufferCount];
                        for (int i = 0; i < bufferCount; ++i) {
                            sampleBuffers[i] = audioRecorderBuffer instanceof FloatArraySampleBuffer ? new FloatArraySampleBuffer(audioRecChannels, bufferSize, audioRecRate, new float[bufferSize]) : new DoubleArraySampleBuffer(audioRecChannels, bufferSize, audioRecRate, new double[bufferSize]);
                        }
                        try {
                            boolean readOnly = false;
                            boolean closeModel = false;
                            LockFactory lockFactory = mediator.getLockFactory();
                            ThreadPool writerThreadPool = mediator.getWriterThreadPool();
                            ReadWriteLock bufLock = lockFactory.createReadWriteLock(fair);
                            audioRecorderRealModel = new RealAudioModel((AudioModel)audioRecorderCachedModel, (SampleModel)audioRecorderCachedModel, sampleIndex, readOnly, closeModel, bufferCount, bufferSize, sampleBuffers, bufLock, writerThreadPool);
                            audioRecorderCursor = audioRecorderRealModel.openRealtimeCursor(sampleIndex);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    if (debug != null) {
                        logger.log(debug, " - created AudioRecorderCursor: " + audioRecorderCursor);
                    }
                } else {
                    audioRecorderCursor = audioRecorderCursorOld;
                    audioRecorderRealModel = audioRecorderRealModelOld;
                    if (debug != null) {
                        logger.log(debug, " - keeping AudioRecorderCursor: " + audioRecorderCursor);
                    }
                }
            }
            if (audioRecorderRealModel != null) {
                targetAudioModel = audioRecorderRealModel;
                targetSampleModel = audioRecorderRealModel;
            } else {
                targetAudioModel = audioRecorderCachedModel;
                targetSampleModel = audioRecorderCachedModel;
            }
            if (enableRecorder && audioRecorderBuffer != null && targetSampleModel != null && audioRecorderCursor != null) {
                if (audioRecorderChunkOld == null || audioRecorderCursor != audioRecorderCursorOld) {
                    if (debug != null) {
                        logger.log(debug, " - creating AudioChunk: cursor=" + targetSampleModel);
                    }
                    int bufFrames = audioRecorderBuffer.getSamples() / audioRecChannels;
                    long bufferLatencyNanos = LineUtil.getNanoOfs((long)bufFrames, (double)audioRecRate);
                    long totalLatencyNanos = bufferLatencyNanos + this.recordingLatencyNanos;
                    long chunkOfs = startLineOfs;
                    long chunkEnd = Long.MAX_VALUE;
                    long modelOfs = totalLatencyNanos;
                    long modelEnd = Long.MAX_VALUE;
                    audioRecorderChunk = (AudioChunk)targetAudioModel.createLineChunk(chunkOfs, chunkEnd, modelOfs, modelEnd);
                    this.audioLine.setRecChunk((LineChunk)audioRecorderChunk);
                    this.audioLine.getMutableChunkModel().addChunk((LineChunk)audioRecorderChunk);
                    if (debug != null) {
                        logger.log(debug, " - created AudioChunk: " + audioRecorderChunk);
                    }
                } else {
                    audioRecorderChunk = audioRecorderChunkOld;
                    if (debug != null) {
                        logger.log(debug, " - keeping AudioChunk: " + audioRecorderChunk);
                    }
                }
            }
            if (enableRecorder && audioRecorderBuffer != null && targetSampleModel != null && audioRecorderCursor != null) {
                if (audioRecorderOld == null || audioRecorderCursor != audioRecorderCursorOld || audioRecorderBuffer != audioRecorderBufferOld) {
                    if (debug != null) {
                        logger.log(debug, " - creating AudioRecorder: buffer=" + audioRecorderBuffer);
                    }
                    audioRecorder = new WaxLabAudioRecorder(this.audioLine.getName(), audioRecorderBuffer, audioRecorderCursor, this.audioLine);
                    if (debug != null) {
                        logger.log(debug, " - created AudioRecorder: " + audioRecorder);
                    }
                } else {
                    audioRecorder = audioRecorderOld;
                    if (debug != null) {
                        logger.log(debug, " - keeping AudioRecorder: " + audioRecorder);
                    }
                }
            }
            boolean bl = syncFeatureChanged = syncFeature != syncFeatureOld;
            if (!syncFeatureChanged && audioRecorderJoiner == audioRecorderJoinerOld && audioRecorderBuffer == audioRecorderBufferOld && audioRecorderCursor == audioRecorderCursorOld && audioRecorderCachedModel == audioRecorderCachedModelOld && audioRecorderRealModel == audioRecorderRealModelOld && audioRecorder == audioRecorderOld) {
                logger.info("TODO no changes !");
            }
            if ((audioSyncGroup = recSyncGroup) != null) {
                this.audioLine.setAudioSyncGroup(audioSyncGroup);
            }
            RecorderInfo info = new RecorderInfo();
            info.audioRecChannels = audioRecChannels;
            info.audioRecRate = audioRecRate;
            info.audioRecSampleType = audioRecSampleType;
            info.audioRecorderPorts = recPorts;
            info.audioRecorderJoiner = audioRecorderJoiner;
            info.audioRecorderBuffer = audioRecorderBuffer;
            info.audioRecorderCursor = audioRecorderCursor;
            info.audioRecorderCachedModel = audioRecorderCachedModel;
            info.audioRecorderRealModel = audioRecorderRealModel;
            info.audioRecorderChunk = audioRecorderChunk;
            info.audioRecorder = audioRecorder;
            info.audioRecorderPrepare = audioRecorderChunk != audioRecorderChunkOld;
            this.recorderInfoList.add(info);
            this.recorderInfoActive = info;
            AudioProcessor audioProcessor = recJoiner = audioRecorderJoiner == null ? null : audioRecorderJoiner.getJoiner();
            if (recJoiner != null) {
                if (audioJoinHandlerOld == null || audioRecorderJoiner != audioRecorderJoinerOld) {
                    int priority = 900;
                    audioJoinHandler = syncFeature.createAudioProcHandler(info, priority, recSyncGroup, recJoiner);
                    if (debug != null) {
                        logger.log(debug, " - created AudioJoinHandler: " + audioJoinHandler);
                    }
                } else {
                    audioJoinHandler = audioJoinHandlerOld;
                    if (audioJoinHandler != null) {
                        audioJoinHandler.infoObject = info;
                    }
                    if (debug != null) {
                        logger.log(debug, " - keeping AudioJoinHandler: " + audioJoinHandler);
                    }
                }
                info.audioJoinHandler = audioJoinHandler;
            }
            if (audioRecorder != null) {
                if (audioRecHandlerOld == null || audioRecorder != audioRecorderOld) {
                    int priority = 600;
                    audioRecHandler = syncFeature.createAudioProcHandler(info, priority, recSyncGroup, audioRecorder);
                    if (debug != null) {
                        logger.log(debug, " - created AudioRecorderHandler: " + audioRecHandler);
                    }
                } else {
                    audioRecHandler = audioRecHandlerOld;
                    if (audioRecHandler != null) {
                        audioRecHandler.infoObject = info;
                    }
                    if (debug != null) {
                        logger.log(debug, " - keeping AudioRecorderHandler: " + audioRecHandler);
                    }
                }
                info.audioRecHandler = audioRecHandler;
            }
            if (syncFeatureOld != null) {
                if (syncFeatureChanged || audioJoinHandler != audioJoinHandlerOld) {
                    syncFeatureOld.removeSyncHandler(audioJoinHandlerOld);
                }
                if (syncFeatureChanged || audioRecHandler != audioRecHandlerOld) {
                    syncFeatureOld.removeSyncHandler(audioRecHandlerOld);
                }
            }
            this.syncFeatureOld = syncFeature;
            if (syncFeature != null) {
                if (syncFeatureChanged || audioJoinHandler != audioJoinHandlerOld) {
                    syncFeature.insertSyncHandler(audioJoinHandler);
                }
                if (syncFeatureChanged || audioRecHandler != audioRecHandlerOld) {
                    syncFeature.insertSyncHandler(audioRecHandler);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabAudioSyncGroup audioSyncGroup, long lineOfs, long studioTime, long masterTime) {
        Object infoObject = syncHandler.getInfoObject();
        if (infoObject != null && infoObject instanceof RecorderInfo) {
            RecorderInfo info = (RecorderInfo)infoObject;
            List list = this.recorderInfoList;
            synchronized (list) {
                if (!info.audioRecorderPrepare) {
                    return;
                }
            }
            AudioChunk audioChunk = info.audioRecorderChunk;
            if (audioChunk == null) {
                return;
            }
            try {
                MutableChunkModel chunkModel;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("     - prepare AudioRecorder: lineOfs=" + lineOfs + ", chunkLineOfs=" + audioChunk.getChunkOfs() + " -> " + lineOfs + ", modelOfs=" + audioChunk.getModelOfs() + ", modelEnd=" + audioChunk.getModelEnd());
                }
                if ((chunkModel = this.audioLine.getMutableChunkModel()) != null) {
                    chunkModel.moveChunk((LineChunk)audioChunk, lineOfs, audioChunk.getChunkEnd(), audioChunk.getZOrder());
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            return;
        }
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiInputPort midiInputPort, long lineOfs, long studioTime, long masterTime) {
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiOutputPort midiOutputPort, long lineOfs, long studioTime, long masterTime) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseSyncHandler(SyncHandler syncHandler) {
        Object infoObject = syncHandler.getInfoObject();
        if (infoObject != null && infoObject instanceof RecorderInfo) {
            WaxLabAudioJoinerInfo joinerInfo;
            SampleCursor audioRecorderCursor;
            RecorderInfo info = (RecorderInfo)infoObject;
            boolean releaseAudioRecorder = true;
            boolean releaseSampleCursor = true;
            boolean releaseRecorderJoiner = true;
            boolean releaseRealAudioModel = true;
            boolean flushCachedAudioModel = true;
            boolean releaseRecorderChunk = true;
            List list = this.recorderInfoList;
            synchronized (list) {
                RecorderInfo active;
                if (!this.recorderInfoList.remove(info)) {
                    return;
                }
                if (this.recorderInfoActive == info) {
                    this.recorderInfoActive = null;
                }
                if ((active = this.recorderInfoActive) != null) {
                    releaseAudioRecorder = info.audioRecorder != active.audioRecorder;
                    releaseSampleCursor = info.audioRecorderCursor != active.audioRecorderCursor;
                    releaseRecorderJoiner = info.audioRecorderJoiner != active.audioRecorderJoiner;
                    releaseRealAudioModel = info.audioRecorderRealModel != active.audioRecorderRealModel;
                    flushCachedAudioModel = info.audioRecorderCachedModel != active.audioRecorderCachedModel;
                    releaseRecorderChunk = info.audioRecorderChunk != active.audioRecorderChunk;
                }
            }
            WaxLabAudioRecorder audioRecorder = info.audioRecorder;
            if (audioRecorder != null) {
                info.audioRecorder = null;
                if (releaseAudioRecorder) {
                    try {
                        audioRecorder.shutdown();
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            if ((audioRecorderCursor = info.audioRecorderCursor) != null) {
                info.audioRecorderCursor = null;
                if (releaseSampleCursor) {
                    try {
                        audioRecorderCursor.close();
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            if ((joinerInfo = info.audioRecorderJoiner) != null) {
                info.audioRecorderJoiner = null;
                if (releaseRecorderJoiner) {
                    WaxLabAudioSyncGroup syncGroup;
                    SyncHandler.AudioProcHandler joinHandler = info.audioJoinHandler;
                    WaxLabAudioSyncGroup waxLabAudioSyncGroup = syncGroup = joinHandler == null ? null : joinHandler.group;
                    if (syncGroup != null) {
                        syncGroup.releaseAudioJoiner(joinerInfo);
                    }
                }
            }
            RealAudioModel realAudioModel = info.audioRecorderRealModel;
            CachedAudioModel cachedAudioModel = info.audioRecorderCachedModel;
            if (realAudioModel != null && releaseRealAudioModel) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Closing RealAudioModel (only): " + realAudioModel + " -> " + cachedAudioModel);
                }
                try {
                    realAudioModel.close();
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                realAudioModel = null;
            }
            if (cachedAudioModel != null && flushCachedAudioModel) {
                try {
                    cachedAudioModel.flush();
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            MutableChunkModel chunkModel = this.audioLine.getMutableChunkModel();
            AudioChunk audioRecorderChunk = info.audioRecorderChunk;
            if (chunkModel != null && audioRecorderChunk != null && cachedAudioModel != null && releaseRecorderChunk) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Releasing AudioRecorderChunk: " + audioRecorderChunk + " -> " + cachedAudioModel);
                }
                try {
                    long chunkOfs = audioRecorderChunk.getChunkOfs();
                    long modelOfs = audioRecorderChunk.getModelOfs();
                    long chunkEnd = info.stopLineOfs;
                    if (chunkEnd == Long.MIN_VALUE) {
                        logger.info("TODO chunkOfs=" + chunkOfs + ", stopLineOfs=" + chunkEnd);
                        chunkEnd = chunkOfs + cachedAudioModel.getNanoLength() - modelOfs;
                    }
                    if (chunkEnd < chunkOfs) {
                        chunkEnd = chunkOfs;
                    }
                    long modelEnd = chunkEnd - chunkOfs + modelOfs;
                    MutableLineChunk recordedAudioChunk = cachedAudioModel.createLineChunk(chunkOfs, chunkEnd, modelOfs, modelEnd);
                    if (this.audioLine.getRecChunk() == audioRecorderChunk) {
                        this.audioLine.setRecChunk(null);
                    }
                    chunkModel.addChunk((LineChunk)recordedAudioChunk);
                    chunkModel.removeChunk((LineChunk)audioRecorderChunk);
                    if (audioRecorderChunk instanceof MutableLineChunk) {
                        ((MutableLineChunk)audioRecorderChunk).close();
                    }
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            info.audioRecorderCachedModel = null;
            info.audioRecorderRealModel = null;
            info.audioRecorderChunk = null;
            info.audioRecorderPorts = null;
            info.audioJoinHandler = null;
            info.audioRecHandler = null;
            return;
        }
    }

    protected class WidgetAudioRecorder
    extends AbstractLineWidget {
        public static final String NAME = "AudioRecorder";
        public static final String TOOLTIP = "Audio Recording";

        public WidgetAudioRecorder(AbstractLine line) {
            super(line, NAME);
            this.setTooltip(TOOLTIP);
        }

        @Override
        protected Icon createDisabledIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_record_disabled_icon16.png");
        }

        @Override
        protected Icon createEnabledIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_record_enabled_icon16.png");
        }

        @Override
        protected Icon createActiveIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_record_active_icon16.png");
        }

        @Override
        protected synchronized void setSelected(boolean selected) {
            super.setSelected(selected);
            FeatureAudioLineRecorder.this.checkEnable();
        }
    }

    protected static class RecorderInfo {
        protected boolean audioRecorderPrepare;
        protected int audioRecChannels;
        protected float audioRecRate;
        protected int audioRecSampleType;
        protected WaxLabAudioInputPort[] audioRecorderPorts;
        protected WaxLabAudioJoinerInfo audioRecorderJoiner;
        protected SampleBuffer audioRecorderBuffer;
        protected SampleCursor audioRecorderCursor;
        protected WaxLabAudioRecorder audioRecorder;
        protected SyncHandler.AudioProcHandler audioJoinHandler;
        protected SyncHandler.AudioProcHandler audioRecHandler;
        protected CachedAudioModel audioRecorderCachedModel;
        protected RealAudioModel audioRecorderRealModel;
        protected AudioChunk audioRecorderChunk;
        protected long stopLineOfs = Long.MIN_VALUE;

        protected RecorderInfo() {
        }
    }
}

