/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Tools;
import com.waxmonster.waxlab.impl.AbstractLine;
import com.waxmonster.waxlab.impl.AbstractLineWidget;
import com.waxmonster.waxlab.impl.CommonLineFeature;
import com.waxmonster.waxlab.impl.DefaultEditorLine;
import com.waxmonster.waxlab.impl.ScratchManager;
import com.waxmonster.waxlab.impl.SyncFeature;
import com.waxmonster.waxlab.impl.SyncHandler;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import javax.swing.Icon;

public class FeatureEditorLinePlayer
extends CommonLineFeature {
    public static final String NAME = "EditorLinePlayer";
    private final DefaultEditorLine editorLine;
    private final WidgetEditorPlayer widgetEditorPlayer;
    private ScratchManager scratchManager;

    public FeatureEditorLinePlayer(DefaultEditorLine editorLine, ScratchManager scratchManager) {
        super(editorLine, NAME);
        this.editorLine = editorLine;
        this.widgetEditorPlayer = new WidgetEditorPlayer(editorLine);
        this.scratchManager = scratchManager;
    }

    public final DefaultEditorLine getEditorLine() {
        return this.editorLine;
    }

    public final WidgetEditorPlayer getWidgetEditorPlayer() {
        return this.widgetEditorPlayer;
    }

    protected synchronized void checkEnable() {
        this.setEnabled(this.widgetEditorPlayer.isSelected());
    }

    @Override
    protected void fireFeatureSynced() {
        super.fireFeatureSynced();
        boolean active = this.isActive();
        this.widgetEditorPlayer.setActive(active);
    }

    protected ScratchManager getScratchManager() {
        return this.scratchManager;
    }

    protected void setScratchManager(ScratchManager scratchManager) {
        this.scratchManager = scratchManager;
    }

    @Override
    protected void mediateFeature(SyncFeature syncFeature) {
        SyncMediator mediator = this.getMediator();
        if (mediator == null) {
            return;
        }
        long lineOfs = syncFeature.getStartLineOfs();
        ScratchManager manager = this.getScratchManager();
        boolean enableRecorder = false;
        boolean enableScratcher = false;
        boolean enablePlayback = true;
        manager.mediateFeature(mediator, lineOfs, enableRecorder, enableScratcher, enablePlayback);
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabAudioSyncGroup audioSyncGroup, long lineOfs, long studioTime, long masterTime) {
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiInputPort midiInputPort, long lineOfs, long studioTime, long masterTime) {
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiOutputPort midiOutputPort, long lineOfs, long studioTime, long masterTime) {
    }

    @Override
    protected void releaseSyncHandler(SyncHandler syncHandler) {
    }

    protected class WidgetEditorPlayer
    extends AbstractLineWidget {
        public static final String NAME = "EditorPlayer";
        public static final String TOOLTIP = "Scratch-Editor Playback";

        public WidgetEditorPlayer(AbstractLine line) {
            super(line, NAME);
            this.setTooltip(TOOLTIP);
        }

        @Override
        protected Icon createDisabledIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_disabled_icon16.png");
        }

        @Override
        protected Icon createEnabledIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_enabled_icon16.png");
        }

        @Override
        protected Icon createActiveIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_active_icon16.png");
        }

        @Override
        protected synchronized void setSelected(boolean selected) {
            super.setSelected(selected);
            FeatureEditorLinePlayer.this.checkEnable();
        }
    }
}

