/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Clock;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import com.spacekiller.util.midi.MidiFilter;
import com.spacekiller.util.thread.ThreadPool;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.model.impl.DefaultChunkModel;
import com.waxmonster.model.impl.MergedMidiTrackReader;
import com.waxmonster.model.impl.MidiTrackReader;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.WaxLabPreferences;
import com.waxmonster.waxlab.impl.AbstractLine;
import com.waxmonster.waxlab.impl.AbstractLineWidget;
import com.waxmonster.waxlab.impl.CommonLineFeature;
import com.waxmonster.waxlab.impl.DefaultMidiLine;
import com.waxmonster.waxlab.impl.SyncFeature;
import com.waxmonster.waxlab.impl.SyncHandler;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiSyncGroup;
import com.waxmonster.waxlab.proc.WaxLabMidiPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class FeatureMidiLinePlayer
extends CommonLineFeature {
    private static final Logger logger = Platform.getLogger(FeatureMidiLinePlayer.class);
    private static final int MIN_READER_QUEUE_SIZE = 10;
    public static final String NAME = "MidiLinePlayer";
    private final DefaultMidiLine midiLine;
    private final WidgetMidiPlayer widgetMidiPlayer;
    private MidiFilter playbackMidiFilter;
    private WaxLabPortInfo playbackPort;
    private SyncFeature syncFeatureOld;
    private List playerInfoList;
    private PlayerInfo playerInfoActive;

    public FeatureMidiLinePlayer(DefaultMidiLine midiLine) {
        super(midiLine, NAME);
        this.midiLine = midiLine;
        this.widgetMidiPlayer = new WidgetMidiPlayer(midiLine);
        this.playerInfoList = new ArrayList();
    }

    public final DefaultMidiLine getMidiLine() {
        return this.midiLine;
    }

    public final WidgetMidiPlayer getWidgetMidiPlayer() {
        return this.widgetMidiPlayer;
    }

    protected synchronized void checkEnable() {
        this.setEnabled(this.widgetMidiPlayer.isSelected());
    }

    @Override
    protected void fireFeatureSynced() {
        super.fireFeatureSynced();
        boolean active = this.isActive();
        this.widgetMidiPlayer.setActive(active);
    }

    public synchronized WaxLabPortInfo getPlaybackPort() {
        return this.playbackPort;
    }

    public synchronized void setPlaybackPort(WaxLabPortInfo playbackPort) {
        if (this.playbackPort == playbackPort) {
            return;
        }
        this.playbackPort = playbackPort;
        this.invalidate();
    }

    public synchronized MidiFilter getPlaybackMidiFilter() {
        return this.playbackMidiFilter;
    }

    public synchronized void setPlaybackMidiFilter(MidiFilter playbackMidiFilter) {
        if (this.playbackMidiFilter == playbackMidiFilter) {
            return;
        }
        this.playbackMidiFilter = playbackMidiFilter;
        this.invalidate();
    }

    @Override
    protected synchronized void mediateFeature(SyncFeature syncFeature) {
        SyncMediator mediator = this.getMediator();
        if (mediator == null) {
            return;
        }
        SyncFeature syncFeatureOld = this.syncFeatureOld;
        Level debug = Level.FINE;
        if (!logger.isLoggable(debug)) {
            debug = null;
        }
        try {
            boolean syncFeatureChanged;
            DefaultChunkModel mcModel;
            MidiFilter midiFilter;
            WaxLabPortInfo playPortInfo = this.getPlaybackPort();
            WaxLabMidiOutputPort playPort = FeatureMidiLinePlayer.validateMidiOutputPort(playPortInfo);
            WaxLabMidiSyncGroup playSyncGroup = FeatureMidiLinePlayer.validateMidiSyncGroup(playPort);
            if (playSyncGroup == null) {
                playPort = null;
            }
            if ((midiFilter = this.getPlaybackMidiFilter()) == null) {
                midiFilter = MidiFilter.ACCEPT_ALL_FILTER;
            }
            long startLineOfs = syncFeature.getStartLineOfs();
            if (debug != null) {
                logger.log(debug, "mediate: " + this.midiLine + ", playPort=" + (Object)((Object)playPort));
            }
            boolean enablePlayer = this.isEnabled();
            MidiProcessor targetProcessor = null;
            if (playPort == null) {
                enablePlayer = false;
            } else {
                targetProcessor = playPort.getMidiProcessor();
                if (targetProcessor == null) {
                    enablePlayer = false;
                }
            }
            MidiFilter midiFilterOld = null;
            WaxLabMidiOutputPort midiPlayerPortOld = null;
            DefaultChunkModel midiPlayerModelOld = null;
            MergedMidiTrackReader midiPlayerReaderOld = null;
            MidiProcessor midiPlayerTargetOld = null;
            WaxLabMidiPlayer midiPlayerOld = null;
            SyncHandler.MidiOutHandler midiPlayHandlerOld = null;
            PlayerInfo prevInfo = this.playerInfoActive;
            if (prevInfo != null) {
                midiFilterOld = prevInfo.midiFilter;
                midiPlayerPortOld = prevInfo.midiPlayerPort;
                midiPlayerModelOld = prevInfo.midiPlayerModel;
                midiPlayerReaderOld = prevInfo.midiPlayerReader;
                midiPlayerTargetOld = prevInfo.midiPlayerTarget;
                midiPlayerOld = prevInfo.midiPlayer;
                midiPlayHandlerOld = prevInfo.midiPlayHandler;
            }
            DefaultChunkModel midiPlayerModel = null;
            MergedMidiTrackReader midiPlayerReader = null;
            WaxLabMidiPlayer midiPlayer = null;
            SyncHandler.MidiOutHandler midiPlayHandler = null;
            if (enablePlayer && (mcModel = this.midiLine.getMidiChunkModel()) != null && mcModel instanceof DefaultChunkModel) {
                midiPlayerModel = mcModel;
            }
            if (enablePlayer && midiPlayerModel != null && targetProcessor != null) {
                if (midiPlayerReaderOld == null || midiPlayerModel != midiPlayerModelOld || targetProcessor != midiPlayerTargetOld) {
                    if (debug != null) {
                        logger.log(debug, " - creating MidiTrackReader: line=" + this.midiLine + ", model=" + midiPlayerModel);
                    }
                    MergedMidiTrackReader reader = null;
                    try {
                        WaxLabPreferences waxLabPrefs = mediator.getWaxLabPreferences();
                        int maxQueueSize = waxLabPrefs.getMidiPlayerQueueSize();
                        if (maxQueueSize < 10) {
                            maxQueueSize = 10;
                        }
                        long ofs = startLineOfs;
                        long end = Long.MAX_VALUE;
                        boolean stopAtEnd = false;
                        float unitRate = 1000000.0f;
                        reader = new MergedMidiTrackReader(midiPlayerModel, ofs, end, stopAtEnd, unitRate, maxQueueSize);
                        reader.start();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                    midiPlayerReader = reader;
                    if (debug != null) {
                        logger.log(debug, " - created MidiTrackReader: " + midiPlayerReader);
                    }
                } else {
                    midiPlayerReader = midiPlayerReaderOld;
                    if (debug != null) {
                        logger.log(debug, " - keeping MidiTrackReader: " + midiPlayerReader);
                    }
                }
            }
            if (enablePlayer && midiPlayerReader != null && targetProcessor != null) {
                if (midiPlayerOld == null || midiPlayerReader != midiPlayerReaderOld || targetProcessor != midiPlayerTargetOld) {
                    if (debug != null) {
                        logger.log(debug, " - creating MidiPlayer: line=" + this.midiLine + ", reader=" + midiPlayerReader + ", target=" + targetProcessor);
                    }
                    ThreadPool threadPool = mediator.getLoaderThreadPool();
                    Clock clock = mediator.getClock();
                    SyncMediator syncClock = mediator;
                    midiPlayer = new WaxLabMidiPlayer((MidiTrackReader)midiPlayerReader, midiFilter, targetProcessor, clock, syncClock, threadPool);
                    long startTimeBase = mediator.getStartTimeBase() - mediator.getStartLineOfs();
                    midiPlayer.setStartTimeBase(startTimeBase);
                    midiPlayer.startup();
                    if (debug != null) {
                        logger.log(debug, " - created MidiPlayer: " + midiPlayer);
                    }
                } else {
                    midiPlayer = midiPlayerOld;
                    if (midiPlayer != null && midiFilter != midiFilterOld) {
                        midiPlayer.setMidiFilter(midiFilter);
                    }
                    if (debug != null) {
                        logger.log(debug, " - keeping MidiPlayer: " + midiPlayer);
                    }
                }
            }
            boolean bl = syncFeatureChanged = syncFeature != syncFeatureOld;
            if (!syncFeatureChanged && targetProcessor == midiPlayerTargetOld && midiPlayerModel == midiPlayerModelOld && midiPlayerReader == midiPlayerReaderOld && midiPlayer == midiPlayerOld) {
                logger.info("TODO no changes !");
            }
            PlayerInfo info = new PlayerInfo();
            info.midiFilter = midiFilter;
            info.midiPlayerPort = playPort;
            info.midiPlayerModel = midiPlayerModel;
            info.midiPlayerReader = midiPlayerReader;
            info.midiPlayerTarget = targetProcessor;
            info.midiPlayer = midiPlayer;
            info.midiPlayerPrepare = midiPlayerReader != midiPlayerReaderOld;
            this.playerInfoList.add(info);
            this.playerInfoActive = info;
            if (midiPlayer != null && playPort != null) {
                if (midiPlayHandlerOld == null || playPort != midiPlayerPortOld || midiPlayer != midiPlayerOld) {
                    int priority = 100;
                    midiPlayHandler = syncFeature.createMidiOutHandler(info, priority, playPort, midiPlayer);
                    if (debug != null) {
                        logger.log(debug, " - created MidiPlayHandler: " + midiPlayHandler);
                    }
                } else {
                    midiPlayHandler = midiPlayHandlerOld;
                    if (midiPlayHandler != null) {
                        midiPlayHandler.infoObject = info;
                    }
                    if (debug != null) {
                        logger.log(debug, " - keeping MidiPlayHandler: " + midiPlayHandler);
                    }
                }
                info.midiPlayHandler = midiPlayHandler;
            }
            if (syncFeatureOld != null && (syncFeatureChanged || midiPlayHandler != midiPlayHandlerOld)) {
                syncFeatureOld.removeSyncHandler(midiPlayHandlerOld);
            }
            this.syncFeatureOld = syncFeature;
            if (syncFeature != null && (syncFeatureChanged || midiPlayHandler != midiPlayHandlerOld)) {
                syncFeature.insertSyncHandler(midiPlayHandler);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabAudioSyncGroup audioSyncGroup, long lineOfs, long studioTime, long masterTime) {
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiInputPort midiInputPort, long lineOfs, long studioTime, long masterTime) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiOutputPort midiOutputPort, long lineOfs, long studioTime, long masterTime) {
        Object infoObject = syncHandler.getInfoObject();
        if (infoObject != null && infoObject instanceof PlayerInfo) {
            WaxLabMidiPlayer midiPlayer;
            PlayerInfo info = (PlayerInfo)infoObject;
            List list = this.playerInfoList;
            synchronized (list) {
                if (!info.midiPlayerPrepare) {
                    return;
                }
            }
            SyncMediator mediator = this.getMediator();
            if (mediator == null) {
                return;
            }
            long startTimeBase = mediator.getStartTimeBase() - mediator.getStartLineOfs();
            MergedMidiTrackReader midiReader = info.midiPlayerReader;
            if (midiReader != null) {
                midiReader.seek(lineOfs);
            }
            if ((midiPlayer = info.midiPlayer) != null) {
                midiPlayer.setStartTimeBase(startTimeBase);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseSyncHandler(SyncHandler syncHandler) {
        Object infoObject = syncHandler.getInfoObject();
        if (infoObject != null && infoObject instanceof PlayerInfo) {
            MergedMidiTrackReader midiReader;
            PlayerInfo info = (PlayerInfo)infoObject;
            boolean releaseMidiPlayer = true;
            boolean releaseMidiReader = true;
            List list = this.playerInfoList;
            synchronized (list) {
                PlayerInfo active;
                if (!this.playerInfoList.remove(info)) {
                    return;
                }
                if (this.playerInfoActive == info) {
                    this.playerInfoActive = null;
                }
                if ((active = this.playerInfoActive) != null) {
                    releaseMidiPlayer = info.midiPlayer != active.midiPlayer;
                    releaseMidiReader = info.midiPlayerReader != active.midiPlayerReader;
                }
            }
            WaxLabMidiPlayer midiPlayer = info.midiPlayer;
            if (midiPlayer != null) {
                info.midiPlayer = null;
                if (releaseMidiPlayer) {
                    try {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Stopping MidiPlayer: " + midiPlayer);
                        }
                        midiPlayer.shutdown();
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            if ((midiReader = info.midiPlayerReader) != null) {
                info.midiPlayerReader = null;
                if (releaseMidiReader) {
                    try {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Closing MidiTrackReader: " + midiReader);
                        }
                        midiReader.close();
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            info.midiPlayerPort = null;
            info.midiPlayHandler = null;
            info.midiFilter = null;
            info.midiPlayerModel = null;
            info.midiPlayerTarget = null;
            return;
        }
    }

    protected class WidgetMidiPlayer
    extends AbstractLineWidget {
        public static final String NAME = "MidiPlayer";
        public static final String TOOLTIP = "Midi Playback";

        public WidgetMidiPlayer(AbstractLine line) {
            super(line, NAME);
            this.setTooltip(TOOLTIP);
        }

        @Override
        protected Icon createDisabledIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_disabled_icon16.png");
        }

        @Override
        protected Icon createEnabledIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_enabled_icon16.png");
        }

        @Override
        protected Icon createActiveIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_active_icon16.png");
        }

        @Override
        protected synchronized void setSelected(boolean selected) {
            super.setSelected(selected);
            FeatureMidiLinePlayer.this.checkEnable();
        }
    }

    protected static class PlayerInfo {
        protected boolean midiPlayerPrepare;
        protected MidiFilter midiFilter;
        protected WaxLabMidiOutputPort midiPlayerPort;
        protected DefaultChunkModel midiPlayerModel;
        protected MergedMidiTrackReader midiPlayerReader;
        protected MidiProcessor midiPlayerTarget;
        protected WaxLabMidiPlayer midiPlayer;
        protected SyncHandler.MidiOutHandler midiPlayHandler;

        protected PlayerInfo() {
        }
    }
}

