/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import com.spacekiller.util.lock.LockSupport;
import com.spacekiller.util.midi.MidiFilter;
import com.spacekiller.util.midi.file.TrackModelFile;
import com.spacekiller.util.thread.ThreadPool;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.MidiChunk;
import com.waxmonster.model.MidiModel;
import com.waxmonster.model.MutableChunkModel;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.impl.CachedMidiModel;
import com.waxmonster.model.impl.MidiTrackWriter;
import com.waxmonster.model.impl.RealMidiTrackWriter;
import com.waxmonster.studio.SyncClock;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.WaxLabPreferences;
import com.waxmonster.waxlab.impl.AbstractLine;
import com.waxmonster.waxlab.impl.AbstractLineWidget;
import com.waxmonster.waxlab.impl.CommonLineFeature;
import com.waxmonster.waxlab.impl.DefaultMidiLine;
import com.waxmonster.waxlab.impl.SyncFeature;
import com.waxmonster.waxlab.impl.SyncHandler;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiSyncGroup;
import com.waxmonster.waxlab.proc.WaxLabMidiRecorder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class FeatureMidiLineRecorder
extends CommonLineFeature {
    private static final Logger logger = Platform.getLogger(FeatureMidiLineRecorder.class);
    private static final int MIN_WRITER_QUEUE_SIZE = 10;
    public static final String NAME = "MidiLineRecorder";
    private final DefaultMidiLine midiLine;
    private final WidgetMidiRecorder widgetMidiRecorder;
    private float recordingTickRate;
    private MidiFilter recordingMidiFilter;
    private WaxLabPortInfo recordingPort;
    private SyncFeature syncFeatureOld;
    private List recorderInfoList;
    private RecorderInfo recorderInfoActive;

    public FeatureMidiLineRecorder(DefaultMidiLine midiLine) {
        super(midiLine, NAME);
        this.midiLine = midiLine;
        this.widgetMidiRecorder = new WidgetMidiRecorder(midiLine);
        this.recorderInfoList = new ArrayList();
    }

    public final DefaultMidiLine getMidiLine() {
        return this.midiLine;
    }

    public final WidgetMidiRecorder getWidgetMidiRecorder() {
        return this.widgetMidiRecorder;
    }

    protected synchronized void checkEnable() {
        this.setEnabled(this.widgetMidiRecorder.isSelected());
    }

    @Override
    protected void fireFeatureSynced() {
        super.fireFeatureSynced();
        boolean active = this.isActive();
        this.widgetMidiRecorder.setActive(active);
    }

    public synchronized WaxLabPortInfo getRecordingPort() {
        return this.recordingPort;
    }

    public synchronized void setRecordingPort(WaxLabPortInfo recordingPort) {
        if (this.recordingPort == recordingPort) {
            return;
        }
        this.recordingPort = recordingPort;
        this.invalidate();
    }

    public synchronized float getRecordingTickRate() {
        return this.recordingTickRate;
    }

    public synchronized void setRecordingTickRate(float recordingTickRate) {
        if (this.recordingTickRate == recordingTickRate) {
            return;
        }
        this.recordingTickRate = recordingTickRate;
        this.invalidate();
    }

    public synchronized MidiFilter getRecordingMidiFilter() {
        return this.recordingMidiFilter;
    }

    public synchronized void setRecordingMidiFilter(MidiFilter recordingMidiFilter) {
        if (this.recordingMidiFilter == recordingMidiFilter) {
            return;
        }
        this.recordingMidiFilter = recordingMidiFilter;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void mediateFeature(SyncFeature syncFeature) {
        SyncMediator mediator = this.getMediator();
        if (mediator == null) {
            return;
        }
        SyncFeature syncFeatureOld = this.syncFeatureOld;
        Level debug = Level.FINE;
        if (!logger.isLoggable(debug)) {
            debug = null;
        }
        try {
            boolean syncFeatureChanged;
            MidiFilter midiFilter;
            float tickRate;
            WaxLabPortInfo recPortInfo = this.getRecordingPort();
            WaxLabMidiInputPort recPort = FeatureMidiLineRecorder.validateMidiInputPort(recPortInfo);
            WaxLabMidiSyncGroup recSyncGroup = FeatureMidiLineRecorder.validateMidiSyncGroup(recPort);
            if (recSyncGroup == null) {
                recPort = null;
            }
            if ((tickRate = this.getRecordingTickRate()) <= 0.0f) {
                tickRate = 9000.0f;
            }
            if ((midiFilter = this.getRecordingMidiFilter()) == null) {
                midiFilter = MidiFilter.ACCEPT_ALL_FILTER;
            }
            long startLineOfs = syncFeature.getStartLineOfs();
            if (debug != null) {
                logger.log(debug, "mediate: " + this.midiLine + ", recPort=" + (Object)((Object)recPort));
            }
            boolean enableRecorder = this.isEnabled();
            if (recPort == null) {
                enableRecorder = false;
            }
            float tickRateOld = 0.0f;
            MidiFilter midiFilterOld = null;
            WaxLabMidiInputPort midiRecorderPortOld = null;
            WaxLabMidiRecorder midiRecorderOld = null;
            MidiTrackWriter midiRecorderWriterOld = null;
            SyncHandler.MidiProcHandler midiRecHandlerOld = null;
            MidiModel midiRecorderModelOld = null;
            MidiChunk midiRecorderChunkOld = null;
            RecorderInfo prevInfo = this.recorderInfoActive;
            if (prevInfo != null) {
                tickRateOld = prevInfo.tickRate;
                midiFilterOld = prevInfo.midiFilter;
                midiRecorderPortOld = prevInfo.midiRecorderPort;
                midiRecorderOld = prevInfo.midiRecorder;
                midiRecorderWriterOld = prevInfo.midiRecorderWriter;
                midiRecHandlerOld = prevInfo.midiRecHandler;
                midiRecorderModelOld = prevInfo.midiRecorderModel;
                midiRecorderChunkOld = prevInfo.midiRecorderChunk;
            }
            WaxLabMidiRecorder midiRecorder = null;
            MidiTrackWriter midiRecorderWriter = null;
            SyncHandler.MidiProcHandler midiRecHandler = null;
            MidiModel midiRecorderModel = null;
            MidiChunk midiRecorderChunk = null;
            WaxLab waxLab = mediator.getWaxLab();
            if (enableRecorder && recPort != null && waxLab != null && tickRate > 0.0f) {
                if (midiRecorderModelOld == null || tickRate != tickRateOld || recPort != midiRecorderPortOld) {
                    if (debug != null) {
                        logger.log(debug, " - creating CachedMidiModel: line=" + this.midiLine + ", tickRate=" + tickRate);
                    }
                    String timestampString = mediator.getTimestampString();
                    String fileNamePrefix = FeatureMidiLineRecorder.buildFileNamePrefix(waxLab, this.midiLine, timestampString);
                    TrackModelFile trackModelFile = null;
                    CachedMidiModel cachedMidiModel = null;
                    try {
                        trackModelFile = waxLab.createNewMidiTrackFile(fileNamePrefix, tickRate);
                        boolean readOnly = false;
                        cachedMidiModel = waxLab.createCachedMidiModel(trackModelFile, readOnly);
                        cachedMidiModel.addNode(cachedMidiModel.newNode(0L, 250));
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                    finally {
                        if (cachedMidiModel == null && trackModelFile != null) {
                            try {
                                trackModelFile.close();
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, e.getMessage(), e);
                            }
                            trackModelFile = null;
                        }
                    }
                    midiRecorderModel = cachedMidiModel;
                    if (debug != null) {
                        logger.log(debug, " - created CachedMidiModel: " + midiRecorderModel);
                    }
                } else {
                    midiRecorderModel = midiRecorderModelOld;
                    if (debug != null) {
                        logger.log(debug, " - keeping CachedMidiModel: " + midiRecorderModel);
                    }
                }
            }
            if (enableRecorder && midiRecorderModel != null) {
                if (midiRecorderChunkOld == null || midiRecorderModel != midiRecorderModelOld) {
                    if (debug != null) {
                        logger.log(debug, " - creating MidiRecorderChunk: model=" + midiRecorderModel);
                    }
                    long chunkOfs = startLineOfs;
                    long chunkEnd = Long.MAX_VALUE;
                    long modelOfs = 0L;
                    long modelEnd = Long.MAX_VALUE;
                    midiRecorderChunk = (MidiChunk)midiRecorderModel.createLineChunk(chunkOfs, chunkEnd, modelOfs, modelEnd);
                    this.midiLine.setRecChunk((LineChunk)midiRecorderChunk);
                    this.midiLine.getMutableChunkModel().addChunk((LineChunk)midiRecorderChunk);
                    if (debug != null) {
                        logger.log(debug, " - created MidiRecorderChunk: " + midiRecorderChunk);
                    }
                } else {
                    midiRecorderChunk = midiRecorderChunkOld;
                    if (debug != null) {
                        logger.log(debug, " - keeping MidiRecorderChunk: " + midiRecorderChunk);
                    }
                }
            }
            if (enableRecorder && midiRecorderModel != null && midiRecorderChunk != null) {
                if (midiRecorderWriterOld == null || midiRecorderModel != midiRecorderModelOld || midiRecorderChunk != midiRecorderChunkOld) {
                    if (debug != null) {
                        logger.log(debug, " - creating MidiTrackWriter: model=" + midiRecorderModel);
                    }
                    RealMidiTrackWriter writer = null;
                    try {
                        WaxLabPreferences waxLabPrefs = mediator.getWaxLabPreferences();
                        int queueSize = waxLabPrefs.getMidiRecorderQueueSize();
                        if (queueSize < 10) {
                            queueSize = 10;
                        }
                        LockSupport lockSupport = mediator.getLockSupport();
                        ThreadPool threadPool = mediator.getWriterThreadPool();
                        SyncMediator syncClock = mediator;
                        writer = new RealMidiTrackWriter(midiRecorderModel, midiRecorderChunk, (SyncClock)syncClock, queueSize, lockSupport, threadPool);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                    midiRecorderWriter = writer;
                    if (debug != null) {
                        logger.log(debug, " - created MidiTrackWriter: " + midiRecorderWriter);
                    }
                } else {
                    midiRecorderWriter = midiRecorderWriterOld;
                    if (debug != null) {
                        logger.log(debug, " - keeping MidiTrackWriter: " + midiRecorderWriter);
                    }
                }
            }
            if (enableRecorder && midiRecorderModel != null && midiRecorderWriter != null) {
                if (midiRecorderOld == null || midiRecorderWriter != midiRecorderWriterOld) {
                    midiRecorder = new WaxLabMidiRecorder(midiRecorderModel, midiRecorderWriter, midiFilter);
                    long startTimeBase = mediator.getStartTimeBase() - mediator.getStartLineOfs();
                    midiRecorder.setStartTime(startTimeBase);
                    if (debug != null) {
                        logger.log(debug, " - created MidiRecorder: " + midiRecorder);
                    }
                } else {
                    midiRecorder = midiRecorderOld;
                    if (midiRecorder != null && midiFilter != midiFilterOld) {
                        midiRecorder.setMidiFilter(midiFilter);
                    }
                    if (debug != null) {
                        logger.log(debug, " - keeping MidiRecorder: " + midiRecorder);
                    }
                }
            }
            boolean bl = syncFeatureChanged = syncFeature != syncFeatureOld;
            if (!syncFeatureChanged && midiRecorderModel == midiRecorderModelOld && midiRecorderChunk == midiRecorderChunkOld && midiRecorderWriter == midiRecorderWriterOld && midiRecorder == midiRecorderOld) {
                logger.info("TODO no changes !");
            }
            RecorderInfo info = new RecorderInfo();
            info.tickRate = tickRate;
            info.midiFilter = midiFilter;
            info.midiRecorderPort = recPort;
            info.midiRecorderModel = midiRecorderModel;
            info.midiRecorderChunk = midiRecorderChunk;
            info.midiRecorderWriter = midiRecorderWriter;
            info.midiRecorder = midiRecorder;
            info.midiRecorderPrepare = midiRecorderChunk != midiRecorderChunkOld;
            this.recorderInfoList.add(info);
            this.recorderInfoActive = info;
            if (midiRecorder != null) {
                if (midiRecHandlerOld == null || midiRecorder != midiRecorderOld) {
                    int priority = 600;
                    midiRecHandler = syncFeature.createMidiProcHandler(info, priority, recPort, midiRecorder);
                    if (debug != null) {
                        logger.log(debug, " - created MidiRecorderHandler: " + midiRecHandler);
                    }
                } else {
                    midiRecHandler = midiRecHandlerOld;
                    if (midiRecHandler != null) {
                        midiRecHandler.infoObject = info;
                    }
                    if (debug != null) {
                        logger.log(debug, " - keeping MidiRecorderHandler: " + midiRecHandler);
                    }
                }
                info.midiRecHandler = midiRecHandler;
            }
            if (syncFeatureOld != null && (syncFeatureChanged || midiRecHandler != midiRecHandlerOld)) {
                syncFeatureOld.removeSyncHandler(midiRecHandlerOld);
            }
            this.syncFeatureOld = syncFeature;
            if (syncFeature != null && (syncFeatureChanged || midiRecHandler != midiRecHandlerOld)) {
                syncFeature.insertSyncHandler(midiRecHandler);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabAudioSyncGroup audioSyncGroup, long lineOfs, long studioTime, long masterTime) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiInputPort midiInputPort, long lineOfs, long studioTime, long masterTime) {
        Object infoObject = syncHandler.getInfoObject();
        if (infoObject != null && infoObject instanceof RecorderInfo) {
            RecorderInfo info = (RecorderInfo)infoObject;
            List list = this.recorderInfoList;
            synchronized (list) {
                if (!info.midiRecorderPrepare) {
                    return;
                }
            }
            SyncMediator mediator = this.getMediator();
            if (mediator == null) {
                return;
            }
            long startTime = mediator.getStartTimeBase() - mediator.getStartLineOfs();
            MidiChunk midiChunk = info.midiRecorderChunk;
            if (midiChunk == null) {
                return;
            }
            try {
                WaxLabMidiRecorder midiRec;
                MutableChunkModel chunkModel;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("     - prepare MidiRecorder: lineOfs=" + lineOfs + ", chunkLineOfs=" + midiChunk.getChunkOfs() + " -> " + lineOfs + ", startTime=" + startTime);
                }
                if ((chunkModel = this.midiLine.getMutableChunkModel()) != null) {
                    chunkModel.moveChunk((LineChunk)midiChunk, lineOfs, midiChunk.getChunkEnd(), midiChunk.getZOrder());
                }
                if ((midiRec = info.midiRecorder) != null) {
                    midiRec.setStartTime(startTime);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            return;
        }
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiOutputPort midiOutputPort, long lineOfs, long studioTime, long masterTime) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseSyncHandler(SyncHandler syncHandler) {
        Object infoObject = syncHandler.getInfoObject();
        if (infoObject != null && infoObject instanceof RecorderInfo) {
            MidiModel cachedMidiModel;
            MidiTrackWriter realMidiWriter;
            RecorderInfo info = (RecorderInfo)infoObject;
            boolean releaseMidiRecorder = true;
            boolean releaseMidiWriter = true;
            boolean flushRecorderModel = true;
            boolean releaseRecorderChunk = true;
            List list = this.recorderInfoList;
            synchronized (list) {
                RecorderInfo active;
                if (!this.recorderInfoList.remove(info)) {
                    return;
                }
                if (this.recorderInfoActive == info) {
                    this.recorderInfoActive = null;
                }
                if ((active = this.recorderInfoActive) != null) {
                    releaseMidiRecorder = info.midiRecorder != active.midiRecorder;
                    releaseMidiWriter = info.midiRecorderWriter != active.midiRecorderWriter;
                    flushRecorderModel = info.midiRecorderModel != active.midiRecorderModel;
                    releaseRecorderChunk = info.midiRecorderChunk != active.midiRecorderChunk;
                }
            }
            WaxLabMidiRecorder midiRecorder = info.midiRecorder;
            if (midiRecorder != null) {
                info.midiRecorder = null;
                if (releaseMidiRecorder) {
                    try {
                        midiRecorder.shutdown();
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            if ((realMidiWriter = info.midiRecorderWriter) != null) {
                info.midiRecorderWriter = null;
                if (releaseMidiWriter) {
                    try {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Stopping MidiWriter: " + realMidiWriter);
                        }
                        realMidiWriter.close();
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            if ((cachedMidiModel = info.midiRecorderModel) != null && flushRecorderModel) {
                try {
                    cachedMidiModel.flush();
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            MutableChunkModel chunkModel = this.midiLine.getMutableChunkModel();
            MidiChunk midiRecorderChunk = info.midiRecorderChunk;
            if (chunkModel != null && midiRecorderChunk != null && cachedMidiModel != null && releaseRecorderChunk) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Releasing MidiRecorderChunk: " + midiRecorderChunk + " -> " + cachedMidiModel);
                }
                try {
                    long chunkOfs = midiRecorderChunk.getChunkOfs();
                    long modelOfs = midiRecorderChunk.getModelOfs();
                    long chunkEnd = info.stopLineOfs;
                    if (chunkEnd == Long.MIN_VALUE) {
                        logger.info("TODO chunkOfs=" + chunkOfs + ", chunkEnd=" + chunkEnd);
                        chunkEnd = chunkOfs + cachedMidiModel.getNanoLength() - modelOfs;
                    }
                    if (chunkEnd < chunkOfs) {
                        chunkEnd = chunkOfs;
                    }
                    long modelEnd = chunkEnd - chunkOfs + modelOfs;
                    MutableLineChunk recordedMidiChunk = cachedMidiModel.createLineChunk(chunkOfs, chunkEnd, modelOfs, modelEnd);
                    if (this.midiLine.getRecChunk() == midiRecorderChunk) {
                        this.midiLine.setRecChunk(null);
                    }
                    chunkModel.addChunk((LineChunk)recordedMidiChunk);
                    chunkModel.removeChunk((LineChunk)midiRecorderChunk);
                    if (midiRecorderChunk instanceof MutableLineChunk) {
                        ((MutableLineChunk)midiRecorderChunk).close();
                    }
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            info.midiRecorderModel = null;
            info.midiRecorderChunk = null;
            info.midiRecorderPort = null;
            info.midiRecHandler = null;
            return;
        }
    }

    protected class WidgetMidiRecorder
    extends AbstractLineWidget {
        public static final String NAME = "MidiRecorder";
        public static final String TOOLTIP = "Midi Recording";

        public WidgetMidiRecorder(AbstractLine line) {
            super(line, NAME);
            this.setTooltip(TOOLTIP);
        }

        @Override
        protected Icon createDisabledIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_record_disabled_icon16.png");
        }

        @Override
        protected Icon createEnabledIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_record_enabled_icon16.png");
        }

        @Override
        protected Icon createActiveIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_record_active_icon16.png");
        }

        @Override
        protected synchronized void setSelected(boolean selected) {
            super.setSelected(selected);
            FeatureMidiLineRecorder.this.checkEnable();
        }
    }

    protected static class RecorderInfo {
        protected boolean midiRecorderPrepare;
        protected float tickRate;
        protected MidiFilter midiFilter;
        protected WaxLabMidiInputPort midiRecorderPort;
        protected WaxLabMidiRecorder midiRecorder;
        protected SyncHandler.MidiProcHandler midiRecHandler;
        protected MidiTrackWriter midiRecorderWriter;
        protected MidiModel midiRecorderModel;
        protected MidiChunk midiRecorderChunk;
        protected long stopLineOfs = Long.MIN_VALUE;

        protected RecorderInfo() {
        }
    }
}

