/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Tools;
import com.waxmonster.waxlab.impl.AbstractLine;
import com.waxmonster.waxlab.impl.AbstractLineWidget;
import com.waxmonster.waxlab.impl.CommonLineFeature;
import com.waxmonster.waxlab.impl.DefaultTimecodeLine;
import com.waxmonster.waxlab.impl.ScratchManager;
import com.waxmonster.waxlab.impl.SyncFeature;
import com.waxmonster.waxlab.impl.SyncHandler;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import javax.swing.Icon;

public class FeatureTimecodeLine
extends CommonLineFeature {
    public static final String NAME = "TimecodeLine";
    private final DefaultTimecodeLine timecodeLine;
    private final WidgetTimecodeRecorder widgetTimecodeRecorder;
    private final WidgetTimecodeScratcher widgetTimecodeScratcher;
    private final WidgetTimecodePlayer widgetTimecodePlayer;
    private ScratchManager scratchManager;

    public FeatureTimecodeLine(DefaultTimecodeLine timecodeLine, ScratchManager scratchManager) {
        super(timecodeLine, NAME);
        this.timecodeLine = timecodeLine;
        this.scratchManager = scratchManager;
        this.widgetTimecodeRecorder = new WidgetTimecodeRecorder(timecodeLine);
        this.widgetTimecodeScratcher = new WidgetTimecodeScratcher(timecodeLine);
        this.widgetTimecodePlayer = new WidgetTimecodePlayer(timecodeLine);
    }

    public final DefaultTimecodeLine getTimecodeLine() {
        return this.timecodeLine;
    }

    public final WidgetTimecodeRecorder getWidgetTimecodeRecorder() {
        return this.widgetTimecodeRecorder;
    }

    public final WidgetTimecodeScratcher getWidgetTimecodeScratcher() {
        return this.widgetTimecodeScratcher;
    }

    public final WidgetTimecodePlayer getWidgetTimecodePlayer() {
        return this.widgetTimecodePlayer;
    }

    protected ScratchManager getScratchManager() {
        return this.scratchManager;
    }

    protected void setScratchManager(ScratchManager scratchManager) {
        this.scratchManager = scratchManager;
    }

    protected synchronized void checkEnable() {
        boolean enable;
        boolean bl = enable = this.widgetTimecodeRecorder.isSelected() || this.widgetTimecodeScratcher.isSelected() || this.widgetTimecodePlayer.isSelected();
        if (enable == this.isEnabled()) {
            this.invalidate();
        } else {
            this.setEnabled(enable);
        }
    }

    @Override
    protected void fireFeatureSynced() {
        super.fireFeatureSynced();
        boolean active = this.isActive();
        this.widgetTimecodeRecorder.setActive(active);
        this.widgetTimecodeScratcher.setActive(active);
        this.widgetTimecodePlayer.setActive(active);
    }

    @Override
    protected void mediateFeature(SyncFeature syncFeature) {
        SyncMediator mediator = this.getMediator();
        if (mediator == null) {
            return;
        }
        long lineOfs = syncFeature.getStartLineOfs();
        boolean enableRecorder = this.widgetTimecodeRecorder.isSelected();
        boolean enableScratcher = this.widgetTimecodeScratcher.isSelected();
        boolean enablePlayback = this.widgetTimecodePlayer.isSelected();
        this.scratchManager.mediateFeature(mediator, lineOfs, enableRecorder, enableScratcher, enablePlayback);
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabAudioSyncGroup audioSyncGroup, long lineOfs, long studioTime, long masterTime) {
        this.scratchManager.prepareSyncHandler(syncHandler, audioSyncGroup, lineOfs, studioTime, masterTime);
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiInputPort midiInputPort, long lineOfs, long studioTime, long masterTime) {
        this.scratchManager.prepareSyncHandler(syncHandler, midiInputPort, lineOfs, studioTime, masterTime);
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiOutputPort midiOutputPort, long lineOfs, long studioTime, long masterTime) {
        this.scratchManager.prepareSyncHandler(syncHandler, midiOutputPort, lineOfs, studioTime, masterTime);
    }

    @Override
    protected void releaseSyncHandler(SyncHandler syncHandler) {
        this.scratchManager.releaseSyncHandler(syncHandler);
    }

    protected class WidgetTimecodePlayer
    extends AbstractLineWidget {
        public static final String NAME = "TimecodePlayer";
        public static final String TOOLTIP = "Scratch Playback";

        public WidgetTimecodePlayer(AbstractLine line) {
            super(line, NAME);
            this.setTooltip(TOOLTIP);
        }

        @Override
        protected Icon createDisabledIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_disabled_icon16.png");
        }

        @Override
        protected Icon createEnabledIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_enabled_icon16.png");
        }

        @Override
        protected Icon createActiveIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_active_icon16.png");
        }

        @Override
        protected synchronized void setSelected(boolean selected) {
            if (selected == this.isSelected()) {
                return;
            }
            if (selected && FeatureTimecodeLine.this.widgetTimecodeScratcher.isSelected()) {
                return;
            }
            super.setSelected(selected);
            FeatureTimecodeLine.this.checkEnable();
        }
    }

    protected class WidgetTimecodeScratcher
    extends AbstractLineWidget {
        public static final String NAME = "TimecodeScratcher";
        public static final String TOOLTIP = "Real-Time Scratching";

        public WidgetTimecodeScratcher(AbstractLine line) {
            super(line, NAME);
            this.setTooltip(TOOLTIP);
        }

        @Override
        protected Icon createDisabledIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_scratch_disabled_icon16.png");
        }

        @Override
        protected Icon createEnabledIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_scratch_enabled_icon16.png");
        }

        @Override
        protected Icon createActiveIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_scratch_active_icon16.png");
        }

        @Override
        protected synchronized void setSelected(boolean selected) {
            if (selected == this.isSelected()) {
                return;
            }
            if (selected && FeatureTimecodeLine.this.widgetTimecodePlayer.isSelected()) {
                return;
            }
            super.setSelected(selected);
            FeatureTimecodeLine.this.checkEnable();
        }
    }

    protected class WidgetTimecodeRecorder
    extends AbstractLineWidget {
        public static final String NAME = "TimecodeRecorder";
        public static final String TOOLTIP = "Scratch Recording";

        public WidgetTimecodeRecorder(AbstractLine line) {
            super(line, NAME);
            this.setTooltip(TOOLTIP);
        }

        @Override
        protected Icon createDisabledIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_record_disabled_icon16.png");
        }

        @Override
        protected Icon createEnabledIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_record_enabled_icon16.png");
        }

        @Override
        protected Icon createActiveIcon16() {
            return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_record_active_icon16.png");
        }

        @Override
        protected synchronized void setSelected(boolean selected) {
            if (selected == this.isSelected()) {
                return;
            }
            super.setSelected(selected);
            FeatureTimecodeLine.this.checkEnable();
        }
    }
}

