/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Resource;
import com.spacekiller.util.Tools;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.spacekiller.util.sound.DummySampleModel;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleModel;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.editor.InterpolatorRegistry;
import com.waxmonster.editor.WaxEditorModel;
import com.waxmonster.editor.impl.InterpolatedFaderModel;
import com.waxmonster.editor.impl.InterpolatedTimecodeModel;
import com.waxmonster.editor.impl.WaxEditorUtil;
import com.waxmonster.fader.FaderCurve;
import com.waxmonster.fader.impl.FaderCurveUtil;
import com.waxmonster.model.FaderModel;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.impl.old.MergedFaderModelOLD;
import com.waxmonster.model.impl.old.MergedTimecodeModelOLD;
import com.waxmonster.scratch.AudioScratchModel;
import com.waxmonster.scratch.PitchDeck;
import com.waxmonster.scratch.impl.AbstractAudioScratchPlayer;
import com.waxmonster.waxlab.EditorLineConfig;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.WaxLabPreferences;
import com.waxmonster.waxlab.impl.CommonLineFeature;
import com.waxmonster.waxlab.impl.DefaultEditorLine;
import com.waxmonster.waxlab.impl.SyncFeature;
import com.waxmonster.waxlab.impl.SyncHandler;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabAudioOutputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import com.waxmonster.waxlab.impl.WaxLabScratchDeck;
import com.waxmonster.waxlab.old.WaxLabScratchCursorFader;
import com.waxmonster.waxlab.old.WaxLabScratchTarget;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class FeatureZEditorOldPlayer
extends CommonLineFeature {
    private static final Logger logger = Platform.getLogger(FeatureZEditorOldPlayer.class);
    public static final String NAME = "EditorLinePlayer";
    public static final String TOOLTIP = "Scratch-Editor Playback";
    private final DefaultEditorLine editorLine;
    private WaxLabPortInfo[] playbackPorts;
    private Set audioProcessors;
    private boolean editorPlayerIsNew;
    private AudioProcessor editorPlayer;
    private WaxLabAudioOutputPort[] editorPlayerPorts;
    private SampleBuffer editorPlayerOutput;
    private SyncHandler.AudioProcHandler editorPlayHandler;
    private SyncHandler.AudioOutHandler editorOutHandler;

    public FeatureZEditorOldPlayer(DefaultEditorLine editorLine) {
        super(editorLine, NAME);
        this.editorLine = editorLine;
        this.audioProcessors = new HashSet();
    }

    protected Icon createDisabledIcon16() {
        return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_disabled_icon16.png");
    }

    protected Icon createEnabledIcon16() {
        return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_enabled_icon16.png");
    }

    protected Icon createActiveIcon16() {
        return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_active_icon16.png");
    }

    public final DefaultEditorLine getEditorLine() {
        return this.editorLine;
    }

    public synchronized WaxLabPortInfo[] getPlaybackPorts() {
        return this.playbackPorts;
    }

    public synchronized void setPlaybackPorts(WaxLabPortInfo[] playbackPorts) {
        if (FeatureZEditorOldPlayer.equalsPortArray(this.playbackPorts, playbackPorts)) {
            return;
        }
        this.playbackPorts = playbackPorts;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mediateFeature(SyncFeature syncFeature) {
        SyncMediator mediator = this.getMediator();
        if (mediator == null) {
            return;
        }
        try {
            AudioProcessor editorLinePlayer;
            WaxLabAudioOutputPort[] playPorts = FeatureZEditorOldPlayer.validateAudioOutputPorts(-1, this.getPlaybackPorts());
            WaxLabAudioSyncGroup audioSyncGroup = FeatureZEditorOldPlayer.validateAudioSyncGroup(playPorts);
            if (audioSyncGroup == null) {
                playPorts = null;
            }
            int playPortCount = playPorts == null ? 0 : playPorts.length;
            long startLineOfs = syncFeature.getStartLineOfs();
            if (audioSyncGroup != null) {
                this.editorLine.setAudioSyncGroup(audioSyncGroup);
            }
            if ((editorLinePlayer = this.editorPlayer) != null) {
                logger.info("TODO check existing editorLinePlayer: " + editorLinePlayer);
                editorLinePlayer = null;
            }
            DoubleArraySampleBuffer editorPlayerOutput = null;
            if (editorLinePlayer == null && playPortCount > 0) {
                float frameRate;
                int frames;
                int channels;
                SampleBuffer sb;
                if (playPortCount == 1) {
                    WaxLabAudioOutputPort port = playPorts[0];
                    sb = port.getBuffer();
                    channels = sb.getChannels();
                    frames = sb.getSamples() / channels;
                    frameRate = sb.getFrameRate();
                } else {
                    Object outputs = null;
                    channels = (outputs).length;
                    sb = outputs[0];
                    frames = sb.getSamples();
                    frameRate = sb.getFrameRate();
                }
                editorPlayerOutput = audioSyncGroup.createPlayBuffer(channels, frames, frameRate);
                DummySampleModel audioModel = new DummySampleModel(channels, frameRate);
                MediaEntry mediaEntry = null;
                double startTimePos = startLineOfs / 1000000L;
                editorLinePlayer = this.createWaxLabEditorPlayer(startTimePos, (SampleBuffer)editorPlayerOutput, (SampleModel)audioModel, mediaEntry);
                if (editorLinePlayer != null) {
                    Set set = this.audioProcessors;
                    synchronized (set) {
                        this.audioProcessors.add(editorLinePlayer);
                    }
                }
            }
            Object info = null;
            this.editorPlayerIsNew = editorLinePlayer != this.editorPlayer;
            this.editorPlayer = editorLinePlayer;
            this.editorPlayerPorts = playPorts;
            this.editorPlayerOutput = editorPlayerOutput;
            SyncHandler.AudioProcHandler oldPlayHandler = this.editorPlayHandler;
            this.editorPlayHandler = null;
            if (editorLinePlayer != null) {
                this.editorPlayHandler = syncFeature.createAudioProcHandler(info, 300, audioSyncGroup, editorLinePlayer);
                syncFeature.insertSyncHandler(this.editorPlayHandler);
            }
            if (oldPlayHandler != null) {
                syncFeature.removeSyncHandler(oldPlayHandler);
            }
            SyncHandler.AudioOutHandler oldOutHandler = this.editorOutHandler;
            this.editorOutHandler = null;
            if (editorPlayerOutput != null) {
                this.editorOutHandler = syncFeature.createAudioOutHandler(null, 100, audioSyncGroup, playPorts, (SampleBuffer)editorPlayerOutput);
                syncFeature.insertSyncHandler(this.editorOutHandler);
            }
            if (oldOutHandler != null) {
                syncFeature.removeSyncHandler(oldOutHandler);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabAudioSyncGroup audioSyncGroup, long lineOfs, long studioTime, long masterTime) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("prepareSyncHandler: " + syncHandler + ", lineOfs=" + lineOfs + ", audioSyncGroup=" + (Object)((Object)audioSyncGroup));
        }
        if (syncHandler == null) {
            return;
        }
        if (syncHandler == this.editorPlayHandler) {
            try {
                if (this.editorPlayerIsNew) {
                    throw new UnsupportedOperationException("TODO prepareSyncHandler: " + syncHandler + ", lineOfs=" + lineOfs);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            return;
        }
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiInputPort midiInputPort, long lineOfs, long studioTime, long masterTime) {
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiOutputPort midiOutputPort, long lineOfs, long studioTime, long masterTime) {
    }

    protected AudioProcessor createWaxLabEditorPlayer(double startTime, SampleBuffer target, SampleModel audioModel, MediaEntry mediaEntry) throws AudioException {
        ScratchDeck scratchDeck;
        Resource scratchAudioResource;
        double relStartTime;
        WaxLabScratchCursorFader scratchFader;
        double startTrackPos;
        DoubleArraySampleBuffer scratchTargetBuffer;
        double fadeOutMillis;
        EditorLineConfig config = this.editorLine.getEditorLineConfig();
        if (config == null) {
            return null;
        }
        if (!config.isPlaybackEnabled()) {
            return null;
        }
        WaxEditorModel[] editorModels = this.editorLine.getEditorChunks();
        int editorModelCount = editorModels.length;
        float mergeFrameRate = target.getFrameRate();
        InterpolatorRegistry interpolatorRegistry = this.getMediator().getInterpolatorRegistry();
        InterpolatedTimecodeModel[] interTimecodeModels = WaxEditorUtil.createInterpolatedTimecodeModels((float)mergeFrameRate, (WaxEditorModel[])editorModels, (int)editorModelCount, (InterpolatorRegistry)interpolatorRegistry);
        MergedTimecodeModelOLD mergedTimecodeModel = new MergedTimecodeModelOLD(mergeFrameRate);
        mergedTimecodeModel.addTimecodeModels((TimecodeModel[])interTimecodeModels);
        MergedTimecodeModelOLD timecodeModel = mergedTimecodeModel;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("MergedTimecodeModel: editorModels=" + editorModels.length + ", interTimecodeModels=" + interTimecodeModels.length);
        }
        double startTrackAnc = 0.0;
        try {
            int tcFirstIndex = (int)(startTime * (double)mergeFrameRate / 1000.0);
            if (tcFirstIndex >= 0 && (long)tcFirstIndex < mergedTimecodeModel.getSamples()) {
                double[] firstTimecodePos = new double[1];
                mergedTimecodeModel.get((long)tcFirstIndex, firstTimecodePos, 0, 1);
                startTrackAnc = firstTimecodePos[0];
            }
        }
        catch (IOException e) {
            throw new AudioException((Throwable)e);
        }
        WaxLabPreferences waxLabPreferences = this.getMediator().getWaxLabPreferences();
        double fadeInMillis = waxLabPreferences.getEditorFadeInMillis();
        if (fadeInMillis < 0.0) {
            fadeInMillis = 10.0;
        }
        if ((fadeOutMillis = waxLabPreferences.getEditorFadeOutMillis()) < 0.0) {
            fadeOutMillis = 10.0;
        }
        MergedFaderModelOLD faderModel = null;
        InterpolatedFaderModel[] interFaderModels = WaxEditorUtil.createInterpolatedFaderModels((float)mergeFrameRate, (WaxEditorModel[])editorModels, (int)editorModelCount, (InterpolatorRegistry)interpolatorRegistry, (double)fadeInMillis, (double)fadeOutMillis);
        if (interFaderModels.length > 0) {
            MergedFaderModelOLD mergedFaderModel = new MergedFaderModelOLD(mergeFrameRate);
            mergedFaderModel.addFaderModels((FaderModel[])interFaderModels);
            faderModel = mergedFaderModel;
        }
        FaderCurve faderCurve = null;
        if (faderModel != null && (faderCurve = config.getFaderCurve()) == null) {
            boolean crossfader = false;
            faderCurve = FaderCurveUtil.createDefaultFaderCurve((String)"Default Curve", (boolean)crossfader);
        }
        if (target instanceof DoubleArraySampleBuffer) {
            scratchTargetBuffer = (DoubleArraySampleBuffer)target;
        } else {
            int channels = target.getChannels();
            int samples = target.getSamples();
            float rate = target.getFrameRate();
            scratchTargetBuffer = new DoubleArraySampleBuffer(channels, samples, rate, new double[samples]);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("createEditorLinePlayer: editorLine=" + this.editorLine + ", startTime=" + startTime + ", tcModel=" + timecodeModel + ", faderModel=" + faderModel + ", faderCurve=" + faderCurve);
        }
        double volumeFactor = config.getVolumeFactor();
        int pitchMode = 0;
        double pitchFactor = config.getPitchFactor();
        double pitchBPM = 0.0;
        PitchDeck pitchDeck = null;
        double beatJump = 1.0;
        float resampleRate = config.getResampleRate();
        AbstractAudioScratchPlayer audioScratchPlayer = this.createAudioScratchPlayer(this.editorLine, startTime, (TimecodeModel)timecodeModel, beatJump, audioModel, resampleRate, mediaEntry, startTrackPos = 0.0, volumeFactor, pitchMode, pitchFactor, pitchBPM, pitchDeck, scratchTargetBuffer);
        Object scratchProcessor = audioScratchPlayer;
        if (scratchProcessor == null) {
            return null;
        }
        if (faderModel != null && faderCurve != null && (scratchFader = this.createFadedAudioProcessor((AudioProcessor)scratchProcessor, scratchTargetBuffer, this.editorLine, (FaderModel)faderModel, relStartTime = startTime, faderCurve)) != null) {
            scratchProcessor = scratchFader;
        }
        if (scratchTargetBuffer != target) {
            WaxLabScratchTarget playerWrapper = new WaxLabScratchTarget((AudioProcessor)scratchProcessor, (SampleBuffer)scratchTargetBuffer, target);
            scratchProcessor = playerWrapper;
        }
        if ((scratchAudioResource = this.editorLine.getScratchAudioResource()) != null && (scratchDeck = this.editorLine.getScratchDeck()) != null && scratchDeck instanceof WaxLabScratchDeck) {
            WaxLabScratchDeck deck = (WaxLabScratchDeck)scratchDeck;
            Object scratchMediaEntry = null;
            AudioScratchModel asm = deck.getScratchModel();
            if (asm != null) {
                asm.setAnchor(-startTrackAnc);
            }
        }
        return scratchProcessor;
    }

    @Override
    protected void releaseSyncHandler(SyncHandler syncHandler) {
        logger.warning("TODO releaseSyncHandler: " + syncHandler);
    }

    protected static class PlayerInfo {
        private boolean infoNew;

        protected PlayerInfo() {
        }
    }
}

