/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.spacekiller.util.sound.DummySampleModel;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleModel;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.model.FaderModel;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.impl.old.MergedFaderModelOLD;
import com.waxmonster.model.impl.old.MergedTimecodeModelOLD;
import com.waxmonster.waxlab.TimecodeLineConfig;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.impl.CommonLineFeature;
import com.waxmonster.waxlab.impl.DefaultTimecodeLine;
import com.waxmonster.waxlab.impl.SyncFeature;
import com.waxmonster.waxlab.impl.SyncHandler;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabAudioOutputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabLiveFeeder;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class FeatureZTimecodeOldPlayer
extends CommonLineFeature {
    private static final Logger logger = Platform.getLogger(FeatureZTimecodeOldPlayer.class);
    public static final String NAME = "TimecodeLinePlayer";
    public static final String TOOLTIP = "Timecode Playback";
    private final DefaultTimecodeLine timecodeLine;
    private WaxLabPortInfo[] playbackPorts;
    private Set audioProcessors;
    private boolean scratchPlayerIsNew;
    private AudioProcessor scratchPlayer;
    private WaxLabAudioOutputPort[] scratchPlayerPorts;
    private SampleBuffer scratchPlayerOutput;
    private SyncHandler.AudioProcHandler scratchPlayHandler;
    private SyncHandler.AudioOutHandler scratchOutHandler;

    public FeatureZTimecodeOldPlayer(DefaultTimecodeLine timecodeLine) {
        super(timecodeLine, NAME);
        this.timecodeLine = timecodeLine;
        this.audioProcessors = new HashSet();
    }

    protected Icon createDisabledIcon16() {
        return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_disabled_icon16.png");
    }

    protected Icon createEnabledIcon16() {
        return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_enabled_icon16.png");
    }

    protected Icon createActiveIcon16() {
        return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_play_active_icon16.png");
    }

    public final DefaultTimecodeLine getTimecodeLine() {
        return this.timecodeLine;
    }

    public synchronized WaxLabPortInfo[] getPlaybackPorts() {
        return this.playbackPorts;
    }

    public synchronized void setPlaybackPorts(WaxLabPortInfo[] playbackPorts) {
        if (FeatureZTimecodeOldPlayer.equalsPortArray(this.playbackPorts, playbackPorts)) {
            return;
        }
        this.playbackPorts = playbackPorts;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mediateFeature(SyncFeature syncFeature) {
        SyncMediator mediator = this.getMediator();
        if (mediator == null) {
            return;
        }
        try {
            AudioProcessor scratchLinePlayer;
            WaxLabAudioOutputPort[] playPorts = FeatureZTimecodeOldPlayer.validateAudioOutputPorts(-1, this.getPlaybackPorts());
            WaxLabAudioSyncGroup audioSyncGroup = FeatureZTimecodeOldPlayer.validateAudioSyncGroup(playPorts);
            if (audioSyncGroup == null) {
                playPorts = null;
            }
            int playPortCount = playPorts == null ? 0 : playPorts.length;
            long startLineOfs = syncFeature.getStartLineOfs();
            if (audioSyncGroup != null) {
                this.timecodeLine.setAudioSyncGroup(audioSyncGroup);
            }
            if ((scratchLinePlayer = this.scratchPlayer) != null) {
                throw new UnsupportedOperationException("TODO");
            }
            DoubleArraySampleBuffer output = null;
            if (scratchLinePlayer == null && playPortCount > 0) {
                float frameRate;
                int frames;
                int channels;
                SampleBuffer sb;
                if (playPortCount == 1) {
                    WaxLabAudioOutputPort port = playPorts[0];
                    sb = port.getBuffer();
                    channels = sb.getChannels();
                    frames = sb.getSamples() / channels;
                    frameRate = sb.getFrameRate();
                } else {
                    Object outputs = null;
                    channels = (outputs).length;
                    sb = outputs[0];
                    frames = sb.getSamples();
                    frameRate = sb.getFrameRate();
                }
                output = audioSyncGroup.createPlayBuffer(channels, frames, frameRate);
                DummySampleModel audioModel = new DummySampleModel(channels, frameRate);
                MediaEntry mediaEntry = null;
                Object info = null;
                this.scratchPlayerIsNew = true;
                double startTimePos = 0.0;
                scratchLinePlayer = this.createWaxLabTimecodePlayer(startTimePos, (SampleBuffer)output, (SampleModel)audioModel, mediaEntry);
                if (scratchLinePlayer != null) {
                    Object feeder;
                    if (audioModel instanceof WaxLabLiveFeeder) {
                        feeder = (WaxLabLiveFeeder)audioModel;
                        Set set = this.audioProcessors;
                        synchronized (set) {
                            this.audioProcessors.add(feeder);
                        }
                        SyncHandler.AudioProcHandler audioFeedHandler = syncFeature.createAudioProcHandler(info, 700, audioSyncGroup, (AudioProcessor)feeder);
                        syncFeature.insertSyncHandler(audioFeedHandler);
                    }
                    feeder = this.audioProcessors;
                    synchronized (feeder) {
                        this.audioProcessors.add(scratchLinePlayer);
                    }
                    SyncHandler.AudioProcHandler audioProcHandler = syncFeature.createAudioProcHandler(info, 300, audioSyncGroup, scratchLinePlayer);
                    syncFeature.insertSyncHandler(audioProcHandler);
                    SyncHandler.AudioOutHandler audioOutHandler = syncFeature.createAudioOutHandler(null, 100, audioSyncGroup, playPorts, (SampleBuffer)output);
                    syncFeature.insertSyncHandler(audioOutHandler);
                }
            }
            this.scratchPlayer = scratchLinePlayer;
            this.scratchPlayerPorts = playPorts;
            this.scratchPlayerOutput = output;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabAudioSyncGroup audioSyncGroup, long lineOfs, long studioTime, long masterTime) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("prepareSyncHandler: " + syncHandler + ", lineOfs=" + lineOfs + ", audioSyncGroup=" + (Object)((Object)audioSyncGroup));
        }
        if (syncHandler == null) {
            return;
        }
        if (syncHandler instanceof SyncHandler.AudioProcHandler) {
            SyncHandler.AudioProcHandler entry = (SyncHandler.AudioProcHandler)syncHandler;
            try {
                if (this.scratchPlayerIsNew) {
                    throw new UnsupportedOperationException("TODO prepareSyncHandler: " + syncHandler + ", lineOfs=" + lineOfs);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            return;
        }
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiInputPort midiInputPort, long lineOfs, long studioTime, long masterTime) {
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiOutputPort midiOutputPort, long lineOfs, long studioTime, long masterTime) {
    }

    protected AudioProcessor createWaxLabTimecodePlayer(double startTime, SampleBuffer target, SampleModel audioModel, MediaEntry mediaEntry) throws AudioException {
        WaxLab waxLab = this.getMediator().getWaxLab();
        DefaultTimecodeLine tcLine = this.timecodeLine;
        TimecodeLineConfig config = tcLine.getTimecodeLineConfig();
        if (config == null) {
            return null;
        }
        if (!config.isPlaybackEnabled() && !config.isScratchingEnabled()) {
            return null;
        }
        float targetFrameRate = target.getFrameRate();
        if (audioModel == null) {
            return null;
        }
        Object tcModels = null;
        throw new UnsupportedOperationException("TODO");
    }

    protected FaderModel mergeFaderModels(FaderModel[] faderModels, float frameRate) throws AudioException {
        MergedFaderModelOLD mfm = new MergedFaderModelOLD(frameRate);
        mfm.addFaderModels(faderModels);
        return mfm;
    }

    protected TimecodeModel mergeTimecodeModels(TimecodeModel[] tcModels, float frameRate) throws AudioException {
        MergedTimecodeModelOLD mtm = new MergedTimecodeModelOLD(frameRate);
        mtm.addTimecodeModels(tcModels);
        return mtm;
    }

    @Override
    protected void releaseSyncHandler(SyncHandler syncHandler) {
        logger.warning("TODO releaseSyncHandler: " + syncHandler);
    }

    protected static class PlayerInfo {
        private boolean infoNew;

        protected PlayerInfo() {
        }
    }
}

