/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.sound.AudioFile;
import com.spacekiller.util.sound.DefaultSampleCursor;
import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.spacekiller.util.sound.FloatArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleCursor;
import com.spacekiller.util.sound.SampleModel;
import com.spacekiller.util.thread.ThreadPool;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.model.AudioModel;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.impl.CachedAudioModel;
import com.waxmonster.model.impl.RealAudioModel;
import com.waxmonster.timecode.TimecodeFormat;
import com.waxmonster.waxlab.TimecodeLineConfig;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.WaxLabPreferences;
import com.waxmonster.waxlab.impl.AbstractScratchModeControl;
import com.waxmonster.waxlab.impl.CommonLineFeature;
import com.waxmonster.waxlab.impl.DefaultTimecodeLine;
import com.waxmonster.waxlab.impl.SyncFeature;
import com.waxmonster.waxlab.impl.SyncHandler;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabAudioInputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioJoinerInfo;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.swing.Icon;

public class FeatureZTimecodeOldRecorder
extends CommonLineFeature {
    private static final Logger logger = Platform.getLogger(FeatureZTimecodeOldRecorder.class);
    public static final String NAME = "TimecodeLineRecorder";
    public static final String TOOLTIP = "Timecode Recording";
    private final DefaultTimecodeLine timecodeLine;
    private WaxLabPortInfo[] recordingPorts;
    private Set audioProcessors;
    private AudioProcessor scratchRecorder;
    private boolean scratchRecorderIsNew;
    private WaxLabAudioInputPort[] scratchRecorderPorts;
    private WaxLabAudioJoinerInfo scratchRecorderJoiner;
    private TimecodeModel scratchRecorderModel;

    public FeatureZTimecodeOldRecorder(DefaultTimecodeLine timecodeLine) {
        super(timecodeLine, NAME);
        this.timecodeLine = timecodeLine;
        this.audioProcessors = new HashSet();
    }

    protected Icon createDisabledIcon16() {
        return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_record_disabled_icon16.png");
    }

    protected Icon createEnabledIcon16() {
        return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_record_enabled_icon16.png");
    }

    protected Icon createActiveIcon16() {
        return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_record_active_icon16.png");
    }

    public final DefaultTimecodeLine getTimecodeLine() {
        return this.timecodeLine;
    }

    public synchronized WaxLabPortInfo[] getRecordingPorts() {
        return this.recordingPorts;
    }

    public synchronized void setRecordingPorts(WaxLabPortInfo[] recordingPorts) {
        if (FeatureZTimecodeOldRecorder.equalsPortArray(this.recordingPorts, recordingPorts)) {
            return;
        }
        this.recordingPorts = recordingPorts;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mediateFeature(SyncFeature syncFeature) {
        SyncMediator mediator = this.getMediator();
        if (mediator == null) {
            return;
        }
        try {
            WaxLabAudioInputPort[] recPorts = FeatureZTimecodeOldRecorder.validateAudioInputPorts(this.getRecordingPorts(), -1);
            WaxLabAudioSyncGroup audioSyncGroup = FeatureZTimecodeOldRecorder.validateAudioSyncGroup(recPorts);
            if (audioSyncGroup == null) {
                recPorts = null;
            }
            int recPortCount = recPorts == null ? 0 : recPorts.length;
            long startLineOfs = syncFeature.getStartLineOfs();
            if (audioSyncGroup != null) {
                this.timecodeLine.setAudioSyncGroup(audioSyncGroup);
            }
            WaxLabAudioJoinerInfo recJoiner = null;
            AudioProcessor scratchLineRecorder = this.scratchRecorder;
            if (scratchLineRecorder != null) {
                throw new UnsupportedOperationException("TODO");
            }
            if (scratchLineRecorder == null && recPortCount > 0) {
                SampleBuffer source = null;
                if (recPortCount == 1) {
                    source = recPorts[0].getBuffer();
                    recJoiner = null;
                    if (source != null && !(source instanceof DoubleArraySampleBuffer)) {
                        // empty if block
                    }
                } else {
                    recJoiner = audioSyncGroup.setupAudioJoiner(recPorts);
                    if (recJoiner != null) {
                        source = recJoiner.getOutput();
                    }
                }
                if (source != null) {
                    Object info = null;
                    this.scratchRecorderIsNew = true;
                    double startTimePos = 0.0;
                    String timestampString = mediator.getTimestampString();
                    scratchLineRecorder = this.createWaxLabTimecodeRecorder(startTimePos, timestampString, source);
                    if (scratchLineRecorder != null) {
                        Object joiner;
                        if (recJoiner != null && (joiner = recJoiner.getJoiner()) != null) {
                            Set set = this.audioProcessors;
                            synchronized (set) {
                                this.audioProcessors.add(joiner);
                            }
                            SyncHandler.AudioProcHandler audioRecJoinerHandler = syncFeature.createAudioProcHandler(null, 900, audioSyncGroup, (AudioProcessor)joiner);
                            syncFeature.insertSyncHandler(audioRecJoinerHandler);
                        }
                        joiner = this.audioProcessors;
                        synchronized (joiner) {
                            this.audioProcessors.add(scratchLineRecorder);
                        }
                        SyncHandler.AudioProcHandler audioScratchRecHandler = syncFeature.createAudioProcHandler(info, 600, audioSyncGroup, scratchLineRecorder);
                        syncFeature.insertSyncHandler(audioScratchRecHandler);
                    }
                }
            }
            this.scratchRecorder = scratchLineRecorder;
            this.scratchRecorderPorts = recPorts;
            this.scratchRecorderJoiner = recJoiner;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabAudioSyncGroup audioSyncGroup, long lineOfs, long studioTime, long masterTime) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("prepareSyncHandler: " + syncHandler + ", lineOfs=" + lineOfs + ", audioSyncGroup=" + (Object)((Object)audioSyncGroup));
        }
        if (syncHandler == null) {
            return;
        }
        if (!(syncHandler instanceof SyncHandler.AudioProcHandler)) return;
        SyncHandler.AudioProcHandler entry = (SyncHandler.AudioProcHandler)syncHandler;
        try {
            TimecodeModel timecodeModel;
            if (this.scratchRecorderIsNew && (timecodeModel = this.scratchRecorderModel) == null) return;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiInputPort midiInputPort, long lineOfs, long studioTime, long masterTime) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("prepareSyncHandler: " + syncHandler + ", lineOfs=" + lineOfs + ", midiInputPort=" + (Object)((Object)midiInputPort));
        }
        throw new UnsupportedOperationException("TODO prepareSyncHandler: " + syncHandler + ", lineOfs=" + lineOfs + ", midiInputPort=" + (Object)((Object)midiInputPort));
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiOutputPort midiOutputPort, long lineOfs, long studioTime, long masterTime) {
    }

    protected AudioProcessor createWaxLabTimecodeRecorder(double startTime, String timestampString, SampleBuffer source) throws AudioException {
        WaxLab waxLab = this.getMediator().getWaxLab();
        DefaultTimecodeLine tcLine = this.timecodeLine;
        TimecodeLineConfig lineConfig = tcLine.getTimecodeLineConfig();
        WaxLabPreferences waxLabPreferences = this.getMediator().getWaxLabPreferences();
        LockFactory lockFactory = this.getMediator().getLockFactory();
        ThreadPool writerThreadPool = this.getMediator().getWriterThreadPool();
        int channels = source.getChannels();
        if (channels != 2) {
            throw new AudioException("Invalid number of timecode audio channels: " + channels + " != 2 (stereo)");
        }
        String timecode = lineConfig.getTimecodeFormatName();
        int scratchMode = AbstractScratchModeControl.getTimecodeDecoderMode(lineConfig.getScratchMode());
        if (scratchMode < 0 || scratchMode == 0) {
            scratchMode = 1;
        }
        try {
            AudioFile targetAudioFile;
            TimecodeFormat timecodeFormat = waxLab.getTimecodeFormat(timecode);
            if (timecodeFormat == null) {
                throw new AudioException("Timecode format not found: " + timecode);
            }
            if (!timecodeFormat.isAudioDecoderSupported()) {
                if (timecodeFormat.isMidiDecoderSupported()) {
                    logger.warning("TODO MIDI-Timecode support: timecodeFormat=" + timecodeFormat);
                    throw new UnsupportedOperationException("TODO MIDI-Timecode support: timecodeFormat=" + timecodeFormat);
                }
                throw new UnsupportedOperationException("TimecodeFormat is not supported: " + timecodeFormat);
            }
            float frameRate = source.getFrameRate();
            int recSampleType = 1;
            AudioFormat targetFormat = FeatureZTimecodeOldRecorder.createAudioFormat(channels, frameRate, recSampleType);
            String fileNamePrefix = FeatureZTimecodeOldRecorder.buildFileNamePrefix(waxLab, tcLine, timestampString);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("createTimecodeLineRecorder: format=" + targetFormat);
            }
            if ((targetAudioFile = waxLab.createNewAudioFile(fileNamePrefix, targetFormat)) == null) {
                return null;
            }
            CachedAudioModel cachedAudioModel = waxLab.createCachedAudioModel(targetAudioFile);
            if (cachedAudioModel == null) {
                return null;
            }
            long sampleIndex = 0L;
            boolean batchMode = this.getMediator().isBatchMode();
            if (batchMode) {
                CachedAudioModel targetAudioModel = cachedAudioModel;
                CachedAudioModel targetSampleModel = cachedAudioModel;
                DefaultSampleCursor targetAudioCursor = new DefaultSampleCursor((SampleModel)cachedAudioModel, sampleIndex);
                boolean closeTargetAudioModel = false;
            } else {
                int bufferCount = waxLabPreferences.getTimecodeRecorderBufferCount();
                int bufferSize = channels * (int)((double)waxLabPreferences.getTimecodeRecorderBufferMillis() * (double)frameRate / 1000.0);
                boolean fair = waxLabPreferences.isTimecodeRecorderBufferFair();
                SampleBuffer[] sampleBuffers = new SampleBuffer[bufferCount];
                for (int i = 0; i < bufferCount; ++i) {
                    sampleBuffers[i] = source instanceof FloatArraySampleBuffer ? new FloatArraySampleBuffer(channels, bufferSize, frameRate, new float[bufferSize]) : new DoubleArraySampleBuffer(channels, bufferSize, frameRate, new double[bufferSize]);
                }
                try {
                    RealAudioModel realtimeModel;
                    boolean readOnly = false;
                    boolean closeModel = false;
                    ReadWriteLock bufLock = lockFactory.createReadWriteLock(fair);
                    RealAudioModel targetAudioModel = realtimeModel = new RealAudioModel((AudioModel)cachedAudioModel, (SampleModel)cachedAudioModel, sampleIndex, readOnly, closeModel, bufferCount, bufferSize, sampleBuffers, bufLock, writerThreadPool);
                    RealAudioModel targetSampleModel = realtimeModel;
                    SampleCursor targetAudioCursor = realtimeModel.openRealtimeCursor(sampleIndex);
                    boolean closeTargetAudioModel = true;
                }
                catch (IOException e) {
                    throw new AudioException((Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new AudioException((Throwable)e);
                }
            }
            long lineOfs = 0L;
            int maxBufferFrames = source.getSamples() / channels;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Creating timecode decoder: format=" + timecodeFormat + ", frameRate=" + frameRate + ", maxBufferFrames=" + maxBufferFrames + ", scratchMode=" + scratchMode);
            }
            throw new UnsupportedOperationException("OLD");
        }
        catch (IOException e) {
            throw new AudioException((Throwable)e);
        }
    }

    @Override
    protected void releaseSyncHandler(SyncHandler syncHandler) {
        logger.warning("TODO releaseSyncHandler: " + syncHandler);
    }

    protected static class RecorderInfo {
        private boolean infoNew;

        protected RecorderInfo() {
        }
    }
}

