/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Clock;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Resource;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.Tools;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.LockSupport;
import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.sound.AudioFile;
import com.spacekiller.util.sound.DefaultSampleCursor;
import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.spacekiller.util.sound.DummySampleModel;
import com.spacekiller.util.sound.FloatArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleCursor;
import com.spacekiller.util.sound.SampleModel;
import com.spacekiller.util.thread.ThreadPool;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.midi.MidiException;
import com.waxmonster.midi.MidiSupport;
import com.waxmonster.model.AudioModel;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.impl.CachedAudioModel;
import com.waxmonster.model.impl.RealAudioModel;
import com.waxmonster.scratch.AudioScratchModel;
import com.waxmonster.scratch.AudioScratchPlayer;
import com.waxmonster.scratch.PitchDeck;
import com.waxmonster.scratch.impl.AbstractAudioScratchPlayer;
import com.waxmonster.studio.Port;
import com.waxmonster.timecode.TimecodeFormat;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.ScratchLine;
import com.waxmonster.waxlab.ScratchLineConfig;
import com.waxmonster.waxlab.TimecodeLine;
import com.waxmonster.waxlab.TimecodeLineConfig;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.WaxLabPreferences;
import com.waxmonster.waxlab.impl.AbstractPitchModeControl;
import com.waxmonster.waxlab.impl.AbstractScratchLine;
import com.waxmonster.waxlab.impl.AbstractScratchModeControl;
import com.waxmonster.waxlab.impl.CommonLineFeature;
import com.waxmonster.waxlab.impl.DefaultTimecodeLine;
import com.waxmonster.waxlab.impl.SyncFeature;
import com.waxmonster.waxlab.impl.SyncHandler;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabAudioInputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioJoinerInfo;
import com.waxmonster.waxlab.impl.WaxLabAudioOutputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import com.waxmonster.waxlab.impl.WaxLabLiveFeeder;
import com.waxmonster.waxlab.impl.WaxLabLiveFeederResource;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiSupport;
import com.waxmonster.waxlab.impl.WaxLabScratchDeck;
import com.waxmonster.waxlab.impl.WaxLabScratchDeckMediator;
import com.waxmonster.waxlab.old.WaxLabScratchRecorderOld;
import com.waxmonster.waxlab.old.WaxLabScratchTarget;
import com.waxmonster.waxlab.util.LineWrapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.swing.Icon;

public class FeatureZTimecodeOldScratcher
extends CommonLineFeature {
    private static final Logger logger = Platform.getLogger(FeatureZTimecodeOldScratcher.class);
    public static final String NAME = "TimecodeLineScratcher";
    public static final String TOOLTIP = "Real-Time Scratching";
    private static final int DEFAULT_FADER_QUEUE_SIZE_PER_SECOND = 2000;
    private static final int MIN_FADER_QUEUE_SIZE = 256;
    public static final double DEFAULT_FADER_REACTION_MILLIS = 1.0;
    private final DefaultTimecodeLine timecodeLine;
    private WaxLabPortInfo[] playbackPorts;
    private WaxLabPortInfo[] recordingPorts;
    private WaxLabPortInfo[] liveFeedPorts;
    private Set audioProcessors;
    private AudioProcessor scratchPlayer;
    private boolean scratchPlayerIsNew;
    private WaxLabAudioOutputPort[] scratchPlayerPorts;
    private SampleBuffer scratchPlayerOutput;
    private AudioProcessor scratchRecorder;
    private WaxLabAudioInputPort[] scratchRecorderPorts;
    private WaxLabAudioJoinerInfo scratchRecorderJoiner;
    private TimecodeModel scratchRecorderModel;
    private WaxLabLiveFeeder scratchFeeder;
    private WaxLabAudioInputPort[] scratchFeederPorts;
    private WaxLabAudioJoinerInfo scratchFeederJoiner;

    public FeatureZTimecodeOldScratcher(DefaultTimecodeLine timecodeLine) {
        super(timecodeLine, NAME);
        this.timecodeLine = timecodeLine;
        this.audioProcessors = new HashSet();
    }

    protected Icon createDisabledIcon16() {
        return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_scratch_disabled_icon16.png");
    }

    protected Icon createEnabledIcon16() {
        return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_scratch_enabled_icon16.png");
    }

    protected Icon createActiveIcon16() {
        return Tools.getIcon(this.getClass(), (String)"/com/waxmonster/waxlab/impl/icons/feature_scratch_active_icon16.png");
    }

    public final DefaultTimecodeLine getTimecodeLine() {
        return this.timecodeLine;
    }

    public synchronized WaxLabPortInfo[] getPlaybackPorts() {
        return this.playbackPorts;
    }

    public synchronized void setPlaybackPorts(WaxLabPortInfo[] playbackPorts) {
        if (FeatureZTimecodeOldScratcher.equalsPortArray(this.playbackPorts, playbackPorts)) {
            return;
        }
        this.playbackPorts = playbackPorts;
        this.invalidate();
    }

    public synchronized WaxLabPortInfo[] getRecordingPorts() {
        return this.recordingPorts;
    }

    public synchronized void setRecordingPorts(WaxLabPortInfo[] recordingPorts) {
        if (FeatureZTimecodeOldScratcher.equalsPortArray(this.recordingPorts, recordingPorts)) {
            return;
        }
        this.recordingPorts = recordingPorts;
        this.invalidate();
    }

    public synchronized WaxLabPortInfo[] getLiveFeedPorts() {
        return this.liveFeedPorts;
    }

    public synchronized void setLiveFeedPorts(WaxLabPortInfo[] liveFeedPorts) {
        if (FeatureZTimecodeOldScratcher.equalsPortArray(this.liveFeedPorts, liveFeedPorts)) {
            return;
        }
        this.liveFeedPorts = liveFeedPorts;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mediateFeature(SyncFeature syncFeature) {
        SyncMediator mediator = this.getMediator();
        if (mediator == null) {
            return;
        }
        try {
            WaxLabAudioInputPort[] recPorts;
            WaxLabAudioOutputPort[] playPorts = FeatureZTimecodeOldScratcher.validateAudioOutputPorts(-1, this.getPlaybackPorts());
            WaxLabAudioSyncGroup audioSyncGroup = FeatureZTimecodeOldScratcher.validateAudioSyncGroup(playPorts);
            if (audioSyncGroup == null) {
                playPorts = null;
            }
            int playPortCount = playPorts == null ? 0 : playPorts.length;
            long startLineOfs = syncFeature.getStartLineOfs();
            if (audioSyncGroup != null) {
                this.timecodeLine.setAudioSyncGroup(audioSyncGroup);
            }
            int recPortCount = (recPorts = FeatureZTimecodeOldScratcher.validateAudioInputPorts(this.getRecordingPorts(), -1)) == null ? 0 : recPorts.length;
            WaxLabAudioJoinerInfo recJoiner = null;
            WaxLabAudioInputPort[] feedPorts = FeatureZTimecodeOldScratcher.validateAudioInputPorts(this.getLiveFeedPorts(), -1);
            int feedPortCount = feedPorts == null ? 0 : feedPorts.length;
            WaxLabAudioJoinerInfo feedJoiner = null;
            AudioProcessor scratchLinePlayer = this.scratchPlayer;
            AudioProcessor scratchLineRecorder = this.scratchRecorder;
            WaxLabLiveFeeder scratchLineFeeder = this.scratchFeeder;
            if (scratchLinePlayer != null) {
                throw new UnsupportedOperationException("TODO");
            }
            DoubleArraySampleBuffer output = null;
            if (scratchLinePlayer == null && playPortCount > 0) {
                SampleBuffer source = null;
                if (recPorts.length == 1) {
                    source = recPorts[0].getBuffer();
                    recJoiner = null;
                    if (source != null && !(source instanceof DoubleArraySampleBuffer)) {
                        // empty if block
                    }
                } else {
                    recJoiner = audioSyncGroup.setupAudioJoiner(recPorts);
                    if (recJoiner != null) {
                        source = recJoiner.getOutput();
                    }
                }
                if (source != null) {
                    float frameRate;
                    int frames;
                    int channels;
                    SampleBuffer sb;
                    if (playPortCount == 1) {
                        WaxLabAudioOutputPort port = playPorts[0];
                        sb = port.getBuffer();
                        channels = sb.getChannels();
                        frames = sb.getSamples() / channels;
                        frameRate = sb.getFrameRate();
                    } else {
                        Object outputs = null;
                        channels = (outputs).length;
                        sb = outputs[0];
                        frames = sb.getSamples();
                        frameRate = sb.getFrameRate();
                    }
                    SampleBuffer feedSource = null;
                    Resource audioResource = this.timecodeLine.getScratchAudioResource();
                    DummySampleModel audioModel = null;
                    if (audioResource != null && audioResource instanceof WaxLabLiveFeederResource) {
                        if (feedPortCount == 1) {
                            feedSource = feedPorts[0].getBuffer();
                            feedJoiner = null;
                        } else {
                            feedJoiner = audioSyncGroup.setupAudioJoiner(feedPorts);
                            if (feedJoiner != null) {
                                feedSource = feedJoiner.getOutput();
                            }
                        }
                        if (feedSource != null) {
                            scratchLineFeeder = null;
                            audioModel = (AudioModel)scratchLineFeeder;
                        }
                    }
                    if (audioModel == null) {
                        audioModel = new DummySampleModel(channels, frameRate);
                    }
                    MediaEntry mediaEntry = null;
                    output = audioSyncGroup.createPlayBuffer(channels, frames, frameRate);
                    Object info = null;
                    float audioModelRate = audioModel.getFrameRate();
                    double needlePos = 0.0;
                    double needleFramePos = needlePos * (double)audioModelRate / 1000.0;
                    this.scratchPlayerIsNew = true;
                    double startTimePos = 0.0;
                    String timestampString = mediator.getTimestampString();
                    scratchLinePlayer = this.createWaxLabRealtimeScratcher(startTimePos, timestampString, source, (SampleBuffer)output, (SampleModel)audioModel, mediaEntry, needleFramePos);
                    if (scratchLinePlayer != null) {
                        Object audioFeedHandler;
                        Object audioRecJoinerHandler;
                        Object joiner;
                        if (recJoiner != null && (joiner = recJoiner.getJoiner()) != null) {
                            Set set = this.audioProcessors;
                            synchronized (set) {
                                this.audioProcessors.add(joiner);
                            }
                            audioRecJoinerHandler = syncFeature.createAudioProcHandler(null, 900, audioSyncGroup, (AudioProcessor)joiner);
                            syncFeature.insertSyncHandler((SyncHandler)audioRecJoinerHandler);
                        }
                        if (feedJoiner != null && (joiner = feedJoiner.getJoiner()) != null) {
                            audioRecJoinerHandler = this.audioProcessors;
                            synchronized (audioRecJoinerHandler) {
                                this.audioProcessors.add(joiner);
                            }
                            SyncHandler.AudioProcHandler audioFeedJoinerHandler = syncFeature.createAudioProcHandler(null, 900, audioSyncGroup, (AudioProcessor)joiner);
                            syncFeature.insertSyncHandler(audioFeedJoinerHandler);
                        }
                        if (scratchLineFeeder != null) {
                            joiner = this.audioProcessors;
                            synchronized (joiner) {
                                this.audioProcessors.add(scratchLineFeeder);
                            }
                            audioFeedHandler = syncFeature.createAudioProcHandler(info, 600, audioSyncGroup, scratchLineFeeder);
                            syncFeature.insertSyncHandler((SyncHandler)audioFeedHandler);
                        }
                        audioFeedHandler = this.audioProcessors;
                        synchronized (audioFeedHandler) {
                            this.audioProcessors.add(scratchLinePlayer);
                        }
                        SyncHandler.AudioProcHandler audioProcHandler = syncFeature.createAudioProcHandler(info, 500, audioSyncGroup, scratchLinePlayer);
                        syncFeature.insertSyncHandler(audioProcHandler);
                        SyncHandler.AudioOutHandler audioOutHandler = syncFeature.createAudioOutHandler(null, 100, audioSyncGroup, playPorts, (SampleBuffer)output);
                        syncFeature.insertSyncHandler(audioOutHandler);
                    }
                }
            }
            this.scratchPlayer = scratchLinePlayer;
            this.scratchPlayerPorts = playPorts;
            this.scratchPlayerOutput = output;
            this.scratchRecorder = scratchLineRecorder;
            this.scratchRecorderPorts = recPorts;
            this.scratchRecorderJoiner = recJoiner;
            this.scratchFeeder = scratchLineFeeder;
            this.scratchFeederPorts = feedPorts;
            this.scratchFeederJoiner = feedJoiner;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabAudioSyncGroup audioSyncGroup, long lineOfs, long studioTime, long masterTime) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("prepareSyncHandler: " + syncHandler + ", lineOfs=" + lineOfs + ", audioSyncGroup=" + (Object)((Object)audioSyncGroup));
        }
        if (syncHandler == null) {
            return;
        }
        if (syncHandler instanceof SyncHandler.AudioProcHandler) {
            SyncHandler.AudioProcHandler entry = (SyncHandler.AudioProcHandler)syncHandler;
            try {
                if (this.scratchPlayerIsNew) {
                    throw new UnsupportedOperationException("TODO prepareSyncHandler: " + syncHandler + ", lineOfs=" + lineOfs);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            return;
        }
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiInputPort midiInputPort, long lineOfs, long studioTime, long masterTime) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("prepareSyncHandler: " + syncHandler + ", lineOfs=" + lineOfs + ", midiInputPort=" + (Object)((Object)midiInputPort));
        }
        throw new UnsupportedOperationException("TODO prepareSyncHandler: " + syncHandler + ", lineOfs=" + lineOfs + ", midiInputPort=" + (Object)((Object)midiInputPort));
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiOutputPort midiOutputPort, long lineOfs, long studioTime, long masterTime) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("prepareSyncHandler: " + syncHandler + ", lineOfs=" + lineOfs + ", midiOutputPort=" + (Object)((Object)midiOutputPort));
        }
        throw new UnsupportedOperationException("TODO prepareSyncHandler: " + syncHandler + ", lineOfs=" + lineOfs + ", midiOutputPort=" + (Object)((Object)midiOutputPort));
    }

    protected AudioProcessor createWaxLabRealtimeScratcher(double startTime, String timestampString, SampleBuffer source, SampleBuffer target, SampleModel audioModel, MediaEntry mediaEntry, double needleFramePos) throws AudioException {
        boolean midiTimecodeInput;
        SampleBuffer stereoTimecodeInput;
        TimecodeFormat timecodeFormat;
        WaxLab waxLab = this.getMediator().getWaxLab();
        WaxLabPreferences waxLabPreferences = this.getMediator().getWaxLabPreferences();
        TimecodeLineConfig lineConfig = this.timecodeLine.getTimecodeLineConfig();
        String timecodeFormatName = lineConfig.getTimecodeFormatName();
        int scratchMode = AbstractScratchModeControl.getTimecodeDecoderMode(lineConfig.getScratchMode());
        if (scratchMode < 0) {
            scratchMode = 1;
        }
        try {
            timecodeFormat = waxLab.getTimecodeFormat(timecodeFormatName);
        }
        catch (IOException e) {
            throw new AudioException((Throwable)e);
        }
        if (timecodeFormat == null) {
            throw new AudioException("Timecode format not found: " + timecodeFormatName);
        }
        if (timecodeFormat.isAudioDecoderSupported()) {
            int channels = source.getChannels();
            if (channels != 2) {
                throw new AudioException("Invalid number of timecode audio channels: " + channels + " != 2 (stereo)");
            }
            stereoTimecodeInput = source;
            midiTimecodeInput = false;
        } else if (timecodeFormat.isMidiDecoderSupported()) {
            stereoTimecodeInput = null;
            midiTimecodeInput = true;
            logger.warning("DEBUG MIDI-Timecode support: timecodeFormat=" + timecodeFormat);
        } else {
            throw new AudioException("TimecodeFormat is not supported: " + timecodeFormat);
        }
        if (audioModel == null) {
            return null;
        }
        try {
            ScratchDeck scratchDeck;
            Resource scratchAudioResource;
            WaxLabScratchTarget audioScratchPlayer;
            DoubleArraySampleBuffer scratchTargetBuffer;
            CachedAudioModel cachedAudioModel = null;
            if (lineConfig.isRecordingEnabled()) {
                if (stereoTimecodeInput != null) {
                    AudioFile targetAudioFile;
                    int channels = source.getChannels();
                    float frameRate = source.getFrameRate();
                    int recSampleType = 1;
                    AudioFormat targetFormat = FeatureZTimecodeOldScratcher.createAudioFormat(channels, frameRate, recSampleType);
                    String fileNamePrefix = FeatureZTimecodeOldScratcher.buildFileNamePrefix(waxLab, this.timecodeLine, timestampString);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Creating audio model: format=" + targetFormat);
                    }
                    if ((targetAudioFile = waxLab.createNewAudioFile(fileNamePrefix, targetFormat)) != null && (cachedAudioModel = waxLab.createCachedAudioModel(targetAudioFile)) != null) {
                        long lineOfs = 0L;
                    }
                }
                if (midiTimecodeInput) {
                    logger.warning("TODO midiTimecodeInput recording !");
                }
            }
            if (target instanceof DoubleArraySampleBuffer) {
                scratchTargetBuffer = (DoubleArraySampleBuffer)target;
            } else {
                int chs = target.getChannels();
                int samples = target.getSamples();
                float rate = target.getFrameRate();
                scratchTargetBuffer = new DoubleArraySampleBuffer(chs, samples, rate, new double[samples]);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("createTimecodeLineRealtimeScratchProcessor: tcLine=" + this.timecodeLine + ", tcFormat=" + timecodeFormat + ", scratchMode=" + scratchMode + ", needleFramePos=" + needleFramePos);
            }
            double startFramePos = 0.0;
            double volumeFactor = lineConfig.getPostFaderVolume();
            int pitchMode = AbstractPitchModeControl.getScratchPlayerPitchMode(lineConfig.getPitchMode());
            double pitchFactor = lineConfig.getPitchFactor();
            double pitchBPM = lineConfig.getPitchBPM();
            PitchDeck pitchDeck = this.lookupPitchDeck(waxLab, this.timecodeLine);
            double beatJump = lineConfig.getJumpBeats();
            float resampleRate = lineConfig.getResampleRate();
            Object scratchProcessor = audioScratchPlayer = null;
            if (scratchTargetBuffer != target) {
                WaxLabScratchTarget playerWrapper;
                scratchProcessor = playerWrapper = new WaxLabScratchTarget((AudioProcessor)scratchProcessor, (SampleBuffer)scratchTargetBuffer, target);
            }
            if (cachedAudioModel != null) {
                boolean closeTargetAudioModel;
                DefaultSampleCursor targetAudioCursor;
                CachedAudioModel targetAudioModel;
                long sampleIndex = 0L;
                boolean batchMode = this.getMediator().isBatchMode();
                if (batchMode) {
                    targetAudioModel = cachedAudioModel;
                    targetAudioCursor = new DefaultSampleCursor((SampleModel)cachedAudioModel, sampleIndex);
                    closeTargetAudioModel = false;
                } else {
                    int channels = cachedAudioModel.getChannels();
                    float frameRate = cachedAudioModel.getFrameRate();
                    int bufferCount = waxLabPreferences.getTimecodeRecorderBufferCount();
                    int bufferSize = channels * (int)((double)waxLabPreferences.getTimecodeRecorderBufferMillis() * (double)frameRate / 1000.0);
                    boolean fair = waxLabPreferences.isTimecodeRecorderBufferFair();
                    SampleBuffer[] sampleBuffers = new SampleBuffer[bufferCount];
                    for (int i = 0; i < bufferCount; ++i) {
                        sampleBuffers[i] = source instanceof FloatArraySampleBuffer ? new FloatArraySampleBuffer(channels, bufferSize, frameRate, new float[bufferSize]) : new DoubleArraySampleBuffer(channels, bufferSize, frameRate, new double[bufferSize]);
                    }
                    try {
                        boolean readOnly = false;
                        boolean closeModel = false;
                        ThreadPool writerThreadPool = this.getMediator().getWriterThreadPool();
                        LockFactory lockFactory = this.getMediator().getLockFactory();
                        ReadWriteLock bufLock = lockFactory.createReadWriteLock(fair);
                        RealAudioModel realtimeModel = new RealAudioModel((AudioModel)cachedAudioModel, (SampleModel)cachedAudioModel, sampleIndex, readOnly, closeModel, bufferCount, bufferSize, sampleBuffers, bufLock, writerThreadPool);
                        targetAudioModel = realtimeModel;
                        targetAudioCursor = realtimeModel.openRealtimeCursor(sampleIndex);
                        closeTargetAudioModel = true;
                    }
                    catch (IOException e) {
                        throw new AudioException((Throwable)e);
                    }
                    catch (InterruptedException e) {
                        throw new AudioException((Throwable)e);
                    }
                }
                WaxLabScratchRecorderOld scratchRecorder = new WaxLabScratchRecorderOld((AudioProcessor)scratchProcessor, stereoTimecodeInput, (SampleCursor)targetAudioCursor, (SampleModel)targetAudioModel, closeTargetAudioModel);
                scratchProcessor = scratchRecorder;
            }
            if ((scratchAudioResource = this.timecodeLine.getScratchAudioResource()) != null && (scratchDeck = this.timecodeLine.getScratchDeck()) != null && scratchDeck instanceof WaxLabScratchDeck) {
                WaxLabScratchDeck deck = (WaxLabScratchDeck)scratchDeck;
                Object scratchMediaEntry = null;
            }
            return scratchProcessor;
        }
        catch (IOException e) {
            throw new AudioException((Throwable)e);
        }
    }

    protected AbstractAudioScratchPlayer createRealtimeScratchPlayer(AbstractScratchLine scratchLine, SampleBuffer stereoTimecodeInput, TimecodeFormat timecodeFormat, int scratchMode, MediaEntry entry, double beatJump, SampleModel audioModel, float resampleRate, double startFramePos, double volume, int pitchMode, double pitchFactor, double pitchBPM, PitchDeck pitchDeck, double needleFramePos, DoubleArraySampleBuffer audioOutput) throws AudioException {
        Object timecodeDecoder;
        AudioScratchPlayer realScratchPlayer;
        int beatSliceCount;
        ScratchLineConfig slc;
        int cuePointCount;
        WaxLabPreferences waxLabConfig;
        double skipThreshold;
        AudioScratchModel audioScratchModel = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("AudioScratchModel: " + audioScratchModel);
        }
        if ((skipThreshold = (waxLabConfig = this.getMediator().getWaxLabPreferences()).getScratchNeedleSkipThreshold()) < 0.0) {
            skipThreshold = 10.0;
        }
        if (skipThreshold < 2.0) {
            skipThreshold = 2.0;
        }
        if ((cuePointCount = (slc = scratchLine.getScratchLineConfig()).getCuePointCount()) < 0) {
            cuePointCount = 8;
        }
        if ((beatSliceCount = slc.getBeatSliceCount()) < 0) {
            beatSliceCount = 8;
        }
        double needleStartPos = 0.0;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Creating realtime scratch player: line=" + scratchLine.getName() + ", scratchMode=" + scratchMode + ", skipThreshold=" + skipThreshold + ", needleStartPos=" + needleStartPos + ", cuePointCount=" + cuePointCount);
        }
        AudioScratchPlayer audioScratchPlayer = realScratchPlayer = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("AudioScratchPlayer: " + audioScratchPlayer);
        }
        if ((timecodeDecoder = null) != null) {
            MidiSupport midiSupport;
            logger.warning("TODO registerTimecodeDecoder: " + timecodeDecoder);
            WaxLabMidiInputPort midiInputPort = this.getTimecodeMidiInputPort(scratchLine);
            logger.warning("TODO registerTimecodeDecoder: midiInputPort=" + (Object)((Object)midiInputPort));
            MidiSupport midiSupport2 = midiSupport = midiInputPort == null ? null : midiInputPort.getMidiSupport();
            if (midiSupport != null && midiSupport instanceof WaxLabMidiSupport) {
                WaxLabMidiSupport waxLabMidiSupport = (WaxLabMidiSupport)midiSupport;
            }
        }
        WaxLabLiveFeeder scratchFeeder = null;
        if (audioModel instanceof WaxLabLiveFeeder) {
            scratchFeeder = (WaxLabLiveFeeder)audioModel;
        }
        WaxLabDevice device = this.getMediator().getWaxLabDevice();
        Clock clock = this.getMediator().getClock();
        LockSupport lockSupport = this.getMediator().getLockSupport();
        LockFactory lockFactory = this.getMediator().getLockFactory();
        ThreadManager threadManager = this.getMediator().getThreadManager();
        WaxLabScratchDeckMediator scratchDeckMediator = null;
        WaxLabScratchDeck scratchDeck = new WaxLabScratchDeck(device, scratchLine, scratchDeckMediator, clock, lockSupport, lockFactory, threadManager);
        scratchDeck.setCuePointCount(cuePointCount);
        scratchDeck.setScratchPlayer((AbstractAudioScratchPlayer)audioScratchPlayer);
        scratchDeck.setResampleRate(resampleRate);
        scratchDeck.setScratchModel(audioScratchModel);
        scratchDeck.setScratchFeeder(scratchFeeder);
        List scratchDeckList = null;
        scratchDeckList.add(scratchDeck);
        scratchDeckMediator.registerScratchDeck(scratchDeck);
        LineWrapper lineWrapper = null;
        if (scratchLine instanceof AbstractScratchLine) {
            AbstractScratchLine asl = scratchLine;
            lineWrapper = asl.getWrapper();
        }
        if (lineWrapper != null) {
            lineWrapper.setScratchPlayer(audioScratchPlayer);
        }
        return audioScratchPlayer;
    }

    protected WaxLabMidiInputPort getTimecodeMidiInputPort(ScratchLine scratchLine) {
        TimecodeLine tcLine = null;
        if (scratchLine != null && scratchLine instanceof TimecodeLine) {
            tcLine = (TimecodeLine)scratchLine;
        }
        if (tcLine == null) {
            return null;
        }
        TimecodeLineConfig tcConfig = tcLine.getTimecodeLineConfig();
        if (tcConfig == null) {
            return null;
        }
        WaxLabPortInfo portInfo = tcConfig.getTimecodeMidiInputPort();
        if (portInfo == null) {
            return null;
        }
        Port port = portInfo.getPort();
        if (port != null && port instanceof WaxLabMidiInputPort) {
            return (WaxLabMidiInputPort)port;
        }
        return null;
    }

    private void prepareScratchLineProcessors(ScratchLine scratchLine, int state) throws MidiException {
        String lineName = scratchLine.getName();
        ScratchLineConfig lineConfig = scratchLine.getScratchLineConfig();
        if (lineConfig == null) {
            return;
        }
    }

    @Override
    protected void releaseSyncHandler(SyncHandler syncHandler) {
        logger.warning("TODO releaseSyncHandler: " + syncHandler);
    }

    protected static class ScratcherInfo {
        private boolean infoNew;

        protected ScratcherInfo() {
        }
    }
}

