/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Resource;
import com.waxmonster.fader.FaderConfig;
import com.waxmonster.timecode.TimecodeFormat;
import com.waxmonster.waxlab.MidiLine;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.impl.AbstractLineFeature;
import com.waxmonster.waxlab.impl.AbstractScratchLine;
import com.waxmonster.waxlab.impl.CommonLineFeature;
import com.waxmonster.waxlab.impl.SyncHandler;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;

public abstract class ScratchManager {
    protected final AbstractScratchLine scratchLine;
    protected int audioFrameType;
    protected boolean audioFaderEnabled;
    protected boolean audioPreFaderEnabled;
    protected boolean audioPostFaderEnabled;
    protected WaxLabPortInfo[] audioPreFaderPorts;
    protected WaxLabPortInfo[] audioPostFaderPorts;
    protected WaxLabPortInfo[] audioLiveFeedPorts;
    protected WaxLabPortInfo[] audioTimecodePorts;
    protected WaxLabPortInfo midiInputPort;
    protected WaxLabPortInfo midiOutputPort;
    protected WaxLabPortInfo midiTimecodePort;
    protected MidiLine faderMidiLine;
    protected TimecodeFormat timecodeFormat;
    protected boolean batchMode;
    protected Resource scratchResource;
    protected boolean liveFeed;
    protected AbstractLineFeature lineFeature;

    protected ScratchManager(AbstractScratchLine scratchLine) {
        this.scratchLine = scratchLine;
    }

    public final AbstractScratchLine getScratchLine() {
        return this.scratchLine;
    }

    protected abstract void setPreFaderVolume(double var1);

    protected abstract void setPostFaderVolume(double var1);

    protected abstract void setFaderConfigArray(FaderConfig[] var1);

    protected synchronized int getAudioFrameType() {
        return this.audioFrameType;
    }

    protected synchronized void setAudioFrameType(int audioFrameType) {
        if (this.audioFrameType == audioFrameType) {
            return;
        }
        this.audioFrameType = audioFrameType;
        if (this.lineFeature != null) {
            this.lineFeature.invalidate();
        }
    }

    protected synchronized boolean isAudioFaderEnabled() {
        return this.audioFaderEnabled;
    }

    protected synchronized void setAudioFaderEnabled(boolean audioFaderEnabled) {
        if (this.audioFaderEnabled == audioFaderEnabled) {
            return;
        }
        this.audioFaderEnabled = audioFaderEnabled;
        if (this.lineFeature != null) {
            this.lineFeature.invalidate();
        }
    }

    protected synchronized boolean isAudioPreFaderEnabled() {
        return this.audioPreFaderEnabled;
    }

    protected synchronized void setAudioPreFaderEnabled(boolean audioPreFaderEnabled) {
        if (this.audioPreFaderEnabled == audioPreFaderEnabled) {
            return;
        }
        this.audioPreFaderEnabled = audioPreFaderEnabled;
        if (this.lineFeature != null) {
            this.lineFeature.invalidate();
        }
    }

    protected synchronized boolean isAudioPostFaderEnabled() {
        return this.audioPostFaderEnabled;
    }

    protected synchronized void setAudioPostFaderEnabled(boolean audioPostFaderEnabled) {
        if (this.audioPostFaderEnabled == audioPostFaderEnabled) {
            return;
        }
        this.audioPostFaderEnabled = audioPostFaderEnabled;
        if (this.lineFeature != null) {
            this.lineFeature.invalidate();
        }
    }

    protected synchronized WaxLabPortInfo[] getAudioPostFaderPorts() {
        return this.audioPostFaderPorts;
    }

    protected synchronized void setAudioPostFaderPorts(WaxLabPortInfo[] audioPostFaderPorts) {
        if (CommonLineFeature.equalsPortArray(this.audioPostFaderPorts, audioPostFaderPorts)) {
            return;
        }
        this.audioPostFaderPorts = audioPostFaderPorts;
        if (this.lineFeature != null) {
            this.lineFeature.invalidate();
        }
    }

    protected synchronized WaxLabPortInfo[] getAudioPreFaderPorts() {
        return this.audioPreFaderPorts;
    }

    protected synchronized void setAudioPreFaderPorts(WaxLabPortInfo[] audioPreFaderPorts) {
        if (CommonLineFeature.equalsPortArray(this.audioPreFaderPorts, audioPreFaderPorts)) {
            return;
        }
        this.audioPreFaderPorts = audioPreFaderPorts;
        if (this.lineFeature != null) {
            this.lineFeature.invalidate();
        }
    }

    protected synchronized WaxLabPortInfo[] getAudioTimecodePorts() {
        return this.audioTimecodePorts;
    }

    protected synchronized void setAudioTimecodePorts(WaxLabPortInfo[] audioTimecodePorts) {
        if (CommonLineFeature.equalsPortArray(this.audioTimecodePorts, audioTimecodePorts)) {
            return;
        }
        this.audioTimecodePorts = audioTimecodePorts;
        if (this.lineFeature != null) {
            this.lineFeature.invalidate();
        }
    }

    protected synchronized WaxLabPortInfo[] getAudioLiveFeedPorts() {
        return this.audioLiveFeedPorts;
    }

    protected synchronized void setAudioLiveFeedPorts(WaxLabPortInfo[] audioLiveFeedPorts) {
        if (CommonLineFeature.equalsPortArray(this.audioLiveFeedPorts, audioLiveFeedPorts)) {
            return;
        }
        this.audioLiveFeedPorts = audioLiveFeedPorts;
        if (this.lineFeature != null) {
            this.lineFeature.invalidate();
        }
    }

    protected synchronized WaxLabPortInfo getMidiInputPort() {
        return this.midiInputPort;
    }

    protected synchronized void setMidiInputPort(WaxLabPortInfo midiInputPort) {
        if (this.midiInputPort == midiInputPort) {
            return;
        }
        this.midiInputPort = midiInputPort;
        if (this.lineFeature != null) {
            this.lineFeature.invalidate();
        }
    }

    protected synchronized WaxLabPortInfo getMidiOutputPort() {
        return this.midiOutputPort;
    }

    protected synchronized void setMidiOutputPort(WaxLabPortInfo midiOutputPort) {
        if (this.midiOutputPort == midiOutputPort) {
            return;
        }
        this.midiOutputPort = midiOutputPort;
        if (this.lineFeature != null) {
            this.lineFeature.invalidate();
        }
    }

    protected synchronized MidiLine getFaderMidiLine() {
        return this.faderMidiLine;
    }

    protected synchronized void setFaderMidiLine(MidiLine faderMidiLine) {
        if (this.faderMidiLine == faderMidiLine) {
            return;
        }
        this.faderMidiLine = faderMidiLine;
        if (this.lineFeature != null) {
            this.lineFeature.invalidate();
        }
    }

    protected synchronized WaxLabPortInfo getMidiTimecodePort() {
        return this.midiTimecodePort;
    }

    protected synchronized void setMidiTimecodePort(WaxLabPortInfo midiTimecodePort) {
        if (this.midiTimecodePort == midiTimecodePort) {
            return;
        }
        this.midiTimecodePort = midiTimecodePort;
        if (this.lineFeature != null) {
            this.lineFeature.invalidate();
        }
    }

    protected synchronized TimecodeFormat getTimecodeFormat() {
        return this.timecodeFormat;
    }

    protected synchronized void setTimecodeFormat(TimecodeFormat timecodeFormat) {
        if (this.timecodeFormat == timecodeFormat) {
            return;
        }
        this.timecodeFormat = timecodeFormat;
        if (this.lineFeature != null) {
            this.lineFeature.invalidate();
        }
    }

    protected boolean isBatchMode() {
        return this.batchMode;
    }

    protected void setBatchMode(boolean batchMode) {
        this.batchMode = batchMode;
    }

    protected Resource getScratchResource() {
        return this.scratchResource;
    }

    protected void setScratchResource(Resource scratchResource) {
        this.scratchResource = scratchResource;
    }

    protected synchronized boolean isLiveFeed() {
        return this.liveFeed;
    }

    protected synchronized void setLiveFeed(boolean liveFeed) {
        if (this.liveFeed == liveFeed) {
            return;
        }
        this.liveFeed = liveFeed;
        if (this.lineFeature != null) {
            this.lineFeature.invalidate();
        }
    }

    protected AbstractLineFeature getLineFeature() {
        return this.lineFeature;
    }

    protected void setLineFeature(AbstractLineFeature lineFeature) {
        this.lineFeature = lineFeature;
    }

    protected abstract void mediateFeature(SyncMediator var1, long var2, boolean var4, boolean var5, boolean var6);

    protected abstract void prepareSyncHandler(SyncHandler var1, WaxLabAudioSyncGroup var2, long var3, long var5, long var7);

    protected abstract void prepareSyncHandler(SyncHandler var1, WaxLabMidiInputPort var2, long var3, long var5, long var7);

    protected abstract void prepareSyncHandler(SyncHandler var1, WaxLabMidiOutputPort var2, long var3, long var5, long var7);

    protected abstract void releaseSyncHandler(SyncHandler var1);
}

