/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Resource;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.sound.DefaultSampleCursor;
import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleCursor;
import com.spacekiller.util.sound.SampleModel;
import com.spacekiller.util.thread.ThreadPool;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.fader.FaderConfig;
import com.waxmonster.fader.FaderDecoder;
import com.waxmonster.fader.VolumeShader;
import com.waxmonster.fader.impl.VolumeShaderSupport;
import com.waxmonster.fader.midi.MidiProcessorFaderDecoder;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.common.MidiActionProcessor;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.MutableChunkModel;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.impl.CachedTimecodeModel;
import com.waxmonster.model.impl.MidiModelFaderDecoder;
import com.waxmonster.model.impl.RealTimecodeModel;
import com.waxmonster.model.impl.TimecodeFile;
import com.waxmonster.scratch.AudioScratchModel;
import com.waxmonster.scratch.PitchDeck;
import com.waxmonster.scratch.impl.AbstractAudioScratchPlayer;
import com.waxmonster.scratch.impl.DefaultAudioScratchPlayer;
import com.waxmonster.scratch.impl.RealAudioScratchPlayer;
import com.waxmonster.studio.Port;
import com.waxmonster.timecode.TimecodeDecoder;
import com.waxmonster.timecode.TimecodeFormat;
import com.waxmonster.waxlab.MidiLine;
import com.waxmonster.waxlab.MidiLineConfig;
import com.waxmonster.waxlab.ScratchLineConfig;
import com.waxmonster.waxlab.TimecodeLine;
import com.waxmonster.waxlab.TimecodeLineConfig;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.WaxLabPreferences;
import com.waxmonster.waxlab.impl.AbstractScratchLine;
import com.waxmonster.waxlab.impl.AbstractScratchModeControl;
import com.waxmonster.waxlab.impl.CommonLineFeature;
import com.waxmonster.waxlab.impl.ScratchManager;
import com.waxmonster.waxlab.impl.SyncFeature;
import com.waxmonster.waxlab.impl.SyncHandler;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabAudioInputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioJoinerInfo;
import com.waxmonster.waxlab.impl.WaxLabAudioOutputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabLiveFeeder;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabScratchDeck;
import com.waxmonster.waxlab.proc.WaxLabAudioFader;
import com.waxmonster.waxlab.proc.WaxLabAudioThru;
import com.waxmonster.waxlab.proc.WaxLabTimecodeAudioProcessor;
import com.waxmonster.waxlab.proc.WaxLabTimecodeMidiProcessor;
import com.waxmonster.waxlab.proc.WaxLabTimecodeProducer;
import com.waxmonster.waxlab.proc.WaxLabTimecodeRecorder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScratchManagerImpl
extends ScratchManager {
    private static final Logger logger = Platform.getLogger(ScratchManagerImpl.class);
    private static final int DEFAULT_VOLUME_SHADER_EVENT_QUEUE_SIZE = 4000;
    private static final int PRIORITY_JOIN_TIMECODE = 890;
    private static final int PRIORITY_JOIN_LIVE_FEED = 880;
    private static final int PRIORITY_DECODE_TIMECODE = 790;
    private static final int PRIORITY_DECODE_FADER = 780;
    private static final int PRIORITY_DECK_ACTION = 770;
    private static final int PRIORITY_PRODUCE_TIMECODE = 690;
    private static final int PRIORITY_RECORD_TIMECODE = 590;
    private static final int PRIORITY_RECORD_LIVE_FEED = 580;
    private static final int PRIORITY_SCRATCH_PLAYER = 490;
    private static final int PRIORITY_PLAYBACK_PRE_FADER = 290;
    private static final int PRIORITY_PLAYBACK_POST_FADER = 280;
    private static final int PRIORITY_OUTPUT_PRE_FADER = 90;
    private static final int PRIORITY_OUTPUT_POST_FADER = 80;
    private static final FaderConfig[] NO_FADER_CONFIG = new FaderConfig[0];
    private SyncFeature syncFeatureOld;
    private List scratchInfoList = new ArrayList();
    private ScratchInfo scratchInfoActive;
    private double preFaderVolume = 1.0;
    private double postFaderVolume = 1.0;
    private WaxLabAudioThru preFaderAudioThru;
    private WaxLabAudioThru postFaderAudioThru;
    private VolumeShader[] postFaderVolumeShaders;
    private FaderDecoder postFaderDecoder;

    protected ScratchManagerImpl(AbstractScratchLine scratchLine) {
        super(scratchLine);
    }

    protected VolumeShader createVolumeShader() {
        return VolumeShaderSupport.getInstance().createVolumeShader();
    }

    protected double getPreFaderVolume() {
        return this.preFaderVolume;
    }

    @Override
    protected void setPreFaderVolume(double v) {
        if (this.preFaderVolume == v) {
            return;
        }
        this.preFaderVolume = v;
        this.applyPreFaderVolume();
    }

    protected void applyPreFaderVolume() {
        WaxLabAudioThru audioThru = this.preFaderAudioThru;
        if (audioThru != null) {
            audioThru.setVolume(this.preFaderVolume);
        }
    }

    protected double getPostFaderVolume() {
        return this.postFaderVolume;
    }

    @Override
    protected void setPostFaderVolume(double v) {
        if (this.postFaderVolume == v) {
            return;
        }
        this.postFaderVolume = v;
        this.applyPostFaderVolume();
    }

    protected void applyPostFaderVolume() {
        VolumeShader[] shaders;
        WaxLabAudioThru audioThru = this.postFaderAudioThru;
        if (audioThru != null) {
            audioThru.setVolume(this.postFaderVolume);
        }
        if ((shaders = this.postFaderVolumeShaders) != null) {
            int num = shaders.length;
            for (int i = 0; i < num; ++i) {
                shaders[i].setVolumeFactor(this.postFaderVolume);
                shaders[i].reset(this.postFaderVolume);
            }
        }
    }

    @Override
    protected void setFaderConfigArray(FaderConfig[] faderConfigArray) {
        this.applyFaderConfigArray(faderConfigArray);
    }

    protected void applyFaderConfigArray(FaderConfig[] faderConfigArray) {
        FaderDecoder faderDecoder = this.postFaderDecoder;
        if (faderDecoder == null || faderConfigArray == null) {
            return;
        }
        faderDecoder.setFaderConfigArray(faderConfigArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void mediateFeature(SyncMediator syncMediator, long lineOfs, boolean enableRecorder, boolean enableScratcher, boolean enablePlayback) {
        Level trace;
        Level debug;
        WaxLab waxLab = syncMediator.getWaxLab();
        WaxLabPreferences waxLabPreferences = syncMediator.getWaxLabPreferences();
        boolean batchMode = syncMediator.isBatchMode();
        if (batchMode != this.batchMode) {
            this.batchMode = batchMode;
        }
        SyncFeature syncFeatureOld = this.syncFeatureOld;
        SyncFeature syncFeature = null;
        if (this.lineFeature != null && this.lineFeature.isEnabled()) {
            syncFeature = this.lineFeature.getSyncFeature();
        }
        if (!logger.isLoggable(debug = Level.FINE)) {
            debug = null;
        }
        if (!logger.isLoggable(trace = Level.FINER)) {
            trace = null;
        }
        try {
            WaxLabAudioSyncGroup audioSyncGroup;
            boolean syncFeatureChanged;
            WaxLabAudioInputPort audioInPort;
            SampleBuffer sb;
            WaxLabAudioOutputPort audioOutPort;
            int i;
            TimecodeLineConfig tclConfig;
            int timecodeRecChannels;
            float audioOutRate;
            WaxLabPortInfo midiTriggerPortInfo;
            WaxLabMidiOutputPort midiTriggerOutputPort;
            WaxLabMidiSyncGroup midiTriggerSyncGroup;
            WaxLabPortInfo midiInputPortInfo;
            WaxLabMidiInputPort midiActionInputPort;
            WaxLabMidiSyncGroup midiActionSyncGroup;
            MidiLine faderMidiLine;
            MidiLineConfig midiLineConfig;
            WaxLabPortInfo midiFaderPortInfo;
            WaxLabMidiInputPort midiFaderInputPort;
            WaxLabMidiSyncGroup midiFaderSyncGroup;
            int targetFrameType = this.getAudioFrameType();
            WaxLabPortInfo[] preFaderPortInfos = this.getAudioPreFaderPorts();
            WaxLabAudioOutputPort[] preFaderPorts = CommonLineFeature.validateAudioOutputPorts(targetFrameType, preFaderPortInfos);
            WaxLabAudioSyncGroup preFaderSyncGroup = CommonLineFeature.validateAudioSyncGroup(preFaderPorts);
            if (preFaderSyncGroup == null) {
                preFaderPorts = null;
            }
            int preFaderPortCount = preFaderPorts == null ? 0 : preFaderPorts.length;
            WaxLabPortInfo[] postFaderPortInfos = this.getAudioPostFaderPorts();
            WaxLabAudioOutputPort[] postFaderPorts = CommonLineFeature.validateAudioOutputPorts(targetFrameType, postFaderPortInfos);
            WaxLabAudioSyncGroup postFaderSyncGroup = CommonLineFeature.validateAudioSyncGroup(postFaderPorts);
            if (postFaderSyncGroup == null) {
                postFaderPorts = null;
            }
            int postFaderPortCount = postFaderPorts == null ? 0 : postFaderPorts.length;
            WaxLabPortInfo[] feedAudioPortInfos = this.getAudioLiveFeedPorts();
            WaxLabAudioInputPort[] feedAudioPorts = CommonLineFeature.validateAudioInputPorts(feedAudioPortInfos, targetFrameType);
            WaxLabAudioSyncGroup feedAudioSyncGroup = CommonLineFeature.validateAudioSyncGroup(feedAudioPorts);
            if (feedAudioSyncGroup == null) {
                feedAudioPorts = null;
            }
            int feedPortCount = feedAudioPorts == null ? 0 : feedAudioPorts.length;
            int tcFrameType = 2;
            WaxLabPortInfo[] tcAudioPortInfos = this.getAudioTimecodePorts();
            WaxLabAudioInputPort[] tcAudioPorts = CommonLineFeature.validateAudioInputPorts(tcAudioPortInfos, tcFrameType);
            WaxLabAudioSyncGroup tcAudioSyncGroup = CommonLineFeature.validateAudioSyncGroup(tcAudioPorts);
            if (tcAudioSyncGroup == null) {
                tcAudioPorts = null;
            }
            int tcAudioPortCount = tcAudioPorts == null ? 0 : tcAudioPorts.length;
            WaxLabPortInfo tcMidiPortInfo = this.getMidiTimecodePort();
            WaxLabMidiInputPort tcMidiInputPort = CommonLineFeature.validateMidiInputPort(tcMidiPortInfo);
            WaxLabMidiSyncGroup tcMidiSyncGroup = CommonLineFeature.validateMidiSyncGroup(tcMidiInputPort);
            if (tcMidiSyncGroup == null) {
                tcMidiInputPort = null;
            }
            if ((midiFaderSyncGroup = CommonLineFeature.validateMidiSyncGroup(midiFaderInputPort = CommonLineFeature.validateMidiInputPort(midiFaderPortInfo = (midiLineConfig = (faderMidiLine = this.getFaderMidiLine()) == null ? null : faderMidiLine.getMidiLineConfig()) == null ? null : midiLineConfig.getRecordingPort()))) == null) {
                midiFaderInputPort = null;
            }
            if ((midiActionSyncGroup = CommonLineFeature.validateMidiSyncGroup(midiActionInputPort = CommonLineFeature.validateMidiInputPort(midiInputPortInfo = this.getMidiInputPort()))) == null) {
                midiActionInputPort = null;
            }
            if ((midiTriggerSyncGroup = CommonLineFeature.validateMidiSyncGroup(midiTriggerOutputPort = CommonLineFeature.validateMidiOutputPort(midiTriggerPortInfo = this.getMidiOutputPort()))) == null) {
                midiTriggerOutputPort = null;
            }
            if ((audioOutRate = CommonLineFeature.computeAudioOutputSampleRate(postFaderPorts, postFaderPortCount)) <= 0.0f) {
                audioOutRate = CommonLineFeature.computeAudioOutputSampleRate(preFaderPorts, preFaderPortCount);
            }
            int audioOutChannels = 0;
            if (audioOutRate > 0.0f && (audioOutChannels = CommonLineFeature.computeAudioOutputChannels(postFaderPorts, postFaderPortCount)) < 1) {
                audioOutChannels = CommonLineFeature.computeAudioOutputChannels(preFaderPorts, preFaderPortCount);
            }
            int audioOutFrames = 0;
            WaxLabAudioSyncGroup audioOutGroup = null;
            if (audioOutChannels > 0) {
                audioOutFrames = CommonLineFeature.computeAudioOutputBufferFrames(postFaderSyncGroup, postFaderPorts, postFaderPortCount);
                if (audioOutFrames > 0) {
                    audioOutGroup = postFaderSyncGroup;
                } else {
                    audioOutFrames = CommonLineFeature.computeAudioOutputBufferFrames(preFaderSyncGroup, preFaderPorts, preFaderPortCount);
                    if (audioOutFrames > 0) {
                        audioOutGroup = preFaderSyncGroup;
                    }
                }
            }
            int feedRecChannels = CommonLineFeature.computeAudioInputChannels(feedAudioPorts, feedPortCount);
            float feedRecRate = CommonLineFeature.computeAudioInputSampleRate(feedAudioPorts, feedPortCount);
            int feedRecFrames = 0;
            if (feedRecChannels > 0) {
                feedRecFrames = CommonLineFeature.computeAudioInputBufferFrames(feedAudioSyncGroup, feedAudioPorts, feedPortCount);
            }
            timecodeRecChannels = (timecodeRecChannels = CommonLineFeature.computeAudioInputChannels(tcAudioPorts, tcAudioPortCount)) < 2 ? 0 : 2;
            WaxLabAudioSyncGroup timecodeDecoderGroup = null;
            float timecodeRecRate = 0.0f;
            int timecodeRecFrames = 0;
            if (timecodeRecChannels > 0) {
                timecodeRecRate = CommonLineFeature.computeAudioInputSampleRate(tcAudioPorts, tcAudioPortCount);
                timecodeRecFrames = CommonLineFeature.computeAudioInputBufferFrames(tcAudioSyncGroup, tcAudioPorts, tcAudioPortCount);
                timecodeDecoderGroup = tcAudioSyncGroup;
            }
            if (timecodeRecRate <= 0.0f || timecodeDecoderGroup == null) {
                timecodeRecRate = audioOutRate;
                timecodeRecFrames = audioOutFrames;
                if (timecodeRecRate > 0.0f && (timecodeDecoderGroup = postFaderSyncGroup) == null) {
                    timecodeDecoderGroup = preFaderSyncGroup;
                }
                if (timecodeDecoderGroup == null) {
                    timecodeRecChannels = 0;
                    timecodeRecRate = 0.0f;
                    timecodeRecFrames = 0;
                }
            }
            WaxLabAudioSyncGroup timecodeProducerGroup = null;
            if (timecodeRecFrames > 0 && (timecodeProducerGroup = audioOutGroup) == null) {
                timecodeProducerGroup = timecodeDecoderGroup;
            }
            if (debug != null) {
                logger.log(debug, "mediate: " + this.scratchLine + ", outChannels=" + audioOutChannels + ", outRate=" + audioOutRate + ", recChannels=" + timecodeRecChannels + ", recRate=" + timecodeRecRate + ", feedChannels=" + feedRecChannels + ", feedRate=" + feedRecRate);
            }
            if (syncFeature == null) {
                audioOutFrames = 0;
                timecodeRecFrames = 0;
                feedRecFrames = 0;
            }
            ScratchLineConfig config = this.scratchLine.getScratchLineConfig();
            Object[] faderConfigArray = null;
            boolean audioFaderEnabled = this.isAudioFaderEnabled();
            boolean enablePreFader = this.isAudioPreFaderEnabled();
            boolean enablePostFader = this.isAudioPostFaderEnabled();
            if (audioFaderEnabled && config != null && config instanceof TimecodeLineConfig && (faderConfigArray = (tclConfig = (TimecodeLineConfig)config).getAudioFaderConfigs()) == null) {
                faderConfigArray = NO_FADER_CONFIG;
            }
            if (faderConfigArray == null) {
                audioFaderEnabled = false;
            }
            if (enableScratcher) {
                enablePlayback = false;
            }
            if (audioOutFrames < 1) {
                postFaderPortCount = 0;
                postFaderPorts = null;
                preFaderPortCount = 0;
                preFaderPorts = null;
                enablePlayback = false;
                enableScratcher = false;
            }
            if (timecodeRecFrames < 1) {
                tcAudioPortCount = 0;
                tcAudioPorts = null;
            }
            if (postFaderPortCount > 0) {
                for (i = 0; i < postFaderPortCount; ++i) {
                    audioOutPort = postFaderPorts[i];
                    if (audioOutPort == null) continue;
                    if (postFaderPortCount == 1) {
                        if (audioOutPort.getChannels() != audioOutChannels) {
                            if (logger.isLoggable(Level.WARNING)) {
                                logger.warning("Invalid post-fader audio output channels: " + (Object)((Object)audioOutPort) + " -> " + audioOutPort.getChannels() + " != " + audioOutChannels);
                            }
                            postFaderPortCount = 0;
                            break;
                        }
                    } else if (audioOutPort.getChannels() != 1) {
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.warning("Invalid post-fader audio output channels: " + (Object)((Object)audioOutPort) + " -> " + audioOutPort.getChannels() + " != 1");
                        }
                        postFaderPortCount = 0;
                        break;
                    }
                    if ((sb = audioOutPort.getBuffer()) == null || sb.getFrameRate() == audioOutRate) continue;
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.warning("Invalid post-fader audio output rate: " + (Object)((Object)audioOutPort) + " -> " + sb.getFrameRate() + " != " + audioOutRate);
                    }
                    postFaderPortCount = 0;
                    break;
                }
            }
            if (preFaderPortCount > 0) {
                for (i = 0; i < preFaderPortCount; ++i) {
                    audioOutPort = preFaderPorts[i];
                    if (audioOutPort == null) continue;
                    if (preFaderPortCount == 1) {
                        if (audioOutPort.getChannels() != audioOutChannels) {
                            if (logger.isLoggable(Level.WARNING)) {
                                logger.warning("Invalid pre-fader audio output channels: " + (Object)((Object)audioOutPort) + " -> " + audioOutPort.getChannels() + " != " + audioOutChannels);
                            }
                            preFaderPortCount = 0;
                            break;
                        }
                    } else if (audioOutPort.getChannels() != 1) {
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.warning("Invalid pre-fader audio output channels: " + (Object)((Object)audioOutPort) + " -> " + audioOutPort.getChannels() + " != 1");
                        }
                        preFaderPortCount = 0;
                        break;
                    }
                    if ((sb = audioOutPort.getBuffer()) == null || sb.getFrameRate() == audioOutRate) continue;
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.warning("Invalid pre-fader audio output rate: " + (Object)((Object)audioOutPort) + " -> " + sb.getFrameRate() + " != " + audioOutRate);
                    }
                    preFaderPortCount = 0;
                    break;
                }
            }
            if (tcAudioPortCount > 0 && timecodeRecChannels > 0) {
                int tcAudioChannels = 0;
                for (int i2 = 0; i2 < tcAudioPortCount; ++i2) {
                    audioInPort = tcAudioPorts[i2];
                    if (audioInPort == null) {
                        ++tcAudioChannels;
                        continue;
                    }
                    if (tcAudioPortCount == 1) {
                        if (audioInPort.getChannels() != timecodeRecChannels) {
                            if (logger.isLoggable(Level.WARNING)) {
                                logger.warning("Invalid timecode audio input channels: " + (Object)((Object)audioInPort) + " -> " + audioInPort.getChannels() + " != " + timecodeRecChannels);
                            }
                            tcAudioPortCount = 0;
                            break;
                        }
                        tcAudioChannels += audioInPort.getChannels();
                    } else {
                        if (audioInPort.getChannels() != 1) {
                            if (logger.isLoggable(Level.WARNING)) {
                                logger.warning("Invalid timecode audio input channels: " + (Object)((Object)audioInPort) + " -> " + audioInPort.getChannels() + " != 1");
                            }
                            tcAudioPortCount = 0;
                            break;
                        }
                        ++tcAudioChannels;
                    }
                    sb = audioInPort.getBuffer();
                    if (sb != null && sb.getFrameRate() != timecodeRecRate) {
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.warning("Invalid timecode audio input rate: " + (Object)((Object)audioInPort) + " -> " + sb.getFrameRate() + " != " + timecodeRecRate);
                        }
                        tcAudioPortCount = 0;
                        break;
                    }
                    if (tcAudioChannels >= timecodeRecChannels) break;
                }
                if (tcAudioChannels != timecodeRecChannels) {
                    tcAudioPortCount = 0;
                }
            }
            if (feedPortCount > 0) {
                for (i = 0; i < feedPortCount; ++i) {
                    audioInPort = feedAudioPorts[i];
                    if (audioInPort == null) continue;
                    if (feedPortCount == 1) {
                        if (audioInPort.getChannels() != feedRecChannels) {
                            if (logger.isLoggable(Level.WARNING)) {
                                logger.warning("Invalid live-feed audio input channels: " + (Object)((Object)audioInPort) + " -> " + audioInPort.getChannels() + " != " + feedRecChannels);
                            }
                            feedPortCount = 0;
                            break;
                        }
                    } else if (audioInPort.getChannels() != 1) {
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.warning("Invalid live-feed audio input channels: " + (Object)((Object)audioInPort) + " -> " + audioInPort.getChannels() + " != 1");
                        }
                        feedPortCount = 0;
                        break;
                    }
                    if ((sb = audioInPort.getBuffer()) == null || sb.getFrameRate() == feedRecRate) continue;
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.warning("Invalid live-feed audio input rate: " + (Object)((Object)audioInPort) + " -> " + sb.getFrameRate() + " != " + feedRecRate);
                    }
                    feedPortCount = 0;
                    break;
                }
                if (feedPortCount > 0 && feedRecChannels != audioOutChannels) {
                    if (audioOutChannels > 0 && logger.isLoggable(Level.WARNING)) {
                        logger.warning("Invalid live-feed audio channels: " + feedRecChannels + " != " + audioOutChannels);
                    }
                    feedPortCount = 0;
                    feedRecChannels = 0;
                }
            }
            if (timecodeProducerGroup == null) {
                enableRecorder = false;
                enableScratcher = false;
            }
            if (tcMidiSyncGroup != null && timecodeDecoderGroup == null && logger.isLoggable(Level.WARNING)) {
                logger.warning("Missing audio port(s) for recording MIDI timecode!");
            }
            if (postFaderPortCount < 1 && preFaderPortCount < 1) {
                enablePlayback = false;
                enableScratcher = false;
            }
            if (!enablePlayback && !enableScratcher) {
                audioFaderEnabled = false;
                enablePostFader = false;
                enablePreFader = false;
                postFaderPortCount = 0;
                postFaderPorts = null;
                preFaderPortCount = 0;
                preFaderPorts = null;
            }
            WaxLabAudioInputPort[] recorderPortsOld = null;
            SampleBuffer tcAudioInputOld = null;
            WaxLabAudioJoinerInfo recorderJoinerOld = null;
            SyncHandler.AudioProcHandler recorderJoinHandlerOld = null;
            WaxLabAudioInputPort[] feederPortsOld = null;
            WaxLabAudioJoinerInfo feederJoinerOld = null;
            SyncHandler.AudioProcHandler feederJoinHandlerOld = null;
            SyncHandler.AudioProcHandler feederRecHandlerOld = null;
            DoubleArraySampleBuffer scratchOutputOld = null;
            SyncHandler.AudioProcHandler preFaderPlayHandlerOld = null;
            SyncHandler.AudioOutHandler preFaderOutHandlerOld = null;
            DoubleArraySampleBuffer preFaderOutputOld = null;
            WaxLabAudioOutputPort[] preFaderPortsOld = null;
            MidiProcessorFaderDecoder postFaderMidiProcDecoderOld = null;
            SyncHandler.MidiProcHandler postFaderMidiProcHandlerOld = null;
            MidiModelFaderDecoder postFaderMidiModelDecoderOld = null;
            VolumeShader[] postFaderVolumeShadersOld = null;
            double[] postFaderVolumeBufferOld = null;
            SyncHandler.AudioProcHandler postFaderPlayHandlerOld = null;
            SyncHandler.AudioOutHandler postFaderOutHandlerOld = null;
            DoubleArraySampleBuffer postFaderOutputOld = null;
            WaxLabAudioOutputPort[] postFaderPortsOld = null;
            int audioOutChannelsOld = -1;
            float audioOutRateOld = -1.0f;
            int audioOutFramesOld = -1;
            float timecodeRecRateOld = -1.0f;
            int timecodeRecFramesOld = -1;
            TimecodeFormat timecodeFormatOld = null;
            TimecodeDecoder timecodeDecoderOld = null;
            double[] timecodeBufferOld = null;
            SyncHandler.AudioProcHandler timecodeAudioHandlerOld = null;
            SyncHandler.MidiProcHandler timecodeMidiHandlerOld = null;
            SyncHandler.AudioProcHandler timecodeProducerHandlerOld = null;
            WaxLabTimecodeRecorder timecodeRecorderOld = null;
            SyncHandler.AudioProcHandler timecodeRecorderHandlerOld = null;
            CachedTimecodeModel recorderCachedModelOld = null;
            RealTimecodeModel recorderRealModelOld = null;
            MutableLineChunk recorderChunkOld = null;
            AbstractAudioScratchPlayer scratchPlayerOld = null;
            SyncHandler.AudioProcHandler scratchPlayerHandlerOld = null;
            MidiActionProcessor deckMidiActionProcessorOld = null;
            SyncHandler.MidiProcHandler deckMidiActionProcHandlerOld = null;
            MidiProcessor deckTriggerMidiProcessorOld = null;
            WaxLabLiveFeeder scratchFeederOld = null;
            ScratchInfo prevInfo = this.scratchInfoActive;
            if (prevInfo != null) {
                recorderPortsOld = prevInfo.recorderPorts;
                tcAudioInputOld = prevInfo.tcAudioInput;
                recorderJoinerOld = prevInfo.recorderJoiner;
                recorderJoinHandlerOld = prevInfo.recorderJoinHandler;
                feederPortsOld = prevInfo.feederPorts;
                feederJoinerOld = prevInfo.feederJoiner;
                feederJoinHandlerOld = prevInfo.feederJoinHandler;
                feederRecHandlerOld = prevInfo.feederRecHandler;
                scratchOutputOld = prevInfo.scratchOutput;
                preFaderPlayHandlerOld = prevInfo.preFaderPlayHandler;
                preFaderOutHandlerOld = prevInfo.preFaderOutHandler;
                preFaderOutputOld = prevInfo.preFaderOutput;
                preFaderPortsOld = prevInfo.preFaderPorts;
                postFaderMidiProcDecoderOld = prevInfo.postFaderMidiProcDecoder;
                postFaderMidiProcHandlerOld = prevInfo.postFaderMidiProcHandler;
                postFaderMidiModelDecoderOld = prevInfo.postFaderMidiModelDecoder;
                postFaderVolumeShadersOld = prevInfo.postFaderVolumeShaders;
                postFaderVolumeBufferOld = prevInfo.postFaderVolumeBuffer;
                postFaderPortsOld = prevInfo.postFaderPorts;
                postFaderPlayHandlerOld = prevInfo.postFaderPlayHandler;
                postFaderOutHandlerOld = prevInfo.postFaderOutHandler;
                postFaderOutputOld = prevInfo.postFaderOutput;
                audioOutChannelsOld = prevInfo.audioOutChannels;
                audioOutRateOld = prevInfo.audioOutRate;
                audioOutFramesOld = prevInfo.audioOutFrames;
                timecodeRecRateOld = prevInfo.timecodeRecRate;
                timecodeRecFramesOld = prevInfo.timecodeRecFrames;
                timecodeFormatOld = prevInfo.timecodeFormat;
                timecodeDecoderOld = prevInfo.timecodeDecoder;
                timecodeBufferOld = prevInfo.timecodeBuffer;
                timecodeAudioHandlerOld = prevInfo.timecodeAudioHandler;
                timecodeMidiHandlerOld = prevInfo.timecodeMidiHandler;
                timecodeProducerHandlerOld = prevInfo.timecodeProducerHandler;
                timecodeRecorderOld = prevInfo.timecodeRecorder;
                timecodeRecorderHandlerOld = prevInfo.timecodeRecorderHandler;
                recorderCachedModelOld = prevInfo.recorderCachedModel;
                recorderRealModelOld = prevInfo.recorderRealModel;
                recorderChunkOld = prevInfo.recorderChunk;
                scratchPlayerOld = prevInfo.scratchPlayer;
                scratchPlayerHandlerOld = prevInfo.scratchPlayerHandler;
                deckMidiActionProcessorOld = prevInfo.deckMidiActionProcessor;
                deckMidiActionProcHandlerOld = prevInfo.deckMidiActionProcHandler;
                deckTriggerMidiProcessorOld = prevInfo.deckTriggerMidiProcessor;
                scratchFeederOld = prevInfo.scratchFeeder;
            }
            WaxLabAudioInputPort[] recorderPorts = null;
            WaxLabAudioJoinerInfo recorderJoiner = null;
            SyncHandler.AudioProcHandler recorderJoinHandler = null;
            WaxLabAudioInputPort[] feederPorts = null;
            WaxLabAudioJoinerInfo feederJoiner = null;
            SyncHandler.AudioProcHandler feederJoinHandler = null;
            SyncHandler.AudioProcHandler feederRecHandler = null;
            SyncHandler.AudioProcHandler preFaderPlayHandler = null;
            SyncHandler.AudioOutHandler preFaderOutHandler = null;
            MidiProcessorFaderDecoder postFaderMidiProcDecoder = null;
            Object postFaderMidiModelDecoder = null;
            VolumeShader[] postFaderVolumeShaders = null;
            double[] postFaderVolumeBuffer = null;
            SyncHandler.AudioProcHandler postFaderPlayHandler = null;
            SyncHandler.AudioOutHandler postFaderOutHandler = null;
            TimecodeFormat timecodeFormat = null;
            TimecodeDecoder timecodeDecoder = null;
            double[] timecodeBuffer = null;
            SyncHandler.AudioProcHandler timecodeAudioHandler = null;
            SyncHandler.MidiProcHandler timecodeMidiHandler = null;
            SyncHandler.AudioProcHandler timecodeProducerHandler = null;
            WaxLabTimecodeRecorder timecodeRecorder = null;
            SyncHandler.AudioProcHandler timecodeRecorderHandler = null;
            CachedTimecodeModel recorderCachedModel = null;
            RealTimecodeModel recorderRealModel = null;
            MutableLineChunk recorderChunk = null;
            boolean recorderChunkIsNew = false;
            AbstractAudioScratchPlayer scratchPlayer = null;
            SyncHandler.AudioProcHandler scratchPlayerHandler = null;
            MidiActionProcessor deckMidiActionProcessor = null;
            SyncHandler.MidiProcHandler deckMidiActionProcHandler = null;
            MidiProcessor deckTriggerMidiProcessor = null;
            AudioScratchModel scratchModel = null;
            WaxLabLiveFeeder scratchFeeder = null;
            SyncHandler.MidiProcHandler postFaderMidiProcHandler = null;
            SampleBuffer tcAudioInput = null;
            DoubleArraySampleBuffer scratchOutput = null;
            DoubleArraySampleBuffer preFaderOutput = null;
            DoubleArraySampleBuffer postFaderOutput = null;
            WaxLabScratchDeck scratchDeck = this.scratchLine.getWaxLabScratchDeck();
            logger.info("applyScratchLineConfig: " + config);
            scratchDeck.applyScratchLineConfig(config, false);
            if (enableRecorder || enableScratcher) {
                timecodeFormat = this.getTimecodeFormat();
                boolean timecodeInputValid = false;
                if (timecodeFormat != null) {
                    if (timecodeFormat.isAudioDecoderSupported() && tcAudioPortCount > 0) {
                        timecodeInputValid = true;
                    }
                    if (timecodeFormat.isMidiDecoderSupported() && tcMidiInputPort != null) {
                        timecodeInputValid = true;
                    }
                }
                if (timecodeInputValid) {
                    if (timecodeFormat != timecodeFormatOld || timecodeRecRate != timecodeRecRateOld || timecodeRecFrames != timecodeRecFramesOld || audioOutRate != audioOutRateOld || audioOutFrames != audioOutFramesOld) {
                        if (debug != null) {
                            logger.log(debug, " - creating TimecodeDecoder: format=" + timecodeFormat + ", inputRate=" + timecodeRecRate + ", inputBuffer=" + timecodeRecFrames + ", outputRate=" + audioOutRate + ", outputBuffer=" + audioOutFrames);
                        }
                        try {
                            Object v = scratchDeck.scratchModeControl.getValue();
                            int scratchMode = AbstractScratchModeControl.getTimecodeDecoderMode(String.valueOf(v));
                            int tcBufferLen = audioOutFrames;
                            timecodeBuffer = timecodeBufferOld;
                            if (timecodeBuffer == null || timecodeBuffer.length != tcBufferLen) {
                                timecodeBuffer = new double[tcBufferLen];
                            }
                            timecodeDecoder = timecodeFormat.createDecoder(timecodeRecRate, timecodeRecFrames, audioOutRate, audioOutFrames, timecodeBuffer);
                            timecodeDecoder.setMode(scratchMode);
                            if (debug != null) {
                                logger.log(debug, " - created TimecodeDecoder: " + timecodeDecoder);
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                        scratchDeck.setTimecodeDecoder(timecodeDecoder);
                    } else {
                        timecodeBuffer = timecodeBufferOld;
                        timecodeDecoder = timecodeDecoderOld;
                        if (debug != null) {
                            logger.log(debug, " - keeping TimecodeDecoder: " + timecodeDecoder);
                        }
                    }
                }
                if (timecodeDecoder == null) {
                    timecodeRecRate = 0.0f;
                    timecodeRecFrames = 0;
                    enableRecorder = false;
                    enableScratcher = false;
                }
            }
            if (timecodeDecoder != null && timecodeDecoder.isAudioDecoder()) {
                if (recorderPortsOld == null || !CommonLineFeature.equalsPortArray((Port[])tcAudioPorts, (Port[])recorderPortsOld)) {
                    recorderPorts = tcAudioPorts;
                    if (tcAudioSyncGroup != null) {
                        if (tcAudioPortCount == 1) {
                            tcAudioInput = tcAudioPorts[0].getBuffer();
                        } else if (tcAudioPortCount > 1 && (recorderJoiner = tcAudioSyncGroup.setupAudioJoiner(tcAudioPorts)) != null) {
                            tcAudioInput = recorderJoiner.getOutput();
                        }
                    }
                    if (tcAudioInput == null && tcAudioInputOld != null) {
                        int samples = tcAudioInputOld.getSamples();
                        tcAudioInput = new DoubleArraySampleBuffer(tcAudioInputOld.getChannels(), samples, tcAudioInputOld.getFrameRate(), new double[samples]);
                    }
                    if (debug != null) {
                        logger.log(debug, " - created TimecodeAudioInput: " + tcAudioInput + ", joiner=" + recorderJoiner);
                    }
                } else {
                    recorderPorts = recorderPortsOld;
                    tcAudioInput = tcAudioInputOld;
                    recorderJoiner = recorderJoinerOld;
                    if (debug != null) {
                        logger.log(debug, " - keeping TimecodeAudioInput: " + tcAudioInput + ", joiner=" + recorderJoiner);
                    }
                }
            }
            if (enableRecorder && timecodeDecoder != null && timecodeBuffer != null && this.scratchLine instanceof TimecodeLine) {
                TimecodeLine timecodeLine = (TimecodeLine)this.scratchLine;
                if (timecodeRecorderOld == null || timecodeRecRate != timecodeRecRateOld || timecodeBuffer != timecodeBufferOld) {
                    DefaultSampleCursor targetCursor;
                    CachedTimecodeModel targetTimecodeModel;
                    String timestampString = syncMediator.getTimestampString();
                    String fileNamePrefix = CommonLineFeature.buildFileNamePrefix(waxLab, this.scratchLine, timestampString);
                    if (debug != null) {
                        logger.log(debug, " - creating TimecodeRecorder: sampleRate=" + timecodeRecRate + ", lineOfs=" + lineOfs);
                    }
                    recorderChunkIsNew = true;
                    boolean deleteOnClose = false;
                    TimecodeFile timecodeFile = waxLab.createNewTimecodeFile(fileNamePrefix, timecodeRecRate);
                    recorderCachedModel = waxLab.createCachedTimecodeModel(timecodeFile, deleteOnClose);
                    long sampleIndex = 0L;
                    if (batchMode) {
                        targetTimecodeModel = recorderCachedModel;
                        targetCursor = new DefaultSampleCursor((SampleModel)recorderCachedModel, sampleIndex);
                    } else {
                        int bufferCount = waxLabPreferences.getTimecodeRecorderBufferCount();
                        int bufferSize = (int)Math.ceil((double)waxLabPreferences.getTimecodeRecorderBufferMillis() * (double)timecodeRecRate / 1000.0);
                        boolean fair = waxLabPreferences.isTimecodeRecorderBufferFair();
                        int channels = 1;
                        SampleBuffer[] sampleBuffers = new SampleBuffer[bufferCount];
                        for (int i3 = 0; i3 < bufferCount; ++i3) {
                            sampleBuffers[i3] = new DoubleArraySampleBuffer(channels, bufferSize, timecodeRecRate, new double[bufferSize]);
                        }
                        try {
                            boolean readOnly = false;
                            boolean closeModel = false;
                            LockFactory lockFactory = syncMediator.getLockFactory();
                            ThreadPool writerThreadPool = syncMediator.getWriterThreadPool();
                            ReadWriteLock bufLock = lockFactory.createReadWriteLock(fair);
                            recorderRealModel = new RealTimecodeModel((TimecodeModel)recorderCachedModel, (SampleModel)recorderCachedModel, sampleIndex, readOnly, closeModel, bufferCount, bufferSize, sampleBuffers, bufLock, writerThreadPool);
                            targetTimecodeModel = recorderRealModel;
                            targetCursor = recorderRealModel.openRealtimeCursor(sampleIndex);
                        }
                        catch (IOException e) {
                            throw new AudioException((Throwable)e);
                        }
                        catch (InterruptedException e) {
                            throw new AudioException((Throwable)e);
                        }
                    }
                    long chunkOfs = lineOfs;
                    long chunkEnd = Long.MAX_VALUE;
                    long modelOfs = 0L;
                    long modelEnd = Long.MAX_VALUE;
                    recorderChunk = targetTimecodeModel.createLineChunk(chunkOfs, chunkEnd, modelOfs, modelEnd);
                    timecodeLine.setRecChunk((LineChunk)recorderChunk);
                    timecodeLine.getMutableChunkModel().addChunk((LineChunk)recorderChunk);
                    timecodeRecorder = new WaxLabTimecodeRecorder(timecodeBuffer, (SampleCursor)targetCursor, (SampleModel)targetTimecodeModel);
                    if (debug != null) {
                        logger.log(debug, " - created TimecodeRecorder: " + timecodeRecorder + ", timecodeFile=" + timecodeFile);
                    }
                } else {
                    timecodeRecorder = timecodeRecorderOld;
                    recorderCachedModel = recorderCachedModelOld;
                    recorderRealModel = recorderRealModelOld;
                    recorderChunk = recorderChunkOld;
                    if (debug != null) {
                        logger.log(debug, " - keeping TimecodeRecorder: " + timecodeRecorder);
                    }
                }
            }
            if (audioOutFrames > 0 && (enablePlayback || enableScratcher)) {
                if (enablePreFader && preFaderPortCount > 0) {
                    preFaderOutput = preFaderSyncGroup.createPlayBuffer((SampleBuffer)preFaderOutputOld, audioOutChannels, audioOutFrames, audioOutRate);
                }
                if (enablePostFader && postFaderPortCount > 0) {
                    postFaderOutput = postFaderSyncGroup.createPlayBuffer((SampleBuffer)postFaderOutputOld, audioOutChannels, audioOutFrames, audioOutRate);
                }
                if (audioOutGroup != null && (preFaderOutput != null || postFaderOutput != null)) {
                    scratchOutput = audioOutGroup.createPlayBuffer((SampleBuffer)scratchOutputOld, audioOutChannels, audioOutFrames, audioOutRate);
                }
            }
            Resource scratchResourceOld = null;
            AudioScratchModel scratchModelOld = null;
            if ((enablePlayback || enableScratcher) && scratchOutput != null) {
                scratchModelOld = scratchDeck.getScratchModel();
                scratchResourceOld = scratchDeck.getScratchResource();
                Resource scratchResource = this.scratchResource;
                if (scratchModelOld == null || scratchResource != scratchResourceOld || audioOutChannels != audioOutChannelsOld) {
                    if (debug != null) {
                        logger.log(debug, " - creating ScratchModel: resource=" + scratchResource + ", liveFeed=" + this.liveFeed);
                    }
                    if (!this.liveFeed) {
                        scratchModel = scratchDeck.setupScratchModel(audioOutChannels, audioOutRate, batchMode);
                    } else {
                        sb = null;
                        if (feedRecFrames > 0) {
                            feederPorts = feedAudioPorts;
                            if (feedPortCount == 1) {
                                sb = feedAudioPorts[0].getBuffer();
                            } else {
                                feederJoiner = feedAudioSyncGroup.setupAudioJoiner(feedAudioPorts);
                                if (feederJoiner != null) {
                                    sb = feederJoiner.getOutput();
                                    if (debug != null) {
                                        logger.log(debug, " - created FeederAudioJoiner: " + feederJoiner);
                                    }
                                }
                            }
                        }
                        if (sb == null) {
                            int samples = audioOutFrames * audioOutChannels;
                            sb = new DoubleArraySampleBuffer(audioOutChannels, samples, audioOutRate, new double[samples]);
                        }
                        scratchFeeder = scratchDeck.createScratchFeeder(sb);
                        scratchModel = scratchDeck.setupScratchModel(scratchFeeder, audioOutChannels, audioOutRate, batchMode);
                        scratchFeeder.init(scratchModel);
                    }
                    if (debug != null) {
                        logger.log(debug, " - created ScratchModel: " + scratchModel + ", feeder=" + (Object)((Object)scratchFeeder));
                    }
                } else {
                    scratchModel = scratchModelOld;
                    if (this.liveFeed) {
                        feederPorts = feederPortsOld;
                        feederJoiner = feederJoinerOld;
                        scratchFeeder = scratchFeederOld;
                    }
                    if (debug != null) {
                        logger.log(debug, " - keeping ScratchModel: " + scratchModel + ", feeder=" + (Object)((Object)scratchFeeder));
                    }
                }
            }
            if (scratchModel != scratchModelOld) {
                scratchDeck.setScratchModel(scratchModel);
            }
            if (scratchFeeder != scratchFeederOld) {
                scratchDeck.setScratchFeeder(scratchFeeder);
            }
            if (enableScratcher && timecodeDecoder != null && timecodeBuffer != null && scratchModel != null && scratchOutput != null && audioOutChannels > 0 && this.scratchLine instanceof TimecodeLine) {
                if (scratchPlayerOld == null || !(scratchPlayerOld instanceof RealAudioScratchPlayer) || audioOutRate != audioOutRateOld || audioOutChannels != audioOutChannelsOld || timecodeBuffer != timecodeBufferOld) {
                    if (debug != null) {
                        logger.log(debug, " - creating RealtimeScratcher: sampleRate=" + audioOutRate + ", bufferSize=" + audioOutFrames);
                    }
                    try {
                        double skipThreshold = waxLabPreferences.getScratchNeedleSkipThreshold();
                        if (skipThreshold < 0.0) {
                            skipThreshold = 10.0;
                        }
                        if (skipThreshold < 2.0) {
                            skipThreshold = 2.0;
                        }
                        int pitchMode = scratchDeck.getPitchModeControl().getPitchMode();
                        double pitchFactor = scratchDeck.getPitchFactorControl().getDouble();
                        double pitchBPM = scratchDeck.getPitchBpmControl().getDouble();
                        PitchDeck pitchDeck = scratchDeck.getPitchDeckControl().getPitchDeck();
                        double volume = 1.0;
                        double startFramePos = 0.0;
                        scratchPlayer = new RealAudioScratchPlayer(timecodeBuffer, scratchOutput, skipThreshold, scratchModel, startFramePos, volume, pitchMode, pitchFactor, pitchBPM, pitchDeck);
                        if (debug != null) {
                            logger.log(debug, " - created RealtimeScratcher: " + scratchPlayer);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    scratchPlayer = scratchPlayerOld;
                    if (debug != null) {
                        logger.log(debug, " - keeping RealtimeScratcher: " + scratchPlayer);
                    }
                }
                if (midiActionInputPort != null) {
                    deckMidiActionProcessor = scratchDeck.getMidiActionProcessor();
                }
                if (midiTriggerOutputPort != null) {
                    deckTriggerMidiProcessor = midiTriggerOutputPort.getMidiProcessor();
                }
            }
            if (enablePlayback && scratchModel != null && scratchOutput != null && audioOutChannels > 0) {
                if (scratchPlayerOld == null || !(scratchPlayerOld instanceof DefaultAudioScratchPlayer) || audioOutRate != audioOutRateOld || audioOutChannels != audioOutChannelsOld) {
                    if (debug != null) {
                        logger.log(debug, " - creating PlaybackScratcher: sampleRate=" + audioOutRate + ", bufferSize=" + audioOutFrames);
                    }
                    try {
                        scratchPlayer = null;
                        throw new UnsupportedOperationException("TODO scratch playback: " + this.scratchLine);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    scratchPlayer = scratchPlayerOld;
                    if (debug != null) {
                        logger.log(debug, " - keeping PlaybackScratcher: " + scratchPlayer);
                    }
                }
            }
            if (scratchPlayer != scratchPlayerOld) {
                scratchDeck.setScratchPlayer(scratchPlayer);
            }
            MidiProcessorFaderDecoder faderDecoder = null;
            if (audioFaderEnabled && faderConfigArray != null && scratchPlayer != null && postFaderOutput != null) {
                if (enableScratcher && midiFaderInputPort != null) {
                    if (postFaderMidiProcDecoderOld == null || audioOutChannels != audioOutChannelsOld) {
                        postFaderMidiProcDecoder = new MidiProcessorFaderDecoder();
                        postFaderMidiProcDecoder.setChannelCount(audioOutChannels);
                        postFaderMidiProcDecoder.setFaderConfigArray((FaderConfig[])faderConfigArray);
                        if (debug != null) {
                            logger.log(debug, " - created RealtimeFaderDecoder: " + postFaderMidiProcDecoder);
                        }
                    } else {
                        postFaderMidiProcDecoder = postFaderMidiProcDecoderOld;
                        if (postFaderMidiProcDecoder != null && faderConfigArray != null && !Arrays.equals(faderConfigArray, postFaderMidiProcDecoder.getFaderConfigArray())) {
                            postFaderMidiProcDecoder.setFaderConfigArray((FaderConfig[])faderConfigArray);
                        }
                        if (debug != null) {
                            logger.log(debug, " - keeping RealtimeFaderDecoder: " + postFaderMidiProcDecoder);
                        }
                    }
                    this.postFaderDecoder = postFaderMidiProcDecoder;
                    faderDecoder = postFaderMidiProcDecoder;
                } else if (!enablePlayback || midiLineConfig != null) {
                    // empty if block
                }
            }
            if (faderDecoder != null) {
                if (postFaderVolumeShadersOld == null || audioOutChannels != audioOutChannelsOld || audioOutFrames != audioOutFramesOld) {
                    int eventQueueSize = 4000;
                    int volBufSize = audioOutChannels * audioOutFrames;
                    postFaderVolumeBuffer = postFaderVolumeBufferOld == null || postFaderVolumeBufferOld.length < volBufSize ? new double[volBufSize] : postFaderVolumeBufferOld;
                    postFaderVolumeShaders = new VolumeShader[audioOutChannels];
                    for (int k = 0; k < audioOutChannels; ++k) {
                        VolumeShader shader = VolumeShaderSupport.getInstance().createVolumeShader();
                        shader.setOutputChannels(audioOutChannels);
                        shader.setOutputOffset(k);
                        shader.setOutputBuffer(postFaderVolumeBuffer);
                        shader.setChannelMask(0xFFFFFFFF ^ 1 << k);
                        shader.setEventQueueSize(eventQueueSize);
                        shader.setSampleRate((double)audioOutRate);
                        shader.setVolumeFactor(this.postFaderVolume);
                        postFaderVolumeShaders[k] = shader;
                    }
                    if (debug != null) {
                        logger.log(debug, " - created PostFaderVolumeShader(s): " + postFaderVolumeShaders);
                    }
                } else {
                    postFaderVolumeShaders = postFaderVolumeShadersOld;
                    postFaderVolumeBuffer = postFaderVolumeBufferOld;
                    if (debug != null) {
                        logger.log(debug, " - keeping PostFaderVolumeShader(s): " + postFaderVolumeShaders);
                    }
                }
                if (postFaderVolumeShaders != faderDecoder.getVolumeShaderArray()) {
                    faderDecoder.setVolumeShaderArray(postFaderVolumeShaders);
                    if (postFaderVolumeShaders != null) {
                        for (int k = 0; k < postFaderVolumeShaders.length; ++k) {
                            postFaderVolumeShaders[k].seek();
                        }
                    }
                }
            }
            this.postFaderVolumeShaders = postFaderVolumeShaders;
            boolean bl = syncFeatureChanged = syncFeature != syncFeatureOld;
            if (!syncFeatureChanged && timecodeDecoder == timecodeDecoderOld && timecodeRecorder == timecodeRecorderOld && tcAudioInput == tcAudioInputOld && recorderJoiner == recorderJoinerOld && scratchFeeder == scratchFeederOld && feederJoiner == feederJoinerOld && scratchPlayer == scratchPlayerOld && deckMidiActionProcessor == deckMidiActionProcessorOld && deckTriggerMidiProcessor == deckTriggerMidiProcessorOld && postFaderMidiProcDecoder == postFaderMidiProcDecoderOld && postFaderMidiModelDecoder == postFaderMidiModelDecoderOld && postFaderVolumeShaders == postFaderVolumeShadersOld) {
                logger.info("TODO no changes !");
            }
            if ((audioSyncGroup = postFaderSyncGroup) == null && (audioSyncGroup = preFaderSyncGroup) == null) {
                audioSyncGroup = tcAudioSyncGroup;
            }
            if (audioSyncGroup != null) {
                this.scratchLine.setAudioSyncGroup(audioSyncGroup);
            }
            ScratchInfo info = new ScratchInfo();
            info.audioOutChannels = audioOutChannels;
            info.audioOutRate = audioOutRate;
            info.audioOutFrames = audioOutFrames;
            info.timecodeRecRate = timecodeRecRate;
            info.timecodeRecFrames = timecodeRecFrames;
            info.timecodeFormat = timecodeFormat;
            info.timecodeDecoder = timecodeDecoder;
            info.timecodeBuffer = timecodeBuffer;
            info.timecodeRecorderPrepare = timecodeRecorder != null && timecodeRecorder != timecodeRecorderOld;
            info.recorderCachedModel = recorderCachedModel;
            info.recorderRealModel = recorderRealModel;
            info.recorderChunk = recorderChunk;
            info.scratchOutput = scratchOutput;
            info.preFaderOutput = preFaderOutput;
            info.postFaderVolumeShaders = postFaderVolumeShaders;
            info.postFaderOutput = postFaderOutput;
            List k = this.scratchInfoList;
            synchronized (k) {
                this.scratchInfoList.add(info);
                this.scratchInfoActive = info;
            }
            if (timecodeDecoder != null) {
                if (timecodeDecoder.isAudioDecoder() && tcAudioInput != null) {
                    WaxLabAudioSyncGroup timecodeDecoderGroupOld;
                    WaxLabAudioSyncGroup waxLabAudioSyncGroup = timecodeDecoderGroupOld = timecodeAudioHandlerOld == null ? null : timecodeAudioHandlerOld.group;
                    if (timecodeDecoderGroup != timecodeDecoderGroupOld || timecodeDecoder != timecodeDecoderOld || tcAudioInput != tcAudioInputOld) {
                        if (recorderJoiner != null) {
                            AudioProcessor joiner = recorderJoiner.getJoiner();
                            int priority = 890;
                            recorderJoinHandler = syncFeature.createAudioProcHandler(info, priority, tcAudioSyncGroup, joiner);
                            if (debug != null) {
                                logger.log(debug, " - created TimecodeJoinHandler: " + recorderJoinHandler);
                            }
                        }
                        WaxLabTimecodeAudioProcessor tcAudioProc = new WaxLabTimecodeAudioProcessor(this.scratchLine.getName(), timecodeDecoder, tcAudioInput);
                        int priority = 790;
                        timecodeAudioHandler = syncFeature.createAudioProcHandler(info, priority, tcAudioSyncGroup, tcAudioProc);
                        if (debug != null) {
                            logger.log(debug, " - created TimecodeAudioHandler: " + timecodeAudioHandler);
                        }
                    } else {
                        recorderPorts = recorderPortsOld;
                        recorderJoinHandler = recorderJoinHandlerOld;
                        timecodeAudioHandler = timecodeAudioHandlerOld;
                        if (recorderJoinHandler != null) {
                            recorderJoinHandler.infoObject = info;
                        }
                        if (timecodeAudioHandler != null) {
                            timecodeAudioHandler.infoObject = info;
                        }
                        if (debug != null) {
                            logger.log(debug, " - keeping TimecodeAudioHandler: " + timecodeAudioHandler);
                        }
                    }
                } else if (timecodeDecoder.isMidiDecoder() && tcMidiSyncGroup != null && tcMidiInputPort != null) {
                    WaxLabMidiInputPort tcMidiInputPortOld;
                    WaxLabMidiInputPort waxLabMidiInputPort = tcMidiInputPortOld = timecodeMidiHandlerOld == null ? null : timecodeMidiHandlerOld.port;
                    if (tcMidiInputPort != tcMidiInputPortOld || timecodeDecoder != timecodeDecoderOld) {
                        WaxLabTimecodeMidiProcessor tcMidiProc = new WaxLabTimecodeMidiProcessor(this.scratchLine.getName(), timecodeDecoder);
                        int priority = 790;
                        timecodeMidiHandler = syncFeature.createMidiProcHandler(info, priority, tcMidiInputPort, tcMidiProc);
                        if (debug != null) {
                            logger.log(debug, " - created TimecodeMidiHandler: " + timecodeMidiHandler);
                        }
                    } else {
                        timecodeMidiHandler = timecodeMidiHandlerOld;
                        if (timecodeMidiHandler != null) {
                            timecodeMidiHandler.infoObject = info;
                        }
                        if (debug != null) {
                            logger.log(debug, " - keeping TimecodeMidiHandler: " + timecodeMidiHandler);
                        }
                    }
                }
                if (timecodeAudioHandler != null || timecodeMidiHandler != null) {
                    WaxLabAudioSyncGroup timecodeProducerGroupOld;
                    WaxLabAudioSyncGroup waxLabAudioSyncGroup = timecodeProducerGroupOld = timecodeProducerHandlerOld == null ? null : timecodeProducerHandlerOld.group;
                    if (timecodeProducerGroup != timecodeProducerGroupOld || timecodeDecoder != timecodeDecoderOld) {
                        WaxLabTimecodeProducer tcProducer = new WaxLabTimecodeProducer(this.scratchLine.getName(), timecodeDecoder);
                        int priority = 690;
                        timecodeProducerHandler = syncFeature.createAudioProcHandler(info, priority, timecodeProducerGroup, tcProducer);
                        if (debug != null) {
                            logger.log(debug, " - created TimecodeProducerHandler: " + timecodeProducerHandler);
                        }
                    } else {
                        timecodeProducerHandler = timecodeProducerHandlerOld;
                        if (timecodeProducerHandler != null) {
                            timecodeProducerHandler.infoObject = info;
                        }
                        if (debug != null) {
                            logger.log(debug, " - keeping TimecodeProducerHandler: " + timecodeProducerHandler);
                        }
                    }
                } else {
                    if (debug != null) {
                        logger.log(debug, " - Warning: failed to create timecode producer! (missing audio/midi timecode input)");
                    }
                    if (timecodeRecorder != null) {
                        if (recorderChunkIsNew) {
                            long stopLineOfs = Long.MIN_VALUE;
                            boolean delete = true;
                            this.releaseTimecodeRecorder(timecodeRecorder, stopLineOfs, delete, recorderCachedModel, recorderRealModel, recorderChunk);
                        }
                        timecodeRecorder = null;
                    }
                }
                info.recorderPorts = recorderPorts;
                info.tcAudioInput = tcAudioInput;
                info.recorderJoiner = recorderJoiner;
                info.recorderJoinHandler = recorderJoinHandler;
                info.timecodeAudioHandler = timecodeAudioHandler;
                info.timecodeMidiHandler = timecodeMidiHandler;
                info.timecodeProducerHandler = timecodeProducerHandler;
                info.timecodeRecorder = timecodeRecorder;
            }
            if (timecodeRecorder != null) {
                if (timecodeRecorderHandlerOld == null || timecodeRecorder != timecodeRecorderOld) {
                    int priority = 590;
                    timecodeRecorderHandler = syncFeature.createAudioProcHandler(info, priority, audioOutGroup, timecodeRecorder);
                    if (debug != null) {
                        logger.log(debug, " - created TimecodeRecorderHandler: " + timecodeRecorderHandler);
                    }
                } else {
                    timecodeRecorderHandler = timecodeRecorderHandlerOld;
                    if (timecodeRecorderHandler != null) {
                        timecodeRecorderHandler.infoObject = info;
                    }
                    if (debug != null) {
                        logger.log(debug, " - keeping TimecodeRecorderHandler: " + timecodeRecorderHandler);
                    }
                }
                info.timecodeRecorder = timecodeRecorder;
                info.timecodeRecorderHandler = timecodeRecorderHandler;
            }
            if (scratchFeeder != null) {
                if (feederRecHandlerOld == null || scratchFeeder != scratchFeederOld) {
                    AudioProcessor joiner;
                    if (feederJoiner != null && (joiner = feederJoiner.getJoiner()) != null) {
                        int priority = 880;
                        feederJoinHandler = syncFeature.createAudioProcHandler(info, priority, feedAudioSyncGroup, joiner);
                        if (debug != null) {
                            logger.log(debug, " - created FeederAudioJoiner: " + feederJoinHandler);
                        }
                    }
                    int priority = 580;
                    feederRecHandler = syncFeature.createAudioProcHandler(info, priority, feedAudioSyncGroup, scratchFeeder);
                    if (debug != null) {
                        logger.log(debug, " - created FeederRecHandler: " + feederRecHandler);
                    }
                } else {
                    feederJoinHandler = feederJoinHandlerOld;
                    if (feederJoinHandler != null) {
                        feederJoinHandler.infoObject = info;
                    }
                    if ((feederRecHandler = feederRecHandlerOld) != null) {
                        feederRecHandler.infoObject = info;
                    }
                    if (debug != null) {
                        logger.log(debug, " - keeping FeederRecHandler: " + feederRecHandler);
                    }
                }
                info.feederPorts = feederPorts;
                info.feederJoiner = feederJoiner;
                info.feederJoinHandler = feederJoinHandler;
                info.scratchFeeder = scratchFeeder;
                info.feederRecHandler = feederRecHandler;
            }
            if (scratchPlayer != null) {
                if (scratchPlayerHandlerOld == null || scratchPlayer != scratchPlayerOld) {
                    int priority = 490;
                    scratchPlayerHandler = syncFeature.createAudioProcHandler(info, priority, audioOutGroup, (AudioProcessor)scratchPlayer);
                    if (debug != null) {
                        logger.log(debug, " - created ScratchPlayerHandler: " + scratchPlayerHandler);
                    }
                } else {
                    scratchPlayerHandler = scratchPlayerHandlerOld;
                    if (scratchPlayerHandler != null) {
                        scratchPlayerHandler.infoObject = info;
                    }
                    if (debug != null) {
                        logger.log(debug, " - keeping ScratchPlayerHandler: " + scratchPlayerHandler);
                    }
                }
                info.scratchPlayer = scratchPlayer;
                info.scratchPlayerHandler = scratchPlayerHandler;
            }
            if (postFaderMidiProcDecoder != null) {
                if (postFaderMidiProcHandlerOld == null || postFaderMidiProcDecoder != postFaderMidiProcDecoderOld) {
                    int priority = 780;
                    postFaderMidiProcHandler = syncFeature.createMidiProcHandler(info, priority, midiFaderInputPort, (MidiProcessor)postFaderMidiProcDecoder);
                    if (debug != null) {
                        logger.log(debug, " - created PostFaderMidiHandler: " + postFaderMidiProcHandler);
                    }
                } else {
                    postFaderMidiProcHandler = postFaderMidiProcHandlerOld;
                    if (postFaderMidiProcHandler != null) {
                        postFaderMidiProcHandler.infoObject = info;
                    }
                    if (debug != null) {
                        logger.log(debug, " - keeping PostFaderMidiHandler: " + postFaderMidiProcHandler);
                    }
                }
                info.postFaderMidiProcDecoder = postFaderMidiProcDecoder;
                info.postFaderMidiProcHandler = postFaderMidiProcHandler;
            }
            if (deckMidiActionProcessor != null) {
                if (deckMidiActionProcHandlerOld == null || deckMidiActionProcessor != deckMidiActionProcessorOld) {
                    int priority = 770;
                    deckMidiActionProcHandler = syncFeature.createMidiProcHandler(info, priority, midiActionInputPort, (MidiProcessor)deckMidiActionProcessor);
                    if (debug != null) {
                        logger.log(debug, " - created DeckMidiHandler: " + deckMidiActionProcHandler);
                    }
                } else {
                    deckMidiActionProcHandler = deckMidiActionProcHandlerOld;
                    if (deckMidiActionProcHandler != null) {
                        deckMidiActionProcHandler.infoObject = info;
                    }
                    if (debug != null) {
                        logger.log(debug, " - keeping DeckMidiHandler: " + deckMidiActionProcHandler);
                    }
                }
                info.deckMidiActionProcessor = deckMidiActionProcessor;
                info.deckMidiActionProcHandler = deckMidiActionProcHandler;
            }
            info.deckTriggerMidiProcessor = deckTriggerMidiProcessor;
            if (deckTriggerMidiProcessor != deckTriggerMidiProcessorOld) {
                scratchDeck.setTargetMidiProcessor(deckTriggerMidiProcessor);
                if (deckTriggerMidiProcessor != null) {
                    scratchDeck.refreshDeckLightings();
                }
            }
            WaxLabAudioThru preFaderAudioThru = null;
            WaxLabAudioThru postFaderAudioThru = null;
            if (scratchPlayerHandler != null) {
                if (enablePreFader && preFaderOutput != null) {
                    double[] src = scratchOutput.array();
                    double[] dst = preFaderOutput.array();
                    if (preFaderPlayHandlerOld == null || preFaderOutput != preFaderOutputOld || scratchOutput != scratchOutputOld) {
                        preFaderAudioThru = new WaxLabAudioThru(audioOutChannels, src, dst, this.preFaderVolume);
                        int priority = 290;
                        preFaderPlayHandler = syncFeature.createAudioProcHandler(info, priority, preFaderSyncGroup, preFaderAudioThru);
                        if (debug != null) {
                            logger.log(debug, " - created PreFaderThruHandler: " + preFaderPlayHandler);
                        }
                    } else {
                        preFaderPlayHandler = preFaderPlayHandlerOld;
                        if (preFaderPlayHandler != null) {
                            preFaderPlayHandler.infoObject = info;
                        }
                        preFaderAudioThru = this.preFaderAudioThru;
                        if (debug != null) {
                            logger.log(debug, " - keeping PreFaderThruHandler: " + preFaderPlayHandler);
                        }
                    }
                    if (preFaderPlayHandler != null) {
                        if (preFaderOutHandlerOld == null || preFaderPlayHandler != preFaderPlayHandlerOld || preFaderOutput != preFaderOutputOld || !CommonLineFeature.equalsPortArray((Port[])preFaderPorts, (Port[])preFaderPortsOld)) {
                            int priority = 90;
                            preFaderOutHandler = syncFeature.createAudioOutHandler(info, priority, preFaderSyncGroup, preFaderPorts, (SampleBuffer)preFaderOutput);
                            if (debug != null) {
                                logger.log(debug, " - created PreFaderOutHandler: " + preFaderOutHandler);
                            }
                        } else {
                            preFaderOutHandler = preFaderOutHandlerOld;
                            if (preFaderOutHandler != null) {
                                preFaderOutHandler.infoObject = info;
                            }
                            if (debug != null) {
                                logger.log(debug, " - keeping PreFaderOutHandler: " + preFaderOutHandler);
                            }
                        }
                    }
                }
                info.preFaderPlayHandler = preFaderPlayHandler;
                info.preFaderOutHandler = preFaderOutHandler;
                info.preFaderPorts = preFaderPorts;
                if (enablePostFader && postFaderOutput != null) {
                    double[] src = scratchOutput.array();
                    double[] dst = postFaderOutput.array();
                    if (postFaderVolumeShaders == null) {
                        if (postFaderPlayHandlerOld == null || postFaderOutput != postFaderOutputOld || scratchOutput != scratchOutputOld || postFaderVolumeShaders != postFaderVolumeShadersOld) {
                            postFaderAudioThru = new WaxLabAudioThru(audioOutChannels, src, dst, this.postFaderVolume);
                            int priority = 280;
                            postFaderPlayHandler = syncFeature.createAudioProcHandler(info, priority, postFaderSyncGroup, postFaderAudioThru);
                            if (debug != null) {
                                logger.log(debug, " - created PostFaderThruHandler: " + postFaderPlayHandler);
                            }
                        } else {
                            postFaderPlayHandler = postFaderPlayHandlerOld;
                            if (postFaderPlayHandler != null) {
                                postFaderPlayHandler.infoObject = info;
                            }
                            postFaderAudioThru = this.postFaderAudioThru;
                            if (debug != null) {
                                logger.log(debug, " - keeping PostFaderThruHandler: " + postFaderPlayHandler);
                            }
                        }
                    } else if (postFaderPlayHandlerOld == null || postFaderOutput != postFaderOutputOld || scratchOutput != scratchOutputOld || postFaderVolumeShaders != postFaderVolumeShadersOld || postFaderVolumeBuffer != postFaderVolumeBufferOld) {
                        WaxLabAudioFader audioFader = new WaxLabAudioFader(audioOutChannels, postFaderVolumeShaders, postFaderVolumeBuffer, src, dst);
                        int priority = 280;
                        postFaderPlayHandler = syncFeature.createAudioProcHandler(info, priority, postFaderSyncGroup, audioFader);
                        if (debug != null) {
                            logger.log(debug, " - created PostFaderProcHandler: " + postFaderPlayHandler);
                        }
                    } else {
                        postFaderPlayHandler = postFaderPlayHandlerOld;
                        if (postFaderPlayHandler != null) {
                            postFaderPlayHandler.infoObject = info;
                        }
                        if (debug != null) {
                            logger.log(debug, " - keeping PostFaderProcHandler: " + postFaderPlayHandler);
                        }
                    }
                    if (postFaderPlayHandler != null) {
                        if (postFaderOutHandlerOld == null || postFaderPlayHandler != postFaderPlayHandlerOld || postFaderOutput != postFaderOutputOld || !CommonLineFeature.equalsPortArray((Port[])postFaderPorts, (Port[])postFaderPortsOld)) {
                            int priority = 80;
                            postFaderOutHandler = syncFeature.createAudioOutHandler(info, priority, postFaderSyncGroup, postFaderPorts, (SampleBuffer)postFaderOutput);
                            if (debug != null) {
                                logger.log(debug, " - created PostFaderOutHandler: " + postFaderOutHandler);
                            }
                        } else {
                            postFaderOutHandler = postFaderOutHandlerOld;
                            if (postFaderOutHandler != null) {
                                postFaderOutHandler.infoObject = info;
                            }
                            if (debug != null) {
                                logger.log(debug, " - keeping PostFaderOutHandler: " + postFaderOutHandler);
                            }
                        }
                    }
                }
                info.postFaderPlayHandler = postFaderPlayHandler;
                info.postFaderOutHandler = postFaderOutHandler;
                info.postFaderPorts = postFaderPorts;
            }
            this.preFaderAudioThru = preFaderAudioThru;
            this.postFaderAudioThru = postFaderAudioThru;
            if (syncFeatureOld != null) {
                if (syncFeatureChanged || recorderJoinHandler != recorderJoinHandlerOld) {
                    syncFeatureOld.removeSyncHandler(recorderJoinHandlerOld);
                    if (feederJoinHandlerOld == recorderJoinHandlerOld) {
                        feederJoinHandlerOld = null;
                    }
                }
                if (syncFeatureChanged || feederJoinHandler != feederJoinHandlerOld) {
                    syncFeatureOld.removeSyncHandler(feederJoinHandlerOld);
                    if (recorderJoinHandlerOld == feederJoinHandlerOld) {
                        recorderJoinHandlerOld = null;
                    }
                }
                if (syncFeatureChanged || timecodeAudioHandler != timecodeAudioHandlerOld) {
                    syncFeatureOld.removeSyncHandler(timecodeAudioHandlerOld);
                }
                if (syncFeatureChanged || timecodeMidiHandler != timecodeMidiHandlerOld) {
                    syncFeatureOld.removeSyncHandler(timecodeMidiHandlerOld);
                }
                if (syncFeatureChanged || timecodeProducerHandler != timecodeProducerHandlerOld) {
                    if (prevInfo != null) {
                        prevInfo.stopLineOfs = lineOfs;
                    }
                    syncFeatureOld.removeSyncHandler(timecodeProducerHandlerOld);
                }
                if (syncFeatureChanged || feederRecHandler != feederRecHandlerOld) {
                    syncFeatureOld.removeSyncHandler(feederRecHandlerOld);
                }
                if (syncFeatureChanged || timecodeRecorderHandler != timecodeRecorderHandlerOld) {
                    syncFeatureOld.removeSyncHandler(timecodeRecorderHandlerOld);
                }
                if (syncFeatureChanged || scratchPlayerHandler != scratchPlayerHandlerOld) {
                    syncFeatureOld.removeSyncHandler(scratchPlayerHandlerOld);
                }
                if (syncFeatureChanged || postFaderMidiProcHandler != postFaderMidiProcHandlerOld) {
                    syncFeatureOld.removeSyncHandler(postFaderMidiProcHandlerOld);
                }
                if (syncFeatureChanged || deckMidiActionProcHandler != deckMidiActionProcHandlerOld) {
                    syncFeatureOld.removeSyncHandler(deckMidiActionProcHandlerOld);
                }
                if (syncFeatureChanged || preFaderPlayHandler != preFaderPlayHandlerOld) {
                    syncFeatureOld.removeSyncHandler(preFaderPlayHandlerOld);
                }
                if (syncFeatureChanged || preFaderOutHandler != preFaderOutHandlerOld) {
                    syncFeatureOld.removeSyncHandler(preFaderOutHandlerOld);
                }
                if (syncFeatureChanged || postFaderPlayHandler != postFaderPlayHandlerOld) {
                    syncFeatureOld.removeSyncHandler(postFaderPlayHandlerOld);
                }
                if (syncFeatureChanged || postFaderOutHandler != postFaderOutHandlerOld) {
                    syncFeatureOld.removeSyncHandler(postFaderOutHandlerOld);
                }
            }
            this.syncFeatureOld = syncFeature;
            if (syncFeature != null) {
                if (syncFeatureChanged || recorderJoinHandler != recorderJoinHandlerOld) {
                    syncFeature.insertSyncHandler(recorderJoinHandler);
                }
                if (syncFeatureChanged || feederJoinHandler != feederJoinHandlerOld) {
                    syncFeature.insertSyncHandler(feederJoinHandler);
                }
                if (syncFeatureChanged || timecodeAudioHandler != timecodeAudioHandlerOld) {
                    syncFeature.insertSyncHandler(timecodeAudioHandler);
                }
                if (syncFeatureChanged || timecodeMidiHandler != timecodeMidiHandlerOld) {
                    syncFeature.insertSyncHandler(timecodeMidiHandler);
                }
                if (syncFeatureChanged || timecodeProducerHandler != timecodeProducerHandlerOld) {
                    syncFeature.insertSyncHandler(timecodeProducerHandler);
                }
                if (syncFeatureChanged || feederRecHandler != feederRecHandlerOld) {
                    syncFeature.insertSyncHandler(feederRecHandler);
                }
                if (syncFeatureChanged || timecodeRecorderHandler != timecodeRecorderHandlerOld) {
                    syncFeature.insertSyncHandler(timecodeRecorderHandler);
                }
                if (syncFeatureChanged || scratchPlayerHandler != scratchPlayerHandlerOld) {
                    syncFeature.insertSyncHandler(scratchPlayerHandler);
                }
                if (syncFeatureChanged || postFaderMidiProcHandler != postFaderMidiProcHandlerOld) {
                    syncFeature.insertSyncHandler(postFaderMidiProcHandler);
                }
                if (syncFeatureChanged || deckMidiActionProcHandler != deckMidiActionProcHandlerOld) {
                    syncFeature.insertSyncHandler(deckMidiActionProcHandler);
                }
                if (syncFeatureChanged || preFaderPlayHandler != preFaderPlayHandlerOld) {
                    syncFeature.insertSyncHandler(preFaderPlayHandler);
                }
                if (syncFeatureChanged || preFaderOutHandler != preFaderOutHandlerOld) {
                    syncFeature.insertSyncHandler(preFaderOutHandler);
                }
                if (syncFeatureChanged || postFaderPlayHandler != postFaderPlayHandlerOld) {
                    syncFeature.insertSyncHandler(postFaderPlayHandler);
                }
                if (syncFeatureChanged || postFaderOutHandler != postFaderOutHandlerOld) {
                    syncFeature.insertSyncHandler(postFaderOutHandler);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabAudioSyncGroup audioSyncGroup, long lineOfs, long studioTime, long masterTime) {
        MutableLineChunk recorderChunk;
        Object infoObject = syncHandler.getInfoObject();
        ScratchInfo info = null;
        if (infoObject != null && infoObject instanceof ScratchInfo) {
            info = (ScratchInfo)infoObject;
        }
        if (info == null) {
            return;
        }
        boolean recorderNew = false;
        ScratchManagerImpl scratchManagerImpl = this;
        synchronized (scratchManagerImpl) {
            if (syncHandler == info.timecodeProducerHandler) {
                recorderNew = info.timecodeRecorderPrepare;
            }
        }
        if (recorderNew && (recorderChunk = info.recorderChunk) != null) {
            try {
                MutableChunkModel chunkModel;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("     - prepare TimecodeRecorder: lineOfs=" + lineOfs + ", chunkLineOfs=" + recorderChunk.getChunkOfs() + " -> " + lineOfs + ", modelOfs=" + recorderChunk.getModelOfs() + ", modelEnd=" + recorderChunk.getModelEnd());
                }
                if ((chunkModel = this.scratchLine.getMutableChunkModel()) != null) {
                    chunkModel.moveChunk((LineChunk)recorderChunk, lineOfs, recorderChunk.getChunkEnd(), recorderChunk.getZOrder());
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiInputPort midiInputPort, long lineOfs, long studioTime, long masterTime) {
    }

    @Override
    protected void prepareSyncHandler(SyncHandler syncHandler, WaxLabMidiOutputPort midiOutputPort, long lineOfs, long studioTime, long masterTime) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseSyncHandler(SyncHandler syncHandler) {
        SyncHandler.AudioProcHandler joinHandler;
        Object infoObject = syncHandler.getInfoObject();
        ScratchInfo info = null;
        if (infoObject != null && infoObject instanceof ScratchInfo) {
            info = (ScratchInfo)infoObject;
        }
        if (info == null) {
            return;
        }
        CachedTimecodeModel releaseRecorderModel = null;
        WaxLabAudioJoinerInfo releaseTimecodeJoiner = null;
        WaxLabLiveFeeder releaseLiveFeeder = null;
        WaxLabAudioJoinerInfo releaseLiveFeedJoiner = null;
        AbstractAudioScratchPlayer releaseScratchPlayer = null;
        ScratchManagerImpl scratchManagerImpl = this;
        synchronized (scratchManagerImpl) {
            ScratchInfo activeInfo = this.scratchInfoActive;
            if (syncHandler == info.timecodeProducerHandler) {
                releaseRecorderModel = info.recorderCachedModel;
                if (releaseRecorderModel != null) {
                    CachedTimecodeModel activeCachedModel;
                    CachedTimecodeModel cachedTimecodeModel = activeCachedModel = activeInfo == null ? null : activeInfo.recorderCachedModel;
                    if (info == activeInfo || releaseRecorderModel != activeCachedModel) {
                        info.recorderCachedModel = null;
                    } else {
                        releaseRecorderModel = null;
                    }
                }
                if ((releaseTimecodeJoiner = info.recorderJoiner) != null) {
                    WaxLabAudioJoinerInfo activeTimecodeJoiner;
                    WaxLabAudioJoinerInfo waxLabAudioJoinerInfo = activeTimecodeJoiner = activeInfo == null ? null : activeInfo.recorderJoiner;
                    if (info == activeInfo || releaseTimecodeJoiner != activeTimecodeJoiner) {
                        info.recorderJoiner = null;
                    } else {
                        releaseTimecodeJoiner = null;
                    }
                }
            }
            if (syncHandler == info.feederRecHandler) {
                releaseLiveFeeder = info.scratchFeeder;
                if (releaseLiveFeeder != null) {
                    WaxLabLiveFeeder activeScratchFeeder;
                    WaxLabLiveFeeder waxLabLiveFeeder = activeScratchFeeder = activeInfo == null ? null : activeInfo.scratchFeeder;
                    if (info == activeInfo || releaseLiveFeeder != activeScratchFeeder) {
                        info.scratchFeeder = null;
                    } else {
                        releaseLiveFeeder = null;
                    }
                }
                if ((releaseLiveFeedJoiner = info.feederJoiner) != null) {
                    WaxLabAudioJoinerInfo activeLiveFeedJoiner;
                    WaxLabAudioJoinerInfo waxLabAudioJoinerInfo = activeLiveFeedJoiner = activeInfo == null ? null : activeInfo.feederJoiner;
                    if (info == activeInfo || releaseLiveFeedJoiner != activeLiveFeedJoiner) {
                        info.feederJoiner = null;
                    } else {
                        releaseLiveFeedJoiner = null;
                    }
                }
            }
            if (syncHandler == info.scratchPlayerHandler && (releaseScratchPlayer = info.scratchPlayer) != null) {
                AbstractAudioScratchPlayer activeScratchPlayer;
                AbstractAudioScratchPlayer abstractAudioScratchPlayer = activeScratchPlayer = activeInfo == null ? null : activeInfo.scratchPlayer;
                if (info == activeInfo || releaseScratchPlayer != activeScratchPlayer) {
                    info.scratchPlayer = null;
                } else {
                    releaseScratchPlayer = null;
                }
            }
            if (info.recorderCachedModel == null && info.recorderJoiner == null && info.scratchFeeder == null && info.feederJoiner == null && info.scratchPlayer == null) {
                this.scratchInfoList.remove(info);
                if (this.scratchInfoActive == info) {
                    this.scratchInfoActive = null;
                }
            }
        }
        WaxLabScratchDeck scratchDeck = this.scratchLine.getWaxLabScratchDeck();
        if (releaseScratchPlayer != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, " - closing ScratchPlayer: " + releaseScratchPlayer);
            }
            if (scratchDeck != null) {
                scratchDeck.releaseScratchPlayer(releaseScratchPlayer);
            }
            try {
                releaseScratchPlayer.shutdown();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                info.scratchPlayer = null;
                info.scratchPlayerHandler = null;
            }
        }
        if (releaseRecorderModel != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, " - closing TimecodeRecorder: " + info.timecodeRecorder);
            }
            try {
                WaxLabTimecodeRecorder timecodeRecorder = info.timecodeRecorder;
                long stopLineOfs = info.stopLineOfs;
                boolean delete = false;
                this.releaseTimecodeRecorder(timecodeRecorder, stopLineOfs, delete, releaseRecorderModel, info.recorderRealModel, info.recorderChunk);
            }
            finally {
                info.timecodeRecorder = null;
                info.timecodeRecorderHandler = null;
                info.recorderCachedModel = null;
                info.recorderRealModel = null;
                info.recorderChunk = null;
            }
        }
        if (releaseTimecodeJoiner != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, " - closing TimecodeJoiner: " + releaseTimecodeJoiner);
            }
            try {
                joinHandler = info.recorderJoinHandler;
                if (joinHandler != null) {
                    WaxLabAudioSyncGroup syncGroup;
                    WaxLabAudioSyncGroup waxLabAudioSyncGroup = syncGroup = joinHandler == null ? null : joinHandler.group;
                    if (syncGroup != null) {
                        syncGroup.releaseAudioJoiner(releaseTimecodeJoiner);
                    }
                }
            }
            finally {
                info.recorderJoiner = null;
                info.recorderJoinHandler = null;
            }
        }
        if (releaseLiveFeeder != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, " - closing LiveFeeder: " + (Object)((Object)releaseLiveFeeder));
            }
            try {
                releaseLiveFeeder.shutdown();
                releaseLiveFeeder.close();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                info.scratchFeeder = null;
                info.feederRecHandler = null;
            }
        }
        if (releaseLiveFeedJoiner != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, " - closing LiveFeedJoiner: " + releaseLiveFeedJoiner);
            }
            try {
                joinHandler = info.feederJoinHandler;
                if (joinHandler != null) {
                    WaxLabAudioSyncGroup syncGroup;
                    WaxLabAudioSyncGroup waxLabAudioSyncGroup = syncGroup = joinHandler == null ? null : joinHandler.group;
                    if (syncGroup != null) {
                        syncGroup.releaseAudioJoiner(releaseLiveFeedJoiner);
                    }
                }
            }
            finally {
                info.feederJoiner = null;
                info.feederJoinHandler = null;
            }
        }
    }

    protected void releaseTimecodeRecorder(WaxLabTimecodeRecorder timecodeRecorder, long stopLineOfs, boolean delete, CachedTimecodeModel cachedModel, RealTimecodeModel realModel, MutableLineChunk chunk) {
        MutableChunkModel chunkModel;
        logger.info("releaseTimecodeRecorder: timecodeRecorder=" + timecodeRecorder + ", stopLineOfs=" + stopLineOfs + ", delete=" + delete + ", cachedModel=" + cachedModel + ", realModel=" + realModel + ", chunk=" + chunk);
        if (this.scratchLine.getRecChunk() == chunk) {
            this.scratchLine.setRecChunk(null);
        }
        if (timecodeRecorder != null) {
            try {
                timecodeRecorder.shutdown();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (realModel != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Closing RealTimecodeModel (only): " + realModel + " -> " + cachedModel);
            }
            try {
                realModel.close();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            realModel = null;
        }
        if ((chunkModel = this.scratchLine.getMutableChunkModel()) != null && chunk != null && cachedModel != null) {
            try {
                if (!delete) {
                    long chunkOfs = chunk.getChunkOfs();
                    long modelOfs = chunk.getModelOfs();
                    long chunkEnd = stopLineOfs;
                    if (chunkEnd == Long.MIN_VALUE) {
                        logger.info("TODO chunkOfs=" + chunkOfs + ", stopLineOfs=" + chunkEnd);
                        chunkEnd = chunkOfs + cachedModel.getNanoLength() - modelOfs;
                    }
                    if (chunkEnd < chunkOfs) {
                        chunkEnd = chunkOfs;
                    }
                    long modelEnd = chunkEnd - chunkOfs + modelOfs;
                    MutableLineChunk recordedAudioChunk = cachedModel.createLineChunk(chunkOfs, chunkEnd, modelOfs, modelEnd);
                    chunkModel.addChunk((LineChunk)recordedAudioChunk);
                }
                chunkModel.removeChunk((LineChunk)chunk);
                chunk.close();
                if (delete) {
                    cachedModel.setDeleteOnClose(true);
                    cachedModel.close();
                }
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected static class ScratchInfo {
        protected WaxLabAudioInputPort[] recorderPorts;
        protected SampleBuffer tcAudioInput;
        protected WaxLabAudioJoinerInfo recorderJoiner;
        protected SyncHandler.AudioProcHandler recorderJoinHandler;
        protected boolean timecodeRecorderPrepare;
        protected WaxLabTimecodeRecorder timecodeRecorder;
        protected SyncHandler.AudioProcHandler timecodeRecorderHandler;
        protected CachedTimecodeModel recorderCachedModel;
        protected RealTimecodeModel recorderRealModel;
        protected MutableLineChunk recorderChunk;
        protected long stopLineOfs = Long.MIN_VALUE;
        protected int audioOutChannels;
        protected float audioOutRate;
        protected int audioOutFrames;
        protected float timecodeRecRate;
        protected int timecodeRecFrames;
        protected TimecodeFormat timecodeFormat;
        protected TimecodeDecoder timecodeDecoder;
        protected double[] timecodeBuffer;
        protected SyncHandler.AudioProcHandler timecodeAudioHandler;
        protected SyncHandler.MidiProcHandler timecodeMidiHandler;
        protected SyncHandler.AudioProcHandler timecodeProducerHandler;
        protected WaxLabAudioInputPort[] feederPorts;
        protected WaxLabAudioJoinerInfo feederJoiner;
        protected SyncHandler.AudioProcHandler feederJoinHandler;
        protected WaxLabLiveFeeder scratchFeeder;
        protected SyncHandler.AudioProcHandler feederRecHandler;
        protected AbstractAudioScratchPlayer scratchPlayer;
        protected SyncHandler.AudioProcHandler scratchPlayerHandler;
        protected MidiActionProcessor deckMidiActionProcessor;
        protected SyncHandler.MidiProcHandler deckMidiActionProcHandler;
        protected MidiProcessor deckTriggerMidiProcessor;
        protected DoubleArraySampleBuffer scratchOutput;
        protected WaxLabAudioOutputPort[] preFaderPorts;
        protected DoubleArraySampleBuffer preFaderOutput;
        protected SyncHandler.AudioProcHandler preFaderPlayHandler;
        protected SyncHandler.AudioOutHandler preFaderOutHandler;
        protected MidiProcessorFaderDecoder postFaderMidiProcDecoder;
        protected SyncHandler.MidiProcHandler postFaderMidiProcHandler;
        protected MidiModelFaderDecoder postFaderMidiModelDecoder;
        protected VolumeShader[] postFaderVolumeShaders;
        protected double[] postFaderVolumeBuffer;
        protected WaxLabAudioOutputPort[] postFaderPorts;
        protected DoubleArraySampleBuffer postFaderOutput;
        protected SyncHandler.AudioProcHandler postFaderPlayHandler;
        protected SyncHandler.AudioOutHandler postFaderOutHandler;

        protected ScratchInfo() {
        }
    }
}

