/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Platform;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.waxlab.LineFeature;
import com.waxmonster.waxlab.impl.AbstractLineFeature;
import com.waxmonster.waxlab.impl.MidiPlayer;
import com.waxmonster.waxlab.impl.SyncFeature;
import com.waxmonster.waxlab.impl.SyncHandler;
import com.waxmonster.waxlab.impl.WaxLabAudioOutputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SyncFeatureImpl
implements SyncFeature {
    private static final Logger logger = Platform.getLogger(SyncFeatureImpl.class);
    final AbstractLineFeature lineFeature;
    protected long startLineOfs;
    protected List handlerList;
    protected Set handlerSet;
    protected List handlersToInsertList;
    protected Set handlersToInsertSet;
    protected List handlersToRemoveList;
    protected Set handlersToRemoveSet;

    public SyncFeatureImpl(AbstractLineFeature lineFeature) {
        this.lineFeature = lineFeature;
        this.handlerList = new ArrayList();
        this.handlerSet = new HashSet();
        this.handlersToInsertList = new ArrayList();
        this.handlersToInsertSet = new HashSet();
        this.handlersToRemoveList = new ArrayList();
        this.handlersToRemoveSet = new HashSet();
    }

    @Override
    public final LineFeature getLineFeature() {
        return this.lineFeature;
    }

    public final AbstractLineFeature getAbstractLineFeature() {
        return this.lineFeature;
    }

    @Override
    public long getStartLineOfs() {
        return this.startLineOfs;
    }

    public void setStartLineOfs(long startLineOfs) {
        this.startLineOfs = startLineOfs;
    }

    @Override
    public SyncHandler.AudioProcHandler createAudioProcHandler(Object infoObject, int priority, WaxLabAudioSyncGroup group, AudioProcessor proc) {
        return new SyncHandler.AudioProcHandler(this, infoObject, priority, group, proc);
    }

    @Override
    public SyncHandler.AudioOutHandler createAudioOutHandler(Object infoObject, int priority, WaxLabAudioSyncGroup group, WaxLabAudioOutputPort[] ports, SampleBuffer source) {
        return new SyncHandler.AudioOutHandler(this, infoObject, priority, group, ports, source);
    }

    @Override
    public SyncHandler.MidiProcHandler createMidiProcHandler(Object infoObject, int priority, WaxLabMidiInputPort port, MidiProcessor proc) {
        return new SyncHandler.MidiProcHandler(this, infoObject, priority, port, proc);
    }

    @Override
    public SyncHandler.MidiOutHandler createMidiOutHandler(Object infoObject, int priority, WaxLabMidiOutputPort port, MidiPlayer player) {
        return new SyncHandler.MidiOutHandler(this, infoObject, priority, port, player);
    }

    @Override
    public synchronized void insertSyncHandler(SyncHandler syncHandler) {
        if (syncHandler == null) {
            return;
        }
        if (this.handlersToRemoveSet.remove(syncHandler)) {
            this.handlersToRemoveList.remove(syncHandler);
            return;
        }
        if (this.handlersToInsertSet.contains(syncHandler)) {
            return;
        }
        if (this.handlerSet.contains(syncHandler)) {
            return;
        }
        this.handlersToInsertList.add(syncHandler);
        this.handlersToInsertSet.add(syncHandler);
    }

    @Override
    public synchronized void removeSyncHandler(SyncHandler syncHandler) {
        if (syncHandler == null) {
            return;
        }
        if (this.handlersToInsertSet.remove(syncHandler)) {
            this.handlersToInsertList.remove(syncHandler);
            return;
        }
        if (this.handlersToRemoveSet.contains(syncHandler)) {
            return;
        }
        if (!this.handlerSet.contains(syncHandler)) {
            return;
        }
        this.handlersToRemoveList.add(syncHandler);
        this.handlersToRemoveSet.add(syncHandler);
    }

    protected void releaseSyncHandler(SyncHandler syncHandler) {
        try {
            this.lineFeature.releaseSyncHandler(syncHandler);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

