/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.waxlab.impl.AbstractLineFeature;
import com.waxmonster.waxlab.impl.MidiPlayer;
import com.waxmonster.waxlab.impl.SyncFeature;
import com.waxmonster.waxlab.impl.SyncFeatureImpl;
import com.waxmonster.waxlab.impl.WaxLabAudioOutputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;

public abstract class SyncHandler {
    public static final int PRIORITY_JOIN = 900;
    public static final int PRIORITY_DECODE = 800;
    public static final int PRIORITY_PRODUCE = 700;
    public static final int PRIORITY_RECORD = 600;
    public static final int PRIORITY_SCRATCH = 500;
    public static final int PRIORITY_PLAYBACK = 300;
    public static final int PRIORITY_OUTPUT = 100;
    protected final SyncFeatureImpl syncFeature;
    int lastUsedId;
    protected Object infoObject;
    protected final int priority;

    public SyncHandler(SyncFeatureImpl syncFeature, Object infoObject, int priority) {
        this.syncFeature = syncFeature;
        this.infoObject = infoObject;
        this.priority = priority;
    }

    protected final SyncFeatureImpl getSyncFeatureImpl() {
        return this.syncFeature;
    }

    public final SyncFeature getSyncFeature() {
        return this.syncFeature;
    }

    public Object getInfoObject() {
        return this.infoObject;
    }

    public int getPriority() {
        return this.priority;
    }

    public String toString() {
        SyncFeatureImpl sf = this.syncFeature;
        AbstractLineFeature lf = sf == null ? null : sf.lineFeature;
        return super.toString() + "[" + lf + "]";
    }

    public static class MidiOutHandler
    extends SyncHandler {
        protected WaxLabMidiOutputPort port;
        protected MidiPlayer player;

        public MidiOutHandler(SyncFeatureImpl syncFeature, Object infoObject, int priority, WaxLabMidiOutputPort port, MidiPlayer player) {
            super(syncFeature, infoObject, priority);
            this.port = port;
            this.player = player;
        }
    }

    public static class MidiProcHandler
    extends SyncHandler {
        protected WaxLabMidiInputPort port;
        protected MidiProcessor proc;

        public MidiProcHandler(SyncFeatureImpl syncFeature, Object infoObject, int priority, WaxLabMidiInputPort port, MidiProcessor proc) {
            super(syncFeature, infoObject, priority);
            this.port = port;
            this.proc = proc;
        }
    }

    public static class AudioOutHandler
    extends SyncHandler {
        protected WaxLabAudioSyncGroup group;
        protected WaxLabAudioOutputPort[] ports;
        protected SampleBuffer source;
        protected AudioProcessor splitter;
        protected SampleBuffer[] targets;

        public AudioOutHandler(SyncFeatureImpl syncFeature, Object infoObject, int priority, WaxLabAudioSyncGroup group, WaxLabAudioOutputPort[] ports, SampleBuffer source) {
            super(syncFeature, infoObject, priority);
            this.group = group;
            this.ports = ports;
            this.source = source;
        }
    }

    public static class AudioProcHandler
    extends SyncHandler {
        protected WaxLabAudioSyncGroup group;
        protected AudioProcessor proc;

        public AudioProcHandler(SyncFeatureImpl syncFeature, Object infoObject, int priority, WaxLabAudioSyncGroup group, AudioProcessor proc) {
            super(syncFeature, infoObject, priority);
            this.group = group;
            this.proc = proc;
        }
    }
}

