/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Clock;
import com.spacekiller.util.Platform;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.Timer;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.LockSupport;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.thread.ThreadPool;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.common.MonoTarget;
import com.waxmonster.audio.common.MultiMixer;
import com.waxmonster.audio.common.PairMixer;
import com.waxmonster.audio.common.StereoTarget;
import com.waxmonster.audio.common.SurroundTarget;
import com.waxmonster.editor.InterpolatorRegistry;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.common.MidiActionProcessor;
import com.waxmonster.model.LineUtil;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.Studio;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.WaxLabPreferences;
import com.waxmonster.waxlab.impl.AbstractLineFeature;
import com.waxmonster.waxlab.impl.MidiPlayer;
import com.waxmonster.waxlab.impl.SyncClockAccess;
import com.waxmonster.waxlab.impl.SyncClockImpl;
import com.waxmonster.waxlab.impl.SyncFeatureImpl;
import com.waxmonster.waxlab.impl.SyncHandler;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabAudioOutputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioProcessor;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import com.waxmonster.waxlab.impl.WaxLabImpl;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiProcessor;
import com.waxmonster.waxlab.impl.WaxLabMidiSyncGroup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SyncMediatorImpl
implements SyncMediator {
    private static final Logger logger = Platform.getLogger(SyncMediatorImpl.class);
    private static final SyncHandler[] NO_SYNC_HANDLERS = new SyncHandler[0];
    private final WaxLabDevice device;
    private final AsyncShutdown asyncShutdown = new AsyncShutdown();
    private Timer asyncShutdownTimer;
    private int asyncShutdownDelay = 1;
    private int asyncShutdownMinDelay = 1;
    private int asyncShutdownMaxDelay = 100;
    private Studio studio;
    private Clock clock;
    private SyncClockAccess master;
    private final SyncClockAccess studioMaster;
    private boolean studioMasterInit;
    private ThreadManager threadManager;
    private boolean active;
    private boolean startFlag;
    private boolean stopFlag;
    private boolean batchMode;
    private String timestampString;
    private long startLineOfs;
    private long startTimeBase;
    private int nextProcId;
    private Set labAudioProcSet;
    private List labAudioProcList;
    private Set labAudioProcsToAddSet;
    private List labAudioProcsToAddList;
    private Set labAudioProcsToRemoveSet;
    private List labAudioProcsToRemoveList;
    private List labAudioProcsToShutdownList;
    private Set labMidiInputSet;
    private List labMidiInputList;
    private Set labMidiInputToAddSet;
    private List labMidiInputToAddList;
    private Set labMidiInputToRemoveSet;
    private List labMidiInputToRemoveList;
    private List labMidiInputToShutdownList;
    private Set labMidiOutputSet;
    private List labMidiOutputList;
    private Set labMidiOutputToAddSet;
    private List labMidiOutputToAddList;
    private Set labMidiOutputToRemoveSet;
    private List labMidiOutputToRemoveList;
    private List labMidiOutputToShutdownList;
    private Set featureSet;
    private List featureList;
    private Set enabledFeaturesSet;
    private List enabledFeaturesList;
    private Set activeFeaturesSet;
    private List activeFeaturesList;
    private Set featuresToAddSet;
    private List featuresToAddList;
    private Set featuresToRemoveSet;
    private List featuresToRemoveList;
    private Set featuresToMediateSet;
    private List featuresToMediateList;
    private List featuresToActivateList;
    private List featuresToDeactivateList;
    private Set audioGroupsToUpdateSet;
    private List audioGroupsToUpdateList;
    private Set midiInPortsToUpdateSet;
    private List midiInPortsToUpdateList;
    private Set midiOutPortsToUpdateSet;
    private List midiOutPortsToUpdateList;
    private List syncHandlerList;
    private List procOnceList;
    private List procNormList;
    private Set procUniqueSet;
    private List midiProcList;
    private Set midiUniqueSet;
    private List midiPlayerList;
    private Set midiPlayerSet;
    private List midiPlayersToStart;
    private List midiPlayersToStop;
    private int waitIdleMinDelay = 1;
    private int waitIdleMaxDelay = 100;
    private int waitIdleTimeout = 2000;
    private long switchMinNanos = 0L;
    private int switchMinBuffers = 2;
    private WaxLabMidiInputPort waxLabMidiMappingPort;
    private MidiMapping[] waxLabMidiMappings;

    public SyncMediatorImpl(WaxLabDevice device) {
        this.device = device;
        this.nextProcId = 1;
        int initialCapacity = 16;
        this.labAudioProcSet = new HashSet(initialCapacity);
        this.labAudioProcList = new ArrayList(initialCapacity);
        this.labAudioProcsToAddSet = new HashSet(initialCapacity);
        this.labAudioProcsToAddList = new ArrayList(initialCapacity);
        this.labAudioProcsToRemoveSet = new HashSet(initialCapacity);
        this.labAudioProcsToRemoveList = new ArrayList(initialCapacity);
        this.labAudioProcsToShutdownList = new ArrayList(initialCapacity);
        this.labMidiInputSet = new HashSet(initialCapacity);
        this.labMidiInputList = new ArrayList(initialCapacity);
        this.labMidiInputToAddSet = new HashSet(initialCapacity);
        this.labMidiInputToAddList = new ArrayList(initialCapacity);
        this.labMidiInputToRemoveSet = new HashSet(initialCapacity);
        this.labMidiInputToRemoveList = new ArrayList(initialCapacity);
        this.labMidiInputToShutdownList = new ArrayList(initialCapacity);
        this.labMidiOutputSet = new HashSet(initialCapacity);
        this.labMidiOutputList = new ArrayList(initialCapacity);
        this.labMidiOutputToAddSet = new HashSet(initialCapacity);
        this.labMidiOutputToAddList = new ArrayList(initialCapacity);
        this.labMidiOutputToRemoveSet = new HashSet(initialCapacity);
        this.labMidiOutputToRemoveList = new ArrayList(initialCapacity);
        this.labMidiOutputToShutdownList = new ArrayList(initialCapacity);
        this.featureSet = new HashSet(initialCapacity);
        this.featureList = new ArrayList(initialCapacity);
        this.enabledFeaturesSet = new HashSet(initialCapacity);
        this.enabledFeaturesList = new ArrayList(initialCapacity);
        this.activeFeaturesSet = new HashSet(initialCapacity);
        this.activeFeaturesList = new ArrayList(initialCapacity);
        this.featuresToAddSet = new HashSet(initialCapacity);
        this.featuresToAddList = new ArrayList(initialCapacity);
        this.featuresToRemoveSet = new HashSet(initialCapacity);
        this.featuresToRemoveList = new ArrayList(initialCapacity);
        this.featuresToMediateSet = new HashSet(initialCapacity);
        this.featuresToMediateList = new ArrayList(initialCapacity);
        this.featuresToActivateList = new ArrayList(initialCapacity);
        this.featuresToDeactivateList = new ArrayList(initialCapacity);
        this.audioGroupsToUpdateSet = new HashSet(initialCapacity);
        this.audioGroupsToUpdateList = new ArrayList(initialCapacity);
        this.midiInPortsToUpdateSet = new HashSet(initialCapacity);
        this.midiInPortsToUpdateList = new ArrayList(initialCapacity);
        this.midiOutPortsToUpdateSet = new HashSet(initialCapacity);
        this.midiOutPortsToUpdateList = new ArrayList(initialCapacity);
        this.syncHandlerList = new ArrayList();
        this.procOnceList = new ArrayList();
        this.procNormList = new ArrayList();
        this.procUniqueSet = new HashSet();
        this.midiProcList = new ArrayList();
        this.midiUniqueSet = new HashSet();
        this.midiPlayerList = new ArrayList();
        this.midiPlayerSet = new HashSet();
        this.midiPlayersToStart = new ArrayList();
        this.midiPlayersToStop = new ArrayList();
        this.master = this.studioMaster = new SyncClockImpl();
    }

    @Override
    public final Device getDevice() {
        return this.device;
    }

    @Override
    public final WaxLabDevice getWaxLabDevice() {
        return this.device;
    }

    @Override
    public WaxLab getWaxLab() {
        return this.device.getWaxLab();
    }

    protected WaxLabImpl getWaxLabImpl() {
        return (WaxLabImpl)this.device.getWaxLab();
    }

    public boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isBatchMode() {
        return this.batchMode;
    }

    protected void setBatchMode(boolean batchMode) {
        this.batchMode = batchMode;
    }

    @Override
    public long getStartLineOfs() {
        return this.startLineOfs;
    }

    public void setStartLineOfs(long startLineOfs) {
        this.startLineOfs = startLineOfs;
    }

    @Override
    public long getStartTimeBase() {
        return this.startTimeBase;
    }

    protected void setStartTimeBase(long startTimeBase) {
        this.startTimeBase = startTimeBase;
    }

    @Override
    public String getTimestampString() {
        return this.timestampString;
    }

    protected void setTimestampString(String timestampString) {
        this.timestampString = timestampString;
    }

    public int getAsyncShutdownMinDelay() {
        return this.asyncShutdownMinDelay;
    }

    public void setAsyncShutdownMinDelay(int asyncShutdownMinDelay) {
        if (asyncShutdownMinDelay < 1) {
            asyncShutdownMinDelay = 1;
        }
        this.asyncShutdownMinDelay = asyncShutdownMinDelay;
    }

    public int getAsyncShutdownMaxDelay() {
        return this.asyncShutdownMaxDelay;
    }

    public void setAsyncShutdownMaxDelay(int asyncShutdownMaxDelay) {
        if (asyncShutdownMaxDelay < 1) {
            asyncShutdownMaxDelay = 1;
        }
        this.asyncShutdownMaxDelay = asyncShutdownMaxDelay;
    }

    public int getWaitIdleMinDelay() {
        return this.waitIdleMinDelay;
    }

    public void setWaitIdleMinDelay(int waitIdleMinDelay) {
        if (waitIdleMinDelay < 1) {
            waitIdleMinDelay = 1;
        }
        this.waitIdleMinDelay = waitIdleMinDelay;
    }

    public int getWaitIdleMaxDelay() {
        return this.waitIdleMaxDelay;
    }

    public void setWaitIdleMaxDelay(int waitIdleMaxDelay) {
        if (waitIdleMaxDelay < 1) {
            waitIdleMaxDelay = 1;
        }
        this.waitIdleMaxDelay = waitIdleMaxDelay;
    }

    public int getWaitIdleTimeout() {
        return this.waitIdleTimeout;
    }

    public void setWaitIdleTimeout(int waitIdleTimeout) {
        if (waitIdleTimeout < 1) {
            waitIdleTimeout = 1;
        }
        this.waitIdleTimeout = waitIdleTimeout;
    }

    public long getSwitchMinNanos() {
        return this.switchMinNanos;
    }

    public void setSwitchMinNanos(long switchMinNanos) {
        if (switchMinNanos < 0L) {
            switchMinNanos = 0L;
        }
        this.switchMinNanos = switchMinNanos;
    }

    public int getSwitchMinBuffers() {
        return this.switchMinBuffers;
    }

    public void setSwitchMinBuffers(int switchMinBuffers) {
        if (switchMinBuffers < 2) {
            switchMinBuffers = 2;
        }
        this.switchMinBuffers = switchMinBuffers;
    }

    @Override
    public WaxLabPreferences getWaxLabPreferences() {
        WaxLab waxLab = this.getWaxLab();
        return waxLab.getWaxLabPreferences();
    }

    @Override
    public LockFactory getLockFactory() {
        WaxLabImpl waxLab = this.getWaxLabImpl();
        return waxLab.getLockFactory();
    }

    @Override
    public ThreadPool getLoaderThreadPool() {
        WaxLabImpl waxLab = this.getWaxLabImpl();
        return waxLab.getLoaderThreadPool();
    }

    @Override
    public ThreadPool getWriterThreadPool() {
        WaxLabImpl waxLab = this.getWaxLabImpl();
        return waxLab.getWriterThreadPool();
    }

    @Override
    public ThreadPool getWorkerThreadPool() {
        WaxLabImpl waxLab = this.getWaxLabImpl();
        return waxLab.getWorkerThreadPool();
    }

    public Studio getStudio() {
        return this.studio;
    }

    public synchronized void setStudio(Studio studio) {
        this.studio = studio;
        if (this.asyncShutdownTimer == null && studio != null) {
            int millis = this.asyncShutdownDelay;
            this.asyncShutdownTimer = studio.createTimer((Runnable)this.asyncShutdown, millis);
            this.asyncShutdownTimer.setRepeats(true);
            this.asyncShutdownTimer.setDelay(this.asyncShutdownMinDelay);
        }
    }

    @Override
    public Timer createTimer(Runnable target, int millis) {
        return this.studio.createTimer(target, millis);
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    protected synchronized void setClock(Clock clock) {
        Clock oldClock = this.clock;
        if (clock == oldClock) {
            return;
        }
        this.clock = clock;
        if (clock == null) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("setClock: " + clock + ", studioMaster=" + this.studioMaster + ", master=" + this.master);
        }
        if (this.master == this.studioMaster && !this.studioMasterInit) {
            long nanoBase = clock.nanos();
            this.studioMaster.rebase(nanoBase);
            this.studioMasterInit = true;
            return;
        }
        throw new UnsupportedOperationException("TODO rebase: master=" + this.master + ", clock=" + clock);
    }

    protected SyncClockAccess getMaster() {
        return this.master;
    }

    protected void setMaster(SyncClockAccess master) {
        this.master = master;
    }

    protected void switchMaster(SyncClockAccess newMaster) {
        SyncClockAccess oldMaster = this.master;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("switchMaster: " + oldMaster + " -> " + newMaster);
        }
        long newBase = newMaster.nanoBase();
        long newSync = newMaster.nanoSync(0L);
        long oldSync = oldMaster.nanoSync(0L);
        long nanoBase = newSync - newBase - oldSync;
        newMaster.rebase(nanoBase);
        if (logger.isLoggable(Level.FINE)) {
            long nanos = this.clock.nanos();
            logger.fine("switchMaster: " + oldMaster.nanoSync(nanos) + " ~= " + newMaster.nanoSync(nanos));
        }
        this.master = newMaster;
    }

    public double nanoDelta() {
        return this.master.nanoDelta();
    }

    public long nanoSync(long time) {
        return this.master.nanoSync(time);
    }

    public long nanoSync(double time) {
        return this.master.nanoSync(time);
    }

    @Override
    public LockSupport getLockSupport() {
        WaxLabImpl waxLab = this.getWaxLabImpl();
        return waxLab.getLockSupport();
    }

    @Override
    public ThreadManager getThreadManager() {
        return this.threadManager;
    }

    protected void setThreadManager(ThreadManager threadManager) {
        this.threadManager = threadManager;
    }

    @Override
    public InterpolatorRegistry getInterpolatorRegistry() {
        WaxLabImpl waxLab = this.getWaxLabImpl();
        return waxLab.getInterpolatorRegistry();
    }

    final synchronized boolean addFeature(AbstractLineFeature feature) {
        if (feature == null) {
            return false;
        }
        if (this.featureSet.contains(feature)) {
            return true;
        }
        if (this.featuresToRemoveSet.remove(feature)) {
            this.featuresToRemoveList.remove(feature);
            return true;
        }
        if (this.featuresToAddSet.add(feature)) {
            this.featuresToAddList.add(feature);
        }
        return true;
    }

    final synchronized boolean removeFeature(AbstractLineFeature feature) {
        if (feature == null) {
            return false;
        }
        if (!this.featureSet.contains(feature)) {
            return true;
        }
        if (this.featuresToAddSet.remove(feature)) {
            this.featuresToAddList.remove(feature);
            return true;
        }
        if (this.featuresToRemoveSet.add(feature)) {
            this.featuresToRemoveList.add(feature);
        }
        return true;
    }

    @Override
    public synchronized boolean addWaxLabAudioProcessor(WaxLabAudioProcessor proc) {
        if (proc == null) {
            return false;
        }
        if (this.labAudioProcsToRemoveSet.remove(proc)) {
            this.labAudioProcsToRemoveList.remove(proc);
            return true;
        }
        if (this.labAudioProcSet.contains(proc)) {
            return true;
        }
        if (this.labAudioProcsToAddSet.add(proc)) {
            this.labAudioProcsToAddList.add(proc);
        }
        return true;
    }

    @Override
    public synchronized boolean removeWaxLabAudioProcessor(WaxLabAudioProcessor proc) {
        if (proc == null) {
            return false;
        }
        if (this.labAudioProcsToAddSet.remove(proc)) {
            this.labAudioProcsToAddList.remove(proc);
            return true;
        }
        if (!this.labAudioProcSet.contains(proc)) {
            return true;
        }
        if (this.labAudioProcsToRemoveSet.add(proc)) {
            this.labAudioProcsToRemoveList.add(proc);
            this.checkAutoMediate();
        }
        return true;
    }

    @Override
    public synchronized boolean addWaxLabMidiInputPort(WaxLabMidiInputPort port) {
        if (port == null) {
            return false;
        }
        if (this.labMidiInputToRemoveSet.remove((Object)port)) {
            this.labMidiInputToRemoveList.remove((Object)port);
            return true;
        }
        if (this.labMidiInputSet.contains((Object)port)) {
            return true;
        }
        if (this.labMidiInputToAddSet.add(port)) {
            this.labMidiInputToAddList.add(port);
        }
        return true;
    }

    @Override
    public synchronized boolean removeWaxLabMidiInputPort(WaxLabMidiInputPort port) {
        if (port == null) {
            return false;
        }
        if (this.labMidiInputToAddSet.remove((Object)port)) {
            this.labMidiInputToAddList.remove((Object)port);
            return true;
        }
        if (!this.labMidiInputSet.contains((Object)port)) {
            return true;
        }
        if (this.labMidiInputToRemoveSet.add(port)) {
            this.labMidiInputToRemoveList.add(port);
            this.checkAutoMediate();
        }
        return true;
    }

    @Override
    public synchronized boolean addWaxLabMidiOutputPort(WaxLabMidiOutputPort port) {
        if (port == null) {
            return false;
        }
        if (this.labMidiOutputToRemoveSet.remove((Object)port)) {
            this.labMidiOutputToRemoveList.remove((Object)port);
            return true;
        }
        if (this.labMidiOutputSet.contains((Object)port)) {
            return true;
        }
        if (this.labMidiOutputToAddSet.add(port)) {
            this.labMidiOutputToAddList.add(port);
        }
        return true;
    }

    @Override
    public synchronized boolean removeWaxLabMidiOutputPort(WaxLabMidiOutputPort port) {
        if (port == null) {
            return false;
        }
        if (this.labMidiOutputToAddSet.remove((Object)port)) {
            this.labMidiOutputToAddList.remove((Object)port);
            return true;
        }
        if (!this.labMidiOutputSet.contains((Object)port)) {
            return true;
        }
        if (this.labMidiOutputToRemoveSet.add(port)) {
            this.labMidiOutputToRemoveList.add(port);
            this.checkAutoMediate();
        }
        return true;
    }

    protected synchronized boolean checkAutoMediate() {
        if (this.labAudioProcsToRemoveList.size() < this.labAudioProcList.size()) {
            return false;
        }
        if (this.labMidiInputToRemoveList.size() < this.labMidiInputList.size()) {
            return false;
        }
        if (this.labMidiOutputToRemoveList.size() < this.labMidiOutputList.size()) {
            return false;
        }
        this.mediate();
        return true;
    }

    @Override
    public synchronized void start(boolean batchMode, long startLineOfs, String timestampString) {
        if (this.active) {
            throw new IllegalStateException("Mediator is already started");
        }
        this.setActive(true);
        this.setBatchMode(batchMode);
        this.setStartLineOfs(startLineOfs);
        this.setTimestampString(timestampString);
        this.startFlag = true;
        this.stopFlag = false;
        this.mediate();
    }

    @Override
    public synchronized void stop() {
        if (!this.active) {
            return;
        }
        this.setActive(false);
        this.startFlag = false;
        this.stopFlag = true;
        this.mediate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void mediate() {
        Timer shutdownTimer;
        int bufFrames;
        float frameRate;
        MidiPlayer midiPlayer;
        WaxLabMidiProcessor labMidiProc;
        long nanos;
        WaxLabAudioSyncGroup labAudioGroup;
        int audioGroupsToUpdateSize;
        SyncHandler syncHandler;
        SyncFeatureImpl syncFeature;
        AbstractLineFeature feature;
        WaxLabMidiOutputPort midiOutPort;
        WaxLabMidiInputPort midiInPort;
        WaxLabAudioProcessor labAudioProc;
        int i;
        Clock clock;
        Level trace;
        Level debug = Level.FINE;
        if (!logger.isLoggable(debug)) {
            debug = null;
        }
        if (!logger.isLoggable(trace = Level.FINER)) {
            trace = null;
        }
        if ((clock = this.clock) == null) {
            return;
        }
        boolean start = this.startFlag;
        this.startFlag = false;
        boolean stop = this.stopFlag;
        this.stopFlag = false;
        this.featuresToMediateSet.clear();
        this.featuresToMediateList.clear();
        this.featuresToActivateList.clear();
        this.featuresToDeactivateList.clear();
        if (debug != null) {
            logger.log(debug, "======== Mediate " + this + " ========");
            logger.log(debug, "audioProcs:  " + this.labAudioProcList.size() + " = " + this.labAudioProcList);
            logger.log(debug, "midiInputs:  " + this.labMidiInputList.size() + " = " + this.labMidiInputList);
            logger.log(debug, "midiOutputs: " + this.labMidiOutputList.size() + " = " + this.labMidiOutputList);
            logger.log(debug, "features:        " + this.featureList.size() + " = " + this.featureList);
            logger.log(debug, "enabledFeatures: " + this.enabledFeaturesList.size() + " = " + this.enabledFeaturesList);
            logger.log(debug, "activeFeatures:  " + this.activeFeaturesList.size() + " = " + this.activeFeaturesList);
            logger.log(debug, "audioProcsToAdd:     " + this.labAudioProcsToAddList.size() + " = " + this.labAudioProcsToAddList);
            logger.log(debug, "audioProcsToRemove:  " + this.labAudioProcsToRemoveList.size() + " = " + this.labAudioProcsToRemoveList);
            logger.log(debug, "midiInputsToAdd:     " + this.labMidiInputToAddList.size() + " = " + this.labMidiInputToAddList);
            logger.log(debug, "midiInputsToRemove:  " + this.labMidiInputToRemoveList.size() + " = " + this.labMidiInputToRemoveList);
            logger.log(debug, "midiOutputsToAdd:    " + this.labMidiOutputToAddList.size() + " = " + this.labMidiOutputToAddList);
            logger.log(debug, "midiOutputsToRemove: " + this.labMidiOutputToRemoveList.size() + " = " + this.labMidiOutputToRemoveList);
            logger.log(debug, "featuresToAdd:    " + this.featuresToAddList.size() + " = " + this.featuresToAddList);
            logger.log(debug, "featuresToRemove: " + this.featuresToRemoveList.size() + " = " + this.featuresToRemoveList);
        }
        SyncClockAccess newMaster = this.master;
        int audioProcessorChanges = 0;
        int midiInputPortChanges = 0;
        int midiOutputPortChanges = 0;
        int size = this.labAudioProcsToRemoveList.size();
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                labAudioProc = (WaxLabAudioProcessor)this.labAudioProcsToRemoveList.get(i);
                if (!this.labAudioProcSet.remove(labAudioProc)) continue;
                this.labAudioProcList.remove(labAudioProc);
                ++audioProcessorChanges;
                if (newMaster != labAudioProc) continue;
                newMaster = null;
            }
            this.labAudioProcsToShutdownList.addAll(this.labAudioProcsToRemoveList);
            this.labAudioProcsToRemoveList.clear();
            this.labAudioProcsToRemoveSet.clear();
        }
        if ((size = this.labAudioProcsToAddList.size()) > 0) {
            for (i = 0; i < size; ++i) {
                labAudioProc = (WaxLabAudioProcessor)this.labAudioProcsToAddList.get(i);
                if (!this.labAudioProcSet.add(labAudioProc)) continue;
                this.labAudioProcList.add(labAudioProc);
                ++audioProcessorChanges;
                boolean masterFlag = false;
                if (!masterFlag) continue;
                newMaster = labAudioProc;
            }
            this.labAudioProcsToAddList.clear();
            this.labAudioProcsToAddSet.clear();
        }
        if (!(newMaster != null && newMaster != this.studioMaster || this.labAudioProcList.isEmpty())) {
            newMaster = (WaxLabAudioProcessor)this.labAudioProcList.get(0);
        }
        if ((size = this.labMidiInputToRemoveList.size()) > 0) {
            for (i = 0; i < size; ++i) {
                midiInPort = (WaxLabMidiInputPort)((Object)this.labMidiInputToRemoveList.get(i));
                if (!this.labMidiInputSet.remove((Object)midiInPort)) continue;
                this.labMidiInputList.remove((Object)midiInPort);
                ++midiInputPortChanges;
            }
            this.labMidiInputToShutdownList.addAll(this.labMidiInputToRemoveList);
            this.labMidiInputToRemoveList.clear();
            this.labMidiInputToRemoveSet.clear();
        }
        if ((size = this.labMidiInputToAddList.size()) > 0) {
            for (i = 0; i < size; ++i) {
                midiInPort = (WaxLabMidiInputPort)((Object)this.labMidiInputToAddList.get(i));
                if (!this.labMidiInputSet.add(midiInPort)) continue;
                this.labMidiInputList.add(midiInPort);
                ++midiInputPortChanges;
            }
            this.labMidiInputToAddList.clear();
            this.labMidiInputToAddSet.clear();
        }
        if ((size = this.labMidiOutputToRemoveList.size()) > 0) {
            for (i = 0; i < size; ++i) {
                midiOutPort = (WaxLabMidiOutputPort)((Object)this.labMidiOutputToRemoveList.get(i));
                if (!this.labMidiOutputSet.remove((Object)midiOutPort)) continue;
                this.labMidiOutputList.remove((Object)midiOutPort);
                ++midiOutputPortChanges;
            }
            this.labMidiOutputToShutdownList.addAll(this.labMidiOutputToRemoveList);
            this.labMidiOutputToRemoveList.clear();
            this.labMidiOutputToRemoveSet.clear();
        }
        if ((size = this.labMidiOutputToAddList.size()) > 0) {
            for (i = 0; i < size; ++i) {
                midiOutPort = (WaxLabMidiOutputPort)((Object)this.labMidiOutputToAddList.get(i));
                if (!this.labMidiOutputSet.add(midiOutPort)) continue;
                this.labMidiOutputList.add(midiOutPort);
                ++midiOutputPortChanges;
            }
            this.labMidiOutputToAddList.clear();
            this.labMidiOutputToAddSet.clear();
        }
        if (newMaster == null) {
            newMaster = this.studioMaster;
        }
        if (newMaster != this.master) {
            this.switchMaster(newMaster);
        }
        if ((size = this.featuresToRemoveList.size()) > 0) {
            for (i = 0; i < size; ++i) {
                feature = (AbstractLineFeature)this.featuresToRemoveList.get(i);
                if (this.activeFeaturesSet.remove(feature)) {
                    this.activeFeaturesList.remove(feature);
                    this.featuresToDeactivateList.add(feature);
                }
                if (this.enabledFeaturesSet.remove(feature)) {
                    this.enabledFeaturesList.remove(feature);
                }
                if (!this.featureSet.remove(feature)) continue;
                this.featureList.remove(feature);
            }
        }
        if ((size = this.featuresToAddList.size()) > 0) {
            for (i = 0; i < size; ++i) {
                feature = (AbstractLineFeature)this.featuresToAddList.get(i);
                if (!this.featureSet.add(feature)) continue;
                this.featureList.add(feature);
                AbstractLineFeature masterFlag = feature;
                synchronized (masterFlag) {
                    SyncMediatorImpl mediator = feature.getMediatorImpl();
                    if (mediator != null) {
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.warning("Feature is already occupied by another SyncMediator: " + mediator);
                        }
                        this.featureSet.remove(feature);
                        this.featureList.remove(feature);
                        continue;
                    }
                    feature.setMediatorImpl(this);
                }
                syncFeature = new SyncFeatureImpl(feature);
                feature.setSyncFeatureImpl(syncFeature);
                feature.setValid(false);
            }
            this.featuresToAddList.clear();
            this.featuresToAddSet.clear();
        }
        int validatedFeatures = 0;
        size = this.featureList.size();
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                feature = (AbstractLineFeature)this.featureList.get(i);
                if (!this.active) {
                    if (!this.activeFeaturesSet.contains(feature)) continue;
                    this.featuresToDeactivateList.add(feature);
                    continue;
                }
                if (feature.isValid()) {
                    if (!start && !stop && audioProcessorChanges <= 0 && midiInputPortChanges <= 0 && midiOutputPortChanges <= 0 || !feature.isEnabled() && !this.enabledFeaturesSet.contains(feature) || !this.featuresToMediateSet.add(feature)) continue;
                    this.featuresToMediateList.add(feature);
                    continue;
                }
                try {
                    feature.validate();
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                finally {
                    feature.setValid(true);
                }
                ++validatedFeatures;
                if (feature.isEnabled()) {
                    if (this.enabledFeaturesSet.add(feature)) {
                        this.enabledFeaturesList.add(feature);
                    }
                    if (!this.featuresToMediateSet.add(feature)) continue;
                    this.featuresToMediateList.add(feature);
                    continue;
                }
                if (this.enabledFeaturesSet.remove(feature)) {
                    this.enabledFeaturesList.remove(feature);
                }
                if (!this.activeFeaturesSet.contains(feature)) continue;
                this.featuresToDeactivateList.add(feature);
            }
        }
        if (debug != null) {
            logger.log(debug, "validatedFeatures: " + validatedFeatures);
        }
        long startLineOfs = this.startLineOfs;
        if (start) {
            this.startTimeBase = this.master.nanoSync(clock.nanos());
            if (debug != null) {
                logger.log(debug, "startLineOfs: " + startLineOfs);
                logger.log(debug, "startTimeBase: " + this.startTimeBase);
            }
        } else {
            long elapsedNanos = this.master.nanoSync(clock.nanos()) - this.startTimeBase;
            startLineOfs += elapsedNanos;
            if (debug != null) {
                logger.log(debug, "startLineOfs: " + this.startLineOfs + " + " + elapsedNanos + " = " + startLineOfs);
            }
        }
        size = this.featuresToMediateList.size();
        if (debug != null) {
            logger.log(debug, "featuresToMediate: " + size + " = " + this.featuresToMediateList);
        }
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                boolean handlersEmpty;
                feature = (AbstractLineFeature)this.featuresToMediateList.get(i);
                syncFeature = feature.getSyncFeatureImpl();
                if (syncFeature == null) continue;
                syncFeature.setStartLineOfs(startLineOfs);
                try {
                    feature.mediateFeature(syncFeature);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                SyncFeatureImpl syncFeatureImpl = syncFeature;
                synchronized (syncFeatureImpl) {
                    int k;
                    int num = syncFeature.handlersToRemoveList.size();
                    if (num > 0) {
                        for (k = 0; k < num; ++k) {
                            syncHandler = (SyncHandler)syncFeature.handlersToRemoveList.get(k);
                            syncFeature.handlerList.remove(syncHandler);
                            syncFeature.handlerSet.remove(syncHandler);
                            this.removeHandlerFromPort(syncHandler);
                        }
                        syncFeature.handlersToRemoveList.clear();
                        syncFeature.handlersToRemoveSet.clear();
                    }
                    if ((num = syncFeature.handlersToInsertList.size()) > 0) {
                        for (k = 0; k < num; ++k) {
                            syncHandler = (SyncHandler)syncFeature.handlersToInsertList.get(k);
                            syncFeature.handlerList.add(syncHandler);
                            syncFeature.handlerSet.add(syncHandler);
                            this.insertHandlerIntoPort(syncHandler);
                        }
                        syncFeature.handlersToInsertList.clear();
                        syncFeature.handlersToInsertSet.clear();
                    }
                    handlersEmpty = syncFeature.handlerList.isEmpty();
                }
                if (handlersEmpty) {
                    if (!feature.isActive()) continue;
                    this.featuresToDeactivateList.add(feature);
                    continue;
                }
                if (feature.isActive()) continue;
                this.featuresToActivateList.add(feature);
            }
            this.featuresToMediateList.clear();
            this.featuresToMediateSet.clear();
        }
        size = this.featuresToActivateList.size();
        if (debug != null) {
            logger.log(debug, "featuresToActivate: " + size + " = " + this.featuresToActivateList);
        }
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                feature = (AbstractLineFeature)this.featuresToActivateList.get(i);
                syncFeature = feature.getSyncFeatureImpl();
                if (syncFeature == null || feature.isActive()) continue;
                feature.setActive(true);
                if (!this.activeFeaturesSet.add(feature)) continue;
                this.activeFeaturesList.add(feature);
            }
            this.featuresToActivateList.clear();
        }
        size = this.featuresToDeactivateList.size();
        if (debug != null) {
            logger.log(debug, "featuresToDeactivate: " + size + " = " + this.featuresToDeactivateList);
        }
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                int num;
                feature = (AbstractLineFeature)this.featuresToDeactivateList.get(i);
                syncFeature = feature.getSyncFeatureImpl();
                if (syncFeature == null || !feature.isActive()) continue;
                feature.setActive(false);
                if (this.activeFeaturesSet.remove(feature)) {
                    this.activeFeaturesList.remove(feature);
                }
                if ((num = syncFeature.handlerList.size()) <= 0) continue;
                for (int k = 0; k < num; ++k) {
                    syncHandler = (SyncHandler)syncFeature.handlerList.get(k);
                    this.removeHandlerFromPort(syncHandler);
                }
                syncFeature.handlerList.clear();
                syncFeature.handlerSet.clear();
            }
            this.featuresToDeactivateList.clear();
        }
        size = this.featuresToRemoveList.size();
        if (debug != null) {
            logger.log(debug, "featuresToRemove: " + size + " = " + this.featuresToRemoveList);
        }
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                feature = (AbstractLineFeature)this.featuresToRemoveList.get(i);
                if (!this.featureSet.remove(feature)) continue;
                this.featureList.remove(feature);
                AbstractLineFeature num = feature;
                synchronized (num) {
                    if (feature.getMediatorImpl() == this) {
                        feature.setMediatorImpl(null);
                        feature.setSyncFeatureImpl(null);
                    }
                    continue;
                }
            }
            this.featuresToRemoveList.clear();
            this.featuresToRemoveSet.clear();
        }
        if ((audioGroupsToUpdateSize = this.audioGroupsToUpdateList.size()) > 0) {
            int wakeProcId = this.nextProcId++;
            for (i = 0; i < audioGroupsToUpdateSize; ++i) {
                labAudioGroup = (WaxLabAudioSyncGroup)((Object)this.audioGroupsToUpdateList.get(i));
                labAudioProc = labAudioGroup.getWaxLabAudioProcessor();
                if (labAudioProc == null || labAudioGroup.prepareList.isEmpty() || (nanos = labAudioProc.startTime) != Long.MAX_VALUE) continue;
                if (debug != null) {
                    logger.log(debug, "wake-up AudioSyncGroup: " + (Object)((Object)labAudioGroup));
                }
                long swtchPos = Long.MIN_VALUE;
                int onceId = 0;
                AudioProcessor[] onceProcs = null;
                SyncHandler[] onceHandlers = null;
                int normId = wakeProcId;
                AudioProcessor[] normProcs = WaxLabAudioSyncGroup.NO_PROCS;
                SyncHandler[] normHandlers = NO_SYNC_HANDLERS;
                labAudioProc.reset(swtchPos, onceId, onceProcs, onceHandlers, normId, normProcs, normHandlers);
            }
        }
        int onceProcId = 0;
        int normProcId = 0;
        if (audioGroupsToUpdateSize > 0) {
            if (debug != null) {
                logger.log(debug, "Updating AudioSyncGroup(s): " + audioGroupsToUpdateSize);
            }
            onceProcId = this.nextProcId++;
            normProcId = this.nextProcId++;
            for (i = 0; i < audioGroupsToUpdateSize; ++i) {
                labAudioGroup = (WaxLabAudioSyncGroup)((Object)this.audioGroupsToUpdateList.get(i));
                labAudioProc = labAudioGroup.getWaxLabAudioProcessor();
                if (labAudioProc == null) continue;
                int handlerCount = 0;
                List handlerList = labAudioGroup.handlerList;
                if (handlerList != null) {
                    handlerCount = handlerList.size();
                }
                if (debug != null) {
                    logger.log(debug, "update AudioSyncGroup: " + (Object)((Object)labAudioGroup) + ", handlerCount=" + handlerCount);
                }
                boolean procOnceNeeded = false;
                try {
                    AudioProcessor audioProc;
                    SyncHandler entry;
                    int k;
                    for (k = 0; k < handlerCount; ++k) {
                        syncHandler = (SyncHandler)handlerList.get(k);
                        if (!(syncHandler instanceof SyncHandler.AudioProcHandler)) continue;
                        entry = (SyncHandler.AudioProcHandler)syncHandler;
                        if (entry.group != labAudioGroup) {
                            logger.warning("Unexpected handler syncGroup: " + (Object)((Object)entry.group) + " != " + (Object)((Object)labAudioGroup));
                            continue;
                        }
                        entry.lastUsedId = normProcId;
                        this.syncHandlerList.add(entry);
                        audioProc = entry.proc;
                        if (audioProc == null || !this.procUniqueSet.add(audioProc)) continue;
                        this.procOnceList.add(audioProc);
                        this.procNormList.add(audioProc);
                        if (debug == null) continue;
                        logger.log(debug, " - Processor: " + audioProc + " -> " + entry);
                    }
                    for (k = 0; k < handlerCount; ++k) {
                        syncHandler = (SyncHandler)handlerList.get(k);
                        if (!(syncHandler instanceof SyncHandler.AudioOutHandler)) continue;
                        entry = (SyncHandler.AudioOutHandler)syncHandler;
                        if (((SyncHandler.AudioOutHandler)entry).group != labAudioGroup) {
                            logger.warning("Unexpected handler syncGroup: " + (Object)((Object)((SyncHandler.AudioOutHandler)entry).group) + " != " + (Object)((Object)labAudioGroup));
                            continue;
                        }
                        ((SyncHandler.AudioOutHandler)entry).lastUsedId = normProcId;
                        this.syncHandlerList.add(entry);
                        WaxLabAudioOutputPort[] ports = ((SyncHandler.AudioOutHandler)entry).ports;
                        SampleBuffer source = ((SyncHandler.AudioOutHandler)entry).source;
                        int portCount = ports.length;
                        if (portCount == 1) {
                            WaxLabAudioOutputPort port = ports[0];
                            ((SyncHandler.AudioOutHandler)entry).splitter = null;
                            ((SyncHandler.AudioOutHandler)entry).targets = null;
                            if (port == null || source == null) continue;
                            port.sourcesNew.add(source);
                            continue;
                        }
                        AudioProcessor splitter = ((SyncHandler.AudioOutHandler)entry).splitter;
                        SampleBuffer[] targets = ((SyncHandler.AudioOutHandler)entry).targets;
                        if (targets == null) {
                            targets = labAudioGroup.createSplitBuffers(source);
                            try {
                                splitter = labAudioGroup.createAudioSplitter(source, targets);
                            }
                            catch (AudioException e) {
                                logger.log(Level.SEVERE, e.getMessage(), e);
                                continue;
                            }
                            ((SyncHandler.AudioOutHandler)entry).splitter = splitter;
                            ((SyncHandler.AudioOutHandler)entry).targets = targets;
                        }
                        if (splitter != null) {
                            this.procOnceList.add(splitter);
                            this.procNormList.add(splitter);
                            if (debug != null) {
                                logger.log(debug, " - Splitter: " + splitter + " -> " + entry);
                            }
                        }
                        for (int j = 0; j < portCount; ++j) {
                            WaxLabAudioOutputPort port = ports[j];
                            if (port == null) continue;
                            port.sourcesNew.add(targets[j]);
                        }
                    }
                    int outPortCount = labAudioGroup.getOutputPortCount();
                    for (int k2 = 0; k2 < outPortCount; ++k2) {
                        WaxLabAudioOutputPort outPort = (WaxLabAudioOutputPort)labAudioGroup.getOutputPortAt(k2);
                        audioProc = this.getAudioOutputPortMixer(labAudioGroup, outPort);
                        if (audioProc != null) {
                            this.procOnceList.add(audioProc);
                            this.procNormList.add(audioProc);
                            if (debug != null) {
                                logger.log(debug, " - Mixer: " + audioProc + " -> " + (Object)((Object)outPort));
                            }
                        } else if (!outPort.sourcesOld.isEmpty() && (audioProc = outPort.getClearer()) != null) {
                            this.procOnceList.add(audioProc);
                            procOnceNeeded = true;
                            if (debug != null) {
                                logger.log(debug, " - Clearer: " + audioProc + " -> " + (Object)((Object)outPort));
                            }
                        }
                        outPort.swapAndClearSources();
                    }
                    labAudioProc.syncSwtchPos = Long.MIN_VALUE;
                    labAudioProc.syncHandlers = this.buildSyncHandlerArray(this.syncHandlerList);
                    labAudioProc.syncOnceProcs = procOnceNeeded ? this.buildAudioProcessorArray(this.procOnceList) : null;
                    labAudioProc.syncNormProcs = this.buildAudioProcessorArray(this.procNormList);
                    if (labAudioProc.syncNormProcs.length < 1 && (stop || this.master != labAudioProc)) {
                        labAudioProc.syncNormProcs = null;
                    }
                    if (debug == null) continue;
                    int numSyncHandlers = this.syncHandlerList.size();
                    int numOnceProcs = this.procOnceList.size();
                    int numNormProcs = this.procNormList.size();
                    logger.log(debug, "updated AudioSyncGroup: " + (Object)((Object)labAudioGroup) + ", handlers=" + numSyncHandlers + ", onceProcs=" + numOnceProcs + ", normProcs=" + numNormProcs);
                    continue;
                }
                finally {
                    this.syncHandlerList.clear();
                    this.procOnceList.clear();
                    this.procNormList.clear();
                    this.procUniqueSet.clear();
                }
            }
        }
        int midiProcId = 0;
        int midiInPortsToUpdateSize = this.midiInPortsToUpdateList.size();
        if (midiInPortsToUpdateSize > 0) {
            midiProcId = this.nextProcId++;
            for (i = 0; i < midiInPortsToUpdateSize; ++i) {
                midiInPort = (WaxLabMidiInputPort)((Object)this.midiInPortsToUpdateList.get(i));
                if (!this.labMidiInputSet.contains((Object)midiInPort) || (labMidiProc = midiInPort.getWaxLabMidiProcessor()) == null) continue;
                midiInPort.currentProcId = midiProcId;
                int handlerCount = 0;
                List handlerList = midiInPort.handlerList;
                if (handlerList != null) {
                    handlerCount = handlerList.size();
                }
                if (debug != null) {
                    logger.log(debug, "update MidiInputPort: " + (Object)((Object)midiInPort) + ", handlerCount=" + handlerCount);
                }
                try {
                    for (int k = 0; k < handlerCount; ++k) {
                        syncHandler = (SyncHandler)handlerList.get(k);
                        if (!(syncHandler instanceof SyncHandler.MidiProcHandler)) continue;
                        SyncHandler.MidiProcHandler entry = (SyncHandler.MidiProcHandler)syncHandler;
                        if (entry.port != midiInPort) {
                            logger.warning("Unexpected handler port: " + (Object)((Object)entry.port) + " != " + (Object)((Object)midiInPort));
                            continue;
                        }
                        entry.lastUsedId = midiProcId;
                        MidiProcessor midiProc = entry.proc;
                        if (midiProc == null || !this.midiUniqueSet.add(midiProc)) continue;
                        this.midiProcList.add(midiProc);
                    }
                    MidiActionProcessor actionProc = midiInPort.syncMidiActionProc;
                    if (actionProc != null && actionProc.getMidiMappingCount() > 0 && this.midiUniqueSet.add(actionProc)) {
                        this.midiProcList.add(actionProc);
                    }
                    labMidiProc.syncMidiProcs = this.buildMidiProcessorArray(this.midiProcList);
                    continue;
                }
                finally {
                    this.midiProcList.clear();
                    this.midiUniqueSet.clear();
                }
            }
        }
        int midiOutId = 0;
        int midiOutPortsToUpdateSize = this.midiOutPortsToUpdateList.size();
        if (midiOutPortsToUpdateSize > 0) {
            midiOutId = this.nextProcId++;
            for (i = 0; i < midiOutPortsToUpdateSize; ++i) {
                SyncHandler.MidiOutHandler entry;
                int k;
                midiOutPort = (WaxLabMidiOutputPort)((Object)this.midiOutPortsToUpdateList.get(i));
                if (!this.labMidiOutputSet.contains((Object)midiOutPort)) continue;
                midiOutPort.currentProcId = midiOutId;
                int handlerCount = 0;
                List handlerList = midiOutPort.handlerList;
                if (handlerList != null) {
                    handlerCount = handlerList.size();
                }
                if (debug != null) {
                    logger.log(debug, "update MidiOutputPort: " + (Object)((Object)midiOutPort) + ", handlerCount=" + handlerCount);
                }
                for (k = 0; k < handlerCount; ++k) {
                    syncHandler = (SyncHandler)handlerList.get(k);
                    if (!(syncHandler instanceof SyncHandler.MidiOutHandler)) continue;
                    entry = (SyncHandler.MidiOutHandler)syncHandler;
                    if (entry.port != midiOutPort) {
                        logger.warning("Unexpected handler port: " + (Object)((Object)entry.port) + " != " + (Object)((Object)midiOutPort));
                        continue;
                    }
                    entry.lastUsedId = midiOutId;
                    if (!midiOutPort.syncHandlerSet.add(entry)) continue;
                    midiOutPort.syncHandlerList.add(entry);
                    midiPlayer = entry.player;
                    if (midiPlayer == null || !this.midiPlayerSet.add(midiPlayer)) continue;
                    this.midiPlayerList.add(midiPlayer);
                    this.midiPlayersToStart.add(midiPlayer);
                    if (debug == null) continue;
                    logger.log(debug, " - insert MidiPlayer: " + midiPlayer + ", handler=" + entry + ", port=" + (Object)((Object)midiOutPort));
                }
                handlerList = midiOutPort.syncHandlerList;
                handlerCount = handlerList.size();
                for (k = handlerCount - 1; k >= 0; --k) {
                    syncHandler = (SyncHandler)handlerList.get(k);
                    if (!(syncHandler instanceof SyncHandler.MidiOutHandler)) continue;
                    entry = (SyncHandler.MidiOutHandler)syncHandler;
                    if (entry.port != midiOutPort) {
                        logger.warning("Unexpected handler port: " + (Object)((Object)entry.port) + " != " + (Object)((Object)midiOutPort));
                        continue;
                    }
                    if (entry.lastUsedId == midiOutId) continue;
                    handlerList.remove(k);
                    midiOutPort.syncHandlerSet.remove(entry);
                    midiPlayer = entry.player;
                    if (midiPlayer == null || !this.midiPlayerSet.remove(midiPlayer)) continue;
                    this.midiPlayerList.remove(midiPlayer);
                    this.midiPlayersToStop.add(midiPlayer);
                    if (debug == null) continue;
                    logger.log(debug, " - remove MidiPlayer: " + midiPlayer + ", handler=" + entry + ", port=" + (Object)((Object)midiOutPort));
                }
                continue;
            }
        }
        if (audioGroupsToUpdateSize > 0) {
            long waitStartTime = System.currentTimeMillis();
            long waitedTime = 0L;
            int waitDelay = this.waitIdleMinDelay;
            int prevWaitCount = -1;
            while (true) {
                int waitCount = 0;
                for (i = 0; i < audioGroupsToUpdateSize; ++i) {
                    labAudioGroup = (WaxLabAudioSyncGroup)((Object)this.audioGroupsToUpdateList.get(i));
                    labAudioProc = labAudioGroup.getWaxLabAudioProcessor();
                    if (labAudioGroup.prepareList.isEmpty()) continue;
                    nanos = labAudioProc.startTime;
                    if (nanos == Long.MAX_VALUE) {
                        ++waitCount;
                        continue;
                    }
                    if (labAudioProc.syncStartTime != Long.MAX_VALUE) continue;
                    labAudioProc.syncStartTime = this.master.nanoSync(nanos);
                }
                if (waitCount < 1) {
                    if (debug == null) break;
                    logger.log(debug, "Ready to prepare AudioSyncGroup(s): " + audioGroupsToUpdateSize + " (waited " + waitedTime + " ms.)");
                    break;
                }
                if (waitCount != prevWaitCount) {
                    if (debug != null) {
                        logger.log(debug, "Waiting for idle AudioSyncGroup(s): " + waitCount + " / " + audioGroupsToUpdateSize);
                    }
                    prevWaitCount = waitCount;
                }
                if ((waitedTime = System.currentTimeMillis() - waitStartTime) > (long)this.waitIdleTimeout) {
                    if (!logger.isLoggable(Level.WARNING)) break;
                    logger.warning("Timeout while waiting for idle AudioSyncGroup(s): " + waitCount + " / " + audioGroupsToUpdateSize + "(timeout: " + waitedTime + " > " + this.waitIdleTimeout + " ms.)");
                    break;
                }
                try {
                    Thread.sleep(waitDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if ((waitDelay <<= 1) <= this.waitIdleMaxDelay) continue;
                waitDelay = this.waitIdleMaxDelay;
            }
        }
        long minSpareNanos = 0L;
        if (audioGroupsToUpdateSize > 0) {
            for (i = 0; i < audioGroupsToUpdateSize; ++i) {
                labAudioGroup = (WaxLabAudioSyncGroup)((Object)this.audioGroupsToUpdateList.get(i));
                labAudioProc = labAudioGroup.getWaxLabAudioProcessor();
                frameRate = labAudioProc.frameRate;
                bufFrames = labAudioProc.bufFrames;
                if (frameRate <= 0.0f || bufFrames < 1 || (nanos = (long)Math.ceil(LineUtil.getNanoPos((long)(this.switchMinBuffers * bufFrames), (double)frameRate))) <= minSpareNanos) continue;
                minSpareNanos = nanos;
            }
        }
        if (minSpareNanos < this.switchMinNanos) {
            minSpareNanos = this.switchMinNanos;
        }
        if (debug != null) {
            logger.log(debug, "Minimum switching spare time: " + minSpareNanos + " ns. (~" + Math.ceil((double)minSpareNanos / 10000.0) / 100.0 + " ms.)");
        }
        long prepareLineOfs = this.startLineOfs;
        if (debug != null) {
            logger.log(debug, "Preparing new SyncHandler(s): start=" + start);
        }
        long prepareNanos = minSpareNanos;
        while (true) {
            int k;
            List prepareList;
            int prepareSize;
            long firstTime;
            long numBufs;
            long framePos;
            long time;
            double bufNanos;
            long startTime;
            if (debug != null) {
                logger.log(debug, "trying to prepare with spare time: " + prepareNanos + " ns.");
            }
            long latestTime = startTime = clock.nanos() + prepareNanos;
            if (audioGroupsToUpdateSize > 0) {
                for (i = 0; i < audioGroupsToUpdateSize; ++i) {
                    labAudioGroup = (WaxLabAudioSyncGroup)((Object)this.audioGroupsToUpdateList.get(i));
                    labAudioProc = labAudioGroup.getWaxLabAudioProcessor();
                    if (labAudioProc.isIdle()) continue;
                    frameRate = labAudioProc.frameRate;
                    bufFrames = labAudioProc.bufFrames;
                    bufNanos = labAudioProc.bufNanos;
                    WaxLabAudioProcessor.Info audioProcInfo = labAudioProc.getInfo();
                    time = audioProcInfo.time;
                    framePos = audioProcInfo.framePos;
                    labAudioGroup.syncTime = time;
                    labAudioGroup.syncFramePos = framePos;
                    numBufs = (long)Math.ceil((double)(startTime - time) / bufNanos);
                    if (numBufs < 2L) {
                        numBufs = 2L;
                    }
                    if ((firstTime = time + LineUtil.getNanoOfs((long)(numBufs * (long)bufFrames), (double)frameRate)) <= latestTime) continue;
                    latestTime = firstTime;
                }
                startTime = latestTime;
            }
            if (audioGroupsToUpdateSize > 0) {
                for (i = 0; i < audioGroupsToUpdateSize; ++i) {
                    labAudioGroup = (WaxLabAudioSyncGroup)((Object)this.audioGroupsToUpdateList.get(i));
                    labAudioProc = labAudioGroup.getWaxLabAudioProcessor();
                    if (labAudioProc.isIdle()) continue;
                    frameRate = labAudioProc.frameRate;
                    bufFrames = labAudioProc.bufFrames;
                    bufNanos = labAudioProc.bufNanos;
                    time = labAudioGroup.syncTime;
                    framePos = labAudioGroup.syncFramePos;
                    numBufs = (long)Math.ceil((double)(latestTime - time) / bufNanos);
                    firstTime = time + LineUtil.getNanoOfs((long)(numBufs * (long)bufFrames), (double)frameRate);
                    if (firstTime > latestTime && numBufs > 2L) {
                        firstTime = time + LineUtil.getNanoOfs((long)(--numBufs * (long)bufFrames), (double)frameRate);
                    }
                    if (firstTime > latestTime && logger.isLoggable(Level.WARNING)) {
                        logger.warning("OOPS, unexpected firstTime: " + firstTime + " > " + latestTime);
                    }
                    if (firstTime < startTime) {
                        startTime = firstTime;
                    }
                    labAudioProc.syncSwtchPos = framePos + numBufs * (long)bufFrames;
                    labAudioProc.syncSwtchTime = firstTime;
                    if (trace == null) continue;
                    logger.log(trace, " - prepare AudioSyncGroup: " + (Object)((Object)labAudioGroup) + ", firstTime=" + firstTime + ", numBufs=" + numBufs + ", switchPos=" + labAudioProc.syncSwtchPos);
                }
            }
            long masterLatestTime = this.master.nanoSync(latestTime);
            if (start) {
                this.startTimeBase = masterLatestTime;
                if (debug != null) {
                    logger.log(debug, "startTimeBase: " + this.startTimeBase);
                }
            }
            if (audioGroupsToUpdateSize > 0) {
                for (i = 0; i < audioGroupsToUpdateSize; ++i) {
                    labAudioGroup = (WaxLabAudioSyncGroup)((Object)this.audioGroupsToUpdateList.get(i));
                    labAudioProc = labAudioGroup.getWaxLabAudioProcessor();
                    if (labAudioProc.isIdle() || (prepareSize = (prepareList = labAudioGroup.prepareList).size()) < 1) continue;
                    frameRate = labAudioProc.frameRate;
                    prepareLineOfs = this.startLineOfs + labAudioProc.syncStartTime - this.startTimeBase + LineUtil.getNanoOfs((long)labAudioProc.syncSwtchPos, (double)frameRate);
                    long prepareStudioTime = labAudioProc.syncSwtchTime;
                    long prepareMasterTime = masterLatestTime - latestTime + prepareStudioTime;
                    if (trace != null) {
                        logger.log(trace, " - prepare new Audio-SyncHandler(s): " + (Object)((Object)labAudioGroup) + ", handlers=" + prepareSize + ", switchPos=" + labAudioProc.syncSwtchPos + ", prepareLineOfs=" + startLineOfs + " -> " + prepareLineOfs);
                    }
                    for (k = 0; k < prepareSize; ++k) {
                        syncHandler = (SyncHandler)prepareList.get(k);
                        syncFeature = syncHandler.syncFeature;
                        if (syncFeature == null) continue;
                        if (trace != null) {
                            logger.log(trace, "   - prepare SyncHandler: " + syncHandler);
                        }
                        try {
                            syncFeature.lineFeature.prepareSyncHandler(syncHandler, labAudioGroup, prepareLineOfs, prepareStudioTime, prepareMasterTime);
                            continue;
                        }
                        catch (Throwable e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                }
            }
            if (midiInPortsToUpdateSize > 0) {
                for (i = 0; i < midiInPortsToUpdateSize; ++i) {
                    midiInPort = (WaxLabMidiInputPort)((Object)this.midiInPortsToUpdateList.get(i));
                    prepareList = midiInPort.prepareList;
                    prepareSize = prepareList.size();
                    if (prepareSize < 1) continue;
                    prepareLineOfs = this.startLineOfs + masterLatestTime - this.startTimeBase;
                    long prepareStudioTime = latestTime;
                    long prepareMasterTime = masterLatestTime;
                    if (trace != null) {
                        logger.log(trace, " - prepare new MidiInput-SyncHandler(s): " + (Object)((Object)midiInPort) + ", handlers=" + prepareSize + ", prepareLineOfs=" + startLineOfs + " -> " + prepareLineOfs);
                    }
                    for (k = 0; k < prepareSize; ++k) {
                        syncHandler = (SyncHandler)prepareList.get(k);
                        syncFeature = syncHandler.syncFeature;
                        if (syncFeature == null) continue;
                        if (trace != null) {
                            logger.log(trace, "   - prepare SyncHandler: " + syncHandler);
                        }
                        try {
                            syncFeature.lineFeature.prepareSyncHandler(syncHandler, midiInPort, prepareLineOfs, prepareStudioTime, prepareMasterTime);
                            continue;
                        }
                        catch (Throwable e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                }
            }
            if (midiOutPortsToUpdateSize > 0) {
                for (i = 0; i < midiOutPortsToUpdateSize; ++i) {
                    midiOutPort = (WaxLabMidiOutputPort)((Object)this.midiOutPortsToUpdateList.get(i));
                    prepareList = midiOutPort.prepareList;
                    prepareSize = prepareList.size();
                    if (prepareSize < 1) continue;
                    prepareLineOfs = this.startLineOfs + masterLatestTime - this.startTimeBase;
                    long prepareStudioTime = latestTime;
                    long prepareMasterTime = masterLatestTime;
                    if (trace != null) {
                        logger.log(trace, " - prepare new MidiOutput-SyncHandler(s): " + (Object)((Object)midiOutPort) + ", handlers=" + prepareSize + ", prepareLineOfs=" + startLineOfs + " -> " + prepareLineOfs);
                    }
                    for (k = 0; k < prepareSize; ++k) {
                        syncHandler = (SyncHandler)prepareList.get(k);
                        syncFeature = syncHandler.syncFeature;
                        if (syncFeature == null) continue;
                        if (trace != null) {
                            logger.log(trace, "   - prepare SyncHandler: " + syncHandler);
                        }
                        try {
                            syncFeature.lineFeature.prepareSyncHandler(syncHandler, midiOutPort, prepareLineOfs, prepareStudioTime, prepareMasterTime);
                            continue;
                        }
                        catch (Throwable e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                }
            }
            if ((nanos = startTime - clock.nanos()) >= minSpareNanos) break;
            prepareNanos += minSpareNanos - nanos;
        }
        if (audioGroupsToUpdateSize > 0) {
            for (i = 0; i < audioGroupsToUpdateSize; ++i) {
                labAudioGroup = (WaxLabAudioSyncGroup)((Object)this.audioGroupsToUpdateList.get(i));
                labAudioProc = labAudioGroup.getWaxLabAudioProcessor();
                long swtchPos = labAudioProc.syncSwtchPos;
                SyncHandler[] handlers = labAudioProc.syncHandlers;
                AudioProcessor[] onceProcs = labAudioProc.syncOnceProcs;
                AudioProcessor[] normProcs = labAudioProc.syncNormProcs;
                labAudioProc.reset(swtchPos, onceProcId, onceProcs, handlers, normProcId, normProcs, handlers);
            }
        }
        if (midiInPortsToUpdateSize > 0) {
            for (i = 0; i < midiInPortsToUpdateSize; ++i) {
                midiInPort = (WaxLabMidiInputPort)((Object)this.midiInPortsToUpdateList.get(i));
                labMidiProc = midiInPort.getWaxLabMidiProcessor();
                if (labMidiProc == null) {
                    if (debug == null) continue;
                    logger.log(debug, "WaxLabMidiProcessor is not available for port: " + (Object)((Object)midiInPort));
                    continue;
                }
                MidiProcessor[] midiProcs = labMidiProc.syncMidiProcs;
                labMidiProc.reset(midiProcs);
            }
        }
        if (midiOutPortsToUpdateSize > 0) {
            for (i = 0; i < midiOutPortsToUpdateSize; ++i) {
                midiOutPort = (WaxLabMidiOutputPort)((Object)this.midiOutPortsToUpdateList.get(i));
            }
            size = this.midiPlayersToStop.size();
            if (size > 0) {
                try {
                    for (int k = 0; k < size; ++k) {
                        midiPlayer = (MidiPlayer)this.midiPlayersToStop.get(k);
                        long stopLineOfs = prepareLineOfs;
                        if (trace != null) {
                            logger.log(trace, "   - stop MidiPlayer: " + midiPlayer + ", stopLineOfs=" + stopLineOfs);
                        }
                        midiPlayer.setStopLineOfs(stopLineOfs);
                    }
                }
                finally {
                    this.midiPlayersToStop.clear();
                }
            }
            if ((size = this.midiPlayersToStart.size()) > 0) {
                try {
                    for (int k = 0; k < size; ++k) {
                        midiPlayer = (MidiPlayer)this.midiPlayersToStart.get(k);
                        if (trace != null) {
                            logger.log(trace, "   - start MidiPlayer: " + midiPlayer);
                        }
                        midiPlayer.play();
                    }
                }
                finally {
                    this.midiPlayersToStart.clear();
                }
            }
        }
        if (audioGroupsToUpdateSize > 0) {
            for (i = 0; i < audioGroupsToUpdateSize; ++i) {
                labAudioGroup = (WaxLabAudioSyncGroup)((Object)this.audioGroupsToUpdateList.get(i));
                labAudioGroup.prepareList.clear();
            }
            this.audioGroupsToUpdateList.clear();
            this.audioGroupsToUpdateSet.clear();
        }
        if (midiInPortsToUpdateSize > 0) {
            for (i = 0; i < midiInPortsToUpdateSize; ++i) {
                midiInPort = (WaxLabMidiInputPort)((Object)this.midiInPortsToUpdateList.get(i));
                midiInPort.prepareList.clear();
            }
            this.midiInPortsToUpdateList.clear();
            this.midiInPortsToUpdateSet.clear();
        }
        if (midiOutPortsToUpdateSize > 0) {
            for (i = 0; i < midiOutPortsToUpdateSize; ++i) {
                midiOutPort = (WaxLabMidiOutputPort)((Object)this.midiOutPortsToUpdateList.get(i));
                midiOutPort.prepareList.clear();
            }
            this.midiOutPortsToUpdateList.clear();
            this.midiOutPortsToUpdateSet.clear();
        }
        if (debug != null) {
            logger.log(debug, "-------- Mediate done --------");
        }
        if ((shutdownTimer = this.asyncShutdownTimer) != null && !shutdownTimer.isActive()) {
            this.asyncShutdownDelay = this.asyncShutdownMinDelay;
            shutdownTimer.setDelay(this.asyncShutdownDelay);
            shutdownTimer.start();
        }
    }

    protected AudioProcessor getAudioOutputPortMixer(WaxLabAudioSyncGroup syncGroup, WaxLabAudioOutputPort outPort) {
        MonoTarget mixer;
        SampleBuffer out = outPort.getBuffer();
        if (out == null) {
            return null;
        }
        List sourcesNew = outPort.sourcesNew;
        int sourceCount = sourcesNew.size();
        if (sourceCount < 1) {
            return null;
        }
        List sourcesOld = outPort.sourcesOld;
        if (sourceCount == sourcesOld.size()) {
            // empty if block
        }
        if (sourceCount == 1) {
            SampleBuffer in = (SampleBuffer)sourcesNew.get(0);
            switch (in.getChannels()) {
                case 1: {
                    mixer = new MonoTarget(in, out);
                    break;
                }
                case 2: {
                    mixer = new StereoTarget(in, out);
                    break;
                }
                default: {
                    mixer = new SurroundTarget(in, out);
                    break;
                }
            }
        } else if (sourceCount == 2) {
            SampleBuffer first = (SampleBuffer)sourcesNew.get(0);
            SampleBuffer second = (SampleBuffer)sourcesNew.get(1);
            mixer = new PairMixer(first, second, out);
        } else {
            SampleBuffer[] in = sourcesNew.toArray(new SampleBuffer[sourceCount]);
            mixer = new MultiMixer(in, out);
        }
        return mixer;
    }

    protected void insertHandlerIntoPort(SyncHandler handler) {
        if (handler == null) {
            return;
        }
        if (handler instanceof SyncHandler.AudioProcHandler) {
            SyncHandler.AudioProcHandler entry = (SyncHandler.AudioProcHandler)handler;
            WaxLabAudioSyncGroup syncGroup = entry.group;
            if (syncGroup != null && syncGroup.handlerSet.add(handler)) {
                this.insertHandlerIntoList(handler, syncGroup.handlerList);
                if (this.audioGroupsToUpdateSet.add(syncGroup)) {
                    this.audioGroupsToUpdateList.add(syncGroup);
                    syncGroup.prepareList.clear();
                }
                syncGroup.prepareList.add(handler);
            }
            return;
        }
        if (handler instanceof SyncHandler.AudioOutHandler) {
            SyncHandler.AudioOutHandler entry = (SyncHandler.AudioOutHandler)handler;
            WaxLabAudioSyncGroup syncGroup = entry.group;
            if (syncGroup != null && syncGroup.handlerSet.add(handler)) {
                this.insertHandlerIntoList(handler, syncGroup.handlerList);
                if (this.audioGroupsToUpdateSet.add(syncGroup)) {
                    this.audioGroupsToUpdateList.add(syncGroup);
                    syncGroup.prepareList.clear();
                }
                syncGroup.prepareList.add(handler);
            }
            return;
        }
        if (handler instanceof SyncHandler.MidiProcHandler) {
            SyncHandler.MidiProcHandler entry = (SyncHandler.MidiProcHandler)handler;
            WaxLabMidiInputPort midiPort = entry.port;
            if (midiPort != null && midiPort.handlerSet.add(handler)) {
                this.insertHandlerIntoList(handler, midiPort.handlerList);
                if (this.midiInPortsToUpdateSet.add(midiPort)) {
                    this.midiInPortsToUpdateList.add(midiPort);
                    midiPort.prepareList.clear();
                }
                midiPort.prepareList.add(handler);
            }
            return;
        }
        if (handler instanceof SyncHandler.MidiOutHandler) {
            SyncHandler.MidiOutHandler entry = (SyncHandler.MidiOutHandler)handler;
            WaxLabMidiOutputPort midiPort = entry.port;
            if (midiPort != null && midiPort.handlerSet.add(handler)) {
                this.insertHandlerIntoList(handler, midiPort.handlerList);
                if (this.midiOutPortsToUpdateSet.add(midiPort)) {
                    this.midiOutPortsToUpdateList.add(midiPort);
                    midiPort.prepareList.clear();
                }
                midiPort.prepareList.add(handler);
            }
            return;
        }
        logger.warning("Unsupported handler: " + handler);
    }

    private void insertHandlerIntoList(SyncHandler handler, List handlerList) {
        int index;
        int prio = handler.priority;
        int num = handlerList.size();
        for (index = 0; index < num; ++index) {
            SyncHandler other = (SyncHandler)handlerList.get(index);
            if (other.priority < prio) break;
        }
        handlerList.add(index, handler);
    }

    protected void removeHandlerFromPort(SyncHandler handler) {
        if (handler == null) {
            return;
        }
        if (handler instanceof SyncHandler.AudioProcHandler) {
            SyncHandler.AudioProcHandler entry = (SyncHandler.AudioProcHandler)handler;
            WaxLabAudioSyncGroup syncGroup = entry.group;
            if (syncGroup != null && syncGroup.handlerSet.remove(handler)) {
                syncGroup.handlerList.remove(handler);
                if (this.audioGroupsToUpdateSet.add(syncGroup)) {
                    this.audioGroupsToUpdateList.add(syncGroup);
                }
            }
            return;
        }
        if (handler instanceof SyncHandler.AudioOutHandler) {
            SyncHandler.AudioOutHandler entry = (SyncHandler.AudioOutHandler)handler;
            WaxLabAudioSyncGroup syncGroup = entry.group;
            if (syncGroup != null && syncGroup.handlerSet.remove(handler)) {
                syncGroup.handlerList.remove(handler);
                if (this.audioGroupsToUpdateSet.add(syncGroup)) {
                    this.audioGroupsToUpdateList.add(syncGroup);
                }
            }
            return;
        }
        if (handler instanceof SyncHandler.MidiProcHandler) {
            SyncHandler.MidiProcHandler entry = (SyncHandler.MidiProcHandler)handler;
            WaxLabMidiInputPort midiPort = entry.port;
            if (midiPort != null && midiPort.handlerSet.remove(handler)) {
                midiPort.handlerList.remove(handler);
                if (this.midiInPortsToUpdateSet.add(midiPort)) {
                    this.midiInPortsToUpdateList.add(midiPort);
                }
                midiPort.releaseList.add(handler);
            }
            return;
        }
        if (handler instanceof SyncHandler.MidiOutHandler) {
            SyncHandler.MidiOutHandler entry = (SyncHandler.MidiOutHandler)handler;
            WaxLabMidiOutputPort midiPort = entry.port;
            if (midiPort != null && midiPort.handlerSet.remove(handler)) {
                midiPort.handlerList.remove(handler);
                if (this.midiOutPortsToUpdateSet.add(midiPort)) {
                    this.midiOutPortsToUpdateList.add(midiPort);
                }
                midiPort.releaseList.add(handler);
            }
            return;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Unsupported handler: " + handler);
        }
    }

    protected SyncHandler[] buildSyncHandlerArray(List list) {
        int num = list.size();
        if (num < 1) {
            return NO_SYNC_HANDLERS;
        }
        return list.toArray(new SyncHandler[num]);
    }

    protected AudioProcessor[] buildAudioProcessorArray(List list) {
        int num = list.size();
        if (num < 1) {
            return WaxLabAudioSyncGroup.NO_PROCS;
        }
        return list.toArray(new AudioProcessor[num]);
    }

    protected MidiProcessor[] buildMidiProcessorArray(List list) {
        int num = list.size();
        if (num < 1) {
            return WaxLabMidiSyncGroup.NO_PROCS;
        }
        return list.toArray(new MidiProcessor[num]);
    }

    protected MidiProcessor[] includeMidiProcessor(MidiProcessor proc, MidiProcessor[] procs) {
        if (proc == null) {
            return procs;
        }
        int num = procs == null ? 0 : procs.length;
        for (int i = 0; i < num; ++i) {
            if (procs[i] != proc) continue;
            return procs;
        }
        MidiProcessor[] arr = new MidiProcessor[num + 1];
        if (num > 0) {
            System.arraycopy(procs, 0, arr, 0, num);
        }
        arr[num] = proc;
        return arr;
    }

    protected MidiProcessor[] excludeMidiProcessor(MidiProcessor proc, MidiProcessor[] procs) {
        if (proc == null) {
            return procs;
        }
        int num = procs == null ? 0 : procs.length;
        for (int i = 0; i < num; ++i) {
            if (procs[i] != proc) continue;
            MidiProcessor[] arr = new MidiProcessor[--num];
            if (i > 0) {
                System.arraycopy(procs, 0, arr, 0, i);
            }
            if (i < num) {
                System.arraycopy(procs, i + 1, arr, i, num - i);
            }
            return arr;
        }
        return procs;
    }

    protected synchronized void resetWaxLabMidiMappings(WaxLabMidiInputPort newMidiPort, MidiMapping[] newMappings) {
        MidiMapping mapping;
        int i;
        int num;
        WaxLab waxLab = this.getWaxLab();
        int numMappings = newMappings == null ? 0 : newMappings.length;
        WaxLabMidiInputPort oldMidiPort = this.waxLabMidiMappingPort;
        MidiActionProcessor oldActionProc = oldMidiPort == null ? null : oldMidiPort.syncMidiActionProc;
        WaxLabMidiProcessor oldWaxLabMidiProc = oldMidiPort == null ? null : oldMidiPort.getWaxLabMidiProcessor();
        MidiActionProcessor newActionProc = null;
        WaxLabMidiProcessor newWaxLabMidiProc = null;
        if (newMidiPort != null) {
            newActionProc = newMidiPort.syncMidiActionProc;
            if (newActionProc == null) {
                newMidiPort.syncMidiActionProc = newActionProc = new MidiActionProcessor(newMidiPort.getName());
            }
            newWaxLabMidiProc = newMidiPort.getWaxLabMidiProcessor();
        }
        this.waxLabMidiMappingPort = newMidiPort;
        if (oldActionProc != null && oldActionProc != newActionProc && this.waxLabMidiMappings != null) {
            num = this.waxLabMidiMappings.length;
            for (i = 0; i < num; ++i) {
                mapping = this.waxLabMidiMappings[i];
                if (mapping == null) continue;
                oldActionProc.removeMidiMapping(mapping);
                oldActionProc.removeMidiAction(mapping.getAction());
            }
            this.waxLabMidiMappings = null;
            oldActionProc.validate();
        }
        if (newActionProc != null) {
            if (this.waxLabMidiMappings != null) {
                num = this.waxLabMidiMappings.length;
                for (i = 0; i < num; ++i) {
                    mapping = this.waxLabMidiMappings[i];
                    if (mapping == null) continue;
                    newActionProc.removeMidiMapping(mapping);
                    newActionProc.removeMidiAction(mapping.getAction());
                }
                this.waxLabMidiMappings = null;
            }
            if (waxLab != null && numMappings > 0) {
                MidiMapping[] mappings = new MidiMapping[numMappings];
                for (i = 0; i < numMappings; ++i) {
                    mapping = newMappings[i];
                    if (mapping == null) continue;
                    MidiAction action = waxLab.getMidiAction(mapping);
                    if (action == null) {
                        if (!logger.isLoggable(Level.FINER)) continue;
                        logger.finer("MidiAction not found for MidiMapping: " + mapping.getClass() + " = " + mapping);
                        continue;
                    }
                    mappings[i] = mapping;
                    newActionProc.addMidiAction(mapping.getAction(), action);
                    newActionProc.addMidiMapping(mapping);
                }
                this.waxLabMidiMappings = mappings;
            }
            newActionProc.validate();
        }
        if (oldWaxLabMidiProc != null && oldWaxLabMidiProc != newWaxLabMidiProc) {
            MidiProcessor[] procs = oldWaxLabMidiProc.getProcessors();
            MidiProcessor[] arr = oldActionProc.getMidiMappingCount() > 0 ? this.includeMidiProcessor((MidiProcessor)oldActionProc, procs) : this.excludeMidiProcessor((MidiProcessor)oldActionProc, procs);
            if (arr != procs) {
                oldWaxLabMidiProc.reset(arr);
            }
        }
        if (newWaxLabMidiProc != null) {
            MidiProcessor[] procs = newWaxLabMidiProc.getProcessors();
            MidiProcessor[] arr = newActionProc.getMidiMappingCount() > 0 ? this.includeMidiProcessor((MidiProcessor)newActionProc, procs) : this.excludeMidiProcessor((MidiProcessor)newActionProc, procs);
            if (arr != procs) {
                newWaxLabMidiProc.reset(arr);
            }
        }
    }

    public synchronized boolean shutdownOldHandlers() {
        boolean allDone = true;
        if (!this.shutdownOldMidiOutputHandlers()) {
            allDone = false;
        }
        if (!this.shutdownOldMidiInputHandlers()) {
            allDone = false;
        }
        if (!this.shutdownOldAudioHandlers()) {
            allDone = false;
        }
        return allDone;
    }

    protected boolean shutdownOldAudioHandlers() {
        WaxLabAudioProcessor labAudioProc;
        int i;
        boolean allDone = true;
        int num = this.labAudioProcList.size();
        if (num > 0) {
            for (i = 0; i < num; ++i) {
                labAudioProc = (WaxLabAudioProcessor)this.labAudioProcList.get(i);
                if (labAudioProc.releaseUnusedHandlers()) continue;
                allDone = false;
            }
        }
        if ((num = this.labAudioProcsToShutdownList.size()) > 0) {
            for (i = 0; i < num; ++i) {
                labAudioProc = (WaxLabAudioProcessor)this.labAudioProcsToShutdownList.get(i);
                if (labAudioProc.releaseUnusedHandlers()) continue;
                allDone = false;
            }
            this.labAudioProcsToShutdownList.clear();
        }
        return allDone;
    }

    protected boolean shutdownOldMidiInputHandlers() {
        SyncHandler handler;
        int k;
        int releaseCount;
        List releaseList;
        WaxLabMidiInputPort midiPort;
        int i;
        int num = this.labMidiInputList.size();
        if (num > 0) {
            for (i = 0; i < num; ++i) {
                midiPort = (WaxLabMidiInputPort)((Object)this.labMidiInputList.get(i));
                releaseList = midiPort.releaseList;
                releaseCount = releaseList.size();
                if (releaseCount <= 0) continue;
                for (k = 0; k < releaseCount; ++k) {
                    handler = (SyncHandler)releaseList.get(k);
                    if (handler.lastUsedId == midiPort.currentProcId) continue;
                    handler.syncFeature.releaseSyncHandler(handler);
                }
                releaseList.clear();
            }
        }
        if ((num = this.labMidiInputToShutdownList.size()) > 0) {
            for (i = 0; i < num; ++i) {
                midiPort = (WaxLabMidiInputPort)((Object)this.labMidiInputToShutdownList.get(i));
                releaseList = midiPort.releaseList;
                releaseCount = releaseList.size();
                if (releaseCount <= 0) continue;
                for (k = 0; k < releaseCount; ++k) {
                    handler = (SyncHandler)releaseList.get(k);
                    handler.syncFeature.releaseSyncHandler(handler);
                }
                releaseList.clear();
            }
            this.labMidiInputToShutdownList.clear();
        }
        return true;
    }

    protected boolean shutdownOldMidiOutputHandlers() {
        SyncHandler handler;
        int k;
        int releaseCount;
        List releaseList;
        WaxLabMidiOutputPort midiPort;
        int i;
        int num = this.labMidiOutputList.size();
        if (num > 0) {
            for (i = 0; i < num; ++i) {
                midiPort = (WaxLabMidiOutputPort)((Object)this.labMidiOutputList.get(i));
                releaseList = midiPort.releaseList;
                releaseCount = releaseList.size();
                if (releaseCount <= 0) continue;
                for (k = 0; k < releaseCount; ++k) {
                    handler = (SyncHandler)releaseList.get(k);
                    if (handler.lastUsedId == midiPort.currentProcId) continue;
                    handler.syncFeature.releaseSyncHandler(handler);
                }
                releaseList.clear();
            }
        }
        if ((num = this.labMidiOutputToShutdownList.size()) > 0) {
            for (i = 0; i < num; ++i) {
                midiPort = (WaxLabMidiOutputPort)((Object)this.labMidiOutputToShutdownList.get(i));
                releaseList = midiPort.releaseList;
                releaseCount = releaseList.size();
                if (releaseCount <= 0) continue;
                for (k = 0; k < releaseCount; ++k) {
                    handler = (SyncHandler)releaseList.get(k);
                    handler.syncFeature.releaseSyncHandler(handler);
                }
                releaseList.clear();
            }
            this.labMidiOutputToShutdownList.clear();
        }
        return true;
    }

    protected class AsyncShutdown
    implements Runnable {
        protected AsyncShutdown() {
        }

        @Override
        public void run() {
            boolean allDone = SyncMediatorImpl.this.shutdownOldHandlers();
            if (allDone) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("shutdownOldHandlers: done.");
                }
                SyncMediatorImpl.this.asyncShutdownTimer.stop();
            } else {
                int delay = SyncMediatorImpl.this.asyncShutdownDelay << 1;
                if (delay > SyncMediatorImpl.this.asyncShutdownMaxDelay || delay < SyncMediatorImpl.this.asyncShutdownDelay) {
                    delay = SyncMediatorImpl.this.asyncShutdownMaxDelay;
                }
                if (delay != SyncMediatorImpl.this.asyncShutdownDelay) {
                    SyncMediatorImpl.this.asyncShutdownDelay = delay;
                    SyncMediatorImpl.this.asyncShutdownTimer.setDelay(delay);
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("shutdownOldHandlers: delay=" + delay);
                }
            }
        }
    }
}

