/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.model.LineUtil;
import com.waxmonster.waxlab.impl.SyncClockAccess;
import com.waxmonster.waxlab.impl.SyncHandler;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;

public class WaxLabAudioProcessor
implements AudioProcessor,
SyncClockAccess {
    public static final long NO_START = Long.MAX_VALUE;
    public static final long NO_SWTCH = Long.MAX_VALUE;
    private final WaxLabAudioSyncGroup syncGroup;
    private final String name;
    private final SampleBuffer[] in;
    private final SampleBuffer[] out;
    protected final int bufFrames;
    protected final double bufNanos;
    protected final float frameRate;
    protected final double millisPerFrame;
    protected final double nanosPerFrame;
    protected volatile long startTime;
    protected volatile long framePos;
    protected volatile long nanoBase;
    protected Info[] info;
    protected int infoLen;
    protected volatile int infoIdx;
    protected volatile Proc proc;
    protected volatile Proc head;
    protected volatile Swch tail;
    private Idle idlePool;
    private Norm normPool;
    private Once oncePool;
    long syncStartTime = Long.MAX_VALUE;
    long syncSwtchTime = Long.MAX_VALUE;
    long syncSwtchPos = Long.MAX_VALUE;
    SyncHandler[] syncHandlers;
    AudioProcessor[] syncOnceProcs;
    AudioProcessor[] syncNormProcs;

    protected WaxLabAudioProcessor(WaxLabAudioSyncGroup syncGroup, String name, int bufFrames, SampleBuffer[] in, SampleBuffer[] out, AudioProcessor[] procs) throws AudioException {
        int infoLen;
        this.syncGroup = syncGroup;
        this.name = name;
        this.in = in;
        this.out = out;
        this.frameRate = this.enumerateFrameRate(in, out);
        this.bufFrames = bufFrames;
        this.bufNanos = LineUtil.getNanoPos((long)bufFrames, (double)this.frameRate);
        this.millisPerFrame = 1000.0 / (double)this.frameRate;
        this.nanosPerFrame = 1.0E9 / (double)this.frameRate;
        this.startTime = Long.MAX_VALUE;
        this.framePos = 0L;
        int poolLen = 4;
        for (int i = 0; i < poolLen; ++i) {
            this.idlePool = new Idle(0, this.idlePool);
            this.normPool = new Norm(0, null, null, Long.MAX_VALUE, this.normPool);
            this.oncePool = new Once(0, null, null, this.oncePool);
        }
        Swch swch = procs != null && procs.length > 0 ? new Norm(0, null, procs) : new Idle(0);
        this.proc = swch;
        this.head = swch;
        this.tail = swch;
        this.infoLen = infoLen = 1000;
        this.info = new Info[infoLen];
        for (int i = 0; i < infoLen; ++i) {
            this.info[i] = new Info();
        }
    }

    protected final WaxLabAudioSyncGroup getSyncGroup() {
        return this.syncGroup;
    }

    public boolean isActive() {
        return this.startTime != Long.MAX_VALUE;
    }

    public boolean isIdle() {
        return this.startTime == Long.MAX_VALUE;
    }

    protected float enumerateFrameRate(SampleBuffer[] in, SampleBuffer[] out) throws AudioException {
        SampleBuffer sb;
        int i;
        float rate = -1.0f;
        for (i = 0; !(i >= in.length || (sb = in[i]) != null && (rate = sb.getFrameRate()) > 0.0f); ++i) {
        }
        if (rate <= 0.0f) {
            for (i = 0; !(i >= out.length || (sb = out[i]) != null && (rate = sb.getFrameRate()) > 0.0f); ++i) {
            }
        }
        if (rate <= 0.0f) {
            throw new AudioException("Invalid frame rate: " + rate);
        }
        return rate;
    }

    public void process(long time, int frames) throws AudioException {
        this.proc.next(time, frames);
    }

    public void shutdown() throws AudioException {
        this.proc = null;
        this.syncGroup.getSyncMediator().removeWaxLabAudioProcessor(this);
    }

    public synchronized void reset(long swtchPos, int onceId, AudioProcessor[] onceProcs, SyncHandler[] onceHandlers, int normId, AudioProcessor[] normProcs, SyncHandler[] normHandlers) {
        Swch norm = normProcs != null ? this.getNorm(normId, normHandlers, normProcs) : this.getIdle(normId);
        Proc next = norm;
        if (onceProcs != null) {
            next = this.getOnce(onceId, onceHandlers, onceProcs, next);
        }
        Swch prev = this.tail;
        this.tail = norm;
        prev.next = next;
        prev.swtchPos = swtchPos;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized boolean releaseUnusedHandlers() {
        block0: while (true) {
            if ((h = this.head) == this.proc) {
                return h == this.tail;
            }
            this.head = h.next;
            id = h.id;
            handlers = h.handlers;
            h.handlers = null;
            h.procs = null;
            h.recycle();
            if (handlers == null) continue;
            n = handlers.length;
            i = 0;
            while (true) {
                if (i < n) ** break;
                continue block0;
                handler = handlers[i];
                if (handler != null && handler.lastUsedId - id <= 0 && (feature = handler.syncFeature) != null) {
                    feature.releaseSyncHandler(handler);
                }
                ++i;
            }
            break;
        }
    }

    public Norm getNorm(int id, SyncHandler[] handlers, AudioProcessor[] procs) {
        return this.getNorm(id, handlers, procs, Long.MAX_VALUE, null);
    }

    public synchronized Norm getNorm(int id, SyncHandler[] handlers, AudioProcessor[] procs, long swtchPos, Proc next) {
        Norm proc = this.normPool;
        if (proc != null) {
            this.normPool = (Norm)proc.next;
            proc.id = id;
            proc.next = next;
            proc.procs = procs;
            proc.handlers = handlers;
            proc.swtchPos = swtchPos;
            return proc;
        }
        return new Norm(id, handlers, procs, swtchPos, next);
    }

    public synchronized Once getOnce(int id, SyncHandler[] handlers, AudioProcessor[] procs, Proc next) {
        Once proc = this.oncePool;
        if (proc != null) {
            this.oncePool = (Once)proc.next;
            proc.id = id;
            proc.next = next;
            proc.procs = procs;
            proc.handlers = handlers;
            return proc;
        }
        return new Once(id, handlers, procs, next);
    }

    public synchronized Idle getIdle(int id) {
        Idle proc = this.idlePool;
        if (proc != null) {
            this.idlePool = (Idle)proc.next;
            proc.id = id;
            proc.next = null;
            proc.procs = null;
            return proc;
        }
        return new Idle(id);
    }

    public int getBufferFrames() {
        return this.bufFrames;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public double getMillisPerFrame() {
        return this.millisPerFrame;
    }

    public double getNanosPerFrame() {
        return this.nanosPerFrame;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFramePosition() {
        return this.framePos;
    }

    public double getMilliPosition() {
        return (double)this.framePos * this.millisPerFrame;
    }

    public double getNanoPosition() {
        return (double)this.framePos * this.nanosPerFrame;
    }

    final SampleBuffer[] getIn() {
        return this.in;
    }

    final SampleBuffer[] getOut() {
        return this.out;
    }

    public Info getInfo() {
        return this.info[this.infoIdx];
    }

    public double nanoDelta(Info info) {
        return (double)(info.time - this.startTime) - (double)info.framePos * this.nanosPerFrame;
    }

    public double nanoDelta() {
        return this.nanoDelta(this.info[this.infoIdx]);
    }

    public long nanoSync(long time) {
        return time - (long)this.nanoDelta(this.info[this.infoIdx]) - this.nanoBase;
    }

    public long nanoSync(double time) {
        return (long)(time - this.nanoDelta(this.info[this.infoIdx])) - this.nanoBase;
    }

    @Override
    public long nanoBase() {
        return this.nanoBase;
    }

    @Override
    public void rebase(long nanoBase) {
        this.nanoBase = nanoBase;
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }

    protected class Once
    extends Proc {
        protected boolean done;

        public Once(int id, SyncHandler[] handlers, AudioProcessor[] procs, Proc next) {
            this.id = id;
            this.handlers = handlers;
            this.procs = procs;
            this.next = next;
            this.done = false;
        }

        @Override
        public void frst(long time, int frames) throws AudioException {
            this.done = true;
            AudioProcessor[] pr = this.procs;
            int n = pr.length;
            int i = 0;
            while (i < n) {
                pr[i++].process(time, frames);
            }
            WaxLabAudioProcessor.this.proc = this;
        }

        @Override
        public void next(long time, int frames) throws AudioException {
            int idx = (WaxLabAudioProcessor.this.infoIdx + 1) % WaxLabAudioProcessor.this.infoLen;
            Info x = WaxLabAudioProcessor.this.info[idx];
            x.time = time;
            x.framePos = WaxLabAudioProcessor.this.framePos;
            WaxLabAudioProcessor.this.infoIdx = idx;
            WaxLabAudioProcessor.this.framePos += (long)frames;
            if (this.done) {
                this.next.frst(time, frames);
            } else {
                this.done = true;
                AudioProcessor[] pr = this.procs;
                int n = pr.length;
                int i = 0;
                while (i < n) {
                    pr[i++].process(time, frames);
                }
            }
        }

        @Override
        public void recycle() {
            this.done = false;
            this.next = WaxLabAudioProcessor.this.oncePool;
            WaxLabAudioProcessor.this.oncePool = this;
        }
    }

    protected class Idle
    extends Swch {
        public Idle(int id) {
            this.id = id;
            this.swtchPos = Long.MAX_VALUE;
        }

        public Idle(int id, Proc next) {
            this(id);
            this.next = next;
        }

        @Override
        public void frst(long time, int frames) throws AudioException {
            WaxLabAudioProcessor.this.startTime = Long.MAX_VALUE;
            WaxLabAudioProcessor.this.framePos = 0L;
            WaxLabAudioProcessor.this.syncStartTime = Long.MAX_VALUE;
            WaxLabAudioProcessor.this.proc = this;
        }

        @Override
        public void next(long time, int frames) throws AudioException {
            if (this.swtchPos != Long.MAX_VALUE) {
                WaxLabAudioProcessor.this.startTime = time;
                WaxLabAudioProcessor.this.framePos = 0L;
                int idx = (WaxLabAudioProcessor.this.infoIdx + 1) % WaxLabAudioProcessor.this.infoLen;
                Info x = WaxLabAudioProcessor.this.info[idx];
                x.time = time;
                x.framePos = WaxLabAudioProcessor.this.framePos;
                WaxLabAudioProcessor.this.infoIdx = idx;
                WaxLabAudioProcessor.this.framePos += (long)frames;
                this.next.frst(time, frames);
            }
        }

        @Override
        public void recycle() {
            this.swtchPos = Long.MAX_VALUE;
            this.next = WaxLabAudioProcessor.this.idlePool;
            WaxLabAudioProcessor.this.idlePool = this;
        }
    }

    protected class Norm
    extends Swch {
        public Norm(int id, SyncHandler[] handlers, AudioProcessor[] procs, long swtchPos, Proc next) {
            this.id = id;
            this.handlers = handlers;
            this.procs = procs;
            this.next = next;
            this.swtchPos = swtchPos;
        }

        public Norm(int id, SyncHandler[] handlers, AudioProcessor[] procs) {
            this(id, handlers, procs, Long.MAX_VALUE, null);
        }

        @Override
        public void frst(long time, int frames) throws AudioException {
            AudioProcessor[] pr = this.procs;
            int n = pr.length;
            int i = 0;
            while (i < n) {
                pr[i++].process(time, frames);
            }
            WaxLabAudioProcessor.this.proc = this;
        }

        @Override
        public void next(long time, int frames) throws AudioException {
            int idx = (WaxLabAudioProcessor.this.infoIdx + 1) % WaxLabAudioProcessor.this.infoLen;
            Info x = WaxLabAudioProcessor.this.info[idx];
            x.time = time;
            x.framePos = WaxLabAudioProcessor.this.framePos;
            WaxLabAudioProcessor.this.infoIdx = idx;
            WaxLabAudioProcessor.this.framePos += (long)frames;
            if (WaxLabAudioProcessor.this.framePos > this.swtchPos) {
                this.next.frst(time, frames);
            } else {
                AudioProcessor[] pr = this.procs;
                int n = pr.length;
                int i = 0;
                while (i < n) {
                    pr[i++].process(time, frames);
                }
            }
        }

        @Override
        public void recycle() {
            this.swtchPos = Long.MAX_VALUE;
            this.next = WaxLabAudioProcessor.this.normPool;
            WaxLabAudioProcessor.this.normPool = this;
        }
    }

    protected abstract class Swch
    extends Proc {
        protected volatile long swtchPos;

        protected Swch() {
        }
    }

    protected abstract class Proc {
        protected int id;
        protected SyncHandler[] handlers;
        protected AudioProcessor[] procs;
        protected volatile Proc next;

        protected Proc() {
        }

        public abstract void next(long var1, int var3) throws AudioException;

        public abstract void frst(long var1, int var3) throws AudioException;

        public abstract void recycle();
    }

    public static class Info {
        protected long time;
        protected long framePos;
    }
}

