/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.studio.Port;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabAudioInputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioOutputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WaxLabAudioSupport
extends AudioSupport {
    private final WaxLabDevice waxLabDevice;
    private boolean active;
    private final List syncGroupList;
    private final Map syncGroupMap;

    protected WaxLabAudioSupport(WaxLabDevice waxLabDevice) {
        this.waxLabDevice = waxLabDevice;
        this.syncGroupList = new ArrayList();
        this.syncGroupMap = new HashMap();
    }

    public String toString() {
        return super.toString() + "[device=" + (Object)((Object)this.waxLabDevice) + "]";
    }

    public synchronized void reset() {
        if (this.active) {
            for (WaxLabAudioSyncGroup group : this.syncGroupList) {
                group.dispose();
            }
            this.syncGroupList.clear();
            this.syncGroupMap.clear();
            this.active = false;
        }
    }

    public synchronized AudioSyncGroup getAudioSyncGroup(AudioPort port) {
        if (!this.active) {
            this.active = true;
            this.createAudioSyncGroups();
        }
        return (AudioSyncGroup)this.syncGroupMap.get(port);
    }

    protected synchronized void createAudioSyncGroups() {
        WaxLab waxLab = this.waxLabDevice.getWaxLab();
        if (waxLab == null) {
            return;
        }
        HashMap<String, LinkedList<Port>> portsByGroupName = new HashMap<String, LinkedList<Port>>();
        Port[] ports = this.waxLabDevice.getPorts();
        for (int i = 0; i < ports.length; ++i) {
            List<Object> list;
            String groupName;
            Port port = ports[i];
            if (port == null) continue;
            if (port instanceof WaxLabAudioInputPort) {
                WaxLabAudioInputPort inputPort = (WaxLabAudioInputPort)port;
                groupName = inputPort.getSyncGroupName();
                list = (LinkedList<Port>)portsByGroupName.get(groupName);
                if (list == null) {
                    list = new LinkedList<Port>();
                    portsByGroupName.put(groupName, (LinkedList<Port>)list);
                }
                list.add(port);
                continue;
            }
            if (!(port instanceof WaxLabAudioOutputPort)) continue;
            WaxLabAudioOutputPort outputPort = (WaxLabAudioOutputPort)port;
            groupName = outputPort.getSyncGroupName();
            list = (List)portsByGroupName.get(groupName);
            if (list == null) {
                list = new LinkedList();
                portsByGroupName.put(groupName, (LinkedList<Port>)list);
            }
            list.add(port);
        }
        for (Map.Entry me : portsByGroupName.entrySet()) {
            int i;
            String groupName = (String)me.getKey();
            List list = (List)me.getValue();
            Port[] p = list.toArray(new Port[list.size()]);
            LinkedList<WaxLabAudioInputPort> waxLabAudioInputPorts = new LinkedList<WaxLabAudioInputPort>();
            LinkedList<WaxLabAudioOutputPort> waxLabAudioOutputPorts = new LinkedList<WaxLabAudioOutputPort>();
            for (int i2 = 0; i2 < p.length; ++i2) {
                Port port = p[i2];
                if (port instanceof WaxLabAudioInputPort) {
                    waxLabAudioInputPorts.add((WaxLabAudioInputPort)port);
                    continue;
                }
                if (!(port instanceof WaxLabAudioOutputPort)) continue;
                waxLabAudioOutputPorts.add((WaxLabAudioOutputPort)port);
            }
            SyncMediator syncMediator = this.waxLabDevice.getSyncMediator();
            WaxLabAudioInputPort[] inputPorts = waxLabAudioInputPorts.toArray(new WaxLabAudioInputPort[waxLabAudioInputPorts.size()]);
            WaxLabAudioOutputPort[] outputPorts = waxLabAudioOutputPorts.toArray(new WaxLabAudioOutputPort[waxLabAudioOutputPorts.size()]);
            WaxLabAudioSyncGroup group = new WaxLabAudioSyncGroup(groupName, this.waxLabDevice, inputPorts, outputPorts, syncMediator);
            this.syncGroupList.add(group);
            for (i = 0; i < inputPorts.length; ++i) {
                this.syncGroupMap.put(inputPorts[i], group);
            }
            for (i = 0; i < outputPorts.length; ++i) {
                this.syncGroupMap.put(outputPorts[i], group);
            }
        }
    }
}

