/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Platform;
import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.common.AudioClearer;
import com.waxmonster.audio.common.StereoJoiner;
import com.waxmonster.audio.common.StereoSplitter;
import com.waxmonster.audio.common.SurroundJoiner;
import com.waxmonster.audio.common.SurroundSplitter;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabAudioInputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioJoinerInfo;
import com.waxmonster.waxlab.impl.WaxLabAudioOutputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioProcessor;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class WaxLabAudioSyncGroup
extends AudioSyncGroup {
    private static final Logger logger = Platform.getLogger(WaxLabAudioSyncGroup.class);
    private static final int DEFAULT_AUDIO_SHUTDOWN_TIMEOUT = 1000;
    protected static final AudioProcessor[] NO_PROCS = new AudioProcessor[0];
    private final WaxLabAudioInputPort[] waxLabAudioInputPorts;
    private final WaxLabAudioOutputPort[] waxLabAudioOutputPorts;
    private final WaxLabDevice device;
    private final WaxLab waxLab;
    final SyncMediator syncMediator;
    Set handlerSet;
    List handlerList;
    List prepareList;
    long syncTime;
    long syncFramePos;
    private WaxLabAudioProcessor waxLabAudioProcessor;
    private int audioShutdownTimeout = 1000;
    private final List audioJoinerInfos;

    protected WaxLabAudioSyncGroup(String name, WaxLabDevice device, WaxLabAudioInputPort[] inputPorts, WaxLabAudioOutputPort[] outputPorts, SyncMediator syncMediator) {
        super(name, (AudioInputPort[])inputPorts, (AudioOutputPort[])outputPorts);
        this.waxLabAudioInputPorts = inputPorts;
        this.waxLabAudioOutputPorts = outputPorts;
        this.device = device;
        this.waxLab = device.getWaxLab();
        this.syncMediator = syncMediator;
        this.handlerSet = new HashSet();
        this.handlerList = new ArrayList();
        this.prepareList = new ArrayList();
        this.audioJoinerInfos = new ArrayList();
    }

    protected final WaxLabDevice getDevice() {
        return this.device;
    }

    protected final WaxLab getWaxLab() {
        return this.waxLab;
    }

    protected final SyncMediator getSyncMediator() {
        return this.syncMediator;
    }

    protected void dispose() {
        for (WaxLabAudioInputPort port : this.waxLabAudioInputPorts) {
            port.setBuffer(null);
        }
        for (WaxLabAudioOutputPort port : this.waxLabAudioOutputPorts) {
            port.setBuffer(null);
            port.setClearer(null);
        }
    }

    public WaxLabAudioProcessor getWaxLabAudioProcessor() {
        return this.waxLabAudioProcessor;
    }

    public synchronized AudioProcessor createAudioProcessor(SampleBuffer[] in, SampleBuffer[] out) throws AudioException {
        SampleBuffer buf;
        Object port;
        int i;
        if (this.waxLabAudioProcessor != null) {
            throw new AudioException("WaxLabAudioProcessor is already initialized: " + (Object)((Object)this));
        }
        int inputCount = in.length;
        int outputCount = out.length;
        if (inputCount != this.waxLabAudioInputPorts.length) {
            throw new AudioException("Invalid number of input buffers: " + inputCount + " != " + this.waxLabAudioInputPorts.length);
        }
        if (outputCount != this.waxLabAudioOutputPorts.length) {
            throw new AudioException("Invalid number of output buffers: " + outputCount + " != " + this.waxLabAudioOutputPorts.length);
        }
        if (inputCount < 1 && outputCount < 1) {
            return null;
        }
        int bufFrames = -1;
        for (i = 0; i < inputCount; ++i) {
            port = this.waxLabAudioInputPorts[i];
            if (port.getBuffer() != null) {
                throw new AudioException("WaxLabAudioInputPort buffer is already initialized: " + (Object)port);
            }
            buf = in[i];
            port.setBuffer(buf);
            if (bufFrames >= 1 || buf == null) continue;
            bufFrames = buf.getSamples() / buf.getChannels();
        }
        for (i = 0; i < outputCount; ++i) {
            port = this.waxLabAudioOutputPorts[i];
            if (((WaxLabAudioOutputPort)((Object)port)).getBuffer() != null) {
                throw new AudioException("WaxLabAudioOutputPort buffer is already initialized: " + (Object)port);
            }
            buf = out[i];
            ((WaxLabAudioOutputPort)((Object)port)).setClearer((AudioProcessor)new AudioClearer(buf));
            ((WaxLabAudioOutputPort)((Object)port)).setBuffer(buf);
            if (bufFrames >= 1 || buf == null) continue;
            bufFrames = buf.getSamples() / buf.getChannels();
        }
        if (bufFrames < 1) {
            return null;
        }
        String name = this.getName();
        this.waxLabAudioProcessor = new WaxLabAudioProcessor(this, name, bufFrames, in, out, NO_PROCS);
        this.syncMediator.addWaxLabAudioProcessor(this.waxLabAudioProcessor);
        return this.waxLabAudioProcessor;
    }

    protected boolean testTimecodeModel(TimecodeModel tcModel) throws IOException {
        logger.info("testTimecodeModel: " + tcModel);
        long samples = tcModel.getSamples();
        long nanCount = 0L;
        double[] arr = new double[1];
        for (long i = 0L; i < samples; ++i) {
            tcModel.get(i, arr, 0, 1);
            if (!Double.isNaN(arr[0]) || ++nanCount >= 10L) continue;
            logger.warning("NaN timecode sample: #" + i);
        }
        if (nanCount > 0L) {
            logger.warning("Invalid timecode model: samples=" + samples + ", nanCount=" + nanCount);
            return false;
        }
        return true;
    }

    protected void dumpTimecodeModel(TimecodeModel tcModel) throws IOException {
        logger.info("dumpTimecodeModel: " + tcModel);
        long samples = tcModel.getSamples();
        logger.info("Timecode samples: " + samples);
        double[] arr = new double[1];
        for (long i = 0L; i < samples; ++i) {
            tcModel.get(i, arr, 0, 1);
            logger.info("Timecode sample #" + i + " = " + (double)Math.round(arr[0] * 1000.0) / 1000.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WaxLabAudioJoinerInfo setupAudioJoiner(WaxLabAudioInputPort[] recPorts) throws AudioException {
        SampleBuffer buffer;
        int channels = recPorts.length;
        if (channels < 1) {
            return null;
        }
        int bufFrames = -1;
        float bufRate = -1.0f;
        SampleBuffer[] inputs = new SampleBuffer[channels];
        for (int i = 0; i < channels; ++i) {
            WaxLabAudioInputPort port = recPorts[i];
            if (port == null || (buffer = port.getBuffer()) == null || buffer.getChannels() != 1) continue;
            int frames = buffer.getSamples();
            if (bufFrames < 1) {
                bufFrames = frames;
            }
            if (frames != bufFrames) continue;
            float rate = buffer.getFrameRate();
            if (bufRate <= 0.0f) {
                bufRate = rate;
            }
            if (rate != bufRate) continue;
            inputs[i] = buffer;
        }
        if (bufFrames < 1 || bufRate <= 0.0f) {
            return null;
        }
        WaxLabAudioJoinerInfo joinerInfo = null;
        List list = this.audioJoinerInfos;
        synchronized (list) {
            int num = this.audioJoinerInfos.size();
            for (int i = 0; i < num; ++i) {
                WaxLabAudioJoinerInfo inst = (WaxLabAudioJoinerInfo)this.audioJoinerInfos.get(i);
                if (!inst.sameInputs(inputs)) continue;
                joinerInfo = inst;
                break;
            }
            if (joinerInfo == null) {
                SampleBuffer[] inputsNotNull = inputs;
                for (int i = 0; i < channels; ++i) {
                    if (inputs[i] != null) continue;
                    SampleBuffer dummy = this.createDummyBuffer(bufRate, 1, bufFrames);
                    inputsNotNull = new SampleBuffer[channels];
                    for (int k = 0; k < channels; ++k) {
                        buffer = inputs[k];
                        inputsNotNull[k] = buffer == null ? dummy : buffer;
                    }
                    break;
                }
                SampleBuffer output = this.createJoinBuffer(bufRate, channels, bufFrames);
                AudioProcessor joiner = this.createAudioJoiner(inputsNotNull, output);
                joinerInfo = new WaxLabAudioJoinerInfo(inputs, output, joiner);
                this.audioJoinerInfos.add(joinerInfo);
            }
            ++joinerInfo.usedCount;
        }
        return joinerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void releaseAudioJoiner(WaxLabAudioJoinerInfo joinerInfo) {
        if (joinerInfo == null) {
            return;
        }
        List list = this.audioJoinerInfos;
        synchronized (list) {
            --joinerInfo.usedCount;
            if (joinerInfo.usedCount < 1) {
                this.audioJoinerInfos.remove(joinerInfo);
            }
        }
    }

    protected SampleBuffer createJoinBuffer(float frameRate, int channels, int bufFrames) {
        int samples = channels * bufFrames;
        return new DoubleArraySampleBuffer(channels, samples, frameRate, new double[samples]);
    }

    protected SampleBuffer createDummyBuffer(float frameRate, int channels, int bufFrames) {
        int samples = channels * bufFrames;
        return new DoubleArraySampleBuffer(channels, samples, frameRate, new double[samples]);
    }

    protected AudioProcessor createAudioJoiner(SampleBuffer[] in, SampleBuffer out) throws AudioException {
        int channels = out.getChannels();
        if (in.length != channels) {
            throw new AudioException("Invalid number of input channels: " + in.length + " != " + channels);
        }
        if (channels == 2) {
            return new StereoJoiner(in[0], in[1], out);
        }
        return new SurroundJoiner(in, out);
    }

    protected DoubleArraySampleBuffer createPlayBuffer(SampleBuffer buf, int channels, int frames, float rate) {
        int samples = frames * channels;
        if (buf != null && buf instanceof DoubleArraySampleBuffer && channels == buf.getChannels() && samples == buf.getSamples() && rate == buf.getFrameRate()) {
            return (DoubleArraySampleBuffer)buf;
        }
        return new DoubleArraySampleBuffer(channels, samples, rate, new double[samples]);
    }

    protected DoubleArraySampleBuffer createPlayBuffer(int channels, int frames, float rate) {
        return this.createPlayBuffer(null, channels, frames, rate);
    }

    protected SampleBuffer[] createSplitBuffers(SampleBuffer in) {
        float frameRate = in.getFrameRate();
        int channels = in.getChannels();
        int frames = in.getSamples() / channels;
        SampleBuffer[] out = new SampleBuffer[channels];
        for (int i = 0; i < channels; ++i) {
            out[i] = new DoubleArraySampleBuffer(1, frames, frameRate, new double[frames]);
        }
        return out;
    }

    protected AudioProcessor createAudioSplitter(SampleBuffer in, SampleBuffer[] out) throws AudioException {
        int channels = in.getChannels();
        if (out.length != channels) {
            throw new AudioException("Invalid number of output channels: " + out.length + " != " + channels);
        }
        if (channels == 2) {
            return new StereoSplitter(in, out[0], out[1]);
        }
        return new SurroundSplitter(in, out);
    }

    public int getAudioShutdownTimeout() {
        return this.audioShutdownTimeout;
    }

    public void setAudioShutdownTimeout(int audioShutdownTimeout) {
        this.audioShutdownTimeout = audioShutdownTimeout;
    }

    protected static class MidiMappingInfo {
        final WaxLabMidiSupport waxLabMidiSupport;
        final WaxLabMidiInputPort midiInputPort;
        final MidiMapping midiMapping;
        final MidiAction midiAction;

        public MidiMappingInfo(WaxLabMidiSupport waxLabMidiSupport, WaxLabMidiInputPort midiInputPort, MidiMapping midiMapping, MidiAction midiAction) {
            this.waxLabMidiSupport = waxLabMidiSupport;
            this.midiInputPort = midiInputPort;
            this.midiMapping = midiMapping;
            this.midiAction = midiAction;
        }
    }
}

