/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Clock;
import com.spacekiller.util.Platform;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.media.MediaPlayer;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.manager.MediaManagerPlugin;
import com.waxmonster.audio.AudioInputPortType;
import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.midi.MidiInputPortType;
import com.waxmonster.midi.MidiOutputPortType;
import com.waxmonster.midi.impl.MidiEngineConfig;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import com.waxmonster.waxlab.AudioLine;
import com.waxmonster.waxlab.AudioLineConfig;
import com.waxmonster.waxlab.EditorLine;
import com.waxmonster.waxlab.EditorLineConfig;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.TimecodeLine;
import com.waxmonster.waxlab.TimecodeLineConfig;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.SyncMediatorImpl;
import com.waxmonster.waxlab.impl.WaxLabAudioInputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioOutputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioSupport;
import com.waxmonster.waxlab.impl.WaxLabDeviceInfo;
import com.waxmonster.waxlab.impl.WaxLabImpl;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiSupport;
import com.waxmonster.waxlab.impl.WaxLabPanel;
import com.waxmonster.waxlab.impl.WaxLabPluginContext;
import com.waxmonster.waxlab.util.WaxLabXmlUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class WaxLabDevice
extends Device {
    private static final int VERSION_1 = 1;
    private static final int VERSION = 1;
    private static final String PROPERTY_VERSION = "version";
    private static final String PROPERTY_PORT_COUNT = "portCount";
    private static final String PROPERTY_PORT_ID_PREFIX = "portId.";
    private static final String PROPERTY_PORT_NAME_PREFIX = "portName.";
    private static final String PROPERTY_PORT_TYPE_PREFIX = "portType.";
    private static final String PROPERTY_WAXLAB_FILE = "waxLabFile";
    private static final Logger logger = Platform.getLogger(WaxLabDevice.class);
    private static final Port[] NO_PORTS = new Port[0];
    private final WaxLabDeviceInfo deviceInfo;
    private final WaxLabImpl waxLab;
    private final LockFactory lockFactory;
    private MidiEngineConfig midiEngineConfig;
    private final WaxLabPanel waxLabPanel;
    private final WaxLabPluginContext pluginContext;
    private final SyncMediatorImpl syncMediator;
    private final WaxLabAudioSupport waxLabAudioSupport;
    private final WaxLabMidiSupport waxLabMidiSupport;
    private WaxLabPortInfo[] waxLabPorts;
    private Set portSet;
    private Set portIds;
    private PortType[] supportedInputPortTypes;
    private PortType[] supportedOutputPortTypes;
    private final List mediaPlayers;

    public WaxLabDevice(DeviceProvider provider, String name, WaxLabDeviceInfo deviceInfo, WaxLabImpl waxLab, WaxLabPanel waxLabPanel, WaxLabPluginContext pluginContext, MidiEngineConfig midiEngineConfig) throws StudioException {
        super(provider, name);
        this.deviceInfo = deviceInfo;
        this.waxLab = waxLab;
        this.waxLabPanel = waxLabPanel;
        this.pluginContext = pluginContext;
        this.lockFactory = waxLab.getLockFactory();
        this.midiEngineConfig = midiEngineConfig;
        this.waxLabPorts = new WaxLabPortInfo[0];
        this.portSet = new HashSet();
        this.portIds = new HashSet();
        this.mediaPlayers = new ArrayList();
        this.supportedInputPortTypes = new PortType[]{AudioInputPortType.MONO, AudioInputPortType.STEREO, MidiInputPortType.TYPE};
        this.supportedOutputPortTypes = new PortType[]{AudioOutputPortType.MONO, AudioOutputPortType.STEREO, MidiOutputPortType.TYPE};
        this.syncMediator = new SyncMediatorImpl(this);
        this.waxLabAudioSupport = new WaxLabAudioSupport(this);
        this.waxLabMidiSupport = new WaxLabMidiSupport(this);
        this.setTooltip(deviceInfo.getTooltip());
        waxLab.setWaxLabDevice(this);
        this.refreshPorts();
        this.refreshPlayerNamePrefix();
    }

    protected final SyncMediator getSyncMediator() {
        return this.syncMediator;
    }

    protected final WaxLabAudioSupport getWaxLabAudioSupport() {
        return this.waxLabAudioSupport;
    }

    protected final WaxLabMidiSupport getWaxLabMidiSupport() {
        return this.waxLabMidiSupport;
    }

    protected final Clock getClock() {
        Studio studio = this.getStudio();
        if (studio == null) {
            return null;
        }
        return studio.getClock();
    }

    protected final ThreadManager getThreadManager() {
        Studio studio = this.getStudio();
        if (studio == null) {
            return null;
        }
        return studio.getThreadManager();
    }

    protected String getTitleOrName() {
        return super.getTitleOrName();
    }

    public Icon getIcon(int iconKind) {
        return this.deviceInfo.getIcon(iconKind);
    }

    public synchronized Component getCustomizer() {
        WaxLabPanel panel = this.waxLabPanel;
        if (panel == null) {
            return null;
        }
        if (panel.getWaxLabDevice() != this) {
            panel.setWaxLabDevice(this);
        }
        return panel.getComponent();
    }

    protected void activate() throws StudioException {
        this.waxLabMidiSupport.activateWaxLabMidiEngines(this);
    }

    protected void deactivate() throws StudioException {
        if (this.waxLab.isActive()) {
            try {
                this.waxLab.stop();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.waxLabMidiSupport.deactivateWaxLabMidiEngines(this);
        this.waxLabAudioSupport.reset();
        this.waxLabMidiSupport.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties() {
        WaxLabPluginContext ctx = this.getPluginContext();
        if (ctx != null) {
            ctx.updateWaxLabDeviceProperties();
        }
        WaxLabDevice waxLabDevice = this;
        synchronized (waxLabDevice) {
            File waxLabFile;
            Properties props = super.getProperties();
            props.setProperty(PROPERTY_VERSION, String.valueOf(1));
            WaxLabPortInfo[] portInfos = this.waxLabPorts;
            int num = portInfos.length;
            props.setProperty(PROPERTY_PORT_COUNT, String.valueOf(num));
            for (int i = 0; i < num; ++i) {
                String suffix = String.valueOf(i);
                WaxLabPortInfo portInfo = portInfos[i];
                String portId = portInfo.getId();
                String portName = portInfo.getName();
                if (portId == null || portName == null) continue;
                props.setProperty(PROPERTY_PORT_ID_PREFIX + suffix, portId);
                props.setProperty(PROPERTY_PORT_NAME_PREFIX + suffix, portName);
                PortType portType = portInfo.getType();
                if (portType == null) continue;
                props.setProperty(PROPERTY_PORT_TYPE_PREFIX + suffix, portType.getName());
            }
            if (this.waxLab != null && (waxLabFile = this.waxLab.getWaxLabFile()) != null) {
                File projectDir;
                String waxLabPath = waxLabFile.getPath();
                Studio studio = this.getStudio();
                if (studio != null && (projectDir = studio.getDirectory()) != null) {
                    String prefix;
                    String absProjectPath = projectDir.getAbsolutePath();
                    String absWaxLabPath = waxLabFile.getAbsolutePath();
                    if (absWaxLabPath.startsWith(prefix = absProjectPath + File.separator)) {
                        waxLabPath = absWaxLabPath.substring(prefix.length());
                    }
                }
                props.setProperty(PROPERTY_WAXLAB_FILE, waxLabPath);
            }
            return props;
        }
    }

    public void setProperties(Properties newProperties) {
        super.setProperties(newProperties);
        boolean legacyProject = true;
        String sVersion = newProperties.getProperty(PROPERTY_VERSION);
        if (sVersion != null) {
            legacyProject = false;
        }
        LinkedList<WaxLabPortInfo> newPorts = new LinkedList<WaxLabPortInfo>();
        String sPortCount = newProperties.getProperty(PROPERTY_PORT_COUNT);
        if (sPortCount != null && sPortCount.length() > 0) {
            int portCount = this.parseIntProperty(PROPERTY_PORT_COUNT, sPortCount);
            for (int i = 0; i < portCount; ++i) {
                String typeName;
                String portName;
                String suffix = String.valueOf(i);
                String portId = newProperties.getProperty(PROPERTY_PORT_ID_PREFIX + suffix);
                if (portId == null || (portName = newProperties.getProperty(PROPERTY_PORT_NAME_PREFIX + suffix)) == null || (typeName = newProperties.getProperty(PROPERTY_PORT_TYPE_PREFIX + suffix)) == null) continue;
                newPorts.add(this.createPortInfo(portId, portName, typeName));
            }
        }
        WaxLabPortInfo[] arr = newPorts.toArray(new WaxLabPortInfo[newPorts.size()]);
        try {
            this.setWaxLabPorts(arr);
        }
        catch (StudioException e) {
            throw new RuntimeException(e);
        }
        String waxLabPath = newProperties.getProperty(PROPERTY_WAXLAB_FILE);
        if (waxLabPath != null && waxLabPath.length() > 0) {
            try {
                if (this.waxLabPanel != null && this.waxLabPanel.getWaxLabDevice() != this) {
                    this.waxLabPanel.setWaxLabDevice(this);
                }
                boolean locate = false;
                this.waxLabPanel.loadWaxLabFile(waxLabPath, locate);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (legacyProject) {
            try {
                this.generateLegacyPorts();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected WaxLabPortInfo createPortInfo(String id, String name, String type) {
        int i;
        PortType portType = null;
        boolean input = false;
        for (i = 0; i < this.supportedInputPortTypes.length; ++i) {
            if (!type.equals(this.supportedInputPortTypes[i].getName())) continue;
            portType = this.supportedInputPortTypes[i];
            input = true;
            break;
        }
        if (portType == null) {
            for (i = 0; i < this.supportedOutputPortTypes.length; ++i) {
                if (!type.equals(this.supportedOutputPortTypes[i].getName())) continue;
                portType = this.supportedOutputPortTypes[i];
                input = false;
                break;
            }
        }
        WaxLabPortInfo portInfo = new WaxLabPortInfo();
        portInfo.setId(id);
        portInfo.setName(name);
        portInfo.setType(portType);
        portInfo.setInput(input);
        return portInfo;
    }

    protected void applyProperty(String key, String value) {
    }

    protected WaxLabAudioInputPort getWaxLabAudioInputPort(Port[] ports) {
        if (ports != null) {
            for (int i = 0; i < ports.length; ++i) {
                Port p = ports[i];
                if (p == null || !(p instanceof WaxLabAudioInputPort)) continue;
                return (WaxLabAudioInputPort)p;
            }
        }
        return null;
    }

    protected WaxLabAudioOutputPort getWaxLabAudioOutputPort(Port[] ports) {
        if (ports != null) {
            for (int i = 0; i < ports.length; ++i) {
                Port p = ports[i];
                if (p == null || !(p instanceof WaxLabAudioOutputPort)) continue;
                return (WaxLabAudioOutputPort)p;
            }
        }
        return null;
    }

    protected WaxLabMidiInputPort getWaxLabMidiInputPort(Port[] ports) {
        if (ports != null) {
            for (int i = 0; i < ports.length; ++i) {
                Port p = ports[i];
                if (p == null || !(p instanceof WaxLabMidiInputPort)) continue;
                return (WaxLabMidiInputPort)p;
            }
        }
        return null;
    }

    protected WaxLabMidiOutputPort getWaxLabMidiOutputPort(Port[] ports) {
        if (ports != null) {
            for (int i = 0; i < ports.length; ++i) {
                Port p = ports[i];
                if (p == null || !(p instanceof WaxLabMidiOutputPort)) continue;
                return (WaxLabMidiOutputPort)p;
            }
        }
        return null;
    }

    protected final WaxLab getWaxLab() {
        return this.waxLab;
    }

    protected final WaxLabImpl getWaxLabImpl() {
        return this.waxLab;
    }

    protected final WaxLabPanel getWaxLabPanel() {
        return this.waxLabPanel;
    }

    protected final WaxLabPluginContext getPluginContext() {
        return this.pluginContext;
    }

    protected final LockFactory getLockFactory() {
        return this.lockFactory;
    }

    public MidiEngineConfig getMidiEngineConfig() {
        return this.midiEngineConfig;
    }

    protected void setMidiEngineConfig(MidiEngineConfig midiEngineConfig) {
        this.midiEngineConfig = midiEngineConfig;
    }

    public PortType[] getSupportedInputPortTypes() {
        int num = this.supportedInputPortTypes.length;
        PortType[] arr = new PortType[num];
        System.arraycopy(this.supportedInputPortTypes, 0, arr, 0, num);
        return arr;
    }

    public PortType[] getSupportedOutputPortTypes() {
        int num = this.supportedOutputPortTypes.length;
        PortType[] arr = new PortType[num];
        System.arraycopy(this.supportedOutputPortTypes, 0, arr, 0, num);
        return arr;
    }

    private void generateLegacyPorts() throws StudioException {
        LinkedList<WaxLabPortInfo> inputPortList = new LinkedList<WaxLabPortInfo>();
        LinkedList<WaxLabPortInfo> outputPortList = new LinkedList<WaxLabPortInfo>();
        WaxLabPortInfo info = new WaxLabPortInfo();
        info.setInput(true);
        info.setType((PortType)MidiInputPortType.TYPE);
        info.setName("MIDI-In");
        info.setId(info.getName());
        inputPortList.add(info);
        info = new WaxLabPortInfo();
        info.setInput(false);
        info.setType((PortType)MidiOutputPortType.TYPE);
        info.setName("MIDI-Out");
        info.setId(info.getName());
        outputPortList.add(info);
        if (this.waxLab != null) {
            for (Line line : this.waxLab.getLines()) {
                WaxLabPortInfo[] linePorts;
                if (line == null || (linePorts = this.generateLegacyPorts(line)) == null) continue;
                int num = linePorts.length;
                for (int k = 0; k < num; ++k) {
                    WaxLabPortInfo info2 = linePorts[k];
                    if (info2.isInput()) {
                        inputPortList.add(info2);
                        continue;
                    }
                    outputPortList.add(info2);
                }
            }
        }
        LinkedList<WaxLabPortInfo> newPortList = new LinkedList<WaxLabPortInfo>();
        newPortList.addAll(inputPortList);
        newPortList.addAll(outputPortList);
        WaxLabPortInfo[] newPorts = newPortList.toArray(new WaxLabPortInfo[newPortList.size()]);
        this.setWaxLabPorts(newPorts);
    }

    private WaxLabPortInfo[] generateLegacyPorts(Line line) {
        String lineName = String.valueOf(line.getName());
        if (line instanceof AudioLine) {
            WaxLabPortInfo[] playbackPorts;
            WaxLabPortInfo[] recordingPorts;
            AudioLine audioLine = (AudioLine)line;
            AudioLineConfig audioConfig = audioLine.getAudioLineConfig();
            int recFrameType = 2;
            int playFrameType = 2;
            WaxLabPortInfo inputPort = new WaxLabPortInfo();
            inputPort.setInput(true);
            inputPort.setName(lineName + "-In");
            inputPort.setId(inputPort.getName());
            int recChannels = WaxLabXmlUtil.getFrameTypeChannelCount(recFrameType);
            if (recChannels == 1) {
                inputPort.setType((PortType)AudioInputPortType.MONO);
                recordingPorts = new WaxLabPortInfo[]{inputPort};
            } else {
                inputPort.setType((PortType)AudioInputPortType.STEREO);
                recordingPorts = new WaxLabPortInfo[]{inputPort, inputPort};
            }
            audioConfig.setRecordingPorts(recordingPorts);
            WaxLabPortInfo outputPort = new WaxLabPortInfo();
            outputPort.setInput(false);
            outputPort.setName(lineName + "-Out");
            outputPort.setId(outputPort.getName());
            int playChannels = WaxLabXmlUtil.getFrameTypeChannelCount(playFrameType);
            if (playChannels == 1) {
                outputPort.setType((PortType)AudioOutputPortType.MONO);
                playbackPorts = new WaxLabPortInfo[]{outputPort};
            } else {
                outputPort.setType((PortType)AudioOutputPortType.STEREO);
                playbackPorts = new WaxLabPortInfo[]{outputPort, outputPort};
            }
            audioConfig.setPlaybackPorts(playbackPorts);
            return new WaxLabPortInfo[]{inputPort, outputPort};
        }
        if (line instanceof TimecodeLine) {
            WaxLabPortInfo[] playbackPorts;
            TimecodeLine tcLine = (TimecodeLine)line;
            TimecodeLineConfig tcConfig = tcLine.getTimecodeLineConfig();
            int playFrameType = 2;
            WaxLabPortInfo inputPort = new WaxLabPortInfo();
            inputPort.setInput(true);
            inputPort.setName(lineName + "-In");
            inputPort.setId(inputPort.getName());
            inputPort.setType((PortType)AudioInputPortType.STEREO);
            WaxLabPortInfo[] recordingPorts = new WaxLabPortInfo[]{inputPort, inputPort};
            tcConfig.setRecordingPorts(recordingPorts);
            WaxLabPortInfo outputPort = new WaxLabPortInfo();
            outputPort.setInput(false);
            outputPort.setName(lineName + "-Out");
            outputPort.setId(outputPort.getName());
            int playChannels = WaxLabXmlUtil.getFrameTypeChannelCount(playFrameType);
            if (playChannels == 1) {
                outputPort.setType((PortType)AudioOutputPortType.MONO);
                playbackPorts = new WaxLabPortInfo[]{outputPort};
            } else {
                outputPort.setType((PortType)AudioOutputPortType.STEREO);
                playbackPorts = new WaxLabPortInfo[]{outputPort, outputPort};
            }
            tcConfig.setPostFaderPorts(playbackPorts);
            return new WaxLabPortInfo[]{inputPort, outputPort};
        }
        if (line instanceof EditorLine) {
            WaxLabPortInfo[] playbackPorts;
            EditorLine editorLine = (EditorLine)line;
            EditorLineConfig editorConfig = editorLine.getEditorLineConfig();
            int playFrameType = 2;
            WaxLabPortInfo outputPort = new WaxLabPortInfo();
            outputPort.setInput(false);
            outputPort.setName(lineName + "-Out");
            outputPort.setId(outputPort.getName());
            int playChannels = WaxLabXmlUtil.getFrameTypeChannelCount(playFrameType);
            if (playChannels == 1) {
                outputPort.setType((PortType)AudioOutputPortType.MONO);
                playbackPorts = new WaxLabPortInfo[]{outputPort};
            } else {
                outputPort.setType((PortType)AudioOutputPortType.STEREO);
                playbackPorts = new WaxLabPortInfo[]{outputPort, outputPort};
            }
            editorConfig.setPlaybackPorts(playbackPorts);
            return new WaxLabPortInfo[]{outputPort};
        }
        return null;
    }

    public WaxLabPortInfo[] getWaxLabPorts() {
        WaxLabPortInfo[] orig = this.waxLabPorts;
        int num = orig.length;
        WaxLabPortInfo[] arr = new WaxLabPortInfo[num];
        System.arraycopy(orig, 0, arr, 0, num);
        return arr;
    }

    public synchronized void setWaxLabPorts(WaxLabPortInfo[] newPorts) throws StudioException {
        String id;
        WaxLabPortInfo info;
        int i;
        int num = newPorts.length;
        for (i = 0; i < num; ++i) {
            info = newPorts[i];
            Port port = info.getPort();
            if (port == null || port.getType() == info.getType()) continue;
            info.setPort(null);
        }
        this.portIds.clear();
        for (i = 0; i < num; ++i) {
            info = newPorts[i];
            id = info.getId();
            if (id == null) continue;
            if (!this.portIds.contains(id)) {
                this.portIds.add(id);
                continue;
            }
            info.setId(null);
        }
        for (i = 0; i < num; ++i) {
            info = newPorts[i];
            id = info.getId();
            if (id != null) continue;
            id = this.uniquePortId(this.portIds);
            info.setId(id);
            this.portIds.add(id);
        }
        this.waxLabPorts = newPorts;
        this.refreshPorts();
    }

    protected String uniquePortId(Set set) {
        for (long nextId = 1L; nextId < Long.MAX_VALUE; ++nextId) {
            String id = Long.toString(nextId);
            if (set.contains(id)) continue;
            return id;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refreshPorts() {
        Port port;
        WaxLabPortInfo info;
        Studio studio = this.getStudio();
        int newCount = this.waxLabPorts.length;
        for (int i = 0; i < newCount; ++i) {
            info = this.waxLabPorts[i];
            PortType type = info.getType();
            port = info.getPort();
            if (port != null && port.getDevice() == this && port.getType() == type) {
                this.portSet.remove(port);
                String name = info.getName();
                if (name == null || name.equals(port.getName())) continue;
                try {
                    if (this.renamePort(port, name)) continue;
                    logger.warning("Failed to rename port: " + port + " => " + name);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                continue;
            }
            port = this.createPort(info);
            info.setPort(port);
        }
        if (!this.portSet.isEmpty()) {
            Iterator i = this.portSet.iterator();
            while (i.hasNext()) {
                port = (Port)i.next();
                try {
                    if (studio != null) {
                        studio.disconnect(port);
                    }
                    if (this.removePort(port)) continue;
                    logger.warning("Failed to remove port: " + port);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                finally {
                    i.remove();
                }
            }
        }
        int nextPortIndex = 0;
        for (int i = 0; i < newCount; ++i) {
            info = this.waxLabPorts[i];
            port = info.getPort();
            if (port == null) continue;
            this.portSet.add(port);
            try {
                if (port.getDevice() == this) {
                    int prevIndex = this.getPortIndex(port);
                    if (prevIndex == nextPortIndex) {
                        ++nextPortIndex;
                        continue;
                    }
                    this.removePort(port);
                }
                this.insertPortAt(port, nextPortIndex);
                ++nextPortIndex;
                continue;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (studio != null) {
            try {
                studio.resolveInvalidConnections((Device)this);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected Port createPort(WaxLabPortInfo info) {
        PortType type = info.getType();
        if (type == null) {
            return null;
        }
        String name = info.getName();
        if (info.isInput()) {
            if (type instanceof AudioInputPortType) {
                AudioInputPortType audioInputPortType = (AudioInputPortType)type;
                return new WaxLabAudioInputPort(name, audioInputPortType, this.waxLabAudioSupport);
            }
            if (type instanceof MidiInputPortType) {
                MidiInputPortType midiInputPortType = (MidiInputPortType)type;
                return new WaxLabMidiInputPort(name, midiInputPortType, this.waxLabMidiSupport);
            }
        } else {
            if (type instanceof AudioOutputPortType) {
                AudioOutputPortType audioOutputPortType = (AudioOutputPortType)type;
                return new WaxLabAudioOutputPort(name, audioOutputPortType, this.waxLabAudioSupport);
            }
            if (type instanceof MidiOutputPortType) {
                MidiOutputPortType midiOutputPortType = (MidiOutputPortType)type;
                return new WaxLabMidiOutputPort(name, midiOutputPortType, this.waxLabMidiSupport);
            }
        }
        return null;
    }

    protected void studioChanged(Studio studio) {
        super.studioChanged(studio);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("studioChanged: " + studio);
        }
        this.refreshSyncMediator(studio);
        this.refreshLineMediaPlayers(studio);
    }

    protected void refreshSyncMediator(Studio studio) {
        ThreadManager threadManager;
        if (studio == null) {
            return;
        }
        this.syncMediator.setStudio(studio);
        Clock clock = studio.getClock();
        if (clock != null) {
            this.syncMediator.setClock(clock);
            this.waxLabPanel.setClock(clock);
            this.waxLabPanel.setMediator(this.syncMediator);
        }
        if ((threadManager = studio.getThreadManager()) != null) {
            this.syncMediator.setThreadManager(threadManager);
        }
    }

    public synchronized void setTitle(String title) {
        super.setTitle(title);
        this.handleTitleChanged();
    }

    protected void handleTitleChanged() {
        this.refreshWaxLabName();
        this.refreshPlayerNamePrefix();
    }

    protected void refreshWaxLabName() {
        WaxLabImpl waxLab = this.waxLab;
        if (waxLab == null) {
            return;
        }
        String titleOrName = this.getTitleOrName();
        waxLab.setName(titleOrName);
    }

    protected void refreshPlayerNamePrefix() {
        WaxLabImpl waxLab = this.waxLab;
        if (waxLab == null) {
            return;
        }
        String titleOrName = this.getTitleOrName();
        String playerNamePrefix = String.valueOf(titleOrName) + "-";
        waxLab.setPlayerNamePrefix(playerNamePrefix);
    }

    protected void refreshMediaPlayers() {
        this.refreshLineMediaPlayers(this.getStudio());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshLineMediaPlayers(Studio studio) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("refreshMediaPlayers: " + (Object)((Object)this) + ", studio=" + studio);
        }
        try {
            List list = this.mediaPlayers;
            synchronized (list) {
                MediaPlayer[] newPlayers = null;
                if (studio != null) {
                    newPlayers = this.waxLab.getLineMediaPlayers();
                }
                MediaManagerPlugin mediaManagerPlugin = MediaManagerPlugin.getInstance();
                WaxLabDevice owner = this;
                int newCount = newPlayers == null ? 0 : newPlayers.length;
                HashSet oldPlayers = new HashSet();
                oldPlayers.addAll(this.mediaPlayers);
                for (int i = 0; i < newCount; ++i) {
                    MediaPlayer mp = newPlayers[i];
                    if (mp == null || oldPlayers.remove(mp)) continue;
                    this.mediaPlayers.add(mp);
                    mediaManagerPlugin.registerMediaPlayer(mp, (Object)owner);
                }
                if (!oldPlayers.isEmpty()) {
                    for (MediaPlayer mp : oldPlayers) {
                        this.mediaPlayers.remove(mp);
                        mediaManagerPlugin.unregisterMediaPlayer(mp, (Object)owner);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshControls() {
        Line[] lines = this.waxLab.getLines();
        ArrayList<Control> controlList = new ArrayList<Control>();
        WaxLabDevice waxLabDevice = this;
        synchronized (waxLabDevice) {
            int i;
            int lineCount = lines == null ? 0 : lines.length;
            for (int i2 = 0; i2 < lineCount; ++i2) {
                Control[] lineControls;
                Line line = lines[i2];
                if (line == null || (lineControls = line.getLineControls()) == null) continue;
                int num = lineControls.length;
                for (int k = 0; k < num; ++k) {
                    Control control = lineControls[k];
                    if (control == null) continue;
                    controlList.add(control);
                }
            }
            int controlCount = controlList.size();
            int oldCount = this.getControlCount();
            for (i = 0; i < controlCount; ++i) {
                Control control = (Control)controlList.get(i);
                if (i < oldCount) {
                    if (this.getControlAt(i) == control) continue;
                    this.removeControlAt(i);
                }
                this.insertControlAt(control, i);
            }
            if (oldCount > controlCount) {
                for (i = controlCount; i < oldCount; ++i) {
                    this.removeControlAt(controlCount);
                }
            }
        }
    }

    protected class LineProxy {
        private final Line line;
        private Port[] ports;

        public LineProxy(Line line) {
            this.line = line;
            this.ports = NO_PORTS;
        }

        public final Line getLine() {
            return this.line;
        }

        public Port[] getPorts() {
            return this.ports;
        }

        public void setPorts(Port[] ports) {
            this.ports = ports;
        }
    }
}

