/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Data;
import com.spacekiller.util.FileResource;
import com.spacekiller.util.ListenerList;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Resource;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.TimeUnit;
import com.spacekiller.util.heap.Heap;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.LockSupport;
import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.media.MediaPlayer;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.SeekableStream;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.wave.WaveAudioFile;
import com.spacekiller.util.midi.file.FileTrackModel;
import com.spacekiller.util.midi.file.TrackModelFile;
import com.spacekiller.util.midi.file.TrackModelFileImpl;
import com.spacekiller.util.midi.model.StateModel;
import com.spacekiller.util.midi.model.TrackModel;
import com.spacekiller.util.midi.tree.TreeStateModel;
import com.spacekiller.util.sound.AudioFile;
import com.spacekiller.util.sound.ByteArraySampleBuffer;
import com.spacekiller.util.sound.DefaultSampleCursor;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleModel;
import com.spacekiller.util.sound.SampleType;
import com.spacekiller.util.sound.SoundSystem;
import com.spacekiller.util.sound.SoundUtil;
import com.spacekiller.util.thread.DefaultThreadPool;
import com.spacekiller.util.thread.ThreadPool;
import com.spacekiller.util.time.UnitsPerSecond;
import com.waxmonster.editor.InterpolatorRegistry;
import com.waxmonster.editor.WaxEditorFile;
import com.waxmonster.editor.WaxEditorModel;
import com.waxmonster.editor.impl.DefaultWaxEditorFile;
import com.waxmonster.editor.impl.InterpolatedFaderModel;
import com.waxmonster.editor.impl.InterpolatedTimecodeModel;
import com.waxmonster.editor.impl.WaxEditorUtil;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.midi.common.MidiTriggerEvent;
import com.waxmonster.midi.common.MidiTriggerEventTarget;
import com.waxmonster.model.ChunkModel;
import com.waxmonster.model.FaderModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.MidiModel;
import com.waxmonster.model.MidiTrack;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.impl.CachedAudioModel;
import com.waxmonster.model.impl.CachedFaderModel;
import com.waxmonster.model.impl.CachedMidiModel;
import com.waxmonster.model.impl.CachedTimecodeModel;
import com.waxmonster.model.impl.DefaultFaderFile;
import com.waxmonster.model.impl.DefaultMidiTrack;
import com.waxmonster.model.impl.DefaultTimecodeFile;
import com.waxmonster.model.impl.FaderFile;
import com.waxmonster.model.impl.MidiModelUtil;
import com.waxmonster.model.impl.SeekableAudioModel;
import com.waxmonster.model.impl.TimecodeFile;
import com.waxmonster.model.impl.old.MergedFaderModelOLD;
import com.waxmonster.model.impl.old.MergedTimecodeModelOLD;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import com.waxmonster.timecode.TimecodeDecoder;
import com.waxmonster.timecode.TimecodeFormat;
import com.waxmonster.timecode.TimecodeManager;
import com.waxmonster.waxlab.AudioLine;
import com.waxmonster.waxlab.AudioLineConfig;
import com.waxmonster.waxlab.EditorLine;
import com.waxmonster.waxlab.EditorLineConfig;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.LineConfig;
import com.waxmonster.waxlab.LineFeature;
import com.waxmonster.waxlab.LineListener;
import com.waxmonster.waxlab.LineMidiMapping;
import com.waxmonster.waxlab.LineMidiTrigger;
import com.waxmonster.waxlab.LineWidget;
import com.waxmonster.waxlab.MidiLine;
import com.waxmonster.waxlab.MidiLineConfig;
import com.waxmonster.waxlab.ScratchLine;
import com.waxmonster.waxlab.TimecodeLine;
import com.waxmonster.waxlab.TimecodeLineConfig;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.WaxLabConst;
import com.waxmonster.waxlab.WaxLabListener;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.WaxLabPreferences;
import com.waxmonster.waxlab.impl.AbstractLine;
import com.waxmonster.waxlab.impl.AbstractLineFeature;
import com.waxmonster.waxlab.impl.AbstractScratchModeControl;
import com.waxmonster.waxlab.impl.DefaultAudioLine;
import com.waxmonster.waxlab.impl.DefaultEditorLine;
import com.waxmonster.waxlab.impl.DefaultMidiLine;
import com.waxmonster.waxlab.impl.DefaultTimecodeLine;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.SyncMediatorImpl;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import com.waxmonster.waxlab.util.InterruptedIOException;
import com.waxmonster.waxlab.util.TempWaveAudioFile;
import com.waxmonster.waxlab.util.WaxLabXmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WaxLabImpl
implements WaxLab,
WaxLabConst {
    public static final String TEMP_FILE_NAME_SEPARATOR = "_$";
    private static final Logger logger = Logger.getLogger(WaxLabImpl.class.getName());
    private String name = "WaxLab";
    private List lines;
    private Map lineFeatureMap;
    private WaxLabDevice device;
    private ListenerList<WaxLabListener> waxLabListeners;
    private WaxLabPreferences waxLabPreferences;
    private LockSupport lockSupport;
    private LockFactory lockFactory;
    private SoundSystem soundSystem;
    private TimecodeManager timecodeManager;
    private InterpolatorRegistry interpolatorRegistry;
    private MediaLibrary mediaLibrary;
    private File waxLabFile;
    private File contentDirectory;
    private Heap mutationHeap;
    private int mutationBlockSize;
    private boolean deleteTempTimecodeFiles = true;
    private boolean active;
    private boolean dirty;
    private boolean autoStarted;
    private boolean autoStopStudio;
    private DateFormat timestampFormat;
    private String clockType;
    private WaxLabPortInfo clockAudioPort;
    private WaxLabPortInfo midiInputPort;
    private MidiAction[] midiActions;
    private Map midiActionMap;
    private MidiMapping[] midiMappings;
    private WaxLabPortInfo midiOutputPort;
    private String[] midiEvents;
    private MidiTrigger[] midiTriggers;
    private Properties properties;
    private DefaultThreadPool cacheThreadPool;
    private DefaultThreadPool writerThreadPool;
    private DefaultThreadPool loaderThreadPool;
    private DefaultThreadPool workerThreadPool;
    private String playerNamePrefix;
    private byte[] copyByteArray;
    private float[] copyFloatArray;
    private double[] copyDoubleArray;
    private final LineHandler lineHandler = new LineHandler();
    private final RefreshFeatures refreshFeatures = new RefreshFeatures();
    private final RefreshControls refreshControls = new RefreshControls();
    private final RefreshMidiLightings refreshMidiLightings = new RefreshMidiLightings();
    private final MediateAsync mediateAsync = new MediateAsync();
    private boolean mediatePending;
    private boolean autoMediate = true;
    private final MidiTriggerEventTarget triggerTarget;
    private MidiProcessor targetMidiProcessor;
    protected MidiTriggerEvent waxLabStartedEvent;
    protected MidiTriggerEvent waxLabStoppedEvent;

    public WaxLabImpl(SoundSystem soundSystem, TimecodeManager timecodeManager, InterpolatorRegistry interpolatorRegistry, MediaLibrary mediaLibrary, LockSupport lockSupport, LockFactory lockFactory, Heap mutationHeap, int mutationBlockSize) throws InterruptedException {
        this.timestampFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
        this.lines = new ArrayList();
        this.lineFeatureMap = new HashMap();
        this.waxLabListeners = new ListenerList(WaxLabListener.class);
        this.waxLabPreferences = new WaxLabPreferences();
        this.soundSystem = soundSystem;
        this.timecodeManager = timecodeManager;
        this.interpolatorRegistry = interpolatorRegistry;
        this.mediaLibrary = mediaLibrary;
        this.lockSupport = lockSupport;
        this.lockFactory = lockFactory;
        this.mutationHeap = mutationHeap;
        this.mutationBlockSize = mutationBlockSize;
        this.cacheThreadPool = this.createDefaultThreadPool("WaxLabCache-", this.waxLabPreferences.getModelCacheThreadPriority());
        this.writerThreadPool = this.createDefaultThreadPool("WaxLabWriter-", this.waxLabPreferences.getModelWriterThreadPriority());
        this.loaderThreadPool = this.createDefaultThreadPool("WaxLabLoader-", this.waxLabPreferences.getModelLoaderThreadPriority());
        this.workerThreadPool = this.createDefaultThreadPool("WaxLabWorker-", this.waxLabPreferences.getWorkerThreadPriority());
        this.copyByteArray = new byte[262144];
        this.copyFloatArray = new float[32768];
        this.copyDoubleArray = new double[32768];
        this.active = false;
        this.dirty = false;
        this.midiActionMap = new HashMap();
        this.midiMappings = new MidiMapping[0];
        this.properties = new Properties();
        this.triggerTarget = new MidiTriggerEventTarget();
        this.initMidiEvents();
    }

    public synchronized int getLineCount() {
        return this.lines.size();
    }

    public synchronized Line getLineAt(int index) {
        return (Line)this.lines.get(index);
    }

    public synchronized Line[] getLines() {
        return this.lines.toArray(new Line[this.lines.size()]);
    }

    public synchronized int getLineIndex(Line line) {
        return this.lines.indexOf(line);
    }

    public synchronized void addLine(Line line) {
        this.insertLineAt(line, this.lines.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void insertLineAt(Line lineObj, int index) {
        AbstractLine line;
        if (lineObj == null) {
            return;
        }
        AbstractLine abstractLine = line = (AbstractLine)lineObj;
        synchronized (abstractLine) {
            WaxLabImpl currImpl = line.getWaxLabImpl();
            if (currImpl != null) {
                throw new IllegalStateException("Line is already used by another WaxLab: " + currImpl);
            }
            line.setWaxLabImpl(this);
        }
        boolean done = false;
        try {
            this.lines.add(index, line);
            this.setDirtyFlag();
            if (this.device != null) {
                this.device.refreshMediaPlayers();
            }
            line.registerLineListener(this.lineHandler);
            boolean changed = this.refreshFeatures(line);
            for (WaxLabListener l : (WaxLabListener[])this.waxLabListeners.array()) {
                l.lineInserted((Line)line, index);
            }
            if (changed) {
                this.handleFeaturesChanged();
            }
            done = true;
        }
        finally {
            if (!done) {
                AbstractLine abstractLine2 = line;
                synchronized (abstractLine2) {
                    line.setWaxLabImpl(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeLineAt(int index) {
        SyncMediatorImpl syncMediator;
        AbstractLine line = (AbstractLine)this.lines.remove(index);
        if (line == null) {
            return;
        }
        this.setDirtyFlag();
        AbstractLine abstractLine = line;
        synchronized (abstractLine) {
            if (line.getWaxLabImpl() == this) {
                line.setWaxLabImpl(null);
            }
        }
        if (this.device != null) {
            this.device.refreshMediaPlayers();
        }
        line.unregisterLineListener(this.lineHandler);
        Set featureSet = (Set)this.lineFeatureMap.remove(line);
        if (featureSet != null && (syncMediator = this.getSyncMediatorImpl()) != null) {
            for (AbstractLineFeature feature : featureSet) {
                syncMediator.removeFeature(feature);
            }
        }
        for (WaxLabListener l : (WaxLabListener[])this.waxLabListeners.array()) {
            l.lineRemoved((Line)line, index);
        }
    }

    public synchronized void removeLine(Line lineObj) {
        AbstractLine line = (AbstractLine)lineObj;
        int index = this.getLineIndex(line);
        if (index >= 0) {
            this.removeLineAt(index);
        }
    }

    public synchronized void moveLine(Line lineObj, int newIndex) {
        AbstractLine line = (AbstractLine)lineObj;
        if (newIndex < 0 || newIndex >= this.lines.size()) {
            return;
        }
        int index = this.getLineIndex(line);
        if (index < 0) {
            return;
        }
        if (index == newIndex) {
            return;
        }
        this.lines.remove(index);
        this.lines.add(newIndex, line);
        this.setDirtyFlag();
        for (WaxLabListener l : (WaxLabListener[])this.waxLabListeners.array()) {
            l.lineMoved((Line)line, newIndex);
        }
    }

    public synchronized void applyLineConfig(Line line, LineConfig config) throws IOException {
        if (line == null) {
            throw new IllegalArgumentException("Invalid line: " + line);
        }
        if (config == null) {
            throw new IllegalArgumentException("Invalid line config: " + config);
        }
        if (line instanceof AudioLine) {
            AudioLine audioLine = (AudioLine)line;
            if (!(config instanceof AudioLineConfig)) {
                throw new IllegalArgumentException("Invalid audio line config: " + config);
            }
            AudioLineConfig audioLineConfig = (AudioLineConfig)config;
            audioLine.setAudioLineConfig(audioLineConfig);
            audioLine.setName(audioLineConfig.getName());
            this.fireLineChanged(line);
            return;
        }
        if (line instanceof MidiLine) {
            MidiLine midiLine = (MidiLine)line;
            if (!(config instanceof MidiLineConfig)) {
                throw new IllegalArgumentException("Invalid midi line config: " + config);
            }
            MidiLineConfig midiLineConfig = (MidiLineConfig)config;
            midiLine.setMidiLineConfig(midiLineConfig);
            midiLine.setName(midiLineConfig.getName());
            this.fireLineChanged(line);
            return;
        }
        if (line instanceof TimecodeLine) {
            TimecodeLine tcLine = (TimecodeLine)line;
            if (!(config instanceof TimecodeLineConfig)) {
                throw new IllegalArgumentException("Invalid timecode line config: " + config);
            }
            TimecodeLineConfig tcLineConfig = (TimecodeLineConfig)config;
            tcLine.setTimecodeLineConfig(tcLineConfig);
            tcLine.setName(tcLineConfig.getName());
            this.fireLineChanged(line);
            return;
        }
        if (line instanceof EditorLine) {
            EditorLine editorLine = (EditorLine)line;
            if (!(config instanceof EditorLineConfig)) {
                throw new IllegalArgumentException("Invalid editor line config: " + config);
            }
            EditorLineConfig editorLineConfig = (EditorLineConfig)config;
            editorLine.setEditorLineConfig(editorLineConfig);
            editorLine.setName(editorLineConfig.getName());
            this.fireLineChanged(line);
            return;
        }
        throw new IllegalArgumentException("Unsupported line type: " + line);
    }

    protected synchronized void fireLineChanged(Line line) {
        for (WaxLabListener l : (WaxLabListener[])this.waxLabListeners.array()) {
            l.lineChanged(line);
        }
    }

    public void mediate() {
        boolean done = this.setMediatePending(true);
        if (done) {
            try {
                this.workerThreadPool.start((Runnable)this.mediateAsync);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected void mediateImpl() {
        if (!this.isMediatePending()) {
            return;
        }
        this.setMediatePending(false);
        WaxLabDevice dev = this.getWaxLabDevice();
        if (dev == null) {
            return;
        }
        SyncMediator mediator = dev.getSyncMediator();
        if (mediator == null) {
            return;
        }
        mediator.mediate();
    }

    public boolean isAutoMediate() {
        return this.autoMediate;
    }

    public void setAutoMediate(boolean autoMediate) {
        this.autoMediate = autoMediate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMediatePending() {
        MediateAsync mediateAsync = this.mediateAsync;
        synchronized (mediateAsync) {
            return this.mediatePending;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setMediatePending(boolean mediatePending) {
        MediateAsync mediateAsync = this.mediateAsync;
        synchronized (mediateAsync) {
            if (this.mediatePending == mediatePending) {
                return false;
            }
            this.mediatePending = mediatePending;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("setMediatePending: " + mediatePending);
            }
            return true;
        }
    }

    protected void handleFeaturesChanged() {
        if (this.isAutoMediate()) {
            this.mediate();
        } else {
            this.setMediatePending(true);
        }
    }

    protected void handleFeaturesSynced() {
    }

    public synchronized void registerWaxLabListener(WaxLabListener l) {
        if (l == null) {
            return;
        }
        this.waxLabListeners.add((Object)l);
    }

    public synchronized void unregisterWaxLabListener(WaxLabListener l) {
        if (l == null) {
            return;
        }
        this.waxLabListeners.remove((Object)l);
    }

    public AudioLine createAudioLine() {
        boolean fair = this.waxLabPreferences.isLineLockFair();
        ReadWriteLock lock = this.lockFactory.createReadWriteLock(fair);
        return new DefaultAudioLine(lock);
    }

    public MidiLine createMidiLine() {
        boolean fair = this.waxLabPreferences.isLineLockFair();
        ReadWriteLock lock = this.lockFactory.createReadWriteLock(fair);
        return new DefaultMidiLine(lock);
    }

    public TimecodeLine createTimecodeLine(boolean leftDeck) {
        boolean fair = this.waxLabPreferences.isLineLockFair();
        ReadWriteLock lock = this.lockFactory.createReadWriteLock(fair);
        DefaultTimecodeLine tcLine = new DefaultTimecodeLine(lock);
        tcLine.setPlayerNamePrefix(this.playerNamePrefix);
        TimecodeLineConfig tcLineConfig = tcLine.getTimecodeLineConfig();
        if (tcLineConfig != null) {
            double scratchVolumeFactor = this.waxLabPreferences.getScratchDefaultVolume();
            if (!Double.isNaN(scratchVolumeFactor)) {
                tcLineConfig.setPreFaderVolume(scratchVolumeFactor);
                tcLineConfig.setPostFaderVolume(scratchVolumeFactor);
            }
            tcLineConfig.setPitchBPM(133.33333333333334);
            tcLineConfig.setAudioFaderConfigs(tcLineConfig.createDefaultFaderConfigs(leftDeck));
        }
        return tcLine;
    }

    public EditorLine createEditorLine() {
        boolean fair = this.waxLabPreferences.isLineLockFair();
        ReadWriteLock lock = this.lockFactory.createReadWriteLock(fair);
        DefaultEditorLine editorLine = new DefaultEditorLine(lock);
        editorLine.setPlayerNamePrefix(this.playerNamePrefix);
        double scratchVolumeFactor = this.waxLabPreferences.getScratchDefaultVolume();
        if (!Double.isNaN(scratchVolumeFactor)) {
            editorLine.getEditorLineConfig().setVolumeFactor(scratchVolumeFactor);
        }
        return editorLine;
    }

    public TimecodeFormat getTimecodeFormat(String timecodeFormatName) throws IOException {
        if (timecodeFormatName != null) {
            TimecodeManager manager = this.getTimecodeManager();
            TimecodeFormat[] formats = manager.getTimecodeFormats();
            for (int i = 0; i < formats.length; ++i) {
                if (!timecodeFormatName.equals(formats[i].getName())) continue;
                return formats[i];
            }
        }
        throw new IOException("Timecode format not found: " + timecodeFormatName);
    }

    public boolean isAudioFile(File file) throws IOException {
        try {
            AudioFileFormat fileFormat = this.getSoundSystem().getAudioFileFormat(file);
            return fileFormat != null;
        }
        catch (UnsupportedAudioFileException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("UnsupportedAudioFile: " + file + " (" + e + ")");
            }
            return false;
        }
    }

    public boolean isMidiFile(File file) throws IOException {
        return MidiModelUtil.isMidiFile((File)file);
    }

    public boolean isTimecodeFile(File file) throws IOException {
        return DefaultTimecodeFile.isTimecodeFile((File)file);
    }

    public boolean isWaxEditorFile(File file) throws IOException {
        return DefaultWaxEditorFile.isWaxEditorFile((File)file);
    }

    protected File createNewContentFile(String fileNamePrefix, String fileNameSuffix) throws IOException {
        String fileNameAppendix;
        File contentDir = this.makeContentDirectory();
        File file = null;
        int max = 1000;
        for (int i = 1; i < max; ++i) {
            fileNameAppendix = String.valueOf(i);
            while (fileNameAppendix.length() < 3) {
                fileNameAppendix = "0" + fileNameAppendix;
            }
            fileNameAppendix = "_" + fileNameAppendix;
            file = new File(contentDir, fileNamePrefix + fileNameAppendix + fileNameSuffix);
            if (file.exists()) continue;
            return file;
        }
        fileNameAppendix = "_" + this.timestampFormat.format(new Date());
        file = new File(contentDir, fileNamePrefix + fileNameAppendix + fileNameSuffix);
        if (file.exists()) {
            throw new IOException("File already exists: " + file);
        }
        return file;
    }

    public AudioFile createNewAudioFile(String fileNamePrefix, AudioFormat format) throws IOException {
        String fileNameSuffix = ".wav";
        File file = this.createNewContentFile(fileNamePrefix, fileNameSuffix);
        return this.createAudioFile(file, format);
    }

    public AudioFile createAudioFile(File file, AudioFormat format) throws IOException {
        return new WaveAudioFile(file, format);
    }

    protected String parseModelName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int x = fileName.indexOf(46);
        if (x >= 0) {
            fileName = fileName.substring(0, x);
        }
        if ((x = fileName.lastIndexOf(TEMP_FILE_NAME_SEPARATOR)) >= 0) {
            fileName = fileName.substring(0, x);
        }
        if ((x = fileName.lastIndexOf(95)) >= 0) {
            fileName = fileName.substring(x + 1);
        }
        if (fileName.length() > 0) {
            return fileName;
        }
        return null;
    }

    protected DefaultThreadPool createDefaultThreadPool(String namePrefix, int priority) throws InterruptedException {
        ThreadManager manager = Platform.getInstance().getThreadManager();
        ClassLoader contextLoader = this.getClass().getClassLoader();
        boolean daemon = true;
        int minThreadCount = 1;
        int maxThreadCount = Integer.MAX_VALUE;
        int idleTimeout = 60000;
        DefaultThreadPool pool = new DefaultThreadPool(manager, namePrefix, priority, daemon, contextLoader, minThreadCount, maxThreadCount, (long)idleTimeout);
        return pool;
    }

    public SeekableAudioModel createSeekableAudioModel(Resource resource, MediaEntry mediaEntry, AudioFormat targetFormat) throws IOException, UnsupportedAudioFileException {
        MediaLibrary lib = this.mediaLibrary;
        if (lib == null) {
            return null;
        }
        String modelName = null;
        double duration = -1.0;
        if (mediaEntry != null) {
            modelName = mediaEntry.getTitle();
            duration = mediaEntry.getDuration();
        }
        if (duration < 0.0 || Double.isNaN(duration)) {
            logger.warning("FIXME Cannot create seekable audio stream because the duration is unknown: resource=" + resource + ", entry=" + mediaEntry);
            return null;
        }
        AudioInputStream ais = null;
        boolean success = false;
        try {
            boolean seekable = true;
            ais = targetFormat == null ? lib.createAudioInputStream(resource, seekable) : lib.createAudioInputStream(resource, targetFormat, seekable);
            SeekableStream sk = null;
            if (ais != null && ais instanceof SeekableStream) {
                sk = (SeekableStream)ais;
            }
            if (sk == null) {
                throw new IOException("Invalid seekable audio stream: " + ais);
            }
            AudioFormat audioFormat = ais.getFormat();
            int channels = audioFormat.getChannels();
            float frameRate = audioFormat.getSampleRate();
            int bufferSamples = channels * (int)frameRate;
            SampleType sampleType = SoundUtil.guessSampleType((AudioFormat)audioFormat);
            if (sampleType == null) {
                throw new IOException("Unsupported audio format: " + audioFormat);
            }
            ByteArraySampleBuffer rsb = sampleType.createByteArraySampleBuffer(channels, frameRate, bufferSamples);
            long totalSamples = (long)channels * (long)(duration * (double)frameRate);
            SeekableAudioModel audioModel = new SeekableAudioModel(rsb, sk, totalSamples);
            audioModel.setResource(resource);
            audioModel.setName(modelName);
            success = true;
            SeekableAudioModel seekableAudioModel = audioModel;
            return seekableAudioModel;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
        finally {
            if (!success && ais != null) {
                ais.close();
            }
        }
    }

    public CachedAudioModel createCachedAudioModel(AudioFile audioFile) throws IOException {
        boolean flushAsync = true;
        String fileName = audioFile.getPath();
        if (fileName != null) {
            fileName = new File(fileName).getName();
        }
        String modelName = this.parseModelName(fileName);
        AudioFormat format = audioFile.getAudioFormat();
        int channels = format.getChannels();
        float frameRate = format.getFrameRate();
        int partSize = channels * (int)((double)this.waxLabPreferences.getAudioCachePartMillis() * (double)frameRate / 1000.0);
        int maxLoadedParts = this.waxLabPreferences.getAudioCacheMaxParts();
        boolean fair = this.waxLabPreferences.isAudioCacheFair();
        SampleType sampleType = SoundUtil.guessSampleType((AudioFormat)format);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createCachedAudioModel: audioFile=" + audioFile + ", format=" + format + ", sampleType=" + sampleType);
        }
        if (sampleType == null) {
            throw new IOException("Unsupported audio format: " + format);
        }
        try {
            CachedAudioModel model = new CachedAudioModel(channels, frameRate, partSize, maxLoadedParts, this.lockFactory, fair, flushAsync, (ThreadPool)this.cacheThreadPool, audioFile, sampleType);
            model.setName(modelName);
            File file = audioFile.getFile();
            if (file != null) {
                model.setResource((Resource)new FileResource(file));
            }
            return model;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e);
        }
    }

    public CachedAudioModel createCachedAudioModel(Resource resource, String[] trackIds, boolean readOnly) throws IOException {
        File file = null;
        try {
            file = resource.getFile();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (file != null) {
            return this.createCachedAudioModel(file, trackIds, readOnly);
        }
        throw new IOException("Unsupported audio resource: " + resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public CachedAudioModel createCachedAudioModel(File file, String[] trackIds, boolean readOnly) throws IOException {
        SoundSystem soundSystem = this.getSoundSystem();
        try {
            AudioFileFormat.Type type;
            AudioFileFormat aff = soundSystem.getAudioFileFormat(file);
            AudioFormat format = aff.getFormat();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("createCachedAudioModel: file=" + file + ", readOnly=" + readOnly + ", format=" + format);
            }
            if ((type = aff.getType()) == AudioFileFormat.Type.WAVE) {
                boolean waveFormatSupported = false;
                int bits = format.getSampleSizeInBits();
                switch (bits) {
                    case 16: {
                        if (!SoundUtil.PCM_SIGNED.equals(format.getEncoding())) break;
                        waveFormatSupported = true;
                        break;
                    }
                    case 24: {
                        if (!SoundUtil.PCM_SIGNED.equals(format.getEncoding())) break;
                        waveFormatSupported = true;
                        break;
                    }
                    case 32: {
                        if (!SoundUtil.PCM_FLOAT.equals(format.getEncoding())) break;
                        waveFormatSupported = true;
                        break;
                    }
                }
                if (waveFormatSupported) {
                    String mode = readOnly ? "r" : "rw";
                    WaveAudioFile audioFile = new WaveAudioFile(file, mode);
                    return this.createCachedAudioModel((AudioFile)audioFile);
                }
            }
            if (!readOnly) {
                throw new IOException("Audio file not supported for write mode: " + file);
            }
            AudioInputStream ais = soundSystem.getAudioInputStream(file);
            try {
                CachedAudioModel cachedAudioModel;
                AudioFormat.Encoding encoding;
                int sampleSizeInBits = format.getSampleSizeInBits();
                if (sampleSizeInBits < 16) {
                    sampleSizeInBits = 16;
                }
                if (sampleSizeInBits > 16) {
                    encoding = SoundUtil.PCM_FLOAT;
                    sampleSizeInBits = 32;
                } else {
                    encoding = SoundUtil.PCM_SIGNED;
                }
                float sampleRate = format.getSampleRate();
                int channels = format.getChannels();
                int frameSize = (sampleSizeInBits + 7) / 8 * channels;
                float frameRate = sampleRate;
                boolean bigEndian = false;
                AudioFormat targetFormat = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, bigEndian);
                AudioInputStream converted = soundSystem.getAudioInputStream(targetFormat, ais);
                try {
                    boolean success = false;
                    String prefix = "temp";
                    String suffix = ".wav";
                    File tempFile = Platform.getInstance().createTempFile(prefix, suffix);
                    TempWaveAudioFile audioFile = new TempWaveAudioFile(tempFile, targetFormat, file);
                    try {
                        int n;
                        int bufSize = this.waxLabPreferences.getAudioConverterBufferSize() / frameSize * frameSize;
                        if (bufSize < frameSize) {
                            bufSize = frameSize;
                        }
                        byte[] buf = new byte[bufSize];
                        long framePos = 0L;
                        while ((n = converted.read(buf, 0, bufSize)) >= 0) {
                            audioFile.write(framePos, buf, 0, n);
                            framePos += (long)(n / frameSize);
                        }
                        audioFile.flush();
                        success = true;
                    }
                    finally {
                        if (!success) {
                            audioFile.close();
                            tempFile.delete();
                        }
                    }
                    cachedAudioModel = this.createCachedAudioModel((AudioFile)audioFile);
                }
                catch (Throwable throwable) {
                    converted.close();
                    throw throwable;
                }
                converted.close();
                return cachedAudioModel;
            }
            finally {
                ais.close();
            }
        }
        catch (UnsupportedAudioFileException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IOException("Unsupported audio file: " + file + " (" + e + ")");
        }
    }

    public CachedTimecodeModel createCachedTimecodeModel(Resource resource, String[] trackIds, boolean readOnly) throws IOException {
        File file = null;
        try {
            file = resource.getFile();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (file != null) {
            return this.createCachedTimecodeModel(file, trackIds, readOnly);
        }
        throw new IOException("Unsupported timecode resource: " + resource);
    }

    public CachedTimecodeModel createCachedTimecodeModel(File file, String[] trackIds, boolean readOnly) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createCachedTimecodeModel: file=" + file + ", readOnly=" + readOnly);
        }
        String modelName = this.parseModelName(file.getName());
        DefaultTimecodeFile tcFile = new DefaultTimecodeFile(file, readOnly);
        boolean flushAsync = true;
        boolean deleteOnClose = false;
        float frameRate = tcFile.getFrameRate();
        long samples = tcFile.getFrameLength();
        int partSize = (int)((double)this.waxLabPreferences.getTimecodeCachePartMillis() * (double)frameRate / 1000.0);
        int maxLoadedParts = this.waxLabPreferences.getTimecodeCacheMaxParts();
        boolean fair = this.waxLabPreferences.isTimecodeCacheFair();
        try {
            CachedTimecodeModel tcModel = new CachedTimecodeModel(frameRate, samples, partSize, maxLoadedParts, this.lockFactory, fair, flushAsync, (ThreadPool)this.cacheThreadPool, (TimecodeFile)tcFile, deleteOnClose);
            tcModel.setName(modelName);
            if (file != null) {
                tcModel.setResource((Resource)new FileResource(file));
            }
            return tcModel;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e);
        }
    }

    public CachedTimecodeModel createCachedTimecodeModel(TimecodeFile timecodeFile, boolean deleteOnClose) throws IOException {
        boolean flushAsync = true;
        String fileName = timecodeFile.getPath();
        if (fileName != null) {
            fileName = new File(fileName).getName();
        }
        String modelName = this.parseModelName(fileName);
        float frameRate = timecodeFile.getFrameRate();
        long samples = timecodeFile.getFrameLength();
        int partSize = (int)((double)this.waxLabPreferences.getTimecodeCachePartMillis() * (double)frameRate / 1000.0);
        int maxLoadedParts = this.waxLabPreferences.getTimecodeCacheMaxParts();
        boolean fair = this.waxLabPreferences.isTimecodeCacheFair();
        try {
            CachedTimecodeModel tcModel = new CachedTimecodeModel(frameRate, samples, partSize, maxLoadedParts, this.lockFactory, fair, flushAsync, (ThreadPool)this.cacheThreadPool, timecodeFile, deleteOnClose);
            tcModel.setName(modelName);
            File file = timecodeFile.getFile();
            if (file != null) {
                tcModel.setResource((Resource)new FileResource(file));
            }
            return tcModel;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e);
        }
    }

    public CachedTimecodeModel analyzeTimecodeAudioModel(File audioFile, TimecodeLineConfig timecodeConfig, double[] progress) throws IOException {
        if (this.active) {
            throw new IllegalStateException("WaxLab device is currently active!");
        }
        if (timecodeConfig == null) {
            throw new NullPointerException("Missing TimecodeLineConfig");
        }
        String fileNamePrefix = audioFile.getName();
        int x = fileNamePrefix.lastIndexOf(46);
        if (x >= 0) {
            fileNamePrefix = fileNamePrefix.substring(0, x);
        }
        String tcFormatName = timecodeConfig.getTimecodeFormatName();
        int mode = AbstractScratchModeControl.getTimecodeDecoderMode(timecodeConfig.getScratchMode());
        if (mode < 0 || mode == 0) {
            mode = 1;
        }
        TimecodeFormat timecodeFormat = this.getTimecodeFormat(tcFormatName);
        boolean readOnly = true;
        String[] trackIds = null;
        CachedAudioModel audioModel = this.createCachedAudioModel(audioFile, trackIds, readOnly);
        return this.analyzeTimecodeAudioModel(audioModel, timecodeFormat, mode, fileNamePrefix, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedTimecodeModel analyzeTimecodeAudioModel(CachedAudioModel audioModel, TimecodeFormat timecodeFormat, int mode, String fileNamePrefix, double[] progress) throws IOException {
        if (this.active) {
            throw new IllegalStateException("WaxLab device is currently active!");
        }
        progress[0] = 0.0;
        int channels = 2;
        int modelChannels = audioModel.getChannels();
        if (modelChannels != 2) {
            throw new IOException("Invalid number of timecode audio channels: " + modelChannels + " != " + 2);
        }
        float frameRate = audioModel.getFrameRate();
        long frameLen = audioModel.getFrameLength();
        int bufLen = 2048;
        TimecodeFile timecodeFile = this.createNewTimecodeFile(fileNamePrefix, frameRate);
        CachedTimecodeModel timecodeModel = this.createCachedTimecodeModel(timecodeFile, this.deleteTempTimecodeFiles);
        DefaultSampleCursor targetSampleCursor = new DefaultSampleCursor((SampleModel)timecodeModel);
        Object tcDummyLine = null;
        int scratchMode = mode;
        int maxBufferFrames = bufLen / 2;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Creating timecode decoder: format=" + timecodeFormat + ", mode=" + mode + ", frameRate=" + frameRate + ", maxBufferFrames=" + maxBufferFrames);
        }
        double[] timecodeBuffer = null;
        TimecodeDecoder tcDecoder = timecodeFormat.createDecoder(frameRate, maxBufferFrames, frameRate, maxBufferFrames, timecodeBuffer);
        tcDecoder.setMode(scratchMode);
        try {
            long time = 0L;
            long bufTime = (long)((double)maxBufferFrames * 1.0E9 / (double)frameRate);
            double[] buf = new double[bufLen];
            long pos = 0L;
            long end = frameLen * 2L;
            while (pos < end) {
                int num = (int)Math.min((long)bufLen, end - pos);
                audioModel.get(pos, buf, 0, num);
                tcDecoder.decode(time, buf, 0, num);
                tcDecoder.produce(time, num / 2);
                time += bufTime;
                progress[0] = (double)(pos += (long)num) / (double)end;
            }
            progress[0] = 1.0;
        }
        finally {
            tcDecoder.close();
        }
        return timecodeModel;
    }

    public CachedFaderModel createCachedFaderModel(Resource resource, String[] trackIds, boolean readOnly) throws IOException {
        File file = null;
        try {
            file = resource.getFile();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (file != null) {
            return this.createCachedFaderModel(file, trackIds, readOnly);
        }
        throw new IOException("Unsupported fader resource: " + resource);
    }

    public CachedFaderModel createCachedFaderModel(File file, String[] trackIds, boolean readOnly) throws IOException {
        DefaultFaderFile faderFile = new DefaultFaderFile(file, readOnly);
        return this.createCachedFaderModel((FaderFile)faderFile);
    }

    public CachedFaderModel createCachedFaderModel(FaderFile faderFile) throws IOException {
        boolean flushAsync = true;
        float frameRate = faderFile.getFrameRate();
        long samples = faderFile.getFrameLength();
        int partSize = (int)((double)this.waxLabPreferences.getFaderCachePartMillis() * (double)frameRate / 1000.0);
        int maxLoadedParts = this.waxLabPreferences.getFaderCacheMaxParts();
        boolean fair = this.waxLabPreferences.isFaderCacheFair();
        try {
            CachedFaderModel faderModel = new CachedFaderModel(frameRate, samples, partSize, maxLoadedParts, this.lockFactory, fair, flushAsync, (ThreadPool)this.cacheThreadPool, faderFile);
            File file = faderFile.getFile();
            if (file != null) {
                String modelName = this.parseModelName(file.getName());
                faderModel.setName(modelName);
                faderModel.setResource((Resource)new FileResource(file));
            }
            return faderModel;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e);
        }
    }

    public TrackModelFile createNewMidiTrackFile(String fileNamePrefix, float tickRate) throws IOException {
        if (tickRate <= 0.0f) {
            throw new IllegalArgumentException("Invalid tickRate: " + tickRate);
        }
        String fileNameSuffix = ".wlm";
        File file = this.createNewContentFile(fileNamePrefix, fileNameSuffix);
        boolean readOnly = false;
        TrackModelFile trackModelFile = this.createMidiTrackFile(file, readOnly);
        trackModelFile.setTickRate(tickRate);
        return trackModelFile;
    }

    public TrackModelFile createMidiTrackFile(File file, boolean readOnly) throws IOException {
        int bufInitSize = 1024;
        boolean fair = this.waxLabPreferences.isMidiCacheFair();
        TrackModelFileImpl trackModelFile = new TrackModelFileImpl(file, readOnly, bufInitSize, this.lockFactory, fair);
        return trackModelFile;
    }

    public CachedMidiModel createCachedMidiModel(TrackModelFile trackModelFile, boolean readOnly) throws IOException {
        File file = trackModelFile.getFile();
        FileResource resource = new FileResource(file);
        float tickRate = trackModelFile.getTickRate();
        if (tickRate <= 0.0f) {
            throw new IllegalArgumentException("Invalid tickRate: " + tickRate);
        }
        UnitsPerSecond timeUnit = new UnitsPerSecond((double)tickRate);
        boolean fair = this.waxLabPreferences.isMidiCacheFair();
        int millisPerState = this.waxLabPreferences.getMidiStateMillis();
        if (millisPerState < 1) {
            millisPerState = 1;
        }
        int millisPerPart = this.waxLabPreferences.getMidiCachePartMillis();
        int maxLoadedParts = this.waxLabPreferences.getMidiCacheMaxParts();
        int ticksPerState = (int)((float)millisPerState * tickRate / 1000.0f);
        int ticksPerPart = (int)((float)millisPerPart * tickRate / 1000.0f);
        if (ticksPerState < 1) {
            ticksPerState = 1;
        }
        if (ticksPerPart < 1) {
            ticksPerPart = 1;
        }
        if (maxLoadedParts < 1) {
            maxLoadedParts = 1;
        }
        int initPartCapacity = maxLoadedParts;
        int partModelType = 2;
        FileTrackModel trackModel = new FileTrackModel(partModelType, trackModelFile, initPartCapacity, maxLoadedParts, ticksPerPart, this.lockFactory, fair);
        TreeStateModel stateModel = new TreeStateModel((TrackModel)trackModel, (long)ticksPerState);
        CachedMidiModel cachedMidiModel = new CachedMidiModel(trackModel, (StateModel)stateModel, (TimeUnit)timeUnit, this.lockFactory, fair, trackModelFile);
        cachedMidiModel.setResource((Resource)resource);
        return cachedMidiModel;
    }

    public MidiTrack[] createMidiTracks(Resource resource, boolean readOnly) throws IOException {
        String[] trackIds = null;
        return this.createMidiTracks(resource, trackIds, readOnly);
    }

    public MidiTrack[] createMidiTracks(Resource resource, String[] trackIds, boolean readOnly) throws IOException {
        File file;
        if (resource.isFile() && (file = resource.getFile()) != null && TrackModelFileImpl.isTrackModelFile((File)file)) {
            CachedMidiModel cachedMidiModel;
            TrackModelFile trackModelFile = this.createMidiTrackFile(file, readOnly);
            if (trackModelFile != null && (cachedMidiModel = this.createCachedMidiModel(trackModelFile, readOnly)) != null) {
                String trackName = cachedMidiModel.getName();
                TimeUnit timeUnit = cachedMidiModel.getTimeUnit();
                String trackId = null;
                DefaultMidiTrack midiTrack = new DefaultMidiTrack(resource, trackId, trackName, timeUnit, (MidiModel)cachedMidiModel);
                return new MidiTrack[]{midiTrack};
            }
            return new MidiTrack[0];
        }
        if (!readOnly) {
            throw new IOException("Read/Write not supported for MIDI resource: " + resource);
        }
        MidiTrack[] midiTracks = null;
        MidiModelUtil midiModelUtil = MidiModelUtil.getInstance();
        try {
            midiTracks = midiModelUtil.readMidiTracks(resource, trackIds);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IOException("Failed to load midi resource: " + resource + ", cause=" + e);
        }
        return midiTracks;
    }

    public MidiModel createMidiModel(MidiTrack[] midiTracks) throws IOException {
        MidiModel midiModel;
        int numTracks = midiTracks.length;
        int millisPerState = this.waxLabPreferences.getMidiStateMillis();
        if (millisPerState < 1) {
            millisPerState = 1;
        }
        double secondsPerState = (double)millisPerState / 1000.0;
        int modelType = 2;
        boolean fair = this.waxLabPreferences.isMidiCacheFair();
        long totalEvents = 0L;
        UnitsPerSecond timeUnit = null;
        for (int i = 0; i < numTracks; ++i) {
            MidiTrack midiTrack = midiTracks[i];
            if (midiTrack == null) continue;
            long eventCount = midiTrack.getEventCount();
            if (eventCount > 0L) {
                totalEvents += eventCount;
            }
            if (timeUnit != null) continue;
            timeUnit = midiTrack.getTimeUnit();
        }
        int initCapacity = 32;
        if (totalEvents > (long)initCapacity && totalEvents <= Integer.MAX_VALUE) {
            initCapacity = (int)totalEvents;
        }
        if (timeUnit == null) {
            float tickRate = 9000.0f;
            timeUnit = new UnitsPerSecond((double)tickRate);
        }
        try {
            MidiModelUtil midiModelUtil = MidiModelUtil.getInstance();
            midiModel = midiModelUtil.createMidiModel(midiTracks, secondsPerState, modelType, initCapacity, (TimeUnit)timeUnit, this.lockFactory, fair);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IOException("Failed to create midi model: " + e);
        }
        boolean checkIntegrity = this.waxLabPreferences.isMidiCheckIntegrity();
        if (checkIntegrity) {
            midiModel.checkIntegrity();
        }
        return midiModel;
    }

    public WaxEditorModel createCachedWaxEditorModel(Resource resource, String[] trackIds, boolean readOnly) throws IOException {
        File file = null;
        try {
            file = resource.getFile();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (file != null) {
            int index = 0;
            WaxEditorModel[] wems = this.createCachedWaxEditorModels(file, readOnly);
            if (index < wems.length) {
                return wems[index];
            }
            return null;
        }
        throw new IOException("Unsupported wax-editor resource: " + resource);
    }

    public WaxEditorModel[] createCachedWaxEditorModels(File file, boolean readOnly) throws IOException {
        DefaultWaxEditorFile wef = new DefaultWaxEditorFile(file);
        return wef.readWaxEditorFile();
    }

    public FaderFile createNewFaderFile(String fileNamePrefix, float sampleRate) throws IOException {
        String fileNameSuffix = ".wlf";
        File file = this.createNewContentFile(fileNamePrefix, fileNameSuffix);
        return new DefaultFaderFile(file, sampleRate);
    }

    public TimecodeFile createNewTimecodeFile(String fileNamePrefix, float sampleRate) throws IOException {
        String fileNameSuffix = ".wlt";
        File file = this.createNewContentFile(fileNamePrefix, fileNameSuffix);
        return new DefaultTimecodeFile(file, sampleRate);
    }

    public WaxEditorFile createNewWaxEditorFile(String fileNamePrefix) throws IOException {
        String fileNameSuffix = ".wlx";
        File file = this.createNewContentFile(fileNamePrefix, fileNameSuffix);
        return new DefaultWaxEditorFile(file);
    }

    public TimecodeManager getTimecodeManager() {
        return this.timecodeManager;
    }

    protected void setTimecodeManager(TimecodeManager timecodeManager) {
        this.timecodeManager = timecodeManager;
    }

    public WaxLabPreferences getWaxLabPreferences() {
        return this.waxLabPreferences;
    }

    public synchronized void setWaxLabPreferences(WaxLabPreferences prefs) {
        this.waxLabPreferences = prefs;
        this.configureThreadPool(this.cacheThreadPool, prefs.getModelCacheThreadPriority(), prefs.getModelCacheIdleTimeout());
        this.configureThreadPool(this.writerThreadPool, prefs.getModelWriterThreadPriority(), prefs.getModelWriterIdleTimeout());
        this.configureThreadPool(this.loaderThreadPool, prefs.getModelLoaderThreadPriority(), prefs.getModelLoaderIdleTimeout());
        this.configureThreadPool(this.workerThreadPool, prefs.getWorkerThreadPriority(), prefs.getWorkerIdleTimeout());
    }

    protected void configureThreadPool(DefaultThreadPool threadPool, int priority, long idleTimeout) {
        if (priority >= 1 && priority <= 10) {
            threadPool.setPriority(priority);
        }
        if (idleTimeout >= 0L) {
            threadPool.setIdleTimeout(idleTimeout);
        }
    }

    public synchronized void saveWaxLabConfig(File waxLabConfigFile, boolean includeModelFiles) throws IOException {
        WaxLabXmlUtil util = new WaxLabXmlUtil(this, this.device);
        util.saveStudioConfig(waxLabConfigFile, includeModelFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAudioFile(AudioFile audioFile, File targetFile) throws IOException {
        long frames = audioFile.getFrameLength();
        AudioFormat format = audioFile.getAudioFormat();
        int frameSize = format.getFrameSize();
        AudioFile dest = this.createAudioFile(targetFile, format);
        try {
            byte[] byArray = this.copyByteArray;
            synchronized (this.copyByteArray) {
                int num;
                byte[] buf = this.copyByteArray;
                int bufFrames = buf.length / frameSize;
                for (long framePos = 0L; framePos < frames; framePos += (long)num) {
                    num = (int)Math.min((long)bufFrames, frames - framePos);
                    int len = num * frameSize;
                    audioFile.read(framePos, buf, 0, len);
                    dest.write(framePos, buf, 0, len);
                }
                // ** MonitorExit[var8_7] (shouldn't be in output)
            }
        }
        finally {
            dest.close();
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTimecodeModel(TimecodeModel model, File targetFile) throws IOException {
        long frames = model.getFrameLength();
        float frameRate = model.getFrameRate();
        DefaultTimecodeFile tcFile = new DefaultTimecodeFile(targetFile, frameRate);
        try {
            byte[] byArray = this.copyByteArray;
            synchronized (this.copyByteArray) {
                int len;
                byte[] arr = this.copyByteArray;
                double[] buf = this.copyDoubleArray;
                int bufSize = Math.min(buf.length, arr.length / 8);
                for (long framePos = 0L; framePos < frames; framePos += (long)len) {
                    len = (int)Math.min((long)bufSize, frames - framePos);
                    model.get(framePos, buf, 0, len);
                    int off = 0;
                    int i = 0;
                    while (i < len) {
                        Data.setDouble((byte[])arr, (int)off, (double)buf[i++]);
                        off += 8;
                    }
                    tcFile.write(framePos, arr, 0, off);
                }
                // ** MonitorExit[var7_6] (shouldn't be in output)
            }
        }
        finally {
            tcFile.close();
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFaderModel(FaderModel model, File targetFile) throws IOException {
        long frames = model.getFrameLength();
        float frameRate = model.getFrameRate();
        DefaultFaderFile fdrFile = new DefaultFaderFile(targetFile, frameRate);
        try {
            byte[] byArray = this.copyByteArray;
            synchronized (this.copyByteArray) {
                int len;
                byte[] arr = this.copyByteArray;
                float[] buf = this.copyFloatArray;
                int bufSize = Math.min(buf.length, arr.length / 4);
                for (long framePos = 0L; framePos < frames; framePos += (long)len) {
                    len = (int)Math.min((long)bufSize, frames - framePos);
                    model.get(framePos, buf, 0, len);
                    int off = 0;
                    int i = 0;
                    while (i < len) {
                        Data.setFloat((byte[])arr, (int)off, (float)buf[i++]);
                        off += 4;
                    }
                    fdrFile.write(framePos, arr, 0, off);
                }
                // ** MonitorExit[var7_6] (shouldn't be in output)
            }
        }
        finally {
            fdrFile.close();
        }
        {
            return;
        }
    }

    public void writeWaxEditorModels(WaxEditorModel[] models, File targetFile) throws IOException {
        DefaultWaxEditorFile wef = new DefaultWaxEditorFile(targetFile);
        wef.writeWaxEditorFile(models);
    }

    public long exportEditorLineToAudioFile(EditorLine editorLine, long lineOfs, long lineEnd, int bufferFrames, AudioFile targetFile, long framePos) throws IOException {
        DefaultEditorLine scratchLine = null;
        if (editorLine instanceof DefaultEditorLine) {
            scratchLine = (DefaultEditorLine)editorLine;
        }
        if (scratchLine == null) {
            throw new IllegalArgumentException("Unsupported scratch editor line: " + editorLine);
        }
        MediaEntry mediaEntry = scratchLine.getScratchMediaEntry();
        Resource scratchResource = mediaEntry != null ? mediaEntry.getResource() : scratchLine.getScratchAudioResource();
        if (scratchResource == null) {
            throw new RuntimeException("No scratch resource specified for editor line: " + scratchLine);
        }
        AudioFormat audioFormat = targetFile.getAudioFormat();
        int audioChannels = audioFormat.getChannels();
        float frameRate = audioFormat.getFrameRate();
        int frameSize = audioFormat.getFrameSize();
        throw new UnsupportedOperationException("TODO");
    }

    public long exportEditorLineToAudioModel(EditorLine editorLine, long lineOfs, long lineEnd, int bufferFrames, SampleModel targetModel) throws IOException {
        DefaultEditorLine scratchLine = null;
        if (editorLine instanceof DefaultEditorLine) {
            scratchLine = (DefaultEditorLine)editorLine;
        }
        if (scratchLine == null) {
            throw new IllegalArgumentException("Unsupported scratch editor line: " + editorLine);
        }
        MediaEntry mediaEntry = scratchLine.getScratchMediaEntry();
        Resource scratchResource = mediaEntry != null ? mediaEntry.getResource() : scratchLine.getScratchAudioResource();
        if (scratchResource == null) {
            throw new RuntimeException("No scratch resource specified for editor line: " + scratchLine);
        }
        int audioChannels = targetModel.getChannels();
        float frameRate = targetModel.getFrameRate();
        throw new UnsupportedOperationException("TODO");
    }

    public long exportEditorLineToTimecodeFile(EditorLine editorLine, long lineOfs, long lineEnd, int bufferSize, TimecodeFile targetFile, long framePos) throws IOException {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Invalid buffer size: " + bufferSize);
        }
        ChunkModel chunkModel = editorLine.getChunkModel();
        LineChunk[] lineChunks = chunkModel.getChunks(new LineChunk[chunkModel.getChunkCount()]);
        int numLineChunks = lineChunks.length;
        WaxEditorModel[] editorModels = new WaxEditorModel[numLineChunks];
        int editorModelCount = 0;
        for (int i = 0; i < numLineChunks; ++i) {
            LineChunk lineChunk = lineChunks[i];
            if (lineChunk == null || !(lineChunk instanceof WaxEditorModel)) continue;
            editorModels[editorModelCount++] = (WaxEditorModel)lineChunk;
        }
        float frameRate = targetFile.getFrameRate();
        InterpolatedTimecodeModel[] interTimecodeModels = WaxEditorUtil.createInterpolatedTimecodeModels((float)frameRate, (WaxEditorModel[])editorModels, (int)editorModelCount, (InterpolatorRegistry)this.interpolatorRegistry);
        MergedTimecodeModelOLD mergedTimecodeModel = new MergedTimecodeModelOLD(frameRate);
        mergedTimecodeModel.addTimecodeModels((TimecodeModel[])interTimecodeModels);
        MergedTimecodeModelOLD timecodeModel = mergedTimecodeModel;
        throw new UnsupportedOperationException("TODO");
    }

    public long exportEditorLineToFaderFile(EditorLine editorLine, long lineOfs, long lineEnd, int bufferSize, FaderFile targetFile, long framePos) throws IOException {
        double fadeOutMillis;
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Invalid buffer size: " + bufferSize);
        }
        WaxEditorModel[] editorModels = editorLine.getEditorChunks();
        int editorModelCount = editorModels.length;
        float frameRate = targetFile.getFrameRate();
        double fadeInMillis = this.waxLabPreferences.getEditorFadeInMillis();
        if (fadeInMillis < 0.0) {
            fadeInMillis = 10.0;
        }
        if ((fadeOutMillis = this.waxLabPreferences.getEditorFadeOutMillis()) < 0.0) {
            fadeOutMillis = 10.0;
        }
        InterpolatedFaderModel[] interFaderModels = WaxEditorUtil.createInterpolatedFaderModels((float)frameRate, (WaxEditorModel[])editorModels, (int)editorModelCount, (InterpolatorRegistry)this.interpolatorRegistry, (double)fadeInMillis, (double)fadeOutMillis);
        MergedFaderModelOLD mergedFaderModel = new MergedFaderModelOLD(frameRate);
        mergedFaderModel.addFaderModels((FaderModel[])interFaderModels);
        MergedFaderModelOLD faderModel = mergedFaderModel;
        throw new UnsupportedOperationException("TODO");
    }

    public long exportTimecodeLineToTimecodeFile(TimecodeLine timecodeLine, long lineOfs, long lineEnd, int bufferSize, TimecodeFile targetFile, long framePos) throws IOException {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Invalid buffer size: " + bufferSize);
        }
        throw new UnsupportedOperationException("TODO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadWaxLabConfig(File waxLabConfigFile, boolean includeModelFiles) throws IOException {
        WaxLabImpl waxLabImpl = this;
        synchronized (waxLabImpl) {
            if (this.active) {
                throw new IllegalStateException("WaxLab device is currently active!");
            }
        }
        WaxLabXmlUtil util = new WaxLabXmlUtil(this, this.device);
        util.loadStudioConfig(waxLabConfigFile, includeModelFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadWaxLabConfig(URL waxLabConfigURL, boolean includeModelFiles) throws IOException {
        WaxLabImpl waxLabImpl = this;
        synchronized (waxLabImpl) {
            if (this.active) {
                throw new IllegalStateException("WaxLab device is currently active!");
            }
        }
        WaxLabXmlUtil util = new WaxLabXmlUtil(this, this.device);
        URI baseURI = null;
        try {
            baseURI = new URI(waxLabConfigURL.toString());
        }
        catch (URISyntaxException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        InputStream in = waxLabConfigURL.openStream();
        try {
            util.loadStudioConfig(in, baseURI, includeModelFiles);
        }
        finally {
            in.close();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDirty() {
        if (this.dirty) {
            return true;
        }
        Line[] theLines = this.getLines();
        if (theLines != null) {
            for (int i = 0; i < theLines.length; ++i) {
                if (!theLines[i].isLineDirty()) continue;
                return true;
            }
        }
        return false;
    }

    public void setDirtyFlag() {
        this.dirty = true;
    }

    public void clearDirtyFlag() {
        this.dirty = false;
        Line[] theLines = this.getLines();
        if (theLines != null) {
            for (int i = 0; i < theLines.length; ++i) {
                theLines[i].clearLineDirty();
            }
        }
    }

    public InterpolatorRegistry getInterpolatorRegistry() {
        return this.interpolatorRegistry;
    }

    protected void setInterpolatorRegistry(InterpolatorRegistry interpolatorRegistry) {
        this.interpolatorRegistry = interpolatorRegistry;
    }

    protected final LockSupport getLockSupport() {
        return this.lockSupport;
    }

    protected final LockFactory getLockFactory() {
        return this.lockFactory;
    }

    protected ThreadPool getCacheThreadPool() {
        return this.cacheThreadPool;
    }

    protected ThreadPool getWriterThreadPool() {
        return this.writerThreadPool;
    }

    protected ThreadPool getLoaderThreadPool() {
        return this.loaderThreadPool;
    }

    protected DefaultThreadPool getWorkerThreadPool() {
        return this.workerThreadPool;
    }

    public SoundSystem getSoundSystem() {
        return this.soundSystem;
    }

    protected void setSoundSystem(SoundSystem soundSystem) {
        this.soundSystem = soundSystem;
    }

    public boolean isActive() {
        return this.active;
    }

    protected final WaxLabDevice getWaxLabDevice() {
        return this.device;
    }

    final synchronized void setWaxLabDevice(WaxLabDevice device) throws StudioException {
        if (this.device != null) {
            throw new StudioException("WaxLab is already initialized: " + this);
        }
        this.device = device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(long startLineOfs) throws Exception {
        if (this.active) {
            throw new IllegalStateException("WaxLab is already active: " + this);
        }
        WaxLabDevice dev = this.device;
        if (dev == null) {
            throw new IllegalStateException("WaxLabDevice is not available: " + this);
        }
        Studio studio = dev.getStudio();
        if (studio == null) {
            throw new StudioException("WaxLabDevice is not assigned to a studio: " + (Object)((Object)dev));
        }
        if (!studio.isStarted()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Starting studio automatically: " + studio);
            }
            this.autoStarted = true;
            studio.start();
            if (!studio.isStarted()) {
                throw new StudioException("Studio is not started: " + studio);
            }
        }
        boolean success = false;
        try {
            String timestampString = this.timestampFormat.format(new Date());
            SyncMediator syncMediator = dev.getSyncMediator();
            if (syncMediator != null) {
                boolean batchMode = false;
                syncMediator.start(batchMode, startLineOfs, timestampString);
            }
            success = true;
        }
        finally {
            if (success) {
                this.active = true;
                for (WaxLabListener l : (WaxLabListener[])this.waxLabListeners.array()) {
                    l.stateChanged(true);
                }
                this.lightWaxLabStarted();
            }
        }
    }

    public synchronized void stop() throws Exception {
        if (!this.active) {
            return;
        }
        WaxLabDevice dev = this.device;
        if (dev == null) {
            return;
        }
        Studio studio = dev.getStudio();
        if (studio == null) {
            return;
        }
        SyncMediator syncMediator = dev.getSyncMediator();
        if (syncMediator != null) {
            syncMediator.stop();
        }
        this.active = false;
        for (WaxLabListener l : (WaxLabListener[])this.waxLabListeners.array()) {
            l.stateChanged(false);
        }
        this.lightWaxLabStopped();
        if (logger.isLoggable(Level.FINER)) {
            this.dumpThreadPoolDetails(this.cacheThreadPool, Level.FINER);
            this.dumpThreadPoolDetails(this.writerThreadPool, Level.FINER);
            this.dumpThreadPoolDetails(this.loaderThreadPool, Level.FINER);
            this.dumpThreadPoolDetails(this.workerThreadPool, Level.FINER);
        }
        if (this.autoStarted && this.autoStopStudio) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Stopping studio automatically: " + studio);
            }
            this.autoStarted = false;
            studio.stop();
        }
    }

    protected void dumpThreadPoolDetails(DefaultThreadPool pool, Level level) {
        String prefix = pool.getNamePrefix();
        int priority = pool.getPriority();
        int threads = pool.getThreadCount();
        int minThreads = pool.getMinThreadCount();
        int maxThreads = pool.getMaxThreadCount();
        long idleTimeout = pool.getIdleTimeout();
        logger.log(level, "Thread pool: " + prefix + ", priority=" + priority + ", threads=" + threads + ", minThreads=" + minThreads + ", maxThreads=" + maxThreads + ", idleTimeout=" + idleTimeout);
    }

    public DateFormat getTimestampFormat() {
        return this.timestampFormat;
    }

    public void setTimestampFormat(DateFormat timestampFormat) {
        if (timestampFormat == null) {
            throw new IllegalArgumentException("DateFormat must not be null!");
        }
        this.timestampFormat = timestampFormat;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.properties);
        return props;
    }

    public void setProperties(Properties newProperties) {
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)newProperties);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.setProperty(key, value);
        }
    }

    public synchronized String getClockType() {
        return this.clockType;
    }

    public synchronized void setClockType(String clockType) {
        if (this.clockType == clockType) {
            return;
        }
        if (clockType != null && clockType.equals(this.clockType)) {
            return;
        }
        this.clockType = clockType;
        this.applySyncClock();
    }

    public synchronized WaxLabPortInfo getClockAudioPort() {
        return this.clockAudioPort;
    }

    public synchronized void setClockAudioPort(WaxLabPortInfo clockAudioPort) {
        if (this.clockAudioPort == clockAudioPort) {
            return;
        }
        this.clockAudioPort = clockAudioPort;
        this.applySyncClock();
    }

    public synchronized WaxLabPortInfo getMidiInputPort() {
        return this.midiInputPort;
    }

    public synchronized void setMidiInputPort(WaxLabPortInfo midiInputPort) {
        if (this.midiInputPort == midiInputPort) {
            return;
        }
        this.midiInputPort = midiInputPort;
        this.applyMidiMappings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiAction[] getMidiActions() {
        MidiAction[] actions;
        LinkedList<MidiAction> list = new LinkedList<MidiAction>();
        Map map = this.midiActionMap;
        synchronized (map) {
            actions = this.midiActions;
            if (actions != null) {
                for (MidiAction action : actions) {
                    if (action == null) continue;
                    list.add(action);
                }
            }
        }
        int lineCount = this.getLineCount();
        for (int k = 0; k < lineCount; ++k) {
            Line line = this.getLineAt(k);
            actions = line.getWidgetMidiActions();
            if (actions == null) continue;
            for (MidiAction action : actions) {
                if (action == null) continue;
                list.add(action);
            }
        }
        return list.toArray(new MidiAction[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiAction getMidiAction(MidiMapping mapping) {
        if (mapping == null) {
            return null;
        }
        if (mapping instanceof LineMidiMapping) {
            LineMidiMapping lineMapping = (LineMidiMapping)mapping;
            Line line = lineMapping.getLine();
            if (line == null) {
                return null;
            }
            MidiAction midiAction = line.getWidgetMidiAction(lineMapping);
            if (midiAction != null) {
                return midiAction;
            }
        }
        String action = mapping.getAction();
        Map map = this.midiActionMap;
        synchronized (map) {
            return (MidiAction)this.midiActionMap.get(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMidiActions(MidiAction[] availableMidiActions) {
        Map map = this.midiActionMap;
        synchronized (map) {
            this.midiActions = availableMidiActions;
            this.midiActionMap.clear();
            int num = availableMidiActions == null ? 0 : availableMidiActions.length;
            for (int i = 0; i < num; ++i) {
                String name;
                MidiAction action = availableMidiActions[i];
                if (action == null || (name = action.getName()) == null || this.midiActionMap.containsKey(name)) continue;
                this.midiActionMap.put(name, action);
            }
        }
    }

    public synchronized MidiMapping[] getMidiMappings() {
        MidiMapping[] orig = this.midiMappings;
        int num = orig == null ? 0 : orig.length;
        MidiMapping[] arr = new MidiMapping[num];
        if (num > 0) {
            System.arraycopy(orig, 0, arr, 0, num);
        }
        return arr;
    }

    public synchronized void setMidiMappings(MidiMapping[] mappings) {
        int oldCount;
        MidiMapping[] oldMappings = this.midiMappings;
        LinkedList<MidiMapping> list = new LinkedList<MidiMapping>();
        int num = mappings == null ? 0 : mappings.length;
        for (int i = 0; i < num; ++i) {
            Line line;
            MidiMapping mapping = mappings[i];
            if (mapping == null) continue;
            if (mapping instanceof LineMidiMapping) {
                LineMidiMapping lineMapping = (LineMidiMapping)mapping;
                line = lineMapping.getLine();
            } else {
                String lineName;
                line = null;
                String action = mapping.getAction();
                if (action != null && (lineName = LineMidiMapping.parseLineName((String)action)) != null) {
                    int lineCount = this.getLineCount();
                    for (int k = 0; k < lineCount; ++k) {
                        Line aLine = this.getLineAt(k);
                        if (aLine == null || !lineName.equals(aLine.getName())) continue;
                        line = aLine;
                        break;
                    }
                }
            }
            if (line != null) {
                mapping = LineMidiMapping.getLineMidiMapping((Line)line, (MidiMapping)mapping);
            }
            list.add(mapping);
        }
        mappings = list.toArray(new MidiMapping[list.size()]);
        this.midiMappings = mappings;
        int n = oldCount = oldMappings == null ? 0 : oldMappings.length;
        if (oldCount == mappings.length) {
            boolean changed = false;
            for (int i = 0; i < oldCount; ++i) {
                if (oldMappings[i] == mappings[i]) continue;
                changed = true;
                break;
            }
            if (!changed) {
                return;
            }
        }
        this.applyMidiMappings();
    }

    public synchronized WaxLabPortInfo getMidiOutputPort() {
        return this.midiOutputPort;
    }

    public synchronized void setMidiOutputPort(WaxLabPortInfo midiOutputPort) {
        if (this.midiOutputPort == midiOutputPort) {
            return;
        }
        this.midiOutputPort = midiOutputPort;
        this.applyMidiTriggers();
    }

    public synchronized MidiTrigger[] getMidiTriggers() {
        MidiTrigger[] orig = this.midiTriggers;
        int num = orig == null ? 0 : orig.length;
        MidiTrigger[] arr = new MidiTrigger[num];
        if (num > 0) {
            System.arraycopy(orig, 0, arr, 0, num);
        }
        return arr;
    }

    public synchronized void setMidiTriggers(MidiTrigger[] triggers) {
        int oldCount;
        MidiTrigger[] oldTriggers = this.midiTriggers;
        LinkedList<MidiTrigger> list = new LinkedList<MidiTrigger>();
        int num = triggers == null ? 0 : triggers.length;
        for (int i = 0; i < num; ++i) {
            Line line;
            MidiTrigger trigger = triggers[i];
            if (trigger == null) continue;
            if (trigger instanceof LineMidiTrigger) {
                LineMidiTrigger lineTrigger = (LineMidiTrigger)trigger;
                line = lineTrigger.getLine();
            } else {
                String lineName;
                line = null;
                String event = trigger.getEvent();
                if (event != null && (lineName = LineMidiTrigger.parseLineName((String)event)) != null) {
                    int lineCount = this.getLineCount();
                    for (int k = 0; k < lineCount; ++k) {
                        Line aLine = this.getLineAt(k);
                        if (aLine == null || !lineName.equals(aLine.getName())) continue;
                        line = aLine;
                        break;
                    }
                }
            }
            if (line != null) {
                trigger = LineMidiTrigger.getLineMidiTrigger((Line)line, (MidiTrigger)trigger);
            }
            list.add(trigger);
        }
        triggers = list.toArray(new MidiTrigger[list.size()]);
        this.midiTriggers = triggers;
        int n = oldCount = oldTriggers == null ? 0 : oldTriggers.length;
        if (oldCount == triggers.length) {
            boolean changed = false;
            for (int i = 0; i < oldCount; ++i) {
                if (oldTriggers[i] == triggers[i]) continue;
                changed = true;
                break;
            }
            if (!changed) {
                return;
            }
        }
        this.applyMidiTriggers();
    }

    public synchronized String[] getMidiEvents() {
        LinkedList<String> list = new LinkedList<String>();
        String[] events = this.midiEvents;
        if (events != null) {
            for (String event : events) {
                if (event == null) continue;
                list.add(event);
            }
        }
        int lineCount = this.getLineCount();
        for (int k = 0; k < lineCount; ++k) {
            Line line = this.getLineAt(k);
            events = line.getWidgetMidiEvents();
            if (events == null) continue;
            for (String event : events) {
                if (event == null) continue;
                list.add(event);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    protected synchronized void setMidiEvents(String[] midiEvents) {
        this.midiEvents = midiEvents;
    }

    protected MidiProcessor getTargetMidiProcessor() {
        return this.targetMidiProcessor;
    }

    protected synchronized void setTargetMidiProcessor(MidiProcessor targetMidiProcessor) {
        MidiProcessor oldProc = this.targetMidiProcessor;
        if (targetMidiProcessor != oldProc) {
            if (targetMidiProcessor == null) {
                logger.info("fireDeckStopped ...: " + this);
                this.lightWaxLabStopped();
                logger.info("fireDeckStopped done: " + this);
            }
            this.targetMidiProcessor = targetMidiProcessor;
            this.triggerTarget.setTargetProcessor(targetMidiProcessor);
        }
        this.refreshMidiLightings();
    }

    public void handleMidiTargetChanged(MidiOutputPort midiOutPort) {
        WaxLabMidiOutputPort waxMidiOutPort = null;
        if (midiOutPort != null && midiOutPort instanceof WaxLabMidiOutputPort) {
            waxMidiOutPort = (WaxLabMidiOutputPort)midiOutPort;
        }
        if (waxMidiOutPort == null) {
            return;
        }
        WaxLabPortInfo midiOutInfo = this.getMidiOutputPort();
        if (midiOutInfo == null) {
            return;
        }
        if (midiOutPort != midiOutInfo.getPort()) {
            return;
        }
        MidiProcessor targetMidiProc = waxMidiOutPort.getMidiProcessor();
        this.setTargetMidiProcessor(targetMidiProc);
        try {
            long sleepMillis = 1000L;
            this.workerThreadPool.start((Runnable)new RefreshMidiLightings(sleepMillis));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected synchronized void handleLineChanged(Line line) {
        MidiMapping[] mappings = this.midiMappings;
        this.midiMappings = null;
        this.setMidiMappings(mappings);
        MidiTrigger[] triggers = this.midiTriggers;
        this.midiTriggers = null;
        this.setMidiTriggers(triggers);
    }

    protected synchronized void applySyncClock() {
        SyncMediatorImpl syncMediator = this.getSyncMediatorImpl();
        if (syncMediator == null) {
            return;
        }
        String clockType = this.clockType;
        logger.info("TODO applySyncClock: clockType=" + clockType);
    }

    protected synchronized void applyMidiMappings() {
        Port midiPort;
        SyncMediatorImpl syncMediator = this.getSyncMediatorImpl();
        if (syncMediator == null) {
            return;
        }
        WaxLabMidiInputPort newMidiPort = null;
        WaxLabPortInfo midiInputPort = this.midiInputPort;
        Port port = midiPort = midiInputPort == null ? null : midiInputPort.getPort();
        if (midiPort != null && midiPort instanceof WaxLabMidiInputPort) {
            newMidiPort = (WaxLabMidiInputPort)midiPort;
        }
        MidiMapping[] newMappings = this.midiMappings;
        syncMediator.resetWaxLabMidiMappings(newMidiPort, newMappings);
    }

    protected synchronized void applyMidiTriggers() {
        Port outPort;
        this.refreshMidiTriggers();
        MidiProcessor targetMidiProc = null;
        WaxLabPortInfo outPortInfo = this.getMidiOutputPort();
        if (outPortInfo != null && (outPort = outPortInfo.getPort()) != null && outPort instanceof WaxLabMidiOutputPort) {
            WaxLabMidiOutputPort midiOutPort = (WaxLabMidiOutputPort)outPort;
            targetMidiProc = midiOutPort.getMidiProcessor();
        }
        this.setTargetMidiProcessor(targetMidiProc);
    }

    protected synchronized void refreshMidiTriggers() {
        LinkedList<MidiTrigger> waxLabStartedTriggers = null;
        LinkedList<MidiTrigger> waxLabStoppedTriggers = null;
        MidiTrigger[] triggers = this.getMidiTriggers();
        int num = triggers == null ? 0 : triggers.length;
        for (int i = 0; i < num; ++i) {
            String event;
            MidiTrigger trigger = triggers[i];
            if (trigger == null || (event = trigger.getEvent()) == null) continue;
            if ("Started".equals(event)) {
                if (waxLabStartedTriggers == null) {
                    waxLabStartedTriggers = new LinkedList<MidiTrigger>();
                }
                waxLabStartedTriggers.add(trigger);
                continue;
            }
            if ("Stopped".equals(event)) {
                if (waxLabStoppedTriggers == null) {
                    waxLabStoppedTriggers = new LinkedList<MidiTrigger>();
                }
                waxLabStoppedTriggers.add(trigger);
                continue;
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("Unknown MidiTrigger-Event: " + event);
        }
        this.waxLabStartedEvent = this.createMidiTriggerEvent(waxLabStartedTriggers);
        this.waxLabStoppedEvent = this.createMidiTriggerEvent(waxLabStoppedTriggers);
        this.refreshMidiLightings();
    }

    protected MidiTriggerEvent createMidiTriggerEvent(List triggerList) {
        if (triggerList == null) {
            return null;
        }
        int num = triggerList.size();
        if (num < 1) {
            return null;
        }
        MidiTrigger[] triggers = triggerList.toArray(new MidiTrigger[num]);
        MidiTriggerEvent event = new MidiTriggerEvent(this.triggerTarget);
        event.setMidiTriggers(triggers);
        return event;
    }

    protected void initMidiEvents() {
        String[] events = new String[]{"Started", "Stopped"};
        this.setMidiEvents(events);
    }

    public void refreshMidiLightings() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.getName() + ": refreshMidiLightings: " + this);
        }
        try {
            this.workerThreadPool.start((Runnable)this.refreshMidiLightings);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void refreshMidiLightingsImpl() {
        if (this.isActive()) {
            this.lightWaxLabStarted();
        } else {
            this.lightWaxLabStopped();
        }
    }

    protected void lightWaxLabStarted() {
        MidiTriggerEvent event = this.waxLabStartedEvent;
        if (event != null) {
            event.fire();
        }
    }

    protected void lightWaxLabStopped() {
        MidiTriggerEvent event = this.waxLabStoppedEvent;
        if (event != null) {
            event.fire();
        }
    }

    public MediaLibrary getMediaLibrary() {
        return this.mediaLibrary;
    }

    protected void setMediaLibrary(MediaLibrary mediaLibrary) {
        this.mediaLibrary = mediaLibrary;
    }

    public MediaEntry getMediaEntry(Resource resource) throws IOException {
        MediaLibrary lib = this.mediaLibrary;
        if (lib == null) {
            return null;
        }
        return lib.getMediaEntry(resource);
    }

    public MediaEntry getMediaEntry(Resource resource, int flags) throws IOException {
        MediaLibrary lib = this.mediaLibrary;
        if (lib == null) {
            return null;
        }
        return lib.getMediaEntry(resource, flags);
    }

    public boolean updateMediaMarkers(MutableMediaEntry entry, MediaMarker[] markers) throws IOException {
        MediaLibrary lib = this.mediaLibrary;
        if (lib == null) {
            return false;
        }
        if (entry == null) {
            return false;
        }
        Resource resource = entry.getResource();
        if (resource == null) {
            return false;
        }
        entry.setMarkers(markers);
        lib.putMediaEntry(resource, (MediaEntry)entry);
        return true;
    }

    public synchronized MediaPlayer[] getLineMediaPlayers() {
        LinkedList<MediaPlayer> playerList = new LinkedList<MediaPlayer>();
        Line[] theLines = this.getLines();
        if (theLines != null) {
            for (int i = 0; i < theLines.length; ++i) {
                MediaPlayer[] arr = theLines[i].getMediaPlayers();
                if (arr == null) continue;
                for (MediaPlayer mp : arr) {
                    if (mp == null) continue;
                    playerList.add(mp);
                }
            }
        }
        return playerList.toArray(new MediaPlayer[playerList.size()]);
    }

    public String getPlayerNamePrefix() {
        return this.playerNamePrefix;
    }

    public synchronized void setPlayerNamePrefix(String playerNamePrefix) {
        this.playerNamePrefix = playerNamePrefix;
        Line[] theLines = this.getLines();
        if (theLines != null) {
            for (int i = 0; i < theLines.length; ++i) {
                Line line = theLines[i];
                if (line == null || !(line instanceof ScratchLine)) continue;
                ((ScratchLine)line).setPlayerNamePrefix(playerNamePrefix);
            }
        }
    }

    public boolean isAutoStopStudio() {
        return this.autoStopStudio;
    }

    public void setAutoStopStudio(boolean autoStopStudio) {
        this.autoStopStudio = autoStopStudio;
    }

    protected void refreshControls() {
        WaxLabDevice dev = this.device;
        if (dev != null) {
            dev.refreshControls();
        }
    }

    protected synchronized boolean refreshFeatures() {
        boolean changed = false;
        int numLines = this.lines.size();
        for (int i = 0; i < numLines; ++i) {
            AbstractLine line = (AbstractLine)this.lines.get(i);
            if (!this.refreshFeatures(line)) continue;
            changed = true;
        }
        return changed;
    }

    protected synchronized boolean refreshFeatures(AbstractLine line) {
        AbstractLineFeature feature;
        SyncMediatorImpl syncMediator = this.getSyncMediatorImpl();
        LineFeature[] lineFeatures = line.getLineFeatures();
        int numFeatures = lineFeatures.length;
        HashSet<AbstractLineFeature> featureSet = (HashSet<AbstractLineFeature>)this.lineFeatureMap.get(line);
        if (featureSet == null) {
            featureSet = new HashSet<AbstractLineFeature>();
            this.lineFeatureMap.put(line, featureSet);
        }
        boolean changed = false;
        if (!featureSet.isEmpty()) {
            Iterator iter = featureSet.iterator();
            while (iter.hasNext()) {
                feature = (AbstractLineFeature)iter.next();
                int index = -1;
                for (int i = 0; i < numFeatures; ++i) {
                    if (lineFeatures[i] != feature) continue;
                    index = i;
                    break;
                }
                if (index >= 0) continue;
                iter.remove();
                if (syncMediator == null) continue;
                syncMediator.removeFeature(feature);
                changed = true;
            }
        }
        for (int i = 0; i < numFeatures; ++i) {
            LineFeature lineFeature = lineFeatures[i];
            if (lineFeature == null || !(lineFeature instanceof AbstractLineFeature) || !featureSet.add(feature = (AbstractLineFeature)lineFeature) || syncMediator == null) continue;
            syncMediator.addFeature(feature);
            changed = true;
        }
        return changed;
    }

    protected SyncMediatorImpl getSyncMediatorImpl() {
        WaxLabDevice dev = this.getWaxLabDevice();
        if (dev == null) {
            return null;
        }
        SyncMediator syncMediator = dev.getSyncMediator();
        if (syncMediator != null && syncMediator instanceof SyncMediatorImpl) {
            return (SyncMediatorImpl)syncMediator;
        }
        return null;
    }

    public void copySampleModel(SampleModel srcModel, long srcOfs, SampleModel dstModel, long dstOfs, long sampleNum, SampleBuffer copyBuf) throws IOException {
        if (sampleNum < 1L) {
            if (sampleNum < 0L) {
                throw new IllegalArgumentException("Invalid number of samples: " + sampleNum);
            }
            return;
        }
        int bufferSamples = copyBuf.getSamples();
        while (true) {
            int n = (int)Math.min((long)bufferSamples, sampleNum);
            srcModel.get(srcOfs, copyBuf, 0, n);
            dstModel.set(dstOfs, copyBuf, 0, n);
            if ((sampleNum -= (long)n) < 1L) {
                return;
            }
            srcOfs += (long)n;
            dstOfs += (long)n;
        }
    }

    protected Heap getMutationHeap() {
        return this.mutationHeap;
    }

    protected void setMutationHeap(Heap mutationHeap) {
        this.mutationHeap = mutationHeap;
    }

    public File getContentDirectory() {
        return this.contentDirectory;
    }

    public void setContentDirectory(File contentDirectory) {
        this.contentDirectory = contentDirectory;
    }

    public File makeContentDirectory() throws IOException {
        boolean success;
        File dir = this.getContentDirectory();
        if (dir == null) {
            dir = this.generateContentDirectory();
            this.setContentDirectory(dir);
        }
        if (dir.exists() && dir.isDirectory()) {
            return dir;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Creating content directory: " + dir);
        }
        if (!(success = dir.mkdirs())) {
            throw new IOException("Failed to make content directory: " + dir.getPath());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Created content directory: " + dir);
        }
        return dir;
    }

    protected File generateContentDirectory() throws IOException {
        File projectDir;
        File waxLabDir;
        File waxLabFile = this.getWaxLabFile();
        if (waxLabFile != null && (waxLabDir = waxLabFile.getParentFile()) != null) {
            File absWaxLabDir = waxLabDir.getAbsoluteFile();
            return absWaxLabDir;
        }
        Studio studio = this.device.getStudio();
        if (studio != null && (projectDir = studio.getDirectory()) != null) {
            File absProjectDir = projectDir.getAbsoluteFile();
            return absProjectDir;
        }
        File absCurrentDir = new File(".").getAbsoluteFile();
        return absCurrentDir;
    }

    public File getWaxLabFile() {
        return this.waxLabFile;
    }

    public void setWaxLabFile(File waxLabFile) {
        this.waxLabFile = waxLabFile;
    }

    protected class MediateAsync
    implements Runnable {
        protected MediateAsync() {
        }

        @Override
        public void run() {
            try {
                WaxLabImpl.this.mediateImpl();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected class RefreshMidiLightings
    implements Runnable {
        private long sleepMillis;

        public RefreshMidiLightings() {
            this(0L);
        }

        public RefreshMidiLightings(long sleepMillis) {
            this.sleepMillis = sleepMillis;
        }

        @Override
        public void run() {
            try {
                if (this.sleepMillis > 0L) {
                    Thread.sleep(this.sleepMillis);
                }
                WaxLabImpl.this.refreshMidiLightingsImpl();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected class RefreshControls
    implements Runnable {
        protected RefreshControls() {
        }

        @Override
        public void run() {
            WaxLabImpl.this.refreshControls();
        }
    }

    protected class RefreshFeatures
    implements Runnable {
        protected RefreshFeatures() {
        }

        @Override
        public void run() {
            if (WaxLabImpl.this.refreshFeatures()) {
                WaxLabImpl.this.handleFeaturesChanged();
            }
        }
    }

    protected class LineHandler
    implements LineListener {
        protected LineHandler() {
        }

        public void lineChanged(Line line) {
            WaxLabImpl.this.handleLineChanged(line);
        }

        public void featureAdded(Line line, LineFeature feature) {
            this.refreshFeaturesAsync();
        }

        public void featureRemoved(Line line, LineFeature feature) {
            this.refreshFeaturesAsync();
        }

        public void featureChanged(Line line, LineFeature feature) {
            WaxLabImpl.this.handleFeaturesChanged();
        }

        public void featureSynced(Line line, LineFeature feature) {
            WaxLabImpl.this.handleFeaturesSynced();
        }

        public void controlAdded(Line line, Control control) {
            this.refreshControlsAsync();
        }

        public void controlRemoved(Line line, Control control) {
            this.refreshControlsAsync();
        }

        public void widgetAdded(Line line, LineWidget widget) {
        }

        public void widgetRemoved(Line line, LineWidget widget) {
        }

        public void widgetChanged(Line line, LineWidget widget) {
        }

        protected void refreshFeaturesAsync() {
            try {
                WaxLabImpl.this.workerThreadPool.start((Runnable)WaxLabImpl.this.refreshFeatures);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }

        protected void refreshControlsAsync() {
            try {
                WaxLabImpl.this.workerThreadPool.start((Runnable)WaxLabImpl.this.refreshControls);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

