/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.sound.AbstractSampleModel;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.scratch.AudioScratchModel;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;

public class WaxLabLiveFeeder
extends AbstractSampleModel
implements AudioProcessor {
    private final SampleBuffer src;
    private final int size;
    private final double[] arr;
    private volatile long tail;
    private AudioScratchModel asm;

    public WaxLabLiveFeeder(SampleBuffer src, int feedBufferFrames) {
        super(src.getChannels(), src.getFrameRate());
        int srcBufSize = src.getSamples();
        int feedBufSize = feedBufferFrames * this.channels;
        if (feedBufSize < srcBufSize) {
            throw new IllegalArgumentException("Invalid scratch feed buffer size: " + feedBufSize + " < " + srcBufSize);
        }
        this.src = src;
        this.size = feedBufSize;
        this.arr = new double[feedBufSize];
        this.tail = 0L;
    }

    public synchronized void init(AudioScratchModel audioScratchModel) {
        if (this.asm != null) {
            throw new IllegalStateException("AudioScratchModel is already initialized: " + this.asm);
        }
        int chs = audioScratchModel.getChannels();
        if (chs != this.channels) {
            throw new IllegalArgumentException("Invalid scratch model channels: " + chs + " != " + this.channels);
        }
        float rate = audioScratchModel.getFrameRate();
        if (rate != this.frameRate) {
            throw new IllegalArgumentException("Invalid scratch model frame rate: " + rate + " != " + this.frameRate);
        }
        this.asm = audioScratchModel;
    }

    public void process(long time, int frames) throws AudioException {
        long t = this.tail;
        int o = (int)(t % (long)this.size);
        int n = frames * this.channels;
        if (o + n > this.size) {
            int x = this.size - o;
            this.src.get(0, this.arr, o, x);
            this.src.get(x, this.arr, 0, n - x);
        } else {
            this.src.get(0, this.arr, o, n);
        }
        this.tail += (long)n;
        t /= (long)this.channels;
        try {
            this.asm.reload(t, t + (long)frames);
        }
        catch (IOException e) {
            throw new AudioException((Throwable)e);
        }
    }

    public void shutdown() throws AudioException {
        this.asm = null;
    }

    public long getSamples() {
        return this.tail;
    }

    public boolean isEmpty() {
        return this.tail < 1L;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.flush();
    }

    public void remove(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void insert(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void clear(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public float getFloat(long i) throws IOException {
        int o = (int)(i % (long)this.size);
        return (float)this.arr[o];
    }

    public double getDouble(long i) throws IOException {
        int o = (int)(i % (long)this.size);
        return this.arr[o];
    }

    public void get(long i, double[] dst, int off, int len) {
        int o;
        int x;
        long p = this.tail - (long)this.size;
        if (i < p) {
            if (i + (long)len <= p) {
                Arrays.fill(dst, off, off + len, 0.0);
                return;
            }
            int n = (int)(p - i);
            Arrays.fill(dst, off, off + n, 0.0);
            off += n;
            len -= n;
            i = p;
        }
        if (len > (x = this.size - (o = (int)(i % (long)this.size)))) {
            System.arraycopy(this.arr, o, dst, off, x);
            System.arraycopy(this.arr, 0, dst, off + x, len - x);
        } else {
            System.arraycopy(this.arr, o, dst, off, len);
        }
    }

    public void get(long i, DoubleBuffer dst, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void get(long i, float[] dst, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void get(long i, FloatBuffer dst, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void get(long i, SampleBuffer dst, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, float v) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, double v) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, SampleBuffer src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(SampleBuffer src, int off, int len) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return super.toString() + "[source=" + this.src + ", bufferSamples=" + this.size + ", samples=" + this.tail + "]";
    }
}

