/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.waxmonster.midi.MidiContext;
import com.waxmonster.midi.MidiException;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.midi.impl.AbstractMidiEngine;
import com.waxmonster.midi.impl.MidiContextImpl;
import com.waxmonster.midi.impl.MidiEngineConfig;
import com.waxmonster.midi.impl.Wrapper;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import com.waxmonster.waxlab.impl.WaxLabMidiSyncGroup;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WaxLabMidiEngine
extends AbstractMidiEngine {
    private static final Logger logger = Logger.getLogger(WaxLabMidiEngine.class.getName());
    private WaxLabMidiSyncGroup theGroup;
    private MidiContextImpl theContext;
    private Wrapper theWrapper;

    public WaxLabMidiEngine(MidiEngineConfig config) {
        super(config);
    }

    public void prepare(MidiSyncGroup group, MidiContext context) throws MidiException {
        MidiContextImpl midiContext = this.getMidiContextImpl(context);
        if (group == null || !(group instanceof WaxLabMidiSyncGroup)) {
            throw new MidiException("Invalid MidiSyncGroup: " + group);
        }
        WaxLabMidiSyncGroup waxGroup = (WaxLabMidiSyncGroup)group;
        this.prepareWaxLabMidiEngine(waxGroup, midiContext);
    }

    public void start() throws MidiException {
        this.startWaxLabMidiEngine();
    }

    protected void activateWaxLabMidiSyncGroup(WaxLabDevice device, WaxLabMidiSyncGroup group) throws StudioException {
        Studio studio = device.getStudio();
        if (studio == null) {
            throw new StudioException("Device is not assigned to a studio: " + (Object)((Object)device));
        }
        MidiContextImpl midiContext = this.createMidiContextImpl(studio);
        boolean prepared = this.prepareWaxLabMidiEngine(group, midiContext);
        if (prepared) {
            this.startWaxLabMidiEngine();
        }
    }

    protected void deactivateWaxLabMidiSyncGroup(WaxLabDevice device, WaxLabMidiSyncGroup group) throws StudioException {
        this.stopWaxLabMidiEngine(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean prepareWaxLabMidiEngine(WaxLabMidiSyncGroup group, MidiContextImpl midiContext) throws MidiException {
        Wrapper wrapper;
        WaxLabMidiEngine waxLabMidiEngine = this;
        synchronized (waxLabMidiEngine) {
            if (this.theGroup == group) {
                return false;
            }
            if (this.theGroup != null) {
                throw new MidiException("MidiEngine is already activated: " + (Object)((Object)this));
            }
            this.theGroup = group;
            this.theContext = midiContext;
        }
        this.theWrapper = wrapper = midiContext.getGroupWrapper((MidiSyncGroup)group);
        this.prepareMidiSyncGroup(group, midiContext);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("WaxLabMidiEngine prepared: " + (Object)((Object)this));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startWaxLabMidiEngine() throws MidiException {
        WaxLabMidiSyncGroup group;
        WaxLabMidiEngine waxLabMidiEngine = this;
        synchronized (waxLabMidiEngine) {
            group = this.theGroup;
            if (group == null) {
                throw new MidiException("MidiEngine is not prepared: " + (Object)((Object)group));
            }
        }
        if (this.theWrapper.isStarted()) {
            throw new MidiException("MidiEngine is already started: " + (Object)((Object)group));
        }
        this.theWrapper.setStarted(true);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("WaxLabMidiEngine started: " + (Object)((Object)group));
        }
        this.startMidiEngines(this.theContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopWaxLabMidiEngine(WaxLabMidiSyncGroup group) throws MidiException {
        WaxLabMidiEngine waxLabMidiEngine = this;
        synchronized (waxLabMidiEngine) {
            if (this.theGroup == null) {
                return;
            }
            if (group != this.theGroup) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Ignored invalid MidiSyncGroup: " + (Object)((Object)group) + " != " + (Object)((Object)this.theGroup));
                }
                return;
            }
        }
        MidiContextImpl midiContext = this.theContext;
        if (midiContext != null) {
            this.shutdownMidiProcessors(midiContext);
        }
        WaxLabMidiEngine waxLabMidiEngine2 = this;
        synchronized (waxLabMidiEngine2) {
            this.theContext = null;
            this.theGroup = null;
            this.theWrapper = null;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("WaxLabMidiEngine stopped: " + (Object)((Object)group));
        }
    }
}

