/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiSyncGroup;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

public class WaxLabMidiProcessor
implements MidiProcessor {
    public static final MidiProcessor[] NO_PROCS = new MidiProcessor[0];
    private final WaxLabMidiSyncGroup syncGroup;
    private final WaxLabMidiInputPort port;
    private volatile MidiProcessor[] mp = NO_PROCS;
    MidiProcessor[] syncMidiProcs;

    protected WaxLabMidiProcessor(WaxLabMidiSyncGroup syncGroup, WaxLabMidiInputPort port) {
        this.syncGroup = syncGroup;
        this.port = port;
    }

    public void process(long time, int status) {
        MidiProcessor[] p = this.mp;
        int n = p.length;
        int i = 0;
        while (i < n) {
            p[i++].process(time, status);
        }
    }

    public void process(long time, int status, int data1) {
        MidiProcessor[] p = this.mp;
        int n = p.length;
        int i = 0;
        while (i < n) {
            p[i++].process(time, status, data1);
        }
    }

    public void process(long time, int status, int data1, int data2) {
        MidiProcessor[] p = this.mp;
        int n = p.length;
        int i = 0;
        while (i < n) {
            p[i++].process(time, status, data1, data2);
        }
    }

    public void process(long time, ShortMessage mc) {
        MidiProcessor[] p = this.mp;
        int n = p.length;
        int i = 0;
        while (i < n) {
            p[i++].process(time, mc);
        }
    }

    public void process(long time, SysexMessage sm) {
        MidiProcessor[] p = this.mp;
        int n = p.length;
        int i = 0;
        while (i < n) {
            p[i++].process(time, sm);
        }
    }

    public void shutdown() {
        this.mp = NO_PROCS;
        this.syncGroup.releaseMidiProcessor(this.port, this);
    }

    protected final WaxLabMidiSyncGroup getSyncGroup() {
        return this.syncGroup;
    }

    protected final WaxLabMidiInputPort getPort() {
        return this.port;
    }

    protected MidiProcessor[] getProcessors() {
        return this.mp;
    }

    protected void reset(MidiProcessor[] p) {
        if (p == null) {
            p = NO_PROCS;
        }
        this.mp = p;
    }
}

