/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.waxmonster.midi.MidiPort;
import com.waxmonster.midi.MidiSupport;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.midi.common.MidiActionProcessor;
import com.waxmonster.midi.impl.MidiEngineConfig;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.StudioException;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import com.waxmonster.waxlab.impl.WaxLabMidiEngine;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiSyncGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WaxLabMidiSupport
extends MidiSupport {
    private final WaxLabDevice waxLabDevice;
    private boolean active;
    private final List syncGroupList;
    private final Map syncGroupMap;

    public WaxLabMidiSupport(WaxLabDevice waxLabDevice) {
        this.waxLabDevice = waxLabDevice;
        this.syncGroupList = new ArrayList();
        this.syncGroupMap = new HashMap();
    }

    public synchronized void reset() {
        if (this.active) {
            this.syncGroupList.clear();
            this.syncGroupMap.clear();
            this.active = false;
        }
    }

    public synchronized MidiSyncGroup getMidiSyncGroup(MidiPort port) {
        if (!this.active) {
            this.active = true;
            this.createMidiSyncGroups();
        }
        return (MidiSyncGroup)this.syncGroupMap.get(port);
    }

    protected synchronized void createMidiSyncGroups() {
        WaxLab waxLab = this.waxLabDevice.getWaxLab();
        if (waxLab == null) {
            return;
        }
        String deviceTitleOrName = this.waxLabDevice.getTitleOrName();
        MidiEngineConfig midiEngineConfig = null;
        Port[] ports = this.waxLabDevice.getPorts();
        for (int i = 0; i < ports.length; ++i) {
            WaxLabMidiSyncGroup group;
            SyncMediator syncMediator;
            MidiActionProcessor actionProc;
            WaxLabMidiEngine midiEngine;
            String groupName;
            Port port = ports[i];
            if (port == null) continue;
            if (port instanceof WaxLabMidiInputPort) {
                WaxLabMidiInputPort inputPort = (WaxLabMidiInputPort)port;
                groupName = deviceTitleOrName + "/" + inputPort.getName();
                midiEngine = null;
                actionProc = new MidiActionProcessor(groupName);
                syncMediator = this.waxLabDevice.getSyncMediator();
                group = new WaxLabMidiSyncGroup(groupName, new WaxLabMidiInputPort[]{inputPort}, new WaxLabMidiOutputPort[0], midiEngine, actionProc, this.waxLabDevice, this, syncMediator);
                this.syncGroupList.add(group);
                this.syncGroupMap.put(inputPort, group);
                continue;
            }
            if (!(port instanceof WaxLabMidiOutputPort)) continue;
            WaxLabMidiOutputPort outputPort = (WaxLabMidiOutputPort)port;
            groupName = deviceTitleOrName + "/" + outputPort.getName();
            if (midiEngineConfig == null) {
                midiEngineConfig = this.waxLabDevice.getMidiEngineConfig();
            }
            midiEngine = new WaxLabMidiEngine(midiEngineConfig);
            actionProc = null;
            syncMediator = this.waxLabDevice.getSyncMediator();
            group = new WaxLabMidiSyncGroup(groupName, new WaxLabMidiInputPort[0], new WaxLabMidiOutputPort[]{outputPort}, midiEngine, actionProc, this.waxLabDevice, this, syncMediator);
            this.syncGroupList.add(group);
            this.syncGroupMap.put(outputPort, group);
        }
    }

    protected synchronized void activateWaxLabMidiEngines(WaxLabDevice device) throws StudioException {
        if (device != this.waxLabDevice) {
            throw new StudioException("Invalid device: " + (Object)((Object)device) + " != " + (Object)((Object)this.waxLabDevice));
        }
        if (!this.active) {
            this.active = true;
            this.createMidiSyncGroups();
        }
        for (WaxLabMidiSyncGroup group : this.syncGroupList) {
            WaxLabMidiEngine engine = group.getLabMidiEngine();
            if (engine == null) continue;
            engine.activateWaxLabMidiSyncGroup(device, group);
        }
    }

    protected synchronized void deactivateWaxLabMidiEngines(WaxLabDevice device) throws StudioException {
        if (device != this.waxLabDevice) {
            throw new StudioException("Invalid device: " + (Object)((Object)device) + " != " + (Object)((Object)this.waxLabDevice));
        }
        if (!this.active) {
            return;
        }
        for (WaxLabMidiSyncGroup group : this.syncGroupList) {
            WaxLabMidiEngine engine = group.getLabMidiEngine();
            if (engine == null) continue;
            engine.deactivateWaxLabMidiSyncGroup(device, group);
        }
    }
}

