/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.waxmonster.midi.MidiEngine;
import com.waxmonster.midi.MidiException;
import com.waxmonster.midi.MidiInputPort;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.midi.common.MidiActionProcessor;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.impl.MidiPlayer;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import com.waxmonster.waxlab.impl.WaxLabMidiEngine;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiProcessor;
import com.waxmonster.waxlab.impl.WaxLabMidiSupport;

public class WaxLabMidiSyncGroup
extends MidiSyncGroup {
    protected static final MidiProcessor[] NO_PROCS = new MidiProcessor[0];
    protected static final MidiPlayer[] NO_PLAYERS = new MidiPlayer[0];
    private final WaxLabMidiSupport support;
    private final WaxLabDevice device;
    private final WaxLabMidiInputPort[] waxLabMidiInputPorts;
    private final WaxLabMidiOutputPort[] waxLabMidiOutputPorts;
    private final WaxLabMidiEngine waxLabMidiEngine;
    private final WaxLab waxLab;
    private final SyncMediator syncMediator;

    protected WaxLabMidiSyncGroup(String name, WaxLabMidiInputPort[] inputPorts, WaxLabMidiOutputPort[] outputPorts, WaxLabMidiEngine midiEngine, MidiActionProcessor actionProc, WaxLabDevice device, WaxLabMidiSupport support, SyncMediator syncMediator) {
        super(name, (MidiInputPort[])inputPorts, (MidiOutputPort[])outputPorts, (MidiEngine)midiEngine);
        this.support = support;
        this.device = device;
        this.waxLabMidiInputPorts = inputPorts;
        this.waxLabMidiOutputPorts = outputPorts;
        this.waxLabMidiEngine = midiEngine;
        this.waxLab = device.getWaxLab();
        this.syncMediator = syncMediator;
    }

    protected final WaxLabDevice getDevice() {
        return this.device;
    }

    protected final WaxLab getWaxLab() {
        return this.waxLab;
    }

    protected final WaxLabMidiSupport getSupport() {
        return this.support;
    }

    protected final WaxLabMidiEngine getLabMidiEngine() {
        return this.waxLabMidiEngine;
    }

    protected final SyncMediator getSyncMediator() {
        return this.syncMediator;
    }

    protected WaxLabMidiInputPort getWaxLabMidiInputPort(int index) {
        return this.waxLabMidiInputPorts[index];
    }

    protected WaxLabMidiOutputPort getWaxLabMidiOutputPort(int index) {
        return this.waxLabMidiOutputPorts[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetMidiProcessors(MidiProcessor[] targets) throws MidiException {
        int num = Math.min(targets.length, this.waxLabMidiOutputPorts.length);
        for (int i = 0; i < num; ++i) {
            WaxLabMidiOutputPort port = this.waxLabMidiOutputPorts[i];
            MidiProcessor target = targets[i];
            if (port == null) continue;
            WaxLabMidiOutputPort waxLabMidiOutputPort = port;
            synchronized (waxLabMidiOutputPort) {
                MidiProcessor oldTarget = port.getMidiProcessor();
                if (target != oldTarget) {
                    if (oldTarget != null) {
                        this.syncMediator.removeWaxLabMidiOutputPort(port);
                    }
                    port.setMidiProcessor(target);
                    this.waxLab.handleMidiTargetChanged((MidiOutputPort)port);
                    if (target != null) {
                        this.syncMediator.addWaxLabMidiOutputPort(port);
                    }
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiProcessor createMidiProcessor(MidiInputPort port) throws MidiException {
        if (port instanceof WaxLabMidiInputPort) {
            WaxLabMidiProcessor midiProc;
            WaxLabMidiInputPort inputPort;
            WaxLabMidiInputPort waxLabMidiInputPort = inputPort = (WaxLabMidiInputPort)port;
            synchronized (waxLabMidiInputPort) {
                midiProc = inputPort.getWaxLabMidiProcessor();
                if (midiProc != null) {
                    throw new MidiException("WaxLabMidiProcessor is already initialized for port: " + port);
                }
                midiProc = new WaxLabMidiProcessor(this, inputPort);
                inputPort.setWaxLabMidiProcessor(midiProc);
                MidiActionProcessor waxLabMidiActionProc = inputPort.syncMidiActionProc;
                if (waxLabMidiActionProc != null && waxLabMidiActionProc.getMidiMappingCount() > 0) {
                    midiProc.reset(new MidiProcessor[]{waxLabMidiActionProc});
                }
            }
            this.syncMediator.addWaxLabMidiInputPort(inputPort);
            return midiProc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseMidiProcessor(WaxLabMidiInputPort inputPort, WaxLabMidiProcessor proc) {
        WaxLabMidiInputPort waxLabMidiInputPort = inputPort;
        synchronized (waxLabMidiInputPort) {
            if (inputPort.getWaxLabMidiProcessor() != proc) {
                return;
            }
            inputPort.setWaxLabMidiProcessor(null);
        }
        this.syncMediator.removeWaxLabMidiInputPort(inputPort);
    }
}

