/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Clock;
import com.spacekiller.util.Resource;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.Timer;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.LockSupport;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.DefaultMediaMarker;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.media.MediaPlayerContext;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.control.AbstractDoubleControl;
import com.spacekiller.util.media.control.AbstractEnumControl;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.sound.DoubleArraySampleModel;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleModel;
import com.spacekiller.util.thread.DefaultThreadPool;
import com.spacekiller.util.thread.ThreadPool;
import com.waxmonster.audio.AudioException;
import com.waxmonster.fader.FaderConfig;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.midi.common.AsyncMidiProcessor;
import com.waxmonster.midi.common.MidiActionProcessor;
import com.waxmonster.scratch.AudioScratchModel;
import com.waxmonster.scratch.AudioScratchPlayer;
import com.waxmonster.scratch.AudioSlice;
import com.waxmonster.scratch.PitchDeck;
import com.waxmonster.scratch.impl.AbstractAudioScratchPlayer;
import com.waxmonster.scratch.impl.AbstractAudioSlice;
import com.waxmonster.scratch.impl.CubicAudioScratchModel;
import com.waxmonster.scratch.impl.RealAudioScratchPlayer;
import com.waxmonster.studio.Studio;
import com.waxmonster.timecode.TimecodeDecoder;
import com.waxmonster.timecode.TimecodeFormat;
import com.waxmonster.timecode.TimecodeManager;
import com.waxmonster.waxlab.BeatJumpControl;
import com.waxmonster.waxlab.BeatSliceControl;
import com.waxmonster.waxlab.CuePoint;
import com.waxmonster.waxlab.EditorLineConfig;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.PitchBpmControl;
import com.waxmonster.waxlab.PitchDeckControl;
import com.waxmonster.waxlab.PitchFactorControl;
import com.waxmonster.waxlab.PitchModeControl;
import com.waxmonster.waxlab.PitchTuneControl;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.ScratchDeckListener;
import com.waxmonster.waxlab.ScratchLine;
import com.waxmonster.waxlab.ScratchLineConfig;
import com.waxmonster.waxlab.ScratchModeControl;
import com.waxmonster.waxlab.TimecodeFormatControl;
import com.waxmonster.waxlab.TimecodeLineConfig;
import com.waxmonster.waxlab.VolumeControl;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.WaxLabPreferences;
import com.waxmonster.waxlab.impl.AbstractPitchBpmControl;
import com.waxmonster.waxlab.impl.AbstractPitchFactorControl;
import com.waxmonster.waxlab.impl.AbstractPitchModeControl;
import com.waxmonster.waxlab.impl.AbstractPitchTuneControl;
import com.waxmonster.waxlab.impl.AbstractScratchLine;
import com.waxmonster.waxlab.impl.AbstractScratchModeControl;
import com.waxmonster.waxlab.impl.AbstractTimecodeFormatControl;
import com.waxmonster.waxlab.impl.ScratchManager;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import com.waxmonster.waxlab.impl.WaxLabImpl;
import com.waxmonster.waxlab.impl.WaxLabLiveFeeder;
import com.waxmonster.waxlab.impl.WaxLabLiveFeederResource;
import com.waxmonster.waxlab.impl.WaxLabPitchDeck;
import com.waxmonster.waxlab.impl.WaxLabScratchDeckMediator;
import com.waxmonster.waxlab.impl.WaxLabScratchDeckMidiSender;
import com.waxmonster.waxlab.util.LineWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WaxLabScratchDeck
implements ScratchDeck {
    private static final Logger logger = Logger.getLogger(WaxLabScratchDeck.class.getName());
    public static final WaxLabPitchDeck NULL_DECK = null;
    protected final WaxLabDevice device;
    protected final WaxLab waxLab;
    protected final WaxLabImpl waxLabImpl;
    protected final Clock clock;
    protected final ScratchLine scratchLine;
    protected final WaxLabScratchDeckMediator deckMediator;
    protected final ScratchManager scratchManager;
    private ScratchDeckListener[] listeners;
    protected TimecodeDecoder timecodeDecoder;
    protected AbstractAudioScratchPlayer scratchPlayer;
    protected RealAudioScratchPlayer realScratchPlayer;
    private int channels;
    private double frameRate;
    private MidiProcessor targetMidiProcessor;
    private WaxLabScratchDeckMidiSender midiSender;
    private MidiActionProcessor midiActionProcessor;
    private String name;
    private AudioScratchModel newScratchModel;
    private AudioScratchModel scratchModel;
    private WaxLabLiveFeeder scratchFeeder;
    private volatile double feedMPS;
    private MediaPlayerContext playerContext;
    private MediaEntry mediaEntry;
    private Resource scratchResource;
    private MediaEntry newMediaEntry;
    private Resource newScratchResource;
    private List audioModelList;
    private List scratchModelList;
    protected int unusedModelDelayMillis = 10000;
    private UnusedModelReleaser unusedModelReleaser;
    private Timer unusedModelReleaseTimer;
    private int cuePointCount;
    private QPoint[] cuePoints;
    private QPoint[] sortedCuePoints;
    private QPointComparator qPointComparator;
    private float resampleRate;
    private double spin = 1.0;
    private boolean censor;
    private double censorPosition;
    private boolean goofyMode;
    private boolean bpmAvailable;
    private volatile double jumpBeats;
    private boolean slipMode;
    private boolean slipping;
    private long slipTime;
    private double slipOfs;
    private double slipAnc;
    private double slipVel;
    private final Object loopLock = new Object();
    private AbstractLoop firstLoop;
    private AbstractLoop lastLoop;
    private LoopRoll[] loopRolls;
    private AutoLoop[] autoLoops;
    private AutoLoop autoLoop;
    protected boolean slicerLoopMode;
    protected int sliceParts;
    protected int sliceLastPart;
    protected int sliceCount;
    protected int sliceLastIndex;
    protected double sliceFirstOffset;
    protected double sliceBeats;
    protected double sliceLength;
    protected double slicePartLen;
    protected int slicePartNum;
    protected SlicerLoop slicerLoop;
    protected SlicerAudioSlice slicerSlice;
    protected BeatSlice[] beatSlices;
    private List scratchControls;
    protected final PostFaderVolumeControlImpl postFaderVolumeControl;
    protected final PreFaderVolumeControlImpl preFaderVolumeControl;
    protected final TimecodeFormatControlImpl timecodeFormatControl;
    protected final ScratchModeControlImpl scratchModeControl;
    protected final PitchModeControlImpl pitchModeControl;
    protected final PitchFactorControlImpl pitchFactorControl;
    protected final PitchTuneControlImpl pitchTuneControl;
    protected final PitchBpmControlImpl pitchBpmControl;
    protected final PitchDeckControlImpl pitchDeckControl;
    protected final BeatJumpControlImpl beatJumpControl;
    protected final BeatSliceControlImpl beatSliceControl;
    protected final RefreshDeckLightings refreshDeckLightings = new RefreshDeckLightings();
    private double initPostFaderVolume = -1.0;
    private double initPreFaderVolume = -1.0;
    private FaderConfig[] initFaderConfigArray;
    private String initTimecodeFormatName;
    private String initScratchMode;
    private String initPitchMode;
    private double initPitchBPM;
    private PitchDeck initPitchDeck;
    private double initPitchMin;
    private double initPitchMax;
    private double initPitchFactor;
    private double initJumpBeats;
    private double initSliceBeats;

    public WaxLabScratchDeck(WaxLabDevice device, AbstractScratchLine scratchLine, WaxLabScratchDeckMediator deckMediator, Clock clock, LockSupport lockSupport, LockFactory lockFactory, ThreadManager threadManager) {
        if (scratchLine == null) {
            throw new NullPointerException("scratchLine");
        }
        if (device == null) {
            throw new NullPointerException("device");
        }
        this.device = device;
        this.waxLab = device.getWaxLab();
        if (this.waxLab == null) {
            throw new NullPointerException("waxLab");
        }
        this.waxLabImpl = device.getWaxLabImpl();
        if (this.waxLabImpl == null) {
            throw new NullPointerException("waxLabImpl");
        }
        this.clock = clock;
        this.scratchLine = scratchLine;
        this.deckMediator = deckMediator;
        this.name = scratchLine.getName();
        this.listeners = new ScratchDeckListener[0];
        this.scratchManager = scratchLine.getScratchManager();
        this.audioModelList = new ArrayList();
        this.scratchModelList = new ArrayList();
        this.unusedModelReleaser = new UnusedModelReleaser();
        this.sortedCuePoints = new QPoint[0];
        this.qPointComparator = new QPointComparator();
        this.scratchControls = new ArrayList();
        this.postFaderVolumeControl = new PostFaderVolumeControlImpl();
        this.scratchControls.add(this.postFaderVolumeControl);
        this.preFaderVolumeControl = new PreFaderVolumeControlImpl();
        this.scratchControls.add(this.preFaderVolumeControl);
        this.timecodeFormatControl = new TimecodeFormatControlImpl();
        this.scratchControls.add(this.timecodeFormatControl);
        this.scratchModeControl = new ScratchModeControlImpl();
        this.scratchControls.add(this.scratchModeControl);
        this.pitchModeControl = new PitchModeControlImpl();
        this.scratchControls.add(this.pitchModeControl);
        this.pitchFactorControl = new PitchFactorControlImpl();
        this.scratchControls.add(this.pitchFactorControl);
        this.pitchTuneControl = new PitchTuneControlImpl();
        this.scratchControls.add(this.pitchTuneControl);
        this.pitchBpmControl = new PitchBpmControlImpl();
        this.scratchControls.add(this.pitchBpmControl);
        this.pitchDeckControl = new PitchDeckControlImpl();
        this.scratchControls.add(this.pitchDeckControl);
        this.beatJumpControl = new BeatJumpControlImpl();
        this.scratchControls.add(this.beatJumpControl);
        this.beatSliceControl = new BeatSliceControlImpl();
        this.scratchControls.add(this.beatSliceControl);
        this.loopRolls = new LoopRoll[]{new LoopRoll(0, 0.0625), new LoopRoll(1, 0.125), new LoopRoll(2, 0.25), new LoopRoll(3, 0.5), new LoopRoll(4, 1.0)};
        this.autoLoops = new AutoLoop[]{new AutoLoop(0, 1.0), new AutoLoop(1, 2.0), new AutoLoop(2, 4.0), new AutoLoop(3, 8.0), new AutoLoop(4, 16.0), new AutoLoop(5, 32.0)};
        this.slicerSlice = new SlicerAudioSlice();
        this.slicerLoop = new SlicerLoop(this.slicerSlice);
        int threadPrio = 5;
        String threadName = "AsyncMidiProcessor-" + this.name;
        boolean fair = false;
        AsyncMidiProcessor asyncMidiProcessor = new AsyncMidiProcessor(lockSupport, lockFactory, fair, threadManager, threadPrio, threadName);
        this.midiSender = new WaxLabScratchDeckMidiSender(this, asyncMidiProcessor);
        this.registerScratchDeckListener(this.midiSender);
        this.setName(this.name);
        this.setBeatSliceCount(8);
        this.setCuePointCount(8);
    }

    protected final WaxLabDevice getDevice() {
        return this.device;
    }

    protected final WaxLab getWaxLab() {
        return this.waxLab;
    }

    protected final WaxLabImpl getWaxLabImpl() {
        return this.waxLabImpl;
    }

    public final ScratchLine getScratchLine() {
        return this.scratchLine;
    }

    protected final ScratchManager getScratchManager() {
        return this.scratchManager;
    }

    protected TimecodeFormat[] getTimecodeFormats() {
        TimecodeManager tcMan;
        WaxLabImpl lab = this.waxLabImpl;
        if (lab != null && (tcMan = lab.getTimecodeManager()) != null) {
            return tcMan.getTimecodeFormats();
        }
        return new TimecodeFormat[0];
    }

    public synchronized void registerScratchDeckListener(ScratchDeckListener l) {
        int oldCount = this.listeners.length;
        ScratchDeckListener[] arr = new ScratchDeckListener[oldCount + 1];
        System.arraycopy(this.listeners, 0, arr, 0, oldCount);
        arr[oldCount] = l;
        this.listeners = arr;
    }

    public synchronized void unregisterScratchDeckListener(ScratchDeckListener l) {
        int oldCount = this.listeners.length;
        int index = -1;
        for (int i = 0; i < oldCount; ++i) {
            if (this.listeners[i] != l) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return;
        }
        ScratchDeckListener[] arr = new ScratchDeckListener[oldCount - 1];
        System.arraycopy(this.listeners, 0, arr, 0, index);
        System.arraycopy(this.listeners, index + 1, arr, index, oldCount - index - 1);
        this.listeners = arr;
    }

    public synchronized void applyScratchLineConfig(ScratchLineConfig config, boolean force) {
        PitchDeck pitchDeck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("applyScratchLineConfig: " + config + ", force=" + force);
        }
        double postFaderVolume = 1.0;
        double preFaderVolume = 1.0;
        Object[] faderConfigArray = null;
        String timecodeFormatName = null;
        String scratchMode = "Relative";
        String pitchMode = "Normal";
        double pitchBPM = 0.0;
        ScratchLine pitchLine = null;
        double jumpBeats = 1.0;
        double sliceBeats = 1.0;
        double pitchMin = config.getPitchMin();
        double pitchMax = config.getPitchMax();
        double pitchFactor = config.getPitchFactor();
        if (config instanceof TimecodeLineConfig) {
            TimecodeLineConfig tlc = (TimecodeLineConfig)config;
            postFaderVolume = tlc.getPostFaderVolume();
            preFaderVolume = tlc.getPreFaderVolume();
            faderConfigArray = tlc.getAudioFaderConfigs();
            timecodeFormatName = tlc.getTimecodeFormatName();
            scratchMode = tlc.getScratchMode();
            pitchMode = tlc.getPitchMode();
            pitchBPM = tlc.getPitchBPM();
            pitchLine = tlc.getPitchLine();
            jumpBeats = tlc.getJumpBeats();
            sliceBeats = tlc.getSliceBeats();
        } else if (config instanceof EditorLineConfig) {
            EditorLineConfig elc = (EditorLineConfig)config;
            postFaderVolume = elc.getVolumeFactor();
        }
        float resampleRate = config.getResampleRate();
        this.setResampleRate(resampleRate);
        int cuePointCount = config.getCuePointCount();
        this.setCuePointCount(cuePointCount);
        int beatSliceCount = config.getBeatSliceCount();
        this.setBeatSliceCount(beatSliceCount);
        if (force || !Arrays.equals(this.initFaderConfigArray, faderConfigArray)) {
            this.initFaderConfigArray = faderConfigArray;
            this.scratchManager.setFaderConfigArray((FaderConfig[])faderConfigArray);
        }
        if (force || this.initPostFaderVolume != postFaderVolume) {
            this.initPostFaderVolume = postFaderVolume;
            this.postFaderVolumeControl.setDouble(postFaderVolume);
        }
        if (force || this.initPreFaderVolume != preFaderVolume) {
            this.initPreFaderVolume = preFaderVolume;
            this.preFaderVolumeControl.setDouble(preFaderVolume);
        }
        if (force || !this.equalsString(this.initScratchMode, scratchMode)) {
            this.initScratchMode = scratchMode;
            if (this.scratchModeControl.isValueSupported(scratchMode)) {
                this.scratchModeControl.setValue(scratchMode);
            } else {
                logger.warning("Invalid scratchMode: " + scratchMode);
            }
        }
        if (force || this.initJumpBeats != jumpBeats) {
            this.initJumpBeats = jumpBeats;
            this.beatJumpControl.setDouble(jumpBeats);
        }
        if (force || this.initSliceBeats != sliceBeats) {
            this.initSliceBeats = sliceBeats;
            this.beatSliceControl.setDouble(sliceBeats);
        }
        if (force || this.initPitchMin != pitchMin || this.initPitchMax != pitchMax) {
            this.initPitchMin = pitchMin;
            this.initPitchMax = pitchMax;
            this.pitchFactorControl.setPitchRange(pitchMin, pitchMax);
        }
        if (force || this.initPitchFactor != pitchFactor) {
            this.pitchFactorControl.setDouble(pitchFactor);
            this.pitchTuneControl.setDouble(0.0);
        }
        if (force || this.initPitchBPM != pitchBPM) {
            this.initPitchBPM = pitchBPM;
            this.pitchBpmControl.setDouble(pitchBPM);
        }
        PitchDeck pitchDeck2 = pitchDeck = pitchLine == null ? null : pitchLine.getPitchDeck();
        if (force || this.initPitchDeck != pitchDeck) {
            this.initPitchDeck = pitchDeck;
            if (pitchDeck != this.pitchDeckControl.getPitchDeck()) {
                this.pitchDeckControl.refreshDecks();
                if (this.pitchDeckControl.isValueSupported(pitchDeck)) {
                    this.pitchDeckControl.setValue(pitchDeck);
                } else {
                    logger.warning("Invalid pitchDeck: " + pitchDeck);
                }
            }
        }
        if (force || !this.equalsString(this.initPitchMode, pitchMode)) {
            this.initPitchMode = pitchMode;
            if (this.pitchModeControl.isValueSupported(pitchMode)) {
                this.pitchModeControl.setValue(pitchMode);
            } else {
                logger.warning("Invalid pitchMode: " + pitchMode);
            }
        }
        Resource lineScratchResource = this.scratchLine.getScratchAudioResource();
        if (!(!force && lineScratchResource == this.scratchResource || lineScratchResource != null && lineScratchResource.equals(this.scratchResource))) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ScratchResource changed: " + lineScratchResource + " != " + this.scratchResource);
            }
            MediaEntry lineScratchMediaEntry = this.scratchLine.getScratchMediaEntry();
            try {
                this.loadScratchResource(lineScratchResource, lineScratchMediaEntry);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (force || !this.equalsString(this.initTimecodeFormatName, timecodeFormatName)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("TimecodeFormat changed: " + timecodeFormatName + " != " + this.initTimecodeFormatName);
            }
            this.initTimecodeFormatName = timecodeFormatName;
            this.timecodeFormatControl.refreshTimecodeFormats();
            TimecodeFormat timecodeFormat = this.timecodeFormatControl.getTimecodeFormat(timecodeFormatName);
            if (this.timecodeFormatControl.isValueSupported(timecodeFormat)) {
                this.timecodeFormatControl.setValue(timecodeFormat);
            } else {
                logger.warning("Invalid timecodeFormat: " + timecodeFormatName + " -> " + timecodeFormat);
            }
        }
    }

    private boolean equalsString(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a != null) {
            return a.equals(b);
        }
        if (b != null) {
            return b.equals(a);
        }
        return false;
    }

    protected AudioFormat getPreferredAudioFormat(Resource resource, MediaEntry entry, int channels, float defaultRate) {
        float sampleRate = 0.0f;
        float resampleRate = this.resampleRate;
        if (Float.isNaN(resampleRate)) {
            float entryRate;
            AudioEntry ae;
            AudioEntry audioEntry = ae = entry == null ? null : entry.getAudioEntry();
            if (ae != null && (entryRate = ae.getFrameRate()) > 0.0f) {
                sampleRate = entryRate;
            }
        } else if (resampleRate > 0.0f) {
            sampleRate = resampleRate;
        }
        if (sampleRate <= 0.0f) {
            sampleRate = defaultRate;
        }
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        boolean bigEndian = false;
        float frameRate = sampleRate;
        int sampleSizeInBits = -1;
        int frameSize = -1;
        AudioFormat prefFormat = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, bigEndian);
        return prefFormat;
    }

    public float getResampleRate() {
        return this.resampleRate;
    }

    public void setResampleRate(float resampleRate) {
        this.resampleRate = resampleRate;
    }

    public MediaPlayerContext getPlayerContext() {
        return this.playerContext;
    }

    public void setPlayerContext(MediaPlayerContext playerContext) {
        this.playerContext = playerContext;
    }

    public MediaEntry getMediaEntry() {
        return this.mediaEntry;
    }

    public Resource getScratchResource() {
        return this.scratchResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MediaEntry loadScratchResource(Resource resource, MediaEntry mediaEntry) throws IOException, AudioException, UnsupportedAudioFileException, InterruptedException {
        MediaEntry entry;
        AbstractAudioScratchPlayer scratchPlayer = this.scratchPlayer;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("loadScratchResource: scratchPlayer=" + scratchPlayer + ", resource=" + resource + ", mediaEntry=" + mediaEntry);
        }
        WaxLabScratchDeck waxLabScratchDeck = this;
        synchronized (waxLabScratchDeck) {
            this.newScratchResource = resource;
            this.newMediaEntry = mediaEntry;
        }
        boolean liveFeed = false;
        if (resource != null && resource instanceof WaxLabLiveFeederResource) {
            liveFeed = true;
        }
        boolean wasLiveFeed = this.scratchManager.isLiveFeed();
        this.scratchManager.setScratchResource(resource);
        if (liveFeed) {
            if (!wasLiveFeed) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Need to mediate for starting live-feed...");
                }
                this.scratchManager.setLiveFeed(true);
            }
            return mediaEntry;
        }
        if (!liveFeed && (entry = this.lookupScratchMediaEntry(resource, mediaEntry)) != null) {
            mediaEntry = entry;
            WaxLabScratchDeck waxLabScratchDeck2 = this;
            synchronized (waxLabScratchDeck2) {
                this.newScratchResource = resource;
                this.newMediaEntry = mediaEntry;
            }
        }
        if (wasLiveFeed) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Need to mediate for stopping live-feed...");
            }
            this.scratchManager.setLiveFeed(false);
            return mediaEntry;
        }
        if (scratchPlayer != null) {
            boolean batchMode;
            float playerRate;
            int playerChannels = scratchPlayer.getChannels();
            AudioScratchModel newScratchModel = this.prepareScratchModel(resource, mediaEntry, playerChannels, playerRate = scratchPlayer.getFrameRate(), batchMode = this.scratchManager.isBatchMode());
            if (newScratchModel == null) {
                return null;
            }
            this.fireScratchResourceWillChange();
            WaxLabScratchDeck waxLabScratchDeck3 = this;
            synchronized (waxLabScratchDeck3) {
                this.scratchResource = resource;
                this.mediaEntry = mediaEntry;
                this.newScratchResource = null;
                this.newMediaEntry = null;
                this.setScratchModel(newScratchModel);
            }
            this.closeUnusedModelsLater();
        }
        return mediaEntry;
    }

    protected MediaEntry lookupScratchMediaEntry(Resource resource, MediaEntry mediaEntry) throws IOException {
        int flags;
        double duration;
        if (resource == null) {
            return null;
        }
        if (mediaEntry != null && (duration = mediaEntry.getDuration()) >= 0.0) {
            return mediaEntry;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Lazy lookup media entry: " + resource);
        }
        if ((mediaEntry = this.waxLab.getMediaEntry(resource)) == null) {
            return null;
        }
        duration = mediaEntry.getDuration();
        if (duration >= 0.0) {
            return mediaEntry;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Lazy analyze media resource: " + resource);
        }
        if ((mediaEntry = this.waxLab.getMediaEntry(resource, flags = 24)) == null) {
            return null;
        }
        duration = mediaEntry.getDuration();
        if (duration >= 0.0) {
            return mediaEntry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AudioScratchModel setupScratchModel(int playerChannels, float playerRate, boolean batchMode) throws IOException, AudioException, UnsupportedAudioFileException, InterruptedException {
        MediaEntry mediaEntry;
        Resource resource;
        WaxLabScratchDeck waxLabScratchDeck = this;
        synchronized (waxLabScratchDeck) {
            resource = this.newScratchResource;
            mediaEntry = this.newMediaEntry;
            if (resource == null) {
                AudioScratchModel scratchModel = this.scratchModel;
                if (scratchModel != null) {
                    return scratchModel;
                }
                resource = this.scratchResource;
                mediaEntry = this.mediaEntry;
            }
        }
        AudioScratchModel newScratchModel = this.prepareScratchModel(resource, mediaEntry, playerChannels, playerRate, batchMode);
        this.fireScratchResourceWillChange();
        WaxLabScratchDeck waxLabScratchDeck2 = this;
        synchronized (waxLabScratchDeck2) {
            this.scratchResource = resource;
            this.mediaEntry = mediaEntry;
            this.newScratchResource = null;
            this.newMediaEntry = null;
        }
        return newScratchModel;
    }

    protected WaxLabLiveFeeder createScratchFeeder(SampleBuffer src) throws AudioException {
        int scratchBufFrames;
        int srcFrames;
        float srcRate;
        WaxLabPreferences waxLabPrefs = this.waxLab.getWaxLabPreferences();
        int feederBufferMillis = waxLabPrefs.getScratchFeederBufferMillis();
        int feedBufferFrames = (int)((double)((float)feederBufferMillis * (srcRate = src.getFrameRate())) / 1000.0);
        if (feedBufferFrames < (srcFrames = src.getSamples() / src.getChannels())) {
            feedBufferFrames = srcFrames;
        }
        if (feedBufferFrames < (scratchBufFrames = this.computeScratchBufferFrames(waxLabPrefs, srcRate))) {
            feedBufferFrames = scratchBufFrames;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Creating scratch feeder: src=" + src + ", feedBufferFrames=" + feedBufferFrames);
        }
        return new WaxLabLiveFeeder(src, feedBufferFrames);
    }

    protected AudioScratchModel setupScratchModel(WaxLabLiveFeeder liveFeeder, int playerChannels, float playerRate, boolean batchMode) throws IOException, AudioException, InterruptedException {
        MediaEntry mediaEntry = null;
        double needleFramePos = 0.0;
        AudioScratchModel newScratchModel = this.prepareScratchModel(batchMode, (SampleModel)liveFeeder, mediaEntry, needleFramePos);
        return newScratchModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AudioScratchModel prepareScratchModel(Resource resource, MediaEntry mediaEntry, int playerChannels, float playerRate, boolean batchMode) throws IOException, AudioException, UnsupportedAudioFileException, InterruptedException {
        Object audioModel;
        Object seekableModel;
        AudioFormat prefFormat = this.getPreferredAudioFormat(resource, mediaEntry, playerChannels, playerRate);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(" - Creating seekable audio model: resource=" + resource + ", prefFormat=" + prefFormat);
        }
        if (resource != null) {
            seekableModel = this.waxLab.createSeekableAudioModel(resource, mediaEntry, prefFormat);
            if (seekableModel != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(" - Created seekable audio model: " + seekableModel);
                }
                audioModel = seekableModel;
            } else {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning(" - Failed to create seekable audio model: resource=" + resource + ", format=" + prefFormat);
                }
                audioModel = null;
            }
        } else {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(" - No audio resource specified. Using dummy audio model.");
            }
            audioModel = null;
        }
        if (audioModel == null) {
            audioModel = new DoubleArraySampleModel(playerChannels, playerRate, new double[0], 0);
        }
        seekableModel = this;
        synchronized (seekableModel) {
            this.audioModelList.add(audioModel);
        }
        double needlePos = 0.0;
        float audioModelRate = audioModel.getFrameRate();
        double needleFramePos = needlePos * (double)audioModelRate / 1000.0;
        AudioScratchModel newScratchModel = this.prepareScratchModel(batchMode, (SampleModel)audioModel, mediaEntry, needleFramePos);
        return newScratchModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AudioScratchModel prepareScratchModel(boolean batchMode, SampleModel audioModel, MediaEntry mediaEntry, double needleFramePos) throws IOException, AudioException, InterruptedException {
        int asyncSleepMillis;
        WaxLabPreferences waxLabPrefs = this.waxLab.getWaxLabPreferences();
        ThreadPool loaderThreadPool = this.waxLabImpl.getLoaderThreadPool();
        float audioModelRate = audioModel.getFrameRate();
        int scratchBufFrames = this.computeScratchBufferFrames(waxLabPrefs, audioModelRate);
        int scratchBufCount = waxLabPrefs.getScratchBufferCount();
        if (scratchBufCount < 0) {
            scratchBufCount = 7;
        }
        if (scratchBufCount < 5) {
            scratchBufCount = 5;
        }
        if ((asyncSleepMillis = waxLabPrefs.getScratchLoaderIntervalMillis()) < 1) {
            asyncSleepMillis = 1;
        }
        double bpm = 0.0;
        double duration = -1.0;
        if (mediaEntry != null) {
            bpm = this.getMediaBPM(mediaEntry);
            double seconds = mediaEntry.getDuration();
            if (seconds >= 0.0) {
                duration = seconds * 1000.0;
            }
        }
        CubicAudioScratchModel audioScratchModel = new CubicAudioScratchModel(audioModel, needleFramePos, bpm, duration, scratchBufFrames, scratchBufCount, loaderThreadPool, batchMode, asyncSleepMillis);
        WaxLabScratchDeck waxLabScratchDeck = this;
        synchronized (waxLabScratchDeck) {
            this.newScratchModel = audioScratchModel;
            this.scratchModelList.add(audioScratchModel);
        }
        return audioScratchModel;
    }

    protected int computeScratchBufferFrames(WaxLabPreferences waxLabConfig, float audioModelRate) {
        if (waxLabConfig == null || audioModelRate <= 0.0f) {
            return -1;
        }
        int scratchBufMillis = waxLabConfig.getScratchBufferMillis();
        int scratchBufFrames = (int)((double)scratchBufMillis * (double)audioModelRate / 1000.0);
        if (scratchBufFrames < 16) {
            scratchBufFrames = 16;
        }
        return scratchBufFrames;
    }

    protected void fireScratchResourceWillChange() {
        this.stopBeatSlicer();
        this.stopLoopRolls();
        this.stopAutoLoops();
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].scratchResourceWillChange((ScratchDeck)this);
        }
    }

    protected void fireScratchResourceHasChanged() {
        this.refreshCuePoints();
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].scratchResourceHasChanged((ScratchDeck)this);
        }
    }

    protected double getMediaBPM(MediaEntry me) {
        AudioEntry ae;
        if (me != null && (ae = me.getAudioEntry()) != null) {
            return ae.getBpm();
        }
        return 0.0;
    }

    public AudioScratchModel getScratchModel() {
        return this.scratchModel;
    }

    protected synchronized void setScratchModel(AudioScratchModel scratchModel) {
        AudioScratchModel oldScratchModel = this.scratchModel;
        if (scratchModel == oldScratchModel) {
            return;
        }
        this.scratchModel = scratchModel;
        this.newScratchModel = null;
        AbstractAudioScratchPlayer scratchPlayer = this.scratchPlayer;
        if (scratchPlayer != null) {
            double ofs = scratchPlayer.getOffset();
            if (scratchModel != null) {
                scratchModel.setAnchor(ofs);
            }
            scratchPlayer.setAudioScratchModel(scratchModel);
        }
        this.checkBpmAvailable();
        this.fireScratchResourceHasChanged();
    }

    public WaxLabLiveFeeder getScratchFeeder() {
        return this.scratchFeeder;
    }

    public synchronized void setScratchFeeder(WaxLabLiveFeeder scratchFeeder) {
        if (this.scratchFeeder == scratchFeeder) {
            return;
        }
        if (scratchFeeder != null) {
            this.feedMPS = 1000.0 / (double)(scratchFeeder.getFrameRate() * (float)scratchFeeder.getChannels());
        }
        this.scratchFeeder = scratchFeeder;
        this.checkBpmAvailable();
    }

    public TimecodeDecoder getTimecodeDecoder() {
        return this.timecodeDecoder;
    }

    public synchronized void setTimecodeDecoder(TimecodeDecoder timecodeDecoder) {
        if (this.timecodeDecoder == timecodeDecoder) {
            return;
        }
        this.timecodeDecoder = timecodeDecoder;
        this.scratchModeControl.applyValue(this.scratchModeControl.getValue());
    }

    public AudioScratchPlayer getScratchPlayer() {
        return this.scratchPlayer;
    }

    public synchronized void setScratchPlayer(AbstractAudioScratchPlayer scratchPlayer) {
        if (this.scratchPlayer == scratchPlayer) {
            return;
        }
        RealAudioScratchPlayer realPlayer = scratchPlayer != null && scratchPlayer instanceof RealAudioScratchPlayer ? (RealAudioScratchPlayer)scratchPlayer : null;
        this.scratchPlayer = scratchPlayer;
        this.realScratchPlayer = realPlayer;
        if (scratchPlayer != null) {
            this.channels = scratchPlayer.getChannels();
            this.frameRate = scratchPlayer.getFrameRate();
            this.postFaderVolumeControl.applyDouble(this.postFaderVolumeControl.getDouble());
            this.preFaderVolumeControl.applyDouble(this.preFaderVolumeControl.getDouble());
            this.applyCustomPitch();
            this.applySecondaryPitch();
            this.pitchBpmControl.applyDouble(this.pitchBpmControl.getDouble());
            this.pitchDeckControl.applyValue(this.pitchDeckControl.getValue());
            this.pitchModeControl.applyValue(this.pitchModeControl.getValue());
            if (this.deckMediator != null) {
                this.deckMediator.registerScratchDeck(this);
            }
        } else {
            if (this.deckMediator != null) {
                this.deckMediator.unregisterScratchDeck(this);
            }
            if (this.scratchModel != null) {
                this.scratchModel = null;
                this.closeUnusedModelsLater();
            }
            if (this.newScratchModel != null) {
                this.newScratchModel = null;
                this.closeUnusedModelsLater();
            }
        }
        LineWrapper lineWrapper = null;
        if (this.scratchLine instanceof AbstractScratchLine) {
            AbstractScratchLine asl = (AbstractScratchLine)this.scratchLine;
            lineWrapper = asl.getWrapper();
        }
        if (lineWrapper != null) {
            lineWrapper.setScratchPlayer((AudioScratchPlayer)scratchPlayer);
        }
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].scratchPlayerChanged((ScratchDeck)this);
        }
    }

    public int getChannels() {
        return this.channels;
    }

    protected synchronized void releaseScratchPlayer(AbstractAudioScratchPlayer scratchPlayer) {
        if (scratchPlayer == null) {
            return;
        }
        if (scratchPlayer == this.scratchPlayer) {
            this.setScratchPlayer(null);
            this.setTargetMidiProcessor(null);
        }
    }

    protected void closeUnusedModelsLater() {
        if (this.unusedModelReleaseTimer == null) {
            Studio studio;
            Studio studio2 = studio = this.device == null ? null : this.device.getStudio();
            if (studio != null) {
                this.unusedModelReleaseTimer = studio.createTimer((Runnable)this.unusedModelReleaser, this.unusedModelDelayMillis);
                this.unusedModelReleaseTimer.setRepeats(false);
            }
        }
        if (this.unusedModelReleaseTimer != null) {
            this.unusedModelReleaseTimer.stop();
            this.unusedModelReleaseTimer.setDelay(this.unusedModelDelayMillis);
            this.unusedModelReleaseTimer.start();
        } else {
            this.closeUnusedModels();
        }
    }

    protected void closeUnusedModels() {
        this.closeUnusedScratchModels();
        this.closeUnusedAudioModels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeUnusedScratchModels() {
        int i = 0;
        while (true) {
            block12: {
                AudioScratchModel scratchModel;
                WaxLabScratchDeck waxLabScratchDeck = this;
                synchronized (waxLabScratchDeck) {
                    if (i >= this.scratchModelList.size()) {
                        break;
                    }
                    scratchModel = (AudioScratchModel)this.scratchModelList.get(i);
                    if (scratchModel == this.scratchModel) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(" - ScratchModel still active: " + scratchModel);
                        }
                        break block12;
                    }
                    if (scratchModel == this.newScratchModel) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(" - ScratchModel still pending: " + scratchModel);
                        }
                        break block12;
                    }
                    this.scratchModelList.remove(i);
                    --i;
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(" - Closing unused scratch model: " + scratchModel);
                }
                try {
                    scratchModel.close();
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeUnusedAudioModels() {
        int i = 0;
        while (true) {
            block12: {
                SampleModel audioModel;
                WaxLabScratchDeck waxLabScratchDeck = this;
                synchronized (waxLabScratchDeck) {
                    if (i >= this.audioModelList.size()) {
                        break;
                    }
                    audioModel = (SampleModel)this.audioModelList.get(i);
                    AudioScratchModel asm = this.scratchModel;
                    if (asm != null && asm.getAudioModel() == audioModel) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(" - AudioModel still active: " + audioModel);
                        }
                        break block12;
                    }
                    asm = this.newScratchModel;
                    if (asm != null && asm.getAudioModel() == audioModel) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(" - AudioModel still pending: " + audioModel);
                        }
                        break block12;
                    }
                    this.audioModelList.remove(i);
                    --i;
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(" - Closing unused audio model: " + audioModel);
                }
                try {
                    audioModel.close();
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            ++i;
        }
    }

    protected QPoint getQPoint(int index) {
        QPoint[] arr = this.cuePoints;
        if (index >= 0 && index < arr.length) {
            return arr[index];
        }
        return null;
    }

    public CuePoint getCuePointAt(int index) {
        QPoint[] arr = this.cuePoints;
        if (index >= 0 && index < arr.length) {
            return arr[index];
        }
        return null;
    }

    public CuePoint getSortedCuePointAt(int index) {
        QPoint[] arr = this.sortedCuePoints;
        if (index >= 0 && index < arr.length) {
            return arr[index];
        }
        return null;
    }

    public boolean removeCuePoint(int cuePointIndex) {
        QPoint qp = this.getQPoint(cuePointIndex);
        if (qp == null) {
            return false;
        }
        double cp = qp.pos;
        if (Double.isNaN(cp)) {
            return true;
        }
        this.applyCuePointPosition(qp, cuePointIndex, Double.NaN);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.getName() + ": removeCuePoint: #" + cuePointIndex);
        }
        return true;
    }

    public boolean jumpCuePoint(int cuePointIndex) {
        QPoint qp = this.getQPoint(cuePointIndex);
        if (qp == null) {
            return false;
        }
        return this.jumpCuePoint(qp);
    }

    protected boolean jumpCuePoint(QPoint qp) {
        AbstractAudioScratchPlayer scratchPlayer;
        double pos = qp.pos;
        if (Double.isNaN(pos)) {
            return false;
        }
        if (qp.pressed) {
            return false;
        }
        qp.pressed = true;
        if (this.slipMode && !this.slipping) {
            this.slippingBegin();
        }
        if ((scratchPlayer = this.scratchPlayer) == null) {
            return false;
        }
        double ofs = scratchPlayer.getOffset();
        double ori = scratchPlayer.getPosition();
        this.scratchModel.setOrigin(pos);
        this.scratchModel.setAnchor(ofs - pos);
        scratchPlayer.setOrigin(ori);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.getName() + ": jumpCuePoint: #" + qp.index + ", pos=" + pos);
        }
        return true;
    }

    public boolean jumpOrSetCuePoint(int cuePointIndex) {
        QPoint qp = this.getQPoint(cuePointIndex);
        if (qp == null) {
            return false;
        }
        double pos = qp.pos;
        if (Double.isNaN(pos)) {
            this.setCuePointPosition(cuePointIndex);
        } else {
            this.jumpCuePoint(qp);
        }
        return true;
    }

    public void cuePointReleased(int cuePointIndex) {
        QPoint qp = this.getQPoint(cuePointIndex);
        if (qp == null) {
            return;
        }
        if (qp.pressed) {
            qp.pressed = false;
            if (this.slipMode && this.slipping) {
                this.slippingEnded();
            }
        }
    }

    public boolean setCuePointPosition(int cuePointIndex) {
        AbstractAudioScratchPlayer scratchPlayer = this.scratchPlayer;
        if (scratchPlayer == null) {
            return false;
        }
        WaxLabLiveFeeder feeder = this.scratchFeeder;
        double pos = feeder == null ? scratchPlayer.getOffset() - this.scratchModel.getAnchor() : (double)feeder.getSamples() * this.feedMPS;
        return this.setCuePointPosition(cuePointIndex, pos);
    }

    public boolean setCuePointPosition(int cuePointIndex, double position) {
        QPoint qp = this.getQPoint(cuePointIndex);
        if (qp == null) {
            return false;
        }
        this.applyCuePointPosition(qp, cuePointIndex, position);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.getName() + ": setCuePoint: #" + cuePointIndex + ", pos=" + position);
        }
        return true;
    }

    public double getCuePointPosition(int cuePointIndex) {
        QPoint qp = this.getQPoint(cuePointIndex);
        if (qp == null) {
            return Double.NaN;
        }
        return qp.pos;
    }

    public boolean isLiveFeed() {
        WaxLabLiveFeeder feeder = this.scratchFeeder;
        return feeder != null;
    }

    public boolean jumpLiveFeedHead() {
        AbstractAudioScratchPlayer scratchPlayer = this.scratchPlayer;
        if (scratchPlayer == null) {
            return false;
        }
        WaxLabLiveFeeder feeder = this.scratchFeeder;
        if (feeder == null) {
            return false;
        }
        double cp = (double)feeder.getSamples() * this.feedMPS;
        double ofs = scratchPlayer.getOffset();
        this.scratchModel.setAnchor(ofs - cp);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.getName() + ": jumpLiveFeedHead: ofs=" + ofs + ", head=" + cp);
        }
        return true;
    }

    public boolean instantDouble() {
        WaxLabPitchDeck pitchDeck = this.pitchDeckControl.getWaxLabPitchDeck();
        if (pitchDeck == null) {
            return false;
        }
        WaxLabScratchDeck partnerDeck = pitchDeck.getScratchDeck();
        if (partnerDeck == null) {
            return false;
        }
        AudioScratchPlayer partnerPlayer = partnerDeck.getScratchPlayer();
        if (partnerPlayer == null) {
            return false;
        }
        ScratchLine partnerLine = partnerDeck.getScratchLine();
        if (partnerLine == null) {
            return false;
        }
        Resource resource = partnerLine.getScratchAudioResource();
        MediaEntry entry = partnerLine.getScratchMediaEntry();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.getName() + ": instantDouble: partnerDeck=" + partnerDeck.getName() + ", resource=" + resource + ", entry=" + entry);
        }
        this.scratchLine.setScratchResource(resource, entry);
        this.scratchLine.loadScratchResource(resource, entry);
        AbstractAudioScratchPlayer scratchPlayer = this.scratchPlayer;
        if (scratchPlayer == null) {
            return false;
        }
        AudioScratchPlayer pasp = partnerDeck.getScratchPlayer();
        AudioScratchModel pasm = partnerDeck.getScratchModel();
        double pos = pasp.getOffset() - pasm.getAnchor();
        double ofs = scratchPlayer.getOffset();
        double ori = scratchPlayer.getPosition();
        this.scratchModel.setOrigin(pos);
        this.scratchModel.setAnchor(ofs - pos);
        scratchPlayer.setOrigin(ori);
        return true;
    }

    public boolean beatJumpForward() {
        return this.beatJump(this.jumpBeats);
    }

    public boolean beatJumpBackward() {
        return this.beatJump(-this.jumpBeats);
    }

    public boolean beatJump(double beats) {
        AudioScratchModel asm = this.scratchModel;
        if (asm == null) {
            return false;
        }
        double bpm = asm.getBPM();
        if (bpm > 0.0) {
            double delta = beats * 60000.0 / bpm;
            asm.setAnchor(asm.getAnchor() - delta);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.getName() + ": beatJump: bpm=" + bpm + ", beats=" + beats + ", delta=" + delta);
            }
            return true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.getName() + ": beatJump: BPM unknown!");
        }
        return false;
    }

    public boolean isBeatJumpEnabled() {
        return this.bpmAvailable;
    }

    protected synchronized void checkBpmAvailable() {
        double bpm;
        boolean bpmAvailable = false;
        if (this.scratchModel != null && (bpm = this.scratchModel.getBPM()) > 0.0) {
            bpmAvailable = true;
        }
        if (this.bpmAvailable == bpmAvailable) {
            return;
        }
        this.bpmAvailable = bpmAvailable;
        if (bpmAvailable) {
            this.fireBeatSlicerEnabled();
        } else {
            this.fireBeatSlicerDisabled();
        }
        if (bpmAvailable || this.scratchFeeder != null) {
            this.fireBeatJumpEnabled();
        } else {
            this.fireBeatJumpDisabled();
        }
        this.refreshBpmAvailableLightings();
    }

    public int getBeatSliceCount() {
        return this.sliceCount;
    }

    public synchronized void setBeatSliceCount(int beatSliceCount) {
        if (this.sliceCount == beatSliceCount) {
            return;
        }
        this.stopBeatSlicer();
        BeatSlice[] sliceArray = new BeatSlice[beatSliceCount];
        for (int i = 0; i < beatSliceCount; ++i) {
            sliceArray[i] = new BeatSlice();
        }
        this.beatSlices = sliceArray;
        this.sliceCount = beatSliceCount;
        this.sliceLastIndex = this.sliceCount - 1;
        this.sliceParts = 16;
        this.sliceLastPart = this.sliceParts - 1;
        this.refreshMidiTriggers();
    }

    public int getCuePointCount() {
        return this.cuePointCount;
    }

    public synchronized void setCuePointCount(int cuePointCount) {
        int oldCount = this.cuePointCount;
        if (oldCount == cuePointCount) {
            return;
        }
        QPoint[] newArr = new QPoint[cuePointCount];
        QPoint[] newSorted = new QPoint[cuePointCount];
        int num = Math.min(oldCount, cuePointCount);
        if (num > 0) {
            System.arraycopy(this.cuePoints, 0, newArr, 0, num);
            System.arraycopy(this.sortedCuePoints, 0, newSorted, 0, num);
        }
        for (int i = num; i < cuePointCount; ++i) {
            int index = i;
            newArr[i] = new QPoint(index);
            newSorted[i] = newArr[i];
        }
        this.cuePoints = newArr;
        this.cuePointCount = cuePointCount;
        this.sortedCuePoints = newSorted;
        this.refreshCuePoints();
        this.refreshMidiTriggers();
    }

    public void refreshCuePoints() {
        QPoint qp;
        int i;
        QPoint[] arr;
        MediaMarker[] markers = null;
        MediaEntry me = this.mediaEntry;
        if (me != null) {
            markers = me.getMarkers();
        }
        int num = (arr = this.cuePoints) == null ? 0 : arr.length;
        for (i = 0; i < num; ++i) {
            qp = arr[i];
            qp.marker = null;
            qp.newPos = Double.NaN;
        }
        if (markers != null) {
            for (MediaMarker marker : markers) {
                int idx;
                if (!this.isCuePointMarker(marker) || (idx = marker.getIndex()) < 0 || idx >= num) continue;
                qp = arr[idx];
                if (!Double.isNaN(qp.newPos)) continue;
                qp.newPos = marker.getPosition();
                if (!(marker instanceof DefaultMediaMarker)) continue;
                qp.marker = (DefaultMediaMarker)marker;
            }
        }
        for (i = 0; i < num; ++i) {
            qp = arr[i];
            this.applyQPointInternal(qp, i, qp.newPos);
        }
    }

    public int getLoopRollCount() {
        return this.loopRolls.length;
    }

    public int getAutoLoopCount() {
        return this.autoLoops.length;
    }

    protected MidiActionProcessor createMidiActionProcessor() {
        return new MidiActionProcessor(this.name);
    }

    protected synchronized MidiActionProcessor getMidiActionProcessor() {
        if (this.midiActionProcessor == null) {
            this.setMidiActionProcessor(this.createMidiActionProcessor());
        }
        return this.midiActionProcessor;
    }

    protected synchronized void setMidiActionProcessor(MidiActionProcessor midiActionProcessor) {
        this.midiActionProcessor = midiActionProcessor;
        this.refreshMidiMappings();
    }

    public synchronized void refreshMidiMappings() {
        MidiActionProcessor proc = this.midiActionProcessor;
        if (proc == null) {
            return;
        }
        proc.reset(this.scratchLine.getMidiActions(), this.scratchLine.getMidiMappings());
        proc.validate();
    }

    public synchronized void refreshMidiTriggers() {
        MidiTrigger[] triggers = this.scratchLine.getMidiTriggers();
        this.midiSender.setMidiTriggers(triggers);
        this.refreshDeckLightings();
    }

    protected boolean isCuePointMarker(MediaMarker marker) {
        if (marker != null) {
            switch (marker.getType()) {
                case 3: {
                    return true;
                }
                case 9: {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyCuePointPosition(QPoint qp, int index, double position) {
        MediaMarker[] markers;
        if (!this.applyQPointInternal(qp, index, position)) {
            return;
        }
        MediaEntry me = this.mediaEntry;
        MutableMediaEntry mme = null;
        if (me != null && me instanceof MutableMediaEntry) {
            mme = (MutableMediaEntry)me;
        }
        DefaultMediaMarker marker = qp.marker;
        if (Double.isNaN(position)) {
            if (marker == null) {
                return;
            }
            qp.marker = null;
            if (mme == null) {
                return;
            }
            MutableMediaEntry mutableMediaEntry = mme;
            synchronized (mutableMediaEntry) {
                markers = mme.getMarkers();
                int oldCount = markers == null ? 0 : markers.length;
                boolean found = false;
                for (int i = 0; i < oldCount; ++i) {
                    if (markers[i] != marker) continue;
                    MediaMarker[] arr = new MediaMarker[oldCount - 1];
                    if (i > 0) {
                        System.arraycopy(markers, 0, arr, 0, i);
                    }
                    if (i + 1 < oldCount) {
                        System.arraycopy(markers, i + 1, arr, i, oldCount - i - 1);
                    }
                    markers = arr;
                    mme.setMarkers(arr);
                    found = true;
                    break;
                }
                if (!found) {
                    return;
                }
            }
        } else if (marker == null) {
            int type = 3;
            String name = null;
            qp.marker = marker = new DefaultMediaMarker(type, index, position, name);
            if (mme == null) {
                return;
            }
            MutableMediaEntry mutableMediaEntry = mme;
            synchronized (mutableMediaEntry) {
                MediaMarker[] old = mme.getMarkers();
                int oldCount = old == null ? 0 : old.length;
                MediaMarker[] arr = new MediaMarker[oldCount + 1];
                if (oldCount > 0) {
                    System.arraycopy(old, 0, arr, 0, oldCount);
                }
                arr[oldCount] = marker;
                markers = arr;
                mme.setMarkers(arr);
            }
        } else {
            marker.setPosition(position);
            if (mme == null) {
                return;
            }
            markers = mme.getMarkers();
        }
        try {
            MediaPlayerContext playerContext = this.playerContext;
            if (playerContext != null) {
                playerContext.updateMediaMarkers(mme, markers);
            } else {
                this.waxLab.updateMediaMarkers(mme, markers);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (this.deckMediator != null) {
            this.deckMediator.mediaEntryModified(this, (MediaEntry)mme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean applyQPointInternal(QPoint qp, int index, double pos) {
        boolean wasNaN;
        boolean isNaN;
        WaxLabScratchDeck waxLabScratchDeck = this;
        synchronized (waxLabScratchDeck) {
            double old = qp.pos;
            if (pos == old) {
                return false;
            }
            isNaN = Double.isNaN(pos);
            wasNaN = Double.isNaN(old);
            if (isNaN && wasNaN) {
                return false;
            }
            qp.pos = pos;
            Arrays.sort(this.sortedCuePoints, this.qPointComparator);
        }
        if (isNaN != wasNaN) {
            if (wasNaN) {
                this.fireCuePointAdded(index);
            } else {
                this.fireCuePointRemoved(index);
            }
        } else {
            this.fireCuePointChanged(index);
        }
        return true;
    }

    public MidiProcessor getTargetMidiProcessor() {
        return this.targetMidiProcessor;
    }

    public synchronized void setTargetMidiProcessor(MidiProcessor targetMidiProcessor) {
        MidiProcessor oldProc = this.targetMidiProcessor;
        if (oldProc == targetMidiProcessor) {
            return;
        }
        if (targetMidiProcessor == null) {
            this.midiSender.deckStopped(this);
        }
        this.targetMidiProcessor = targetMidiProcessor;
        this.midiSender.setTargetMidiProcessor(targetMidiProcessor);
        if (targetMidiProcessor != null) {
            try {
                DefaultThreadPool workerThreadPool = this.waxLabImpl.getWorkerThreadPool();
                workerThreadPool.start((Runnable)this.refreshDeckLightings);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (oldProc != null) {
            oldProc.shutdown();
        }
        if (targetMidiProcessor == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("refresh lighting(s) of other deck(s): " + this);
            }
            if (this.deckMediator != null) {
                this.deckMediator.refreshOtherDecksLightings(this);
            }
        }
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setName(String deckName) {
        this.name = deckName;
        String deckPrefix = "" + deckName + "-";
        this.postFaderVolumeControl.setName(deckPrefix + "PostFaderVolume");
        this.preFaderVolumeControl.setName(deckPrefix + "PreFaderVolume");
        this.timecodeFormatControl.setName(deckPrefix + "TimecodeFormat");
        this.scratchModeControl.setName(deckPrefix + "ScratchMode");
        this.pitchModeControl.setName(deckPrefix + "PitchMode");
        this.pitchFactorControl.setName(deckPrefix + "PitchFactor");
        this.pitchTuneControl.setName(deckPrefix + "PitchTune");
        this.pitchBpmControl.setName(deckPrefix + "PitchBpm");
        this.pitchDeckControl.setName(deckPrefix + "PitchDeck");
        this.beatJumpControl.setName(deckPrefix + "BeatJump");
        this.beatSliceControl.setName(deckPrefix + "BeatSlice");
    }

    public synchronized Control[] getScratchControls() {
        return this.scratchControls.toArray(new Control[this.scratchControls.size()]);
    }

    public VolumeControl getPostFaderVolumeControl() {
        return this.postFaderVolumeControl;
    }

    public VolumeControl getPreFaderVolumeControl() {
        return this.preFaderVolumeControl;
    }

    public TimecodeFormatControl getTimecodeFormatControl() {
        return this.timecodeFormatControl;
    }

    public ScratchModeControl getScratchModeControl() {
        return this.scratchModeControl;
    }

    public PitchModeControl getPitchModeControl() {
        return this.pitchModeControl;
    }

    public PitchFactorControl getPitchFactorControl() {
        return this.pitchFactorControl;
    }

    public PitchTuneControl getPitchTuneControl() {
        return this.pitchTuneControl;
    }

    public PitchBpmControl getPitchBpmControl() {
        return this.pitchBpmControl;
    }

    public PitchDeckControl getPitchDeckControl() {
        return this.pitchDeckControl;
    }

    public BeatJumpControl getBeatJumpControl() {
        return this.beatJumpControl;
    }

    public BeatSliceControl getBeatSliceControl() {
        return this.beatSliceControl;
    }

    protected void applyCustomPitch() {
        AbstractAudioScratchPlayer scratchPlayer = this.scratchPlayer;
        if (scratchPlayer == null) {
            return;
        }
        double factor = this.pitchFactorControl.getDouble();
        double tune = this.pitchTuneControl.getDouble();
        double v = factor + tune / 100.0;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.getName() + ": applyCustomPitch: " + v);
        }
        scratchPlayer.setPitchCustom(v);
        this.firePrimaryPitchChanged(v);
    }

    protected void applySecondaryPitch() {
        AbstractAudioScratchPlayer scratchPlayer = this.scratchPlayer;
        if (scratchPlayer == null) {
            return;
        }
        double v = this.spin;
        if (this.censor || this.goofyMode) {
            v = -v;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.getName() + ": applySecondaryPitch: " + v);
        }
        scratchPlayer.setSecondaryPitch(v);
        this.fireSecondaryPitchChanged(v);
    }

    protected void fireDeckStarted() {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].deckStarted((ScratchDeck)this);
        }
    }

    protected void fireDeckStopped() {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].deckStopped((ScratchDeck)this);
        }
    }

    protected void fireScratchModeChanged(int mode) {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].scratchModeChanged((ScratchDeck)this, mode);
        }
    }

    protected void firePitchModeChanged(int mode) {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].pitchModeChanged((ScratchDeck)this, mode);
        }
    }

    protected void firePrimaryPitchChanged(double pitch) {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].primaryPitchChanged((ScratchDeck)this, pitch);
        }
    }

    protected void fireSecondaryPitchChanged(double pitch) {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].secondaryPitchChanged((ScratchDeck)this, pitch);
        }
    }

    protected void fireSlipModeEnabled() {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].slipModeEnabled((ScratchDeck)this);
        }
    }

    protected void fireSlipModeDisabled() {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].slipModeDisabled((ScratchDeck)this);
        }
    }

    protected void fireBeatJumpEnabled() {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].beatJumpEnabled((ScratchDeck)this);
        }
    }

    protected void fireBeatJumpDisabled() {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].beatJumpDisabled((ScratchDeck)this);
        }
    }

    protected void fireJumpBeatsChanged() {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].jumpBeatsChanged((ScratchDeck)this);
        }
    }

    protected void fireCensorActivated() {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].censorActivated((ScratchDeck)this);
        }
    }

    protected void fireCensorDeactivated() {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].censorDeactivated((ScratchDeck)this);
        }
    }

    protected void fireGoofyModeActivated() {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].goofyModeActivated((ScratchDeck)this);
        }
    }

    protected void fireGoofyModeDeactivated() {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].goofyModeDeactivated((ScratchDeck)this);
        }
    }

    protected void fireCuePointAdded(int index) {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].cuePointAdded((ScratchDeck)this, index);
        }
    }

    protected void fireCuePointRemoved(int index) {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].cuePointRemoved((ScratchDeck)this, index);
        }
    }

    protected void fireCuePointChanged(int index) {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].cuePointChanged((ScratchDeck)this, index);
        }
    }

    protected void fireLoopRollStarted(int index) {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].loopRollStarted((ScratchDeck)this, index);
        }
    }

    protected void fireLoopRollStopped(int index) {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].loopRollStopped((ScratchDeck)this, index);
        }
    }

    protected void fireAutoLoopStarted(int index) {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].autoLoopStarted((ScratchDeck)this, index);
        }
    }

    protected void fireAutoLoopStopped(int index) {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].autoLoopStopped((ScratchDeck)this, index);
        }
    }

    protected void fireSliceBeatsChanged() {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].sliceBeatsChanged((ScratchDeck)this);
        }
    }

    protected void fireBeatSlicerEnabled() {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].beatSlicerEnabled((ScratchDeck)this);
        }
    }

    protected void fireBeatSlicerDisabled() {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].beatSlicerDisabled((ScratchDeck)this);
        }
    }

    protected void fireBeatSlicerStarted() {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].beatSlicerStarted((ScratchDeck)this);
        }
    }

    protected void fireBeatSlicerStopped() {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].beatSlicerStopped((ScratchDeck)this);
        }
    }

    protected void fireBeatSlicerLoopModeChanged(boolean loopMode) {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].beatSlicerLoopModeChanged((ScratchDeck)this, loopMode);
        }
    }

    protected void fireBeatSliceActivated(int index) {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].beatSliceActivated((ScratchDeck)this, index);
        }
    }

    protected void fireBeatSliceEntered(int index) {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].beatSliceEntered((ScratchDeck)this, index);
        }
    }

    protected void fireBeatSliceExited(int index) {
        ScratchDeckListener[] arr = this.listeners;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].beatSliceExited((ScratchDeck)this, index);
        }
    }

    public void refreshDeckLightings() {
        AutoLoop[] autos;
        LoopRoll[] rolls;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.getName() + ": refreshDeckLightings: " + this);
        }
        this.midiSender.deckStarted(this);
        QPoint[] qps = this.cuePoints;
        if (qps != null) {
            int num = qps.length;
            for (int i = 0; i < num; ++i) {
                if (qps[i].isSet()) {
                    this.midiSender.cuePointAdded(this, i);
                    continue;
                }
                this.midiSender.cuePointRemoved(this, i);
            }
        }
        if ((rolls = this.loopRolls) != null) {
            int num = rolls.length;
            for (int i = 0; i < num; ++i) {
                if (rolls[i].active) {
                    this.midiSender.loopRollStarted(this, i);
                    continue;
                }
                this.midiSender.loopRollStopped(this, i);
            }
        }
        if ((autos = this.autoLoops) != null) {
            int num = autos.length;
            for (int i = 0; i < num; ++i) {
                if (autos[i].active) {
                    this.midiSender.autoLoopStarted(this, i);
                    continue;
                }
                this.midiSender.autoLoopStopped(this, i);
            }
        }
        if (this.slicerLoop.active) {
            this.midiSender.beatSlicerStarted(this);
        } else {
            this.midiSender.beatSlicerStopped(this);
        }
        this.midiSender.beatSlicerLoopModeChanged(this, this.slicerLoopMode);
        BeatSlice[] slices = this.beatSlices;
        if (slices != null) {
            int num = slices.length;
            block7: for (int i = 0; i < num; ++i) {
                switch (slices[i].state) {
                    case 2: {
                        this.midiSender.beatSliceActivated(this, i);
                        continue block7;
                    }
                    case 1: {
                        this.midiSender.beatSliceEntered(this, i);
                        continue block7;
                    }
                    default: {
                        this.midiSender.beatSliceExited(this, i);
                    }
                }
            }
        }
        this.refreshShiftModesLightings();
        this.refreshScratchModeLightings();
        this.refreshPitchModeLightings();
    }

    protected void refreshShiftModesLightings() {
        this.refreshSlipModeEnabledLightings();
        this.refreshBpmAvailableLightings();
        this.refreshCensorGoofyActivatedLightings();
    }

    protected void refreshSlipModeEnabledLightings() {
        if (this.slipMode) {
            this.midiSender.slipModeEnabled(this);
        } else {
            this.midiSender.slipModeDisabled(this);
        }
    }

    protected void refreshBpmAvailableLightings() {
        if (this.bpmAvailable || this.scratchFeeder != null) {
            this.midiSender.beatJumpEnabled(this);
            this.midiSender.beatSlicerEnabled(this);
        } else {
            this.midiSender.beatJumpDisabled(this);
            this.midiSender.beatSlicerDisabled(this);
        }
    }

    protected void refreshCensorGoofyActivatedLightings() {
        if (this.censor) {
            this.midiSender.censorActivated(this);
        }
        if (this.goofyMode) {
            this.midiSender.goofyModeActivated(this);
        }
        if (!this.censor) {
            this.midiSender.censorDeactivated(this);
        }
        if (!this.goofyMode) {
            this.midiSender.goofyModeDeactivated(this);
        }
    }

    protected void refreshPitchModeLightings() {
        AbstractAudioScratchPlayer scratchPlayer = this.scratchPlayer;
        int mode = scratchPlayer != null ? scratchPlayer.getPitchMode() : 0;
        this.midiSender.pitchModeChanged(this, mode);
    }

    protected void refreshScratchModeLightings() {
        TimecodeDecoder decoder = this.timecodeDecoder;
        if (decoder == null) {
            return;
        }
        int mode = decoder.getMode();
        this.midiSender.scratchModeChanged(this, mode);
    }

    public double getSpin() {
        return this.spin;
    }

    public void setSpin(double spin) {
        if (this.spin == spin) {
            return;
        }
        this.spin = spin;
        this.applySecondaryPitch();
    }

    public boolean isCensor() {
        return this.censor;
    }

    public synchronized void setCensor(boolean censor) {
        if (this.censor == censor) {
            return;
        }
        this.censor = censor;
        AbstractAudioScratchPlayer scratchPlayer = this.scratchPlayer;
        if (scratchPlayer == null) {
            return;
        }
        if (censor) {
            this.censorPosition = scratchPlayer.getOffset() - this.scratchModel.getAnchor();
            this.applySecondaryPitch();
            this.fireCensorActivated();
        } else {
            this.applySecondaryPitch();
            double ofs = scratchPlayer.getOffset();
            double anc = ofs + ofs - this.censorPosition - this.censorPosition - this.scratchModel.getAnchor();
            this.scratchModel.setAnchor(anc);
            this.fireCensorDeactivated();
        }
    }

    public boolean isGoofyMode() {
        return this.goofyMode;
    }

    public synchronized void setGoofyMode(boolean goofyMode) {
        if (this.goofyMode == goofyMode) {
            return;
        }
        this.goofyMode = goofyMode;
        this.applySecondaryPitch();
        if (goofyMode) {
            this.fireGoofyModeActivated();
        } else {
            this.fireGoofyModeDeactivated();
        }
    }

    public AudioSlice getLoopSlice() {
        AbstractLoop loop = this.lastLoop;
        return loop == null ? null : loop.slice;
    }

    protected void applyLoop(AbstractLoop loop) {
        AbstractAudioScratchPlayer scratchPlayer = this.scratchPlayer;
        if (scratchPlayer == null) {
            return;
        }
        if (loop != null) {
            scratchPlayer.setSlice((AudioSlice)loop.slice);
        } else {
            scratchPlayer.setSlice(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean startLoop(AbstractLoop loop) {
        Object object = this.loopLock;
        synchronized (object) {
            if (loop == this.lastLoop) {
                return false;
            }
            if (loop.active) {
                loop.unlink();
                loop.link();
            } else {
                loop.link();
            }
            if (this.slipMode && !this.slipping) {
                this.slippingBegin();
            }
            this.applyLoop(loop);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.getName() + ": loop started: " + loop);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean stopLoop(AbstractLoop loop) {
        Object object = this.loopLock;
        synchronized (object) {
            if (!loop.active) {
                return false;
            }
            if (loop == this.lastLoop) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.getName() + ": stop active loop: " + loop + ", prev=" + loop.prev);
                }
                loop.unlink();
                AbstractLoop newLoop = this.lastLoop;
                this.applyLoop(newLoop);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.getName() + ": loop stopped: " + loop + ", newLoop=" + newLoop);
                }
                if (newLoop == null && this.slipMode && this.slipping) {
                    this.slippingEnded();
                }
            } else {
                loop.unlink();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.getName() + ": loop stopped: " + loop);
                }
            }
        }
        return true;
    }

    protected boolean startBeatLoop(AbstractLoop loop, double beats) {
        double bpm;
        AbstractAudioScratchPlayer scratchPlayer = this.scratchPlayer;
        if (scratchPlayer == null) {
            return false;
        }
        if (beats > 0.0 && (bpm = this.scratchModel.getBPM()) > 0.0) {
            LoopAudioSlice slice = loop.slice;
            if (!loop.active) {
                AbstractLoop prev = this.lastLoop;
                if (prev == null) {
                    slice.setOffset(scratchPlayer.getOffset());
                } else {
                    slice.setOffset(prev.slice.getOffset());
                }
            }
            slice.setLength(beats * 60000.0 / bpm);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.getName() + ": startBeatLoop: beats=" + beats + ", loopMillis=" + slice.getLength() + ", loopStart=" + slice.getOffset());
            }
            return this.startLoop(loop);
        }
        return false;
    }

    public boolean startLoopRoll(int loopRollIndex) {
        LoopRoll loopRoll;
        LoopRoll[] arr = this.loopRolls;
        if (loopRollIndex >= 0 && loopRollIndex < arr.length && (loopRoll = arr[loopRollIndex]) != null && this.startBeatLoop(loopRoll, loopRoll.beats)) {
            this.fireLoopRollStarted(loopRollIndex);
            return true;
        }
        return false;
    }

    public boolean stopLoopRoll(int loopRollIndex) {
        LoopRoll loopRoll;
        LoopRoll[] arr = this.loopRolls;
        if (loopRollIndex >= 0 && loopRollIndex < arr.length && (loopRoll = arr[loopRollIndex]) != null && this.stopLoop(loopRoll)) {
            this.fireLoopRollStopped(loopRollIndex);
            return true;
        }
        return false;
    }

    public boolean stopLoopRolls() {
        boolean result = false;
        LoopRoll[] arr = this.loopRolls;
        for (int i = 0; i < arr.length; ++i) {
            LoopRoll loopRoll = arr[i];
            if (loopRoll == null || !this.stopLoop(loopRoll)) continue;
            this.fireLoopRollStopped(loopRoll.index);
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startAutoLoop(int autoLoopIndex) {
        AutoLoop theLoop;
        AutoLoop[] arr = this.autoLoops;
        if (autoLoopIndex >= 0 && autoLoopIndex < arr.length && (theLoop = arr[autoLoopIndex]) != null) {
            Object object = this.loopLock;
            synchronized (object) {
                AutoLoop oldAutoLoop = this.autoLoop;
                if (this.startBeatLoop(theLoop, theLoop.beats)) {
                    if (oldAutoLoop != theLoop) {
                        this.autoLoop = theLoop;
                        if (oldAutoLoop != null) {
                            oldAutoLoop.unlink();
                            this.fireAutoLoopStopped(oldAutoLoop.index);
                        }
                    }
                    this.fireAutoLoopStarted(autoLoopIndex);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopAutoLoop(int autoLoopIndex) {
        AutoLoop theLoop;
        AutoLoop[] arr = this.autoLoops;
        if (autoLoopIndex >= 0 && autoLoopIndex < arr.length && (theLoop = arr[autoLoopIndex]) != null) {
            Object object = this.loopLock;
            synchronized (object) {
                if (theLoop == this.autoLoop) {
                    this.autoLoop = null;
                    if (this.stopLoop(theLoop)) {
                        this.fireAutoLoopStopped(autoLoopIndex);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopAutoLoops() {
        Object object = this.loopLock;
        synchronized (object) {
            AutoLoop theLoop = this.autoLoop;
            if (theLoop != null) {
                this.autoLoop = null;
                if (this.stopLoop(theLoop)) {
                    this.fireAutoLoopStopped(theLoop.index);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleAutoLoop(int autoLoopIndex) {
        AutoLoop theLoop;
        AutoLoop[] arr = this.autoLoops;
        if (autoLoopIndex >= 0 && autoLoopIndex < arr.length && (theLoop = arr[autoLoopIndex]) != null) {
            Object object = this.loopLock;
            synchronized (object) {
                if (theLoop == this.autoLoop) {
                    this.stopAutoLoop(autoLoopIndex);
                } else {
                    this.startAutoLoop(autoLoopIndex);
                }
            }
        }
        return false;
    }

    public boolean isSlipMode() {
        return this.slipMode;
    }

    public synchronized void setSlipMode(boolean slipMode) {
        if (this.slipMode == slipMode) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.getName() + ": setSlipMode: " + slipMode);
        }
        this.slipMode = slipMode;
        this.refreshSlipModeEnabledLightings();
    }

    protected void slippingBegin() {
        AbstractAudioScratchPlayer scratchPlayer = this.scratchPlayer;
        if (scratchPlayer == null) {
            return;
        }
        this.slipping = true;
        this.slipTime = this.clock.nanos();
        this.slipOfs = scratchPlayer.getOffset();
        this.slipAnc = this.scratchModel.getAnchor();
        this.slipVel = scratchPlayer.getVelocity() * scratchPlayer.getPitch() * this.frameRate / 1000.0;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.getName() + ": backupSlipPos: slipTime=" + this.slipTime + ", slipOfs=" + this.slipOfs + ", slipAnc=" + this.slipAnc + ", slipVel=" + this.slipVel);
        }
    }

    protected void slippingEnded() {
        long time = this.clock.nanos() - this.slipTime;
        if (time < 1L) {
            return;
        }
        double pos = this.slipOfs - this.slipAnc + (double)time * this.slipVel / 1000000.0;
        this.slipping = false;
        AbstractAudioScratchPlayer scratchPlayer = this.scratchPlayer;
        if (scratchPlayer == null) {
            return;
        }
        double ofs = scratchPlayer.getOffset();
        double ori = scratchPlayer.getPosition();
        this.scratchModel.setOrigin(pos);
        this.scratchModel.setAnchor(ofs - pos);
        scratchPlayer.setOrigin(ori);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.getName() + ": restoreSlipPos: time=" + time + ", slipOfs=" + this.slipOfs + ", slipAnc=" + this.slipAnc + ", slipVel=" + this.slipVel + " => " + pos);
        }
    }

    public boolean isBeatSlicerActive() {
        return this.slicerLoop.active;
    }

    public boolean startBeatSlicer() {
        if (this.slicerLoop.active) {
            return false;
        }
        if (this.sliceCount > 0) {
            AbstractAudioScratchPlayer scratchPlayer = this.scratchPlayer;
            if (scratchPlayer == null) {
                return false;
            }
            double ofs = scratchPlayer.getOffset();
            double ori = scratchPlayer.getPosition();
            if (!this.applyBeatSliceOptions()) {
                return false;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.getName() + ": startBeatSlicer: offset=" + ofs + ", sliceBeats=" + this.sliceBeats);
            }
            this.sliceFirstOffset = ofs;
            this.slicerSlice.setOffset(ofs);
            this.slicerSlice.beatOfs = ofs;
            this.slicerSlice.beat = 0;
            this.slicerSlice.part = 0;
            this.slicerSlice.triggerSliceIndex = -1;
            this.fireBeatSliceEntered(0);
            if (this.startLoop(this.slicerLoop)) {
                this.scratchModel.setOrigin(ofs - this.scratchModel.getAnchor());
                scratchPlayer.setOrigin(ori);
                this.fireBeatSlicerStarted();
                return true;
            }
        }
        return false;
    }

    protected boolean applyBeatSliceOptions() {
        double bpm;
        AudioScratchModel asm = this.scratchModel;
        if (asm != null && (bpm = asm.getBPM()) > 0.0) {
            this.sliceLength = this.sliceBeats * 60000.0 / bpm;
            this.slicePartLen = this.sliceLength / (double)this.sliceParts;
            this.slicePartNum = this.sliceParts / 1;
            this.slicerSlice.setLength(this.slicePartLen);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.getName() + ": applyBeatSliceOptions: sliceBeats=" + this.sliceBeats + ", sliceLength=" + this.sliceLength + ", slicePartLen=" + this.slicePartLen);
            }
            return true;
        }
        return false;
    }

    public boolean stopBeatSlicer() {
        if (!this.slicerLoop.active) {
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.getName() + ": stopBeatSlicer");
        }
        if (this.stopLoop(this.slicerLoop)) {
            this.slicerSlice.slicerStopped();
            this.fireBeatSlicerStopped();
            return true;
        }
        return false;
    }

    public boolean isBeatSlicerLoopMode() {
        return this.slicerLoopMode;
    }

    public void setBeatSlicerLoopMode(boolean loop) {
        if (this.slicerLoopMode == loop) {
            return;
        }
        this.slicerLoopMode = loop;
        this.fireBeatSlicerLoopModeChanged(loop);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.getName() + ": setBeatSlicerLoopMode: " + loop);
        }
    }

    public boolean beatSliceTriggered(int slice) {
        if (!this.slicerLoop.active) {
            return false;
        }
        this.beatSlices[slice].pressed = true;
        this.slicerSlice.triggerSliceIndex = slice;
        return true;
    }

    public boolean beatSliceReleased(int slice) {
        if (!this.slicerLoop.active) {
            return false;
        }
        this.beatSlices[slice].pressed = false;
        return true;
    }

    protected class UnusedModelReleaser
    implements Runnable {
        protected UnusedModelReleaser() {
        }

        @Override
        public void run() {
            try {
                WaxLabScratchDeck.this.closeUnusedModels();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected class RefreshDeckLightings
    implements Runnable {
        protected RefreshDeckLightings() {
        }

        @Override
        public void run() {
            WaxLabScratchDeck.this.refreshDeckLightings();
        }
    }

    protected class BeatSliceControlImpl
    extends AbstractDoubleControl
    implements BeatSliceControl {
        public BeatSliceControlImpl() {
            this.setMinimum(0.125);
            this.setMaximum(1.0);
            this.setDouble(1.0);
        }

        protected void setName(String name) {
            super.setName(name);
        }

        protected void applyDouble(double v) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(WaxLabScratchDeck.this.name + ": setSliceBeats: " + v);
            }
            if (v < 0.125) {
                v = 0.125;
            }
            if (v > 1.0) {
                v = 1.0;
            }
            if (v == WaxLabScratchDeck.this.sliceBeats) {
                return;
            }
            WaxLabScratchDeck.this.sliceBeats = v;
            WaxLabScratchDeck.this.fireSliceBeatsChanged();
        }

        public boolean setDoubleBeatSlice() {
            double beats = WaxLabScratchDeck.this.sliceBeats * 2.0;
            if (beats > 1.0) {
                return false;
            }
            this.setDouble(beats);
            return true;
        }

        public boolean setHalfBeatSlice() {
            double beats = WaxLabScratchDeck.this.sliceBeats / 2.0;
            if (beats < 0.125) {
                return false;
            }
            this.setDouble(beats);
            return true;
        }
    }

    protected class BeatJumpControlImpl
    extends AbstractDoubleControl
    implements BeatJumpControl {
        public BeatJumpControlImpl() {
            this.setMinimum(0.03125);
            this.setMaximum(32.0);
            this.setDouble(1.0);
        }

        protected void setName(String name) {
            super.setName(name);
        }

        protected void applyDouble(double v) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(WaxLabScratchDeck.this.name + ": setJumpBeats: " + v);
            }
            if (v < 0.03125) {
                v = 0.03125;
            }
            if (v > 32.0) {
                v = 32.0;
            }
            if (v == WaxLabScratchDeck.this.jumpBeats) {
                return;
            }
            WaxLabScratchDeck.this.jumpBeats = v;
            WaxLabScratchDeck.this.fireJumpBeatsChanged();
        }

        public boolean setDoubleBeatJump() {
            double beats = WaxLabScratchDeck.this.jumpBeats * 2.0;
            if (beats > 32.0) {
                return false;
            }
            this.setDouble(beats);
            return true;
        }

        public boolean setHalfBeatJump() {
            double beats = WaxLabScratchDeck.this.jumpBeats / 2.0;
            if (beats < 0.03125) {
                return false;
            }
            this.setDouble(beats);
            return true;
        }
    }

    protected class PitchDeckControlImpl
    extends AbstractEnumControl
    implements PitchDeckControl {
        protected PitchDeckControlImpl() {
        }

        protected void refreshDecks() {
            LinkedList<PitchDeck> pitchDecks = new LinkedList<PitchDeck>();
            pitchDecks.add(NULL_DECK);
            for (Line line : WaxLabScratchDeck.this.waxLab.getLines()) {
                ScratchLine asl;
                PitchDeck pitchDeck;
                if (line == null || line == WaxLabScratchDeck.this.scratchLine || !(line instanceof ScratchLine) || (pitchDeck = (asl = (ScratchLine)line).getPitchDeck()) == null) continue;
                pitchDecks.add(pitchDeck);
            }
            this.setValues(pitchDecks.toArray(new PitchDeck[pitchDecks.size()]));
        }

        protected void setName(String name) {
            super.setName(name);
        }

        protected void applyValue(Object v) {
            AbstractAudioScratchPlayer player;
            PitchDeck pitchDeck = null;
            if (v != null && v instanceof PitchDeck) {
                pitchDeck = (PitchDeck)v;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(WaxLabScratchDeck.this.name + ": setPitchDeck: " + pitchDeck);
            }
            if ((player = WaxLabScratchDeck.this.scratchPlayer) == null) {
                return;
            }
            player.setPitchDeck(pitchDeck);
        }

        public PitchDeck getPitchDeck() {
            return this.getWaxLabPitchDeck();
        }

        protected WaxLabPitchDeck getWaxLabPitchDeck() {
            return (WaxLabPitchDeck)this.getValue();
        }
    }

    protected class PitchBpmControlImpl
    extends AbstractPitchBpmControl {
        protected PitchBpmControlImpl() {
        }

        protected void setName(String name) {
            super.setName(name);
        }

        protected void applyDouble(double v) {
            AbstractAudioScratchPlayer player = WaxLabScratchDeck.this.scratchPlayer;
            if (player == null) {
                return;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(WaxLabScratchDeck.this.name + ": setPitchBPM: " + v);
            }
            player.setPitchBPM(v);
        }
    }

    protected class PitchTuneControlImpl
    extends AbstractPitchTuneControl {
        protected PitchTuneControlImpl() {
        }

        protected void setName(String name) {
            super.setName(name);
        }

        protected void applyDouble(double v) {
            WaxLabScratchDeck.this.applyCustomPitch();
        }
    }

    protected class PitchFactorControlImpl
    extends AbstractPitchFactorControl {
        protected PitchFactorControlImpl() {
        }

        protected void setName(String name) {
            super.setName(name);
        }

        protected void applyDouble(double v) {
            WaxLabScratchDeck.this.applyCustomPitch();
        }
    }

    protected class PitchModeControlImpl
    extends AbstractPitchModeControl {
        protected PitchModeControlImpl() {
        }

        protected void setName(String name) {
            super.setName(name);
        }

        protected void applyValue(Object v) {
            AbstractAudioScratchPlayer player = WaxLabScratchDeck.this.scratchPlayer;
            if (player == null) {
                return;
            }
            int pitchMode = this.getPitchMode(v);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(WaxLabScratchDeck.this.name + ": setPitchMode: " + v + " => " + pitchMode);
            }
            player.setPitchMode(pitchMode);
            WaxLabScratchDeck.this.firePitchModeChanged(pitchMode);
        }
    }

    protected class ScratchModeControlImpl
    extends AbstractScratchModeControl {
        protected ScratchModeControlImpl() {
        }

        protected void setName(String name) {
            super.setName(name);
        }

        protected void applyValue(Object v) {
            TimecodeDecoder decoder = WaxLabScratchDeck.this.timecodeDecoder;
            if (decoder == null) {
                return;
            }
            int scratchMode = AbstractScratchModeControl.getTimecodeDecoderMode(String.valueOf(v));
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(WaxLabScratchDeck.this.name + ": setScratchMode: " + v + " => " + scratchMode);
            }
            decoder.setMode(scratchMode);
            WaxLabScratchDeck.this.fireScratchModeChanged(scratchMode);
        }
    }

    protected class TimecodeFormatControlImpl
    extends AbstractTimecodeFormatControl {
        protected TimecodeFormatControlImpl() {
        }

        protected void setName(String name) {
            super.setName(name);
        }

        protected void applyValue(Object v) {
            ScratchManager manager = WaxLabScratchDeck.this.scratchManager;
            if (manager == null) {
                return;
            }
            TimecodeFormat tcFormat = null;
            if (v != null && v instanceof TimecodeFormat) {
                tcFormat = (TimecodeFormat)v;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(WaxLabScratchDeck.this.name + ": setTimecodeFormat: " + tcFormat);
            }
            manager.setTimecodeFormat(tcFormat);
        }

        public TimecodeFormat getTimecodeFormat() {
            return (TimecodeFormat)this.getValue();
        }

        protected void refreshTimecodeFormats() {
            this.setValues(WaxLabScratchDeck.this.getTimecodeFormats());
        }

        protected TimecodeFormat getTimecodeFormat(String timecodeFormatName) {
            if (timecodeFormatName != null) {
                Object[] values = this.getValues();
                int num = values.length;
                for (int i = 0; i < num; ++i) {
                    TimecodeFormat format = (TimecodeFormat)values[i];
                    if (!timecodeFormatName.equals(format.getName())) continue;
                    return format;
                }
            }
            return null;
        }
    }

    protected class PreFaderVolumeControlImpl
    extends AbstractDoubleControl
    implements VolumeControl {
        public PreFaderVolumeControlImpl() {
            this.setMinimum(0.0);
            this.setMaximum(1.0);
            this.setDouble(1.0);
        }

        protected void setName(String name) {
            super.setName(name);
        }

        protected void applyDouble(double v) {
            ScratchManager manager = WaxLabScratchDeck.this.scratchManager;
            if (manager == null) {
                return;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(WaxLabScratchDeck.this.name + ": setPreFaderVolume: " + v);
            }
            manager.setPreFaderVolume(v);
        }
    }

    protected class PostFaderVolumeControlImpl
    extends AbstractDoubleControl
    implements VolumeControl {
        public PostFaderVolumeControlImpl() {
            this.setMinimum(0.0);
            this.setMaximum(1.0);
            this.setDouble(1.0);
        }

        protected void setName(String name) {
            super.setName(name);
        }

        protected void applyDouble(double v) {
            ScratchManager manager = WaxLabScratchDeck.this.scratchManager;
            if (manager == null) {
                return;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(WaxLabScratchDeck.this.name + ": setPostFaderVolume: " + v);
            }
            manager.setPostFaderVolume(v);
        }
    }

    protected class BeatSlice {
        public static final int EXITED = 0;
        public static final int ENTERED = 1;
        public static final int ACTIVE = 2;
        protected int state;
        protected boolean pressed;
        protected double offset;

        protected BeatSlice() {
        }
    }

    protected class SlicerAudioSlice
    extends LoopAudioSlice {
        protected int beat;
        protected int part;
        protected double beatOfs;
        protected volatile int triggerSliceIndex;
        protected int sliceIndex;
        protected int slicePart;

        public SlicerAudioSlice() {
            this.prev = null;
            this.next = null;
            this.sliceIndex = -1;
            this.triggerSliceIndex = -1;
        }

        public AudioSlice getNext() {
            int tsl;
            this.beatOfs += WaxLabScratchDeck.this.slicePartLen;
            if (++this.part > WaxLabScratchDeck.this.sliceLastPart) {
                if (this.beat != this.sliceIndex) {
                    WaxLabScratchDeck.this.fireBeatSliceExited(this.beat);
                }
                this.part = 0;
                if (++this.beat > WaxLabScratchDeck.this.sliceLastIndex) {
                    this.beat = 0;
                    if (WaxLabScratchDeck.this.slicerLoopMode) {
                        this.beatOfs = WaxLabScratchDeck.this.sliceFirstOffset;
                    } else {
                        WaxLabScratchDeck.this.sliceFirstOffset = this.beatOfs;
                    }
                }
                if (this.beat != this.sliceIndex) {
                    WaxLabScratchDeck.this.fireBeatSliceEntered(this.beat);
                }
            }
            if ((tsl = this.triggerSliceIndex) >= 0) {
                this.triggerSliceIndex = -1;
                if (this.sliceIndex >= 0) {
                    WaxLabScratchDeck.this.fireBeatSliceExited(this.sliceIndex);
                }
                this.sliceIndex = tsl;
                this.slicePart = 0;
                this.offset = WaxLabScratchDeck.this.sliceFirstOffset + (double)tsl * WaxLabScratchDeck.this.sliceLength;
                BeatSlice beatSlice = WaxLabScratchDeck.this.beatSlices[tsl];
                beatSlice.offset = this.offset;
                WaxLabScratchDeck.this.fireBeatSliceActivated(tsl);
                return this;
            }
            if (this.sliceIndex >= 0) {
                if (++this.slicePart < WaxLabScratchDeck.this.slicePartNum) {
                    this.offset += WaxLabScratchDeck.this.slicePartLen;
                    return this;
                }
                BeatSlice beatSlice = WaxLabScratchDeck.this.beatSlices[this.sliceIndex];
                if (beatSlice.pressed) {
                    this.slicePart = 0;
                    this.offset = beatSlice.offset;
                    return this;
                }
                if (this.beat == this.sliceIndex) {
                    WaxLabScratchDeck.this.fireBeatSliceActivated(this.sliceIndex);
                } else {
                    WaxLabScratchDeck.this.fireBeatSliceExited(this.sliceIndex);
                }
                this.sliceIndex = -1;
            }
            this.offset = this.beatOfs;
            return this;
        }

        public AudioSlice getPrev() {
            int tsl;
            this.beatOfs -= WaxLabScratchDeck.this.slicePartLen;
            if (--this.part < 0) {
                if (this.beat != this.sliceIndex) {
                    WaxLabScratchDeck.this.fireBeatSliceExited(this.beat);
                }
                this.part = WaxLabScratchDeck.this.sliceLastPart;
                if (--this.beat < 0) {
                    this.beat = WaxLabScratchDeck.this.sliceLastIndex;
                    if (WaxLabScratchDeck.this.slicerLoopMode) {
                        this.beatOfs = WaxLabScratchDeck.this.sliceFirstOffset;
                    } else {
                        WaxLabScratchDeck.this.sliceFirstOffset = this.beatOfs;
                    }
                }
                if (this.beat != this.sliceIndex) {
                    WaxLabScratchDeck.this.fireBeatSliceEntered(this.beat);
                }
            }
            if ((tsl = this.triggerSliceIndex) >= 0) {
                this.triggerSliceIndex = -1;
                if (this.sliceIndex >= 0) {
                    WaxLabScratchDeck.this.fireBeatSliceExited(this.sliceIndex);
                }
                this.sliceIndex = tsl;
                this.slicePart = WaxLabScratchDeck.this.slicePartNum - 1;
                this.offset = WaxLabScratchDeck.this.sliceFirstOffset + (double)tsl * WaxLabScratchDeck.this.sliceLength;
                BeatSlice beatSlice = WaxLabScratchDeck.this.beatSlices[tsl];
                beatSlice.offset = this.offset;
                WaxLabScratchDeck.this.fireBeatSliceActivated(tsl);
                return this;
            }
            if (this.sliceIndex >= 0) {
                if (--this.slicePart >= 0) {
                    this.offset -= WaxLabScratchDeck.this.slicePartLen;
                    return this;
                }
                BeatSlice beatSlice = WaxLabScratchDeck.this.beatSlices[this.sliceIndex];
                if (beatSlice.pressed) {
                    this.slicePart = WaxLabScratchDeck.this.slicePartNum - 1;
                    this.offset = beatSlice.offset;
                    return this;
                }
                if (this.beat == this.sliceIndex) {
                    WaxLabScratchDeck.this.fireBeatSliceActivated(this.sliceIndex);
                } else {
                    WaxLabScratchDeck.this.fireBeatSliceExited(this.sliceIndex);
                }
                this.sliceIndex = -1;
            }
            this.offset = this.beatOfs;
            return this;
        }

        protected void slicerStopped() {
            WaxLabScratchDeck.this.fireBeatSliceExited(this.beat);
        }

        public String toString() {
            return super.toString() + "[beat=" + this.beat + ", part=" + this.part + "]";
        }
    }

    protected class SlicerLoop
    extends AbstractLoop {
        public SlicerLoop(SlicerAudioSlice slice) {
            this.slice = slice;
        }
    }

    protected class AutoLoop
    extends AbstractLoop {
        protected final int index;
        protected double beats;

        public AutoLoop(int index, double beats) {
            this.index = index;
            this.beats = beats;
            this.slice = new LoopAudioSlice();
        }
    }

    protected class LoopRoll
    extends AbstractLoop {
        protected final int index;
        protected double beats;

        public LoopRoll(int index, double beats) {
            this.index = index;
            this.beats = beats;
            this.slice = new LoopAudioSlice();
        }
    }

    protected abstract class AbstractLoop {
        protected AbstractLoop prev;
        protected AbstractLoop next;
        protected boolean active;
        protected LoopAudioSlice slice;

        protected void link() {
            this.active = true;
            this.prev = WaxLabScratchDeck.this.lastLoop;
            if (this.prev == null) {
                WaxLabScratchDeck.this.firstLoop = this;
            } else {
                this.prev.next = this;
            }
            WaxLabScratchDeck.this.lastLoop = this;
        }

        protected void unlink() {
            this.active = false;
            if (this.prev == null) {
                if (WaxLabScratchDeck.this.firstLoop == this) {
                    WaxLabScratchDeck.this.firstLoop = this.next;
                }
            } else {
                this.prev.next = this.next;
            }
            if (this.next == null) {
                if (WaxLabScratchDeck.this.lastLoop == this) {
                    WaxLabScratchDeck.this.lastLoop = this.prev;
                }
            } else {
                this.next.prev = this.prev;
            }
            this.prev = null;
            this.next = null;
        }
    }

    protected class LoopAudioSlice
    extends AbstractAudioSlice {
        public LoopAudioSlice() {
            this.prev = this;
            this.next = this;
        }

        public void setOffset(double offset) {
            this.offset = offset;
        }

        public void setLength(double length) {
            this.length = length;
        }
    }

    protected class QPointComparator
    implements Comparator {
        protected QPointComparator() {
        }

        public int compare(Object o1, Object o2) {
            int x2;
            int x1;
            QPoint q1 = (QPoint)o1;
            QPoint q2 = (QPoint)o2;
            double p1 = q1.pos;
            double p2 = q2.pos;
            if (Double.isNaN(p1)) {
                if (!Double.isNaN(p2)) {
                    return 1;
                }
            } else {
                if (Double.isNaN(p2)) {
                    return -1;
                }
                if (p1 < p2) {
                    return -1;
                }
                if (p1 > p2) {
                    return 1;
                }
            }
            return (x1 = q1.index) == (x2 = q2.index) ? 0 : (x1 < x2 ? -1 : 1);
        }
    }

    protected class QPoint
    implements CuePoint {
        protected final int index;
        protected volatile double pos = Double.NaN;
        protected volatile DefaultMediaMarker marker;
        protected double newPos;
        protected boolean pressed;

        public QPoint(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public double getPosition() {
            return this.pos;
        }

        public boolean isSet() {
            return !Double.isNaN(this.pos);
        }

        public String toString() {
            return super.toString() + "[index=" + this.index + ", pos=" + this.pos + "]";
        }
    }
}

