/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.midi.common.AsyncMidiProcessor;
import com.waxmonster.midi.common.MidiTriggerEvent;
import com.waxmonster.midi.common.MidiTriggerEventTarget;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.ScratchDeckListener;
import com.waxmonster.waxlab.impl.WaxLabScratchDeck;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WaxLabScratchDeckMidiSender
implements ScratchDeckListener {
    private static final Logger logger = Logger.getLogger(WaxLabScratchDeckMidiSender.class.getName());
    protected final WaxLabScratchDeck deck;
    private MidiProcessor targetMidiProcessor;
    protected final MidiTriggerEventTarget triggerTarget;
    protected final MidiTriggerEventTarget asyncTriggerTarget;
    protected AsyncMidiProcessor asyncMidiProcessor;
    protected MidiTrigger[] midiTriggers;
    protected MidiTriggerEvent deckStartedEvent;
    protected MidiTriggerEvent deckStoppedEvent;
    protected MidiTriggerEvent pitchModeNormalOnEvent;
    protected MidiTriggerEvent pitchModeNormalOffEvent;
    protected MidiTriggerEvent pitchModeCustomOnEvent;
    protected MidiTriggerEvent pitchModeCustomOffEvent;
    protected MidiTriggerEvent pitchModeBPMOnEvent;
    protected MidiTriggerEvent pitchModeBPMOffEvent;
    protected MidiTriggerEvent pitchModeDeckOnEvent;
    protected MidiTriggerEvent pitchModeDeckOffEvent;
    protected MidiTriggerEvent scratchModeInternalOnEvent;
    protected MidiTriggerEvent scratchModeInternalOffEvent;
    protected MidiTriggerEvent scratchModeRelativeOnEvent;
    protected MidiTriggerEvent scratchModeRelativeOffEvent;
    protected MidiTriggerEvent scratchModeAbsoluteOnEvent;
    protected MidiTriggerEvent scratchModeAbsoluteOffEvent;
    protected MidiTriggerEvent scratchModeSplatterOnEvent;
    protected MidiTriggerEvent scratchModeSplatterOffEvent;
    protected MidiTriggerEvent scratchModeUltimateOnEvent;
    protected MidiTriggerEvent scratchModeUltimateOffEvent;
    protected MidiTriggerEvent[] cuePointAddedEvents;
    protected MidiTriggerEvent[] cuePointRemovedEvents;
    protected MidiTriggerEvent[] loopRollStartedEvents;
    protected MidiTriggerEvent[] loopRollStoppedEvents;
    protected MidiTriggerEvent[] autoLoopStartedEvents;
    protected MidiTriggerEvent[] autoLoopStoppedEvents;
    protected MidiTriggerEvent beatSlicerStartedEvent;
    protected MidiTriggerEvent beatSlicerStoppedEvent;
    protected MidiTriggerEvent beatSlicerLoopOnEvent;
    protected MidiTriggerEvent beatSlicerLoopOffEvent;
    protected MidiTriggerEvent[] beatSliceActivatedEvents;
    protected MidiTriggerEvent[] beatSliceEnteredEvents;
    protected MidiTriggerEvent[] beatSliceExitedEvents;
    protected MidiTriggerEvent slipModeEnabledEvent;
    protected MidiTriggerEvent slipModeDisabledEvent;
    protected MidiTriggerEvent beatJumpEnabledEvent;
    protected MidiTriggerEvent beatJumpDisabledEvent;
    protected MidiTriggerEvent censorActivatedEvent;
    protected MidiTriggerEvent censorDeactivatedEvent;

    public WaxLabScratchDeckMidiSender(WaxLabScratchDeck deck, AsyncMidiProcessor asyncMidiProcessor) {
        this.deck = deck;
        this.asyncMidiProcessor = asyncMidiProcessor;
        this.triggerTarget = new MidiTriggerEventTarget();
        this.asyncTriggerTarget = new MidiTriggerEventTarget();
        this.asyncTriggerTarget.setTargetProcessor((MidiProcessor)asyncMidiProcessor);
        this.setMidiTriggers(new MidiTrigger[0]);
    }

    public MidiProcessor getTargetMidiProcessor() {
        return this.targetMidiProcessor;
    }

    public synchronized void setTargetMidiProcessor(MidiProcessor targetMidiProcessor) {
        if (this.targetMidiProcessor == targetMidiProcessor) {
            return;
        }
        if (targetMidiProcessor == null) {
            this.asyncMidiProcessor.stop();
        }
        this.targetMidiProcessor = targetMidiProcessor;
        this.triggerTarget.setTargetProcessor(targetMidiProcessor);
        this.asyncMidiProcessor.setTarget(targetMidiProcessor);
        if (targetMidiProcessor != null) {
            this.asyncMidiProcessor.start();
        }
    }

    protected MidiTriggerEvent createMidiTriggerEvent(List triggerList) {
        if (triggerList == null) {
            return null;
        }
        int num = triggerList.size();
        if (num < 1) {
            return null;
        }
        MidiTrigger[] triggers = triggerList.toArray(new MidiTrigger[num]);
        MidiTriggerEvent event = new MidiTriggerEvent(this.triggerTarget);
        event.setMidiTriggers(triggers);
        return event;
    }

    public MidiTrigger[] getMidiTriggers() {
        return this.midiTriggers;
    }

    public synchronized void setMidiTriggers(MidiTrigger[] midiTriggers) {
        MidiTriggerEvent stoppedEvent;
        List stoppedList;
        List startedList;
        int i;
        this.midiTriggers = midiTriggers;
        int cuePointCount = this.deck.getCuePointCount();
        int loopRollCount = this.deck.getLoopRollCount();
        int autoLoopCount = this.deck.getAutoLoopCount();
        int beatSliceCount = this.deck.getBeatSliceCount();
        LinkedList<MidiTrigger> deckStartedTriggers = null;
        LinkedList<MidiTrigger> deckStoppedTriggers = null;
        LinkedList<MidiTrigger> censorActivatedTriggers = null;
        LinkedList<MidiTrigger> censorDeactivatedTriggers = null;
        LinkedList<MidiTrigger> slipModeEnabledTriggers = null;
        LinkedList<MidiTrigger> slipModeDisabledTriggers = null;
        LinkedList<MidiTrigger> beatJumpEnabledTriggers = null;
        LinkedList<MidiTrigger> beatJumpDisabledTriggers = null;
        LinkedList<MidiTrigger> scratchModeInternalOnTriggers = null;
        LinkedList<MidiTrigger> scratchModeInternalOffTriggers = null;
        LinkedList<MidiTrigger> scratchModeRelativeOnTriggers = null;
        LinkedList<MidiTrigger> scratchModeRelativeOffTriggers = null;
        LinkedList<MidiTrigger> scratchModeAbsoluteOnTriggers = null;
        LinkedList<MidiTrigger> scratchModeAbsoluteOffTriggers = null;
        LinkedList<MidiTrigger> scratchModeSplatterOnTriggers = null;
        LinkedList<MidiTrigger> scratchModeSplatterOffTriggers = null;
        LinkedList<MidiTrigger> scratchModeUltimateOnTriggers = null;
        LinkedList<MidiTrigger> scratchModeUltimateOffTriggers = null;
        LinkedList<MidiTrigger> pitchModeNormalOnTriggers = null;
        LinkedList<MidiTrigger> pitchModeNormalOffTriggers = null;
        LinkedList<MidiTrigger> pitchModeCustomOnTriggers = null;
        LinkedList<MidiTrigger> pitchModeCustomOffTriggers = null;
        LinkedList<MidiTrigger> pitchModeBPMOnTriggers = null;
        LinkedList<MidiTrigger> pitchModeBPMOffTriggers = null;
        LinkedList<MidiTrigger> pitchModeDeckOnTriggers = null;
        LinkedList<MidiTrigger> pitchModeDeckOffTriggers = null;
        List[] qpAddedTriggers = new List[cuePointCount];
        List[] qpRemovedTriggers = new List[cuePointCount];
        List[] loopRollStartedTriggers = new List[loopRollCount];
        List[] loopRollStoppedTriggers = new List[loopRollCount];
        List[] autoLoopStartedTriggers = new List[autoLoopCount];
        List[] autoLoopStoppedTriggers = new List[autoLoopCount];
        LinkedList<MidiTrigger> beatSlicerStartedTriggers = null;
        LinkedList<MidiTrigger> beatSlicerStoppedTriggers = null;
        LinkedList<MidiTrigger> beatSlicerLoopOnTriggers = null;
        LinkedList<MidiTrigger> beatSlicerLoopOffTriggers = null;
        List[] beatSliceActivatedTriggers = new List[beatSliceCount];
        List[] beatSliceEnteredTriggers = new List[beatSliceCount];
        List[] beatSliceExitedTriggers = new List[beatSliceCount];
        MidiTrigger[] triggers = midiTriggers;
        int num = triggers == null ? 0 : triggers.length;
        for (i = 0; i < num; ++i) {
            List<MidiTrigger> list;
            int index;
            String suffix;
            String event;
            MidiTrigger trigger = triggers[i];
            if (trigger == null || (event = trigger.getEvent()) == null) continue;
            if ("DeckStarted".equals(event)) {
                if (deckStartedTriggers == null) {
                    deckStartedTriggers = new LinkedList<MidiTrigger>();
                }
                deckStartedTriggers.add(trigger);
                continue;
            }
            if ("DeckStopped".equals(event)) {
                if (deckStoppedTriggers == null) {
                    deckStoppedTriggers = new LinkedList<MidiTrigger>();
                }
                deckStoppedTriggers.add(trigger);
                continue;
            }
            if ("CensorActivated".equals(event)) {
                if (censorActivatedTriggers == null) {
                    censorActivatedTriggers = new LinkedList<MidiTrigger>();
                }
                censorActivatedTriggers.add(trigger);
                continue;
            }
            if ("CensorDeactivated".equals(event)) {
                if (censorDeactivatedTriggers == null) {
                    censorDeactivatedTriggers = new LinkedList<MidiTrigger>();
                }
                censorDeactivatedTriggers.add(trigger);
                continue;
            }
            if ("SlipModeEnabled".equals(event)) {
                if (slipModeEnabledTriggers == null) {
                    slipModeEnabledTriggers = new LinkedList<MidiTrigger>();
                }
                slipModeEnabledTriggers.add(trigger);
                continue;
            }
            if ("SlipModeDisabled".equals(event)) {
                if (slipModeDisabledTriggers == null) {
                    slipModeDisabledTriggers = new LinkedList<MidiTrigger>();
                }
                slipModeDisabledTriggers.add(trigger);
                continue;
            }
            if ("BeatJumpEnabled".equals(event)) {
                if (beatJumpEnabledTriggers == null) {
                    beatJumpEnabledTriggers = new LinkedList<MidiTrigger>();
                }
                beatJumpEnabledTriggers.add(trigger);
                continue;
            }
            if ("BeatJumpDisabled".equals(event)) {
                if (beatJumpDisabledTriggers == null) {
                    beatJumpDisabledTriggers = new LinkedList<MidiTrigger>();
                }
                beatJumpDisabledTriggers.add(trigger);
                continue;
            }
            if ("ScratchModeActivated-Internal".equals(event)) {
                if (scratchModeInternalOnTriggers == null) {
                    scratchModeInternalOnTriggers = new LinkedList<MidiTrigger>();
                }
                scratchModeInternalOnTriggers.add(trigger);
                continue;
            }
            if ("ScratchModeDeactivated-Internal".equals(event)) {
                if (scratchModeInternalOffTriggers == null) {
                    scratchModeInternalOffTriggers = new LinkedList<MidiTrigger>();
                }
                scratchModeInternalOffTriggers.add(trigger);
                continue;
            }
            if ("ScratchModeActivated-Relative".equals(event)) {
                if (scratchModeRelativeOnTriggers == null) {
                    scratchModeRelativeOnTriggers = new LinkedList<MidiTrigger>();
                }
                scratchModeRelativeOnTriggers.add(trigger);
                continue;
            }
            if ("ScratchModeDeactivated-Relative".equals(event)) {
                if (scratchModeRelativeOffTriggers == null) {
                    scratchModeRelativeOffTriggers = new LinkedList<MidiTrigger>();
                }
                scratchModeRelativeOffTriggers.add(trigger);
                continue;
            }
            if ("ScratchModeActivated-Absolute".equals(event)) {
                if (scratchModeAbsoluteOnTriggers == null) {
                    scratchModeAbsoluteOnTriggers = new LinkedList<MidiTrigger>();
                }
                scratchModeAbsoluteOnTriggers.add(trigger);
                continue;
            }
            if ("ScratchModeDeactivated-Absolute".equals(event)) {
                if (scratchModeAbsoluteOffTriggers == null) {
                    scratchModeAbsoluteOffTriggers = new LinkedList<MidiTrigger>();
                }
                scratchModeAbsoluteOffTriggers.add(trigger);
                continue;
            }
            if ("ScratchModeActivated-Splatter".equals(event)) {
                if (scratchModeSplatterOnTriggers == null) {
                    scratchModeSplatterOnTriggers = new LinkedList<MidiTrigger>();
                }
                scratchModeSplatterOnTriggers.add(trigger);
                continue;
            }
            if ("ScratchModeDeactivated-Splatter".equals(event)) {
                if (scratchModeSplatterOffTriggers == null) {
                    scratchModeSplatterOffTriggers = new LinkedList<MidiTrigger>();
                }
                scratchModeSplatterOffTriggers.add(trigger);
                continue;
            }
            if ("ScratchModeActivated-Ultimate".equals(event)) {
                if (scratchModeUltimateOnTriggers == null) {
                    scratchModeUltimateOnTriggers = new LinkedList<MidiTrigger>();
                }
                scratchModeUltimateOnTriggers.add(trigger);
                continue;
            }
            if ("ScratchModeDeactivated-Ultimate".equals(event)) {
                if (scratchModeUltimateOffTriggers == null) {
                    scratchModeUltimateOffTriggers = new LinkedList<MidiTrigger>();
                }
                scratchModeUltimateOffTriggers.add(trigger);
                continue;
            }
            if ("PitchModeActivated-Normal".equals(event)) {
                if (pitchModeNormalOnTriggers == null) {
                    pitchModeNormalOnTriggers = new LinkedList<MidiTrigger>();
                }
                pitchModeNormalOnTriggers.add(trigger);
                continue;
            }
            if ("PitchModeDeactivated-Normal".equals(event)) {
                if (pitchModeNormalOffTriggers == null) {
                    pitchModeNormalOffTriggers = new LinkedList<MidiTrigger>();
                }
                pitchModeNormalOffTriggers.add(trigger);
                continue;
            }
            if ("PitchModeActivated-Custom".equals(event)) {
                if (pitchModeCustomOnTriggers == null) {
                    pitchModeCustomOnTriggers = new LinkedList<MidiTrigger>();
                }
                pitchModeCustomOnTriggers.add(trigger);
                continue;
            }
            if ("PitchModeDeactivated-Custom".equals(event)) {
                if (pitchModeCustomOffTriggers == null) {
                    pitchModeCustomOffTriggers = new LinkedList<MidiTrigger>();
                }
                pitchModeCustomOffTriggers.add(trigger);
                continue;
            }
            if ("PitchModeActivated-BPM".equals(event)) {
                if (pitchModeBPMOnTriggers == null) {
                    pitchModeBPMOnTriggers = new LinkedList<MidiTrigger>();
                }
                pitchModeBPMOnTriggers.add(trigger);
                continue;
            }
            if ("PitchModeDeactivated-BPM".equals(event)) {
                if (pitchModeBPMOffTriggers == null) {
                    pitchModeBPMOffTriggers = new LinkedList<MidiTrigger>();
                }
                pitchModeBPMOffTriggers.add(trigger);
                continue;
            }
            if ("PitchModeActivated-Deck".equals(event)) {
                if (pitchModeDeckOnTriggers == null) {
                    pitchModeDeckOnTriggers = new LinkedList<MidiTrigger>();
                }
                pitchModeDeckOnTriggers.add(trigger);
                continue;
            }
            if ("PitchModeDeactivated-Deck".equals(event)) {
                if (pitchModeDeckOffTriggers == null) {
                    pitchModeDeckOffTriggers = new LinkedList<MidiTrigger>();
                }
                pitchModeDeckOffTriggers.add(trigger);
                continue;
            }
            if (event.startsWith("CuePointAdded-")) {
                try {
                    suffix = event.substring("CuePointAdded-".length());
                    index = Integer.parseInt(suffix) - 1;
                    if (index < 0 || index >= cuePointCount) continue;
                    list = qpAddedTriggers[index];
                    if (list == null) {
                        list = new LinkedList<MidiTrigger>();
                        qpAddedTriggers[index] = list;
                    }
                    list.add(trigger);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (event.startsWith("CuePointRemoved-")) {
                try {
                    suffix = event.substring("CuePointRemoved-".length());
                    index = Integer.parseInt(suffix) - 1;
                    if (index < 0 || index >= cuePointCount) continue;
                    list = qpRemovedTriggers[index];
                    if (list == null) {
                        list = new LinkedList();
                        qpRemovedTriggers[index] = list;
                    }
                    list.add(trigger);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (event.startsWith("LoopRollStarted-")) {
                try {
                    suffix = event.substring("LoopRollStarted-".length());
                    index = Integer.parseInt(suffix) - 1;
                    if (index < 0 || index >= loopRollStartedTriggers.length) continue;
                    list = loopRollStartedTriggers[index];
                    if (list == null) {
                        list = new LinkedList();
                        loopRollStartedTriggers[index] = list;
                    }
                    list.add(trigger);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (event.startsWith("LoopRollStopped-")) {
                try {
                    suffix = event.substring("LoopRollStopped-".length());
                    index = Integer.parseInt(suffix) - 1;
                    if (index < 0 || index >= loopRollStoppedTriggers.length) continue;
                    list = loopRollStoppedTriggers[index];
                    if (list == null) {
                        loopRollStoppedTriggers[index] = list = new LinkedList();
                    }
                    list.add(trigger);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (event.startsWith("AutoLoopStarted-")) {
                try {
                    suffix = event.substring("AutoLoopStarted-".length());
                    index = Integer.parseInt(suffix) - 1;
                    if (index < 0 || index >= autoLoopStartedTriggers.length) continue;
                    list = autoLoopStartedTriggers[index];
                    if (list == null) {
                        autoLoopStartedTriggers[index] = list = new LinkedList();
                    }
                    list.add(trigger);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (event.startsWith("AutoLoopStopped-")) {
                try {
                    suffix = event.substring("AutoLoopStopped-".length());
                    index = Integer.parseInt(suffix) - 1;
                    if (index < 0 || index >= autoLoopStoppedTriggers.length) continue;
                    list = autoLoopStoppedTriggers[index];
                    if (list == null) {
                        autoLoopStoppedTriggers[index] = list = new LinkedList();
                    }
                    list.add(trigger);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if ("BeatSlicerStarted".equals(event)) {
                if (beatSlicerStartedTriggers == null) {
                    beatSlicerStartedTriggers = new LinkedList<MidiTrigger>();
                }
                beatSlicerStartedTriggers.add(trigger);
                continue;
            }
            if ("BeatSlicerStopped".equals(event)) {
                if (beatSlicerStoppedTriggers == null) {
                    beatSlicerStoppedTriggers = new LinkedList<MidiTrigger>();
                }
                beatSlicerStoppedTriggers.add(trigger);
                continue;
            }
            if ("BeatSlicerLoopActivated".equals(event)) {
                if (beatSlicerLoopOnTriggers == null) {
                    beatSlicerLoopOnTriggers = new LinkedList<MidiTrigger>();
                }
                beatSlicerLoopOnTriggers.add(trigger);
                continue;
            }
            if ("BeatSlicerLoopDeactivated".equals(event)) {
                if (beatSlicerLoopOffTriggers == null) {
                    beatSlicerLoopOffTriggers = new LinkedList<MidiTrigger>();
                }
                beatSlicerLoopOffTriggers.add(trigger);
                continue;
            }
            if (event.startsWith("BeatSliceActivated-")) {
                try {
                    suffix = event.substring("BeatSliceActivated-".length());
                    index = Integer.parseInt(suffix) - 1;
                    if (index < 0 || index >= beatSliceActivatedTriggers.length) continue;
                    list = beatSliceActivatedTriggers[index];
                    if (list == null) {
                        beatSliceActivatedTriggers[index] = list = new LinkedList();
                    }
                    list.add(trigger);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (event.startsWith("BeatSliceEntered-")) {
                try {
                    suffix = event.substring("BeatSliceEntered-".length());
                    index = Integer.parseInt(suffix) - 1;
                    if (index < 0 || index >= beatSliceEnteredTriggers.length) continue;
                    list = beatSliceEnteredTriggers[index];
                    if (list == null) {
                        beatSliceEnteredTriggers[index] = list = new LinkedList();
                    }
                    list.add(trigger);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (event.startsWith("BeatSliceExited-")) {
                try {
                    suffix = event.substring("BeatSliceExited-".length());
                    index = Integer.parseInt(suffix) - 1;
                    if (index < 0 || index >= beatSliceExitedTriggers.length) continue;
                    list = beatSliceExitedTriggers[index];
                    if (list == null) {
                        beatSliceExitedTriggers[index] = list = new LinkedList();
                    }
                    list.add(trigger);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("Unknown MidiTrigger-Event: " + event);
        }
        this.deckStartedEvent = this.createMidiTriggerEvent(deckStartedTriggers);
        this.deckStoppedEvent = this.createMidiTriggerEvent(deckStoppedTriggers);
        this.slipModeEnabledEvent = this.createMidiTriggerEvent(slipModeEnabledTriggers);
        this.slipModeDisabledEvent = this.createMidiTriggerEvent(slipModeDisabledTriggers);
        this.beatJumpEnabledEvent = this.createMidiTriggerEvent(beatJumpEnabledTriggers);
        this.beatJumpDisabledEvent = this.createMidiTriggerEvent(beatJumpDisabledTriggers);
        this.censorActivatedEvent = this.createMidiTriggerEvent(censorActivatedTriggers);
        this.censorDeactivatedEvent = this.createMidiTriggerEvent(censorDeactivatedTriggers);
        this.scratchModeInternalOnEvent = this.createMidiTriggerEvent(scratchModeInternalOnTriggers);
        this.scratchModeInternalOffEvent = this.createMidiTriggerEvent(scratchModeInternalOffTriggers);
        this.scratchModeRelativeOnEvent = this.createMidiTriggerEvent(scratchModeRelativeOnTriggers);
        this.scratchModeRelativeOffEvent = this.createMidiTriggerEvent(scratchModeRelativeOffTriggers);
        this.scratchModeAbsoluteOnEvent = this.createMidiTriggerEvent(scratchModeAbsoluteOnTriggers);
        this.scratchModeAbsoluteOffEvent = this.createMidiTriggerEvent(scratchModeAbsoluteOffTriggers);
        this.scratchModeSplatterOnEvent = this.createMidiTriggerEvent(scratchModeSplatterOnTriggers);
        this.scratchModeSplatterOffEvent = this.createMidiTriggerEvent(scratchModeSplatterOffTriggers);
        this.scratchModeUltimateOnEvent = this.createMidiTriggerEvent(scratchModeUltimateOnTriggers);
        this.scratchModeUltimateOffEvent = this.createMidiTriggerEvent(scratchModeUltimateOffTriggers);
        this.pitchModeNormalOnEvent = this.createMidiTriggerEvent(pitchModeNormalOnTriggers);
        this.pitchModeNormalOffEvent = this.createMidiTriggerEvent(pitchModeNormalOffTriggers);
        this.pitchModeCustomOnEvent = this.createMidiTriggerEvent(pitchModeCustomOnTriggers);
        this.pitchModeCustomOffEvent = this.createMidiTriggerEvent(pitchModeCustomOffTriggers);
        this.pitchModeBPMOnEvent = this.createMidiTriggerEvent(pitchModeBPMOnTriggers);
        this.pitchModeBPMOffEvent = this.createMidiTriggerEvent(pitchModeBPMOffTriggers);
        this.pitchModeDeckOnEvent = this.createMidiTriggerEvent(pitchModeDeckOnTriggers);
        this.pitchModeDeckOffEvent = this.createMidiTriggerEvent(pitchModeDeckOffTriggers);
        this.cuePointAddedEvents = new MidiTriggerEvent[cuePointCount];
        this.cuePointRemovedEvents = new MidiTriggerEvent[cuePointCount];
        for (i = 0; i < cuePointCount; ++i) {
            triggers = null;
            List qpAddedList = qpAddedTriggers[i];
            if (qpAddedList != null && (num = qpAddedList.size()) > 0) {
                triggers = qpAddedList.toArray(new MidiTrigger[num]);
            }
            MidiTriggerEvent qpAddedEvent = null;
            if (triggers != null) {
                qpAddedEvent = new MidiTriggerEvent(this.triggerTarget);
                qpAddedEvent.setMidiTriggers(triggers);
            }
            this.cuePointAddedEvents[i] = qpAddedEvent;
            triggers = null;
            List qpRemovedList = qpRemovedTriggers[i];
            if (qpRemovedList != null && (num = qpRemovedList.size()) > 0) {
                triggers = qpRemovedList.toArray(new MidiTrigger[num]);
            }
            MidiTriggerEvent qpRemovedEvent = null;
            if (triggers != null) {
                qpRemovedEvent = new MidiTriggerEvent(this.triggerTarget);
                qpRemovedEvent.setMidiTriggers(triggers);
            }
            this.cuePointRemovedEvents[i] = qpRemovedEvent;
        }
        this.loopRollStartedEvents = new MidiTriggerEvent[loopRollCount];
        this.loopRollStoppedEvents = new MidiTriggerEvent[loopRollCount];
        for (i = 0; i < loopRollCount; ++i) {
            triggers = null;
            startedList = loopRollStartedTriggers[i];
            if (startedList != null && (num = startedList.size()) > 0) {
                triggers = startedList.toArray(new MidiTrigger[num]);
            }
            MidiTriggerEvent startedEvent = null;
            if (triggers != null) {
                startedEvent = new MidiTriggerEvent(this.triggerTarget);
                startedEvent.setMidiTriggers(triggers);
            }
            this.loopRollStartedEvents[i] = startedEvent;
            triggers = null;
            stoppedList = loopRollStoppedTriggers[i];
            if (stoppedList != null && (num = stoppedList.size()) > 0) {
                triggers = stoppedList.toArray(new MidiTrigger[num]);
            }
            stoppedEvent = null;
            if (triggers != null) {
                stoppedEvent = new MidiTriggerEvent(this.triggerTarget);
                stoppedEvent.setMidiTriggers(triggers);
            }
            this.loopRollStoppedEvents[i] = stoppedEvent;
        }
        this.autoLoopStartedEvents = new MidiTriggerEvent[autoLoopCount];
        this.autoLoopStoppedEvents = new MidiTriggerEvent[autoLoopCount];
        for (i = 0; i < autoLoopCount; ++i) {
            triggers = null;
            startedList = autoLoopStartedTriggers[i];
            if (startedList != null && (num = startedList.size()) > 0) {
                triggers = startedList.toArray(new MidiTrigger[num]);
            }
            MidiTriggerEvent startedEvent = null;
            if (triggers != null) {
                startedEvent = new MidiTriggerEvent(this.triggerTarget);
                startedEvent.setMidiTriggers(triggers);
            }
            this.autoLoopStartedEvents[i] = startedEvent;
            triggers = null;
            stoppedList = autoLoopStoppedTriggers[i];
            if (stoppedList != null && (num = stoppedList.size()) > 0) {
                triggers = stoppedList.toArray(new MidiTrigger[num]);
            }
            stoppedEvent = null;
            if (triggers != null) {
                stoppedEvent = new MidiTriggerEvent(this.triggerTarget);
                stoppedEvent.setMidiTriggers(triggers);
            }
            this.autoLoopStoppedEvents[i] = stoppedEvent;
        }
        this.beatSlicerStartedEvent = this.createMidiTriggerEvent(beatSlicerStartedTriggers);
        this.beatSlicerStoppedEvent = this.createMidiTriggerEvent(beatSlicerStoppedTriggers);
        this.beatSlicerLoopOnEvent = this.createMidiTriggerEvent(beatSlicerLoopOnTriggers);
        this.beatSlicerLoopOffEvent = this.createMidiTriggerEvent(beatSlicerLoopOffTriggers);
        this.beatSliceActivatedEvents = new MidiTriggerEvent[beatSliceCount];
        this.beatSliceEnteredEvents = new MidiTriggerEvent[beatSliceCount];
        this.beatSliceExitedEvents = new MidiTriggerEvent[beatSliceCount];
        for (i = 0; i < beatSliceCount; ++i) {
            List triggerList = null;
            triggers = null;
            triggerList = beatSliceActivatedTriggers[i];
            if (triggerList != null && (num = triggerList.size()) > 0) {
                triggers = triggerList.toArray(new MidiTrigger[num]);
            }
            MidiTriggerEvent activatedEvent = null;
            if (triggers != null) {
                activatedEvent = new MidiTriggerEvent(this.asyncTriggerTarget);
                activatedEvent.setMidiTriggers(triggers);
            }
            this.beatSliceActivatedEvents[i] = activatedEvent;
            triggers = null;
            triggerList = beatSliceEnteredTriggers[i];
            if (triggerList != null && (num = triggerList.size()) > 0) {
                triggers = triggerList.toArray(new MidiTrigger[num]);
            }
            MidiTriggerEvent enteredEvent = null;
            if (triggers != null) {
                enteredEvent = new MidiTriggerEvent(this.asyncTriggerTarget);
                enteredEvent.setMidiTriggers(triggers);
            }
            this.beatSliceEnteredEvents[i] = enteredEvent;
            triggers = null;
            triggerList = beatSliceExitedTriggers[i];
            if (triggerList != null && (num = triggerList.size()) > 0) {
                triggers = triggerList.toArray(new MidiTrigger[num]);
            }
            MidiTriggerEvent exitedEvent = null;
            if (triggers != null) {
                exitedEvent = new MidiTriggerEvent(this.asyncTriggerTarget);
                exitedEvent.setMidiTriggers(triggers);
            }
            this.beatSliceExitedEvents[i] = exitedEvent;
        }
    }

    protected void fire(MidiTriggerEvent event) {
        if (event != null) {
            event.fire();
        }
    }

    public void deckStarted(ScratchDeck deck) {
        this.fire(this.deckStartedEvent);
    }

    public void deckStopped(ScratchDeck deck) {
        this.fire(this.deckStoppedEvent);
    }

    public void scratchPlayerChanged(ScratchDeck deck) {
    }

    public void scratchResourceWillChange(ScratchDeck deck) {
    }

    public void scratchResourceHasChanged(ScratchDeck deck) {
    }

    public void scratchModeChanged(ScratchDeck deck, int mode) {
        switch (mode) {
            case 0: {
                this.fire(this.scratchModeRelativeOffEvent);
                this.fire(this.scratchModeAbsoluteOffEvent);
                this.fire(this.scratchModeSplatterOffEvent);
                this.fire(this.scratchModeUltimateOffEvent);
                this.fire(this.scratchModeInternalOnEvent);
                break;
            }
            case 1: {
                this.fire(this.scratchModeInternalOffEvent);
                this.fire(this.scratchModeAbsoluteOffEvent);
                this.fire(this.scratchModeSplatterOffEvent);
                this.fire(this.scratchModeUltimateOffEvent);
                this.fire(this.scratchModeRelativeOnEvent);
                break;
            }
            case 2: {
                this.fire(this.scratchModeInternalOffEvent);
                this.fire(this.scratchModeRelativeOffEvent);
                this.fire(this.scratchModeSplatterOffEvent);
                this.fire(this.scratchModeUltimateOffEvent);
                this.fire(this.scratchModeAbsoluteOnEvent);
                break;
            }
            case 3: {
                this.fire(this.scratchModeInternalOffEvent);
                this.fire(this.scratchModeRelativeOffEvent);
                this.fire(this.scratchModeAbsoluteOffEvent);
                this.fire(this.scratchModeUltimateOffEvent);
                this.fire(this.scratchModeSplatterOnEvent);
                break;
            }
            case 4: {
                this.fire(this.scratchModeInternalOffEvent);
                this.fire(this.scratchModeRelativeOffEvent);
                this.fire(this.scratchModeAbsoluteOffEvent);
                this.fire(this.scratchModeSplatterOffEvent);
                this.fire(this.scratchModeUltimateOnEvent);
            }
        }
    }

    public void pitchModeChanged(ScratchDeck deck, int mode) {
        switch (mode) {
            case 0: {
                this.fire(this.pitchModeCustomOffEvent);
                this.fire(this.pitchModeBPMOffEvent);
                this.fire(this.pitchModeDeckOffEvent);
                this.fire(this.pitchModeNormalOnEvent);
                break;
            }
            case 1: {
                this.fire(this.pitchModeNormalOffEvent);
                this.fire(this.pitchModeBPMOffEvent);
                this.fire(this.pitchModeDeckOffEvent);
                this.fire(this.pitchModeCustomOnEvent);
                break;
            }
            case 2: {
                this.fire(this.pitchModeNormalOffEvent);
                this.fire(this.pitchModeCustomOffEvent);
                this.fire(this.pitchModeDeckOffEvent);
                this.fire(this.pitchModeBPMOnEvent);
                break;
            }
            case 3: {
                this.fire(this.pitchModeNormalOffEvent);
                this.fire(this.pitchModeCustomOffEvent);
                this.fire(this.pitchModeBPMOffEvent);
                this.fire(this.pitchModeDeckOnEvent);
            }
        }
    }

    public void primaryPitchChanged(ScratchDeck deck, double pitch) {
    }

    public void secondaryPitchChanged(ScratchDeck deck, double pitch) {
    }

    public void slipModeEnabled(ScratchDeck deck) {
        this.fire(this.slipModeEnabledEvent);
    }

    public void slipModeDisabled(ScratchDeck deck) {
        this.fire(this.slipModeDisabledEvent);
    }

    public void beatJumpEnabled(ScratchDeck deck) {
        this.fire(this.beatJumpEnabledEvent);
    }

    public void beatJumpDisabled(ScratchDeck deck) {
        this.fire(this.beatJumpDisabledEvent);
    }

    public void jumpBeatsChanged(ScratchDeck deck) {
    }

    public void censorActivated(ScratchDeck deck) {
        if (deck.isCensor() || deck.isGoofyMode()) {
            this.fire(this.censorActivatedEvent);
        } else {
            this.fire(this.censorDeactivatedEvent);
        }
    }

    public void censorDeactivated(ScratchDeck deck) {
        if (deck.isCensor() || deck.isGoofyMode()) {
            this.fire(this.censorActivatedEvent);
        } else {
            this.fire(this.censorDeactivatedEvent);
        }
    }

    public void goofyModeActivated(ScratchDeck deck) {
        if (deck.isCensor() || deck.isGoofyMode()) {
            this.fire(this.censorActivatedEvent);
        } else {
            this.fire(this.censorDeactivatedEvent);
        }
    }

    public void goofyModeDeactivated(ScratchDeck deck) {
        if (deck.isCensor() || deck.isGoofyMode()) {
            this.fire(this.censorActivatedEvent);
        } else {
            this.fire(this.censorDeactivatedEvent);
        }
    }

    public void cuePointAdded(ScratchDeck deck, int index) {
        MidiTriggerEvent[] events = this.cuePointAddedEvents;
        if (index >= 0 && index < events.length) {
            this.fire(events[index]);
        }
    }

    public void cuePointRemoved(ScratchDeck deck, int index) {
        MidiTriggerEvent[] events = this.cuePointRemovedEvents;
        if (index >= 0 && index < events.length) {
            this.fire(events[index]);
        }
    }

    public void cuePointChanged(ScratchDeck deck, int index) {
    }

    public void loopRollStarted(ScratchDeck deck, int index) {
        MidiTriggerEvent[] events = this.loopRollStartedEvents;
        if (index >= 0 && index < events.length) {
            this.fire(events[index]);
        }
    }

    public void loopRollStopped(ScratchDeck deck, int index) {
        MidiTriggerEvent[] events = this.loopRollStoppedEvents;
        if (index >= 0 && index < events.length) {
            this.fire(events[index]);
        }
    }

    public void autoLoopStarted(ScratchDeck deck, int index) {
        MidiTriggerEvent[] events = this.autoLoopStartedEvents;
        if (index >= 0 && index < events.length) {
            this.fire(events[index]);
        }
    }

    public void autoLoopStopped(ScratchDeck deck, int index) {
        MidiTriggerEvent[] events = this.autoLoopStoppedEvents;
        if (index >= 0 && index < events.length) {
            this.fire(events[index]);
        }
    }

    public void sliceBeatsChanged(ScratchDeck deck) {
    }

    public void beatSlicerEnabled(ScratchDeck deck) {
    }

    public void beatSlicerDisabled(ScratchDeck deck) {
    }

    public void beatSlicerStarted(ScratchDeck deck) {
        this.fire(this.beatSlicerStartedEvent);
    }

    public void beatSlicerStopped(ScratchDeck deck) {
        this.fire(this.beatSlicerStoppedEvent);
    }

    public void beatSlicerLoopModeChanged(ScratchDeck deck, boolean loopMode) {
        this.fire(loopMode ? this.beatSlicerLoopOnEvent : this.beatSlicerLoopOffEvent);
    }

    public void beatSliceActivated(ScratchDeck deck, int index) {
        MidiTriggerEvent[] events = this.beatSliceActivatedEvents;
        if (index >= 0 && index < events.length) {
            this.fire(events[index]);
        }
    }

    public void beatSliceEntered(ScratchDeck deck, int index) {
        MidiTriggerEvent[] events = this.beatSliceEnteredEvents;
        if (index >= 0 && index < events.length) {
            this.fire(events[index]);
        }
    }

    public void beatSliceExited(ScratchDeck deck, int index) {
        MidiTriggerEvent[] events = this.beatSliceExitedEvents;
        if (index >= 0 && index < events.length) {
            this.fire(events[index]);
        }
    }
}

