/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.old;

import com.spacekiller.util.thread.ThreadPool;
import com.spacekiller.util.thread.Work;
import com.waxmonster.scratch.ScratchModel;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractScratchModelOLD
implements ScratchModel {
    public static final int MIN_BUFFER_COUNT = 5;
    public static final int DEFAULT_BUFFER_COUNT = 7;
    public static final int MIN_BUFFER_FRAMES = 16;
    private static final Logger logger = Logger.getLogger(AbstractScratchModelOLD.class.getName());
    protected final float rate;
    protected final int bufCount;
    protected final int bufFrames;
    protected volatile Buf buf;
    protected final Loader loader;
    protected Work loaderWork;
    protected ThreadPool loaderThreadPool;

    public AbstractScratchModelOLD(float rate, int bufFrames, int bufCount, ThreadPool loaderThreadPool) throws IOException {
        if (bufFrames < 16) {
            throw new IllegalArgumentException("Invalid scratch buffer size: " + bufFrames + " < " + 16 + " frames");
        }
        if (bufCount < 5) {
            throw new IllegalArgumentException("Invalid number of scratch buffers: " + bufCount + " < " + 5);
        }
        this.rate = rate;
        this.bufFrames = bufFrames;
        this.bufCount = bufCount;
        this.buf = null;
        this.loader = new Loader();
        this.loaderThreadPool = loaderThreadPool;
    }

    public final float getFrameRate() {
        return this.rate;
    }

    protected void start(double startFramePos) throws IOException, InterruptedException {
        Buf firstBuf;
        if (startFramePos != startFramePos) {
            throw new IllegalArgumentException("Invalid start frame position: " + startFramePos);
        }
        if (this.buf != null) {
            throw new IllegalStateException("Scratch buffers are already initialized: " + this);
        }
        long framePos = (long)(startFramePos - (double)(this.bufCount * this.bufFrames / 2));
        Buf lastBuf = firstBuf = this.createBuf(this.bufFrames);
        Buf mainBuf = null;
        for (int i = 1; i < this.bufCount; ++i) {
            Buf b = this.createBuf(this.bufFrames);
            b.ofs = framePos;
            b.end = framePos += (long)this.bufFrames;
            if (mainBuf == null && (double)framePos > startFramePos) {
                mainBuf = b;
            }
            lastBuf.next = b;
            b.prev = lastBuf;
            lastBuf = b;
        }
        lastBuf.next = firstBuf;
        firstBuf.prev = lastBuf;
        this.buf = mainBuf;
        if (mainBuf == null) {
            logger.warning("Main buffer is null: bufCount=" + this.bufCount + ", startFramePos=" + startFramePos);
            mainBuf = firstBuf;
        }
        this.load(mainBuf);
        Buf b = mainBuf.next;
        while (b != mainBuf) {
            this.load(b);
            b = b.next;
        }
        this.loaderWork = this.loaderThreadPool.start((Runnable)this.loader);
    }

    protected void preload(boolean forward) throws IOException {
        Buf b = this.buf;
        if (forward) {
            long z;
            b = b.next;
            for (z = b.end; b.ofs == z; z += (long)this.bufFrames) {
                b = b.next;
            }
            b.ofs = z;
            b.end = z + (long)this.bufFrames;
        } else {
            long x;
            b = b.prev;
            for (x = b.ofs; b.end == x; x -= (long)this.bufFrames) {
                b = b.prev;
            }
            b.ofs = x - (long)this.bufFrames;
            b.end = x;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Preloading buffer: ofs=" + b.ofs + ", end=" + b.end);
        }
        this.load(b);
    }

    protected void loadAll() throws IOException {
        Buf b = this.buf;
        long x = b.ofs;
        long z = x + (long)this.bufFrames;
        this.load(b);
        Buf prev = b.prev;
        Buf next = b.next;
        while (true) {
            next.ofs = z;
            next.end = z += (long)this.bufFrames;
            this.load(next);
            if (next == prev) break;
            next = next.next;
            prev.end = x;
            prev.ofs = x -= (long)this.bufFrames;
            this.load(prev);
            if (prev == next) break;
            prev = prev.prev;
        }
    }

    public void reload(long p, long q) throws IOException {
        int i;
        Buf next;
        Buf prev;
        int n;
        Buf b = this.buf;
        long x = b.ofs;
        long z = x + (long)this.bufFrames;
        if (q <= x) {
            do {
                b = b.prev;
                z = b.end;
                if (z == x) continue;
                return;
            } while (q <= (x -= (long)this.bufFrames));
            n = (int)(q - x);
            if (p >= x) {
                int i2 = (int)(p - x);
                this.load(b, i2, n);
                return;
            }
            this.load(b, 0, n);
            prev = b.prev;
            next = null;
        } else if (p >= z) {
            do {
                b = b.next;
                x = b.ofs;
                if (x == z) continue;
                return;
            } while (p >= (z += (long)this.bufFrames));
            i = (int)(p - x);
            if (q <= z) {
                int n2 = (int)(q - p);
                this.load(b, i, n2);
                return;
            }
            n = (int)(z - p);
            this.load(b, i, n);
            prev = null;
            next = b.next;
        } else if (p >= x) {
            i = (int)(p - x);
            if (q <= z) {
                int n3 = (int)(q - p);
                this.load(b, i, n3);
                return;
            }
            this.load(b, i, this.bufFrames - i);
            next = b.next;
            prev = null;
        } else if (q <= z) {
            n = (int)(q - x);
            this.load(b, 0, n);
            prev = b.prev;
            next = null;
        } else {
            this.load(b, 0, this.bufFrames);
            prev = b.prev;
            next = b.next;
        }
        while (true) {
            long v;
            if (next != null) {
                v = next.ofs;
                if (q <= v || v != z) {
                    next = null;
                    continue;
                }
                if (q <= (z += (long)this.bufFrames)) {
                    n = (int)(q - v);
                    this.load(next, 0, n);
                    next = null;
                    continue;
                }
                this.load(next, 0, this.bufFrames);
                next = next.next;
                if (prev == null) {
                    continue;
                }
            } else if (prev == null) {
                return;
            }
            if (p >= (v = prev.end) || v != x) {
                prev = null;
                continue;
            }
            if (p >= (x -= (long)this.bufFrames)) {
                i = (int)(p - x);
                this.load(prev, i, this.bufFrames - i);
                prev = null;
                continue;
            }
            this.load(prev, 0, this.bufFrames);
            prev = prev.prev;
        }
    }

    public void batch(Buf b) {
        if (!b.loaded) {
            logger.info("Waiting for loader...");
            while (!b.loaded) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            logger.info("Resume after loading...");
        }
    }

    protected abstract Buf createBuf(int var1);

    protected abstract void load(Buf var1) throws IOException;

    protected abstract void load(Buf var1, int var2, int var3) throws IOException;

    protected class Loader
    implements Runnable {
        private boolean stop = false;
        private int switchDelta = 0;
        private boolean skipped = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean forward = true;
                boolean skip = false;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Scratch loader started: " + AbstractScratchModelOLD.this);
                }
                while (true) {
                    Loader loader = this;
                    synchronized (loader) {
                        if (this.stop) {
                            break;
                        }
                        if (this.skipped) {
                            skip = true;
                            this.skipped = false;
                        } else if (this.switchDelta > 1) {
                            --this.switchDelta;
                            forward = true;
                        } else if (this.switchDelta < -1) {
                            ++this.switchDelta;
                            forward = false;
                        } else {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    if (skip) {
                        skip = false;
                        AbstractScratchModelOLD.this.loadAll();
                        continue;
                    }
                    AbstractScratchModelOLD.this.preload(forward);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                AbstractScratchModelOLD.this.loaderWork = null;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Scratch loader stopped: " + AbstractScratchModelOLD.this);
                }
            }
        }

        public synchronized void stop() {
            this.stop = true;
            this.notifyAll();
        }

        public void join() throws InterruptedException {
            Work work = AbstractScratchModelOLD.this.loaderWork;
            if (work != null) {
                work.join();
            }
        }

        public synchronized void switchFwd(int count) {
            this.switchDelta += count;
            if (this.switchDelta > 1) {
                this.notifyAll();
            }
        }

        public synchronized void switchBwd(int count) {
            this.switchDelta -= count;
            if (this.switchDelta < -1) {
                this.notifyAll();
            }
        }

        public synchronized void skip(boolean forward) {
            this.skipped = true;
            this.notifyAll();
        }
    }

    protected static abstract class Buf {
        protected Buf prev;
        protected Buf next;
        protected volatile long ofs;
        protected volatile long end;
        protected volatile boolean loaded;

        protected Buf() {
        }

        public String toString() {
            return super.toString() + "[ofs=" + this.ofs + ", end=" + this.end + "]";
        }
    }
}

