/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.old;

import com.spacekiller.util.Platform;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.waxlab.impl.WaxLabAudioProcessor;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OldWaxLabAudioProcessor
implements AudioProcessor {
    private static final Logger logger = Platform.getLogger(WaxLabAudioProcessor.class);
    private final WaxLabAudioSyncGroup syncGroup;
    private final String name;
    private final SampleBuffer[] in;
    private final SampleBuffer[] out;
    private final float frameRate;
    private final double millisPerFrame;
    private final double nanosPerFrame;
    private volatile boolean reset;
    private volatile long startTime;
    private volatile long framePos;
    private volatile long lastTime;
    private volatile int lastFrames;
    protected volatile double nanoDelta;
    private volatile AudioProcessor[] processors;
    private volatile AudioProcessor[] newProcessors;

    protected OldWaxLabAudioProcessor(WaxLabAudioSyncGroup syncGroup, String name, SampleBuffer[] in, SampleBuffer[] out) throws AudioException {
        this.syncGroup = syncGroup;
        this.name = name;
        this.in = in;
        this.out = out;
        this.frameRate = this.enumerateFrameRate(in, out);
        this.millisPerFrame = 1000.0 / (double)this.frameRate;
        this.nanosPerFrame = 1.0E9 / (double)this.frameRate;
        this.startTime = 0L;
        this.framePos = 0L;
        this.lastTime = 0L;
        this.lastFrames = 0;
        this.nanoDelta = 0.0;
        this.processors = null;
        this.newProcessors = new AudioProcessor[0];
        this.reset = true;
    }

    protected final WaxLabAudioSyncGroup getSyncGroup() {
        return this.syncGroup;
    }

    protected float enumerateFrameRate(SampleBuffer[] in, SampleBuffer[] out) throws AudioException {
        SampleBuffer sb;
        int i;
        float rate = -1.0f;
        for (i = 0; !(i >= in.length || (sb = in[i]) != null && (rate = sb.getFrameRate()) > 0.0f); ++i) {
        }
        if (rate <= 0.0f) {
            for (i = 0; !(i >= out.length || (sb = out[i]) != null && (rate = sb.getFrameRate()) > 0.0f); ++i) {
            }
        }
        if (rate <= 0.0f) {
            throw new AudioException("Invalid frame rate: " + rate);
        }
        return rate;
    }

    public void process(long time, int frames) throws AudioException {
        if (this.reset) {
            this.lastTime = this.startTime = time;
            this.lastFrames = frames;
            this.nanoDelta = 0.0;
            this.framePos = frames;
            this.processors = this.newProcessors;
            this.reset = false;
        } else {
            this.lastTime = time;
            this.lastFrames = frames;
            this.nanoDelta = (double)(time - this.startTime) - (double)this.framePos * this.nanosPerFrame;
            this.framePos += (long)frames;
        }
        AudioProcessor[] pr = this.processors;
        int n = pr.length;
        int i = 0;
        while (i < n) {
            pr[i++].process(time, frames);
        }
    }

    public void shutdown() throws AudioException {
        AudioProcessor[] pr = this.processors;
        if (pr != null) {
            int n = pr.length;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Shutdown old audio processors: " + n);
            }
            int i = 0;
            while (i < n) {
                pr[i++].shutdown();
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Shutdown old audio processors completed.");
            }
        }
    }

    protected void reset(AudioProcessor[] newProcs) {
        this.newProcessors = newProcs;
        this.reset = true;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public int getLastFrames() {
        return this.lastFrames;
    }

    public long getFramePosition() {
        return this.framePos;
    }

    public double getMillisecondPosition() {
        return (double)this.framePos * this.millisPerFrame;
    }

    public double getNanoPosition() {
        return (double)this.framePos * this.nanosPerFrame;
    }

    public double getNanoDelta() {
        return this.nanoDelta;
    }

    final SampleBuffer[] getIn() {
        return this.in;
    }

    final SampleBuffer[] getOut() {
        return this.out;
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }
}

