/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.old;

import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.spacekiller.util.sound.SampleCursor;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.fader.FaderCurve;

public class WaxLabScratchCursorFader
implements AudioProcessor {
    private final AudioProcessor ap;
    private final double[] da;
    private final int nc;
    private final SampleCursor fc;
    private final float[] fa;
    private final FaderCurve cv;
    private final float v0;

    public WaxLabScratchCursorFader(AudioProcessor ap, DoubleArraySampleBuffer sb, SampleCursor faderCursor, FaderCurve faderCurve) throws AudioException {
        this.ap = ap;
        this.da = sb.array();
        this.nc = sb.getChannels();
        this.fc = faderCursor;
        this.fa = new float[sb.getSamples() / this.nc];
        this.cv = faderCurve;
        this.v0 = this.cv.getVolume(0.0f);
        float rate = sb.getFrameRate();
        float faderRate = faderCursor.getFrameRate();
        if (faderRate != rate) {
            throw new AudioException("Invalid fader frame rate: " + faderRate + " != " + rate);
        }
    }

    public void process(long time, int frames) throws AudioException {
        this.ap.process(time, frames);
        this.fc.get(this.fa, 0, frames);
        int x = 0;
        float p = 0.0f;
        double v = this.v0;
        for (int i = 0; i < frames; ++i) {
            float f = this.fa[i];
            if (f != p) {
                p = f;
                v = this.cv.getVolume(f);
            }
            for (int k = 0; k < this.nc; ++k) {
                int n = x++;
                this.da[n] = this.da[n] * v;
            }
        }
    }

    public void shutdown() throws AudioException {
        this.fc.close();
        this.ap.shutdown();
    }

    public String toString() {
        return super.toString() + "[" + this.ap + "]";
    }
}

