/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.old;

import com.spacekiller.util.Platform;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleCursor;
import com.spacekiller.util.sound.SampleModel;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WaxLabScratchRecorderOld
implements AudioProcessor {
    private static final Logger logger = Platform.getLogger(WaxLabScratchRecorderOld.class);
    private final AudioProcessor ap;
    protected final SampleBuffer src;
    protected final int nc;
    protected final SampleCursor cur;
    private SampleModel audioModel;
    private boolean closeAudioModel;

    public WaxLabScratchRecorderOld(AudioProcessor ap, SampleBuffer src, SampleCursor dst, SampleModel audioModel, boolean closeAudioModel) throws AudioException {
        this.ap = ap;
        this.src = src;
        this.nc = src.getChannels();
        this.cur = dst;
        this.audioModel = audioModel;
        this.closeAudioModel = closeAudioModel;
        int channels = dst.getChannels();
        if (channels != this.nc) {
            throw new AudioException("Invalid number of target audio channels: " + channels + " != " + this.nc);
        }
    }

    public void process(long time, int frames) throws AudioException {
        int n = frames * this.nc;
        this.ap.process(time, frames);
        this.cur.set(this.src, 0, n);
    }

    public void shutdown() throws AudioException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Stopping scratch recorder: " + this);
        }
        this.ap.shutdown();
        this.cur.close();
        if (this.audioModel != null) {
            try {
                this.audioModel.flush();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (this.closeAudioModel && this.audioModel != null) {
            try {
                this.audioModel.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Scratch recorder stopped: " + this);
        }
    }
}

