/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.proc;

import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.fader.VolumeShader;

public class WaxLabAudioFader
implements AudioProcessor {
    private final int nc;
    private final VolumeShader[] vsa;
    private final double[] vol;
    private final double[] src;
    private final double[] dst;

    public WaxLabAudioFader(int nc, VolumeShader[] vsa, double[] vol, double[] src, double[] dst) {
        this.nc = nc;
        this.vsa = vsa;
        this.vol = vol;
        this.src = src;
        this.dst = dst;
    }

    public void process(long time, int frames) throws AudioException {
        int i = 0;
        while (i < this.nc) {
            this.vsa[i++].produce(time, frames);
        }
        int n = frames * this.nc;
        for (i = 0; i < n; ++i) {
            this.dst[i] = this.src[i] * this.vol[i];
        }
    }

    public void shutdown() throws AudioException {
    }
}

