/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.proc;

import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleCursor;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;

public class WaxLabAudioPlayer
implements AudioProcessor {
    private final String name;
    protected final SampleBuffer dst;
    protected final int nc;
    private boolean idle;
    protected final SampleCursor cur;
    protected long num;

    public WaxLabAudioPlayer(String name, SampleCursor cursor, long samples, SampleBuffer dst) throws AudioException {
        this.name = name;
        this.dst = dst;
        this.nc = dst.getChannels();
        this.cur = cursor;
        this.num = samples;
        this.idle = false;
        int mc = cursor.getChannels();
        if (mc != this.nc) {
            throw new AudioException("Invalid number of audio channels: " + mc + " != " + this.nc);
        }
    }

    public WaxLabAudioPlayer(String name, SampleCursor cursor, SampleBuffer dst) throws AudioException {
        this(name, cursor, Long.MAX_VALUE, dst);
    }

    public void process(long time, int frames) throws AudioException {
        int n = frames * this.nc;
        if ((long)n > this.num) {
            if (this.num > 0L) {
                int r = (int)this.num;
                this.cur.get(this.dst, 0, r);
                this.dst.clear(r, n - r);
                this.num = 0L;
            } else if (!this.idle) {
                this.dst.clear(0, this.dst.getSamples());
                this.idle = true;
            }
        } else {
            this.cur.get(this.dst, 0, n);
            this.num -= (long)n;
        }
    }

    public void shutdown() throws AudioException {
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }
}

