/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.proc;

import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleCursor;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.waxlab.AudioLine;

public class WaxLabAudioRecorder
implements AudioProcessor {
    private final String name;
    protected final SampleBuffer src;
    protected final int nc;
    protected final SampleCursor cur;
    private AudioLine audioLine;

    public WaxLabAudioRecorder(String name, SampleBuffer src, SampleCursor dst, AudioLine audioLine) throws AudioException {
        this.name = name;
        this.src = src;
        this.nc = src.getChannels();
        this.cur = dst;
        this.audioLine = audioLine;
        int channels = dst.getChannels();
        if (channels != this.nc) {
            throw new AudioException("Invalid number of target audio channels: " + channels + " != " + this.nc);
        }
    }

    protected AudioLine getAudioLine() {
        return this.audioLine;
    }

    public void process(long time, int frames) throws AudioException {
        this.cur.set(this.src, 0, frames * this.nc);
    }

    public void shutdown() throws AudioException {
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }
}

