/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.proc;

import com.spacekiller.util.Clock;
import com.spacekiller.util.Platform;
import com.spacekiller.util.midi.MidiFilter;
import com.spacekiller.util.midi.model.MidiNode;
import com.spacekiller.util.midi.model.Node;
import com.spacekiller.util.midi.model.NodeConsumer;
import com.spacekiller.util.midi.model.TrackNode;
import com.spacekiller.util.thread.ThreadPool;
import com.spacekiller.util.thread.Work;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.common.SysexMidiMsg;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.impl.MidiTrackReader;
import com.waxmonster.studio.SyncClock;
import com.waxmonster.waxlab.impl.MidiPlayer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.SysexMessage;

public class WaxLabMidiPlayer
implements MidiPlayer,
NodeConsumer {
    private static final Logger logger = Platform.getLogger(WaxLabMidiPlayer.class);
    private static final long WAIT_NANOS = -129542144L;
    protected ThreadPool threadPool;
    protected Work work;
    protected Thread thread;
    protected volatile boolean loop;
    protected volatile boolean play;
    protected volatile long stopLineOfs;
    protected volatile boolean stop;
    protected long sleep;
    protected final MidiTrackReader reader;
    protected final float tickRate;
    protected final MidiProcessor target;
    protected final Clock clock;
    protected long time;
    protected final SyncClock syncClock;
    protected long startTimeBase;
    protected MidiFilter midiFilter;
    private final Player player = new Player();
    private final SendAllNotesOff sendAllNotesOff = new SendAllNotesOff();

    public WaxLabMidiPlayer(MidiTrackReader reader, MidiFilter midiFilter, MidiProcessor target, Clock clock, SyncClock syncClock, ThreadPool threadPool) throws InterruptedException {
        this.threadPool = threadPool;
        this.reader = reader;
        this.tickRate = reader.getTickRate();
        this.target = target;
        this.clock = clock;
        this.syncClock = syncClock;
        this.stopLineOfs = Long.MAX_VALUE;
        this.setMidiFilter(midiFilter);
    }

    public long getStartTimeBase() {
        return this.startTimeBase;
    }

    public void setStartTimeBase(long startTimeBase) {
        this.startTimeBase = startTimeBase;
    }

    public MidiFilter getMidiFilter() {
        return this.midiFilter;
    }

    public void setMidiFilter(MidiFilter midiFilter) {
        if (midiFilter == null) {
            throw new NullPointerException("midiFilter");
        }
        this.midiFilter = midiFilter;
    }

    @Override
    public synchronized boolean isRunning() {
        return this.loop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() throws InterruptedException {
        WaxLabMidiPlayer waxLabMidiPlayer = this;
        synchronized (waxLabMidiPlayer) {
            if (this.loop) {
                return;
            }
            this.loop = true;
        }
        boolean success = false;
        try {
            this.work = this.threadPool.start((Runnable)this.player);
            this.thread = this.threadPool.getThread(this.work);
            success = true;
        }
        finally {
            if (!success) {
                WaxLabMidiPlayer waxLabMidiPlayer2 = this;
                synchronized (waxLabMidiPlayer2) {
                    this.loop = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        WaxLabMidiPlayer waxLabMidiPlayer = this;
        synchronized (waxLabMidiPlayer) {
            if (!this.loop) {
                return;
            }
            this.loop = false;
            this.play = false;
            this.stop = true;
            this.stopLineOfs = Long.MIN_VALUE;
        }
        this.reader.wakeup();
    }

    @Override
    public void play() {
        this.stop = false;
        this.play = true;
        this.reader.wakeup();
    }

    @Override
    public void stop() {
        this.play = false;
        this.stop = true;
        this.reader.wakeup();
    }

    @Override
    public long getStopLineOfs() {
        return this.stopLineOfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStopLineOfs(long stopLineOfs) {
        WaxLabMidiPlayer waxLabMidiPlayer = this;
        synchronized (waxLabMidiPlayer) {
            this.stopLineOfs = stopLineOfs;
        }
        this.reader.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loop() {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("WaxLabMidiPlayer thread started: " + this);
            }
            boolean finer = logger.isLoggable(Level.FINER);
            while (this.loop) {
                if (!this.play) {
                    if (finer) {
                        logger.finer("Waiting to start playback...");
                    }
                    try {
                        this.reader.sleep(-129542144L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                if (finer) {
                    logger.finer("Midi playback started: " + this);
                }
                while (true) {
                    this.sleep = Long.MAX_VALUE;
                    this.reader.read((NodeConsumer)this);
                    if (this.stop) break;
                    try {
                        this.reader.sleep(this.sleep);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (finer) {
                    logger.finer("Midi playback stopping: " + this);
                }
                this.stop = false;
                this.play = false;
                this.reader.getAllNotesOff((NodeConsumer)this.sendAllNotesOff);
                if (!finer) continue;
                logger.finer("Midi playback stopped: " + this);
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("WaxLabMidiPlayer thread stopped: " + this);
            }
        }
    }

    public boolean consume(Node node) {
        MidiNode tn = (MidiNode)node;
        long tick = tn.getTick();
        long p = LineUtil.getNanoOfs((long)tick, (double)this.tickRate);
        if (p >= this.stopLineOfs) {
            this.stop = true;
            return false;
        }
        long time = this.clock.nanos();
        long t = this.syncClock.nanoSync(time) - this.startTimeBase;
        if (p > t) {
            this.sleep = p - t;
            return false;
        }
        int len = tn.getLength();
        block0 : switch (len) {
            case 1: {
                int status = tn.getStatus();
                if (!this.midiFilter.accept(status)) break;
                this.target.process(time + p - t, status);
                break;
            }
            case 2: {
                int status = tn.getStatus();
                int data1 = tn.getData1();
                if (!this.midiFilter.accept(status, data1)) break;
                this.target.process(time + p - t, status, data1);
                break;
            }
            case 3: {
                int status = tn.getStatus();
                int data1 = tn.getData1();
                int data2 = tn.getData2();
                if (!this.midiFilter.accept(status, data1, data2)) break;
                this.target.process(time + p - t, status, data1, data2);
                break;
            }
            default: {
                switch (tn.getStatus()) {
                    case 240: {
                        if (len <= 0) break block0;
                        byte[] data = new byte[len];
                        tn.read(0, data, 0, len);
                        SysexMidiMsg sxm = new SysexMidiMsg(data);
                        if (!this.midiFilter.accept((MidiMessage)sxm)) break block0;
                        this.target.process(time + p - t, (SysexMessage)sxm);
                        break block0;
                    }
                }
            }
        }
        return true;
    }

    protected void sendNoteOff(long time, MidiNode node, int status) {
        int channel = status & 0xF;
        int noteIdx = node.getData1();
        status = 0x80 | channel;
        this.target.process(time, status, noteIdx, 0);
    }

    protected class SendAllNotesOff
    implements NodeConsumer {
        protected long time;

        protected SendAllNotesOff() {
        }

        public boolean consume(Node node) {
            TrackNode tn = (TrackNode)node;
            int status = tn.getStatus();
            switch (status & 0xF0) {
                case 144: {
                    if (tn.getData2() == 0) break;
                    WaxLabMidiPlayer.this.sendNoteOff(this.time, (MidiNode)tn, status);
                    break;
                }
                case 160: {
                    WaxLabMidiPlayer.this.sendNoteOff(this.time, (MidiNode)tn, status);
                }
            }
            return true;
        }
    }

    protected class Player
    implements Runnable {
        protected Player() {
        }

        @Override
        public void run() {
            WaxLabMidiPlayer.this.loop();
        }
    }
}

