/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.proc;

import com.spacekiller.util.midi.MidiFilter;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.model.MidiModel;
import com.waxmonster.model.impl.MidiTrackWriter;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

public class WaxLabMidiRecorder
implements MidiProcessor {
    protected final MidiModel model;
    protected final MidiTrackWriter writer;
    protected long startTime;
    protected MidiFilter midiFilter;

    public WaxLabMidiRecorder(MidiModel model, MidiTrackWriter writer, MidiFilter midiFilter) {
        this.model = model;
        this.writer = writer;
        this.setMidiFilter(midiFilter);
    }

    public void process(long time, int status) {
        if (this.midiFilter.accept(status)) {
            this.writer.writeNode(time - this.startTime, status);
        }
    }

    public void process(long time, int status, int data1) {
        if (this.midiFilter.accept(status, data1)) {
            this.writer.writeNode(time - this.startTime, status, data1);
        }
    }

    public void process(long time, int status, int data1, int data2) {
        if (this.midiFilter.accept(status, data1, data2)) {
            this.writer.writeNode(time - this.startTime, status, data1, data2);
        }
    }

    public void process(long time, ShortMessage sm) {
        if (this.midiFilter.accept((MidiMessage)sm)) {
            int len = sm.getLength();
            switch (len) {
                case 3: {
                    this.writer.writeNode(time - this.startTime, sm.getStatus(), sm.getData1(), sm.getData2());
                    return;
                }
                case 2: {
                    this.writer.writeNode(time - this.startTime, sm.getStatus(), sm.getData1());
                    return;
                }
                case 1: {
                    this.writer.writeNode(time - this.startTime, sm.getStatus());
                    return;
                }
            }
            byte[] data = sm.getMessage();
            this.writer.writeNode(time - this.startTime, sm.getStatus(), data, 0, len);
        }
    }

    public void process(long time, SysexMessage sm) {
        if (this.midiFilter.accept((MidiMessage)sm)) {
            int len = sm.getLength();
            byte[] data = sm.getMessage();
            this.writer.writeNode(time - this.startTime, sm.getStatus(), data, 0, len);
        }
    }

    public void shutdown() {
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public MidiFilter getMidiFilter() {
        return this.midiFilter;
    }

    public void setMidiFilter(MidiFilter midiFilter) {
        if (midiFilter == null) {
            throw new NullPointerException("midiFilter");
        }
        this.midiFilter = midiFilter;
    }
}

