/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.proc;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.timecode.TimecodeDecoder;

public class WaxLabTimecodeAudioProcessor
implements AudioProcessor {
    private String name;
    private SampleBuffer buf;
    private TimecodeDecoder dec;

    public WaxLabTimecodeAudioProcessor(String name, TimecodeDecoder dec, SampleBuffer buf) {
        this.name = name;
        this.setTimecodeDecoder(dec);
        this.setSampleBuffer(buf);
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }

    protected TimecodeDecoder getTimecodeDecoder() {
        return this.dec;
    }

    protected void setTimecodeDecoder(TimecodeDecoder dec) {
        if (dec == null) {
            throw new NullPointerException("TimecodeDecoder is null");
        }
        this.dec = dec;
    }

    protected SampleBuffer getSampleBuffer() {
        return this.buf;
    }

    protected void setSampleBuffer(SampleBuffer buf) {
        if (buf == null) {
            throw new NullPointerException("SampleBuffer is null");
        }
        this.buf = buf;
    }

    public void process(long time, int frames) throws AudioException {
        this.dec.decode(time, this.buf, 0, frames * 2);
    }

    public void shutdown() throws AudioException {
        this.dec.close();
    }
}

