/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.proc;

import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.timecode.TimecodeDecoder;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

public class WaxLabTimecodeMidiProcessor
implements MidiProcessor {
    private String name;
    private volatile TimecodeDecoder dec;

    public WaxLabTimecodeMidiProcessor(String name, TimecodeDecoder dec) {
        this.name = name;
        this.setTimecodeDecoder(dec);
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }

    protected TimecodeDecoder getTimecodeDecoder() {
        return this.dec;
    }

    protected void setTimecodeDecoder(TimecodeDecoder dec) {
        if (dec == null) {
            throw new NullPointerException("TimecodeDecoder is null");
        }
        this.dec = dec;
    }

    public void process(long time, int status) {
        this.dec.handle(time, status, 0, 0);
    }

    public void process(long time, int status, int data1) {
        this.dec.handle(time, status, data1, 0);
    }

    public void process(long time, int status, int data1, int data2) {
        this.dec.handle(time, status, data1, data2);
    }

    public void process(long time, ShortMessage mc) {
        int len = mc.getLength();
        switch (len) {
            case 1: {
                this.process(time, mc.getStatus());
                return;
            }
            case 2: {
                this.process(time, mc.getStatus(), mc.getData1());
                return;
            }
            case 3: {
                this.process(time, mc.getStatus(), mc.getData1(), mc.getData2());
                return;
            }
        }
    }

    public void process(long time, SysexMessage sm) {
    }

    public void shutdown() {
        this.dec.close();
    }
}

