/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.proc;

import com.spacekiller.util.Platform;
import com.spacekiller.util.sound.SampleCursor;
import com.spacekiller.util.sound.SampleModel;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WaxLabTimecodeRecorder
implements AudioProcessor {
    private static final Logger logger = Platform.getLogger(WaxLabTimecodeRecorder.class);
    protected final double[] buf;
    protected final SampleCursor cur;
    private SampleModel timecodeModel;

    public WaxLabTimecodeRecorder(double[] timecodeBuffer, SampleCursor targetTimecodeCursor, SampleModel timecodeModel) {
        this.buf = timecodeBuffer;
        this.cur = targetTimecodeCursor;
        this.timecodeModel = timecodeModel;
    }

    public void process(long time, int frames) throws AudioException {
        this.cur.set(this.buf, 0, frames);
    }

    public void shutdown() throws AudioException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Closing timecode recorder: " + this);
        }
        this.cur.close();
        if (this.timecodeModel != null) {
            try {
                this.timecodeModel.flush();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Timecode recorder closed: " + this);
        }
    }
}

