/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.util;

import com.spacekiller.util.FileLocator;
import com.spacekiller.util.FileResource;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Resource;
import com.spacekiller.util.Tools;
import com.spacekiller.util.URIResource;
import com.spacekiller.util.URLResource;
import com.spacekiller.util.media.MediaEntry;
import com.waxmonster.editor.WaxEditorModel;
import com.waxmonster.fader.FaderConfig;
import com.waxmonster.fader.FaderCurve;
import com.waxmonster.fader.impl.AbstractFaderCurve;
import com.waxmonster.fader.impl.FaderCurveUtil;
import com.waxmonster.fader.midi.DefaultMidiFaderConfig;
import com.waxmonster.fader.midi.MidiFaderConfig;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.model.AudioModel;
import com.waxmonster.model.ChunkModel;
import com.waxmonster.model.FaderModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.LineModel;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.MidiModel;
import com.waxmonster.model.MidiTrack;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.impl.CachedAudioModel;
import com.waxmonster.model.impl.CachedFaderModel;
import com.waxmonster.model.impl.CachedTimecodeModel;
import com.waxmonster.waxlab.AudioLine;
import com.waxmonster.waxlab.AudioLineConfig;
import com.waxmonster.waxlab.EditorLine;
import com.waxmonster.waxlab.EditorLineConfig;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.MidiLine;
import com.waxmonster.waxlab.MidiLineConfig;
import com.waxmonster.waxlab.ScratchLine;
import com.waxmonster.waxlab.TimecodeLine;
import com.waxmonster.waxlab.TimecodeLineConfig;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import com.waxmonster.waxlab.impl.WaxLabLiveFeederResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WaxLabXmlUtil {
    public static final String NAMESPACE = "https://waxmonster.com/waxlab/";
    public static final String XSD_URLS = "https://waxmonster.com/schema/ waxmonster_waxlab_V1.xsd";
    protected static final String SAMPLE_TYPE_SIGNED_16 = "PCM_SIGNED_16";
    protected static final String SAMPLE_TYPE_SIGNED_24 = "PCM_SIGNED_24";
    protected static final String SAMPLE_TYPE_SIGNED_32 = "PCM_SIGNED_32";
    protected static final String SAMPLE_TYPE_FLOAT_32 = "PCM_FLOAT_32";
    protected static final String SAMPLE_TYPE_FLOAT_64 = "PCM_FLOAT_64";
    protected static final String FRAME_TYPE_MONO = "mono";
    protected static final String FRAME_TYPE_STEREO = "stereo";
    public static final String MODEL_TYPE_AUDIO = "audio";
    public static final String MODEL_TYPE_TIMECODE = "timecode";
    public static final String MODEL_TYPE_FADER = "fader";
    public static final String MODEL_TYPE_MIDI = "midi";
    public static final String MODEL_TYPE_EDITOR = "editor";
    protected static final String RESOURCE_TYPE_LIVE = "live";
    protected static final String RESOURCE_TYPE_FILE = "file";
    protected static final String RESOURCE_TYPE_URL = "url";
    protected static final String RESOURCE_TYPE_URI = "uri";
    protected static final String PROPERTY_PREFIX_MIDI_MAPPING = "MidiActionMapping.";
    protected static final String PROPERTY_PREFIX_MIDI_TRIGGER = "MidiEventTrigger.";
    protected static final String RESOURCE_ID_PREFIX = "Res#";
    protected static final String LIVE_FEED_RESOURCE = "LiveFeed";
    private static final Logger logger = Logger.getLogger(WaxLabXmlUtil.class.getName());
    private WaxLab waxLab;
    private WaxLabDevice waxLabDevice;
    private Map waxLabPortMap;
    private List errors;
    private long nextModelId = 1L;
    private long nextResourceId = 1L;

    public WaxLabXmlUtil(WaxLab waxLab, WaxLabDevice waxLabDevice) {
        this.waxLab = waxLab;
        this.waxLabDevice = waxLabDevice;
        this.waxLabPortMap = new HashMap();
        this.errors = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStudioConfig(File file, boolean includeModelFiles) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element elStudio = this.createWaxLabElement(doc, includeModelFiles, file);
            doc.appendChild(elStudio);
            DOMSource source = new DOMSource(doc);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer trans = transFactory.newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            FileOutputStream fos = new FileOutputStream(file);
            try {
                StreamResult result = new StreamResult(fos);
                trans.transform(source, result);
            }
            finally {
                fos.close();
            }
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    protected Element createWaxLabElement(Document doc, boolean includeModelFiles, File waxLabFile) {
        String lineId;
        Line line;
        int i;
        MidiTrigger[] midiTriggers;
        WaxLabPortInfo midiOutputPort;
        String midiOutputPortId;
        WaxLabPortInfo midiInputPort;
        String midiInputPortId;
        WaxLabPortInfo clockAudioPort;
        String clockAudioPortId;
        File baseDir = waxLabFile.getParentFile();
        Element elStudio = doc.createElementNS(NAMESPACE, "waxlab");
        elStudio.setPrefix("tns");
        Attr attr = doc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation");
        attr.setValue(XSD_URLS);
        elStudio.setAttributeNode(attr);
        File contentDir = this.waxLab.getContentDirectory();
        if (contentDir == null) {
            contentDir = baseDir;
        } else {
            File dirFile;
            String contentDirPath = contentDir.getPath();
            if (baseDir != null) {
                contentDirPath = this.relativeDirectoryPath(contentDir, baseDir);
            }
            if ((dirFile = new File(contentDirPath)).isAbsolute()) {
                contentDirPath = Tools.getFileURI((File)dirFile).getPath();
            }
            elStudio.setAttribute("contentDirectory", contentDirPath);
        }
        String clockType = this.waxLab.getClockType();
        if (clockType != null) {
            elStudio.setAttribute("clockType", clockType);
        }
        String string = clockAudioPortId = (clockAudioPort = this.waxLab.getClockAudioPort()) == null ? null : clockAudioPort.getId();
        if (clockAudioPortId != null) {
            elStudio.setAttribute("clockAudioPort", clockAudioPortId);
        }
        String string2 = midiInputPortId = (midiInputPort = this.waxLab.getMidiInputPort()) == null ? null : midiInputPort.getId();
        if (midiInputPortId != null) {
            elStudio.setAttribute("midiInputPort", midiInputPortId);
        }
        String string3 = midiOutputPortId = (midiOutputPort = this.waxLab.getMidiOutputPort()) == null ? null : midiOutputPort.getId();
        if (midiOutputPortId != null) {
            elStudio.setAttribute("midiOutputPort", midiOutputPortId);
        }
        LinkedList<Element> propertyElements = new LinkedList<Element>();
        LinkedList<Element> resourceElements = new LinkedList<Element>();
        LinkedList<Element> lineElements = new LinkedList<Element>();
        LinkedList<Element> modelElements = new LinkedList<Element>();
        LinkedList<Element> chunkElements = new LinkedList<Element>();
        HashMap<Line, String> line2IdMap = new HashMap<Line, String>();
        HashMap<LineModel, String> model2IdMap = new HashMap<LineModel, String>();
        HashMap<Resource, String> resource2IdMap = new HashMap<Resource, String>();
        Properties props = this.waxLab.getProperties();
        for (Map.Entry<Object, Object> me : props.entrySet()) {
            String value;
            String key = String.valueOf(me.getKey());
            Element elProp = this.createPropertyElement(doc, "property", key, value = String.valueOf(me.getValue()));
            if (elProp == null) continue;
            propertyElements.add(elProp);
        }
        MidiMapping[] midiMappings = this.waxLab.getMidiMappings();
        if (midiMappings != null) {
            for (int i2 = 0; i2 < midiMappings.length; ++i2) {
                String value;
                String key;
                Element elProp;
                MidiMapping mam = midiMappings[i2];
                if (mam == null || (elProp = this.createPropertyElement(doc, "property", key = PROPERTY_PREFIX_MIDI_MAPPING + String.valueOf(1000 + i2).substring(1), value = this.formatMidiMapping(mam))) == null) continue;
                propertyElements.add(elProp);
            }
        }
        if ((midiTriggers = this.waxLab.getMidiTriggers()) != null) {
            for (int i3 = 0; i3 < midiTriggers.length; ++i3) {
                String value;
                String key;
                Element elProp;
                MidiTrigger trigger = midiTriggers[i3];
                if (trigger == null || (elProp = this.createPropertyElement(doc, "property", key = PROPERTY_PREFIX_MIDI_TRIGGER + String.valueOf(1000 + i3).substring(1), value = this.formatMidiTrigger(trigger))) == null) continue;
                propertyElements.add(elProp);
            }
        }
        Line[] lines = this.waxLab.getLines();
        for (i = 0; i < lines.length; ++i) {
            line = lines[i];
            lineId = "Line#" + (i + 1);
            line2IdMap.put(line, lineId);
        }
        for (i = 0; i < lines.length; ++i) {
            Element elLine;
            line = lines[i];
            lineId = (String)line2IdMap.get(line);
            if (line instanceof AudioLine) {
                elLine = this.createAudioLineElement(doc, (AudioLine)line, lineId);
            } else if (line instanceof MidiLine) {
                elLine = this.createMidiLineElement(doc, (MidiLine)line, lineId);
            } else if (line instanceof TimecodeLine) {
                elLine = this.createTimecodeLineElement(doc, (TimecodeLine)line, lineId, contentDir, line2IdMap, resource2IdMap, resourceElements);
            } else if (line instanceof EditorLine) {
                elLine = this.createEditorLineElement(doc, (EditorLine)line, lineId, contentDir, line2IdMap, resource2IdMap, resourceElements);
            } else {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.warning("Unsupported line type: " + line.getClass());
                continue;
            }
            if (elLine == null) continue;
            lineElements.add(elLine);
        }
        if (includeModelFiles) {
            for (i = 0; i < lines.length; ++i) {
                line = lines[i];
                lineId = (String)line2IdMap.get(line);
                ChunkModel chunkModel = line.getChunkModel();
                LineChunk[] lineChunks = chunkModel.getChunks(new LineChunk[chunkModel.getChunkCount()]);
                for (int k = 0; k < lineChunks.length; ++k) {
                    Element elChunk;
                    LineChunk lineChunk = lineChunks[k];
                    long chunkOfs = lineChunk.getChunkOfs();
                    long chunkEnd = lineChunk.getChunkEnd();
                    long modelOfs = lineChunk.getModelOfs();
                    long modelEnd = lineChunk.getModelEnd();
                    LineModel lineModel = lineChunk.getLineModel();
                    String modelType = null;
                    Resource resource = null;
                    String[] trackIds = null;
                    String modelName = null;
                    if (lineModel != null) {
                        modelType = this.getModelType(lineModel);
                        if (modelType == null) {
                            IOException e = new IOException("Unsupported model type: model=" + lineModel + ", chunk=" + lineChunk);
                            logger.log(Level.SEVERE, e.getMessage(), e);
                            this.errors.add(e);
                        } else {
                            resource = lineModel.getResource();
                            trackIds = lineModel.getTrackIds();
                            modelName = lineModel.getName();
                            if (resource == null) {
                                logger.info("FIXME line=" + line.getName() + ", lineChunk=" + lineChunk + ", lineModel=" + lineModel + ", resource=" + resource);
                            }
                        }
                    }
                    String resourceId = null;
                    if (resource != null && (resourceId = (String)resource2IdMap.get(resource)) == null) {
                        resourceId = RESOURCE_ID_PREFIX + this.nextResourceId++;
                        resource2IdMap.put(resource, resourceId);
                        Element elResource = this.createResourceElement(doc, resourceId, resource, contentDir);
                        if (elResource != null) {
                            resourceElements.add(elResource);
                        }
                    }
                    String modelId = null;
                    if (modelType != null && resourceId != null && (modelId = (String)model2IdMap.get(lineModel)) == null) {
                        modelId = "Model#" + this.nextModelId++;
                        model2IdMap.put(lineModel, modelId);
                        Element elModel = this.createModelElement(doc, modelId, modelType, resourceId, trackIds, modelName);
                        if (elModel != null) {
                            modelElements.add(elModel);
                        }
                    }
                    if (modelId == null || (elChunk = this.createChunkElement(doc, lineId, chunkOfs, chunkEnd, modelId, modelOfs, modelEnd)) == null) continue;
                    chunkElements.add(elChunk);
                }
            }
        }
        for (Element element : propertyElements) {
            elStudio.appendChild(element);
        }
        for (Element element : resourceElements) {
            elStudio.appendChild(element);
        }
        for (Element element : lineElements) {
            elStudio.appendChild(element);
        }
        for (Element element : modelElements) {
            elStudio.appendChild(element);
        }
        for (Element element : chunkElements) {
            elStudio.appendChild(element);
        }
        return elStudio;
    }

    protected String relativeFilePath(File file, File baseDir) {
        if (file == null) {
            return null;
        }
        if (baseDir != null) {
            File parentDir;
            String basePath = baseDir.getPath();
            if (!basePath.endsWith(File.separator)) {
                basePath = basePath + File.separator;
            }
            if ((parentDir = file.getParentFile()) != null) {
                String parentPath = parentDir.getPath();
                if (!parentPath.endsWith(File.separator)) {
                    parentPath = parentPath + File.separator;
                }
                if (parentPath.startsWith(basePath)) {
                    String relativePath = parentPath.substring(basePath.length());
                    return relativePath + file.getName();
                }
            }
        }
        return file.getPath();
    }

    protected String relativeDirectoryPath(File dir, File baseDir) {
        if (dir == null) {
            return null;
        }
        if (baseDir != null) {
            String dirPath;
            String basePath = baseDir.getPath();
            if (!basePath.endsWith(File.separator)) {
                basePath = basePath + File.separator;
            }
            if (!(dirPath = dir.getPath()).endsWith(File.separator)) {
                dirPath = dirPath + File.separator;
            }
            if (dirPath.startsWith(basePath)) {
                String relativePath = dirPath.substring(basePath.length());
                if (relativePath.length() < 1) {
                    relativePath = ".";
                }
                return relativePath;
            }
        }
        return dir.getPath();
    }

    protected String getModelType(LineModel lineModel) {
        if (lineModel == null) {
            return null;
        }
        if (lineModel instanceof AudioModel) {
            return MODEL_TYPE_AUDIO;
        }
        if (lineModel instanceof MidiModel) {
            return MODEL_TYPE_MIDI;
        }
        if (lineModel instanceof FaderModel) {
            return MODEL_TYPE_FADER;
        }
        if (lineModel instanceof TimecodeModel) {
            return MODEL_TYPE_TIMECODE;
        }
        if (lineModel instanceof WaxEditorModel) {
            return MODEL_TYPE_EDITOR;
        }
        return null;
    }

    protected Element createResourceElement(Document doc, String resourceId, Resource resource, File baseDir) {
        if (resource instanceof WaxLabLiveFeederResource) {
            String type = RESOURCE_TYPE_LIVE;
            String path = "";
            return this.createResourceElement(doc, resourceId, type, path);
        }
        try {
            File file = resource.getFile();
            if (file != null) {
                String type = null;
                String path = this.relativeFilePath(file, baseDir);
                return this.createResourceElement(doc, resourceId, type, path);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            this.errors.add(e);
        }
        try {
            URL url = resource.getURL();
            if (url != null) {
                String type = RESOURCE_TYPE_URL;
                String path = url.toString();
                return this.createResourceElement(doc, resourceId, type, path);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            this.errors.add(e);
        }
        try {
            URI uri = resource.getURI();
            if (uri != null) {
                String type = RESOURCE_TYPE_URI;
                String path = uri.toString();
                return this.createResourceElement(doc, resourceId, type, path);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            this.errors.add(e);
        }
        IOException e = new IOException("Unsupported resource: " + resource);
        logger.log(Level.SEVERE, e.getMessage(), e);
        this.errors.add(e);
        return null;
    }

    protected Element createResourceElement(Document doc, String resourceId, String type, String path) {
        Element el = doc.createElement("resource");
        el.setAttribute("id", resourceId);
        if (type != null) {
            el.setAttribute("type", type);
        }
        el.setAttribute("path", path);
        return el;
    }

    protected Element createModelElement(Document doc, String modelId, String modelType, String resourceId, String[] trackIds, String modelName) {
        int num;
        Element el = doc.createElement("model");
        el.setAttribute("id", modelId);
        el.setAttribute("type", modelType);
        el.setAttribute("resourceId", resourceId);
        if (trackIds != null && (num = trackIds.length) > 0) {
            el.setAttribute("trackIds", this.formatTrackIds(trackIds));
        }
        if (modelName != null && modelName.length() > 0) {
            el.setAttribute("name", modelName);
        }
        return el;
    }

    protected Element createChunkElement(Document doc, String lineId, long chunkOfs, long chunkEnd, String modelId, long modelOfs, long modelEnd) {
        Element el = doc.createElement("chunk");
        el.setAttribute("lineId", lineId);
        el.setAttribute("chunkOfs", this.formatNanos(chunkOfs));
        el.setAttribute("chunkEnd", this.formatNanos(chunkEnd));
        el.setAttribute("modelId", modelId);
        el.setAttribute("modelOfs", this.formatNanos(modelOfs));
        el.setAttribute("modelEnd", this.formatNanos(modelEnd));
        return el;
    }

    protected Element createAudioLineElement(Document doc, AudioLine line, String lineId) {
        String audioRenderMode;
        int recSampleType;
        AudioLineConfig config = line.getAudioLineConfig();
        Element el = doc.createElement("line");
        el.setAttribute("xsi:type", "tns:AudioLine");
        el.setAttribute("id", lineId);
        String name = line.getName();
        if (name != null) {
            el.setAttribute("name", name);
        }
        el.setAttribute("trackSize", Integer.toString(line.getTrackSize()));
        el.setAttribute("recordingEnabled", Boolean.toString(config.isRecordingEnabled()));
        int recFrameType = config.getRecordingFrameType();
        if (recFrameType >= 0) {
            el.setAttribute("recordingFrameType", this.formatFrameType(recFrameType));
        }
        if ((recSampleType = config.getRecordingSampleType()) >= 0) {
            el.setAttribute("recordingSampleType", this.formatSampleType(recSampleType));
        }
        el.setAttribute("recordingPorts", this.formatPortIds(config.getRecordingPorts()));
        el.setAttribute("playbackEnabled", Boolean.toString(config.isPlaybackEnabled()));
        int playFrameType = config.getPlaybackFrameType();
        if (playFrameType >= 0) {
            el.setAttribute("playbackFrameType", this.formatFrameType(playFrameType));
        }
        el.setAttribute("playbackPorts", this.formatPortIds(config.getPlaybackPorts()));
        if (config.isBackgroundShading()) {
            el.setAttribute("backgroundShading", Boolean.toString(config.isBackgroundShading()));
        }
        if ((audioRenderMode = config.getAudioRenderMode()) != null) {
            el.setAttribute("audioRenderMode", audioRenderMode);
        }
        Properties props = line.getProperties();
        for (Map.Entry<Object, Object> me : props.entrySet()) {
            String value;
            String key = String.valueOf(me.getKey());
            Element elProp = this.createPropertyElement(doc, "property", key, value = String.valueOf(me.getValue()));
            if (elProp == null) continue;
            el.appendChild(elProp);
        }
        return el;
    }

    protected Element createTimecodeLineElement(Document doc, TimecodeLine line, String lineId, File contentDir, Map line2IdMap, Map resource2IdMap, List resourceElements) {
        MidiTrigger[] triggers;
        String pitchMode;
        Resource resource;
        WaxLabPortInfo timecodeMidiInputPort;
        String timecodeMidiInputPortId;
        WaxLabPortInfo midiOutputPort;
        String midiOutputPortId;
        WaxLabPortInfo midiInputPort;
        String midiInputPortId;
        TimecodeLineConfig config = line.getTimecodeLineConfig();
        Element el = doc.createElement("line");
        el.setAttribute("xsi:type", "tns:TimecodeLine");
        el.setAttribute("id", lineId);
        String name = line.getName();
        if (name != null) {
            el.setAttribute("name", name);
        }
        el.setAttribute("trackSize", Integer.toString(line.getTrackSize()));
        el.setAttribute("recordingEnabled", Boolean.toString(config.isRecordingEnabled()));
        el.setAttribute("recordingPorts", this.formatPortIds(config.getRecordingPorts()));
        String tcName = config.getTimecodeFormatName();
        if (tcName != null) {
            el.setAttribute("timecodeFormatName", tcName);
        }
        el.setAttribute("playbackEnabled", Boolean.toString(config.isPlaybackEnabled()));
        el.setAttribute("scratchingEnabled", Boolean.toString(config.isScratchingEnabled()));
        int playFrameType = config.getPlaybackFrameType();
        if (playFrameType >= 0) {
            el.setAttribute("playbackFrameType", this.formatFrameType(playFrameType));
        }
        el.setAttribute("preFaderEnabled", String.valueOf(config.isPreFaderEnabled()));
        el.setAttribute("preFaderVolume", String.valueOf(config.getPreFaderVolume()));
        el.setAttribute("preFaderPorts", this.formatPortIds(config.getPreFaderPorts()));
        el.setAttribute("postFaderEnabled", String.valueOf(config.isPostFaderEnabled()));
        el.setAttribute("postFaderVolume", String.valueOf(config.getPostFaderVolume()));
        el.setAttribute("postFaderPorts", this.formatPortIds(config.getPostFaderPorts()));
        MidiLine midiInputLine = config.getFaderMidiLine();
        String midiInputLineId = (String)line2IdMap.get(midiInputLine);
        if (midiInputLineId != null) {
            el.setAttribute("faderMidiLine", midiInputLineId);
        }
        String string = midiInputPortId = (midiInputPort = config.getMidiInputPort()) == null ? null : midiInputPort.getId();
        if (midiInputPortId != null) {
            el.setAttribute("midiInputPort", midiInputPortId);
        }
        String string2 = midiOutputPortId = (midiOutputPort = config.getMidiOutputPort()) == null ? null : midiOutputPort.getId();
        if (midiOutputPortId != null) {
            el.setAttribute("midiOutputPort", midiOutputPortId);
        }
        String string3 = timecodeMidiInputPortId = (timecodeMidiInputPort = config.getTimecodeMidiInputPort()) == null ? null : timecodeMidiInputPort.getId();
        if (timecodeMidiInputPortId != null) {
            el.setAttribute("timecodeMidiInputPort", timecodeMidiInputPortId);
        }
        if ((resource = line.getScratchAudioResource()) != null) {
            String resourceId = (String)resource2IdMap.get(resource);
            if (resourceId == null) {
                resourceId = RESOURCE_ID_PREFIX + this.nextResourceId++;
                resource2IdMap.put(resource, resourceId);
                Element elResource = this.createResourceElement(doc, resourceId, resource, contentDir);
                if (elResource != null) {
                    resourceElements.add(elResource);
                }
            }
            if (resourceId != null) {
                el.setAttribute("scratchResourceId", resourceId);
            }
        }
        el.setAttribute("liveFeedPorts", this.formatPortIds(config.getLiveFeedPorts()));
        String scratchMode = config.getScratchMode();
        if (scratchMode != null) {
            el.setAttribute("scratchMode", scratchMode);
        }
        if ((pitchMode = config.getPitchMode()) != null) {
            el.setAttribute("pitchMode", pitchMode);
        }
        el.setAttribute("pitchFactor", String.valueOf(config.getPitchFactor()));
        el.setAttribute("pitchMin", String.valueOf(config.getPitchMin()));
        el.setAttribute("pitchMax", String.valueOf(config.getPitchMax()));
        el.setAttribute("pitchBPM", String.valueOf(config.getPitchBPM()));
        ScratchLine pitchLine = config.getPitchLine();
        String pitchLineId = (String)line2IdMap.get(pitchLine);
        if (pitchLineId != null) {
            el.setAttribute("pitchLine", pitchLineId);
        }
        el.setAttribute("jumpBeats", String.valueOf(config.getJumpBeats()));
        el.setAttribute("sliceBeats", String.valueOf(config.getSliceBeats()));
        el.setAttribute("cuePointCount", String.valueOf(config.getCuePointCount()));
        el.setAttribute("resampleRate", String.valueOf(config.getResampleRate()));
        el.setAttribute("audioFaderEnabled", Boolean.toString(config.isAudioFaderEnabled()));
        FaderConfig[] faderConfigs = config.getAudioFaderConfigs();
        if (faderConfigs != null) {
            for (int i = 0; i < faderConfigs.length; ++i) {
                Element elFaderConfig;
                FaderConfig faderConfig = faderConfigs[i];
                if (faderConfig == null || (elFaderConfig = this.createFaderConfigElement(doc, faderConfig, "faderConfig")) == null) continue;
                el.appendChild(elFaderConfig);
            }
        }
        if (config.isInvertedView()) {
            el.setAttribute("invertedView", Boolean.toString(config.isInvertedView()));
        }
        if (!config.isFaderShadingView()) {
            el.setAttribute("faderShadingView", Boolean.toString(config.isFaderShadingView()));
        }
        if (!config.isTimecodeAutoScrolling()) {
            el.setAttribute("timecodeAutoScrolling", Boolean.toString(config.isTimecodeAutoScrolling()));
        }
        if (!config.isScratchPositionViewEnabled()) {
            el.setAttribute("scratchPositionViewEnabled", Boolean.toString(config.isScratchPositionViewEnabled()));
        }
        if (!config.isBeatCompassViewEnabled()) {
            el.setAttribute("beatCompassViewEnabled", Boolean.toString(config.isBeatCompassViewEnabled()));
        }
        if (!config.isBeatRadarViewEnabled()) {
            el.setAttribute("beatRadarViewEnabled", Boolean.toString(config.isBeatRadarViewEnabled()));
        }
        Properties props = line.getProperties();
        for (Map.Entry<Object, Object> me : props.entrySet()) {
            String value;
            String key = String.valueOf(me.getKey());
            Element elProp = this.createPropertyElement(doc, "property", key, value = String.valueOf(me.getValue()));
            if (elProp == null) continue;
            el.appendChild(elProp);
        }
        MidiMapping[] midiActionMappings = line.getMidiMappings();
        if (midiActionMappings != null) {
            for (int i = 0; i < midiActionMappings.length; ++i) {
                String value;
                String key;
                Element elProp;
                MidiMapping mam = midiActionMappings[i];
                if (mam == null || (elProp = this.createPropertyElement(doc, "property", key = PROPERTY_PREFIX_MIDI_MAPPING + String.valueOf(1000 + i).substring(1), value = this.formatMidiMapping(mam))) == null) continue;
                el.appendChild(elProp);
            }
        }
        if ((triggers = line.getMidiTriggers()) != null) {
            for (int i = 0; i < triggers.length; ++i) {
                String value;
                String key;
                Element elProp;
                MidiTrigger trigger = triggers[i];
                if (trigger == null || (elProp = this.createPropertyElement(doc, "property", key = PROPERTY_PREFIX_MIDI_TRIGGER + String.valueOf(1000 + i).substring(1), value = this.formatMidiTrigger(trigger))) == null) continue;
                el.appendChild(elProp);
            }
        }
        return el;
    }

    protected Element createEditorLineElement(Document doc, EditorLine line, String lineId, File contentDir, Map line2IdMap, Map resource2IdMap, List resourceElements) {
        Element curveElement;
        FaderCurve curve;
        EditorLineConfig config = line.getEditorLineConfig();
        Element el = doc.createElement("line");
        el.setAttribute("xsi:type", "tns:EditorLine");
        el.setAttribute("id", lineId);
        String name = line.getName();
        if (name != null) {
            el.setAttribute("name", name);
        }
        el.setAttribute("trackSize", Integer.toString(line.getTrackSize()));
        el.setAttribute("playbackEnabled", Boolean.toString(config.isPlaybackEnabled()));
        int playFrameType = config.getPlaybackFrameType();
        if (playFrameType >= 0) {
            el.setAttribute("playbackFrameType", this.formatFrameType(playFrameType));
        }
        el.setAttribute("playbackPorts", this.formatPortIds(config.getPlaybackPorts()));
        el.setAttribute("playbackVolume", String.valueOf(config.getVolumeFactor()));
        el.setAttribute("pitchFactor", String.valueOf(config.getPitchFactor()));
        el.setAttribute("pitchMin", String.valueOf(config.getPitchMin()));
        el.setAttribute("pitchMax", String.valueOf(config.getPitchMax()));
        el.setAttribute("resampleRate", String.valueOf(config.getResampleRate()));
        if (config.isInvertedView()) {
            el.setAttribute("invertedView", "" + config.isInvertedView());
        }
        if (config.isHideTimecodePoints()) {
            el.setAttribute("hideTimecodePoints", "" + config.isHideTimecodePoints());
        }
        if (config.isHideFaderPoints()) {
            el.setAttribute("hideFaderPoints", "" + config.isHideFaderPoints());
        }
        if (!config.isTimecodeAutoScrolling()) {
            el.setAttribute("timecodeAutoScrolling", "" + config.isTimecodeAutoScrolling());
        }
        if ((curve = config.getFaderCurve()) != null && (curveElement = this.createFaderCurveElement(doc, curve, "faderCurve")) != null) {
            el.appendChild(curveElement);
        }
        Properties props = line.getProperties();
        for (Map.Entry<Object, Object> me : props.entrySet()) {
            String value;
            String key = String.valueOf(me.getKey());
            Element elProp = this.createPropertyElement(doc, "property", key, value = String.valueOf(me.getValue()));
            if (elProp == null) continue;
            el.appendChild(elProp);
        }
        return el;
    }

    protected Element createMidiLineElement(Document doc, MidiLine line, String lineId) {
        WaxLabPortInfo playPort;
        String playPortId;
        String recPortId;
        MidiLineConfig config = line.getMidiLineConfig();
        Element el = doc.createElement("line");
        el.setAttribute("xsi:type", "tns:MidiLine");
        el.setAttribute("id", lineId);
        String name = line.getName();
        if (name != null) {
            el.setAttribute("name", name);
        }
        el.setAttribute("trackSize", Integer.toString(line.getTrackSize()));
        el.setAttribute("recordingTickRate", this.formatFloat(config.getRecordingTickRate()));
        el.setAttribute("recordingEnabled", "" + config.isRecordingEnabled());
        el.setAttribute("playbackEnabled", "" + config.isPlaybackEnabled());
        WaxLabPortInfo recPort = config.getRecordingPort();
        String string = recPortId = recPort == null ? null : recPort.getId();
        if (recPortId != null) {
            el.setAttribute("recordingPort", recPortId);
        }
        String string2 = playPortId = (playPort = config.getPlaybackPort()) == null ? null : playPort.getId();
        if (playPortId != null) {
            el.setAttribute("playbackPort", playPortId);
        }
        boolean hideInactiveControls = config.isHideInactiveControls();
        el.setAttribute("hideInactiveControls", this.formatBoolean(hideInactiveControls));
        long hideInactiveControlMillis = config.getHideInactiveControlMillis();
        if (hideInactiveControlMillis >= 0L) {
            el.setAttribute("hideInactiveControlMillis", Long.toString(hideInactiveControlMillis));
        }
        Properties props = line.getProperties();
        for (Map.Entry<Object, Object> me : props.entrySet()) {
            String value;
            String key = String.valueOf(me.getKey());
            Element elProp = this.createPropertyElement(doc, "property", key, value = String.valueOf(me.getValue()));
            if (elProp == null) continue;
            el.appendChild(elProp);
        }
        return el;
    }

    protected Element createPropertyElement(Document doc, Map.Entry entry, String tagName) {
        Object key = entry.getKey();
        Object value = entry.getValue();
        if (key == null || value == null) {
            return null;
        }
        Element el = doc.createElement(tagName);
        el.setAttribute("key", String.valueOf(key));
        el.setAttribute("value", String.valueOf(value));
        return el;
    }

    protected Element createPropertyElement(Document doc, String tagName, String key, String value) {
        Element el = doc.createElement(tagName);
        el.setAttribute("key", String.valueOf(key));
        el.setAttribute("value", String.valueOf(value));
        return el;
    }

    protected Element createFaderConfigElement(Document doc, FaderConfig config, String tagName) {
        String faderName = config.getFaderName();
        int faderType = config.getFaderType();
        boolean faderEnabled = config.isFaderEnabled();
        int channelMask = config.getChannelMask();
        boolean reverseMode = config.isReverseMode();
        float initValue = config.getInitValue();
        FaderCurve faderCurve = config.getFaderCurve();
        MidiMapping midiMapping = null;
        if (config instanceof MidiFaderConfig) {
            MidiFaderConfig mfc = (MidiFaderConfig)config;
            midiMapping = mfc.getMidiMapping();
        }
        String typeAsText = DefaultMidiFaderConfig.getFaderTypeName((int)faderType);
        String curveAsText = null;
        if (faderCurve != null) {
            curveAsText = this.formatFaderCurve(faderCurve);
        }
        String mappingAsText = null;
        if (midiMapping != null) {
            mappingAsText = this.formatMidiMapping(midiMapping);
        }
        Element el = doc.createElement(tagName);
        el.setAttribute("faderName", String.valueOf(faderName));
        el.setAttribute("faderType", String.valueOf(typeAsText));
        el.setAttribute("faderEnabled", Boolean.toString(faderEnabled));
        el.setAttribute("channelMask", String.valueOf(channelMask));
        el.setAttribute("reverseMode", Boolean.toString(reverseMode));
        el.setAttribute("initValue", String.valueOf(initValue));
        if (curveAsText != null) {
            el.setAttribute("faderCurve", curveAsText);
        }
        if (midiMapping != null) {
            el.setAttribute("midiMapping", mappingAsText);
        }
        return el;
    }

    protected Element createFaderCurveElement(Document doc, FaderCurve curve, String tagName) {
        String curveName = null;
        if (curve != null) {
            if (curve instanceof AbstractFaderCurve) {
                AbstractFaderCurve afc = (AbstractFaderCurve)curve;
                curveName = afc.getName();
            } else {
                curveName = curve.getClass().getName();
            }
        }
        String curveAsText = null;
        if (curve != null) {
            curveAsText = FaderCurveUtil.formatFaderCurve((FaderCurve)curve);
        }
        Element el = doc.createElement(tagName);
        el.setAttribute("name", String.valueOf(curveName));
        if (curveAsText != null) {
            el.setAttribute("curve", curveAsText);
        }
        return el;
    }

    protected LineModel resolveModel(String modelType, Resource resource, String[] trackIds, String modelName) {
        if (MODEL_TYPE_AUDIO.equals(modelType)) {
            CachedAudioModel audioModel = null;
            try {
                boolean readOnly = true;
                audioModel = this.waxLab.createCachedAudioModel(resource, trackIds, readOnly);
            }
            catch (Exception e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (audioModel == null) {
                return null;
            }
            audioModel.setResource(resource);
            audioModel.setTrackIds(trackIds);
            audioModel.setName(modelName);
            return audioModel;
        }
        if (MODEL_TYPE_TIMECODE.equals(modelType)) {
            CachedTimecodeModel tcModel = null;
            try {
                boolean readOnly = true;
                tcModel = this.waxLab.createCachedTimecodeModel(resource, trackIds, readOnly);
            }
            catch (Exception e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (tcModel == null) {
                return null;
            }
            tcModel.setResource(resource);
            tcModel.setTrackIds(trackIds);
            tcModel.setName(modelName);
            return tcModel;
        }
        if (MODEL_TYPE_FADER.equals(modelType)) {
            CachedFaderModel faderModel = null;
            try {
                boolean readOnly = true;
                faderModel = this.waxLab.createCachedFaderModel(resource, trackIds, readOnly);
            }
            catch (Exception e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (faderModel == null) {
                return null;
            }
            faderModel.setResource(resource);
            faderModel.setTrackIds(trackIds);
            faderModel.setName(modelName);
            return faderModel;
        }
        if (MODEL_TYPE_MIDI.equals(modelType)) {
            MidiModel midiModel = null;
            try {
                boolean readOnly = true;
                MidiTrack[] midiTracks = this.waxLab.createMidiTracks(resource, trackIds, readOnly);
                if (midiTracks != null && midiTracks.length > 0) {
                    midiModel = this.waxLab.createMidiModel(midiTracks);
                }
            }
            catch (Exception e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (midiModel == null) {
                return null;
            }
            midiModel.setResource(resource);
            midiModel.setTrackIds(trackIds);
            midiModel.setName(modelName);
            return midiModel;
        }
        if (MODEL_TYPE_EDITOR.equals(modelType)) {
            WaxEditorModel editorModel = null;
            try {
                boolean readOnly = true;
                editorModel = this.waxLab.createCachedWaxEditorModel(resource, trackIds, readOnly);
            }
            catch (Exception e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (editorModel == null) {
                return null;
            }
            editorModel.setResource(resource);
            editorModel.setTrackIds(trackIds);
            editorModel.setName(modelName);
            return editorModel;
        }
        IOException e = new IOException("Unsupported model: type=" + modelType + ", resource=" + resource);
        logger.log(Level.SEVERE, e.getMessage(), e);
        this.errors.add(e);
        return null;
    }

    public Resource resolveResource(String type, String path, URI baseURI) {
        if (RESOURCE_TYPE_LIVE.equals(type)) {
            return new WaxLabLiveFeederResource();
        }
        if (RESOURCE_TYPE_FILE.equals(type) || type == null) {
            try {
                File locatedFile;
                FileLocator fileLocator;
                File file = new File(path);
                if (!file.isAbsolute() && baseURI != null && this.isFile(baseURI)) {
                    File baseDir = new File(baseURI);
                    file = new File(baseDir, path);
                }
                if (!file.exists() && (fileLocator = Platform.getInstance().getFileLocator()) != null && (locatedFile = fileLocator.locateFile(path)) != null) {
                    file = locatedFile;
                }
                return new FileResource(file);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                this.errors.add(e);
                return null;
            }
        }
        if (RESOURCE_TYPE_URL.equals(type)) {
            try {
                URI uri = new URI(path);
                return new URIResource(uri);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                this.errors.add(e);
                return null;
            }
        }
        if (RESOURCE_TYPE_URI.equals(type)) {
            try {
                URL url = new URL(path);
                return new URLResource(url);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                this.errors.add(e);
                return null;
            }
        }
        IOException e = new IOException("Unsupported resource: type=" + type + ", path=" + path);
        logger.log(Level.SEVERE, e.getMessage(), e);
        this.errors.add(e);
        return null;
    }

    public URI resolveContentDirectory(String contentDirectoryPath, URI baseURI) throws Exception {
        if (contentDirectoryPath == null) {
            return baseURI;
        }
        if (contentDirectoryPath.length() < 1) {
            return baseURI;
        }
        URI contentURI = new URI(null, contentDirectoryPath, null);
        if (baseURI != null) {
            contentURI = baseURI.resolve(contentURI);
        }
        return contentURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadStudioConfig(File file, boolean includeModelFiles) throws IOException {
        File baseDir = file.getParentFile();
        URI baseURI = baseDir == null ? null : baseDir.toURI();
        FileInputStream fis = new FileInputStream(file);
        try {
            this.loadStudioConfig(fis, baseURI, includeModelFiles);
        }
        finally {
            fis.close();
        }
    }

    public void loadStudioConfig(InputStream in, URI baseURI, boolean includeModelFiles) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(in);
            NodeList list = doc.getChildNodes();
            int n = list.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = list.item(i);
                String nodeName = node.getLocalName();
                if (!"waxlab".equals(nodeName)) continue;
                this.readWaxLab(node, includeModelFiles, baseURI);
            }
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    protected void readWaxLab(Node studioNode, boolean includeModelFiles, URI baseURI) {
        TimecodeLineConfig config;
        Line line;
        TimecodeLine timecodeLine;
        this.waxLabPortMap.clear();
        WaxLabPortInfo[] portInfos = this.waxLabDevice.getWaxLabPorts();
        for (int i = 0; i < portInfos.length; ++i) {
            WaxLabPortInfo portInfo = portInfos[i];
            if (portInfo == null) continue;
            this.waxLabPortMap.put(portInfo.getId(), portInfo);
        }
        URI contentBaseURI = null;
        if (studioNode != null && studioNode instanceof Element) {
            WaxLabPortInfo[] ports;
            String midiOutputPortId;
            WaxLabPortInfo[] ports2;
            String midiInputPortId;
            String clockType;
            WaxLabPortInfo[] ports3;
            String clockAudioPortId;
            Element elStudio = (Element)studioNode;
            String contentDirPath = elStudio.getAttribute("contentDirectory");
            if (contentDirPath != null && contentDirPath.length() > 0) {
                try {
                    boolean isFileURI;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.fine("contentDirPath: " + contentDirPath);
                    }
                    if (isFileURI = this.isFile(contentBaseURI = this.resolveContentDirectory(contentDirPath, baseURI))) {
                        File contentDir = Tools.getURIFile((URI)contentBaseURI);
                        this.waxLab.setContentDirectory(contentDir);
                        if (logger.isLoggable(Level.FINER)) {
                            logger.fine("contentDir: " + contentDir);
                        }
                    }
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if ((clockAudioPortId = elStudio.getAttribute("clockAudioPort")) != null && (ports3 = this.parsePortIds(clockAudioPortId)).length > 0) {
                this.waxLab.setClockAudioPort(ports3[0]);
            }
            if ((clockType = elStudio.getAttribute("clockType")) != null) {
                this.waxLab.setClockType(clockType);
            }
            if ((midiInputPortId = elStudio.getAttribute("midiInputPort")) != null && (ports2 = this.parsePortIds(midiInputPortId)).length > 0) {
                this.waxLab.setMidiInputPort(ports2[0]);
            }
            if ((midiOutputPortId = elStudio.getAttribute("midiOutputPort")) != null && (ports = this.parsePortIds(midiOutputPortId)).length > 0) {
                this.waxLab.setMidiOutputPort(ports[0]);
            }
        }
        if (contentBaseURI == null) {
            contentBaseURI = baseURI;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("contentBaseURI: " + contentBaseURI);
        }
        Properties waxLabProps = new Properties();
        ArrayList<AudioLine> lines = new ArrayList<AudioLine>();
        HashMap<String, AudioLine> linesById = new HashMap<String, AudioLine>();
        HashMap timecodeLine2MidiInputLineId = new HashMap();
        HashMap timecodeLine2PitchLineId = new HashMap();
        HashMap<String, Resource> resourcesById = new HashMap<String, Resource>();
        HashMap<String, LineModel> modelsById = new HashMap<String, LineModel>();
        int nextLegacyModelId = 1;
        NodeList list = studioNode.getChildNodes();
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            IOException e;
            IOException e2;
            IOException e3;
            IOException e4;
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            String name = el.getNodeName();
            if ("property".equals(name)) {
                this.readProperty((Element)node, waxLabProps);
                continue;
            }
            if ("line".equals(name)) {
                String lineId = this.getAttribute(el, "id");
                if (lineId == null) continue;
                String type = this.getAttribute(el, "xsi:type");
                if (type != null) {
                    AudioLine line2;
                    if (type.endsWith("AudioLine")) {
                        line2 = this.readAudioLine(el);
                        if (line2 == null) continue;
                        lines.add(line2);
                        linesById.put(lineId, line2);
                        continue;
                    }
                    if (type.endsWith("TimecodeLine")) {
                        line2 = this.readTimecodeLine(el, timecodeLine2MidiInputLineId, timecodeLine2PitchLineId, resourcesById);
                        if (line2 == null) continue;
                        lines.add(line2);
                        linesById.put(lineId, line2);
                        continue;
                    }
                    if (type.endsWith("EditorLine")) {
                        line2 = this.readEditorLine(el);
                        if (line2 == null) continue;
                        lines.add(line2);
                        linesById.put(lineId, line2);
                        continue;
                    }
                    if (type.endsWith("MidiLine")) {
                        line2 = this.readMidiLine(el);
                        if (line2 == null) continue;
                        lines.add(line2);
                        linesById.put(lineId, line2);
                        continue;
                    }
                }
                e4 = new IOException("Unexpected line element type: " + type);
                this.errors.add(e4);
                logger.log(Level.SEVERE, e4.getMessage(), e4);
                continue;
            }
            boolean legacyModel = false;
            if (RESOURCE_TYPE_FILE.equals(name)) {
                legacyModel = true;
                name = "resource";
            }
            if ("resource".equals(name)) {
                String path = this.getAttribute(el, "path");
                if (path == null) {
                    e4 = new IOException("Missing attribute 'path' for resource element: " + el);
                    this.errors.add(e4);
                    logger.log(Level.SEVERE, e4.getMessage(), e4);
                    continue;
                }
                String resourceId = this.getAttribute(el, "id");
                if (legacyModel && resourceId == null) {
                    resourceId = path;
                }
                if (resourceId == null) {
                    IOException e5 = new IOException("Missing attribute 'id' for resource element: " + el);
                    this.errors.add(e5);
                    logger.log(Level.SEVERE, e5.getMessage(), e5);
                    continue;
                }
                String type = this.getAttribute(el, "type");
                Resource resource = this.resolveResource(type, path, contentBaseURI);
                if (resource != null) {
                    resourcesById.put(resourceId, resource);
                }
                if (!legacyModel) continue;
            }
            if (legacyModel) {
                name = "model";
            }
            boolean legacyChunk = false;
            String legacyLineId = null;
            String legacyModelId = null;
            if ("model".equals(name)) {
                LineModel model;
                String modelType;
                if (!includeModelFiles) continue;
                String modelId = this.getAttribute(el, "id");
                if (modelId == null) {
                    legacyLineId = this.getAttribute(el, "lineId");
                    if (legacyLineId != null) {
                        legacyChunk = true;
                        modelId = legacyModelId = "LegacyModel#" + nextLegacyModelId++;
                    }
                    if (!legacyChunk) {
                        e3 = new IOException("Missing attribute 'modelId' for model element: " + el);
                        this.errors.add(e3);
                        logger.log(Level.SEVERE, e3.getMessage(), e3);
                        continue;
                    }
                }
                if ((modelType = this.getAttribute(el, "type")) == null) {
                    e2 = new IOException("Missing attribute 'type' for model element: " + el);
                    this.errors.add(e2);
                    logger.log(Level.SEVERE, e2.getMessage(), e2);
                    continue;
                }
                String resourceId = this.getAttribute(el, "resourceId");
                if (legacyModel && resourceId == null) {
                    resourceId = this.getAttribute(el, "path");
                }
                if (resourceId == null) {
                    e = new IOException("Missing attribute 'resourceId' for model element: " + el + ", type=" + modelType);
                    this.errors.add(e);
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    continue;
                }
                String[] trackIds = null;
                String strTrackIds = this.getAttribute(el, "trackIds");
                if (strTrackIds != null) {
                    trackIds = this.parseTrackIds(strTrackIds);
                }
                String modelName = this.getAttribute(el, "name");
                Resource resource = (Resource)resourcesById.get(resourceId);
                if (resource == null) {
                    IOException e6 = new IOException("Missing resource for model element: " + el + ", modelId=" + modelId + ", resourceId=" + resourceId);
                    this.errors.add(e6);
                    logger.log(Level.SEVERE, e6.getMessage(), e6);
                    continue;
                }
                try {
                    model = this.resolveModel(modelType, resource, trackIds, modelName);
                }
                catch (Exception e7) {
                    this.errors.add(e7);
                    logger.log(Level.SEVERE, e7.getMessage(), e7);
                    continue;
                }
                if (model != null) {
                    modelsById.put(modelId, model);
                }
                if (!legacyChunk) continue;
            }
            if (legacyChunk) {
                name = "chunk";
            }
            if ("chunk".equals(name)) {
                LineModel model;
                Line line3;
                if (!includeModelFiles) continue;
                String lineId = this.getAttribute(el, "lineId");
                if (lineId == null) {
                    if (legacyChunk) {
                        lineId = legacyLineId;
                    }
                    if (lineId == null) {
                        e3 = new IOException("Missing attribute 'lineId' for chunk element: " + el);
                        this.errors.add(e3);
                        logger.log(Level.SEVERE, e3.getMessage(), e3);
                        continue;
                    }
                }
                if ((line3 = (Line)linesById.get(lineId)) == null) {
                    e2 = new IOException("Target line '" + lineId + "' not found for chunk element: " + el);
                    this.errors.add(e2);
                    logger.log(Level.SEVERE, e2.getMessage(), e2);
                    continue;
                }
                String modelId = this.getAttribute(el, "modelId");
                if (modelId == null) {
                    if (legacyChunk) {
                        modelId = legacyModelId;
                    }
                    if (modelId == null) {
                        e = new IOException("Missing attribute 'modelId' for chunk element: " + el);
                        this.errors.add(e);
                        logger.log(Level.SEVERE, e.getMessage(), e);
                        continue;
                    }
                }
                if ((model = (LineModel)modelsById.get(modelId)) == null) {
                    IOException e8 = new IOException("Model '" + modelId + "' not found for chunk element: " + el);
                    this.errors.add(e8);
                    logger.log(Level.SEVERE, e8.getMessage(), e8);
                    continue;
                }
                long chunkOfs = Long.MIN_VALUE;
                String sChunkOfs = this.getAttribute(el, "chunkOfs");
                if (sChunkOfs != null && sChunkOfs.length() > 0) {
                    chunkOfs = this.parseNanos(sChunkOfs, Long.MIN_VALUE);
                } else if (legacyChunk) {
                    double startTime = 0.0;
                    String strStartTime = this.getAttribute(el, "startTime");
                    if (strStartTime != null) {
                        try {
                            startTime = Double.parseDouble(strStartTime.trim());
                        }
                        catch (NumberFormatException e9) {
                            this.errors.add(e9);
                            logger.log(Level.SEVERE, e9.getMessage(), e9);
                        }
                    }
                    chunkOfs = (long)(startTime * 1000000.0);
                }
                if (chunkOfs == Long.MIN_VALUE) {
                    IOException e10 = new IOException("Missing attribute 'chunkOfs' for chunk element: " + el);
                    this.errors.add(e10);
                    logger.log(Level.SEVERE, e10.getMessage(), e10);
                    continue;
                }
                long chunkEnd = Long.MIN_VALUE;
                String sChunkEnd = this.getAttribute(el, "chunkEnd");
                if (sChunkEnd != null && sChunkEnd.length() > 0) {
                    chunkEnd = this.parseNanos(sChunkEnd, Long.MIN_VALUE);
                } else if (legacyChunk) {
                    chunkEnd = Long.MAX_VALUE;
                }
                if (chunkEnd == Long.MIN_VALUE) {
                    IOException e11 = new IOException("Missing attribute 'chunkEnd' for chunk element: " + el);
                    this.errors.add(e11);
                    logger.log(Level.SEVERE, e11.getMessage(), e11);
                    continue;
                }
                long modelOfs = 0L;
                String sModelOfs = this.getAttribute(el, "modelOfs");
                if (sModelOfs != null && sModelOfs.length() > 0) {
                    modelOfs = this.parseNanos(sModelOfs, Long.MIN_VALUE);
                    if (modelOfs == Long.MIN_VALUE) {
                        modelOfs = 0L;
                    }
                } else if (legacyChunk) {
                    double subTimeOffset = Double.NaN;
                    String strSubTimeOffset = this.getAttribute(el, "subTimeOffset");
                    if (strSubTimeOffset != null) {
                        try {
                            subTimeOffset = Double.parseDouble(strSubTimeOffset.trim());
                        }
                        catch (NumberFormatException e12) {
                            this.errors.add(e12);
                            logger.log(Level.SEVERE, e12.getMessage(), e12);
                        }
                    }
                    if (!Double.isNaN(subTimeOffset)) {
                        modelOfs = (long)(subTimeOffset * 1000000.0);
                    }
                }
                long modelEnd = Long.MAX_VALUE;
                String sModelEnd = this.getAttribute(el, "modelEnd");
                if (sModelEnd != null && sModelEnd.length() > 0) {
                    modelEnd = this.parseNanos(sModelEnd, Long.MIN_VALUE);
                    if (modelEnd == Long.MIN_VALUE) {
                        modelEnd = Long.MAX_VALUE;
                    }
                } else if (legacyChunk) {
                    long modelLen;
                    double subTimeLength = Double.NaN;
                    String strSubTimeLength = this.getAttribute(el, "subTimeLength");
                    if (strSubTimeLength != null) {
                        try {
                            subTimeLength = Double.parseDouble(strSubTimeLength.trim());
                        }
                        catch (NumberFormatException e13) {
                            this.errors.add(e13);
                            logger.log(Level.SEVERE, e13.getMessage(), e13);
                        }
                    }
                    if (!Double.isNaN(subTimeLength) && subTimeLength >= 0.0 && (modelLen = (long)(subTimeLength * 1000000.0)) >= 0L) {
                        modelEnd = modelOfs + modelLen;
                    }
                }
                if (legacyChunk && chunkEnd == Long.MAX_VALUE) {
                    chunkEnd = modelOfs < modelEnd ? LineUtil.longSum((long)chunkOfs, (long)(modelEnd - modelOfs)) : chunkOfs;
                }
                MutableLineChunk chunk = null;
                try {
                    chunk = model.createLineChunk(chunkOfs, chunkEnd, modelOfs, modelEnd);
                }
                catch (Exception e14) {
                    this.errors.add(e14);
                    logger.log(Level.SEVERE, e14.getMessage(), e14);
                    continue;
                }
                if (chunk == null) continue;
                line3.getMutableChunkModel().addChunk((LineChunk)chunk);
                continue;
            }
            logger.warning("Unexpected element name: " + name);
        }
        for (Map.Entry me : timecodeLine2MidiInputLineId.entrySet()) {
            timecodeLine = (TimecodeLine)me.getKey();
            String midiInputLineId = (String)me.getValue();
            if (midiInputLineId == null || (line = (Line)linesById.get(midiInputLineId)) == null || !(line instanceof MidiLine)) continue;
            MidiLine midiInputLine = (MidiLine)line;
            if (timecodeLine == null || (config = timecodeLine.getTimecodeLineConfig()) == null) continue;
            config.setFaderMidiLine(midiInputLine);
            timecodeLine.setTimecodeLineConfig(config);
        }
        for (Map.Entry me : timecodeLine2PitchLineId.entrySet()) {
            timecodeLine = (TimecodeLine)me.getKey();
            String pitchLineId = (String)me.getValue();
            if (pitchLineId == null || (line = (Line)linesById.get(pitchLineId)) == null || !(line instanceof ScratchLine)) continue;
            ScratchLine pitchLine = (ScratchLine)line;
            if (timecodeLine == null || (config = timecodeLine.getTimecodeLineConfig()) == null) continue;
            config.setPitchLine(pitchLine);
            timecodeLine.setTimecodeLineConfig(config);
        }
        TreeMap<String, String> midiMappingMap = new TreeMap<String, String>();
        TreeMap<String, String> midiTriggerMap = new TreeMap<String, String>();
        Properties customProps = new Properties();
        for (Map.Entry<Object, Object> me : waxLabProps.entrySet()) {
            String key = (String)me.getKey();
            String value = (String)me.getValue();
            if (key.startsWith(PROPERTY_PREFIX_MIDI_MAPPING)) {
                midiMappingMap.put(key.substring(PROPERTY_PREFIX_MIDI_MAPPING.length()), value);
                continue;
            }
            if (key.startsWith(PROPERTY_PREFIX_MIDI_TRIGGER)) {
                midiTriggerMap.put(key.substring(PROPERTY_PREFIX_MIDI_TRIGGER.length()), value);
                continue;
            }
            customProps.setProperty(key, value);
        }
        this.waxLab.setProperties(customProps);
        int lineCount = lines.size();
        for (int i = 0; i < lineCount; ++i) {
            line = (Line)lines.get(i);
            this.waxLab.addLine(line);
        }
        ArrayList<MidiMapping> midiMappingList = new ArrayList<MidiMapping>(midiMappingMap.size());
        for (String spec : midiMappingMap.values()) {
            MidiMapping mapping = this.parseMidiMapping(spec);
            if (mapping == null) continue;
            midiMappingList.add(mapping);
        }
        MidiMapping[] midiMappings = midiMappingList.toArray(new MidiMapping[midiMappingList.size()]);
        this.waxLab.setMidiMappings(midiMappings);
        ArrayList<MidiTrigger> midiTriggerList = new ArrayList<MidiTrigger>(midiTriggerMap.size());
        for (String spec : midiTriggerMap.values()) {
            MidiTrigger trigger = this.parseMidiTrigger(spec);
            if (trigger == null) continue;
            midiTriggerList.add(trigger);
        }
        MidiTrigger[] midiTriggers = midiTriggerList.toArray(new MidiTrigger[midiTriggerList.size()]);
        this.waxLab.setMidiTriggers(midiTriggers);
    }

    protected boolean isFile(URI uri) {
        return uri == null ? false : RESOURCE_TYPE_FILE.equalsIgnoreCase(uri.getScheme());
    }

    protected AudioLine readAudioLine(Element el) {
        AudioLine line = this.waxLab.createAudioLine();
        AudioLineConfig config = line.getAudioLineConfig();
        line.setName(this.getAttribute(el, "name"));
        String s = this.getAttribute(el, "trackSize");
        int trackSize = this.parseInt(s, -1);
        if (trackSize >= 0) {
            line.setTrackSize(trackSize);
        }
        config.setRecordingEnabled(this.parseBoolean(this.getAttribute(el, "recordingEnabled"), false));
        s = this.getAttribute(el, "recordingSampleType");
        if (s != null) {
            try {
                int recSampleType = this.parseSampleType(s);
                if (recSampleType >= 0) {
                    config.setRecordingSampleType(recSampleType);
                }
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((s = this.getAttribute(el, "recordingFrameType")) != null) {
            try {
                int recFrameType = this.parseFrameType(s);
                if (recFrameType >= 0) {
                    config.setRecordingFrameType(recFrameType);
                }
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((s = this.getAttribute(el, "recordingPorts")) != null) {
            config.setRecordingPorts(this.parsePortIds(s));
        }
        config.setPlaybackEnabled(this.parseBoolean(this.getAttribute(el, "playbackEnabled"), false));
        s = this.getAttribute(el, "playbackFrameType");
        if (s != null) {
            try {
                int playFrameType = this.parseFrameType(s);
                if (playFrameType >= 0) {
                    config.setPlaybackFrameType(playFrameType);
                }
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((s = this.getAttribute(el, "playbackPorts")) != null) {
            config.setPlaybackPorts(this.parsePortIds(s));
        }
        config.setBackgroundShading(this.parseBoolean(this.getAttribute(el, "backgroundShading"), false));
        config.setAudioRenderMode(this.getAttribute(el, "audioRenderMode"));
        Properties lineProps = new Properties();
        NodeList list = el.getChildNodes();
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element) || !"property".equals(node.getNodeName())) continue;
            this.readProperty((Element)node, lineProps);
        }
        line.setProperties(lineProps);
        line.setAudioLineConfig(config);
        return line;
    }

    protected TimecodeLine readTimecodeLine(Element el, Map dstTimecodeLine2MidiInputLineId, Map dstTimecodeLine2PitchLineId, HashMap resourcesById) {
        WaxLabPortInfo[] ports;
        TimecodeLine line = this.waxLab.createTimecodeLine(false);
        TimecodeLineConfig config = line.getTimecodeLineConfig();
        line.setName(this.getAttribute(el, "name"));
        String s = this.getAttribute(el, "trackSize");
        int trackSize = this.parseInt(s, -1);
        if (trackSize >= 0) {
            line.setTrackSize(trackSize);
        }
        config.setRecordingEnabled(this.parseBoolean(this.getAttribute(el, "recordingEnabled"), false));
        s = this.getAttribute(el, "recordingPorts");
        if (s != null) {
            config.setRecordingPorts(this.parsePortIds(s));
        }
        config.setTimecodeFormatName(this.getAttribute(el, "timecodeFormatName"));
        config.setPlaybackEnabled(this.parseBoolean(this.getAttribute(el, "playbackEnabled"), false));
        config.setScratchingEnabled(this.parseBoolean(this.getAttribute(el, "scratchingEnabled"), false));
        s = this.getAttribute(el, "playbackFrameType");
        if (s != null) {
            try {
                int playFrameType = this.parseFrameType(s);
                if (playFrameType >= 0) {
                    config.setPlaybackFrameType(playFrameType);
                }
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        config.setPreFaderEnabled(this.parseBoolean(this.getAttribute(el, "preFaderEnabled"), false));
        config.setPostFaderEnabled(this.parseBoolean(this.getAttribute(el, "postFaderEnabled"), false));
        s = this.getAttribute(el, "preFaderVolume");
        if (s != null) {
            try {
                double playVolume = Double.parseDouble(s.trim());
                config.setPreFaderVolume(playVolume);
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((s = this.getAttribute(el, "postFaderVolume")) != null) {
            try {
                double playVolume = Double.parseDouble(s.trim());
                config.setPostFaderVolume(playVolume);
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((s = this.getAttribute(el, "preFaderPorts")) != null) {
            config.setPreFaderPorts(this.parsePortIds(s));
        }
        if ((s = this.getAttribute(el, "postFaderPorts")) != null) {
            config.setPostFaderPorts(this.parsePortIds(s));
        }
        if ((s = this.getAttribute(el, "faderMidiLine")) != null) {
            dstTimecodeLine2MidiInputLineId.put(line, s);
        }
        if ((s = this.getAttribute(el, "midiInputPort")) != null && (ports = this.parsePortIds(s)).length > 0) {
            config.setMidiInputPort(ports[0]);
        }
        if ((s = this.getAttribute(el, "midiOutputPort")) != null && (ports = this.parsePortIds(s)).length > 0) {
            config.setMidiOutputPort(ports[0]);
        }
        if ((s = this.getAttribute(el, "timecodeMidiInputPort")) != null && (ports = this.parsePortIds(s)).length > 0) {
            config.setTimecodeMidiInputPort(ports[0]);
        }
        config.setPitchMode(this.getAttribute(el, "pitchMode"));
        s = this.getAttribute(el, "pitchFactor");
        if (s != null) {
            try {
                double playPitch = Double.parseDouble(s.trim());
                config.setPitchFactor(playPitch);
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((s = this.getAttribute(el, "pitchMin")) != null) {
            try {
                double pitchMin = Double.parseDouble(s.trim());
                config.setPitchMin(pitchMin);
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((s = this.getAttribute(el, "pitchMax")) != null) {
            try {
                double pitchMax = Double.parseDouble(s.trim());
                config.setPitchMax(pitchMax);
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((s = this.getAttribute(el, "pitchBPM")) != null) {
            try {
                double pitchBPM = Double.parseDouble(s.trim());
                config.setPitchBPM(pitchBPM);
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((s = this.getAttribute(el, "pitchLine")) != null) {
            dstTimecodeLine2PitchLineId.put(line, s);
        }
        if ((s = this.getAttribute(el, "jumpBeats")) != null) {
            try {
                double jumpBeats = Double.parseDouble(s.trim());
                config.setJumpBeats(jumpBeats);
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((s = this.getAttribute(el, "sliceBeats")) != null) {
            try {
                double sliceBeats = Double.parseDouble(s.trim());
                config.setSliceBeats(sliceBeats);
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((s = this.getAttribute(el, "cuePointCount")) != null) {
            try {
                int cuePointCount = Integer.parseInt(s.trim());
                if (cuePointCount >= 0) {
                    config.setCuePointCount(cuePointCount);
                }
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((s = this.getAttribute(el, "resampleRate")) != null) {
            try {
                float resampleRate = Float.parseFloat(s.trim());
                config.setResampleRate(resampleRate);
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        boolean audioFaderEnabled = true;
        s = this.getAttribute(el, "audioFaderEnabled");
        if (s != null) {
            audioFaderEnabled = this.parseBoolean(s, false);
        }
        config.setAudioFaderEnabled(audioFaderEnabled);
        config.setScratchMode(this.getAttribute(el, "scratchMode"));
        String scratchResourceId = this.getAttribute(el, "scratchResourceId");
        if (scratchResourceId != null) {
            Resource resource = (Resource)resourcesById.get(scratchResourceId);
            MediaEntry mediaEntry = null;
            if (resource != null || mediaEntry != null) {
                line.setScratchResource(resource, mediaEntry);
            }
        }
        if ((s = this.getAttribute(el, "liveFeedPorts")) != null) {
            config.setLiveFeedPorts(this.parsePortIds(s));
        }
        config.setInvertedView(this.parseBoolean(this.getAttribute(el, "invertedView"), false));
        s = this.getAttribute(el, "faderShadingView");
        if (s != null) {
            config.setFaderShadingView(this.parseBoolean(s, false));
        }
        if ((s = this.getAttribute(el, "timecodeAutoScrolling")) != null) {
            config.setTimecodeAutoScrolling(this.parseBoolean(s, false));
        }
        if ((s = this.getAttribute(el, "scratchPositionViewEnabled")) != null) {
            config.setScratchPositionViewEnabled(this.parseBoolean(s, false));
        }
        if ((s = this.getAttribute(el, "beatCompassViewEnabled")) != null) {
            config.setBeatCompassViewEnabled(this.parseBoolean(s, false));
        }
        if ((s = this.getAttribute(el, "beatRadarViewEnabled")) != null) {
            config.setBeatRadarViewEnabled(this.parseBoolean(s, false));
        }
        Properties lineProps = new Properties();
        LinkedList<FaderConfig> faderConfigList = new LinkedList<FaderConfig>();
        NodeList list = el.getChildNodes();
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            FaderConfig faderConfig;
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            if ("property".equals(node.getNodeName())) {
                this.readProperty((Element)node, lineProps);
                continue;
            }
            if (!"faderConfig".equals(node.getNodeName()) || (faderConfig = this.readFaderConfig((Element)node)) == null) continue;
            faderConfigList.add(faderConfig);
        }
        config.setAudioFaderConfigs(faderConfigList.toArray(new FaderConfig[faderConfigList.size()]));
        TreeMap<String, String> midiMappingTreeMap = new TreeMap<String, String>();
        TreeMap<String, String> midiTriggerTreeMap = new TreeMap<String, String>();
        Properties customProps = new Properties();
        for (Map.Entry<Object, Object> me : lineProps.entrySet()) {
            String key = (String)me.getKey();
            String value = (String)me.getValue();
            if (key.startsWith(PROPERTY_PREFIX_MIDI_MAPPING)) {
                midiMappingTreeMap.put(key.substring(PROPERTY_PREFIX_MIDI_MAPPING.length()), value);
                continue;
            }
            if (key.startsWith(PROPERTY_PREFIX_MIDI_TRIGGER)) {
                midiTriggerTreeMap.put(key.substring(PROPERTY_PREFIX_MIDI_TRIGGER.length()), value);
                continue;
            }
            customProps.setProperty(key, value);
        }
        line.setProperties(customProps);
        line.setTimecodeLineConfig(config);
        ArrayList<MidiMapping> midiActionMappingList = new ArrayList<MidiMapping>(midiMappingTreeMap.size());
        for (String spec : midiMappingTreeMap.values()) {
            MidiMapping mapping = this.parseMidiMapping(spec);
            if (mapping == null) continue;
            midiActionMappingList.add(mapping);
        }
        MidiMapping[] midiActionMappings = midiActionMappingList.toArray(new MidiMapping[midiActionMappingList.size()]);
        line.setMidiMappings(midiActionMappings);
        ArrayList<MidiTrigger> midiTriggerList = new ArrayList<MidiTrigger>(midiTriggerTreeMap.size());
        for (String spec : midiTriggerTreeMap.values()) {
            MidiTrigger trigger = this.parseMidiTrigger(spec);
            if (trigger == null) continue;
            midiTriggerList.add(trigger);
        }
        MidiTrigger[] midiTriggers = midiTriggerList.toArray(new MidiTrigger[midiTriggerList.size()]);
        line.setMidiTriggers(midiTriggers);
        return line;
    }

    protected EditorLine readEditorLine(Element el) {
        EditorLine line = this.waxLab.createEditorLine();
        EditorLineConfig config = line.getEditorLineConfig();
        line.setName(this.getAttribute(el, "name"));
        String s = this.getAttribute(el, "trackSize");
        int trackSize = this.parseInt(s, -1);
        if (trackSize >= 0) {
            line.setTrackSize(trackSize);
        }
        config.setPlaybackEnabled(this.parseBoolean(this.getAttribute(el, "playbackEnabled"), false));
        s = this.getAttribute(el, "playbackFrameType");
        if (s != null) {
            try {
                int playFrameType = this.parseFrameType(s);
                if (playFrameType >= 0) {
                    config.setPlaybackFrameType(playFrameType);
                }
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((s = this.getAttribute(el, "playbackPorts")) != null) {
            config.setPlaybackPorts(this.parsePortIds(s));
        }
        if ((s = this.getAttribute(el, "playbackVolume")) != null) {
            try {
                double playVolume = Double.parseDouble(s.trim());
                config.setVolumeFactor(playVolume);
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((s = this.getAttribute(el, "pitchFactor")) != null) {
            try {
                double playPitch = Double.parseDouble(s.trim());
                config.setPitchFactor(playPitch);
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((s = this.getAttribute(el, "pitchMin")) != null) {
            try {
                double pitchMin = Double.parseDouble(s.trim());
                config.setPitchMin(pitchMin);
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((s = this.getAttribute(el, "pitchMax")) != null) {
            try {
                double pitchMax = Double.parseDouble(s.trim());
                config.setPitchMax(pitchMax);
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((s = this.getAttribute(el, "resampleRate")) != null) {
            try {
                float resampleRate = Float.parseFloat(s.trim());
                config.setResampleRate(resampleRate);
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        config.setInvertedView(this.parseBoolean(this.getAttribute(el, "invertedView"), false));
        config.setHideTimecodePoints(this.parseBoolean(this.getAttribute(el, "hideTimecodePoints"), false));
        config.setHideFaderPoints(this.parseBoolean(this.getAttribute(el, "hideFaderPoints"), false));
        s = this.getAttribute(el, "timecodeAutoScrolling");
        if (s != null) {
            config.setTimecodeAutoScrolling(this.parseBoolean(s, false));
        }
        Properties lineProps = new Properties();
        NodeList list = el.getChildNodes();
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            if ("faderCurve".equals(node.getNodeName())) {
                FaderCurve curve = this.readFaderCurve((Element)node);
                if (curve == null) continue;
                config.setFaderCurve(curve);
                continue;
            }
            if (!"property".equals(node.getNodeName())) continue;
            this.readProperty((Element)node, lineProps);
        }
        line.setProperties(lineProps);
        line.setEditorLineConfig(config);
        return line;
    }

    protected MidiLine readMidiLine(Element el) {
        WaxLabPortInfo[] ports;
        float recordingTickRate;
        MidiLine line = this.waxLab.createMidiLine();
        MidiLineConfig config = line.getMidiLineConfig();
        line.setName(this.getAttribute(el, "name"));
        String s = this.getAttribute(el, "trackSize");
        int trackSize = this.parseInt(s, -1);
        if (trackSize >= 0) {
            line.setTrackSize(trackSize);
        }
        if ((recordingTickRate = this.parseFloat(this.getAttribute(el, "recordingTickRate"), -1.0f)) <= 0.0f) {
            recordingTickRate = 9000.0f;
        }
        config.setRecordingTickRate(recordingTickRate);
        config.setRecordingEnabled(this.parseBoolean(this.getAttribute(el, "recordingEnabled"), false));
        s = this.getAttribute(el, "recordingPort");
        if (s != null && (ports = this.parsePortIds(s)).length > 0) {
            config.setRecordingPort(ports[0]);
        }
        config.setPlaybackEnabled(this.parseBoolean(this.getAttribute(el, "playbackEnabled"), false));
        s = this.getAttribute(el, "playbackPort");
        if (s != null && (ports = this.parsePortIds(s)).length > 0) {
            config.setPlaybackPort(ports[0]);
        }
        boolean hideInactiveControls = false;
        s = this.getAttribute(el, "hideInactiveControls");
        if (s != null) {
            hideInactiveControls = this.parseBoolean(s, false);
        }
        config.setHideInactiveControls(hideInactiveControls);
        long hideInactiveControlMillis = -1L;
        s = this.getAttribute(el, "hideInactiveControlMillis");
        if (s != null) {
            hideInactiveControlMillis = this.parseLong(s, -1L);
        }
        config.setHideInactiveControlMillis(hideInactiveControlMillis);
        Properties lineProps = new Properties();
        NodeList list = el.getChildNodes();
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element) || !"property".equals(node.getNodeName())) continue;
            this.readProperty((Element)node, lineProps);
        }
        line.setProperties(lineProps);
        line.setMidiLineConfig(config);
        return line;
    }

    protected AudioFormat readAudioFormat(WaxLab studio, Element el) {
        float frameRate;
        int bitDepth = 16;
        int channels = 2;
        boolean bigEndian = false;
        String sEncoding = this.getAttribute(el, "encoding");
        AudioFormat.Encoding encoding = this.parseEncoding(sEncoding, AudioFormat.Encoding.PCM_SIGNED);
        String sFrameRate = this.getAttribute(el, "frameRate");
        if (sFrameRate == null) {
            return null;
        }
        String sBitDepth = this.getAttribute(el, "bitDepth");
        String sChannels = this.getAttribute(el, "channels");
        String sBigEndian = this.getAttribute(el, "bigEndian");
        try {
            frameRate = Float.parseFloat(sFrameRate);
            if (sBitDepth != null) {
                bitDepth = Integer.parseInt(sBitDepth);
            }
            if (sChannels != null) {
                channels = Integer.parseInt(sChannels);
            }
            if (sBigEndian != null) {
                bigEndian = "true".equalsIgnoreCase(sBigEndian);
            }
        }
        catch (NumberFormatException e) {
            this.errors.add(e);
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        float sampleRate = frameRate;
        int sampleSizeInBits = bitDepth;
        int frameSize = channels * bitDepth / 8;
        AudioFormat format = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, bigEndian);
        return format;
    }

    protected AudioFormat.Encoding parseEncoding(String name, AudioFormat.Encoding defaultEncoding) {
        if (AudioFormat.Encoding.PCM_SIGNED.toString().equals(name)) {
            return AudioFormat.Encoding.PCM_SIGNED;
        }
        if (AudioFormat.Encoding.PCM_UNSIGNED.toString().equals(name)) {
            return AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (AudioFormat.Encoding.ALAW.toString().equals(name)) {
            return AudioFormat.Encoding.ALAW;
        }
        if (AudioFormat.Encoding.ULAW.toString().equals(name)) {
            return AudioFormat.Encoding.ULAW;
        }
        return defaultEncoding;
    }

    protected FaderConfig readFaderConfig(Element el) {
        String faderName = this.getAttribute(el, "faderName");
        String faderType = this.getAttribute(el, "faderType");
        String faderEnabled = this.getAttribute(el, "faderEnabled");
        String channelMask = this.getAttribute(el, "channelMask");
        String reverseMode = this.getAttribute(el, "reverseMode");
        String initValue = this.getAttribute(el, "initValue");
        String faderCurve = this.getAttribute(el, "faderCurve");
        String midiMapping = this.getAttribute(el, "midiMapping");
        DefaultMidiFaderConfig config = new DefaultMidiFaderConfig();
        config.setFaderName(faderName);
        config.setFaderType(DefaultMidiFaderConfig.getFaderType((Object)faderType));
        config.setFaderEnabled(this.parseBoolean(faderEnabled, false));
        if (channelMask != null) {
            config.setChannelMask(this.parseInt(channelMask, 0));
        }
        config.setReverseMode(this.parseBoolean(reverseMode, false));
        if (initValue != null) {
            config.setInitValue(this.parseFloat(initValue, 0.5f));
        }
        if (faderCurve != null) {
            config.setFaderCurve(this.parseFaderCurve(faderCurve));
        }
        if (midiMapping != null) {
            config.setMidiMapping(this.parseMidiMapping(midiMapping));
        }
        return config;
    }

    protected void readProperty(Element el, Properties dest) {
        String key = this.getAttribute(el, "key");
        String value = this.getAttribute(el, "value");
        if (key != null && value != null) {
            dest.setProperty(key, value);
        }
    }

    protected FaderCurve readFaderCurve(Element el) {
        try {
            String curveName = this.getAttribute(el, "name");
            FaderCurve curve = null;
            String s = this.getAttribute(el, "curve");
            if (s != null && !"null".equalsIgnoreCase(s) && (curve = FaderCurveUtil.parseFaderCurve((String)s)) != null && curve instanceof AbstractFaderCurve) {
                AbstractFaderCurve afc = (AbstractFaderCurve)curve;
                afc.setName(curveName);
            }
            return curve;
        }
        catch (Exception e) {
            this.errors.add(e);
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected String getAttribute(Element el, String name) {
        Attr attr = el.getAttributeNode(name);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public Throwable[] getErrors() {
        return this.errors.toArray(new Throwable[this.errors.size()]);
    }

    protected String formatBoolean(boolean value) {
        return String.valueOf(value);
    }

    protected boolean parseBoolean(String text, boolean defaultValue) {
        if (text != null && text.length() > 0) {
            if ("true".equals(text)) {
                return true;
            }
            if ("false".equals(text)) {
                return false;
            }
            if ("true".equalsIgnoreCase(text = text.trim())) {
                return true;
            }
            if ("false".equalsIgnoreCase(text)) {
                return false;
            }
            if ("on".equalsIgnoreCase(text)) {
                return true;
            }
            if ("off".equalsIgnoreCase(text)) {
                return false;
            }
        }
        return defaultValue;
    }

    protected String formatInt(int value) {
        return String.valueOf(value);
    }

    protected int parseInt(String text, int defaultValue) {
        if (text != null && text.length() > 0) {
            try {
                int value = Integer.parseInt(text.trim());
                return value;
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return defaultValue;
    }

    protected long parseLong(String text, long defaultValue) {
        if (text != null && text.length() > 0) {
            try {
                long value = Long.parseLong(text.trim());
                return value;
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return defaultValue;
    }

    protected String formatDouble(double value) {
        String s = String.valueOf(value);
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    protected double parseDouble(String text, double defaultValue) {
        if (text != null && text.length() > 0) {
            try {
                double value = Double.parseDouble(text.trim());
                return value;
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return defaultValue;
    }

    protected String formatFloat(float value) {
        String s = String.valueOf(value);
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    protected float parseFloat(String text, float defaultValue) {
        if (text != null && text.length() > 0) {
            try {
                float value = Float.parseFloat(text.trim());
                return value;
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return defaultValue;
    }

    protected String formatNanos(long nanos) {
        return LineUtil.formatNanos((long)nanos);
    }

    protected long parseNanos(String value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return LineUtil.parseNanos((String)value);
        }
        catch (NumberFormatException e) {
            this.errors.add(e);
            logger.log(Level.SEVERE, e.getMessage(), e);
            return defaultValue;
        }
    }

    protected String formatTrackIds(String[] trackIds) {
        StringBuffer sb = new StringBuffer();
        if (trackIds != null) {
            for (String trackId : trackIds) {
                if (trackId == null) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(trackId);
            }
        }
        return sb.toString();
    }

    protected String[] parseTrackIds(String value) {
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer tok = new StringTokenizer(value, ",", false);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if ((s = s.trim()).length() <= 0) continue;
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    protected String formatPortIds(WaxLabPortInfo[] ports) {
        StringBuffer sb = new StringBuffer();
        if (ports != null) {
            for (WaxLabPortInfo port : ports) {
                String portId;
                if (port == null || (portId = port.getId()) == null) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(portId);
            }
        }
        return sb.toString();
    }

    protected WaxLabPortInfo[] parsePortIds(String value) {
        LinkedList<WaxLabPortInfo> list = new LinkedList<WaxLabPortInfo>();
        StringTokenizer tok = new StringTokenizer(value, ",", false);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if ((s = s.trim()).length() <= 0) continue;
            WaxLabPortInfo info = (WaxLabPortInfo)this.waxLabPortMap.get(s);
            if (info == null) {
                info = new WaxLabPortInfo();
                info.setId(s);
            }
            list.add(info);
        }
        return list.toArray(new WaxLabPortInfo[list.size()]);
    }

    protected String formatSampleType(int sampleType) {
        switch (sampleType) {
            case 1: {
                return SAMPLE_TYPE_SIGNED_16;
            }
            case 2: {
                return SAMPLE_TYPE_SIGNED_24;
            }
            case 3: {
                return SAMPLE_TYPE_SIGNED_32;
            }
            case 4: {
                return SAMPLE_TYPE_FLOAT_32;
            }
            case 5: {
                return SAMPLE_TYPE_FLOAT_64;
            }
        }
        return String.valueOf(sampleType);
    }

    protected int parseSampleType(String value) {
        if (value != null && value.length() > 0) {
            if (SAMPLE_TYPE_SIGNED_16.equals(value = value.trim())) {
                return 1;
            }
            if (SAMPLE_TYPE_SIGNED_24.equals(value)) {
                return 2;
            }
            if (SAMPLE_TYPE_SIGNED_32.equals(value)) {
                return 3;
            }
            if (SAMPLE_TYPE_FLOAT_32.equals(value)) {
                return 4;
            }
            if (SAMPLE_TYPE_FLOAT_64.equals(value)) {
                return 5;
            }
            try {
                int sampleType = Integer.parseInt(value.trim());
                return sampleType;
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return -1;
    }

    protected String formatFrameType(int frameType) {
        switch (frameType) {
            case 1: {
                return FRAME_TYPE_MONO;
            }
            case 2: {
                return FRAME_TYPE_STEREO;
            }
        }
        return String.valueOf(frameType);
    }

    protected int parseFrameType(String value) {
        if (value != null && value.length() > 0) {
            if (FRAME_TYPE_MONO.equals(value = value.trim())) {
                return 1;
            }
            if (FRAME_TYPE_STEREO.equals(value)) {
                return 2;
            }
            try {
                int frameType = Integer.parseInt(value.trim());
                return frameType;
            }
            catch (NumberFormatException e) {
                this.errors.add(e);
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return -1;
    }

    public static int getFrameTypeChannelCount(int frameType) {
        switch (frameType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return -1;
    }

    protected String formatMidiMapping(MidiMapping mapping) {
        return mapping.toString();
    }

    protected MidiMapping parseMidiMapping(String value) {
        return MidiMapping.parseMidiMapping((String)value);
    }

    protected String formatMidiTrigger(MidiTrigger trigger) {
        return trigger.toString();
    }

    protected MidiTrigger parseMidiTrigger(String value) {
        return MidiTrigger.parseMidiTrigger((String)value);
    }

    protected String formatFaderCurve(FaderCurve faderCurve) {
        return FaderCurveUtil.formatFaderCurve((FaderCurve)faderCurve);
    }

    protected FaderCurve parseFaderCurve(String value) {
        return FaderCurveUtil.parseFaderCurve((String)value);
    }
}

