/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.analyzer;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.DefaultAudioEntry;
import com.spacekiller.util.media.DefaultMediaEntry;
import com.spacekiller.util.media.MediaAnalyzer;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.MutableAudioEntry;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.sound.RawSampleBuffer;
import com.spacekiller.util.sound.SampleType;
import com.spacekiller.util.sound.SoundUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundMediaAnalyzer
implements MediaAnalyzer {
    private static final Logger logger = Logger.getLogger(SoundMediaAnalyzer.class.getName());
    private static final double PEAK_COMPUTE_SECONDS = 1.0;
    private static final double ZERO_COMPUTE_SECONDS = 0.01;
    private static final int DEFAULT_BUFFER_FRAMES = 65536;
    private static final long DEFAULT_ANALYZER_TIMEOUT = 30000L;
    private static final long MAXIMUM_TRACK_DURATION_LIMIT_SECONDS = 14400L;
    private static final long INFINITE_TRACK_DURATION_LIMIT_SECONDS = 360L;
    private static final double DEFAULT_NORMALIZED_AMP_THRESHOLD = 0.99;
    private final AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, -1, -1, -1, -1.0f, false);
    private int bufferFrames = 65536;
    private long analyzerTimeout = 30000L;
    private double normalizedAmpThreshold = 0.99;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaEntry analyzeMediaResource(Resource resource, MediaEntry me, MediaLibrary library) throws IOException, UnsupportedAudioFileException {
        if (resource == null) {
            return null;
        }
        boolean infinite = false;
        if (me != null) {
            infinite = me.isInfinite();
        }
        Object mme = me != null && me instanceof MutableMediaEntry ? (MutableMediaEntry)me : new DefaultMediaEntry();
        AudioEntry ae = mme.getAudioEntry();
        Object mae = ae != null && ae instanceof MutableAudioEntry ? (MutableAudioEntry)ae : new DefaultAudioEntry();
        AudioInputStream pcmStream = library.createAudioInputStream(resource, this.targetFormat);
        try {
            int flags;
            double peakRms;
            SampleType sampleType;
            AudioFormat.Encoding encoding;
            AudioFormat audioFormat = pcmStream.getFormat();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Analyzing media resource: " + resource + ", format=" + audioFormat);
            }
            if ((encoding = audioFormat.getEncoding()) != this.targetFormat.getEncoding()) {
                throw new UnsupportedAudioFileException("Invalid audio encoding: " + encoding + " != " + this.targetFormat.getEncoding());
            }
            int channels = audioFormat.getChannels();
            if (channels < 1) {
                throw new UnsupportedAudioFileException("Invalid audio channels: " + channels);
            }
            int bitDepth = audioFormat.getSampleSizeInBits();
            if (bitDepth < 1) {
                throw new UnsupportedAudioFileException("Invalid audio bit depth: " + bitDepth);
            }
            int frameSize = audioFormat.getFrameSize();
            if (frameSize < 1) {
                throw new UnsupportedAudioFileException("Invalid audio frame size: " + frameSize);
            }
            float sampleRate = audioFormat.getSampleRate();
            if (sampleRate < 1.0f) {
                throw new UnsupportedAudioFileException("Invalid audio sample rate: " + sampleRate);
            }
            long limitSeconds = 14400L;
            if (infinite) {
                limitSeconds = 360L;
            }
            long limitFrames = (long)((float)limitSeconds * sampleRate);
            try {
                sampleType = SoundUtil.guessSampleType((AudioFormat)audioFormat);
                if (sampleType == null) {
                    throw new Exception("Unsupported audio format: " + audioFormat);
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Unsupported audio format: resource=" + resource + ", audioFormat=" + audioFormat, e);
                }
                MediaEntry mediaEntry = null;
                if (pcmStream != null) {
                    pcmStream.close();
                }
                return mediaEntry;
            }
            float frameRate = sampleRate;
            int bufferSamples = this.bufferFrames * channels;
            RawSampleBuffer rsb = sampleType.createRawSampleBuffer(channels, frameRate, bufferSamples);
            int bufferBytes = rsb.getByteLength();
            long totalFrames = 0L;
            double totalSquareSum = 0.0;
            long totalSquareCount = 0L;
            int emptyTimeout = 5000;
            long emptyTime = 0L;
            int peakSamples = (int)(1.0 * (double)sampleRate * (double)channels);
            if (peakSamples < 1) {
                throw new IllegalArgumentException("Invalid peak samples: " + peakSamples);
            }
            double[] squareBuf = new double[peakSamples];
            int squareOfs = 0;
            double squareSum = 0.0;
            double peakSquareSum = 0.0;
            boolean[] wasSilence = new boolean[channels];
            boolean silentChannels = false;
            double silenceThreshold = 0.01;
            double silenceSquareSum = (double)peakSamples * (silenceThreshold * silenceThreshold);
            int zeroDiv = (int)(0.01 * (double)sampleRate);
            if (zeroDiv < 2) {
                zeroDiv = 2;
            }
            double[] peak = new double[channels];
            long zeroCrossings = 0L;
            double zeroThreshold = 0.01;
            double minAmplitude = Double.MAX_VALUE;
            double maxAmplitude = Double.MIN_VALUE;
            double firstSoundFrameIndex = -1.0;
            double lastSoundFrameIndex = -1.0;
            int[] dir = new int[channels];
            long startTime = System.currentTimeMillis();
            while (totalFrames < limitFrames) {
                if (System.currentTimeMillis() - startTime > this.analyzerTimeout) {
                    throw new UnsupportedAudioFileException("Analyzer timeout reached while scanning resource: " + resource);
                }
                int nb = rsb.write(0, (InputStream)pcmStream, bufferBytes);
                if (nb < 0) break;
                int nf = nb / frameSize;
                if (nf < 1) {
                    if (nf < 0) break;
                    if (emptyTime == 0L) {
                        emptyTime = System.currentTimeMillis();
                        continue;
                    }
                    if (System.currentTimeMillis() - emptyTime <= (long)emptyTimeout) continue;
                    throw new StreamCorruptedException(String.valueOf(resource) + " => timeout reading empty buffer: " + emptyTimeout);
                }
                emptyTime = 0L;
                double ss = 0.0;
                int o = 0;
                for (int i = 0; i < nf; ++i) {
                    block15: for (int k = 0; k < channels; ++k) {
                        double v;
                        if ((v = rsb.getDouble(o++)) != 0.0) {
                            lastSoundFrameIndex = totalFrames + (long)i;
                            if (firstSoundFrameIndex < 0.0) {
                                firstSoundFrameIndex = lastSoundFrameIndex;
                            }
                        }
                        if (v > maxAmplitude) {
                            maxAmplitude = v;
                            if (minAmplitude > v) {
                                minAmplitude = v;
                            }
                        } else if (v < minAmplitude) {
                            minAmplitude = v;
                            if (maxAmplitude < v) {
                                maxAmplitude = v;
                            }
                        }
                        double v2 = v * v;
                        ss += v2;
                        squareSum += v2 - squareBuf[squareOfs];
                        squareBuf[squareOfs] = v2;
                        squareOfs = (squareOfs + 1) % peakSamples;
                        if (squareSum > peakSquareSum) {
                            peakSquareSum = squareSum;
                        }
                        double z = peak[k];
                        switch (dir[k]) {
                            case 0: {
                                dir[k] = v < z ? -1 : 1;
                                peak[k] = v;
                                continue block15;
                            }
                            case 1: {
                                if (v > z) {
                                    peak[k] = v;
                                    continue block15;
                                }
                                if (!(v + zeroThreshold < z)) continue block15;
                                ++zeroCrossings;
                                dir[k] = -1;
                                peak[k] = v;
                                continue block15;
                            }
                            case -1: {
                                if (v < z) {
                                    peak[k] = v;
                                    continue block15;
                                }
                                if (!(v - zeroThreshold > z)) continue block15;
                                ++zeroCrossings;
                                dir[k] = 1;
                                peak[k] = v;
                                continue block15;
                            }
                            default: {
                                throw new IllegalStateException("Invalid direction: " + dir[k]);
                            }
                        }
                    }
                }
                totalSquareSum += ss;
                totalSquareCount += (long)o;
                if (totalSquareSum < 0.0) {
                    logger.warning("Square Sum Overflow: totalSquareCount=" + totalSquareCount + ", totalSquareSum=" + totalSquareSum);
                    totalSquareSum = 0.0;
                    totalSquareCount = 0L;
                }
                totalFrames += (long)nf;
            }
            double duration = (double)totalFrames / (double)sampleRate;
            if (totalFrames >= limitFrames) {
                duration = -1.0;
            }
            double rms = Math.sqrt(totalSquareSum / (double)totalSquareCount);
            if (peakSquareSum > 0.0) {
                peakRms = Math.sqrt(peakSquareSum / (double)peakSamples);
                if (peakRms < rms) {
                    peakRms = rms;
                }
            } else {
                peakRms = rms;
            }
            if (minAmplitude == Double.MAX_VALUE) {
                minAmplitude = Double.NaN;
            }
            if (maxAmplitude == Double.MIN_VALUE) {
                maxAmplitude = Double.NaN;
            }
            int normalized = 0;
            if (!Double.isNaN(minAmplitude) && !Double.isNaN(maxAmplitude)) {
                normalized = maxAmplitude >= this.normalizedAmpThreshold || minAmplitude <= -this.normalizedAmpThreshold ? (maxAmplitude <= 1.0 && minAmplitude >= -1.0 && minAmplitude <= maxAmplitude ? 1 : -1) : -1;
            }
            double firstSoundMillis = Double.NaN;
            if (firstSoundFrameIndex >= 0.0) {
                firstSoundMillis = firstSoundFrameIndex * 1000.0 / (double)sampleRate;
            }
            double lastSoundMillis = Double.NaN;
            if (lastSoundFrameIndex >= 0.0) {
                lastSoundMillis = (lastSoundFrameIndex + 1.0) * 1000.0 / (double)sampleRate;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Analyzed media resource: " + resource + ", channels=" + channels + ", bitDepth=" + bitDepth + ", frameRate=" + sampleRate + ", frameCount=" + totalFrames);
            }
            if (((flags = mme.getFlags()) & 1) != 0) {
                flags -= flags & 1;
            }
            mme.setDuration(duration);
            mme.setFlags(flags);
            mae.setChannels(channels);
            mae.setBitDepth(bitDepth);
            mae.setFrameRate(sampleRate);
            mae.setFrameCount(totalFrames);
            mae.setRms(rms);
            mae.setPeakRms(peakRms);
            mae.setZeroCrossings(zeroCrossings / (long)channels);
            mae.setMinAmplitude(minAmplitude);
            mae.setMaxAmplitude(maxAmplitude);
            mae.setNormalized(normalized);
            mae.setFirstSoundMillis(firstSoundMillis);
            mae.setLastSoundMillis(lastSoundMillis);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            if (mme != null) {
                int flags = mme.getFlags();
                mme.setFlags(flags |= 1);
            }
            MediaEntry mediaEntry = null;
            return mediaEntry;
        }
        finally {
            if (pcmStream != null) {
                pcmStream.close();
            }
        }
        mme.setAudioEntry((AudioEntry)mae);
        return mme;
    }
}

