/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.analyzer.duplicate;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.analyzer.duplicate.DuplicateDetector;
import com.spacekiller.util.media.analyzer.duplicate.DuplicateDetectorOptions;

public class DuplicateDetectorImpl
implements DuplicateDetector {
    private final DuplicateDetectorOptions options;
    private final double durationTolerance;
    private final boolean durationCheck;
    private final double bpmTolerance;
    private final boolean bpmCheck;
    private final double rmsTolerance;
    private final boolean rmsCheck;
    private final double peakTolerance;
    private final boolean peakCheck;
    private final double rmsPeakDiffTolerance;
    private final boolean rmsPeakDiffCheck;
    private final double zeroCrossingsTolerance;
    private final boolean zeroCrossingsCheck;

    public DuplicateDetectorImpl(DuplicateDetectorOptions options) {
        this.options = options;
        this.durationTolerance = options.getDurationTolerance();
        this.durationCheck = this.durationTolerance > 0.0 && options.isDurationEnabled();
        this.bpmTolerance = options.getBpmTolerance();
        this.bpmCheck = this.bpmTolerance > 0.0 && options.isBpmEnabled();
        this.rmsTolerance = options.getRmsTolerance();
        this.rmsCheck = this.rmsTolerance > 0.0 && options.isRmsEnabled();
        this.peakTolerance = options.getPeakTolerance();
        this.peakCheck = this.peakTolerance > 0.0 && options.isPeakEnabled();
        this.rmsPeakDiffTolerance = options.getRmsPeakDiffTolerance();
        this.rmsPeakDiffCheck = this.rmsPeakDiffTolerance > 0.0 && options.isRmsPeakDiffEnabled();
        this.zeroCrossingsTolerance = options.getZeroCrossingsTolerance();
        this.zeroCrossingsCheck = this.zeroCrossingsTolerance > 0.0 && options.isZeroCrossingsEnabled();
    }

    protected DuplicateDetectorOptions getOptions() {
        return this.options;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double compareMediaEntry(MediaEntry a, MediaEntry b) {
        double diff;
        double vb;
        double va;
        Resource ares = a.getResource();
        Resource bres = b.getResource();
        if (ares != null && bres != null && ares.equals(bres)) {
            return 0.0;
        }
        double result = 0.0;
        int resultCount = 0;
        if (this.durationCheck) {
            va = a.getDuration();
            vb = b.getDuration();
            if (!(va >= 0.0) || !(vb >= 0.0)) return 1.0;
            diff = Math.abs(va - vb);
            if (!(diff < this.durationTolerance)) return 1.0;
            result += diff / this.durationTolerance;
            ++resultCount;
        }
        if (this.bpmCheck) {
            va = this.getBpm(a);
            vb = this.getBpm(b);
            if (!(va > 0.0) || !(vb > 0.0)) return 1.0;
            diff = this.diff(va, vb, this.bpmTolerance);
            if (!(diff < 1.0)) return 1.0;
            result += diff;
            ++resultCount;
        }
        if (this.rmsCheck) {
            va = this.getRms(a);
            diff = this.diff(va, vb = this.getRms(b), this.rmsTolerance);
            if (!(diff < 1.0)) return 1.0;
            result += diff;
            ++resultCount;
        }
        if (this.peakCheck) {
            va = this.getPeak(a);
            diff = this.diff(va, vb = this.getPeak(b), this.peakTolerance);
            if (!(diff < 1.0)) return 1.0;
            result += diff;
            ++resultCount;
        }
        if (this.rmsPeakDiffCheck) {
            va = this.getRmsPeakDiff(a);
            diff = this.diff(va, vb = this.getRmsPeakDiff(b), this.rmsPeakDiffTolerance);
            if (!(diff < 1.0)) return 1.0;
            result += diff;
            ++resultCount;
        }
        if (this.zeroCrossingsCheck) {
            va = this.getZeroCrossings(a);
            vb = this.getZeroCrossings(b);
            if (!(va > 0.0) || !(vb > 0.0)) return 1.0;
            diff = this.diff(va, vb, this.zeroCrossingsTolerance);
            if (!(diff < 1.0)) return 1.0;
            result += diff;
            ++resultCount;
        }
        if (resultCount >= true) return result / (double)resultCount;
        return 1.0;
    }

    protected double diff(double va, double vb, double tolerance) {
        double diff;
        if (!Double.isNaN(va) && !Double.isNaN(vb) && (diff = Math.abs((va - vb) / (va + vb))) < tolerance && diff >= 0.0) {
            return diff / tolerance;
        }
        return 1.0;
    }

    protected double getBpm(MediaEntry me) {
        AudioEntry ae;
        if (me != null && (ae = me.getAudioEntry()) != null) {
            return ae.getBpm();
        }
        return Double.NaN;
    }

    protected double getRms(MediaEntry me) {
        AudioEntry ae;
        if (me != null && (ae = me.getAudioEntry()) != null) {
            return ae.getRms();
        }
        return Double.NaN;
    }

    protected double getPeak(MediaEntry me) {
        AudioEntry ae;
        if (me != null && (ae = me.getAudioEntry()) != null) {
            return ae.getPeakRms();
        }
        return Double.NaN;
    }

    protected double getRmsPeakDiff(MediaEntry me) {
        AudioEntry ae;
        if (me != null && (ae = me.getAudioEntry()) != null) {
            double rms = ae.getRms();
            double peak = ae.getPeakRms();
            if (rms >= 0.0 && peak >= 0.0) {
                return peak - rms;
            }
        }
        return Double.NaN;
    }

    protected long getZeroCrossings(MediaEntry me) {
        AudioEntry ae;
        if (me != null && (ae = me.getAudioEntry()) != null) {
            return ae.getZeroCrossings();
        }
        return -1L;
    }
}

