/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.analyzer.duplicate;

import com.spacekiller.util.media.analyzer.duplicate.DuplicateDetectorOptions;
import com.spacekiller.util.media.control.AbstractDoubleControl;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.TextFieldControlPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DuplicateDetectorPanel
extends JPanel {
    private static final long serialVersionUID = 3430573901440083353L;
    private DuplicateDetectorOptions options;
    private boolean refreshing;
    private DurationToleranceControl durationToleranceControl = new DurationToleranceControl();
    private BpmToleranceControl bpmToleranceControl = new BpmToleranceControl();
    private RmsToleranceControl rmsToleranceControl = new RmsToleranceControl();
    private PeakToleranceControl peakToleranceControl = new PeakToleranceControl();
    private RmsPeakDiffToleranceControl rmsPeakDiffToleranceControl = new RmsPeakDiffToleranceControl();
    private ZeroCrossingsToleranceControl zeroCrossingsToleranceControl = new ZeroCrossingsToleranceControl();
    private ThresholdControl thresholdControl = new ThresholdControl();
    private TextFieldControlPanel textFieldControlPanelDuration;
    private TextFieldControlPanel textFieldControlPanelBPM;
    private TextFieldControlPanel textFieldControlPanelRMS;
    private TextFieldControlPanel textFieldControlPanelThreshold;
    private JCheckBox chckbxCompareDuration;
    private JCheckBox chckbxCompareBpm;
    private JCheckBox chckbxCompareRms;
    private JRadioButton rdbtnOnlyCheckSelected;
    private JRadioButton rdbtnCheckAllEntries;
    private JCheckBox chckbxCompareFilePath;
    private JCheckBox chckbxComparePeak;
    private JCheckBox chckbxCompareRmsPeakDiff;
    private JCheckBox chckbxZeroCrossings;
    private TextFieldControlPanel textFieldControlPanelPeak;
    private TextFieldControlPanel textFieldControlPanelRmsPeakDiff;
    private TextFieldControlPanel textFieldControlPanelZeroCrossings;

    public DuplicateDetectorPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.weighty = 1.0;
        gbc_panel.weightx = 1.0;
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        this.chckbxCompareDuration = new JCheckBox("Compare Duration:");
        this.chckbxCompareDuration.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!DuplicateDetectorPanel.this.refreshing) {
                    if (DuplicateDetectorPanel.this.options != null) {
                        DuplicateDetectorPanel.this.options.setDurationEnabled(DuplicateDetectorPanel.this.chckbxCompareDuration.isSelected());
                    }
                    DuplicateDetectorPanel.this.checkEnable();
                }
            }
        });
        this.chckbxCompareFilePath = new JCheckBox("Compare File Path");
        this.chckbxCompareFilePath.setSelected(true);
        this.chckbxCompareFilePath.setEnabled(false);
        GridBagConstraints gbc_chckbxCompareFilePath = new GridBagConstraints();
        gbc_chckbxCompareFilePath.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxCompareFilePath.gridx = 0;
        gbc_chckbxCompareFilePath.gridy = 0;
        panel.add((Component)this.chckbxCompareFilePath, gbc_chckbxCompareFilePath);
        this.chckbxCompareDuration.setToolTipText("Max. duration difference (seconds)");
        GridBagConstraints gbc_chckbxCompareDuration = new GridBagConstraints();
        gbc_chckbxCompareDuration.anchor = 17;
        gbc_chckbxCompareDuration.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxCompareDuration.gridx = 0;
        gbc_chckbxCompareDuration.gridy = 1;
        panel.add((Component)this.chckbxCompareDuration, gbc_chckbxCompareDuration);
        this.textFieldControlPanelDuration = new TextFieldControlPanel();
        this.textFieldControlPanelDuration.setColumns(10);
        GridBagConstraints gbc_textFieldControlPanelDuration = new GridBagConstraints();
        gbc_textFieldControlPanelDuration.weightx = 1.0;
        gbc_textFieldControlPanelDuration.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldControlPanelDuration.fill = 2;
        gbc_textFieldControlPanelDuration.gridx = 1;
        gbc_textFieldControlPanelDuration.gridy = 1;
        panel.add((Component)this.textFieldControlPanelDuration, gbc_textFieldControlPanelDuration);
        this.chckbxCompareBpm = new JCheckBox("Compare BPM:");
        this.chckbxCompareBpm.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!DuplicateDetectorPanel.this.refreshing) {
                    if (DuplicateDetectorPanel.this.options != null) {
                        DuplicateDetectorPanel.this.options.setBpmEnabled(DuplicateDetectorPanel.this.chckbxCompareBpm.isSelected());
                    }
                    DuplicateDetectorPanel.this.checkEnable();
                }
            }
        });
        this.chckbxCompareBpm.setToolTipText("Max. BPM difference");
        GridBagConstraints gbc_chckbxCompareBpm = new GridBagConstraints();
        gbc_chckbxCompareBpm.anchor = 17;
        gbc_chckbxCompareBpm.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxCompareBpm.gridx = 0;
        gbc_chckbxCompareBpm.gridy = 2;
        panel.add((Component)this.chckbxCompareBpm, gbc_chckbxCompareBpm);
        this.textFieldControlPanelBPM = new TextFieldControlPanel();
        this.textFieldControlPanelBPM.setColumns(10);
        GridBagConstraints gbc_textFieldControlPanelBPM = new GridBagConstraints();
        gbc_textFieldControlPanelBPM.weightx = 1.0;
        gbc_textFieldControlPanelBPM.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldControlPanelBPM.fill = 2;
        gbc_textFieldControlPanelBPM.gridx = 1;
        gbc_textFieldControlPanelBPM.gridy = 2;
        panel.add((Component)this.textFieldControlPanelBPM, gbc_textFieldControlPanelBPM);
        this.chckbxCompareRms = new JCheckBox("Compare RMS:");
        this.chckbxCompareRms.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!DuplicateDetectorPanel.this.refreshing) {
                    if (DuplicateDetectorPanel.this.options != null) {
                        DuplicateDetectorPanel.this.options.setRmsEnabled(DuplicateDetectorPanel.this.chckbxCompareRms.isSelected());
                    }
                    DuplicateDetectorPanel.this.checkEnable();
                }
            }
        });
        this.chckbxCompareRms.setToolTipText("Max. RMS difference");
        GridBagConstraints gbc_chckbxCompareRms = new GridBagConstraints();
        gbc_chckbxCompareRms.anchor = 17;
        gbc_chckbxCompareRms.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxCompareRms.gridx = 0;
        gbc_chckbxCompareRms.gridy = 3;
        panel.add((Component)this.chckbxCompareRms, gbc_chckbxCompareRms);
        this.textFieldControlPanelRMS = new TextFieldControlPanel();
        this.textFieldControlPanelRMS.setColumns(10);
        GridBagConstraints gbc_textFieldControlPanelRMS = new GridBagConstraints();
        gbc_textFieldControlPanelRMS.weightx = 1.0;
        gbc_textFieldControlPanelRMS.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldControlPanelRMS.fill = 2;
        gbc_textFieldControlPanelRMS.gridx = 1;
        gbc_textFieldControlPanelRMS.gridy = 3;
        panel.add((Component)this.textFieldControlPanelRMS, gbc_textFieldControlPanelRMS);
        this.chckbxComparePeak = new JCheckBox("Compare Peak:");
        this.chckbxComparePeak.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!DuplicateDetectorPanel.this.refreshing) {
                    if (DuplicateDetectorPanel.this.options != null) {
                        DuplicateDetectorPanel.this.options.setPeakEnabled(DuplicateDetectorPanel.this.chckbxComparePeak.isSelected());
                    }
                    DuplicateDetectorPanel.this.checkEnable();
                }
            }
        });
        this.chckbxComparePeak.setToolTipText("Max. Peak difference");
        GridBagConstraints gbc_chckbxComparePeak = new GridBagConstraints();
        gbc_chckbxComparePeak.anchor = 17;
        gbc_chckbxComparePeak.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxComparePeak.gridx = 0;
        gbc_chckbxComparePeak.gridy = 4;
        panel.add((Component)this.chckbxComparePeak, gbc_chckbxComparePeak);
        this.textFieldControlPanelPeak = new TextFieldControlPanel();
        GridBagConstraints gbc_textFieldControlPanelPeak = new GridBagConstraints();
        gbc_textFieldControlPanelPeak.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldControlPanelPeak.fill = 2;
        gbc_textFieldControlPanelPeak.gridx = 1;
        gbc_textFieldControlPanelPeak.gridy = 4;
        panel.add((Component)this.textFieldControlPanelPeak, gbc_textFieldControlPanelPeak);
        this.chckbxCompareRmsPeakDiff = new JCheckBox("RMS/Peak Diff.:");
        this.chckbxCompareRmsPeakDiff.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!DuplicateDetectorPanel.this.refreshing) {
                    if (DuplicateDetectorPanel.this.options != null) {
                        DuplicateDetectorPanel.this.options.setRmsPeakDiffEnabled(DuplicateDetectorPanel.this.chckbxCompareRmsPeakDiff.isSelected());
                    }
                    DuplicateDetectorPanel.this.checkEnable();
                }
            }
        });
        this.chckbxCompareRmsPeakDiff.setToolTipText("Max. RMS/Peak difference");
        GridBagConstraints gbc_chckbxCompareRmsPeakDiff = new GridBagConstraints();
        gbc_chckbxCompareRmsPeakDiff.anchor = 17;
        gbc_chckbxCompareRmsPeakDiff.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxCompareRmsPeakDiff.gridx = 0;
        gbc_chckbxCompareRmsPeakDiff.gridy = 5;
        panel.add((Component)this.chckbxCompareRmsPeakDiff, gbc_chckbxCompareRmsPeakDiff);
        this.textFieldControlPanelRmsPeakDiff = new TextFieldControlPanel();
        GridBagConstraints gbc_textFieldControlPanelRmsPeakDiff = new GridBagConstraints();
        gbc_textFieldControlPanelRmsPeakDiff.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldControlPanelRmsPeakDiff.fill = 2;
        gbc_textFieldControlPanelRmsPeakDiff.gridx = 1;
        gbc_textFieldControlPanelRmsPeakDiff.gridy = 5;
        panel.add((Component)this.textFieldControlPanelRmsPeakDiff, gbc_textFieldControlPanelRmsPeakDiff);
        this.chckbxZeroCrossings = new JCheckBox("Zero Crossings:");
        this.chckbxZeroCrossings.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!DuplicateDetectorPanel.this.refreshing) {
                    if (DuplicateDetectorPanel.this.options != null) {
                        DuplicateDetectorPanel.this.options.setZeroCrossingsEnabled(DuplicateDetectorPanel.this.chckbxZeroCrossings.isSelected());
                    }
                    DuplicateDetectorPanel.this.checkEnable();
                }
            }
        });
        this.chckbxZeroCrossings.setToolTipText("Max. Zero Crossings difference");
        GridBagConstraints gbc_chckbxZeroCrossings = new GridBagConstraints();
        gbc_chckbxZeroCrossings.anchor = 17;
        gbc_chckbxZeroCrossings.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxZeroCrossings.gridx = 0;
        gbc_chckbxZeroCrossings.gridy = 6;
        panel.add((Component)this.chckbxZeroCrossings, gbc_chckbxZeroCrossings);
        this.textFieldControlPanelZeroCrossings = new TextFieldControlPanel();
        GridBagConstraints gbc_textFieldControlPanelZeroCrossings = new GridBagConstraints();
        gbc_textFieldControlPanelZeroCrossings.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldControlPanelZeroCrossings.fill = 2;
        gbc_textFieldControlPanelZeroCrossings.gridx = 1;
        gbc_textFieldControlPanelZeroCrossings.gridy = 6;
        panel.add((Component)this.textFieldControlPanelZeroCrossings, gbc_textFieldControlPanelZeroCrossings);
        JLabel lblThreshold = new JLabel("Threshold:");
        lblThreshold.setToolTipText("Overall threshold");
        GridBagConstraints gbc_lblThreshold = new GridBagConstraints();
        gbc_lblThreshold.insets = new Insets(0, 4, 5, 5);
        gbc_lblThreshold.anchor = 17;
        gbc_lblThreshold.gridx = 0;
        gbc_lblThreshold.gridy = 7;
        panel.add((Component)lblThreshold, gbc_lblThreshold);
        this.textFieldControlPanelThreshold = new TextFieldControlPanel();
        this.textFieldControlPanelThreshold.setColumns(10);
        GridBagConstraints gbc_textFieldControlPanelThreshold = new GridBagConstraints();
        gbc_textFieldControlPanelThreshold.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldControlPanelThreshold.weightx = 1.0;
        gbc_textFieldControlPanelThreshold.fill = 2;
        gbc_textFieldControlPanelThreshold.gridx = 1;
        gbc_textFieldControlPanelThreshold.gridy = 7;
        panel.add((Component)this.textFieldControlPanelThreshold, gbc_textFieldControlPanelThreshold);
        this.rdbtnOnlyCheckSelected = new JRadioButton("Check selected entries only");
        this.rdbtnOnlyCheckSelected.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!DuplicateDetectorPanel.this.refreshing && DuplicateDetectorPanel.this.options != null) {
                    DuplicateDetectorPanel.this.options.setCheckSelectedOnly(true);
                }
            }
        });
        this.rdbtnOnlyCheckSelected.setToolTipText("Only compare selected entries with all others in the table...");
        GridBagConstraints gbc_rdbtnOnlyCheckSelected = new GridBagConstraints();
        gbc_rdbtnOnlyCheckSelected.insets = new Insets(4, 0, 0, 0);
        gbc_rdbtnOnlyCheckSelected.anchor = 17;
        gbc_rdbtnOnlyCheckSelected.gridwidth = 2;
        gbc_rdbtnOnlyCheckSelected.gridx = 0;
        gbc_rdbtnOnlyCheckSelected.gridy = 8;
        panel.add((Component)this.rdbtnOnlyCheckSelected, gbc_rdbtnOnlyCheckSelected);
        this.rdbtnCheckAllEntries = new JRadioButton("Check all entries");
        this.rdbtnCheckAllEntries.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!DuplicateDetectorPanel.this.refreshing && DuplicateDetectorPanel.this.options != null) {
                    DuplicateDetectorPanel.this.options.setCheckSelectedOnly(false);
                }
            }
        });
        this.rdbtnCheckAllEntries.setToolTipText("Compare all entries... (may take some time)");
        GridBagConstraints gbc_rdbtnCheckAllEntries = new GridBagConstraints();
        gbc_rdbtnCheckAllEntries.gridwidth = 2;
        gbc_rdbtnCheckAllEntries.anchor = 17;
        gbc_rdbtnCheckAllEntries.gridx = 0;
        gbc_rdbtnCheckAllEntries.gridy = 9;
        panel.add((Component)this.rdbtnCheckAllEntries, gbc_rdbtnCheckAllEntries);
        this.initDuplicateDetectorPanel();
    }

    protected void initDuplicateDetectorPanel() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.getRdbtnOnlyCheckSelected());
        group.add(this.getRdbtnCheckAllEntries());
        this.textFieldControlPanelDuration.setControl((Control)this.durationToleranceControl);
        this.textFieldControlPanelBPM.setControl((Control)this.bpmToleranceControl);
        this.textFieldControlPanelRMS.setControl((Control)this.rmsToleranceControl);
        this.textFieldControlPanelPeak.setControl((Control)this.peakToleranceControl);
        this.textFieldControlPanelRmsPeakDiff.setControl((Control)this.rmsPeakDiffToleranceControl);
        this.textFieldControlPanelZeroCrossings.setControl((Control)this.zeroCrossingsToleranceControl);
        this.textFieldControlPanelThreshold.setControl((Control)this.thresholdControl);
    }

    public DuplicateDetectorOptions getOptions() {
        return this.options;
    }

    public void setOptions(DuplicateDetectorOptions options) {
        this.options = options;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        try {
            this.refreshing = true;
            if (this.options != null) {
                this.chckbxCompareDuration.setSelected(this.options.isDurationEnabled());
                this.chckbxCompareBpm.setSelected(this.options.isBpmEnabled());
                this.chckbxCompareRms.setSelected(this.options.isRmsEnabled());
                this.chckbxComparePeak.setSelected(this.options.isPeakEnabled());
                this.chckbxCompareRmsPeakDiff.setSelected(this.options.isRmsPeakDiffEnabled());
                this.chckbxZeroCrossings.setSelected(this.options.isZeroCrossingsEnabled());
                this.durationToleranceControl.setDouble(this.options.getDurationTolerance());
                this.bpmToleranceControl.setDouble(this.options.getBpmTolerance());
                this.rmsToleranceControl.setDouble(this.options.getRmsTolerance());
                this.peakToleranceControl.setDouble(this.options.getPeakTolerance());
                this.rmsPeakDiffToleranceControl.setDouble(this.options.getRmsPeakDiffTolerance());
                this.zeroCrossingsToleranceControl.setDouble(this.options.getZeroCrossingsTolerance());
                this.thresholdControl.setDouble(this.options.getThreshold());
                if (this.options.isCheckSelectedOnly()) {
                    this.rdbtnOnlyCheckSelected.setSelected(true);
                } else {
                    this.rdbtnCheckAllEntries.setSelected(true);
                }
            }
            this.checkEnable();
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void checkEnable() {
        this.textFieldControlPanelDuration.setEnabled(this.chckbxCompareDuration.isSelected());
        this.textFieldControlPanelBPM.setEnabled(this.chckbxCompareBpm.isSelected());
        this.textFieldControlPanelRMS.setEnabled(this.chckbxCompareRms.isSelected());
        this.textFieldControlPanelPeak.setEnabled(this.chckbxComparePeak.isSelected());
        this.textFieldControlPanelRmsPeakDiff.setEnabled(this.chckbxCompareRmsPeakDiff.isSelected());
        this.textFieldControlPanelZeroCrossings.setEnabled(this.chckbxZeroCrossings.isSelected());
    }

    protected TextFieldControlPanel getTextFieldControlPanelDuration() {
        return this.textFieldControlPanelDuration;
    }

    protected TextFieldControlPanel getTextFieldControlPanelBPM() {
        return this.textFieldControlPanelBPM;
    }

    protected TextFieldControlPanel getTextFieldControlPanelRMS() {
        return this.textFieldControlPanelRMS;
    }

    protected TextFieldControlPanel getTextFieldControlPanelThreshold() {
        return this.textFieldControlPanelThreshold;
    }

    protected JCheckBox getChckbxCompareDuration() {
        return this.chckbxCompareDuration;
    }

    protected JCheckBox getChckbxCompareBpm() {
        return this.chckbxCompareBpm;
    }

    protected JCheckBox getChckbxCompareRms() {
        return this.chckbxCompareRms;
    }

    protected JRadioButton getRdbtnOnlyCheckSelected() {
        return this.rdbtnOnlyCheckSelected;
    }

    protected JRadioButton getRdbtnCheckAllEntries() {
        return this.rdbtnCheckAllEntries;
    }

    protected TextFieldControlPanel getTextFieldControlPanelPeak() {
        return this.textFieldControlPanelPeak;
    }

    protected TextFieldControlPanel getTextFieldControlPanelRmsPeakDiff() {
        return this.textFieldControlPanelRmsPeakDiff;
    }

    protected TextFieldControlPanel getTextFieldControlPanelZeroCrossings() {
        return this.textFieldControlPanelZeroCrossings;
    }

    protected JCheckBox getChckbxComparePeak() {
        return this.chckbxComparePeak;
    }

    protected JCheckBox getChckbxCompareRmsPeakDiff() {
        return this.chckbxCompareRmsPeakDiff;
    }

    protected JCheckBox getChckbxZeroCrossings() {
        return this.chckbxZeroCrossings;
    }

    protected class ThresholdControl
    extends AbstractDetectorControl {
        protected ThresholdControl() {
        }

        protected void applyDouble(double v) {
            if (DuplicateDetectorPanel.this.options != null && !DuplicateDetectorPanel.this.refreshing) {
                DuplicateDetectorPanel.this.options.setThreshold(v);
            }
        }
    }

    protected class ZeroCrossingsToleranceControl
    extends AbstractDetectorControl {
        protected ZeroCrossingsToleranceControl() {
        }

        protected void applyDouble(double v) {
            if (DuplicateDetectorPanel.this.options != null && !DuplicateDetectorPanel.this.refreshing) {
                DuplicateDetectorPanel.this.options.setZeroCrossingsTolerance(v);
            }
        }
    }

    protected class RmsPeakDiffToleranceControl
    extends AbstractDetectorControl {
        protected RmsPeakDiffToleranceControl() {
        }

        protected void applyDouble(double v) {
            if (DuplicateDetectorPanel.this.options != null && !DuplicateDetectorPanel.this.refreshing) {
                DuplicateDetectorPanel.this.options.setRmsPeakDiffTolerance(v);
            }
        }
    }

    protected class PeakToleranceControl
    extends AbstractDetectorControl {
        protected PeakToleranceControl() {
        }

        protected void applyDouble(double v) {
            if (DuplicateDetectorPanel.this.options != null && !DuplicateDetectorPanel.this.refreshing) {
                DuplicateDetectorPanel.this.options.setPeakTolerance(v);
            }
        }
    }

    protected class RmsToleranceControl
    extends AbstractDetectorControl {
        protected RmsToleranceControl() {
        }

        protected void applyDouble(double v) {
            if (DuplicateDetectorPanel.this.options != null && !DuplicateDetectorPanel.this.refreshing) {
                DuplicateDetectorPanel.this.options.setRmsTolerance(v);
            }
        }
    }

    protected class BpmToleranceControl
    extends AbstractDetectorControl {
        protected BpmToleranceControl() {
        }

        protected void applyDouble(double v) {
            if (DuplicateDetectorPanel.this.options != null && !DuplicateDetectorPanel.this.refreshing) {
                DuplicateDetectorPanel.this.options.setBpmTolerance(v);
            }
        }
    }

    protected class DurationToleranceControl
    extends AbstractDetectorControl {
        protected DurationToleranceControl() {
        }

        protected void applyDouble(double v) {
            if (DuplicateDetectorPanel.this.options != null && !DuplicateDetectorPanel.this.refreshing) {
                DuplicateDetectorPanel.this.options.setDurationTolerance(v);
            }
        }
    }

    protected abstract class AbstractDetectorControl
    extends AbstractDoubleControl {
        public AbstractDetectorControl() {
            this.setMinimum(0.0);
            this.setMaximum(1000000.0);
        }
    }
}

