/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.buffer;

import com.spacekiller.util.Data;
import com.spacekiller.util.buffer.Position;
import com.spacekiller.util.buffer.UTFBuffer;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;

public abstract class AbstractDataOutput
implements DataOutput,
Position {
    protected byte[] b;
    protected int bo;
    protected int bs;
    protected UTFBuffer utf;

    public AbstractDataOutput(int bufferSize) {
        this.b = new byte[Math.max(bufferSize, 8)];
        this.bo = 0;
        this.bs = this.b.length;
        this.utf = new UTFBuffer();
    }

    @Override
    public int position() {
        return this.bo;
    }

    public void close() throws IOException {
        this.b = null;
        this.bo = 0;
        this.bs = 0;
    }

    @Override
    public void write(byte[] x, int off, int len) throws IOException {
        if (len < this.bs && this.bo + len <= this.bs) {
            System.arraycopy(x, off, this.b, this.bo, len);
            this.bo += len;
        } else {
            this.drain(x, off, len);
        }
    }

    @Override
    public void write(byte[] x) throws IOException {
        this.write(x, 0, x.length);
    }

    @Override
    public void write(int x) throws IOException {
        if (this.bo >= this.bs) {
            this.drain();
        }
        this.b[this.bo++] = (byte)x;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        if (this.bo >= this.bs) {
            this.drain();
        }
        Data.setBoolean((byte[])this.b, (int)this.bo++, (boolean)v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        if (this.bo >= this.bs) {
            this.drain();
        }
        this.b[this.bo++] = (byte)v;
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.write(s.getBytes());
    }

    @Override
    public void writeChar(int v) throws IOException {
        if (this.bo + 2 > this.bs) {
            this.drain();
        }
        Data.setChar((byte[])this.b, (int)this.bo, (char)((char)v));
        this.bo += 2;
    }

    @Override
    public void writeChars(String s) throws IOException {
        int i = 0;
        int len = s.length();
        while (i < len) {
            int m = (this.bs - this.bo) / 2;
            if (m < 1) {
                this.drain();
                m = (this.bs - this.bo) / 2;
            }
            int n = Math.min(len - i, m);
            for (m = 0; m < n; ++m) {
                Data.setChar((byte[])this.b, (int)this.bo, (char)s.charAt(i++));
                this.bo += 2;
            }
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        if (this.bo + 8 > this.bs) {
            this.drain();
        }
        Data.setDouble((byte[])this.b, (int)this.bo, (double)v);
        this.bo += 8;
    }

    @Override
    public void writeFloat(float v) throws IOException {
        if (this.bo + 4 > this.bs) {
            this.drain();
        }
        Data.setFloat((byte[])this.b, (int)this.bo, (float)v);
        this.bo += 4;
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.bo + 4 > this.bs) {
            this.drain();
        }
        Data.setInt((byte[])this.b, (int)this.bo, (int)v);
        this.bo += 4;
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.bo + 8 > this.bs) {
            this.drain();
        }
        Data.setLong((byte[])this.b, (int)this.bo, (long)v);
        this.bo += 8;
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this.bo + 2 > this.bs) {
            this.drain();
        }
        Data.setShort((byte[])this.b, (int)this.bo, (short)((short)v));
        this.bo += 2;
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int len = (int)this.utf.getUTFLength(s);
        if (len > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeChar(len);
        if (this.bo + len > this.bs) {
            this.drain();
            if (len > this.bs) {
                this.bs = len * 3 / 2;
                this.b = new byte[this.bs];
            }
        }
        this.bo += this.utf.writeUTF(s, this.b, this.bo);
    }

    protected abstract void drain() throws IOException;

    protected abstract void drain(byte[] var1, int var2, int var3) throws IOException;
}

