/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.buffer;

import com.spacekiller.util.buffer.Buffer;

public final class Buffers {
    private Buffers() {
    }

    public static void copy(Buffer src, int srcOfs, Buffer dst, int dstOfs, int len) {
        int srcLen = src.length();
        if (srcOfs < 0) {
            throw new ArrayIndexOutOfBoundsException("" + srcOfs + " < 0");
        }
        if (srcOfs + len > srcLen) {
            throw new ArrayIndexOutOfBoundsException("" + (srcOfs + len) + " > " + srcLen);
        }
        int dstLen = dst.length();
        if (dstOfs < 0) {
            throw new ArrayIndexOutOfBoundsException("" + dstOfs + " < 0");
        }
        if (dstOfs + len > dstLen) {
            throw new ArrayIndexOutOfBoundsException("" + (dstOfs + len) + " > " + dstLen);
        }
        System.arraycopy(src.array(), src.offset() + srcOfs, dst.array(), dst.offset() + dstOfs, len);
    }

    public static void copy(Buffer src, int srcOfs, Object dst, int dstOfs, int len) {
        int srcLen = src.length();
        if (srcOfs < 0) {
            throw new ArrayIndexOutOfBoundsException("" + srcOfs + " < 0");
        }
        if (srcOfs + len > srcLen) {
            throw new ArrayIndexOutOfBoundsException("" + (srcOfs + len) + " > " + srcLen);
        }
        System.arraycopy(src.array(), src.offset() + srcOfs, dst, dstOfs, len);
    }

    public static void copy(Object src, int srcOfs, Buffer dst, int dstOfs, int len) {
        int dstLen = dst.length();
        if (dstOfs < 0) {
            throw new ArrayIndexOutOfBoundsException("" + dstOfs + " < 0");
        }
        if (dstOfs + len > dstLen) {
            throw new ArrayIndexOutOfBoundsException("" + (dstOfs + len) + " > " + dstLen);
        }
        System.arraycopy(src, srcOfs, dst.array(), dst.offset() + dstOfs, len);
    }
}

