/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.buffer;

import com.spacekiller.util.buffer.Position;
import com.spacekiller.util.buffer.UTFBuffer;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;

public class PositionDataInput
implements DataInput,
Position {
    protected DataInputStream dis;
    protected int pos;
    protected UTFBuffer utf;

    public PositionDataInput(DataInputStream dis) {
        this.dis = dis;
        this.pos = 0;
        this.utf = new UTFBuffer();
    }

    @Override
    public boolean readBoolean() throws IOException {
        boolean v = this.dis.readBoolean();
        ++this.pos;
        return v;
    }

    @Override
    public byte readByte() throws IOException {
        byte v = this.dis.readByte();
        ++this.pos;
        return v;
    }

    @Override
    public char readChar() throws IOException {
        char v = this.dis.readChar();
        this.pos += 2;
        return v;
    }

    @Override
    public double readDouble() throws IOException {
        double v = this.dis.readDouble();
        this.pos += 8;
        return v;
    }

    @Override
    public float readFloat() throws IOException {
        float v = this.dis.readFloat();
        this.pos += 4;
        return v;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.dis.readFully(b, off, len);
        this.pos += len;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public int readInt() throws IOException {
        int v = this.dis.readInt();
        this.pos += 4;
        return v;
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readLong() throws IOException {
        long v = this.dis.readLong();
        this.pos += 8;
        return v;
    }

    @Override
    public short readShort() throws IOException {
        short v = this.dis.readShort();
        this.pos += 2;
        return v;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int v = this.dis.readUnsignedByte();
        ++this.pos;
        return v;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int v = this.dis.readUnsignedShort();
        this.pos += 2;
        return v;
    }

    @Override
    public String readUTF() throws IOException {
        char utfLen = this.dis.readChar();
        this.pos += 2;
        StringBuffer sbuf = new StringBuffer();
        this.utf.readUTF(this, sbuf, utfLen);
        this.pos += utfLen;
        return sbuf.toString();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int rc = this.dis.skipBytes(n);
        if (rc > 0) {
            this.pos += rc;
        }
        return rc;
    }

    @Override
    public int position() {
        return this.pos;
    }

    public int read() throws IOException {
        int v = this.dis.read();
        ++this.pos;
        return v;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int v = this.dis.read(b, off, len);
        if (v > 0) {
            this.pos += v;
        }
        return v;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

