/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.buffer;

import com.spacekiller.util.buffer.LongInput;
import com.spacekiller.util.buffer.LongOutput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class RandomAccessLongBuffer
implements LongInput,
LongOutput {
    private List data = new ArrayList();
    private int bufCount = 0;
    private long[] buf;
    private int bufId = 0;
    private int bufOfs = 0;
    private int bufLen = 0;
    private int bufPos = 0;
    private int incrementSize = 1024;

    public RandomAccessLongBuffer(int incrementSize) {
        this.incrementSize = incrementSize;
        this.buf = new long[incrementSize];
        this.data.add(this.buf);
        this.bufId = 0;
        this.bufOfs = 0;
        this.bufLen = this.buf.length;
        this.bufPos = 0;
        this.bufCount = this.data.size();
    }

    public int getPosition() {
        return this.bufOfs + this.bufPos;
    }

    protected boolean nextBuffer(boolean allocate) {
        if (this.bufId + 1 >= this.bufCount) {
            if (allocate) {
                ++this.bufId;
                this.bufOfs += this.bufLen;
                this.buf = new long[this.incrementSize];
                this.data.add(this.buf);
                ++this.bufCount;
                this.bufLen = this.buf.length;
                this.bufPos = 0;
                return true;
            }
            return false;
        }
        ++this.bufId;
        this.bufOfs += this.bufLen;
        this.buf = (long[])this.data.get(this.bufId);
        this.bufLen = this.buf.length;
        this.bufPos = 0;
        return true;
    }

    protected boolean prevBuffer() {
        if (this.bufId < 1) {
            return false;
        }
        --this.bufId;
        this.buf = (long[])this.data.get(this.bufId);
        this.bufLen = this.buf.length;
        this.bufOfs -= this.bufLen;
        this.bufPos = 0;
        return true;
    }

    @Override
    public long read() {
        long rc = this.buf[this.bufPos++];
        if (this.bufPos >= this.bufLen) {
            this.nextBuffer(false);
        }
        return rc;
    }

    @Override
    public void read(long[] dst, int ofs, int len) {
        if (len < 1) {
            return;
        }
        while (true) {
            int num = Math.min(this.bufLen - this.bufPos, len);
            for (int c = 0; c < num; ++c) {
                dst[ofs++] = this.buf[this.bufPos++];
            }
            if ((len -= num) < 1) {
                return;
            }
            this.nextBuffer(true);
        }
    }

    @Override
    public void read(DataOutputStream out, int len) throws IOException {
        if (len < 1) {
            return;
        }
        while (true) {
            int num = Math.min(this.bufLen - this.bufPos, len);
            for (int c = 0; c < num; ++c) {
                out.writeLong(this.buf[this.bufPos++]);
            }
            if ((len -= num) < 1) {
                return;
            }
            this.nextBuffer(true);
        }
    }

    public void seek(int ofs) {
        if (ofs < 0) {
            throw new ArrayIndexOutOfBoundsException(ofs);
        }
        if (ofs >= this.bufOfs) {
            while (ofs >= this.bufOfs + this.bufLen) {
                this.nextBuffer(true);
            }
        } else {
            while (this.prevBuffer() && ofs <= this.bufOfs) {
            }
        }
        this.bufPos = ofs - this.bufOfs;
    }

    @Override
    public void write(long[] src, int ofs, int len) {
        if (len < 1) {
            return;
        }
        while (true) {
            int num = Math.min(this.bufLen - this.bufPos, len);
            for (int c = 0; c < num; ++c) {
                this.buf[this.bufPos++] = src[ofs++];
            }
            if ((len -= num) < 1) {
                return;
            }
            this.nextBuffer(true);
        }
    }

    @Override
    public void write(long i) {
        this.buf[this.bufPos++] = i;
        if (this.bufPos >= this.bufLen) {
            this.nextBuffer(true);
        }
    }

    @Override
    public void write(DataInputStream in, int len) throws IOException {
        if (len < 1) {
            return;
        }
        while (true) {
            int num = Math.min(this.bufLen - this.bufPos, len);
            for (int c = 0; c < num; ++c) {
                this.buf[this.bufPos++] = in.readLong();
            }
            if ((len -= num) < 1) {
                return;
            }
            this.nextBuffer(true);
        }
    }
}

