/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.buffer;

import com.spacekiller.util.buffer.CharBuffer;

public class TextBuffer
implements CharSequence,
CharBuffer {
    private char[] arr;
    private int count;

    public TextBuffer() {
    }

    public TextBuffer(String s) {
        this.arr = new char[s.length() + 16];
        this.append(s);
    }

    public TextBuffer(int capacity) {
        this.arr = new char[capacity];
        this.count = 0;
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public char charAt(int index) {
        return this.arr[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new String(this.arr, start, end - start);
    }

    public String subString(int start, int end) {
        return new String(this.arr, start, end - start);
    }

    @Override
    public String toString() {
        return new String(this.arr, 0, this.count);
    }

    @Override
    public int offset() {
        return 0;
    }

    @Override
    public Object array() {
        return this.arr;
    }

    @Override
    public char[] charArray() {
        return this.arr;
    }

    public void append(char c) {
        if (this.count < this.arr.length) {
            this.arr[this.count++] = c;
        } else {
            this.grow(this.count + 1);
            this.arr[this.count++] = c;
        }
    }

    public void append(char[] c) {
        this.append(c, 0, c.length);
    }

    public void append(char[] c, int off, int len) {
        int newCount = this.count + len;
        if (newCount > this.arr.length) {
            this.grow(newCount);
        }
        System.arraycopy(c, off, this.arr, this.count, len);
        this.count = newCount;
    }

    public void append(String s) {
        int len;
        if (s == null) {
            s = "null";
        }
        if ((len = s.length()) == 0) {
            return;
        }
        int newCount = this.count + len;
        if (newCount > this.arr.length) {
            this.grow(newCount);
        }
        s.getChars(0, len, this.arr, this.count);
        this.count = newCount;
    }

    public void setCharAt(int index, char ch) {
        this.arr[index] = ch;
    }

    public int capacity() {
        return this.arr.length;
    }

    private void grow(int min) {
        int newCapacity = (this.arr.length + 1) * 2;
        if (min > newCapacity) {
            newCapacity = min;
        }
        char[] dst = new char[newCapacity];
        System.arraycopy(this.arr, 0, dst, 0, this.count);
        this.arr = dst;
    }

    public int indexOf(char c, int from) {
        for (int i = from; i < this.count; ++i) {
            if (this.arr[i] != c) continue;
            return i;
        }
        return -1;
    }

    public void delete(int start, int end) {
        int len = end - start;
        if (len > 0) {
            System.arraycopy(this.arr, end, this.arr, start, this.count - end);
            this.count -= len;
        }
    }

    public void insert(int offset, String s) {
        int len;
        int newCount;
        if (s == null) {
            s = "null";
        }
        if ((newCount = this.count + (len = s.length())) > this.arr.length) {
            this.grow(newCount);
        }
        System.arraycopy(this.arr, offset, this.arr, offset + len, this.count - offset);
        s.getChars(0, len, this.arr, offset);
        this.count = newCount;
    }
}

