/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.impl;

import com.waxmonster.audio.AudioContext;
import com.waxmonster.audio.AudioEngine;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.impl.AudioContextImpl;
import com.waxmonster.audio.impl.AudioEngineConfig;
import com.waxmonster.audio.impl.DefaultSyncManagerStrategy;
import com.waxmonster.audio.impl.OutputBufferProxy;
import com.waxmonster.audio.impl.SampleBufferProxy;
import com.waxmonster.audio.impl.SourceBufferProxy;
import com.waxmonster.audio.impl.SyncAudioEngine;
import com.waxmonster.audio.impl.SyncBufferProxy;
import com.waxmonster.audio.impl.SyncManagerProxy;
import com.waxmonster.audio.impl.SyncManagerStrategy;
import com.waxmonster.audio.impl.SyncSourceProxy;
import com.waxmonster.audio.impl.SyncTargetProxy;
import com.waxmonster.audio.impl.Wrapper;
import com.waxmonster.audio.impl.WrapperInputPort;
import com.waxmonster.audio.impl.WrapperOutputPort;
import com.waxmonster.studio.Studio;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public abstract class AbstractAudioEngine
implements AudioEngine {
    private static final Logger logger = Logger.getLogger(AbstractAudioEngine.class.getName());
    protected final AudioEngineConfig config;
    protected final boolean optimizeSingleTargetEnabled;

    public AbstractAudioEngine(AudioEngineConfig config) {
        this.config = config;
        this.optimizeSingleTargetEnabled = config.isOptimizeSingleTargetEnabled();
    }

    protected AudioContextImpl getAudioContextImpl(AudioContext context) {
        if (context != null && context instanceof AudioContextImpl) {
            return (AudioContextImpl)context;
        }
        throw new IllegalArgumentException("Invalid AudioContext: " + context);
    }

    protected AudioContextImpl createAudioContextImpl(Studio studio) {
        SyncManagerStrategy strategy = this.createSyncManagerStrategy(studio);
        return new AudioContextImpl(studio, this, strategy);
    }

    protected SyncManagerStrategy createSyncManagerStrategy(Studio studio) {
        DefaultSyncManagerStrategy s = new DefaultSyncManagerStrategy(this.config);
        return s;
    }

    protected Wrapper[] prepareAudioSyncGroup(AudioSyncGroup engineGroup, AudioContextImpl context) throws AudioException {
        boolean resolved;
        Wrapper sourceWrapper;
        WrapperOutputPort sourcePort;
        WrapperInputPort inputPort;
        int k;
        int inputCount;
        SyncManagerProxy syncManagerProxy;
        AudioEngine wrapperEngine;
        Wrapper wrapper;
        int i;
        AudioEngine engine = engineGroup.getAudioEngine();
        if (engine != this) {
            throw new AudioException("Invalid AudioSyncGroup: group=" + engineGroup + ", engine=" + engine + " != " + this);
        }
        Wrapper engineWrapper = context.getGroupWrapper(engineGroup);
        if (engineWrapper.isPrepared()) {
            throw new AudioException("AudioSyncGroup is already prepared: " + engineGroup);
        }
        this.resolveWrapperRecursive(engineWrapper, context);
        Wrapper[] wrappers = context.getGroupWrappers();
        for (i = 0; i < wrappers.length; ++i) {
            wrapper = wrappers[i];
            if (wrapper.getAudioEngine() != this || wrapper == engineWrapper) continue;
            wrapper.setFrameRate(engineWrapper.getFrameRate());
            wrapper.setBufferSize(engineWrapper.getBufferSize());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("AudioSyncGroup(s): group=" + engineGroup + ", wrappers=" + wrappers.length);
            for (i = 0; i < wrappers.length; ++i) {
                wrapper = wrappers[i];
                logger.finer(" - AudioSyncGroup: group=" + wrapper.getGroup() + ", engine=" + wrapper.getAudioEngine() + ", frameRate=" + wrapper.getFrameRate() + ", bufferSize=" + wrapper.getBufferSize());
            }
        }
        for (i = 0; i < wrappers.length; ++i) {
            AudioSyncGroup wrapperGroup;
            AudioEngine wrapperGroupEngine;
            wrapper = wrappers[i];
            wrapperEngine = wrapper.getAudioEngine();
            if (wrapperEngine == null || (syncManagerProxy = wrapper.getSyncManagerProxy()) == null || (wrapperGroupEngine = (wrapperGroup = wrapper.getGroup()).getAudioEngine()) != null && wrapperGroupEngine != this || wrapper.isPrepared()) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Preparing SyncManagerProxy: " + syncManagerProxy.getWrapper());
            }
            inputCount = wrapper.getInputPortCount();
            for (k = 0; k < inputCount; ++k) {
                inputPort = wrapper.getInputPortAt(k);
                sourcePort = inputPort.getSourcePort();
                if (sourcePort == null) continue;
                sourceWrapper = sourcePort.getWrapper();
                SyncSourceProxy syncSourceProxy = new SyncSourceProxy(syncManagerProxy, sourcePort, inputPort);
                syncManagerProxy.addSyncSourceProxy(syncSourceProxy);
                sourceWrapper.addPostProcessor(syncSourceProxy);
                if (inputPort.getSampleBufferProxy() != null) continue;
                SyncBufferProxy inputBufferProxy = new SyncBufferProxy(inputPort, syncSourceProxy);
                inputPort.setSampleBufferProxy(inputBufferProxy);
            }
            if (wrapperGroupEngine != null) {
                SyncTargetProxy stw = new SyncTargetProxy(syncManagerProxy, wrapper);
                syncManagerProxy.addSyncTargetProxy(stw);
                wrapper.addPreProcessor(stw);
            }
            this.prepareOutputBufferProxies(wrapper);
            wrapper.setPrepared(true);
        }
        for (i = 0; i < wrappers.length; ++i) {
            wrapper = wrappers[i];
            if (wrapper.isPrepared() || (wrapperEngine = wrapper.getAudioEngine()) == null || wrapperEngine != this && !(wrapperEngine instanceof SyncAudioEngine)) continue;
            this.prepareInputBufferProxies(wrapper);
            this.prepareOutputBufferProxies(wrapper);
            wrapper.setPrepared(true);
        }
        engineWrapper.setPrepared(true);
        for (i = 0; i < wrappers.length; ++i) {
            AudioEngine groupEngine;
            AudioSyncGroup asg;
            wrapper = wrappers[i];
            if (wrapper.isPrepared() || (asg = wrapper.getGroup()) == engineGroup || (groupEngine = asg.getAudioEngine()) == this || groupEngine == null) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Preparing AudioSyncGroup: group=" + asg + ", engine=" + groupEngine);
            }
            groupEngine.prepare(asg, (AudioContext)context);
            if (!wrapper.isPrepared()) {
                throw new AudioException("Failed to prepare AudioSyncGroup: group=" + asg + ", engine=" + groupEngine);
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("AudioSyncGroup prepared: group=" + asg + ", engine=" + groupEngine);
        }
        do {
            resolved = false;
            for (int i2 = 0; i2 < wrappers.length; ++i2) {
                Wrapper wrapper2 = wrappers[i2];
                syncManagerProxy = wrapper2.getSyncManagerProxy();
                if (wrapper2.getFrameRate() > 0.0f && wrapper2.getBufferSize() > 0) continue;
                if (syncManagerProxy != null) {
                    syncManagerProxy.resolveFrameRateAndBufferSize();
                    if (!(wrapper2.getFrameRate() > 0.0f) || wrapper2.getBufferSize() <= 0) continue;
                    resolved = true;
                    continue;
                }
                float frameRate = -1.0f;
                int bufferSize = -1;
                inputCount = wrapper2.getInputPortCount();
                for (k = 0; k < inputCount; ++k) {
                    inputPort = wrapper2.getInputPortAt(k);
                    sourcePort = inputPort.getSourcePort();
                    if (sourcePort == null) continue;
                    sourceWrapper = sourcePort.getWrapper();
                    float sourceFrameRate = sourceWrapper.getFrameRate();
                    int sourceBufferSize = sourceWrapper.getBufferSize();
                    if (sourceFrameRate <= 0.0f || sourceBufferSize <= 0) continue;
                    if (frameRate <= 0.0f) {
                        frameRate = sourceFrameRate;
                        bufferSize = sourceBufferSize;
                        continue;
                    }
                    if (sourceFrameRate != frameRate) {
                        throw new AudioException("Invalid frame rate: " + sourceFrameRate + " != " + frameRate + ", group=" + wrapper2.getGroup());
                    }
                    if (sourceBufferSize == bufferSize) continue;
                    throw new AudioException("Invalid buffer size: " + sourceBufferSize + " != " + bufferSize + ", group=" + wrapper2.getGroup());
                }
                if (!(frameRate > 0.0f) || bufferSize <= 0) continue;
                wrapper2.setFrameRate(frameRate);
                wrapper2.setBufferSize(bufferSize);
                resolved = true;
            }
        } while (resolved);
        if (context.getOwnerEngine() == this) {
            context.dumpAudioContext();
        }
        return wrappers;
    }

    protected AudioProcessor[] createAudioProcessors(AudioContextImpl context) throws AudioException {
        Wrapper[] wrappers = context.getGroupWrappers();
        for (int i = 0; i < wrappers.length; ++i) {
            Wrapper wrapper = wrappers[i];
            AudioSyncGroup group = wrapper.getGroup();
            float frameRate = wrapper.getFrameRate();
            if (frameRate <= 0.0f) {
                throw new AudioException("Invalid frame rate: group=" + group + ", frameRate=" + frameRate);
            }
            int bufferSize = wrapper.getBufferSize();
            if (bufferSize > 0) continue;
            throw new AudioException("Invalid buffer size: group=" + group + ", bufferSize=" + bufferSize);
        }
        LinkedList<AudioProcessor> processorList = new LinkedList<AudioProcessor>();
        for (int i = 0; i < wrappers.length; ++i) {
            AudioProcessor[] aps;
            AudioSyncGroup group;
            AudioEngine groupEngine;
            Wrapper wrapper = wrappers[i];
            AudioEngine wrapperEngine = wrapper.getAudioEngine();
            if (wrapperEngine != this || (groupEngine = (group = wrapper.getGroup()).getAudioEngine()) != null || (aps = wrapper.createAudioProcessors()) == null) continue;
            for (int k = 0; k < aps.length; ++k) {
                AudioProcessor ap = aps[k];
                if (ap == null) continue;
                processorList.add(ap);
            }
        }
        return processorList.toArray(new AudioProcessor[processorList.size()]);
    }

    protected void startAudioEngines(AudioContextImpl context) throws AudioException {
        Wrapper[] wrappers = context.getGroupWrappers();
        for (int i = 0; i < wrappers.length; ++i) {
            AudioSyncGroup asg;
            AudioEngine groupEngine;
            Wrapper wrapper = wrappers[i];
            if (wrapper.isStarted() || (groupEngine = (asg = wrapper.getGroup()).getAudioEngine()) == this || groupEngine == null) continue;
            if (!wrapper.isPrepared()) {
                throw new AudioException("AudioSyncGroup is not prepared: " + asg);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Starting audio engine: " + groupEngine);
            }
            groupEngine.start();
            if (!wrapper.isStarted()) {
                throw new AudioException("Failed to start audio engine: group=" + asg + ", engine=" + groupEngine);
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("Audio engine started: " + groupEngine);
        }
    }

    private final void resolveWrapperRecursive(Wrapper wrapper, AudioContextImpl context) throws AudioException {
        AudioSyncGroup group = wrapper.getGroup();
        AudioEngine engine = wrapper.getAudioEngine();
        if (engine == null) {
            throw new AudioException("No audio engine available for group: " + group);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("resolveWrapperRecursive: wrapper=" + wrapper + ", engine=" + engine);
        }
        HashSet<AudioSyncGroup> doneGroups = new HashSet<AudioSyncGroup>();
        doneGroups.add(group);
        this.resolveResponsibleEngineRecursive(wrapper, context, engine, doneGroups);
    }

    private final void resolveResponsibleEngineRecursive(Wrapper wrapper, AudioContextImpl context, AudioEngine possibleEngine, Set doneGroups) throws AudioException {
        AudioSyncGroup group = wrapper.getGroup();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("resolveResponsibleEngineRecursive: group=" + group + ", engine=" + wrapper.getAudioEngine() + ", possibleEngine=" + possibleEngine);
        }
        int connectedInputs = 0;
        int inputCount = wrapper.getInputPortCount();
        for (int i = 0; i < inputCount; ++i) {
            WrapperInputPort inputPort = wrapper.getInputPortAt(i);
            WrapperOutputPort sourcePort = inputPort.getSourcePort();
            if (sourcePort == null) continue;
            ++connectedInputs;
            Wrapper sourceWrapper = sourcePort.getWrapper();
            AudioSyncGroup sourceGroup = sourceWrapper.getGroup();
            if (sourceGroup == group || !doneGroups.add(sourceGroup)) continue;
            this.resolveResponsibleEngineRecursive(sourceWrapper, context, possibleEngine, doneGroups);
        }
        AudioEngine engine = wrapper.getAudioEngine();
        if (engine == null) {
            engine = possibleEngine;
        }
        int outputCount = wrapper.getOutputPortCount();
        for (int i = 0; i < outputCount; ++i) {
            WrapperOutputPort outputPort = wrapper.getOutputPortAt(i);
            WrapperInputPort[] targetPorts = outputPort.getTargetPorts();
            for (int k = 0; k < targetPorts.length; ++k) {
                WrapperInputPort targetPort = targetPorts[k];
                Wrapper targetWrapper = targetPort.getWrapper();
                AudioSyncGroup targetGroup = targetWrapper.getGroup();
                AudioEngine targetEngine = targetWrapper.getAudioEngine();
                if (targetEngine == null) {
                    HashSet<AudioSyncGroup> groupSet = new HashSet<AudioSyncGroup>();
                    groupSet.add(targetGroup);
                    HashSet<AudioEngine> engineSet = new HashSet<AudioEngine>();
                    engineSet.add(engine);
                    this.getSourceAudioEngines(targetWrapper, groupSet, engineSet);
                    if (engineSet.size() < 2) {
                        targetWrapper.setAudioEngine(engine);
                        targetEngine = engine;
                    } else {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Synchronization required for multiple source engines: targetGroup=" + targetGroup + ", source engines: " + engineSet.size());
                        }
                        SyncAudioEngine syncEngine = new SyncAudioEngine(targetGroup.getName(), targetWrapper, this.config);
                        targetWrapper.setAudioEngine(syncEngine);
                        SyncManagerStrategy strategy = context.getSyncManagerStrategy();
                        SyncManagerProxy syncManagerProxy = new SyncManagerProxy(targetWrapper, syncEngine, context, strategy);
                        targetWrapper.setSyncManagerProxy(syncManagerProxy);
                        targetEngine = syncEngine;
                    }
                } else if (targetEngine != engine && targetEngine == this) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Synchronization required for different target engine: sourceGroup=" + group + ", targetGroup=" + targetGroup);
                    }
                    SyncManagerStrategy strategy = context.getSyncManagerStrategy();
                    SyncManagerProxy syncManagerProxy = new SyncManagerProxy(targetWrapper, targetEngine, context, strategy);
                    targetWrapper.setSyncManagerProxy(syncManagerProxy);
                }
                if (!doneGroups.add(targetGroup)) continue;
                this.resolveResponsibleEngineRecursive(targetWrapper, context, targetEngine, doneGroups);
            }
        }
        if (wrapper.getAudioEngine() == null && connectedInputs < 1) {
            wrapper.setAudioEngine(possibleEngine);
        }
    }

    private final void getSourceAudioEngines(Wrapper wrapper, Set doneGroups, Set doneEngines) {
        AudioSyncGroup group = wrapper.getGroup();
        int inputCount = wrapper.getInputPortCount();
        for (int i = 0; i < inputCount; ++i) {
            Wrapper sourceWrapper;
            AudioSyncGroup sourceGroup;
            WrapperInputPort inputPort = wrapper.getInputPortAt(i);
            WrapperOutputPort sourcePort = inputPort.getSourcePort();
            if (sourcePort == null || (sourceGroup = (sourceWrapper = sourcePort.getWrapper()).getGroup()) == null || sourceGroup == group) continue;
            AudioEngine sourceEngine = sourceWrapper.getAudioEngine();
            if (sourceEngine != null) {
                doneEngines.add(sourceEngine);
                continue;
            }
            if (!doneGroups.add(sourceGroup)) continue;
            this.getSourceAudioEngines(sourceWrapper, doneGroups, doneEngines);
        }
    }

    private void prepareInputBufferProxies(Wrapper wrapper) throws AudioException {
        AudioSyncGroup group = wrapper.getGroup();
        AudioEngine groupEngine = group.getAudioEngine();
        if (groupEngine == this) {
            return;
        }
        if (wrapper.isPrepared()) {
            throw new AudioException("AudioSyncGroup is already prepared: " + group);
        }
        int inputCount = wrapper.getInputPortCount();
        for (int i = 0; i < inputCount; ++i) {
            SampleBufferProxy inputBufferProxy;
            WrapperInputPort inputPort = wrapper.getInputPortAt(i);
            WrapperOutputPort sourcePort = inputPort.getSourcePort();
            if (sourcePort == null || (inputBufferProxy = inputPort.getSampleBufferProxy()) != null) continue;
            inputBufferProxy = new SourceBufferProxy(inputPort, sourcePort);
            inputPort.setSampleBufferProxy(inputBufferProxy);
        }
    }

    private void prepareOutputBufferProxies(Wrapper wrapper) throws AudioException {
        AudioSyncGroup group = wrapper.getGroup();
        AudioEngine groupEngine = group.getAudioEngine();
        if (groupEngine == this) {
            return;
        }
        int outputCount = wrapper.getOutputPortCount();
        for (int i = 0; i < outputCount; ++i) {
            SampleBufferProxy targetBufferProxy;
            WrapperInputPort targetPort;
            Wrapper targetWrapper;
            WrapperOutputPort outputPort = wrapper.getOutputPortAt(i);
            SampleBufferProxy outputBufferProxy = outputPort.getSampleBufferProxy();
            if (outputBufferProxy != null) continue;
            WrapperInputPort[] targetPorts = outputPort.getTargetPorts();
            if (this.optimizeSingleTargetEnabled && targetPorts.length == 1 && (targetWrapper = (targetPort = targetPorts[0]).getWrapper()).getSyncManagerProxy() == null && targetWrapper.getAudioEngine() == this && (targetBufferProxy = targetPort.getSampleBufferProxy()) != null) {
                outputBufferProxy = targetBufferProxy;
            }
            if (outputBufferProxy == null) {
                outputBufferProxy = new OutputBufferProxy(outputPort);
                for (int k = 0; k < targetPorts.length; ++k) {
                    WrapperInputPort targetPort2 = targetPorts[k];
                    Wrapper targetWrapper2 = targetPort2.getWrapper();
                    if (targetWrapper2.getSyncManagerProxy() != null || targetWrapper2.getAudioEngine() != this) continue;
                    targetPort2.setSampleBufferProxy(outputBufferProxy);
                }
            }
            outputPort.setSampleBufferProxy(outputBufferProxy);
        }
    }

    protected void restartAudioEngines(AudioContextImpl context) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("restartAudioEngines: delegated to " + this);
        }
        AbstractAudioEngine aae = null;
        AudioEngine ownerEngine = context.getOwnerEngine();
        aae = ownerEngine != this && ownerEngine != null && ownerEngine instanceof AbstractAudioEngine ? (AbstractAudioEngine)ownerEngine : this;
        aae.restartAudioEnginesAsync(context);
    }

    private final void restartAudioEnginesAsync(final AudioContextImpl context) {
        if (logger.isLoggable(Level.FINE)) {
            context.dumpAudioContext();
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("restartAudioEnginesAsync: context=" + context);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractAudioEngine.this.restartAudioEnginesInternal(context);
            }
        });
    }

    private final void restartAudioEnginesInternal(AudioContextImpl context) {
        try {
            final Studio studio = context.getStudio();
            logger.info("Stopping studio: " + studio);
            studio.stop();
            logger.info("Studio stopped: " + studio);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        logger.info("Restarting studio: " + studio);
                        studio.start();
                        logger.info("Studio restarted: " + studio);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

